//
//	INTEL CONFIDENTIAL
//	Copyright (c) 2004-2006 Intel Corporation All Rights Reserved. 
//	The software contained or described herein and all documents related to the software (Material) are owned by Intel
//	Corporation or its suppliers or licensors. Title to the Material remains with Intel Corporation or its suppliers and licensors. The
//	Material contains trade secrets and proprietary and confidential information of Intel or its suppliers and licensors. The Material is
//	protected by worldwide copyright and trade secret laws and treaty provisions. No part of the Material may be used, copied,
//	reproduced, modified, published, uploaded, posted, transmitted, distributed, or disclosed in any way without Intels prior express
//	written permission.
//
//	No license under any patent, copyright, trade secret or other intellectual property right is granted to or conferred upon you by
//	disclosure or delivery of the Materials, either expressly, by implication, inducement, estoppel or otherwise. Any license under such 
//	intellectual property rights must be express and approved by Intel in writing.
//
//	Unless otherwise agreed by Intel in writing, you may not remove or alter this notice or any other notice embedded in Materials by
//	Intel or Intels suppliers or licensors in any way.  
//
//	FILENAME: ccu.js
//

/*********************************************************************************
Function:	CreateSpacer
Purpose:	Creates a transparent spacer in the UI. 
Returns:	true if successful, or false if not.
Usage:		CreateSpacer(navParent, hSize, vSize, [borderEnable] )
			parent -> cannot be null, hSize & vSize will default to 1px if null
			borderEnable -> [OPT], pass true to enable borders
			NOTE:  Use of this function within a scrollable text widget is NOT
			supported and is prevented.  If used in a scrollalbe text area the
			spacer becomes selectable, cursor changes and the user can actually change
			the size of the spacer with mouse drag operation!
*********************************************************************************/
function CreateSpacer(navParent, hSize, vSize, borderEnable)
{
	var retval = true;
	try
	{
		hSize = (!hSize)? 1: hSize;								// Default size to something
		vSize = (!vSize)? 1: vSize;								//  if either are null
		borderEnable = (borderEnable) ? true : false;			// Default border to disabled if null
		
		if ( navParent )
		{	
			var spacerElem = document.createElement("div");			// Create an element 
	 		switch (navParent.elem.tagName)
	 		{
	 			case "TEXTAREA":
	 				throw( new Error());							// Skip if this is a textScroll widget
					spacerElem.style.marginTop= "0px";
					spacerElem.style.marginBottom= "0px";
					spacerElem.hideFocus = true;
					spacerElem.disabled = true;
	 				break;
	 			default:
					spacerElem.style.marginTop= "0px";
					spacerElem.style.marginBottom= "9px";
	 				break;
	 		}
	 		spacerElem.className="UISpacer";
			spacerElem.style.position="relative";
			spacerElem.style.zIndex="-99";
			spacerElem.style.overflow="hidden";
			spacerElem.style.backgroundColor="Transparent";
			spacerElem.style.cursor="default";
			spacerElem.style.width = hSize + "px";				// Set the requested size
			spacerElem.style.height = vSize + "px"; 
			if (borderEnable)
			{
				spacerElem.style.border = "solid white 1px";	// Change 0px to 1px to see the spacer
			}
			else
			{
				spacerElem.style.border = "solid white 0px";	// Change 0px to 1px to see the spacer			
			}
			navParent.elem.appendChild(spacerElem);				// Append this object to the body
		}
	}
	catch(e)													// Ignore any errors
	{
		retval = false;
	}													
	return retval;												
}


/*********************************************************************************
Function:	L10NDate
Purpose:	Takes a date object as a parameter and returns the a localized string
			of the date for display.  
Returns:	Localized date string
Usage:		L10Date(dateObj)
*********************************************************************************/
function L10NDate(dateObj)
{
	var dateStr;
	var Month = dateObj.getMonth() + 1;		// Zero based Month in JavaScript
	var Date =	dateObj.getDate();
	var Year =	dateObj.getYear();
	
	if (Month  < 10)							// Add leading zeros if needed
		Month = '0' + Month;
	if (Date < 10)
		Date = '0' + Date;
	
	switch (globalLang.toUpperCase())
	{ 
		case 'ARA':		// Arabic Saudi Arabia		YYYY/MM/DD 
		case 'ARB':		// Arabic Lebanon			YYYY/MM/DD
		case 'CHT':		// Chinese Traditional		YYYY/MM/DD
		case 'JPN':		// Japanese					YYYY/MM/DD
				{
					dateStr = Year + '/' + Month + '/' + Date; 
					break;
				}	
		case 'CSY':		// Czech					DD.MM.YYYY
		case 'DEU':		// German					DD.MM.YYYY
		case 'FIN':		// Finish					DD.MM.YYYY
		case 'NOR':		// Norway					DD.MM.YYYY
		case 'RUS':		// Russian					DD.MM.YYYY
		case 'TRK':		// Turkish					DD.MM.YYYY
				{
					dateStr = Date + '.' + Month + '.' + Year;
					break;
				}	
		case 'DAN':		// Danish					DD-MM-YYYY
		case 'NLD':		// Netherlands				DD-MM-YYYY
		case 'PTG':		// Portuguese				DD-MM-YYYY
				{
					dateStr = Date + '-' + Month + '-' + Year;
					break;
				}	
		case 'CHS':		// Chinese Simplified		YYYY-MM-DD
		case 'FRC':		// French Canadian			YYYY-MM-DD
		case 'KOR':		// Korean					YYYY-MM-DD
		case 'SVE':		// Swedish					YYYY-MM-DD
		case 'PLK':		// Polish					YYYY-MM-DD
				{
					dateStr = Year + '-' + Month + '-' + Date;
					break;
				}	
		case 'HUN':		// Hungary					YYYY.MM.DD		
				{
					dateStr = Year + '.' + Month + '.' + Date;
					break;
				}	
		case 'ELL':		// Greek					DD/MM/YYYY
		case 'ESN':		// Spanish					DD/MM/YYYY
		case 'ESP':		// Spanish					DD/MM/YYYY
		case 'FRA':		// French					DD/MM/YYYY
		case 'HEB':		// Hebrew					DD/MM/YYYY
		case 'ITA':		// Italian					DD/MM/YYYY
		case 'PTB':		// Portuguese				DD/MM/YYYY
		case 'THA':		// Thai						DD/MM/YYYY
				{
					dateStr = Date + '/' + Month + '/' + Year;
					break;
				}	
		case 'ENU':		// English (default)		MM/DD/YYYY
		default:
			{
				dateStr = Month + '/' + Date + '/' + Year;
				break;
			}	
	}
	
	return dateStr;
}

/*********************************************************************************
Function:	L10NNumber (*** PLACEHOLDER FOR FUTURE IMPLEMENTATION)
Purpose:	Takes a number value as a parameter and returns the localized string
			of the number for display.  
Returns:	Localized string representation of the number
Usage:		L10NNumber(num)
*********************************************************************************/
function L10NNumber(num)
{
	var numLocStr = num.toLocalString();
		
	switch (globalLang.toUpperCase())
	{ 
		case 'DEU':		// German					###.###.###,00
		case 'TRK':		// Turkish					###.###.###,00
		case 'DAN':		// Danish					###.###.###,00
		case 'NLD':		// Netherlands				###.###.###,00
		case 'PTG':		// Portuguese				###.###.###,00
		case 'ELL':		// Greek					###.###.###,00
		case 'ESN':		// Spanish					###.###.###,00
		case 'ESP':		// Spanish					###.###.###,00
		case 'ITA':		// Italian					###.###.###,00
		case 'PTB':		// Portuguese				###.###.###,00
			break;
		case 'CSY':		// Czech					### ### ###,00
		case 'FIN':		// Finish					### ### ###,00
		case 'NOR':		// Norway					### ### ###,00
		case 'RUS':		// Russian					### ### ###,00
		case 'FRC':		// French Canadian			### ### ###,00
		case 'SVE':		// Swedish					### ### ###,00
		case 'PLK':		// Polish					### ### ###,00
		case 'HUN':		// Hungary					### ### ###,00		
		case 'FRA':		// French					### ### ###,00
			break;
		case 'ARA':		// Arabic Saudi Arabia		###,###,###.00 
		case 'ARB':		// Arabic Lebanon			###,###,###.00
		case 'CHS':		// Chinese Simplified		###,###,###.00
		case 'CHT':		// Chinese Traditional		###,###,###.00
		case 'ENU':		// English (default)		###,###,###.00
		case 'HEB':		// Hebrew					###,###,###.00
		case 'JPN':		// Japanese					###,###,###.00
		case 'KOR':		// Korean					###,###,###.00
		case 'THA':		// Thai						###,###,###.00
		default:
			break;
	}
	
	return numLocStr;
}

/*********************************************************************************
Function:	ccuL10NCreatePath
Purpose:	Creates the standard path to the CCU localization lang files.  
Returns:	String containing the full relative path to the XML localization file
Usage:		ccuL10NCreatePath(lang, filename) - passed in are the language code
			and the CCU XML file name
*********************************************************************************/
function ccuL10NCreatePath(lang, filename)
{
	// Typical path construct: 'language/' + globalLang + '/ccu.xml'
	var path = null;
	
	// Set default file name if null
	if (filename == null)
		filename = 'ccu.xml';
	
	// Set default lang (ENU) if null	
	if (lang == null)
		lang = 'ENU'

	// Construct the relative path
	path = 'language/' + lang + '/' + filename;
	return path;
}

/*********************************************************************************
Function:	ccuL10NLoadStrings
Purpose:	Override for the template's L10LoadStrings() fn.  Forces loading of the English
			localization XML file if requested lang specific XML load fails.  Optionally allows
			the override of the default file name.  Default filename is 'ccu.xml'.
Returns:	XMLDoc object
Usage:		ccuL10LoadStrings(lang, [fileName]) where lang represents the 3 char language code.
			Example: 'ENU' or 'DEU'. The optional fileName represents the filename if the default 
			'ccu.xml' is to be replaced.
*********************************************************************************/
function ccuL10NLoadStrings(lang, fileName)
{
	var xmlObj = null;
		
	try									// Try and load the language file requested
	{
		var retval = L10NLoadStrings(ccuL10NCreatePath( lang, fileName ));
		
		if (retval.xml.length <= 0)		// If XML.length is > 0 then file should have loaded 
			throw new Error('Specified language XML file failed to load!');
		else
			xmlObj = retval;
	}
	catch(e)							
	{
		// Log where??
	}
			
	return xmlObj;
}


/*********************************************************************************
Function: ParseDateStr
Purpose:  Converts an encoded date to a JavaScript date object
Returns:  Date object (used for Message Center page)
Syntax:   ParseDateStr(date string)  ==> format = ('Y,M,D,H,M,S')
*********************************************************************************/
function ParseDateStr(dStr) // dateStr format = ('Y,M,D,H,M,S')
{  
	var dObj = null;
	
	try
	{
		dObj = eval('new Date(' + dStr + ')');
	}
	catch(e)
	{
		// Log where?? ('Exception:  Bad date string received \n' + e.description);
		dObj = new Date(0);
	}
	
	return dObj;
}

/*********************************************************************************
Function: SetSortOrderState
Purpose:  Attempts to set the sort order & direction into the XML data store
Returns:  Nothing
Syntax:   SetSortOrderState(type,dir)
		  TYPE is g_SORT_SEVERITY or g_SORT_DATE
		  DIR is 1 for a normal sort, and -1 for a reversed sort
*********************************************************************************/
function SetSortOrderState(type, dir)
{
	if (dir == null) 
		dir = g_SORTDIR;				// If not passed set default direction
	
	switch(type)
	{
		case g_SORT_SEVERITY:							// Set sort by severity
			break;
		default:									// Set default 
			{
				type = g_SORT_DATE;
				break;
			}	
	}
	
	try 
	{
		g_ObjUIMgr.SetNCSortOrder(type);
		g_ObjUIMgr.SetNCSortDirection(dir); 
	}
	catch(e)
	{
		// Log where??
	}
	
	return;
}

/*********************************************************************************
Function:	GetSortOrderState
Purpose:	Attempts to get the sort order & direction and populate an object with
			the data.  If data is not present in XML state file, defaults are written.
Returns:	sortType object containing the requested sort information
Usage:		SetSortOrderState(type,dir)
			TYPE is g_SORT_SEVERITY or g_SORT_DATE
			DIR is 1 for a normal sort, and -1 for a reversed sort
*********************************************************************************/
function GetSortOrderState()
{
	var type = null;
	var dir = null;
	var sortType = {type: null, dir: null, fn: null	};	// Need sortType obj to return

	// Attempt to read the sort order type
	try							
	{	
		type = g_ObjUIMgr.GetNCSortOrder();		// Try and read from xml data
		//type = parseInt(type,10);						// Convert str to decimal
	} 
	catch(e)											// If failure, set defaults and update state XML file
	{
		type = g_SORT_DATE;								// Set the default
		SetSortOrderState('mcSortOrder',type);			// Update the XML file
	}
	
	// Attempt to read the sort order direction
	try			
	{	
		dir = g_ObjUIMgr.GetNCSortDirection();			// Try and read from xml data
		//dir  = parseInt(dir,10);						// Convert str to decimal
	} 
	catch(e)											// If failure, set default and update state XML file
	{	
		dir = g_SORT_DIR;								// Set the default
		SetSortOrderState('mcSortDir',dir);				// Update the XML file
	}

	switch(type)
	{
		case g_SORT_SEVERITY:
			{
				sortType.type = type;
				sortType.dir = dir ? dir : g_SORTDIR;		// Make sure dir is NOT null
				sortType.fn = SortBySeverity;
				break;
			}	
		case g_SORT_DATE:
		default:											// Default same as sort by date
			{
				sortType.type = type;
				sortType.dir = dir ? dir : g_SORTDIR;		// Make sure dir is NOT null
				sortType.fn = SortByDate;
				break;
			}		
	}
	
	return sortType;
}

/*********************************************************************************
Function:	GetFileName
Purpose:	Retrieves XML filename & path from CCU COM object
Returns:	String containing full path to XML file.  
Syntax:		GetFileName(PAGE_ID) 
			Valid input Parameter values: 0 = OOBE, 1 = CCU, 2 = Media Center
*********************************************************************************/
function GetFileName(ccuPageID) 
{ 
	var file_path = null;
	
	if (ccuPageID != null)
	{
		if ((ccuPageID < g_OOBE) || (ccuPageID > g_MESSAGE_CENTER))
		{
			// Log where?? ("GetFileName - [" + ccuPage + "bad parameter passed!");
		}
		else
		{
			try
			{
				file_path = g_ObjUIMgr.GetNavFilePath(ccuPageID);
			}
		    catch (e)
			{
				// Log where?? ("ERR: GetNavFilePath - " + e.message);
			}
		}
	}		
	
    return file_path;
}

/*********************************************************************************
Function: IsOOBEComplete
Purpose:  Determines if Out Of Box Experience is complete by calling CCU UI COM object
Returns:  true if complete, false if not
Syntax:   IsOOBEComplete()
*********************************************************************************/
function IsOOBEComplete() 
{
	var status = false;
	
	try
	{
		status = g_ObjUIMgr.IsOOBEComplete();
	}
	catch(e)
	{
		// Log where??
	}	
	
	return status;		
} 

/*********************************************************************************
Function: GetPendingAlertSev()
Purpose:  Returns highest severity among pending alerts
Returns:  Highest severity (g_ERR, g_WARNING, g_INFORMATION)
Syntax:   GetPendingAlertSev()
*********************************************************************************/
function GetPendingAlertSev() 
{
	var sev = -1;
	
	try
	{
		sev = g_ObjUIMgr.GetPendingAlertStatus();
	}
	catch(e)
	{
		// Log where?
	}
	
	return sev;	
} 

/*********************************************************************************
Function:	GetEastforkComponentVersion
Purpose:	Gets the current version of east fork component
Returns:	Current version
Syntax:		GetEastforkVersion(regKey) -- where regKey refers to the registry key
			location for the component
*********************************************************************************/
function GetEastForkComponentVersion(regKey)
{
	var versionStr = null;
	
	try
    {
		versionStr = g_ObjUIMgr.GetEastforkVersion(regKey);
    }
    catch (e)
    {
		// Log where??
    }
 
	return versionStr;
} 
/*********************************************************************************
Function:	GetEFRegistryString
Purpose:	Gets the registry key
Returns:	Current registry entry
Syntax:		GetEFRegistryString(regKeyPath, regKeyName) 
			-- where regKeyPath refers to the registry key location
			-- where regKeyName refers to the registry key name
*********************************************************************************/
function GetEFRegistryString(regKeyPath, regKeyName)
{
	var versionStr = null;
	
	try
    {
		versionStr = g_ObjUIMgr.GetRegistryString(regKeyPath, regKeyName);
    }
    catch (e)
    {
		// Log where??
    }
 
	return versionStr;
} 

/*********************************************************************************
Function: GetCatArray
Purpose:  Retrieve the array of valid categories for main menu
Returns:  Array of category IDs
Syntax:   GetCatArray()
*********************************************************************************/
function GetCatArray()
{
	// Initialize the category IDs
	var catArray = new Array("network", "explore", "devices", "systems", "media"); 
	return catArray;
} 

/*********************************************************************************
Function:	GetCatIndex
Purpose:	Retrieves index of the given category ID for main menu
Returns:	Index
Syntax:		GetCatIndex(cat) -- passed in is the category ID to search for.
*********************************************************************************/
function GetCatIndex(cat)
{	
	var index = -1;
	
	if (cat)
	{
		// Get the category ID array
		var catIDArr = GetCatArray();
		for (var i = 0; i < catIDArr.length; i++)
		{
			if (catIDArr[i] == cat)
			{
				index = i + 1;
			}
		}
	}	
	
	return index;
}

/*********************************************************************************
Function: GetOptCatArray
Purpose:  Retrieve the array of valid categories for the options menu
Returns:  Array of category IDs
Syntax:   GetOptCatArray()
*********************************************************************************/
function GetOptCatArray()
{
	// Initialize the category IDs
	var catArray = new Array("updateOpt", "notificationOpt", "mediaOpt", "trayOpt", "contentOpt", "supportOpt", "aboutOpt");
	return catArray;
} 

/*********************************************************************************
Function:	GetOptCatIndex
Purpose:	Retrieves index of the given category ID for the options menu
Returns:	Index
Syntax:		GetOptCatIndex(cat) -- passed in is the category ID to search for.
*********************************************************************************/
function GetOptCatIndex(cat)
{	
	var index = -1;
	
	if (cat)
	{
		// Get the category ID array
		var catIDArr = GetOptCatArray();
		for (var i = 0; i < catIDArr.length; i++)
		{
			if (catIDArr[i] == cat)
			{
				index = i + 1;
			}
		}
	}	
	
	return index;
}

/*********************************************************************************
Function:	SavePageAttrib
Purpose:	Save the given page attributes
Returns:	Nothing
Syntax:		SavePageAttrib(pageid, attrib, value) - passed in are page ID, page
			attribute and the corresponding value.
*********************************************************************************/
function SavePageAttrib(pageid, attrib, value)
{
	try
	{
		if ((pageid != null) && (attrib != null) && (value != null))
		{
			g_ObjUIMgr.SetData('parentID', pageid);
			g_ObjUIMgr.SetData(attrib, value);
		}
	}
	catch(e)
	{
		// Log where??
	}	
	
	return;
} 

/*********************************************************************************
Function:	GetPageAttrib
Purpose:	Get the requested page attributes (given the pageid)
Returns:	page attribute value
Syntax:		GetPageAttrib(pageid, attrib)
*********************************************************************************/
function GetPageAttrib(pageid, attrib)
{
	var attribVal = null;
	
	if (pageid && attrib)
	{
		try
		{
			var parentID = g_ObjUIMgr.GetData('parentID');
			if ((parentID != null) && (parentID == pageid))
				attribVal = g_ObjUIMgr.GetData(attrib);
		}
		catch(e)
		{
			// Log where??
		}
	}			
	
	return attribVal;
} 
/*********************************************************************************
Function:	IsLimitedUser
Purpose:	Returns true if the User logged in LImited User
Returns:	
Syntax:		IsLimitedUser()
*********************************************************************************/
function IsLimitedUser()
{
	var limitedUsr;
	try
	{
		limitedUsr = g_ObjUIMgr.IsLimitedUser();
	}
	catch(e)
	{
		// Log where??
	}
	return limitedUsr;
}


/*********************************************************************************
Function:	IsMCEActiveShell
Purpose:	Returns true if the MCE is the active shell
Returns:	
Syntax:		IsMCEActiveShell()
*********************************************************************************/
function IsMCEActiveShell()
{
	var active;
	try
	{
		active = g_ObjUIMgr.IsMCEActiveShell();
	}
	catch(e)
	{
		// Log where??
	}
	return active;
}


/*********************************************************************************
Function:	SetPopUp
Purpose:	Sets the status if an alert pops up
Returns:	Nothing
Syntax:		SetPopUp(staVal)
*********************************************************************************/

function SetPopUp(staVal)
{
	try
	{
		g_ObjUIMgr.SetData("IsPopUp",staVal);
	}
	catch(e)
	{
		// Log where?
	}	

}

function GetPopuP()
{
     var retVal;
     
     try
     {
          retVal = g_ObjUIMgr.GetData("IsPopUp");
          retVal = parseInt(retVal,10);
         // alert("GetPopuP " + retVal);
     }   
      catch(e)
      {
		retVal = 0;
      }	
	
	return retVal;
}

function PageGetHashArgs(search)
{
	var Args = new Object();

	if (!search)
		search = location.hash;
	if (search.substr)
	{
		var input = unescape(search.substr(1));
		if (input)
		{
			var srchArray = input.split("&");
			var tempArray = new Array();
			for (var i = 0; i < srchArray.length; i++)
			{
				tempArray = srchArray[i].split("=");
				Args[tempArray[0]] = tempArray[1];
				
			}
			
		}
	}

	return Args;
}
function GetArgVal(argName)
{

	
	var args= PageGetHashArgs();
	if (argName && args)
	{
		if (args[argName])
		{
			myArg = args[argName];
		}
		else
		{
			args = PageGetHashArgs(); //works in framework
			myArg = args[argName];
		}
	}	
	return myArg;
}
/*********************************************************************************
Function:	PopulateHelpBulletedList
Purpose:	Creates the bulleted list based on the number of items present in
the sHelp.
Returns:	Nothing
Syntax:		PopulateHelpBulletedList(sHelp)
*********************************************************************************/
function PopulateHelpBulletedList(sHelp)
{

// List the help text as ordered or unordered list
				if (sHelp.contentB == '')
				{
					txt = CreateText(view, 'p', sHelp.contentA);					// First mouse over help item
					bulletedList = false;					
				}
				else
				{
					// Ordered bulleted list if there are multiple help items
					widget = CreateText(view, 'ul', " ");	
					txt = CreateText(widget, 'li', sHelp.contentA);					// Mouse over help			
					bulletedList = true;
				}
				
				if ((sHelp.contentC == '') && (bulletedList == false))
				{
					txt = CreateText(view, 'p', sHelp.contentB);					// First mouse over help item
				}
				else
				{
					// Append to the ordered bulleted list if there are multiple help items
					if (sHelp.contentB == '')
					{
						txt = CreateText(view, 'p', sHelp.contentB);					// First mouse over help item		
						bulletedList = false;
					}
					else
					{
						if (widget == null)
							widget = CreateText(view, 'ul', " ");					// Mouse over help	
						txt = CreateText(widget, 'li', sHelp.contentB);					// Mouse over help			
						bulletedList = true;
					}
				}
				
				if ((sHelp.contentD == '') && (bulletedList == false))
				{
					txt = CreateText(view, 'p', sHelp.contentC);					// First mouse over help item
				}
				else
				{
					// Append to the ordered bulleted list if there are multiple help items
					if (sHelp.contentC == '')
					{
						txt = CreateText(view, 'p', sHelp.contentC);					// First mouse over help item		
						bulletedList = false;
					}
					else
					{					
						if (widget == null)
							widget = CreateText(view, 'ul', " ");					// Mouse over help	
						txt = CreateText(widget, 'li', sHelp.contentC);					// Mouse over help			
						bulletedList = true;
					}
				}
				
			

}


/***********************************************************************
Function:	SetScreensaver
Purpose:	Sets the Screensaver status 
Parameters:	Turn on and off screensaver (0 turn off, 1 turn on)
Returns: 	none
Syntax:		SetScreensaver(status)
***********************************************************************/
function SetScreensaver(status)
{

	try 
	{
		g_ObjUIMgr.SetScreensaver(status);

	}
	catch (e)
	{
		// log?
	}
	
}


/***********************************************************************
Function:	GetScreensaverStatus
Purpose:	Gets the Screensaver status 
Parameters:	none
Returns: 	g_SCRNSVR
Syntax:		SetScreensaver(status)
***********************************************************************/
function GetScreensaverStatus()
{
	try 
	{
		var g_SCRNSVR = g_ObjUIMgr.GetScreensaverStatus();
	}
	catch (e)
	{
		// log?
	}

	return g_SCRNSVR;
	
}