/*
	INTEL CONFIDENTIAL
	Copyright (c) 2004-2006 Intel Corporation. All Rights Reserved. 
	The software contained or described herein and all documents related to the software (Material) are owned by Intel
	Corporation or its suppliers or licensors. Title to the Material remains with Intel Corporation or its suppliers and licensors. The
	Material contains trade secrets and proprietary and confidential information of Intel or its suppliers and licensors. The Material is
	protected by worldwide copyright and trade secret laws and treaty provisions. No part of the Material may be used, copied,
	reproduced, modified, published, uploaded, posted, transmitted, distributed, or disclosed in any way without Intels prior express
	written permission.

	No license under any patent, copyright, trade secret or other intellectual property right is granted to or conferred upon you by
	disclosure or delivery of the Materials, either expressly, by implication, inducement, estoppel or otherwise. Any license under such 
	intellectual property rights must be express and approved by Intel in writing.

	Unless otherwise agreed by Intel in writing, you may not remove or alter this notice or any other notice embedded in Materials by
	Intel or Intels suppliers or licensors in any way.  
*/

//  File:				xml.js
//	Purpose:			Provides readonly data access to XML file data
//  API Convention:		Functions that begin with a capitol letter are EXTERNAL API functions
//						Functions that begin with a lower case letter are INTERNAL functions
//						and serve as internal 'helper' functions.
//
//  The following line may need to be included in an HTML file before these functions will work.
//  Either un-comment it here, or add this line to the script section in the calling HTML file.
//  If the g_ObjMSXML object is NOT defined, the code will attempt to locate a built-in XML object.
//
//	var g_ObjMSXML = new ActiveXObject("msxml2.DOMDocument.4.0");
//
//	v1.622	Post inpection review changes
//	v1.621	Inpection review changes
//	v1.620	Final defect log rescub.  Verify everything to be fixed is.
//	v1.619	Bug fixed when filter returns 0 nodes, Iterator fns still return data from 1st node.
//	v1.618	Changed filter variable names to more descriptive ones.  Fixed errorhandler routines.
//	v1.617	Added xFilter to getNodes() function.
//	v1.616	Added xFilter to getNodes() function.
//	v1.615	Added external errorHandler capability to rXML class.
//	v1.614	Fixed filter bug when filter/sort enabled
//	v1.613	GetLocNodes integrated into GetNodes function
//	v1.612	Post code inspection changes & updates
//	v1.611	Pre code inspection changes & updates
//	v1.610	No major changes.  Sort bug was caused by COM component.
//	v1.609	Debug version - attempt to fix sort crash issue.
//	v1.608	Code clean up, testing and refactored sort routines.
//	v1.607	Sort routine functional.
//	v1.606	Initial sort routine activated.  Only does reverse read order.
//	v1.605	Fixed default XML object in constructor.  Added initial sort vars.
//	v1.604	Added parent_ID to retval in getNodes().
//	v1.603	Added try catch to prevent error msg popups.
//	v1.602	Fixed ternary retval.filter in getNodes().
//	v1.601	Initial release	

// Global page file variable definitions.  Global Page variables & functions are NOT part of any class or object.
var gp_FATAL_ERROR			= 99;			// Fatal Error that CANNOT continue.  Execution stops.
var gp_NO_NODES_ERROR		= 2;			// Non-Fatal error. No nodes found.  Persistant but recoverable error.
var gp_LOG_ERROR			= 1;			// Non-Fatal error that is only logged.  Resets to gp_NO_ERR.
var gp_NO_ERROR				= 0;			// No error.  Execution is OK.

var gp_rXMLVersion			= '1.622';		// GLOBAL PAGE variable rXML (ReadXML) version number.
var gp_rXMLStatus			= gp_NO_ERROR;	// GLOBAL PAGE status variable for rXML class. 
var gp_rXMLDebugEnable		= false;		// GLOBAL PAGE variable rXML debug enable.
var gp_rXMLMinStatusAlert	= gp_LOG_ERROR;	// GLOBAL PAGE variable.  A status equal to or greater than
											// will cause a debug popup message in errorhandler().

var gpf_rXMLErrorLogger = null;				// GLOBAL PAGE FUNCTION pointer an external error logger routine.

/*-------------------------------------------------------------------------------------------------------------
 rXML Class EXTERNAL API (functions used in the calling HTML file)

 rXML.METHOD()						Helper fn called		Description
 --------------------------------------------------------------------------------------------------------------
 rXML(xmlfile,[XMLObj],[debug])		rXML() - constructor	Loads the XML using optional user provided XML ActiveX object
															passing an optional 3rd 'true' param activates debugging.
 GetNodes(tag,[loadFilt],[xFilt])	getNodes()				Returns a NODES obj from 1st or Nth level XML node.
 GetStatus()						rXML.status (member)	Returns gp_NO_ERROR,gp_LOG_ERROR, gp_NO_NODES_ERROR or gp_FATAL_ERROR.
 SetDebug(bool)						gpf_SetDebug()			Pass a TRUE to enable debug functions
 GetDebug()							gpf_GetDebug()			Returns TRUE if debug is enabled, FALSE if not
 SetErrorLogger(func)				inline fn define		Pass an Error Logging function pointer to enable
															error logging.  The default is no logging.  The JavaScript
															fn pointer passed must accept 1 parameter of type
															'rXMLErrorObj' which is a modified version of a JavaScript
															'Error'.
 --------------------------------------------------------------------------------------------------------------
 NODES Object EXTERNAL API functions (Note this obj is returned by the rXML.GetNodes() function.

 nodes.METHOD()						Helper fn called		Description
 --------------------------------------------------------------------------------------------------------------
 GetTagByIndex(index,tag)			getTagValue()			INDEX func for accessing nodes by index
 GetTag(tag)						getTagValue(}			ITERATOR func returns the value of the named tag
 GetAttributeByIndex(index,attrib)	getAttribValue()		INDEX func for getting the nodes attrib by index
 GetAttribute(attrib)				getAttribValue()		ITERATOR func gets node attribute by name
 FindAttribute(tag,attrib)			findAttribute()			ITERATOR func searches all level 1 nodes for attribute
 NextNode()							nextprevNode()			ITERATOR func increments Iterator index to next available node
 PrevNode()							nextprevNode()			ITERATOR func decrements Iterator index to previous available node
 FirstNode()						firstlastNode()			ITERATOR func sets Iterator index to first available node
 LastNode()							firstlastNode()			ITERATOR func sets Iterator index to last available node
 SetFilter(filterFn)				setFilter()				Sets or removes an iterator runtime runFilter
 SetSortFn(sortFn,Dir)				setSortFn()				Sets sort function and invert flag
 SetSortDir(Dir)					setSortDir()			Sets the sort direction & returns value
 GetVersion()						rXML.version member		Retrieves this app's version string
 LogError(rXMLErrorObj)				errorHandler()			External API to log errors from client HTML pages
 GetStatus()						nodes.status member		Inherits original rXML status, then reverts to its own copy

 Alert(message)						debugAlert(message)		Displays XML node for debugging

 --------------------------------------------------------------------------------------------------------------
 Internal helper functions (no external API intended or supported)

 Internal Function Name				Description
 --------------------------------------------------------------------------------------------------------------
 initNodes(obj,tag,runFilt,xFilt)	Initializes node object with members & methods.  Called from getNodes() fn.
 arClear(aObj)						Clears a JavaScript array
 arCopy(src,dest)					Copies a JavaScript array to another array
 setSortDir(obj,[dir])				Sets the sort direction (0=sort off, 1=normal, -1=reverse)
 setSortFn(obj,fn,[dir])			Sets the sort function for the JavaScript sort fn
 createFilter(filter,prefix)		Replaces '#' symbol in filter string.  Used by JavaScript runFilter
									and XPath filtering.
 getTagValue(obj,index,tag)			Returns XML tag value from nodes object by index
 getAttribValue(obj,index,attrib)	Returns XML Attribute value from nodes object by index
 firstlastNode(obj,dir)				Moves iterator index value to first or last node
 nextprevNode(obj,dir)				Increments or decrements iterator index value
 findAttribute(obj,tag,attrib)		Searches for a node with a particular attribute value
 getChildNodeData(node,runFilter)		Adds 1 level of child data to nodes retval
 getNodeAttributeTags(node)			Adds an array of Attribute Tag names to nodes retval
 getNodeAttribute(node)				Adds attributes from sibling nodes to retval
 getChildNodeTagNames(node)			Adds child tag names array to nodes retval
 getXMLParentNode(xmlObj,xFilter)	Gets a 1st or Nth level XML parent node for the 'initNodes() function
  
 rXMLErrorObj([errObj],[err],[msg])	Creates & returns a modified JavaScript Error object (e_rXML)
 errorHandler(e_rXML)				Default rXML errorhandler that takes a rXMLErrorObj as a parameter
 debugAlert(obj,[msg])				Debug fn that displays the current rXML node info

 --------------------------------------------------------------------------------------------------------------
 GLOBAL PAGE FUNCTIONS				These functions are used to access GLOBAL PAGE variables which in turn
									control or change the function of the rXML class
--------------------------------------------------------------------------------------------------------------
 gpf_GetVersion()					Returns 'gp_rXMLVersion' var containing the rXML version
 gpf_CheckAndThrow()				Throws an exception if 'gp_rXMLStatus var equals gp_FATAL_ERROR
 gpf_GetDebug()						Gets the 'gp_rXMLDebugEnable' var.  TRUE = enabled
 gpf_SetDebug(newDebug)				Gets the 'gp_rXMLDebugEnable' var.  TRUE = enabled
 gpf_getXMLObj(objPtr,userXMLObj)	Attempts to return an XML COM object for XML file access
 gpf_SetErrorLogger(func)			Sets a new error handler by changing the gpf_SetErrHandler fn pointer.
 gpf_ValidateFilter(filter)			Throws and exception if filter string has '#' and is NOT followed by a '.' character.
--------------------------------------------------------------------------------------------------------------*/		

/*********************************************************************************
Function:	rXML(XML_FILE_NAME,[userXMLObj],[enableDebug]) 
Purpose:	This is the parent JavaScript class of the NODES object.  In order to
			obtain a NODES object, this class must be successfully instantiated.
			
			Constructor for XML file data access object.  This is the first call
			to make to access an XML data file.  User can pass in a new MSXML obj
			if desired otherwise the default CCU global object is used.
Returns:	Nothing

Usage:		var val = new rXML("mc.xml");					// Uses template XML obj
			var val = new rXML("mc.xml", userXMLObject);	// [Optional] User XML obj
			var val = new rXML("mc.xml", null, true);		// [Optional] Debug enabled
			See the gpf_getXMLObj() helper function for MSXML syntax & usage.					
*********************************************************************************/
function rXML(filename, userXMLObj, enableDebug)
{
	this.xmlObj=new Object();				// Add xmlObj parameter to class

	// *****************************************************************************
	// External API functions for rXML class - Parent Class METHOD Definitions
	// *****************************************************************************
	rXML.prototype.GetNodes =		function(tag,loadFilter,xFilter){return getNodes(this,tag,loadFilter,xFilter);};
	rXML.prototype.GetStatus =		function()						{return this.status};
	
	rXML.prototype.SetErrorLogger =	function(func)					{return gpf_SetErrorLogger(func);};
	rXML.prototype.GetDebug =		function()						{return gpf_GetDebug();};
	rXML.prototype.SetDebug =		function(bvalue)				{return gpf_SetDebug(bvalue)};
	
	rXML.prototype.ErrorHandler =   function(e_rXML)				{return errorHandler(this,e_rXML);};

	//	Variables:	'tag'			-	STRING, [REQUIRED] Index value into the data array
	//				'loadFilter'	-	STRING, [OPTIONAL] JavaScript comparison function used only at load time
	//				'xFilter'		-	STRING, [OPTIONAL] XPath filter string used only at load time 
	//              'func'			-	STRINT, [REQUIRED] JavaScript function pointer
	//				'bvalue'		-   BOOL,   [REQUIRED] true sets, false clears
	//
	//	Error Levels: (Used in rXML class & nodes objects)
	//				gp_FATAL_ERROR		= (99)	Fatal Error that CANNOT continue.  Execution stops.
	//				gp_NO_NODES_ERROR	= (2)	Recoverable error.  Indicates that 0 nodes were found or loaded.
	//				gp_LOG_ERROR		= (1)	Recoverable error that is logged and can continue.  Reverts to gp_NO_ERR.
	//				gp_NO_ERROR			= (0)	No error.  Execution is OK.

	// *****************************************************************************
	// Internal class members for rXML class
	// *****************************************************************************
	this.version = gpf_GetVersion();		// Retrieve rXML app version from global file var
	this.filename = filename;				// Store XML file to load
	this.status = gp_NO_ERROR;				// rXML status member
	
	if (enableDebug==true)
	{
		this.SetDebug(true);
	}

	// Check XML Object and log errors
	if( gpf_getXMLObj(this)==false )
	{
		this.ErrorHandler(rXMLErrorObj(null,gp_FATAL_ERROR, "rXML() failed to retrieve MS-XML COM object."));
	}
	else
	{
		this.xmlObj.load(this.filename);	// Load the file passed in
				
		if (this.xmlObj.parseError != 0)	// Check filename parameter & log error	
		{
			this.ErrorHandler(rXMLErrorObj(null,gp_FATAL_ERROR, "rXML() failed to load XML file.  Check file name."));
		}
	}	
	
	if ( this.status != gp_NO_ERROR ) 
	{										// Fatal error, construction failed.
		this.ErrorHandler( rXMLErrorObj(null,gp_FATAL_ERROR, "rXML() construction failed.") );
	}
	
	return;
}

/*********************************************************************************
Function:	rXMLErrorObj([errObjPrt], [errorlevel], [msg])
			errObjPtr:	Original 'errObjPtr' parameter passed to the catch() function
			errorlevel: Internal rXML errorlevel ie: gp_FATAL_ERROR etc.
			msg:		Internal rXML message string.
Purpose:	Initialize an Error object with default values & parameters.  Typically 
			called from a Catch() block since an Error object is provided by the 
			try/catch block anyway.
Returns:	An Error object populated with the passed in custom data.  See the NOTE
			below.

Usage:		All parameters are optional.  If the errObjPtr is NOT passed, a new one
			is created and returned populated.  Also if an errorlevel is NOT passed,
			or is out of range, the default value assigned is gp_FATAL_ERROR.  
			Note: The errObjPtr is passed as a pointer, so a return of the object is
			NOT needed.  However without the returned error object, command stacking
			would not work.  In this example the 'throw' would throw a null!
				throw( rXMLErrorObj(e, gp_LOG_ERROR, "message") );	<= Would not work!	
*********************************************************************************/
function rXMLErrorObj(errObjPtr,errlevel, msg)
{
	// Validate error object parameter.  If not supplied, create a new one
	if (errObjPtr==null)		
	{ 
		errObjPtr = new Error();
	}
	
	// Validate errlevel parameter and set default if needed
	if ((errlevel==null) || (errlevel < gp_NO_ERROR) || (errlevel > gp_FATAL_ERROR))
	{	
		errlevel = gp_FATAL_ERROR; 			// Set default errlevel if needed
	}
	
	// Validate msg parameter and set default if needed
	if (msg==null)
	{
		msg = 'Not Specified'; 					// Set default desc text
	}
	
	// Assign rXML errorlevel to Error object .number param		
	if (errlevel > errObjPtr.number)			// Save the highest errorlevel
	{
		errObjPtr.number = errlevel;
	}
	
	// Assign rXML internal msg to Error object .description param	
	if (errObjPtr.description == errObjPtr.message)		// In JavaScript Error() objects have
	{													// identical text in the .message & .description
		errObjPtr.description = msg + ' (' +			// fields.  If true, overwrite .description
								errlevel + ')' + '\n';	// with new msg text
	}
	else												// Save the previous text data by appending the new
	{													// msg text to the end of the previous text.
		errObjPtr.description += msg + ' (' + errlevel + ')' + '\n';				
	}													// This allows tracing the exception path.
		
	// Add additional custom parameters here if needed...

	return errObjPtr;
}

/*********************************************************************************
Function:	getNodes(object, tag, [loadFilter], [xFilter]) 
Purpose:	Parses XML data file and populates data structure.  Typically the first
			call after opening an XML file using the rXML constructor.
Returns:	The NODES data structure object containing the entire XML file as a
			JavaScript object as filtered by the JavaScript & XPath filter strings.
			
			When used without an xFilter, the XML document root is the first node 
			searched for the 'tag' parameter.  The xFilter allows the document root
			to be changed to a sub node before the tag search happens.
			
			BEFORE CALLING ANY NODES METHODS:
			---------------------------------
			Check the status with the nodes.GetStatus() method.  As long as the return 
			is not equal to gp_FATAL_ERROR the nodes object will be valid.  The reason 
			we are not returning a NULL on a fatal error, is because the object status 
			and the reason for the error will be inaccessable via nodes methods if the 
			nodes object returned is null.
			
Usage:		rXML.GetNodes(tag)	- pass a parent node value to locate and process. 
			rXML.GetNodes(tag,loadFilter) - JavaScript filter value is optional.  Locates
			  the parent based on the 'tag'.  Then the child nodes are determined if they
			  test 'true' to the JavaScript 'filter' function passed.
			rXML.GetNodes(tag,loadFilter,xFilter) - The xFilter is optional and allows 
			  passing a XPath string to determine the parent node to load.  After
			  the xFilter is applied then the parent node is located using the 'tag'
			  parameter.  The JavaScript filter is then applied to the remaining children
			  to further filter the returned child nodes.
			  
			  The 'tag' is the XML data value of the nodes you wish to access.  Data 
			  access is limited to the 1st level child nodes of the 'tag' value, 
			  and the attributes of the 'tag' nodes.

			Filter example:  (examples assume parent node is named 'MAIN_ITEM')
				FIRST LEVEL PARENT EXAMPLES:
				----------------------------
				rXML.GetNodes('MAIN_ITEM', "#.SEVERITY=='error'")
					- Gets parent nodes called MAIN_ITEM & have child SEVERITY tags
					  that have the value 'error'.
				rXML.GetNodes('MAIN_ITEM', "#.ATTRIBUTE.ID != '1'")
					- Gets parent nodes called MAIN_ITEM & has a MAIN_ITEM attribute named
					  ID not equal to '1'.
				rXML.GetNodes('MAIN_ITEM')
					- Gets parent nodes called MAIN_ITEM.
			
				nth LEVEL PARENT EXAMPLE (using an xFilter):
				--------------------------------------------
				rXML.GetNodes('MAIN_ITEM', "#.DATA > '1'", XPathString)
					- Change the document root searched with an xFilter string
					- Then use the JavaScript filter to choose a parent from the returned xFilter
					- Returns a nodes object with the parent 'MAIN_ITEM' which is a child of the
					  returned xFilter document root.
				The XPath string cannot be displayed properly inside a JavaScript comment tag
				because of the characters used.  The syntax is shown below using ABREVIATIONS!
				
				NOTE:  '\' = the '/' character (replace the '\' with the '/' char shown below!
				-----------------------------------------------------------------------
				CCU xFilter:	"\\*\LANG[@LID='" + globalLang + "']";	
								"\\*\*[@LID='ENU']" - gets all nodes where the attribute 'LID'='ENU'
				 				"\\*\LANG[@LID='ENU']" gets 'LANG' nodes with attrib 'LID'='ENU'
				 				"\\*\LANG" gets nodes named 'LANG'
			
			Example XML file:
			-----------------		 	
Example:	To access the XML data under the 'MAIN_ITEM' tag, call this routine with
			rXML.GetNodes("MAIN_ITEM").  The returned 'nodes' object will allow access to
			any MAIN_ITEM attribute such as 'ID', using the helper method 
			nodes.GetAttribute().  Access to the first level child data is also 
			supported by using the nodes.GetTag() helper function.  The GetTag() method
			allows access to the 1st level children of any 'MAIN_ITEM' parent
			<MAIN>									<-- XML doc root if NOT using xFilter
				...									<-- Other parents 
				<LANG LID="ENU">					<-- Select with xFilter option with 'ENU'
					<ALERT>								(new XML doc root using xFilter)
						<MAIN_ITEM ID="1">			<-- 1st node in returned nodes obj
							<CHILD>text0</CHILD>	<-- Accessable child data
							<DATA>0</DATA>
						</MAIN_ITEM>
						<MAIN_ITEM ID="2">			<-- 2nd node in returned nodes obj
							<CHILD>text1</CHILD>	<-- Accessable child data
							<DATA>1</DATA>
						</MAIN_ITEM>
					</ALERT>
					<ALERT>
				</ELAN>
				<LANG LID="DEU">					<-- Select with xFilter option with 'DEU'
					...								<-- Nth ALERT node
				</LANG>
				...
			</MAIN>
*********************************************************************************/
function getNodes(rXMLObj,tag,loadFilter,xFilter)
{
	try
	{
		gpf_CheckAndThrow(rXMLObj);					// Will throw an exeception on bad rXML status!

		var retval = new Object();
		var objNodeList;
		var temp = null;

		retval = initNodes(rXMLObj,tag,loadFilter,xFilter);						// Initialize NODES obj
		// Upon return the only possible fatal errors are:
		//  gp_FATAL_ERROR - rXML Class had a fatal error before the GetNodes() fn was called...
		//		Possible causes:	1. Could not load MSXML COM object
		//							2. Could not load XML file
				
		if (retval.xFilter != true)											// If !true, get the nth node
		{																	// as defined by the xFilter
			var ParentNode=getXMLParentNode(rXMLObj.xmlObj,retval.xFilter);	// First get parent tag as 'base node'
			try
			{
				objNodeList = ParentNode.getElementsByTagName(tag);			// Then get 1st child of base parent
			}
			catch(e)
			{
				throw rXMLErrorObj(null,gp_NO_NODES_ERROR,"rXML.GetNodes(xFilter) located 0 nodes.");
			}
		}
		else																// Normal 1st level tag retrieval
		{
			objNodeList = rXMLObj.xmlObj.getElementsByTagName(tag);			// Simply get the 1st level tags
		}																	// from the xml file 'base'
		
		if ( (objNodeList) && (objNodeList.length) )
		{
			retval.TAGS = getChildNodeTagNames(objNodeList.item(0));		// Put child TAG names into TAGS property
			for (var elem=0;elem< objNodeList.length;elem++)				// Populate child property data
			{																// Gets 1 child node & data
				temp = getChildNodeData(objNodeList.item(elem),retval.loadFilter);	
				if (temp)
				{
					retval.iaNormal[retval.length]=retval.length;			// Save current index for unsortings
					retval.iaSorted[retval.length]=0;						// Populate sorted array with 0's
					retval.iaCurPtr=retval.iaNormal;						// Copy iaCurrent ptr to iaNormal
					retval[retval.length]= temp;							// Increment nodes length
					retval.length++;
				}
			}
		}
		else
		{
			throw rXMLErrorObj(null,gp_NO_NODES_ERROR,"rXML.GetNodes() located 0 nodes.");
		}
	}
	catch(e)
	{
		rXMLObj.ErrorHandler(rXMLErrorObj(e,gp_LOG_ERROR,"rXML.GetNodes() failed"));
		
		if (rXMLObj.GetStatus()==gp_FATAL_ERROR)
		{
			retval = null;									// Return a null if FATAL error
		}	// Note:  If null IS returned then all nodes debug funcs are inop such as
			// nodes.Alert("msg")!
	}
	return retval;
}

/*********************************************************************************
Function:	initNodes(rXMLObj, tag, [filter],[xFilter]) 
Purpose:	NODES object constructor, part 2, Initialize the NODES object with default 
			values & parameters.  Called by the getNodes() fn before any data has
			been retrieved.
Returns:	The NODES data structure initialized with default values.

Usage:		initNodes(obj, tag, filter, xFilter)- use the same parameter passed to 
			the original GetNodes() function.
*********************************************************************************/
function initNodes(rXMLObj,tag,loadFilter,xFilter)
{
	var retval = new Object();						// Temp object returned to the getNodes() fn

	try
	{
		gpf_CheckAndThrow(rXMLObj);						// Will throw an exeception on bad status!
		
		retval.rXMLObj = rXMLObj;						// Save a pointer to parent rXML object
		retval.index = 0;								// Index var for iterator functionality
		retval.length = 0;								// Number of nodes in object off the root
		if (rXMLObj.status != gp_FATAL_ERROR)			// If rXML object status is NOT gp_FATAL_ERROR
		{
			retval.status = gp_NO_ERROR;				// Then set Nodes Object to gp_NO_ERROR
		}		
		else
		{
			retval.status = gp_FATAL_ERROR;				// Else set Nodes Object to gp_FATAL_ERROR
		}
				
		// Filter variables & flags
		gpf_ValidateFilter(loadFilter);					// If bad and exception will be thrown here!
	
		retval.runFilter = true;						// Function to filter nodes at run time. Use SetFilter().
														// Function to filter nodes at load time [opt]
		retval.loadFilter = loadFilter==null ? true : loadFilter;
		retval.runFilter_length = 0;					// Number of nodes passing the filter function
		
		// xFilter variables (XPath)
		retval.xFilter = xFilter == null ? true : xFilter;	
														// XPath parameter allowing to filter nodes by parent [opt]
		// Sort variables & flags
		retval.iaCurPtr  = new Array();					// Array of indexes, ACTUAL array used for node navigation
		retval.iaNormal  = new Array();					// Array of indexes, sequence NORMAL (only a copy)
		retval.iaSorted  = new Array();					// Array of indexes, sequence SORTED (only a copy)
		retval.sortDir   = 0;							// Sort direction, 1 => normal, -1=> invert, 0=> disabled
		retval.sortFunc  = null;						// Passed in function to allow sorting
		
		// Function parameter abreviations:
		//		Variables:	'i'	-	INT, Index value into the data array
		//					't' -	STRING, XML tag value
		//					'd' -	INT, Sort Direction, 0=disable, 1=normal, -1=reverse
		//					'a' -	STRING, XML node attribute value
		//					'f' -   FUNCTION, Function
		//					'm' -	STRING, text message
		//					'e' -	CONST, gp_NO_ERROR, gp_LOG_ERROR, gp_FATAL_ERROR
		
		// Indexed node data access methods
		retval.GetTagByIndex = function(i,t)		{return getTagValue(this,i,t);};	// INDEX func for accessing by index
		retval.GetAttributeByIndex = function(i,a)	{return getAttribValue(this,i,a);};	// INDEX func for getting attrib by index

		retval.ErrorHandler =   function(e_rXML)	{return errorHandler(this,e_rXML);};// Nodes obj error handler
		
		// External API Iterator functions - all data access refers to the Iterator indexed 
		// node pointed to by the nodes.index member.
		
		retval.GetAttribute = function(a) {return getAttribValue(this,this.index,a);};	// ITER func gets attribute by name
		retval.FindAttribute = function(t,a) {return findAttribute(this,t,a);};			// ITER func searches all nodes for attribute
		retval.GetTag = function(t) {return getTagValue(this,this.index,t);};			// ITER func gets named tag value
		retval.NextNode = function() {return nextprevNode(this,1);};					// ITER func increments Iterator index
		retval.PrevNode = function() {return nextprevNode(this,-1);};					// ITER func decrements Iterator index
		retval.FirstNode = function(){return firstlastNode(this,1);};					// ITER func sets Iterator index to first node
		retval.LastNode = function() {return firstlastNode(this,-1);};					// ITER func sets Iterator index to last node

		// External API Special Functions
		retval.SetFilter = function(f) {return setFilter(this,f);};						// Sets or removes an iterator filter
		retval.SetSortFn = function(f,d) {return setSortFn(this,f,d);};					// Sets sort function and invert flag
		retval.SetSortDir = function(d) {return setSortDir(this,d);};					// Sets the sort direction & returns value
		retval.GetVersion = function() {return rXMLObj.version;};						// Retrieves this app's version string
		retval.LogError = function(e) {return this.ErrorHandler(e);};					// External API to log errors to the parent class
		retval.GetStatus = function() {return this.status;};							// Returns the status of the nodes object

		// External API Debug functions
		retval.Alert = function(m) {return debugAlert(this,m);};						// Displays XML node for debugging
	}
	catch(e)
	{
		throw rXMLErrorObj( e, gp_FATAL_ERROR, "initNodes() failed"); 
	}
	
	return retval;				
}

/*********************************************************************************
Function:	getTagValue(object, index, tag) 
Purpose:	Retrieves a node TAG value
Returns:	Returns the TAG value string
	
Usage:		nodes.GetTag(tag);					// node access using an iterator
			nodes.GetTagByIndex(tag,index);		// node access using an index
*********************************************************************************/
function getTagValue(obj,index,tag)
{	
	var retval;

	try
	{
		gpf_CheckAndThrow(obj);		// Will throw an exeception on bad rXML status!
		
		// Create filter string
		var filter = createFilter(obj.runFilter,'obj[obj.iaCurPtr[index]]');	

		if ( (tag==null) || (index < 0) || (index > obj.index) )
		{
			throw rXMLErrorObj(null,gp_LOG_ERROR,"getTagValue() null tag value or bad index passed");	
		}
		else
		{
			if (eval(filter))													// Check if node passes filter
			{
				retval = (obj.length) ? obj[obj.iaCurPtr[index]][tag]:null;		// Passed filter so return data
			}
			else																// Filter tested false
			{
				throw rXMLErrorObj(null,gp_LOG_ERROR, "getTagValue() filter disabled node tag access (index & iterator)");	
			}
		}
	}
	catch(e)
	{
		obj.ErrorHandler(rXMLErrorObj(e,gp_LOG_ERROR,"getTagValue() failed"));	
		retval = null;
	}
	return retval;
}

/*********************************************************************************
Function:	findAttribute(object, tag, attrib)
Purpose:	Searches for a 1st level node tag that matches the requested attribute
			values.  If found, returns true and the Iterator index points to the 
			found node.  If NOT found, returns false and the Iterator index remains
			unchanged.  Use nodes.GetTag() to access the Iterator indexed data.
Returns:	true if found, false if not.

Usage:		nodes.FindAttribute(tag, attrib)
*********************************************************************************/
function findAttribute(obj,tag,attrib)
{
	var retval=false;								// Preset, assume we will fail to find attrib
	
	try
	{
		gpf_CheckAndThrow(obj);						// Will throw an exeception on bad rXML status!
		
		var saveindex = obj.index;					// Save the index for later restoration
		
		if (obj.FirstNode()==true)					// Set Iterator index to 0
		{											// FirstNode()will return false if 0 nodes available
			do										// Start do loop
			{
				if (obj.GetAttribute(tag)==attrib)	// Test if current index equals request
				{
					retval = true;					// Success, Attribute was found
					break;							// Jump from loop leaving Iterator index at correct node
				}
			}while (obj.NextNode())					// End do loop.  Increment to next node.
		}
		
		if (retval != true)							// Test if successful
		{
			obj.index = saveindex;					// Restore original Iterator index if NOT found
		}
	}
	catch(e)
	{
		retval = false;								
		obj.ErrorHandler(rXMLErrorObj(e,gp_FATAL_ERROR,"findAttribute() failed"));	
	}
	return retval;
}

/*********************************************************************************
Function:	nextprevNode(object,dir) 
Purpose:	Moves the Iterator index to the next OR previous node.
Returns:	true if successful and Iterator index value is decremented or incremented.
			false if NOT successful and Iterator index value is left unchanged

Usage:		nodes.NextNode() AND nodes.PrevNode(), Nodes object helper functions.
*********************************************************************************/
function nextprevNode(obj,dir)
{
	var retval=false;
	try
	{
		gpf_CheckAndThrow(obj);		// Will throw an exeception on bad rXML status!
		
		var save_index = obj.index;								// Save for restoration
		var filter = createFilter(obj.runFilter,'obj[obj.iaCurPtr[obj.index]]');	// Create filter string
		dir = (dir < 0)? -1:1;									// Set count direction
		obj.index = obj.index + dir;							// Set inc or dec obj.index
		
		// Start while loop till end of array
		while((obj.index >=0) && (obj.index < obj.length))		
		{
			if(eval(filter))									// If function matches node, found it
			{
				retval = true;
				break;
			}

			obj.index = obj.index + dir;						// Node not found so increment/decrement index

		}
		if (retval==false)	
		{
			obj.index = save_index;								// Restore original index and return false
		}
	}
	catch(e)
	{
		retval = false;
		obj.ErrorHandler(rXMLErrorObj(e,gp_LOG_ERROR,"nextprevNode() failed"));	
	}
	
	return retval;
}

/*********************************************************************************
Function:	firstlastNode(object,dir) 
Purpose:	Moves the Iterator index to the first or last appropriate node.  
			Variable 'dir' determines if the function behaves as 1=FirstNode() 
			or -1=LastNode().
Returns:	true if successful and Iterator index value is set.
			false if NOT successful and Iterator index value left unchanged.

Usage:		nodes.FirstNode() OR nodes.LastNode(), Nodes object helper function 
*********************************************************************************/
function firstlastNode(obj,dir)
{
	var retval=false;
	try
	{
		gpf_CheckAndThrow(obj);														// Will throw an exeception 
																					//  on bad rXML status!
		var save_index = obj.index;													// Save for restoration
		var filter = createFilter(obj.runFilter,'obj[obj.iaCurPtr[obj.index]]');	// Create filter string	
		dir = (dir < 0)? -1:1;														// Set count direction
		obj.index = (dir < 0) ? obj.length-1 : 0;									// Set new obj.index
																					//  depending on direction
		// Start while loop till end of array
		while((obj.index >=0) && (obj.index < obj.length))		
		{
			if(eval(filter))									// If function matches node, found it
			{
				retval = true;
				break;
			}
			else
			{
				obj.index = obj.index + dir;					// Node not found so increment/decrement index
			}
		}
		if (retval==false)										// Return true if found
		{
			obj.index = save_index;								// Restore original index and return false
		}
	}
	catch(e)
	{
		obj.ErrorHandler(rXMLErrorObj(e,gp_LOG_ERROR,"firstlastNode() failed"));	
		retval = false;
	}

	return retval;
}

/*********************************************************************************
Function:	setFilter(obj,[runFilter_function) - optional filter function.
Purpose:	Adds or removes a JavaScript filter function to all iterator methods.
			Pass a 'null' to remove the current runFilter and the iterator index value
			remains unchanged, zero is returned.  Pass a JavaScript function to enable a 
			new runFilter; the iterator index is changed to the first matching node and 
			the total number of matched nodes is returned.  If the new runFilter has 0 
			matching nodes then 0 is returned.
Note:		The filter function is disabled when it is set to 'true'.  True is used
			because it will always test to true and pass the eval() functions.  
Returns:	Number of filtered nodes found, or 0 if removing filter function.

Usage:		nodes.SetFilter([#.JavaScript_comparison_function])
			#filter_function:	Function can be any legal JavaScript comparison routine.
								Multiple comparisons are supported such as:
									(#.test > '1')&&(#.test != 10)
								Specifying XML TAG values must be preceed by a '#' which
								represents the required node variable name.  The code
								will replace '#' with the proper object name on the fly.
								For example to specify the following function:
									(nodes.SEVERITY == 'error') simply rewrite it as:
									(#.SEVERITY == 'error').  The '#' token can appear on
									either side of the operator as long as its legal.
Exammples:	nodes.SetFilter("#.SEVERITY=='error'")
				- Iterator methods only allow access to tags with SEVERITY tags
				  that have the value 'error'.
			nodes.SetFilter("#.ATTRIBUTE.ID != '1'")
				- Iterator methods only allow access to tags with an attribute not 
				  equal to '1'.
			nodes.SetFilter() or nodes.setFilter('null')
				- Removes the current runFilter and will iterate to all nodes.

*********************************************************************************/
function setFilter(obj,fn)
{
	var retval;
	try
	{
		gpf_CheckAndThrow(obj);					// Will throw an exeception on bad rXML status!
		gpf_ValidateFilter(fn);					// Will throw and exception on bad run filter!

		if ((fn == true)||(fn==null))			// Filter is being turned off
		{
			obj.runFilter=true;					// Set filter var to default off value
			obj.runFilter_length=0;				// Reset filter length
			retval = obj.runFilter_length;		// Save the return value
		}
		else
		{
			var temp;							// Var used to evaluate JavaScript fn
			obj.runFilter = fn;					// Store new filter function
			obj.index = 0;
			obj.runFilter_length = 0;			// Initialize number of filtered nodes
			for (var i=0;i<obj.length;i++)		// Count up number of 'filtered' nodes
			{
				temp = createFilter(obj.runFilter,'obj[obj.iaCurPtr[i]]');
				if (eval(temp))					// See if current node matches filter params
				{
					obj.runFilter_length++;		// Increment number of filtered nodes
				}
			}
			obj.FirstNode();					// Set to first filtered or non-filtered node.
			retval = obj.runFilter_length;		// Save the return value
		}
	}
	catch(e)
	{
		// Set parameters to default as if no filter were applied
		obj.runFilter=true;					// Set filter var to default off value
		obj.runFilter_length=0;				// Reset filter length
		retval = obj.runFilter_length;		// Save the return value
		
		obj.ErrorHandler(rXMLErrorObj(e,gp_LOG_ERROR,"setFilter() failed"));	
	}
	return retval;
}

/*********************************************************************************
Function:	setSortFn(obj,func, [dir])
			[func]    => JavaScript comparison function pointer
			[sortdir] => 1=Normal, -1=Inverted Normal (NORMAL is default)
Purpose:	Sets the function to use during sorting.  The function pointer passed MUST
			return the following values in order for sorting to function:
				func(a,b) returns 1 or more if a > b
				func(a,b) returns -1 or less if a < b
				func(a,b) returns 0 if a == b
			Refer to JavaScript Array.sort() documentation for more info.
Returns:	Nothing
	
Usage:		SetSortFn(Sort_func,[dir])	Note: The optional dir parameter, allows inversion
			of the returned value from the passed in Sort_func pointer.
*********************************************************************************/
function setSortFn(obj,fn,dir)
{
	try
	{
		gpf_CheckAndThrow(obj);						// Will throw an exeception on bad rXML status!

		dir = (dir) ? dir : 1;						// If no dir passed set default to 1
	
		if (fn)										// If FN passed assign it
		{
			obj.sortFunc = fn;
		}
		else										// Else remove the function ptr
		{	
			obj.sortFunc = null;
		}
		obj.SetSortDir(dir);						// Only set the sort direction if passed
													// FirstNode() call fixes bug.  In SetSortDir().
	}												// SORTING occurs in the setSortDir() FN.
	catch(e)
	{
		obj.ErrorHandler(rXMLErrorObj(e,gp_FATAL_ERROR,"setSortFn() failed"));	
	}
}

/*********************************************************************************
Function:	setSortDir(obj,[dir]) 
			[sortdir] => 1=Normal, -1=Inverted Normal, 0=Disabled (NORMAL is default)
Purpose:	Sets the sort direction, or turns off sorting without clearing the sort
			function member when passed 0 as the [dir].
Returns:	The current sort direction. 
	
Usage:		nodes.SetSortDir(), set the sort direction to NORMAL
			nodes.SetSortDir(-1), set the sort direction to INVERTED NORMAL
			nodes.SetsortDir(0), shuts off sorting without removing the sort function.
*********************************************************************************/
function setSortDir(obj,dir)
{	
	var retval = 0;
	try
	{
		obj.iaCurPtr = obj.iaNormal;				// Set array ptr to original load order
		if (dir != 0)								// Activate Sorting
		{
			obj.sortDir = dir > 0 ? 1 : -1;			// Set sort direction
			
			arCopy(obj.iaNormal, obj.iaSorted);		// Copy NORMAL order to SORTED array
			if (obj.sortFunc)						// If sort FN is NOT null then
			{										//   then use it
				obj.iaSorted.sort(obj.sortFunc);	
			}
			if (obj.sortDir < 0)					// If reversing the sort
			{										//   then reverse the SORTED array
				obj.iaSorted.reverse();				
			}
			obj.iaCurPtr = obj.iaSorted;			// Set current pointer to SORTED array
		}
		else										// Turn sorting OFF
		{
			arClear(obj.iaSorted);					// Remove all elements from iaSorted array
			retval = 0;								// Set the return var
			obj.sortDir = 0;					// Turn off sorting
		}
	}
	catch(e)
	{
		obj.ErrorHandler(rXMLErrorObj(e,gp_FATAL_ERROR,"setSortDir() failed"));	
	}
	obj.FirstNode();								// Move index to 1st record- fixes bug when filter & sort
													//   are enabled at same time.  Filter & Sort order 
													//   dependant!
	return retval;									// Return the current sort direction
}

/*********************************************************************************
Function:	errorHandler(rXMLErrorObj)
Purpose:	Default error handler routine.  The routine takes an error variable of
			type rXMLErrorObj which is essentially a modified JavaScript Error() object.
			
			If debug mode is enabled, AND rXMLErrorObj.number >= gp_rXMLMinStatusAlert,
			a message box displays the error info.
			
			JavaScript Error Object member mapping:
			---------------------------------------
			rXMLErrorObj.name=>			JavaScript name from the JavaScript Error() object
			rXMLErrorObj.message=>		JavaScript error message from the JavaScript Error() object
			rXMLErrorObj.number=>		rXML gp_XXX_YYYY error levels (shown below & defined at top)
			rXMLErrorObj.description=>	rXML error message(s).  
			
Returns:	gp_NO_ERROR or,			// If status is ok, or the status WAS gp_LOG_ERROR
			gp_NO_NODES_ERROR or,	// The nodes object has 0 nodes to iterate.  Non fatal.
			gp_FATAL_ERROR			// Something really bad happened and execution cannot continue.

			Note: gp_LOG_ERROR is NEVER returned because once the error is logged, the 
				  object status is reset to gp_NO_ERROR by this function.

Usage:		errorHandler(rXMLErrorObj)			// Internal helper function access
			
			nodes.LogError(rXMLErrorObj)		// External API nodes access (from client HTML pages)
			rXML.ErrorHandler(rXMLErrorObj)		// External API rXML class access (depreciated)
*********************************************************************************/
function errorHandler(obj,e_rXML)
{	
	var pad='                                                                         ';
	var tab = 27;
	var tabs = '\t'
	
	if (e_rXML == null)							// Validation check.  If null, create a new error object
	{											// and then force a fatal error.
		e_rXML = rXMLErrorObj(null,gp_FATAL_ERROR,"errorHandler() passed a null parameter");
	}

	if (obj != null)
	{
		switch(e_rXML.number)						// Must have a REAL object now
		{
			case gp_NO_ERROR:						// No error so do nothing
				break;
			case gp_LOG_ERROR:						// Non-fatal error, so log, reset and return.
				if (obj.status <= gp_LOG_ERROR)		// Check if we should clear the global error status
				{
					obj.status = gp_NO_ERROR;		// Reset the status to NO_ERROR after logging
				}
				break;
			case gp_NO_NODES_ERROR:					// Non-fatal error.  No nodes found.  Persistent state.
				obj.status = gp_NO_NODES_ERROR;		// Set the gp_NO_NODES_ERROR status
				break;
			default:								// Unknown or fatal error.  Log error and return
			case gp_FATAL_ERROR:
				obj.status = gp_FATAL_ERROR;
				break;		
		}
	}	
	// Call the external error logger routine if error.number is > gp_NO_ERROR
	if (gpf_rXMLErrorLogger != null)
	{
		gpf_rXMLErrorLogger(e_rXML);
	}
	
	//
	// Error handler debug popup dialog only shows if rXML debug is ENABLED!
	// And the error number >= Minimum Status Alert Value
	
	if ( (gpf_GetDebug()==true) && (e_rXML.number >= gp_rXMLMinStatusAlert) )	
	{											// Have to use the global page var instead of 
												// API because this func is outside the class and Nodes obj
		var str = new String();	
		str =  ('Error Handler Debug Output' + pad).slice(0,tab) + tabs + '\n';
		str += '----------------------------------' + '\n\n';
		str += ('Object Status:' + pad).slice(0,tab) + tabs + obj.status + '\n\n';
		str += ('Error Name:' + pad).slice(0,tab) + tabs + e_rXML.name + '\n';
		if (e_rXML.message)
			str += ('Error Message:' + pad).slice(0,tab) + tabs + e_rXML.message + '\n';
		str += ('Error Number:' + pad).slice(0,tab) + tabs;
		
		switch(e_rXML.number)
		{
			case gp_NO_ERROR:
				str += 'No Error, PASS(';
				break;
			case gp_LOG_ERROR:
				str += 'Log Error, PASS(';
				break;
			case gp_NO_NODES_ERROR:
				str += 'No Nodes Error, PASS(';
				break;
			case gp_FATAL_ERROR:
				str += 'Fatal Error, FAIL(';
				break;
		}

		str += e_rXML.number + ')\n';
		str += ('Error Description(s):' + pad).slice(0,tab);
		var strA = e_rXML.description.split('\n');
		str += '\t1.  ' + strA[0] + '\n';
		for (var i=1;i<strA.length-1;i++)
			str += '\t\t\t' + (i+1) + '.  ' + strA[i] + '\n';
		str+='\n';
		alert(str);
	}
	
	return obj.status;
}

/*********************************************************************************
Function:	getXMLParentNode(xmlObj, xFilter) 
Purpose:	Use obj.selectSingleNode(xFilter) to get a 'root' node.   
Returns:	A MSXML node object.  NOT A rXML NODE OBJECT!!!

Usage:		Internal helper function, getXMLParentNode(xmlObj,xFilter)
*********************************************************************************/
function getXMLParentNode(xmlObj, xFilter)
{
	var retval=null;

	try
	{
		if (xFilter==null)
		{
			throw rXMLErrorObj( e, gp_LOG_ERROR, "getXMLParentNode() 'xFilter' parameter cannot be NULL"); 
		}
             
                xmlObj.setProperty("SelectionLanguage", "XPath");		// Set the XPath property for v3 of MSXML
		retval = xmlObj.selectSingleNode(xFilter);				// note:  v4 MSXML uses "XPath" as default,
	}															//		  v3 MSXML we must set "XPath"
	catch(e)
	{
		throw rXMLErrorObj( e, gp_LOG_ERROR, "getXMLParentNode() failed"); 

	}
	return retval;
}

/*********************************************************************************
Function:	arClear() 
Purpose:	Physically erases each element of an array
Returns:	Nothing

Usage:		Internal helper function, arClear(JavaScript Array Object)
*********************************************************************************/
function arClear(aObj)
{
	try
	{
		for (var i=0;i<aObj.length;i++)		// Loop thru entire array and clear
			aObj[i] = '';
	}
	catch(e)								// Not part of class, so use global errorHandler()
	{
		throw rXMLErrorObj(e,gp_FATAL_ERROR,"arClear() failed");	
	}
}

/*********************************************************************************
Function:	arCopy(src,dest)
Range:		src, dest must be valid JavaScript arrays with 0 to n members.
Purpose:	Physically copies each array elem from src to dest array
Returns:	Nothing

Usage:		Internal helper function, arCopy(srcArray, destArray)
*********************************************************************************/
function arCopy(src,dest)
{	
	try
	{	
		for (var i=0;i<src.length;i++)		// Loop thru entire array and clear
		{
			dest[i] = src[i];
		}
	}
	catch(e)
	{										// Not part of class, so use global errorHandler()
		throw rXMLErrorObj(e,gp_FATAL_ERROR,"arCopy() failed");	
	}
}

/*********************************************************************************
Function:	createFilter(filter, prefix) 
Purpose:	Modifies the filter string and adds proper prefix for JavaScript or XPath 
			filtering at load time.  Only used from the GetNodes() function.
			The function inserts the 'prefix' parameter wherever the '#' symbol appears
			within the 'filter' parameter.
Returns:	Returns the new working filter string or TRUE if a filter is NOT applicable.  If
			an exception is thrown, the false is returned causing no data to be available for
			iterative access functions(JavaScript filter only),
	
Usage:		Internal helper function, createFilter('#.data','nodes');
*********************************************************************************/
function createFilter(filter,prefix)
{
	var retval=true;											// Preset to TRUE for return
	try
	{
		if (filter != true)										// Filter is inactive so just return
		{
			var exp = new RegExp('#','g');						// Set global replace of # with prefix string
			retval = (filter).replace(exp,prefix);				// Do the replace
		}
	}
	catch(e)													
	{															// Log error
		throw rXMLErrorObj(e,gp_LOG_ERROR,"createFilter() failed");
		retval=false;											// Nothing will be displayed on bad filter str
	}
	return retval;												// Return modified string
}

/*********************************************************************************
Function:	getAttribValue(object, index, attrib) 
Purpose:	Returns and indexed attribute value
Returns:	Sting value of attribute requested or null if not found
			
Usage:		nodes.GetAttribute("Attribute_Name")
*********************************************************************************/
function getAttribValue(obj,index,attrib)
{
	var retval = null;
	try
	{
		gpf_CheckAndThrow(obj);		// Will throw an exeception on bad rXML status!
		var filter = createFilter(obj.runFilter,'obj[obj.iaCurPtr[index]]');	// Create filter string

		if (( attrib==null) || (index < 0) || (index > obj.index ))
		{
			throw rXMLErrorObj(null,gp_LOG_ERROR,"getAttribValue() null attribute value or bad index passed");	
		}
		else
		{
			if (eval(filter))										// Check if node passes filter
			{														// If node.length > 0 return Attribute
				retval = (obj.length)? obj[obj.iaCurPtr[index]].ATTRIBUTE[attrib] : null;
			}
			else													// Log node access attempt
			{
				throw rXMLErrorObj(null,gp_LOG_ERROR, "getAttribValue() filter disabled node access (index & iterator)");	
			}
		}
	}
	catch(e)
	{
		obj.ErrorHandler(rXMLErrorObj(e,gp_LOG_ERROR,"getAttribValue() failed"));	
		retval = null;
	}
	return retval;
}

/*********************************************************************************
Function:	getChildNodeData(object,loadFilter) 
Purpose:	Adds 1st level tag nodes to nodes retval variable.  Also adds sibling attributes
			and TAGS to nodes retval variable.  This function is only called once from the 
			getNodes() fn.  The load filter is also only applied once, at load time from within
			the getNodes() fn.  This is different from the run time Filter functionality.
Returns:	An object in the form:
				 nodes.length					(value) Number of XML nodes
					  .child_tag_0				(value) XML data
					  .child_tag_1				(value) Next XML data item
					  .child_tag_n				(value) Last XML data item
					  .ATTRIBUTE				(value) Attribute data items
					  .ATTRIBUTE.TAGS			(array)	Attribute TAG names array
					  .ATTRIBUTE.TAGS.length	(value)	Number of Attribute TAGS data values
					  .ATTRIBUTE.tag_0			(value) Attribute data
					  .ATTRIBUTE.tag_1			(value) Next attribute data item
					  .ATTRIBUTE.tag_n			(value) Last attribute data item

Usage:		Internal helper function, getChildNodeData(object,loadFilter) 
*********************************************************************************/
function getChildNodeData(node,loadFilter)
{
	try
	{
		var childTags = node.childNodes;					// Retrieve child nodes
		var attribs = getNodeAttributes(node);				// Retrieve this nodes attributes
		var retval = new Object();

		retval.ATTRIBUTE = attribs.ATTRIBUTE;				// Add attibutes to retval
		for (var i=0;i<childTags.length;i++)				// Loop thru all child nodes and add
		{													// data by TAG NAME to retval
			retval[childTags.item(i).nodeName] = childTags.item(i).text;
		}
		
		if (loadFilter!=true)								// Check if filter active
		{
			var cfTemp = createFilter(loadFilter,'retval');	// Swap # for object name
			if (!eval(cfTemp))
			{												// If retval matches filter return it
				retval = null;
			}
		}
	}
	catch(e)
	{
		retval = null;
		throw rXMLErrorObj(e,gp_FATAL_ERROR,"getChildNodeData() failed");				// Log error
	}
	
	return retval;
}

/*********************************************************************************
Function:	getNodeAttributeTags(node) 
Purpose:	Gets all the attribute TAG names and populates an array.
Returns:	Returns an array of all the attribute TAG names
			
Usage:		Internal helper function, getNodeAttributeTags(node) 
*********************************************************************************/
function getNodeAttributeTags(node)
{	
	var retval=new Array();
	var attribs=new Object();
		
	try
	{
		attribs = node.attributes;					// Retrieve XML attribute names array
		for (var i=0;i<attribs.length;i++)			// Loop thru all attribute names retrieved
		{
			retval[i] = attribs.item(i).name;		// Create a new array of attribute names
		}
	}
	catch(e)
	{
		retval = null;
		throw rXMLErrorObj(e,gp_LOG_ERROR,"getNodeAttributeTags() failed");		// Log error
	}
	
	return retval;
}

/*********************************************************************************
Function:	getNodeAttribute(node) 
Purpose:		
Returns:	Returns an object containing all the attributes of a particular node
			in the following form:
				object.ATTRIBUTE.tagname1=tag1data
				object.ATTRIBUTE.tagname2=tag2data
			
Usage:		Internal helper function, getNodeAttribute(node)
*********************************************************************************/
function getNodeAttributes(node)
{
	var retval = new Array();

	try
	{
		if (node==null)								// Check for null node.
		{
			throw new Error();
		}
		
		var attribs = new Object();
		var attribute = node.attributes;			// obj.attributes DOM property used

		attribs.length=node.attributes.length;		// Add the number of attributes to .length property	
		attribs.TAGS = getNodeAttributeTags(node);
		for (var i=0;i<attribs.length;i++)			// Loop thru and add attribute name/data pairs to 
		{
			attribs[attribute.item(0).name] = attribute.item(0).value;
		}
		retval.ATTRIBUTE=attribs;
	}
	catch(e)
	{
		retval = null;	
		throw rXMLErrorObj(e,gp_LOG_ERROR,"getNodeAttributeTags() failed");				// Log error
	}	
	return retval;	
}

/*********************************************************************************
Function:	getChildNodeTagNames(node) 
Purpose:	Returns an array of child tag names from the provided node
Returns:	Returns an Array possibly empty which is OK.
			
Usage:		Internal helper function, getChildNodeTagNames(node) 
*********************************************************************************/
function getChildNodeTagNames(node)
{
	var retval = new Array();

	try
	{
		var childTags = node.childNodes;				// Get an array of tag names
		for ( var i=0; i<childTags.length; i++ )		// Loop thru the array
		{
			retval[i] = childTags.item(i).nodeName;		// Add an array of tag names for return
		}	
	}
	catch(e)
	{
		throw rXMLErrorObj(e,gp_LOG_ERROR,"getChildNodeTagNames() failed");	// Log error
	}
	return retval;
}

// Global page function definitions - Minimal documentation on these fns.  If you don't understand
// these functions please stop reading and go back to college.  I am not kidding.
// Generalities:
//		Purpose:	All internal functions use these interfaces to access GLOBAL PAGE variables.
//					DO NOT ACCESS 'gp_VARIABLES' directly!
//		Returns:    gpf_SetXX() functions return the value requested
//					gpf_GetXX() functions returns the requested value, usually a BOOL or a STRING
//

/*********************************************************************************
Function:	gpf_GetVersion() - Returns the version of rXML file (this file)
Returns:	STRING containing the current version number.
*********************************************************************************/
function gpf_GetVersion()			// GLOBAL PAGE FUNCTION to read rXML (ReadXML) version number.
{	
	return gp_rXMLVersion;			// Return the global page version variable
}

/*********************************************************************************
Function:	gpf_CheckAndThrow(obj) - Checks the passed object to see if 
			the status is set to a FATAL error.  If it is it throws an exception.  
			If OK, execution continues.
Note:		Only use internally and only from within a try block!
Returns:	Nothing
*********************************************************************************/
function gpf_CheckAndThrow(obj)
{
	if (obj.GetStatus() == gp_FATAL_ERROR)		// Check parent status for fatal error
	{
		throw rXMLErrorObj(null, gp_FATAL_ERROR, "gpf_CheckAndThrow() object status prevented execution");
	}
}


/*********************************************************************************
Function:	gpf_GetDebug() - Retrieves the debug status of rXML class
Returns:	BOOL, true if DEBUG is enabled, or false if it is not.
*********************************************************************************/
function gpf_GetDebug()
{
	return gp_rXMLDebugEnable;				// Return the global page debug enable variable
}

/*********************************************************************************
Function:	gpf_SetDebug() - Sets the global debug status for the rXML class
Parameters:	BOOL true or false.  true enables debugging.  Anything else disables debugging.
Returns:	BOOL, the current setting of the debug flag.
*********************************************************************************/
function gpf_SetDebug(newDebug)
{
	if (newDebug==true)
	{
		gp_rXMLDebugEnable = true;			// Set the debug flag to enabled
	}
	else
	{
		gp_rXMLDebugEnable = false;			// Set the debug flag to disabled
	}
	return gpf_GetDebug();
}

/*********************************************************************************
Function:	gpf_getXMLObj(objPtr, [userXMLObj]) >> [...] OPTIONAL arguement
Purpose:	Function attempts to load an XMLParsing COM object.  Attempts to load
			USERXML, GLOBALXML, and finally MSXML4.
Returns:	TRUE if pass, FALSE if failed.
			objPtr set if pass, objPtr set to NULL if fail.
Usage:		var xmlObj = getXMLObj(userXMLObj);	// Uses User specified XML Obj
			var xmlObj = getXMLObj();			// Attempts to load standard
												//   Global or MSXML objects
*********************************************************************************/
function gpf_getXMLObj(objPtr, userXMLObj)
{
	var retval = true;							// Preset for PASS condition

	if (userXMLObj!=null)		
	{
		objPtr.xmlObj = userXMLObj;				// If user passed in XML object, then use it
	}
	else 
	{
		try
		{
			if(g_ObjMSXML)						// See if global CCU XML object is available
			{
				objPtr.xmlObj = g_ObjMSXML;
			}
		}
		catch(e)								// Lets try the built-in MSXML objects 
		{
			try									// Try MSXML version 4
			{
				objPtr.xmlObj = new ActiveXObject("Msxml2.FreeThreadedDOMDocument.4.0");
			}
			catch(e)
			{
				retval = false;					// Failed
				objPtr.xmlObj = null;			// Set object pointer to null
				objPtr.ErrorHandler(rXMLErrorObj(null,gp_FATAL_ERR, "gpf_getXMLObj() MSXMLv4 failed"));
			}
		}
	}

	if (retval==true)							// If PASS assign default COM parameters
	{
		try
		{
			objPtr.xmlObj.async = false;		// Set defaults for the MSXML parser COM object
			objPtr.xmlObj.resolveExternals= false;	
			objPtr.xmlObj.validateOnParse = true;
		}
		catch(e)
		{
			retval = false;						// Set return value to show FAILURE
			objPtr.ErrorHandler(rXMLErrorObj(e, gp_FATAL_ERROR, "gpf_getXMLObj() failed."));
		}
	}
	
	return retval;
}

/*********************************************************************************
Function:	gpf_SetErrorLogger(rXMLErrorObj)
Purpose:	Changes the global page function pointer to point to an external error
			logger routine.  The new function must accept 1 parameter of type 
			rXMLErrorObj, which is a modified JavaScript Error() object.
Returns:	Nothing
			objPtr set if pass, objPtr set to NULL if fail.
Usage:		rXML.SetErrorLogger(function)			// Sets an error logging function
			rXML.SetErrorLogger()					// Sets the default; no logging
*********************************************************************************/
function gpf_SetErrorLogger(newErrHandler)
{
	try
	{
		if (newErrHandler != null)					// Check if pointer is valid
		{
			gpf_rXMLErrorLogger = newErrHandler;	// Set the new function ptr
		}
		else										// Must be reseting to default
		{
			gpf_rXMLErrorLogger = null				// Set the default, NO logging
		}	
	}
	catch(e)
	{
		gpf_rXMLErrorLogger = null;					// First restore the original
													
		throw rXMLErrorObj(e, gp_LOG_ERROR, "rXML.SetErrorLogger() failed.  Default restored.");

	}

}
/*********************************************************************************
Function:	gpf_ValidateFilter(filter)
Purpose:	Throws and exception if filter string has '#' and is NOT followed by
			a '.' character.  Only works on JavaScript filters.  Not used for XPath filters.
Returns:	Nothing
Usage:		gpf_ValidateFilter('#.test==#id')			// Throws and exception, ie no '.' after 2nd '#'
			gpf_ValidateFilter('#.test==#.id)			// Does nothing and returns
*********************************************************************************/
function gpf_ValidateFilter(filter)
{
	if ( (filter==null)||(filter==true)||(filter==false) )		// If empty do nothing
	{
		return;													// Do nothing but return
	}
	else
	{
		filter = (filter).replace(RegExp('#\\.','g'),'PP');		// First replace valid '#.' tokens
		
		if (filter.search(RegExp('#','g')) != -1)				// Search for invalid remaining '#' tokens
		{														// If 1 is found throw exception
			throw rXMLErrorObj(null, gp_LOG_ERROR, "gpf_ValidateFilter() Syntax error.  Missing '.' after '#' token in filter string");
		}
	}
}

/*********************************************************************************
Function:	debugAlert(object,[message])  [message] parameter optional
Purpose:	Debug function used to display the current Iterator indexed node data.
			Use this function, if debug is enabled, to display a comprehensive display
			of the contents of the current nodes object.
Returns:	Nothing.
Usage:		nodes.Alert(), Nodes object helper debug function.
*********************************************************************************/
function debugAlert(obj,msg)
{
	if (gpf_GetDebug() == false)
		return;										// Don't care about multi-return paths
	
	var i = 0;
	var INDEX = obj.index;
	var pad='                                                                         ';
	var tab = 27;
	var tabs = '\t\t'
	var str =	new String();
	var sTemp = null;
	
	if (msg)										// Process optional 'msg' parameter
	{
		str +=	('Alert Message:' + pad).slice(0,tab) + tabs + msg + '\n';
	}
	str +=	('App Version:' + pad).slice(0,tab) + tabs + gpf_GetVersion() + ' (xml.js)\n\n';
	str +=	('XML File: ' + pad).slice(0,tab) + tabs + obj.rXMLObj.filename + '\n\n';
	str +=	('Nodes Status:' + pad).slice(0,tab) + tabs

	switch(obj.GetStatus())
	{
		case gp_NO_ERROR:
			str += '[ '+ gp_NO_ERROR + ' ] No Error, PASS\n';
			break;
		case gp_LOG_ERROR:
			str += '[ ' + gp_LOG_ERROR + ' ] Log Error, PASS\n';
			break;
		case gp_NO_NODES_ERROR:
			str += '[ ' + gp_NO_NODES_ERROR + ' ] No Nodes Error, PASS\n';
			break;
		case gp_FATAL_ERROR:
			str += '[ ' + gp_FATAL_ERROR + ' ] Fatal Error, FAIL\n';
			break;
	}

	str +=	('Iterator Index:' + pad).slice(0,tab) + tabs + obj.index + '\n\n';
	
	if (obj.xFilter==true)
	{
		str +=	('Nodes Access: ' + pad).slice(0,tab) + tabs + '1st Level Node Access' + '\n';
		str +=	('    xFilter String:' + pad).slice(0,tab) + tabs + 'NOT ASSIGNED' + '\n';
	}
	else
	{
		str +=	('Nodes Access: ' + pad).slice(0,tab) + tabs + 'Nth Level Node Access (XPath Filter)' + '\n';
		str +=	('    Load xFilter String:' + pad).slice(0,tab) + tabs + obj.xFilter + '\n';
	}

	if (obj.loadFilter==true)
		str +=	('\nLoadFilter Function: ' + pad).slice(0,tab) + tabs + 'None' + '\n\n';
	else
		str +=	('\nLoadFilter Function: ' + pad).slice(0,tab) + tabs + createFilter(obj.loadFilter,'obj') + '\n';
	str +=	('Node Count:' + pad).slice(0,tab) + tabs + obj.length + '\n\n';

	if (obj.runFilter==true)
		str +=	('RunFilter Function: ' + pad).slice(0,tab) + tabs + 'None' + '\n';
	else
		str +=	('RunFilter Function: ' + pad).slice(0,tab) + tabs + createFilter(obj.runFilter,'obj') + '\n';
	str +=	('Filtered Nodes: ' + pad).slice(0,tab) + tabs + obj.runFilter_length + '\n';

	if (obj.sortDir==0)
		str+=	'\nSort Info (disabled)\n';
	else
		str+=	'\nSort Info\n';
	
	if (obj.sortFunc!=null)
		str +=	('    Sort Function: ' + pad).slice(0,tab) + tabs + 'Installed' + '\n';
	else
		str +=	('    Sort Function: ' + pad).slice(0,tab) + tabs + 'None' + '\n';
	
	str +=	('    Sort Direction: ' + pad).slice(0,tab) + tabs;
	if (obj.sortDir==0)
		str +=  'None\n';
	else if (obj.sortDir==1)
		str +=  'Normal\n';
	else
		str +=  'Inverted \n';

	str +=	('    Current iArray: ' + pad).slice(0,tab) + tabs;
	if (obj.iaCurPtr.length==0)
		str +=  'empty\n'
	else
	{
		var max = 10;
		for (var i=0,sTemp='[';((i<obj.iaCurPtr.length)&&(i<max));i++)
		{
			sTemp += obj.iaCurPtr[i];
			sTemp += (i<obj.iaCurPtr.length-1)?'\, ':'';
		}
		sTemp += (obj.iaCurPtr.length > max)?'...]':']';

		str += sTemp;

		str += '\n'
	}
	
	str +=	('    Normal iArray: ' + pad).slice(0,tab) + tabs;
	if (obj.iaNormal.length==0)
		str +=  'empty\n'
	else
	{
		var max = 10;
		for (var i=0,sTemp='[';((i<obj.iaNormal.length)&&(i<max));i++)
		{
			sTemp += obj.iaNormal[i];
			sTemp += (i<obj.iaNormal.length-1)?'\, ':'';
		}
		sTemp += (obj.iaNormal.length > max)?'...]':']';

		str += sTemp;

		str += '\n'
		
	}
	str +=	('    Sorted iArray: ' + pad).slice(0,tab) + tabs;

	if (obj.iaSorted.length==0)
		str +=  'empty\n';
	else
	{
		var max = 10;
		for (var i=0,sTemp='[';((i<obj.iaSorted.length)&&(i<max));i++)
		{
			sTemp += obj.iaSorted[i];
			sTemp += (i<obj.iaSorted.length-1)?'\, ':'';
		}
		sTemp += (obj.iaSorted.length > max)?'...]':']';

		str += sTemp;

		str += '\n'
	}

	if (obj.length > 0)									// Make sure we have some nodes to display!
	{
		if (obj.TAGS.length)							// Display XML data
		{
			str+=	'\nXML Tag Data\n';
			for (i=0;i<obj.TAGS.length;i++)
			{
				str+= '    ' + (obj.TAGS[i] + ':' + pad).slice(0,tab) + tabs;
				str+= (obj[INDEX][obj.TAGS[i]]).slice(0,50) + '\n';
			}
		}
		
		if (obj[INDEX].ATTRIBUTE.length)				// Display node ATTRIBUTE
		{
			var aCount = obj[INDEX].ATTRIBUTE.length;
			str+= ('\nAttributes' + pad).slice(0,tab) + tabs;
			str+= aCount + '\n';
			for (i=0;i<aCount;i++)
			{
				str+= '     ' + (obj[INDEX].ATTRIBUTE.TAGS[i] + ':' + pad).slice(0,tab)+ tabs;	
				str+= obj[INDEX].ATTRIBUTE[obj[INDEX].ATTRIBUTE.TAGS[i]] + '\n';			
			}
		}
	}
	else
	{
		str+='\n\nWARNING!  Nodes object is empty so there is nothing to display.\n';
	}

	if ((obj.runFilter != true) && (obj.runFilter_length==0))
		str+='\nNode iteration not possible.  Check your filter strings!  \n';

	alert(str); 
	return;
}


//EOF
