//------------------------------------------------------------------------------
// addins.js - Style sheets, widgets, and code to support global addins
//
// INTEL CONFIDENTIAL
//  Copyright (c) 2004-2006 Intel Corporation All Rights Reserved.  The source code
//  contained or described herein and all documents related to the source code
//  (Material) are owned by Intel Corporation or its suppliers or licensors.
//  Title to the Material remains with Intel Corporation or its suppliers and
//  licensors. The Material may contain trade secrets and   proprietary and
//  confidential information of Intel Corporation and its   suppliers and
//  licensors, and is protected by worldwide copyright and trade secret laws
//  and treaty provisions. No part of the Material may be used, copied,
//  reproduced, modified, published, uploaded, posted, transmitted, distributed,
//  or disclosed in any way without Intels prior express written permission. 
//  
//  No license under any patent, copyright, trade secret or other intellectual
//  property right is granted to or conferred upon you by disclosure or delivery
//  of the Materials, either expressly, by implication, inducement, estoppel or
//  otherwise. Any license under such intellectual property rights must be express
//  and approved by Intel in writing.
//
//  Unless otherwise agreed by Intel in writing, you may not remove or alter this
//  notice or any other notice embedded in Materials by Intel or Intels suppliers
//  or licensors in any way.
//
// Description:
//  LTD0
//
// Left To Do:
//
// Revision History:
//  0.01  10-20-2004	CPD: Initial release
//------------------------------------------------------------------------------

/*********************************************************************************
Global Page Variables
*********************************************************************************/
var gp_nodes = 					null;			// Nodes object 
var gp_mcwCount = 				0;				// mcWidget count
var gp_debug =					false;			// Page debug option

var gp_vars = new Object();						// TIMER specific object
	gp_vars.timerID = 			null;			// ID for later deletion
	gp_vars.timerInterval =		0;				// Maintime base interval TIMER_0
	gp_vars.timerTicks =		0;				// Updated on each call to TimerCallback function
	gp_vars.timerFuncs = 		new Array();	// Stored TIMER call back function pointers
	gp_vars.timerDivs = 		new Array();	// Stored TIMER divisors
	gp_vars.timerData =			new Array();	// Stored TIMER data

/*********************************************************************************
Function:	TimerStart(interval,fn,[data]) 
Purpose:	Starts a timer or adds another timer to the stack.  When a time limit is hit, the passed in 
			function 'fn' is called and is passed the optional 'data' object.
Returns:	TimerID
Syntax:		TimerStart(interval,fn,data)
Desc:		The first call to TimerStart() sets the initial timebase in milliseconds.  Subsequent calls,
			can pass an interval of 0 to use the same time base, or pass a value which is a multiple of the 
			original timebase.  For example if the timebase = 1000 for timer 0, and 2000 for timer 1, then timer
			1 will trigger every second and timer 2 will trigger every 2 seconds.
*********************************************************************************/
function TimerStart(interval,fn,data)
{
	var index = 0;

	if ((!interval) || (!fn))
	{
		//alert("TimerStart() failed.  First 2 parameters cannot be null!");
		return null;
	}

	if (interval==0)
		interval = gp_vars.timerInterval;

	if ( (interval < gp_vars.timerInterval) || (interval % gp_vars.timerInterval))
	{
		//alert("TimerStart(" + interval + ",...) failed.  'interval' param must be >= than " + gp_vars.timerInterval + " AND an even multiple of " + gp_vars.timerInterval);
		return null;
	}
	
	if (gp_vars.timerID==null)		// Inital timebase set with TIMER_0
	{	
		gp_vars.timerInterval =	interval;
		
		try
		{
			gp_vars.timerID = window.setInterval(TimerCallback, gp_vars.timerInterval);
		}
		catch(e)
		{
			// Ignore error
		}
	}

	gp_vars.timerFuncs[index] = fn;
	gp_vars.timerDivs[index] =	Math.round(interval / gp_vars.timerInterval);
	gp_vars.timerData[index] =	data;
	
	return index;
}

/*********************************************************************************
Function:	TimerStop([timerID])
Purpose:	Stops all timers or a particular one.
Returns:	Nothing
Syntax:		TimerStop() without a timerID param will disable all timers.  Passing a timerID
			will terminate a particular timer.
*********************************************************************************/
function TimerStop(ID)
{
	var retVal = true;
		
	try	
	{ 
		window.clearInterval(gp_vars.timerID);
	}
	catch(e)
	{ 
		retVal = null;
		//alert("clearInterval(" + gp_vars.timerID + ") failed.")
	}
	
	gp_vars.timerID = null;	
	
	if (ID >= 0)
	{
		gp_vars.timerFuncs[ID] = null;
		gp_vars.timerDivs[ID] =	null;
		gp_vars.timerData[ID] =	null;
	}
	
	return retVal;
}

/*********************************************************************************
Function:	TimerCallback()
Purpose:	Sequentially calls each timer's callback function and passing any optional data.
Returns:	Nothing
Syntax:		Internal function.
*********************************************************************************/
function TimerCallback()
{
	var arLen = gp_vars.timerFuncs.length;
	gp_vars.timerTicks++;
	
	for (var i=0;i<arLen;i++)
	{
		if ((gp_vars.timerFuncs[i]) && ((gp_vars.timerTicks % gp_vars.timerDivs[i])==0) )
			gp_vars.timerFuncs[i](gp_vars.timerData[i]);
	}
	
	return true;
}
/*********************************************************************************
Function:	mcWidgetUI()
Purpose:	Function to update the UI with the current pending alerts
Returns:	Nothing
Syntax:		Internal function.
*********************************************************************************/
function mcWidgetUI()
{
	var retVal = null;
	
	try
	{
		gp_mcwCount = g_ObjUIMgr.GetNumPendingAlerts(); 
		document.all.mcWidget.innerHTML = gp_mcwCount;				// Update widget UI
		retVal = true;
	}
	catch(e)
	{
	}
	
	return retVal;
		
}

/*********************************************************************************
Function:	mcWidgetOnClick()
Purpose:	MouseClick handler.  Jumps to MC.htm page on single & double clicks.
Returns:	Nothing
Syntax:		Internal function.
*********************************************************************************/
function mcWidgetOnClick()
{
	return PageLoad("mc.htm");
}

/*********************************************************************************
Function:	mcWidgetOnMouse(value,[elem],[msg]) - value is boolean
Purpose:	MouseOver handler function.  Sets alpha opacity to 100 on MouseOver &
			sets alpha opacity to 30 on MouseOut.  If passed the specified display
			object will be updated with a help message onMouseOver and erased 
			onMouseOut events.
Returns:	Nothing
Syntax:		Internal function.
*********************************************************************************/
function mcWidgetOnMouse(value,elem, msg)
{
	if (value)										// true is for onMouseOver
	{
		document.getElementById('mcWidget').className = 'Focus';
		if (msg & elem)
			;			// Placeholder
			
	}
	else											// false is for onMouseOut
	{
		document.getElementById('mcWidget').className = 'Normal';
		if (msg & elem)
			;			// Placeholder for object clearing
	}
}

/*********************************************************************************
Function:	CloseAddIn(addin)
Purpose:	Closes an AddIn.  Need to place this call in the onclose page handler
Returns:	Nothing
Syntax:		CloseAddIn('addin') pass the text name of the AddIn widget.  This must be 
			done so that memory is cleaned up after a page closes.
*********************************************************************************/
function CloseAddIn(addin)
{
	var retVal = null;
	switch(addin)
	{
		case 'mcWidget':
			{
				retVal = TimerStop(0);		// Will kill ALL timers
				break;
			}	
		default:
			//Alert('Attempted to close an unknown AddIn')
			break;
	}
	
	return retVal;
}
/*********************************************************************************
Function:	EnableAddIn(addin,show)
Purpose:	Starts an AddIn
Returns:	Nothing
Syntax:		EnableAddIn(addin,show) where 'addin' is the text name, and 'show' is boolean.
			Pass a true to enable the UI, or a false to disable it.
*********************************************************************************/
function EnableAddIn(addin,show)
{
	var retVal = null;
	
	try
	{
		eval(addin + '()');
		if (show == true)
			retVal = SetCSSAttribute(addin,'display','block');
		else
			retVal = SetCSSAttribute(addin,'display','none');
		
		if (retVal)
			retVal = TimerStart(1000,mcWidgetUI,null);
	}
	catch(e)
	{
		retVal = null;
		//alert('EnableAddIn(' + addin + ', ' + show + ') call failed!');
	}
	
	return retVal;

}
/*********************************************************************************
Function:	mcWidget()
Purpose:	Function creates CSS attributes to control widgets look and feel
Returns:	Nothing
Syntax:		Internal function.
*********************************************************************************/
function mcWidget()
{
	document.write('<A id="mcWidget" class="Normal" ');
		document.write('onClick=mcWidgetOnClick() ');
		document.write('onDblClick=mcWidgetOnClick() ');
		document.write('onMouseEnter=mcWidgetOnMouse(true) ');
		document.write('onMouseOut=mcWidgetOnMouse(false) ');
	document.write('>&nbsp;</A> ');

	document.all.mcWidget.innerHTML = '&nbsp;';
}

/*********************************************************************************
Function:	SetCSSAttribute(obj,attrib,value)
Purpose:	Function sets CSS attributes of widgets objects
Returns:	Nothing
Syntax:		Internal function.
*********************************************************************************/
function SetCSSAttribute(obj,attrib,value)
{
	var retVal = null;
	
	try
	{
		eval('document.all.' + obj + '.style.' + attrib + '=' + '\'' + value + '\'');
		retVal = true;
	}
	catch(e)
	{
		//alert('Bad function call - SetCSSAttribute(' + obj + ', ' + attrib + ', ' + value + ')');
	}
	
	return retVal;
}

