//
//	INTEL CONFIDENTIAL
//	Copyright (c) 2004-2006 Intel Corporation All Rights Reserved. 
//	The source code contained or described herein and all documents related to the source code (Material) are owned by Intel
//	Corporation or its suppliers or licensors. Title to the Material remains with Intel Corporation or its suppliers and licensors. The
//	Material contains trade secrets and proprietary and confidential information of Intel or its suppliers and licensors. The Material is
//	protected by worldwide copyright and trade secret laws and treaty provisions. No part of the Material may be used, copied,
//	reproduced, modified, published, uploaded, posted, transmitted, distributed, or disclosed in any way without Intels prior express
//	written permission.
//
//	No license under any patent, copyright, trade secret or other intellectual property right is granted to or conferred upon you by
//	disclosure or delivery of the Materials, either expressly, by implication, inducement, estoppel or otherwise. Any license under such 
//	intellectual property rights must be express and approved by Intel in writing.
//
//	Unless otherwise agreed by Intel in writing, you may not remove or alter this notice or any other notice embedded in Materials by
//	Intel or Intels suppliers or licensors in any way.  
//
//	FILENAME: global.js - Global defines and functions for the EF project
//
 
// data file defines
var g_OOBE = 0; //for oobe xml
var g_MAIN  = 1; //for main xml
var g_MESSAGE_CENTER = 2; //for message center xml
var g_ALERT = 3; //for alert xml file
var g_CONFIG = 4; // for ccu config file
var g_UIDATA = 5; // for ccu ui data file
var g_EFMAIN = 6; // for EF main file 
var g_OOBE_START = 7; // oobe start page
var g_PREVIOUS = 8; // what the user was previously doing
var g_CONSUM = 9; //for coumser xml
var g_SUPPORT_LOG = 10; //for support log xml
var g_NETWORK = 11; //network submenu
var g_DEVICES = 12;  //devices submenu
var g_MEDIA = 13; //media submenu
var g_SETTINGS = 14; //options submenu
var g_PDERROR = 15; // platform detection error page
var g_SWERROR = 16; // SW error detection  page
var g_SYSTEMS = 17; //systems submenu
var g_EXPLORE = 18; //explore submenu
var g_EULA = 19; // EULA page
var g_ALL = -1; // to update all data 
var g_NEW_ALL = 100; //test

//update plugin data 
var g_REMOVE = 10; //remove the plugin data from the xml

// OOBE status defines
var g_INCOMPLETE = 0; //oobe item not complete
var g_COMPLETE = 1; //oobe item complete
var g_SKIPPED = 2; //oobe item skipped
var g_RERUN = 3;    //oobe item reset

// Main page status defines
var g_NOT_VISIBLE = 0; //main item not visible
var g_VISIBLE = 1; //main item visible

// Message center alert status defines
var g_PENDING = 0; //alert status = new
var g_PROCESSED = 1; //alert status = fixed/viewed

// Sort type & direction defines - used by NotificationSettings.htm page
var g_SORT_SEVERITY = 1; // Should be the default sort order
var g_SORT_DATE = 2; // Alternate sort order
var g_SORTDIR =	1; // 1=Normal, -1=Reverse, Normal is default

// MessageCenter alert severity defines - used for sorting & page icons
var g_HELP = 0;
var g_ERR = 1;
var g_WARNING = 2;
var g_INFORMATION = 3;

// Cache hit/miss variables
var g_CACHED_PAGE = 0;

// Flash detection check
var g_FLASH_CHECK = null;

/******************************************************************************
INITIALIZATION SECTION
The global ActiveX objects and the shared objects for CCU are initialized here
to ensure that the HTML pages don't necessarily have to do it again. The HTML 
pages will need to include global.js file.
*******************************************************************************/

// Generate unique IDs for shared objects
var g_ObjIdUIMgr = GenerateSharedObjectID('CCU', 'UIMgr');
var g_ObjIdMSXML = GenerateSharedObjectID('CCU', 'MSXML');

// Get the shared object based on unique IDs
var g_ObjUIMgr = GetSharedObject(g_ObjIdUIMgr);
var g_ObjMSXML = GetSharedObject(g_ObjIdMSXML);

InitCCUSharedObjects();

/*********************************************************************************
Function:	InitCCUSharedObjects
Purpose:	Initializes global UIMgr and MSXML objects for use by the CCU pages.
Returns:	True if successful, False otherwise.
Usage:		InitCCUSharedObjects()
*********************************************************************************/
function InitCCUSharedObjects()
{
	var retVal = false;
	
	if (g_ObjUIMgr != null)
	{
		// Already initialized the global data, exit!
		retVal = true;
	}
	else
	{
		try
		{
			// Create the shared objects and populate the object frame data
			var UIMgr       = new ActiveXObject("CCU.CCU_UIManager");  
			var MSXML       = new ActiveXObject("Msxml2.FreeThreadedDOMDocument.4.0");

			CreateSharedObject(g_ObjIdUIMgr, UIMgr);
			CreateSharedObject(g_ObjIdMSXML, MSXML);

			// Make sure we can get the shared object we set above.
			g_ObjUIMgr = GetSharedObject(g_ObjIdUIMgr);
			g_ObjMSXML = GetSharedObject(g_ObjIdMSXML);
	  
			g_ObjUIMgr.Init("CCU");              // Must call init first!
			retVal = true;
  
		}
		catch(e)
		{
			// Ignore
		}
	}	
  
	return retVal;
}

/*********************************************************************************
Function:	ReturnToCCUOOBEPage
Purpose:	Validate and load the OOBE page
Returns:	Nothing
Usage:		ReturnToCCUOOBEPage()
*********************************************************************************/
function ReturnToCCUOOBEPage()
{
	return LoadPage('../ccu/OOBE.HTM');
}

/*********************************************************************************
Function:	ReturnToCCUMainPage
Purpose:	Validate and load the CCU settings/main page
Returns:	Nothing
Usage:		ReturnToCCUMainPage()
*********************************************************************************/
function ReturnToCCUMainPage()
{
	return LoadPage('../ccu/MAINccu.HTM');
}

/*********************************************************************************
Function:	ReturnToEFMainPage
Purpose:	Validate and load the EF Main page
Returns:	Nothing
Usage:		ReturnToEFMainPage()
*********************************************************************************/
function ReturnToEFMainPage()
{
	return LoadPage('../scripts/main.htm');
}

/*********************************************************************************
Function:	ReturnToCCUNotificationCenter
Purpose:	Validate and load the Notification Center
Returns:	Nothing
Usage:		ReturnToCCUNotificationCenter()
*********************************************************************************/
function ReturnToCCUNotificationCenter()
{
	return LoadPage('../ccu/mc.htm');	
}

/*********************************************************************************
Function:	ReturnToEFOptions
Purpose:	Return to the options page (settings category) of the control center
Returns:	Nothing
Syntax:		ReturnToEFOptions()
*********************************************************************************/
function ReturnToEFOptions()
{
	return LoadPage('../ccu/options.htm'); 
	//return LoadPage('../ccu/mainCCULaunch.htm?tCAT=settings');
}

/*********************************************************************************
Function: ReturnToManageConnections
Purpose:  Return to the options page (network category) of the control center
Returns:  Nothing
Syntax:   ReturnToManageConnections()
*********************************************************************************/
function ReturnToManageConnections()
{
	return LoadPage('../ccu/mainCCULaunch.htm?tCAT=network');
}

/******************************************************************************
Function:	LoadPDErrorPage
Purpose:	Load the error page for platform detection failures.
Returns:	Nothing
Syntax:		LoadPDErrorPage()
******************************************************************************/
function LoadPDErrorPage()
{
	return LoadPage('../ccu/pderror.htm');
}

/*********************************************************************************
Function:	ReturnToMCEHome
Purpose:	Returns to the start menu
Returns:	Nothing
Usage:		ReturnToMCEHome()
*********************************************************************************/
function ReturnToMCEHome()
{
	try
	{
		window.external.MediaCenter.NavigateToPage('{b8eac38a-7fb8-4559-84b5-42999c6864bd}', null);
		return true;
	}
	catch(e)
	{ 
		return false;
	}
}

/******************************************************************************
Function:	LoadPage
Purpose:	Validates the page and loads it. If page validation fails, this function
			load the error page.
Returns:	Nothing
Syntax:		LoadPDErrorPage()
******************************************************************************/
function LoadPage(url)
{
	var ret = false;
	
	try
	{
		ret = g_ObjUIMgr.IsPageValid(url);
		if(ret)
		{
			PageLoad(url);
		}
	}
	catch(e)
	{
		// do nothing
	}	
	
	if (!ret)
	{
		PageLoad('ccuErr8.htm');
	}
	
	return ret;
}

/*********************************************************************************
Function:	EnableMCECacheEvent
Purpose:	To enable MCE to trigger an event (onReturnFromMediaCenter event) if the
			page that is currently loading is cached by MCE.
Returns:	true/false based on success/failure
Syntax:		EnableMCECacheEvent()
*********************************************************************************/
function EnableMCECacheEvent()
{
	var retVal = true;
	try
	{
		window.external.MediaCenter.onReturnFromMediaCenter = CacheHit;
	}
	catch(e)
	{
		retVal = false;	
	}	
	
	return retVal;
}

/*********************************************************************************
Function:	CacheHit
Purpose:	Sets the cache hit variable to true. This function will be called by MCE if
			the page to be loaded is cached by MCE.
Returns:	TRUE
Syntax:		CacheHit()
*********************************************************************************/
function CacheHit()
{
	g_CACHED_PAGE = 1;
	return g_CACHED_PAGE;
}

/*********************************************************************************
Function:	ClearCache
Purpose:	Clears the cache hit variable. 
Syntax:		ClearCache()
*********************************************************************************/
function ClearCache()
{
	g_CACHED_PAGE = 0;
	return g_CACHED_PAGE;
}

/*********************************************************************************
Function:	DetectFlash
Purpose:	To detect if flash is installed on the system.
Returns:	true if installed, false otherwise.
Syntax:		DetectFlash()
*********************************************************************************/
function DetectFlash()
{
	var flashInstalled = false;
	var flashVersion = null;

	// Extensive check for different versions of flash
	try
	{
		// version will be set for 7.X or greater players
		var AXO = new ActiveXObject("ShockwaveFlash.ShockwaveFlash.7");
		flashVersion = AXO.GetVariable("$version");
	} 
	catch (e) { }
	
	// 6.X player
	if (!flashVersion)
	{
		try 
		{
			// version will be set for 6.X players only
			var AXO = new ActiveXObject("ShockwaveFlash.ShockwaveFlash.6");
			
			// throws if AllowScripAccess does not exist (introduced in 6.0r47)		
			AXO.AllowScriptAccess = "always";

			// safe to call for 6.0r47 or greater
			flashVersion = AXO.GetVariable("$version");

		} catch (e) { }
	}

	// 4.X or 5.x player
	if (!flashVersion)
	{
		try 
		{
			// version will be set for 4.X or 5.X player
			var AXO = new ActiveXObject("ShockwaveFlash.ShockwaveFlash.3");
			flashVersion = AXO.GetVariable("$version");
		} catch (e) { }
	}

	// 3.X player
	if (!flashVersion)
	{
		try 
		{
			// version will be set for 3.X player
			var AXO = new ActiveXObject("ShockwaveFlash.ShockwaveFlash.3");
			flashVersion = "WIN 3,0,18,0";
		} catch (e) { }
	}


	if (flashVersion != null)
	{
		flashInstalled = true;
	}

	FlashChecked(1);

	if (!flashInstalled)
	{
		LoadPage("../scripts/flashInstall.htm");
	}
	
	return flashInstalled;
}

/*********************************************************************************
Function:	FlashChecked
Purpose:	Checks if flash detection has been completed.
Returns:	Returns true if flash check is done, false otherwise.
Syntax:		FlashChecked(checked)
*********************************************************************************/
function FlashChecked(checked)
{
	g_FLASH_CHECK = 0;

	try
	{
		if (checked != null)
		{
			if (checked)
			{
				g_FLASH_CHECK = 1;
				g_ObjUIMgr.SetData("FlashDetected", "1");
			}
		}
		else 
		{
			var flashDetected = g_ObjUIMgr.GetData("FlashDetected");
			if (flashDetected != null)
			{
				g_FLASH_CHECK = flashDetected == "0" ? 0 : 1;
			}
		}	
	}
	catch(e)
	{ }

	return g_FLASH_CHECK;
} 

/*********************************************************************************
Function:	GetArg
Purpose:	Retrieves named arguments passed to the web page
Returns:	The argument value matching the argName passed
Syntax:		GetArg(argName) -- pass in argName key
*********************************************************************************/
function GetArg(argName)
{
	var args = PageGetArgs();
	if (argName && args)
	{
		if (args[argName])
		{
			myArg = args[argName];
		}
		else
		{
			args = PageGetArgs(); //works in framework
			myArg = args[argName];
		}
	}	
	
	return myArg;
}

//-------------------------------------------------------------------------------
//								SUPPORT PAGE
//-------------------------------------------------------------------------------

/******************************************************************************
Function:	GetSupportLinkStatus
Purpose:	Checks if the support link status is active or inactive.
Returns:	Active (1) or inactive state (0)
Syntax:		GetSupportLinkStatus(xmlDoc, nameTag) -- passes in XML Doc handle and the
			search node tag name. 
******************************************************************************/
function  GetSupportLinkStatus(xmlDoc,nameTag)
{
	var status = 0;
	
	if (xmlDoc && nameTag)
	{
		if ((L10NString(xmlDoc, nameTag)).toUpperCase() == "ACTIVE")
		{
			status = 1;
		}	
	}
	
	return status;
}

/******************************************************************************
Function:	GetSupportLink
Purpose:	Retrieves the support link from the XML Doc
Returns:	Support link string
Syntax:		GetSupportLink(xmlDoc, nameTag) -- passes in XML Doc handle and the
			search node tag name. 
******************************************************************************/
function GetSupportLink(xmlDoc,nameTag)
{
	var link = null;
	if (xmlDoc && nameTag)
		link = L10NString(xmlDoc, nameTag);
	
	return link;
}

/******************************************************************************
Function:	DisplaySupportLink
Purpose:	Sets the page location to the support link website
Returns:	Nothing
Syntax:		DisplaySupportLink(SupportLink) -- passes in the support link website 
******************************************************************************/
function DisplaySupportLink(SupportLink )
{
	var retVal = true;
	
	if (SupportLink)
		location = SupportLink ;
	else
		retVal = false;	
		
	return retVal;
}

//-------------------------------------------------------------------------------
//								PLATFORM DETECTION
//-------------------------------------------------------------------------------

/******************************************************************************
Function:	CheckPlatformReady
Purpose:	Checks for platform readiness. Returns true if ready, false otherwise.
Returns:	Nothing
Syntax:		CheckPlatformReady() 
******************************************************************************/
function CheckPlatformReady()
{
	var bPlatformReady = false;
	
	try
	{
		if (g_ObjUIMgr)
		{
			bPlatformReady = g_ObjUIMgr.IsPlatformReady();
		}
	}
	catch(e)
	{
		// Log?
	}
	
	return bPlatformReady;
}

//-------------------------------------------------------------------------------
//								EULA
//-------------------------------------------------------------------------------

/******************************************************************************
Function:	IsEULAAccepted
Purpose:	Checks the EULA acceptance status
Returns:	true, if EULA accepted. False, otherwise.
Syntax:		IsEULAAccepted()	 
******************************************************************************/
function IsEULAAccepted()
{
	var bStatus = false;
	
	try
	{
		if (g_ObjUIMgr)
		{
			bStatus = g_ObjUIMgr.IsEULAAccepted();
		}
	}
	catch(e)
	{
		// Log?
	}
	
	return bStatus;
}

/******************************************************************************
Function:	LaunchEULA
Purpose:	Launches the EULA page with the target page as parameter
Returns:	true if load page succeeded, false otherwise
Syntax:		LaunchEULA(targetPath) where targetPath represents the target page
			for EULA once the agreement has been accepted by the user.
******************************************************************************/
function LaunchEULA(targetPath)
{
	var bStatus = false;
	
	try
	{
		var eula = '../scripts/EULA.HTM#targetPAGE=';
		eula += targetPath; // append target path as parameter
		bStatus = LoadPage(eula);
	}
	catch(e)
	{
		// Log?
	}
	
	return bStatus;
}

/******************************************************************************
Function:	SetEULAStatus
Purpose:	Sets the EULA acceptance status (0 or 1)
Returns:	true if status is set successfully, false otherwise.
Syntax:		SetEULAStatus(status)	
******************************************************************************/
function SetEULAStatus(status)
{
	var bStatus = false;
	
	try
	{
		if (g_ObjUIMgr)
		{
			bStatus = g_ObjUIMgr.SetEULAStatus(status);
		}
	}
	catch(e)
	{
		// Log?
	}
	
	return bStatus;
}

//-------------------------------------------------------------------------------
//								OOBE
//-------------------------------------------------------------------------------

/*********************************************************************************
Function:	SetOOBETaskComplete
Purpose:	Sets the status of a particular oobe item to complete
Returns:	Nothing
Syntax:		SetOOBETaskComplete(plugin id, task id) -- pass in the plug in owner ID
			and the OOBE task id.
*********************************************************************************/
function SetOOBETaskComplete(plugin_id, task_id)
{
	var retVal = true;
	
	try
	{
		retVal = g_ObjUIMgr.SetStatus(g_OOBE, plugin_id, task_id, g_COMPLETE);
	}
	catch(e)
	{
		retVal = false;
	}	
	
	return retVal;
}

/*********************************************************************************
Function:	ResetAllOOBEItems
Purpose:	Resets all OOBE tasks so that it can be run again.
Returns:	Nothing
Syntax:		ResetAllOOBEItems()
*********************************************************************************/
function ResetAllOOBEItems()
{
	var retVal = true;
	try
	{
		g_ObjUIMgr.SetStatus(g_OOBE, "", g_ALL, g_RERUN);
		retVal = g_ObjUIMgr.ReturnToCCU(g_OOBE_START);
	}
	catch(e)
	{
		retVal = false;
	}	
	
	return retVal;
}

/*********************************************************************************
Function:	SetOOBETaskSkip
Purpose:	Sets the status of a particular oobe item to skipped
Returns:	Nothing
Syntax:		SetOOBETaskSkip(plugin id, oobe item id)
*********************************************************************************/
function SetOOBETaskSkip(plugin_id, task_id)
{
	var retVal = true;
	try
	{
		retVal = g_ObjUIMgr.SetStatus(g_OOBE, plugin_id, task_id, g_SKIPPED);
	}
	catch(e)
	{
		retVal = false;
	}	
	
	return retVal;
}

/*********************************************************************************
Function:	CloseMCEViewport
Purpose:	Closes the MCE viewport so it doesn't hide menus
Returns:	Nothing
Syntax:		CloseMCEViewport
*********************************************************************************/
function CloseMCEViewport()
{
	//close any media center viewports and stop any playback
	try
	{
		var MC = window.external.MediaCenter;
		MC.CustomViewPort.Visible = false;
		MC.SharedViewPort.Visible = false;
		if (MC.Experience.Type != 1) //if content type is not audio
		{
			MC.Experience.PlayRate=0; //stop
		}
	}
	catch (e) { /*Ignore*/ }

	return;
}

/******************************************************************************
Function:	IsOSUpgradeDetected
Purpose:	Checks to determine if the OS was upgraded to Vista
Returns:	true, if condition meets upgrade.
Syntax:		IsOSUpgradeDetected()
******************************************************************************/
function IsOSUpgradeDetected()
{
	var bStatus = false;
	
	try
	{
		if (g_ObjUIMgr)
		{
			bStatus = g_ObjUIMgr.IsOSUpgradeDetected();
		}
	}
	catch(e)
	{
		// Log?
	}
	
	return bStatus;
}

/******************************************************************************
Function:	DisplayOSUpgradedMsg
Purpose:	Notification to the user to upgrade Intel(R) Viiv(TM) Software
Returns:	none
Syntax:		DisplayOSUpgradedMsg()
******************************************************************************/
function DisplayOSUpgradedMsg()
{
	try
	{
		if (g_ObjUIMgr)
		{
			g_ObjUIMgr.DisplayOSUpgradedMsg();
		}
	}
	catch(e)
	{
		// Log?
	}
}
