//------------------------------------------------------------------------------
// keyboards.js - On screen keyboard widget, supporting multiple languages.
//
// INTEL CONFIDENTIAL
//	Copyright 2004-2005 Intel Corporation All Rights Reserved.  The source code
//	contained or described herein and all documents related to the source code
//	(Material) are owned by Intel Corporation or its suppliers or licensors.
//	Title to the Material remains with Intel Corporation or its suppliers and
//	licensors. The Material may contain trade secrets and 	proprietary and
//	confidential information of Intel Corporation and its 	suppliers and
//	licensors, and is protected by worldwide copyright and trade secret laws
//	and treaty provisions. No part of the Material may be used, copied,
//	reproduced, modified, published, uploaded, posted, transmitted, distributed,
//	or disclosed in any way without Intels prior express written permission. 
//	
//	No license under any patent, copyright, trade secret or other intellectual
//	property right is granted to or conferred upon you by disclosure or delivery
//	of the Materials, either expressly, by implication, inducement, estoppel or
//	otherwise. Any license under such intellectual property rights must be express
//	and approved by Intel in writing.
//
//	Unless otherwise agreed by Intel in writing, you may not remove or alter this
//	notice or any other notice embedded in Materials by Intel or Intels suppliers
//	or licensors in any way.
//
// Description:
//	LTD0
//
// Revision History:
//	0.90	In development
//	0.85	2004-12-25	Ecosystem Engineering Release
//------------------------------------------------------------------------------



//------------------------------------------------------------------------------
// CreateKeyboardXML - Create the keyboard keys from an XML file.
//------------------------------------------------------------------------------

function CreateKeyboardXML(keyboard, lang)
{
	try
	{
		var xmlDoc = new ActiveXObject("Msxml2.DOMDocument"); // .4.0");
		xmlDoc.async = false;
		xmlDoc.load('keyboard'+lang+'.xml');
		xmlDoc.setProperty("SelectionLanguage", "XPath");

		if (xmlDoc.parseError.errorCode != 0)
			return false;

		var normShiftUp = xmlDoc.selectNodes('/keyboard/norm/shift/up').item(0).text;
		var normShiftDn = xmlDoc.selectNodes('/keyboard/norm/shift/dn').item(0).text;
		var normKeysUp = xmlDoc.selectNodes('/keyboard/norm/keys/up').item(0).text;
		var normKeysDn = xmlDoc.selectNodes('/keyboard/norm/keys/dn').item(0).text;
		keyboard.keysNorm = [normShiftUp, normShiftDn, false,
				[[null, normKeysDn], [null, normKeysUp]]];

		var symbShiftUp = xmlDoc.selectNodes('/keyboard/symb/shift/up').item(0).text;
		var symbShiftDn = xmlDoc.selectNodes('/keyboard/symb/shift/dn').item(0).text;
		var symbKeysUp = xmlDoc.selectNodes('/keyboard/symb/keys/up').item(0).text;
		var symbKeysDn = xmlDoc.selectNodes('/keyboard/symb/keys/dn').item(0).text;
		keyboard.keysSymb = [symbShiftUp, symbShiftDn, false,
				[[null, symbKeysDn], [null, symbKeysUp]]];

		var alt = xmlDoc.selectNodes('/keyboard/alt');
		for (var i = 0; i < alt.length; i++)
		{
			var altShiftUp = alt.item(i).selectNodes('shift/up').item(0).text;
			var altShiftDn = alt.item(i).selectNodes('shift/dn').item(0).text;
			var altActiveUp = alt.item(i).selectNodes('active/up').item(0).text;
			var altActiveDn = alt.item(i).selectNodes('active/dn').item(0).text;
			var altKeysUp = alt.item(i).selectNodes('keys/up').item(0).text;
			var altKeysDn = alt.item(i).selectNodes('keys/dn').item(0).text;
			keyboard.keysAlt[keyboard.keysAlt.length] = [altShiftUp, altShiftDn, false,
					[[altActiveDn, altKeysDn], [altActiveUp, altKeysUp]]];
		}
	}
	catch(e)
	{
		return false;
	}

	return true;
}



//------------------------------------------------------------------------------
// CreateKeyboardENU - Create the ENU keyboard keys.
//------------------------------------------------------------------------------

function CreateKeyboardENU(keyboard)
{
	keyboard.keysNorm = ["CAPS", "CAPS", false,
			[[null, "abcdefghijklmnopqrstuvwxyz1234567890"],
			 [null, "ABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890"]]];
			
	keyboard.keysSymb = ["@#&",	"abc", false,
			[[null, ["/", "&#92;", "-", "+", "=", "_", ",", ".", ":", ";", "!", "?", "", "|", "&", "@", "#", "$", "", "", "", "%", "*", "<", ">", "(", ")", "[", "]", "{", "}", "~", "&#34;", "^", "`", "", "", "", "", ""]],
			 [null, ["/", "&#92;", "-", "+", "=", "_", ",", ".", ":", ";", "!", "?", "", "|", "&", "@", "#", "$", "", "", "", "%", "*", "<", ">", "(", ")", "[", "]", "{", "}", "~", "&#34;", "^", "`", "", "", "", "", ""]]]];
}



//------------------------------------------------------------------------------
// CreateKeyboard - LTD0
//
// Arguments:
//	parent		The heirarchical parent of this widget.
//	id			The ID of the widget's HTML element, null is OK.
//	lang		LTD0
//	action		LTD0
//
// Callback Functions:
//	action		Function to be called when action button is pressed.
//	data		Data to pass to each of the callback functions
//
// Example:
//	scroll = CreateKeyboard(parent, 'keyboard', lang);
//
// Keyboard Widget Attributes:
//	LTD0
//
// Returns the keyboard widget.
//------------------------------------------------------------------------------

function CreateKeyboard(parentWidget, id, lang, action, data, editBox)
{
	var keyboard = CreateWidget(parentWidget, id, true, 'div');

	keyboard.cbEdit = editBox;
	keyboard.cbKeypress = KeyboardKeypress;
	keyboard.navKeys = new Array();

	keyboard.keysNorm = null;
	keyboard.keysSymb = null;
	keyboard.keysAlt = new Array();


	if ((globalLang == 'ENU') || !CreateKeyboardXML(keyboard, globalLang))
		CreateKeyboardENU(keyboard);


	keyboard.tableShift = KeyboardCreateTable(keyboard, 1, 2);
   	keyboard.tableShift.navGrid[0][0].elem.width = '50%';
   	keyboard.tableShift.navGrid[0][1].elem.width = '50%';
	

	if (keyboard.keysAlt.length)
		keyboard.tableAlt = KeyboardCreateTable(keyboard, 1, keyboard.keysAlt.length);

	keyboard.tableKeys = KeyboardCreateTable(keyboard, 6, 8);

	KeyboardDisplayKeys(keyboard);	
	return keyboard;



	//--------------------------------------------------------------------------
	// KeyboardCreateTable - Create a table to organize the keys.
	//--------------------------------------------------------------------------

	function KeyboardCreateTable(keyboard, rows, cols)
	{
		var table = CreateTable(keyboard, null, rows, cols, null, null, true);
		table.elem.setAttribute('className', 'Keyboard');
		return table;
	}



	//--------------------------------------------------------------------------
	// KeyboardDisplayKeys - Initialize the set of keys being displayed.
	//--------------------------------------------------------------------------

	function KeyboardDisplayKeys(keyboard)
	{
		var caps = keyboard.keysNorm[2] ? 1 : 0;
		var keyset = keyboard.keysSymb[2] ? keyboard.keysSymb[3][caps] : keyboard.keysNorm[3][caps];

		keyboard.tableShift.keysRow = keyboard.tableShift.keysCol = 0;

		KeyboardDisplayKey(keyboard, keyboard.tableShift, keyboard.keysNorm[2]?keyboard.keysNorm[1]:keyboard.keysNorm[0], true, KeyboardKeyshift, keyboard.keysNorm);
		KeyboardDisplayKey(keyboard, keyboard.tableShift, keyboard.keysSymb[2]?keyboard.keysSymb[1]:keyboard.keysSymb[0], true, KeyboardKeyshift, keyboard.keysSymb);

	
		if (keyboard.keysAlt.length)
		{
			keyboard.tableAlt.keysRow = keyboard.tableAlt.keysCol = 0;
			for (var i = 0; i < keyboard.keysAlt.length; i++)
			{
				if (keyboard.keysAlt[i][2])
					keyset = keyboard.keysAlt[i][3][caps];
				KeyboardDisplayKey(keyboard, keyboard.tableAlt, keyboard.keysAlt[i][0], true, KeyboardKeyshift, keyboard.keysAlt[i]);
			}
		}
		

		keyboard.tableKeys.keysRow = keyboard.tableKeys.keysCol = 0;

		KeyboardDisplayKey(keyboard, keyboard.tableKeys, '&#9668;', true);
		KeyboardDisplayKey(keyboard, keyboard.tableKeys, ' ', true);
		
		for (var i = 0; i < keyset[1].length; i++)
		{
			var key;
			if (typeof keyset[1] == "string")
				key = keyset[1].charAt(i);
			else
				key = keyset[1][i];
			var active = (!keyset[0]) || (keyset[0].indexOf(key) >= 0);
			KeyboardDisplayKey(keyboard, keyboard.tableKeys, key, active);
		}

		while (keyboard.tableKeys.keysRow < keyboard.tableKeys.navRows)
			KeyboardDisplayKey(keyboard, keyboard.tableKeys, '', false);
	}



	//--------------------------------------------------------------------------
	// KeyboardDisplayKey - FOO
	//--------------------------------------------------------------------------

	function KeyboardDisplayKey(keyboard, table, inner, active, action, data)
	{
		var cell = table.navGrid[table.keysRow][table.keysCol];

		switch (inner)
		{
		case '&': inner = '&amp;'; break;
		case '<': inner = '&lt;'; break;
		case '>': inner = '&gt;'; break;
		}

		cell.elem.innerHTML = '<div class="GridCell">'+inner+'</div>';
		if (!active)
			cell.elem.className = 'Inactive';
		else if (cell.elem.className == 'Inactive')
			cell.elem.className = 'Normal';

		if (!cell.elem.width)
    		cell.elem.width = Math.floor(100 / table.navCols) + '%';
    		
    	cell.cbAction = action ? action : KeyboardKeyaction;
    	cell.cbData = data;
    	cell.navKeyboard = keyboard;
    	cell.navKeyLabel = inner;
    	WidgetSetNavigation(cell, inner ? (active ? 'leaf' : 'inactive') : 'skip');
    	
		if (++table.keysCol >= table.navCols)
		{
			++table.keysRow;
			table.keysCol = 0;
		}

	}



	//--------------------------------------------------------------------------
	// KeyboardKeyshift - FOO
	//--------------------------------------------------------------------------

	function KeyboardKeyshift(cell, data)
	{
		var keyboard = cell.navKeyboard;
		
		if (data == keyboard.keysNorm)
			keyboard.keysSymb[2] = false;
		else if (data == keyboard.keysSymb)
			keyboard.keysNorm[2] = false;
		
		var toggle = !data[2];
		for (var i = 0; i < keyboard.keysAlt.length; i++)
			keyboard.keysAlt[i][2] = false;
		data[2] = toggle;

		KeyboardDisplayKeys(keyboard);
	}
	
	
	
	//--------------------------------------------------------------------------
	// KeyboardKeyaction - FOO
	//--------------------------------------------------------------------------
	
	function KeyboardKeyaction(cell, keyboard)
	{
		var keyChar;

		switch (cell.navKeyLabel)
		{
		case '&amp;': keyChar = 0x26; break;
		case '&lt;': keyChar = 0x3C; break;
		case '&gt;': keyChar = 0x3E; break;
		case '&#9668;': keyChar = 8; break;
		default: keyChar = cell.navKeyLabel.charCodeAt(0);
		}
			
		KeyboardKeypress(cell.navKeyboard, keyChar, null);
	}



	//--------------------------------------------------------------------------
	// KeyboardKeypress - FOO
	//--------------------------------------------------------------------------
	
	function KeyboardKeypress(keyboard, keyChar, data)
	{
		var value = keyboard.cbEdit.navValue;


		var redraw = false;
		for (var i = 0; i < keyboard.keysAlt.length; i++)
		{
			if (keyboard.keysAlt[i][2])
				redraw = true;
			keyboard.keysAlt[i][2] = false;
		}
		if (redraw)
			KeyboardDisplayKeys(keyboard);
		
		
		if (keyChar == -1) /* Clear */
			value = '';

		else if (keyChar == 8) /* Backspace */
			value = value.substring(0, value.length-1);
			
		else if (keyChar == 0xA6)
			return false;

		else if (keyChar >= 31)
			value += String.fromCharCode(keyChar);
			

		EditBoxSetValue(keyboard.cbEdit, value);
		if (keyboard.cbAction)
			keyboard.cbAction(keyboard, keyboard.cbData);
			
		return true;
	}

}
