//------------------------------------------------------------------------------
// layout.js - Generates pages from an XML description of the layout.
//
// INTEL CONFIDENTIAL
//	Copyright 2004-2006 Intel Corporation All Rights Reserved.  The source code
//	contained or described herein and all documents related to the source code
//	(Material) are owned by Intel Corporation or its suppliers or licensors.
//	Title to the Material remains with Intel Corporation or its suppliers and
//	licensors. The Material may contain trade secrets and 	proprietary and
//	confidential information of Intel Corporation and its 	suppliers and
//	licensors, and is protected by worldwide copyright and trade secret laws
//	and treaty provisions. No part of the Material may be used, copied,
//	reproduced, modified, published, uploaded, posted, transmitted, distributed,
//	or disclosed in any way without Intels prior express written permission. 
//	
//	No license under any patent, copyright, trade secret or other intellectual
//	property right is granted to or conferred upon you by disclosure or delivery
//	of the Materials, either expressly, by implication, inducement, estoppel or
//	otherwise. Any license under such intellectual property rights must be express
//	and approved by Intel in writing.
//
//	Unless otherwise agreed by Intel in writing, you may not remove or alter this
//	notice or any other notice embedded in Materials by Intel or Intels suppliers
//	or licensors in any way.
//
// Description:
//	LTD0
//
// Left To Do:
//	LTD0
//
//------------------------------------------------------------------------------


//------------------------------------------------------------------------------
// Define the types of widget HTML element nodes we will be processing.
//------------------------------------------------------------------------------

var NODE_ELEMENT = 1; 
var NODE_ATTRIBUTE = 2;
var NODE_TEXT = 3; 
var NODE_CDATA_SECTION = 4; 



//------------------------------------------------------------------------------
// LayoutButtonAction - FOO
//------------------------------------------------------------------------------

function LayoutButtonAction(w, data)
{

	if (!data.indexOf('javascript:'))
	{
		var f = new Function(data.substring(11));
		f();
	}
	else
		PageLoad(data);
}



//------------------------------------------------------------------------------
// LayoutTranslate - Parse the XML tree and translate the given string.
//------------------------------------------------------------------------------

function LayoutTranslate(languageXML, lookup)
{
	var result = lookup;
	
	try
	{
		var select = languageXML.selectNodes('//string[name = "'+lookup+'"]/value');
		result = select.item(0).text;
	}
	catch(e) { }
	
	return result;
}



//------------------------------------------------------------------------------
// LayoutText - LTD0
//------------------------------------------------------------------------------

function LayoutText(languageXML, node)
{
	var inner = '';

	for (var i = 0; i < node.childNodes.length; i++)
	{
		var child = node.childNodes[i];

		if ((child.nodeType == NODE_TEXT) || (child.nodeType == NODE_CDATA_SECTION))
		{
			var value = child.nodeValue;
			var start, finish;
			
			while ((start = value.indexOf('@')) >= 0)
			{
				if (start)
					inner = inner + value.substring(0, start-1);
				value = value.substring(start+1, value.length);
				
				finish = value.indexOf(';');
				if (finish < 0)
					finish = value.length;


				var lookup = value.substring(0, finish);
				inner = inner + LayoutTranslate(languageXML, lookup);
				value = value.substring(finish+1, value.length);
			}
		
			inner = inner + value;
		}
	}
	
	return inner;
}



//------------------------------------------------------------------------------
// LayoutElement - FOO
//------------------------------------------------------------------------------
function LayoutElement(layout, node, languageXML, navParent)
{


	// LTD0	
	for (var i = 0; i < node.childNodes.length; i++)
	{
		var child = node.childNodes[i];
		if (child.nodeType == NODE_ELEMENT)
		{
			var widget = null;
			var id = child.getAttribute('id');

			if (layout[id])
				alert('ERROR: Duplicate ID = '+id);
				
			var focus = child.getAttribute('focus')=='true';
			switch (child.tagName)
			{
				case 'layout':
					widget = layout.body = CreateWidget(null, 'body', true);
					break;

				case 'page':
					if (!navParent.pages)
					{
						navParent.pages = CreateWidget(navParent, null, false, 'div');
						WidgetSetExclusive(navParent.pages, true);
					}
					widget = CreateWidget(navParent.pages, id, true, 'div');
					widget.elem.className = child.getAttribute('class');
					break;

				case 'dialog':
					widget = CreateDialog(navParent, id, '', '');
					break;

				case 'brand':
					widget = CreateBrand(navParent);
					break;

				case 'menu':
					if (!navParent.span)
						navParent.span = CreateWidget(navParent, null, false, 'div');
					var nowrap = (child.getAttribute('nowrap') == 'true');
					widget = CreateMenuPane(navParent.span, true, id, nowrap);
					break;

				case 'nav':
					var wrapper = navParent;
					if (child.getAttribute('type') == 'tiny')
					{
						wrapper = CreateWidget(navParent, null, 'div');
						wrapper.elem.className = 'FourButton';
					}
					widget = CreateNavPane(wrapper, false, id);
					break;

				case 'zone':
					widget = CreateInfoPane(navParent, false, id);
					widget.elem.className = 'ZonePane';
					break;

				case 'view':
					if (!navParent.views)
					{
						if (!navParent.span)
							navParent.span = CreateWidget(navParent, null, false, 'div');
						navParent.views = CreateWidget(navParent.span, null, true, 'div');
						WidgetSetExclusive(navParent.views, true);
					}
					widget = CreateViewPane(navParent.views, true, id);
					break;

				case 'info':
					widget = CreateInfoPane(navParent, false, id);
					break;
					
				case 'form':
					widget = CreateRadio(navParent, id, null, 0, null, null);
					break;

				case 'radio':
					var checked = (child.getAttribute('checked') == 'true');
					widget = CreateRadioButton(navParent, id, LayoutText(languageXML, child), checked, null, null);
					break;

				case 'title':
					var text = LayoutText(languageXML, child);
					widget = CreateTitle(navParent, text);
					if (id)
						widget.elem.setAttribute('id', id);
					navParent.navTitle = text;
					break;

				case 'subtitle':
					var text = LayoutText(languageXML, child);
					if (child.getAttribute('type') == 'help')
					{
						widget = CreateIconSubTitle(navParent, text);
						AddHelpIconToSubTitle(navParent);
					}
					else
						widget = CreateSubtitle(navParent, text);
					if (id)
						widget.elem.setAttribute('id', id);
					break;
				
				case 'subtitlehelpicon':
					widget = AddHelpIconToSubTitle(navParent);
					break;

				case 'button':
					var href = child.getAttribute('href');
					if (child.getAttribute('type') == 'help')
						widget = CreateHelpButn(navParent, id, href ? LayoutButtonAction : null, null, null, href);
					else
						widget = CreateButn(navParent, id, LayoutText(languageXML, child),
								href ? LayoutButtonAction : null, null, null, href);
					break;

				case 'grid':
					var rows = parseInt(child.getAttribute('rows'));
					var cols = parseInt(child.getAttribute('cols'));
					widget = CreateGrid(navParent, id, rows, cols, null, null, null, child.getAttribute('widths'));
					widget.viewCollapse = (child.getAttribute('collapse') == 'true');
					widget.viewEscape = (child.getAttribute('escape') == 'true');
					var align = child.getAttribute('align');
					if (align)
					{
						for (var row = 0; row < widget.navRows; row++)
							for (var col = 0; col < widget.navCols; col++)
								widget.navGrid[row][col].elem.align = align;
					}
					break;

				case 'scroll':
					var rows = parseInt(child.getAttribute('rows'));
					widget = CreateScroll(navParent, id, rows, null, null, null, null);
					widget.viewCollapse = (child.getAttribute('collapse') == 'true');
					widget.viewEscape = (child.getAttribute('escape') == 'true');
					break;

				case 'table':
					var rows = parseInt(child.getAttribute('rows'));
					var cols = parseInt(child.getAttribute('cols'));
					widget = CreateTable(navParent, id, rows, cols);
					break;
					
				case 'tree':
					var rows = parseInt(child.getAttribute('rows'));
					widget = CreateScroll(navParent, id, rows, null, null, null, null);
					widget.elem.className = 'Tree';
					widget.viewCollapse = (child.getAttribute('collapse') == 'true');
					widget.viewEscape = (child.getAttribute('escape') == 'true');
					break;

				case 'header':
					var text = LayoutText(languageXML, child);
					var align = child.getAttribute('align');
					if (navParent.header)
					{
						if (align)
							navParent.header.align = align;
						if (text)
							navParent.header.innerHTML = text;
					}
					break;

				case 'field':
					var text = LayoutText(languageXML, child);
					var width = child.getAttribute('width');
					var align = child.getAttribute('align');
					ScrollAddField(navParent, text, width, align);					
					break;

				case 'edit':
					widget = CreateEditBox(navParent, id, '', null, null, null); // FOO
					break;

				case 'keyboard':
					var edit = child.getAttribute('edit');
					widget = CreateKeyboard(navParent, id, globalLang, null, null,
							edit ? layout[edit] : null); // FOO
					break;

				case 'image':
					widget = CreateWidget(navParent, id, 'skip', 'img');
					var align = child.getAttribute('align');
					if (align)
						widget.elem.align = align;
					break;

				case 'stats':
					var auto = child.getAttribute('visible')=='auto';
					widget = CreateViewStats(navParent, id, auto);
					var text = LayoutText(languageXML, child);
					if (text)
						widget.label.innerHTML = text;
					break;

				case 'padding':
					var auto = child.getAttribute('visible')=='auto';
					widget = CreateWidget(navParent, id, 'div');
					widget.elem.className = 'ViewPadding';
					break;

				case 'label':
					widget = CreateWidget(navParent, id, 'skip', 'span');
					var text = LayoutText(languageXML, child);
					if (text)
						widget.elem.innerHTML = text;
					break;

				case 'text':
					var rows = parseInt(child.getAttribute('rows'));
					widget = CreateTextScroll(navParent, id, rows, null);
					break;


				case 'h1':
				case 'h2':
				case 'h3':
				case 'p':
				case 'b':
				case 'em':
				case 'ul':
				case 'ol':
				case 'li':
					widget = CreateText(navParent, child.tagName, LayoutText(languageXML, child));
					if (id)
						widget.elem.setAttribute('id', id);
					break;

				case 'div':
				case 'br':
					var vertical = (child.getAttribute('vertical')=='true');
					widget = CreateWidget(navParent, id, vertical, child.tagName);
					break;
									
				default:
					alert('ERROR: Unknown tag '+child.tagName);
					break;
			}


			if (widget)
			{
				if (child.getAttribute('visible')=='false')
					WidgetSetVisible(widget, false);
				if (child.getAttribute('exclusive')=='true')
					WidgetSetExclusive(widget, true);

				var reveal;
				if (reveal = child.getAttribute('reveal'))
				{
					var r = new Object();
					r.id = reveal;
					r.widget = widget;
					layout.reveals[layout.reveals.length] = r;
				}
			
				if (widget.elem.id)
				{
					layout[widget.elem.id] = widget;
					for (var j = 0; j < layout.reveals.length; j++)
					{
						if (layout.reveals[j].id == widget.elem.id)
							ToggleSetSticky(null, layout.reveals[j].widget, widget);
					}
				}

				LayoutElement(layout, child, languageXML, widget);
		
				if (focus || !navParent)
					WidgetSetFocus(widget);
			}
		}
	}	
}



//------------------------------------------------------------------------------
// CreateLayout - LTD0
//------------------------------------------------------------------------------

function CreateLayout(layoutXML, languageXML)
{
	var layout = new Object();
	layout.reveals = new Array();
	LayoutElement(layout, layoutXML, languageXML, null);
	return layout;
		
}


//------------------------------------------------------------------------------
// CreateLayoutPages - LTD0
//------------------------------------------------------------------------------

function CreateLayoutPages(layout, pageXML, languageXML)
{
	LayoutElement(layout, pageXML, languageXML, layout.body);
}


//------------------------------------------------------------------------------
// DestroyLayout - LTD0
//------------------------------------------------------------------------------
function DestroyLayout(layout)
{
	DestroyWidgets();
	layout = null;
}

