//------------------------------------------------------------------------------
// library.js - General library of useful stuff.
//
// INTEL CONFIDENTIAL
//	Copyright 2005-2006 Intel Corporation All Rights Reserved.  The source code
//	contained or described herein and all documents related to the source code
//	(Material) are owned by Intel Corporation or its suppliers or licensors.
//	Title to the Material remains with Intel Corporation or its suppliers and
//	licensors. The Material may contain trade secrets and 	proprietary and
//	confidential information of Intel Corporation and its 	suppliers and
//	licensors, and is protected by worldwide copyright and trade secret laws
//	and treaty provisions. No part of the Material may be used, copied,
//	reproduced, modified, published, uploaded, posted, transmitted, distributed,
//	or disclosed in any way without Intels prior express written permission. 
//	
//	No license under any patent, copyright, trade secret or other intellectual
//	property right is granted to or conferred upon you by disclosure or delivery
//	of the Materials, either expressly, by implication, inducement, estoppel or
//	otherwise. Any license under such intellectual property rights must be express
//	and approved by Intel in writing.
//
//	Unless otherwise agreed by Intel in writing, you may not remove or alter this
//	notice or any other notice embedded in Materials by Intel or Intels suppliers
//	or licensors in any way.
//
// Revision History:
//	0.90	In development
//	0.85	2004-12-25	Ecosystem Engineering Release
//------------------------------------------------------------------------------



//------------------------------------------------------------------------------
// Identify page as enabled for Media Center, avoids a warning dialog to user.
//------------------------------------------------------------------------------

function IsMCEEnabled()
{
    return true;
}



//------------------------------------------------------------------------------
// onScaleEvent - Keep the page sized automatically with the shell.  Always
// cause the first scale event to happen immediately, but if subsequent scale
// events are generated within 250ms compress them into a single change.
//------------------------------------------------------------------------------

var onScaleEventTimeout = 0;
var onScaleEventVScale = 0;
var cbOnAspectRatioEvent = null;

function onScaleEvent(vScale)
{
	onScaleEventVScale = vScale;
	if (!onScaleEventTimeout)
	{
		onScaleEventCallback();
		onScaleEventTimeout = setTimeout(onScaleEventCallback, 250);
	}
}

function onScaleEventCallback()
{
	if (onScaleEventVScale)
	{
		try
		{
			if (cbOnAspectRatioEvent)
				cbOnAspectRatioEvent(false);
			document.body.style.zoom = onScaleEventVScale;
			if (cbOnAspectRatioEvent)
				setTimeout("cbOnAspectRatioEvent(true)", 1);
		}
		catch(e) { }
	}
	
	onScaleEventTimeout = 0;
	onScaleEventVScale = 0;
}



//------------------------------------------------------------------------------
// PageGetArgs - Get the array of name/value search data pairs from the URL.
//------------------------------------------------------------------------------

function PageGetArgs(search)
{
	var args = new Object();
	
	if (!search)
		search = location.search;
	
	if (search.substr)
	{
		var input = unescape(search.substr(1));
		if (input)
		{
			var srchArray = input.split("&");
			var tempArray = new Array();
			for (var i = 0; i < srchArray.length; i++)
			{
				tempArray = srchArray[i].split("=");
				args[tempArray[0]] = tempArray[1];
			}
		}
	}
	
	return args;
}



//------------------------------------------------------------------------------
// PageGetArgument - Obtain a single argument from the URL parameter list.
//------------------------------------------------------------------------------

function PageGetArgument(argName)
{

	if (location.search.substr)
	{
		var input = unescape(location.search.substr(1));
		if (input)
		{
			var srchArray = input.split("&");
			var tempArray = new Array();
			for (var i = 0; i < srchArray.length; i++)
			{
				tempArray = srchArray[i].split("=");
				if (tempArray[0] == argName)
					return tempArray[1];
			}
		}
	}

	return null;
}	



//------------------------------------------------------------------------------
// PageCheckFrameset - Obsolete; no longer used.
//------------------------------------------------------------------------------

function PageCheckFrameset(frameset, page)
{
	return true;
}



//------------------------------------------------------------------------------
// PageURL - Break the URL down into its href, hash and search components.
//------------------------------------------------------------------------------

function PageURL(href)
{
	var url = new Object();
	url.href = href;
	url.hash = '';
	url.search = '';
		
	// Strip off the search string from the URL
	if ((index = url.href.indexOf('?')) >= 0)
	{
		url.search = url.href.substring(index);
		url.href = url.href.substring(0, index);
	}

	// Strip off the hash string from the URL
	if ((index = url.href.indexOf('#')) >= 0)
	{
		url.hash = url.href.substring(index);
		url.href = url.href.substring(0, index);
	}
	
	url.path = url.href.split('/');
	return url;	
}



//------------------------------------------------------------------------------
// PageLoad - Load a new page in the page frame.  If the page has changed, or
// if this PageLoadCallback method is not implemented, simple page load.
//
// If the PageLoadCallback function is implemented, this function converts the
// relative URLs to absolute URLs to help simplify processing in the urlFrame.
// These requests are bounced between urlFrame0.htm and urlFrame1.htm to work
// around a bug in IE where two pages with different arguments it considers the
// same page in its history mechanism - you can't go back to the first page.
//------------------------------------------------------------------------------

var pageUrlFrame = 0;
var pageUrlIframe = null;

function PageLoad(href, replace)
{
	var newLoc = PageURL(href);
	var currLoc = PageURL(unescape(location.href));

	if ((!newLoc.path.length) || (newLoc.path[0].indexOf(':') < 0))
	{ 

	
		// Remove the HTML file from the path; FOO
		// LTD: Situation where current location isn't a file it's a path (obscure)
		if (!newLoc.href)
			newLoc.path[0] = currLoc.path[currLoc.path.length-1];		
		currLoc.path.length = currLoc.path.length - 1;


		// Walk through the relative path and resolve using the absolute path
		for (var i = 0; i < newLoc.path.length; i++)
		{
			// Check for relative parent references
			if (newLoc.path[i] == '..')
			{
				if (currLoc.path.length && currLoc.path[currLoc.path.length-1])
					currLoc.path.length = currLoc.path.length-1;
			}
			
			// Otherwise append any path or file to the absolute path 
			else if (newLoc.path[i] != '.')
				currLoc.path[currLoc.path.length] = newLoc.path[i];
		}


		// Join the path back together, and append hash and search parts
		newLoc.href = currLoc.path.join('/');
		href = newLoc.href + newLoc.hash + newLoc.search;
	}



	if ((typeof PageLoadCallback == "function") && (newLoc.href == currLoc.href))
	{
		pageUrlFrame = pageUrlFrame ? 0 : 1;		
		var href = '../scripts/urlFrame'+pageUrlFrame+'.htm'+newLoc.hash+newLoc.search;
		if (!pageUrlIframe)
		{
			pageUrlIframe = document.createElement('<iframe src="'+href+'" scrolling="none" border="0" id="urlFrame" name="urlFrame" width="0%" height="0%" frameborder="0" style="border: 0;" />');
			document.body.appendChild(pageUrlIframe);
		}
		
		else if (replace)
			frames['urlFrame'].location.replace(href);
			
		else
			frames['urlFrame'].location = href;
	}
	
	else if (replace)
		location.replace(href);
		
	else
		location = href;

}



//============================= Persistent Values ==============================



//------------------------------------------------------------------------------
// LTD0
//------------------------------------------------------------------------------

var sessionManager = null;

function PageValueSet(key, value)
{
	try
	{
		if (!sessionManager)
		{
			InitSessionManager();
		}

		sessionManager.WriteSettings(key, value);
	}
	catch(e) { }
}

function PageValueGet(key)
{
	try
	{
		if (!sessionManager)
		{
			InitSessionManager();
		}

		return sessionManager.ReadSettings(key);
	}
	catch(e) { }		
	return '';
}

function InitSessionManager()
{
	var guid = "{8848B6F4-C0C9-11D9-8BDE-F66BAD1E3F3A}";
	var deviceID = '';
	
	try
	{
		deviceID = (window.external.MediaCenter && window.external.MediaCenter.XRemoting) ?
					window.external.MediaCenter.XRemoting.DeviceID : '';
	}
	catch(e) { }

	try
	{
		sessionManager = new ActiveXObject("IMSShellUtilities.SessionManager");
		sessionManager.Connect(guid, deviceID, guid);
	}
	catch(e)
	{
		sessionManager = null;
		throw e;
	}
}


//============================ L10N (Localization) =============================



//------------------------------------------------------------------------------
// L10NLoadStrings - Load the localization XML string file, check for errors.
//------------------------------------------------------------------------------

function L10NLoadStrings(href)
{
	var xmlDoc = new ActiveXObject("Msxml2.DOMDocument"); // .4.0");
	var namedNodeMap;
	xmlDoc.async = false;
	xmlDoc.load(href);
	xmlDoc.setProperty("SelectionLanguage", "XPath");

	// LTD1
	if (xmlDoc.parseError.errorCode != 0) {
		alert("errorCode: " + xmlDoc.parseError.errorCode + "\n" +
			"filepos: " + xmlDoc.parseError.filepos + "\n" +
	        "line: " + xmlDoc.parseError.line + "\n" +
	        "linepos: " + xmlDoc.parseError.linepos + "\n" +
	        "reason: " + xmlDoc.parseError.reason + "\n" +
	        "srcText: " + xmlDoc.parseError.srcText + "\n" +
	        "url: " + xmlDoc.parseError.url);
	}

	return xmlDoc;
}



//------------------------------------------------------------------------------
// L10NString - Get a localized string by name from the XML string file.  If
//  the string is not found an empty string is returned.
//------------------------------------------------------------------------------

function L10NString(xmlDoc, name)
{
	if (name)
	{
		try
		{
			var value = xmlDoc.selectNodes('//string[name = "'+name+'"]/value');
			return (value ? value.item(0).text : "");
		}
		catch(e)
		{
			// Name not found, ignore error
		}
	}
	
	return '';
}



//================================ Shared Data =================================



/*
 * The API below provides access to data stored by the shared data frame
 *
 * Example usage:
 *
 *   g_myWizObjId   = GenerateSharedObjectID('MyProduct', 'MyObjName');
 *   var g_myWizObj = GetSharedObject(g_myWizObjId);
 * 
 *   if (g_myWizObj != null)
 *   {
 *     // Already initialized the global data, exit!
 *	    return;
 *   }
 *
 *   // Create the shared objects and populate the object frame data
 *   var my_new_obj = new Object();
 * 
 *   my_new_obj.TestString = "My object data in the form of a string.";
 * 
 *   var shared_obj = CreateSharedObject(g_myWizObjId, my_new_obj);
 *   if (shared_obj == null)
 *   {
 *     // its not the end of the world, but we have a failure in creating
 *     // the requested shared object.
 *     alert("ERR: can't create shared object " + g_MyWizObjId);
 *     return;
 *   }
 *
 *   // Puting this down here, ensures we don't have an invalid shared object
 *   // from the get go.
 *   g_myWizObj = my_new_obj;
 *
 *   // Now you can use the shared data using the g_myWizObj variable.
 *
 */

// Global Variables

var globalSharedData = new Array();

function CheckSharedData()
{
	return true;
}



//------------------------------------------------------------------------------
// GenerateSharedObjectID -  Generates a unique string representing an object 
//   identifier.  If a duplicate Identifier already exists, it will return 
//   the unique string to be used in the following API.
//
// Arguments:
//  product_id    Unique identifier for any given product (3rd party or internal)
//  object_name   Name of the object unique to the product
//
//------------------------------------------------------------------------------

function GenerateSharedObjectID(product_id, object_name)
{
	var object_id;
	
	object_id = product_id + '_' + object_name;
	
	return object_id;
}



//------------------------------------------------------------------------------
// CreateSharedObject - Creates a shared object within the shared object 
// frame data space.
//   
// Returns null if the object id already exists.
//
//------------------------------------------------------------------------------

function CreateSharedObject(object_id, object_ptr)
{
	var ii;
	var obj_exists   = false;
	var deleted_objs = 0;

	if (!CheckSharedData())
		return null;
	
	var num_objects = globalSharedData.length;
	
	// Lets make sure an object doesn't exist already.
	for (ii = 0; ii < num_objects; ii++)
	{
		if (globalSharedData[ii] == null)
		{
			continue;
		}
		
		if (globalSharedData[ii].uid == object_id)
		{
			obj_exists = true;
			break;
		}
	}
	
	var new_object = null;
	if (obj_exists == false)
	{
		if (object_ptr == null)
		  return null;
		
		// Create a new object in the shared data list, and set its unique object id
		new_object = new Object();
		new_object.uid       = object_id;
		new_object.objHandle = object_ptr;
		
		// Add the new shared object to the list
		globalSharedData[num_objects++] = new_object;
	}
	
	return new_object;
}



//------------------------------------------------------------------------------
// GetSharedObject - Retrieves a shared object given a unique object identifier.
//
// Arguments:
//   object_id    Unique identifier for the object (from GenerateSharedObjectID).
//
// Returns a handle to the object handle passed during CreateSharedObject().
//
//------------------------------------------------------------------------------

function GetSharedObject(object_id)
{
	var ii;
	
	if (!CheckSharedData())
	{
		return null;
	}
	
	var num_objects = globalSharedData.length;
	
	for (ii = 0; ii < num_objects; ii++)
	{
		if (globalSharedData[ii] == null)
		{
			// Skip this entry it was deleted at some point.
			continue;
		}
		
		if (globalSharedData[ii].uid == object_id)
		{
			return globalSharedData[ii].objHandle;
		}
	}
	
	return null;
}



//------------------------------------------------------------------------------
// DeleteSharedObject - Removes a shared object from the shared data in the
// object frame data space.  Returns 0 on success, 1 if the object was not in
// the list and 2 for any unknown reason.
//
// Arguments:
//   object_id    Unique identifier for the object (from GenerateSharedObjectID).
//
//------------------------------------------------------------------------------

function DeleteSharedObject(object_id)
{
	var ii;
	var num_objects = globalSharedData.length;
	
	for (ii = 0; ii < num_objects; ii++)
	{
		if (globalsharedData[ii] == null)
		{
			// Skip this entry it was deleted at some point.
			continue;
		}
		
		if (globalSharedData[ii].uid == object_id)
		{
			try 
			{
				delete globalSharedData[ii];
				globalSharedData[ii] = null;
				ret_code = 0;
			}
			
			catch(error)
			{
				globalSharedData[ii] = null;
				ret_code = 2;
			}
			
			break;
		}
	}
	
	return 1;
}


//============================ Debug Capabilities ==============================



//------------------------------------------------------------------------------
// Define the types of XML/HTML nodes we will be processing.
//------------------------------------------------------------------------------

var NODE_ELEMENT = 1; 
var NODE_ATTRIBUTE = 2;
var NODE_TEXT = 3; 
var NODE_CDATA_SECTION = 4; 



//------------------------------------------------------------------------------
// DebugHTML - Dump a debug of the HTML structure in a separate window.
//------------------------------------------------------------------------------

var debugWindow = null;
var debugSkip = false;

function DebugHTML(skip)
{

	debugSkip = skip;
	if (!debugWindow || debugWindow.closed)
	{
		debugWindow = window.open('', 'debugWindow',
				'status,menubar,height=400,width=300,resizable,scrollbars');
		setTimeout('DebugHTMLDump()', 50);
	}
	else if (debugWindow.focus)
	{
		debugWindow.focus();
	}

}

function DebugHTMLDump(node, depth)
{
	if (!debugWindow)
		return;
		
	if (!node)
	{
		debugWindow.document.write('<html><head><title>Debug HTML</title></head>');
		DebugHTMLDump(document.body, 0);
		debugWindow.document.write('</html>');
		debugWindow.document.close();
	}
	
	else
	{
		var inner = '';
	
		if ((node.nodeType == NODE_TEXT) || (node.nodeType == NODE_CDATA_SECTION))
		{
			// FOO
		}


		// Element nodes are recursively parsed to build the XHTML text from the
		// XML source, including all attributes and children elements.
	
		if (node.nodeType == NODE_ELEMENT)
		{
			var tag = node.tagName;
			var i, id, space='';
			
			for (i = 0; i < depth*4; i++)
				space = space + '&nbsp;';
				
			debugWindow.document.write(space+'&lt;'+tag);
			id = node.getAttribute('id');
			if (id)
				debugWindow.document.write(' id="'+id+'"');
			if (node.className)
				debugWindow.document.write(' class="'+node.className+'"');
//			for (i = 0; i < node.attributes.length; i++)
//				debugWindow.document.write(' '+node.attributes(i).name+
//					'="'+node.attributes(i).text+'"');
			debugWindow.document.writeln('&gt;<br>');
		
			if (!(debugSkip && (node.tagName.toUpperCase()=='TABLE')))
			{
				var elem = node.childNodes;
				for (i = 0; i < node.childNodes.length; i++)
					DebugHTMLDump(node.childNodes[i], depth+1);
			}
				
			debugWindow.document.write(space+'&lt;/'+tag+'&gt;');
			if (id)
				debugWindow.document.write('&lt!-- '+id+' --&gt');
			debugWindow.document.write('<br>');
		}
	}

}
