//------------------------------------------------------------------------------
// network.js - Network discovery and mapping API.
//
// INTEL CONFIDENTIAL
//	Copyright 2004-2005 Intel Corporation All Rights Reserved.  The source code
//	contained or described herein and all documents related to the source code
//	(Material) are owned by Intel Corporation or its suppliers or licensors.
//	Title to the Material remains with Intel Corporation or its suppliers and
//	licensors. The Material may contain trade secrets and 	proprietary and
//	confidential information of Intel Corporation and its 	suppliers and
//	licensors, and is protected by worldwide copyright and trade secret laws
//	and treaty provisions. No part of the Material may be used, copied,
//	reproduced, modified, published, uploaded, posted, transmitted, distributed,
//	or disclosed in any way without Intels prior express written permission. 
//	
//	No license under any patent, copyright, trade secret or other intellectual
//	property right is granted to or conferred upon you by disclosure or delivery
//	of the Materials, either expressly, by implication, inducement, estoppel or
//	otherwise. Any license under such intellectual property rights must be express
//	and approved by Intel in writing.
//
//	Unless otherwise agreed by Intel in writing, you may not remove or alter this
//	notice or any other notice embedded in Materials by Intel or Intels suppliers
//	or licensors in any way.
//
// Revision History:
//	0.90	In development
//	0.85	2004-12-25	Ecosystem Engineering Release
//------------------------------------------------------------------------------



//------------------------------------------------------------------------------
// NetmapGetNetwork - Get an XML description of the network.  This returns an
//  XML object which contains the devices, network drives, shares, and
//  network attributes (wireless, IP address, etc.) for each device.  This is
//  intended to be used later by the network map widget, which allows the
//  caller to filter or modify what gets displayed on the map.  See also the
//  'network.dtd' document type description, and 'network.xml' example.
//------------------------------------------------------------------------------

function NetmapGetNetwork()
{
	try
	{
		xmlNetworkMapper = new ActiveXObject("IMSShellUtilities.NetworkMap");
		xmlNetwork = new ActiveXObject("Msxml2.DOMDocument"); // .4.0");
		xmlNetwork.async = false;
	 	xmlNetwork.resolveExternals= false; 
		xmlNetwork.validateOnParse = true; 

		var str;
		if (parent && parent.cachedNetmapXML)
			str = parent.cachedNetmapXML;
		else
		{
			str = xmlNetworkMapper.GetXmlString();
			if (parent)
				parent.cachedNetmapXML = str;
		}
		xmlNetwork.loadXML( str );

/*
		if (xmlNetwork.parseError.errorCode != 0) {
			alert("EXCEPTION: netmap\n" +
					"errorCode: " + xmlNetwork.parseError.errorCode + "\n" +
					"filepos: " + xmlNetwork.parseError.filepos + "\n" +
			        "line: " + xmlNetwork.parseError.line + "\n" +
			        "linepos: " + xmlNetwork.parseError.linepos + "\n" +
			        "reason: " + xmlNetwork.parseError.reason + "\n" +
			        "srcText: " + xmlNetwork.parseError.srcText + "\n" +
			        "url: " + xmlNetwork.parseError.url);
		}
*/
	}
	catch(e)
	{
		//alert('EXCEPTION: netmap\n' + e.description);
	}

	return xmlNetwork;
}



//------------------------------------------------------------------------------
// NetmapCreateWidget - Create a network map widget, which can take one of two
//  forms.  If the number of devices displayed in the map is small it will be
//  displayed in a large icon format with minimal text.  If the devices list is
//  large it will automatically switch to a smaller icon format and primarily
//  use text to communicate the details.  Should the total number of devices
//  exceed the height of the screen, it will create a grid area to display
//  the contents of the network map.
//
// Arguments:
//	parent		The heirarchical parent of this widget.
//	size		The number of devices to display on the screen at once.
//	action		LTD0
//	explore		LTD0
//
//------------------------------------------------------------------------------

function NetmapCreateWidget(parent, size, action, focus, update)
{
	if (!update)
		update = NetmapUpdate;

	var netmap = CreateGrid(parent, 'netMapScroll', 1, 4, NetmapUpdate, NetmapAction, null, 'equal');
	stats = CreateViewStats(parent, 'netMapStats', true);
	netmap.cbKeyStep = NetmapKeyStep;
	netmap.cbKeyPage = NetmapKeyPage;
	netmap.localhost = null;

	netmap.cbDeviceAction = action;
	netmap.cbDeviceFocus = focus;
	netmap.cbDeviceUpdate = update;

	for (var row = 0; row < netmap.navRows; row++)
		for (var col = 0; col < netmap.navCols; col++)
			netmap.navGrid[row][col].cbFocus = NetmapFocus;

	netmap.lineTop = CreateWidget(widgetNavRoot, null, false, 'div');
	netmap.lineTop.elem.className = "NetmapLineTop";
	netmap.lineTop.elem.style.display = 'none';
	netmap.lineBot = CreateWidget(widgetNavRoot, null, false, 'div');
	netmap.lineBot.elem.className = "NetmapLineBot";
	netmap.lineBot.elem.style.display = 'none';


	/* NOTE: DO NOT ACCESS DEVICES DIRECTLY!!! SUBJECT TO CHANGE!!! */
	netmap.devices = new Array();
	/* NOTE: DO NOT ACCESS DEVICES DIRECTLY!!! SUBJECT TO CHANGE!!! */


	NetmapDevicesReset(netmap);
	
	return netmap;
}



//------------------------------------------------------------------------------
// NetmapKeyStep - Switch grid navigation from vertical to horizontal.
//------------------------------------------------------------------------------

function NetmapKeyStep(netmap, step, vert)
{
	// Vertical navigation is allowed to leave the netmap
	if (vert)
		return false;

	// Are we stepping above the top of the netmap?
	var viewFirst = netmap.viewFirst + step;
	if (viewFirst < 0)
	{
		viewFirst = 0;
		if (!netmap.viewFirst)
			WidgetSetFocus(netmap.navGrid[0][0]);
	}


	// Are we stepping below the bottom of the netmap?
	if ((step>0) && (netmap.viewFirst + netmap.navRows*netmap.navCols >= netmap.viewTotal))
	{
		// Otherwise move the focus since we were already at the bottom by
		// figuring out which row/column are the last visible
		viewFirst = netmap.viewFirst;
		var viewLast = netmap.viewTotal-viewFirst-1;
		var viewRow = Math.floor(viewLast / netmap.navCols);
		WidgetSetFocus(netmap.navGrid[viewRow][viewLast - viewRow*netmap.navCols]);
	}
	
	
	// Update the current viewport with the new parameters
	if (viewFirst != netmap.viewFirst)
		GridSetViewport(netmap, viewFirst, netmap.viewTotal, netmap.viewCollapse);
	return true;
}



//------------------------------------------------------------------------------
// NetmapKeyPage - Switch from page to single, vertical to horizontal.
//------------------------------------------------------------------------------

function NetmapKeyPage(netmap, step)
{
	return netmap.cbKeyStep(netmap, step, false);
}



//------------------------------------------------------------------------------
// NetmapDevicesReset - Reset the list of device nodes displayed in the network
//  map.  This clears the list, and subequent calls to NetmapDevicesAppend()
//  must be made to populare the device list again.
//------------------------------------------------------------------------------

function NetmapDevicesReset(netmap)
{
	netmap.devices.length = 0;
	ScrollSetViewport(netmap, 0, 0);

}



//------------------------------------------------------------------------------
// NetmapDevicesAppend - Append the device nodes to the network map.  This
//  allows the caller to select the network devices to display and pass them
//  to this function.  For example, to include both the local host and all
//  external devices:
//
//		xmlNetwork = NetmapGetNetwork();
//		xmlNetwork.setProperty("SelectionLanguage", "XPath");
//	    xmlDeviceNodes = xmlNetwork.selectNodes("/network/localhost")
//		NetmapDevicesAppend(netmap, xmlDeviceNodes);
//	    xmlDeviceNodes = xmlNetwork.selectNodes("/network/device")
//		NetmapDevicesAppend(netmap, xmlDeviceNodes);
//
//------------------------------------------------------------------------------

function NetmapDevicesAppend(netmap, xmlDeviceNodes)
{
	var i;

		for (i=0; i<xmlDeviceNodes.length; i++)
			netmap.devices[netmap.devices.length] = NetmapCreateDevice(xmlDeviceNodes.item(i));

	ScrollSetViewport(netmap, 0, netmap.devices.length);
}




//========= INTERNAL CALLS - DO NOT USE ANY OF THIS - SUBJECT TO CHANGE ========



//------------------------------------------------------------------------------
// NetmapCreateAdapter - LTD0 - Internal call, do not use.
//------------------------------------------------------------------------------

function NetmapCreateAdapter(adapterNode)
{
	var adapter = new Object();

	try
	{
		adapter.ipv4 = (adapterNode.getElementsByTagName('ipv4')).item(0).text;
	}
	catch(e)
	{
		adapter.ipv4 = '0.0.0.0'; // LTD1 - Right error mode?
	}

	try
	{	
		adapter.mac = (adapterNode.getElementsByTagName('ipv4')).item(0).text;
	}
	catch(e)
	{
		adapter.mac = null;
	}
	
	return adapter;
}



//------------------------------------------------------------------------------
// NetmapCreateDrive - LTD0 - Internal call, do not use.
//------------------------------------------------------------------------------

function NetmapCreateDrive(driveNode)
{
	var drive = new Object();

	try
	{
		drive.localpath = (driveNode.getElementsByTagName('localpath')).item(0).text;
	}
	catch(e)
	{
		drive.localpath = 'error'; // LTD1 - Right error mode?
	}

	try
	{
		drive.remotehost = (driveNode.getElementsByTagName('remotehost')).item(0).text;
	}
	catch(e)
	{
		drive.remotehost = 'error'; // LTD1 - Right error mode?
	}

	try
	{
		drive.remotepath = (driveNode.getElementsByTagName('remotepath')).item(0).text;
	}
	catch(e)
	{
		drive.remotepath = 'error'; // LTD1 - Right error mode?
	}

	return drive;
}



//------------------------------------------------------------------------------
// NetmapCreateShare - LTD0 - Internal call, do not use.
//------------------------------------------------------------------------------

function NetmapCreateShare(shareNode)
{
	var share = new Object();

	try
	{
		share.name = shareNode.text;
	}
	catch(e)
	{
		share.name = 'error'; // LTD1 - Right error mode?
	}

	return share;
}



//------------------------------------------------------------------------------
// NetmapCreateDevice - LTD0 - Internal call, do not use.
//------------------------------------------------------------------------------

function NetmapCreateDevice(deviceNode)
{
	var device = new Object();
	var i;

	device.adapter = new Array();
	device.drive = new Array();
        device.share = new Array();
	device.type = new Array();
	device.description = '';
	device.localhost = (deviceNode.tagName == 'localhost');

	
	try
	{	
		device.name = (deviceNode.getElementsByTagName('name')).item(0).text;
	}
	catch(e)
	{
		device.name = "(error)"; // LTD1
	}


	try
	{	
		device.uid = (deviceNode.getElementsByTagName('uid')).item(0).text;
	}
	catch(e)
	{
		device.uid= "(error)"; // LTD1
	}

	try
	{	
		device.friendly = (deviceNode.getElementsByTagName('friendly')).item(0).text;
	}
	catch(e)
	{
		device.friendly = '';
	}

	try
	{	
		device.description = (deviceNode.getElementsByTagName('description')).item(0).text;
	}
	catch(e)
	{
		device.description = '';
	}

	try
	{	
		device.status = deviceNode.attributes.getNamedItem('status').value;
	}
	catch(e)
	{
		device.status = '';
	}


	try
	{
		var typeElem = deviceNode.getElementsByTagName('type');
		for (var i = 0; i < typeElem.length; i++)
		{
			var typeNode = typeElem.nextNode;
			device.type[device.type.length] = 
                            typeNode.attributes.getNamedItem('class').value;
		}

		// LTD: Need info from network mgt app about what type of device
		device.primaryType = device.type.length ? device.type[0] : 'desktop';
		switch (device.primaryType)
		{
		case 'desktop': break;
		case 'laptop': break;
		case 'router': break;
		default: device.primaryType = 'desktop';
		}
	}
	catch(e)
	{
	}


	try
	{	
		var adapterElem = deviceNode.getElementsByTagName('adapter');
		for (var i = 0; i < adapterElem.length; i++)
		{
			var adapterNode = adapterElem.nextNode;
			device.adapter[device.adapter.length] = NetmapCreateAdapter(adapterNode);
		}
	}
	catch(e)
	{
	}


	try
	{	
		var driveElem = deviceNode.getElementsByTagName('drive');
		for (var i = 0; i < driveElem.length; i++)
		{
			var driveNode = driveElem.nextNode;
			device.drive[device.drive.length] = NetmapCreateDrive(driveNode);
		}
	}
	catch(e)
	{
	}


	try
	{	
		var shareElem = deviceNode.getElementsByTagName('share');
		for (var i = 0; i < shareElem.length; i++)
		{
			var shareNode = shareElem.nextNode;
			device.share[device.share.length] = NetmapCreateShare(shareNode);
		}
	}
	catch(e)
	{
	}

	return device;
}



//------------------------------------------------------------------------------
// NetmapAction - LTD0 - Internal call, do not use.
//------------------------------------------------------------------------------

function NetmapAction(cell, data)
{
	var netmap = cell.navTable;
	if (netmap.cbDeviceAction)
	{
		var index = netmap.viewFirst + cell.navRow * netmap.navCols + cell.navCol;
		netmap.cbDeviceAction(netmap, netmap.devices[index]);
	}
}
	

		
//------------------------------------------------------------------------------
// NetmapFocus - LTD0 - Internal call, do not use.
//------------------------------------------------------------------------------

function NetmapFocus(cell, focus, data)
{
	var netmap = cell.navTable;
	var index = netmap.viewFirst + cell.navRow * netmap.navCols + cell.navCol;

	if (netmap.cbDeviceFocus)
		netmap.cbDeviceFocus(netmap, focus, netmap.devices[index]);

		
	// Adjust the position of the focus line
	netmap.lineTop.elem.style.display = focus ? 'block' : 'none';
	netmap.lineBot.elem.style.display = focus ? 'block' : 'none';

	if (focus)
	{
		var ofs = netmap.child[index-netmap.viewFirst];
		var lineWidth = Math.floor(ofs.offsetWidth/2) - netmap.lineTop.elem.offsetLeft;
		while (ofs)
		{
			lineWidth += ofs.offsetLeft;
			ofs = ofs.offsetParent;
		}
		
		netmap.lineTop.elem.style.width = lineWidth+'px';
	}
		
}



//------------------------------------------------------------------------------
// NetmapUpdate - LTD0 - Internal call, do not use.
//------------------------------------------------------------------------------

function NetmapUpdate(netmap, start, count)
{

	for (var i = start; i < count; i++)
	{
		var device = netmap.devices[netmap.viewFirst+i];
		var info = (device.friendly?device.friendly:device.name);
		info = info + '<div class="'+device.primaryType+'"></div>';
		
		if (netmap.cbDeviceUpdate)
			info = netmap.cbDeviceUpdate(netmap, device);

		netmap.child[i].innerHTML = info;
		netmap.child[i].align = 'center';
		//netmap.child[i].valign = 'top';
	}

}
