//------------------------------------------------------------------------------
// style.js - Style sheets, widgets, and remote control/mouse navigation.
//
// INTEL CONFIDENTIAL
//	Copyright (c) 2004-2006 Intel Corporation All Rights Reserved.  The source code
//	contained or described herein and all documents related to the source code
//	(Material) are owned by Intel Corporation or its suppliers or licensors.
//	Title to the Material remains with Intel Corporation or its suppliers and
//	licensors. The Material may contain trade secrets and 	proprietary and
//	confidential information of Intel Corporation and its 	suppliers and
//	licensors, and is protected by worldwide copyright and trade secret laws
//	and treaty provisions. No part of the Material may be used, copied,
//	reproduced, modified, published, uploaded, posted, transmitted, distributed,
//	or disclosed in any way without Intels prior express written permission. 
//	
//	No license under any patent, copyright, trade secret or other intellectual
//	property right is granted to or conferred upon you by disclosure or delivery
//	of the Materials, either expressly, by implication, inducement, estoppel or
//	otherwise. Any license under such intellectual property rights must be express
//	and approved by Intel in writing.
//
//	Unless otherwise agreed by Intel in writing, you may not remove or alter this
//	notice or any other notice embedded in Materials by Intel or Intels suppliers
//	or licensors in any way.
//
// Left To Do:
//	LTD0	Documentation
//	LTD1	Localization: Choose UTF-8 or UTF-16, figure out if charset needed
//	LTD2	Not happy with CreateHead - suggestions?
//	LTD3	Fix page up/down with remote
//	LTD4	Add any missing keycodes for remote that shouldn't go to cbKeypress
//
// Revision History:
//	0.90	In development
//	0.85	2004-12-25	Ecosystem Engineering Release
//	0.52	2004-09-03	DPO: Combine widget+HTML elem DOM object, API changes!
//	0.45	2004-08-17	DPO: Page up/down, more documentation.
//	0.44	2004-08-16	DPO: Scroll widget with navigation + auto redraw.
//	0.43	2004-08-12	DPO: Grid widget, table widget, more nav work.
//	0.42	2004-08-11	DPO: Simplified navigation, added scroll widget.
//  0.35	2004-08-09	DPO: Initial revision, basic testing complete.
//------------------------------------------------------------------------------



//------------------------------------------------------------------------------
// globalXXX - Set the default language, direction and stylesheet.
//------------------------------------------------------------------------------

var globalLang = 'ENU';
var globalDir = 'LTR';
var globalStyle = 'stylesheets.dll';
var globalRegPath = 'SOFTWARE\\Intel\\IntelDH';

// Load the object resource manager to read system settings.
try
{
	var objResMgr = new ActiveXObject("CCU_ResMgr.CCU_ResManager");
	globalLang = objResMgr.GetEFRegistryLocale(globalRegPath, 'language');
	globalDir = objResMgr.GetEFLanguageDirection(globalLang);
	objResMgr = null;
}
catch (e) { }

function GlobalLang() { return globalLang; }
function GlobalDir() { return globalDir; }
function GlobalStyle() { return globalStyle; }



//------------------------------------------------------------------------------
// widgetNavXXX - Various global variables used to generate remember widget
// navigation state, focus style options, etc.
//------------------------------------------------------------------------------

var widgetNavFocus = null;
var widgetNavSticky = null;
var widgetNavPress = 0;
var widgetNavRoot = null;
var widgetNavIndex = new Array();
var widgetNavInput = null;
var widgetNavStyle = null;
var widgetArray = new Array();
var widgetMouseIgnore = false;
var widgetMouseTimeout = null;


//------------------------------------------------------------------------------
// CreateHead - Create the HTML head block and set up language, text direction,
// charset, default style sheet, and any application specific head.  If the
// current page is not properly frame then reload within the frameset.  Check
// for a user selected style sheet to override the default, if any.
//
// Arguments:
//	head		LTD2
//------------------------------------------------------------------------------

function CreateHead(head, style, folder)
{
	cbOnAspectRatioEvent = WidgetOnAspectRatioEvent;

	// Override the global style, if requested
	if (style)
		globalStyle = style;


	// LTD1: Choose UTF-8 or UTF-16
	document.write('<html lang="'+globalLang+'" dir="'+globalDir+'">');
	document.write('<head>');

	// Convert the stylesheet DLL into an absolute resource path
	if (!(widgetNavStyle = folder))
	{
		var nPos = location.pathname.indexOf(":/");
		if(nPos > 1)
		{
			var sPath = location.pathname.substr(1, location.pathname.length); 
			var abs = sPath.split('/');		
			abs[abs.length-2] = 'scripts';
			abs[abs.length-1] = globalStyle;		
			widgetNavStyle = 'res://' + abs.join('\\');
		}
		else
		{
			var abs = location.pathname.split('\\');
			abs[abs.length-2] = 'scripts';
			abs[abs.length-1] = globalStyle;
			widgetNavStyle = 'res:/' + abs.join('\\');
		}
	}
	

	// Load the base stylesheet
	document.write('<link id="basicStyle" rel="stylesheet" type="text/css" '+
			'media="all" href="'+widgetNavStyle+'/style.css">');
	
	// Load the right-to-left overrides if needed
	if (globalDir == 'RTL')
		document.write('<link id="basicStyle" rel="stylesheet" type="text/css" '+
				'media="all" href="'+widgetNavStyle+'/style_rtl.css">');				

	// Load the language specific overrides
	document.write('<link id="basicStyle" rel="stylesheet" type="text/css" '+
			'media="all" href="'+widgetNavStyle+'/'+globalLang+'.css">');


	// LTD1: charset needed?
	document.write('<meta http-equiv="Content-Type" content="text/html; charset=ISO-8859-1">');
		
	if (head)
		document.write(head);

	document.write('</head>');	
}



//------------------------------------------------------------------------------
// getNavWidget - Helper function to lookup widget by index.
//------------------------------------------------------------------------------

function getNavWidget(widget_index)
{
  return widgetNavIndex[widget_index];
}

 

//------------------------------------------------------------------------------
// WidgetGetImage - Get an image from the DLL being used by our stylesheet.
//------------------------------------------------------------------------------

function WidgetGetImage(name)
		{ return widgetNavStyle+'/'+name; }
		
		
		

//------------------------------------------------------------------------------
// WidgetTextRegTM - Some fonts don't correctly superscript the circle-r
// character.  Subvert usage of the CSS to define a style to accomplish this.
//------------------------------------------------------------------------------

function WidgetTextRegTM(text)
{
	var r = new RegExp(unescape("%ae"), "g");
	text = text.replace(r, '<span class="RegTM">&reg;</span>');
	text = text.replace(/&reg;/g, '<span class="RegTM">&reg;</span>');
	return text;
}



//============================= Widget Navigation ==============================



//------------------------------------------------------------------------------
// SKIP_xxx - Define masks to set and clear the widget navSkip flag.  
//------------------------------------------------------------------------------

var SKIP_ALWAYS = 0x0001;
var SKIP_INVISIBLE = 0x0002;
var SKIP_INACTIVE = 0x0004;



//------------------------------------------------------------------------------
// WidgetSetNavigation - Set the widget's navigation attributes.  This can
// the navigation direction (vertical/horizontal) or other options.
//
// Arguments:
//	widget		Widget to include in navigation.
//	vert		True for vertical navigation, false for horizontal navigation.
//				Using 'leaf' means this widget can take navigation focus.
//				Using 'skip' causes this widget to be skipped entirely.
//
// Public Attributes:
//	navVert		True for vertical navigation, false for horizontal navigation.
//	navLeaf		True if this widget is a leaf node; do not navigate deeper.
//	navSkip		True if this widget should be skipped for navigation.
//	navCurr		Tracks the most recently focused child widget.
//
//------------------------------------------------------------------------------

function WidgetSetNavigation(widget, vert)
{
	// Initialize this widget's navigation attributes
	widget.navVert = vert ? true : false;
	widget.navLeaf = (vert == 'leaf') ? true : false;
	widget.navSkip = (vert == 'skip') ? SKIP_ALWAYS : (vert == 'inactive' ? SKIP_INACTIVE : 0);
	widget.navCurr = null;


	// Turn off mouse navigation by default
	widget.elem.onclick = null;
	widget.elem.onmouseover = null;
	

	// If the widget is a navigatable leaf widget, make sure it is
	// easily indexable for quick onclick/onmouseover events
	if (vert == 'leaf')
	{
		if (!widget.elem.widgetIndex)
		{
			widget.elem.widgetIndex = widgetNavIndex.length;
			widgetNavIndex[widgetNavIndex.length] = widget;
		}

		widget.elem.onclick = WidgetMouseClick;
		widget.elem.onmouseover = WidgetMouseOver;

		if (widget.navActive && (widget.elem.className == 'Inactive'))
			widget.elem.className = 'Normal';
	}
	
	
	// If the widget is now inactive, make sure we get the right visual
	// style applied to buttons and other widgets
	if (vert == 'inactive')
	{
		if (widget.navActive)
			widget.elem.className = 'Inactive';
	}
}



//------------------------------------------------------------------------------
// WidgetSetVisible - Make a widget visbible or invisible by setting
// the HTML display style; invisible widgets are skipped over by navigation.
//
// This also provides the 'exclusive' option to set all sibling navigation
// elements as invisible, which is useful for tabbed displays.
//
// Arguments:
//	widget		Widget to set as visible or invisible.
//	visible		Set false, true or 'exclusive' to affect its siblings.
//------------------------------------------------------------------------------

function WidgetSetVisible(widget, visible)
{

	// If exclusive, make all the widget's siblings invisible
	if (widget.navParent && ((visible == 'exclusive') ||
			(visible && widget.navParent.navExclusive)))
	{
		for (var i = 0; i < widget.navParent.navChild.length; i++)
			if (!(widget.navParent.navChild[i].navSkip & SKIP_INVISIBLE))
				WidgetSetVisible(widget.navParent.navChild[i], false);
		
		// If we are replacing views or pages, delay mouse event handling so
		// that any default focus isn't lost.
		WidgetMouseDelay();
	}

	// Make the widget visible or invisible through its style attributes
	widget.elem.style.display = (visible?(widget.navBlock?'block':'inline'):'none');
	widget.elem.style.visibility = visible ? 'visible' : 'hidden';

	// Set or clear the field navigation skip field as needed
	if (visible)
	{
		widget.navSkip = widget.navSkip & ~SKIP_INVISIBLE;
		if (widget.navTitle)
		{
			document.title = widget.navTitle;
		}
	}
	else
		widget.navSkip = widget.navSkip | SKIP_INVISIBLE;


	// LTD0
	if (widgetNavFocus && !visible)
	{
		var haveFocus = false;
		var focus = widgetNavFocus;
		while (focus && (focus.navParent != widget.navParent))
		{
			if (focus == widget)
				haveFocus = true;
			focus = focus.navParent;
		}

		if (haveFocus)
		{
			widgetNavFocus = null;
			WidgetSetFocus(widgetNavRoot);
		}
	}
			
}	



//------------------------------------------------------------------------------
// WidgetSetExclusive - Make a widget 'exclusive' meaning only exactly one of
// its children may be visible at any time.  Calls to WidgetSetVisible() will
// check this flag, and make sure this is enforced.
//
// Arguments:
//	widget		Widget to set as visible or invisible.
//	exclusive	True or false.
//------------------------------------------------------------------------------

function WidgetSetExclusive(widget, exclusive)
{
	widget.navExclusive = exclusive ? true : false;
}	



//------------------------------------------------------------------------------
// WidgetSetFocus - Make the widget the current visual focus by setting its
// style class.  If the widget isn't a leaf this recursively searches for a
// child widget which is; once a leaf is found we trace backwards through its
// heirarchy to insure it's visible and to set navCurr correctly.
//
// Arguments:
//	widget		Widget to set current focus on.
//
// Returns true if focus was set, false if no change was made.
//------------------------------------------------------------------------------

function WidgetSetFocus(widget)
{

	// Do not try to navigate through non-element nodes
	if ((!widget) || widget.navSkip)
		return false;


	// Recursively walk down the heirarchy to find a focus leaf widget.
	if (!widget.navLeaf)
	{
		// Try the currently focused widget...
		if (widget.navCurr && WidgetSetFocus(widget.navCurr))
			return true;
			
		// Then iterate through all of the other children...
		for (var i = 0; i < widget.navChild.length; i++)
			if ((widget.navCurr != widget.navChild[i]) &&
					WidgetSetFocus(widget.navChild[i]))
				return true;

		// No visible leaf was found; return failure
		return false;
	}


	// Walk up the heirarchy of navigation parents checking to see that
	// all elements are visible, and to set the current navigation widget
	var skip = widget;
	var keypress = null;
	while (skip)
	{
		if (skip.navSkip)
			return false;
		if (skip.cbKeypress && !keypress)
			keypress = skip;
			
		var navParent = skip.navParent;
		if (navParent)
			navParent.navCurr = skip;
		skip = navParent;
	}



	// Remove focus style from the currently focused widget
	if (widgetNavFocus)
	{
		if (widgetNavFocus == widgetNavSticky)
			widgetNavFocus.elem.className = 'Sticky';
		else
			widgetNavFocus.elem.className = 'Normal';
		if (widgetNavFocus.cbFocus)
			widgetNavFocus.cbFocus(widgetNavFocus, false, widgetNavFocus.cbData);
	}


	// Apply focus style to the newly focused widget
	widgetNavFocus = widget;
	widgetNavInput = keypress;
	if (widgetNavFocus)
	{
		// Set focus to underlying DOM element
		widgetNavFocus.elem.focus();

		if (widgetNavFocus.navToggleView)
		{
			if (widgetNavSticky)
			{
				widgetNavSticky.elem.className = 'Normal';
				WidgetSetVisible(widgetNavSticky.navToggleView, false);
			}
			widgetNavSticky = widgetNavFocus;
			WidgetSetVisible(widgetNavSticky.navToggleView, true);
		}

		widgetNavFocus.elem.className = widgetNavFocus.navExplore ? 'Explore' : (widgetNavPress ? 'Press' : 'Focus');
		widgetNavPress = 0;
					
		if (widgetNavFocus.cbFocus)
			widgetNavFocus.cbFocus(widgetNavFocus, true, widgetNavFocus.cbData);
	}

	return true;
}



//------------------------------------------------------------------------------
// WidgetKeyStep - Recursively walk up the widget tree looking for the next
//  silbling widget in the navigation direction (lt/rt/up/dn) which is visible.
//  Call WidgetSetFocus() when one is found to change focus. 
//
// Arguments:
//	widget		The widget to begin navigating from, usually 'widgetNavFocus'.
//	step		-1 (lt/up) or +1 (rt/dn)
//	vert		true (up/dn) or false (lt/rt)
//------------------------------------------------------------------------------

function WidgetKeyStep(widget, step, vert)
{
	
	// Do not try to navigate through non-element nodes
	if ((!widget) || widget.navSkip)
		return false;


	// Insure we have a currently focused widget
	if (!widget.navCurr)
		widget.navCurr = widget.navChild[0];


	// If there is an explore callback function, redirect right arrow presses
	if ((!vert) && (step == 1) && widget.cbExplore &&
			widget.cbExplore(widget, widget.cbData))
		return true;


	// If there is a navigation function, see if it takes care of navigation
	if (widget.cbKeyStep && widget.cbKeyStep(widget, step, vert))
		return true;

	
	// If the direction matches, see if we can navigate to one of our children
	if ((vert == widget.navVert) && widget.navCurr)
	{
		var index = widget.navCurr.navChildIndex + step;
		while ((index>=0) && (index < widget.navChild.length))
		{
			if (WidgetSetFocus(widget.navChild[index]))
				return true;
			index = index + step;
		}
	}


	// No visible child widget found, check the parent
	if (widget.navParent)
		return WidgetKeyStep(widget.navParent, step, vert);

	
	return false;
}



//------------------------------------------------------------------------------
// WidgetKeyStepWrap - Have widget navigation wrap around; intended to be used
// as a cbKeyStep callback function to override the default behavior.
//------------------------------------------------------------------------------
		
function WidgetKeyStepWrap(widget, step, vert)
{
	if ((vert != widget.navVert) || !widget.navCurr)
		return false;
		
	var index = widget.navCurr.navChildIndex;
	do
	{
		index = index + step;
		if (index < 0)
			index = widget.navChild.length-1;
		else if (index >= widget.navChild.length)
			index = 0;
		
	} while (!WidgetSetFocus(widget.navChild[index]));
		
	return true;
}



//------------------------------------------------------------------------------
// WidgetKeyPage - Recursively walk up the widget tree looking for someone to
// handle page up/page down key press.  Do nothing if nobody wants it.
//------------------------------------------------------------------------------

function WidgetKeyPage(widget, step)
{
	while (widget && !widget.cbKeyPage)
		widget = widget.navParent;
		
	if (!widget)
		return false;
		
	widget.cbKeyPage(widget, step);
	return true;
}



//------------------------------------------------------------------------------
// WidgetKeyAction - Recursively walk up the widget tree looking for someone
// to handle action key press.  Do nothing if nobody wants it.
//------------------------------------------------------------------------------

function WidgetKeyAction(widget)
{
	if (widgetNavFocus)
	{
		widgetNavPress = setTimeout(WidgetKeyRelease, 400);
		WidgetSetFocus(widgetNavFocus);
	}

	while (widget && (widget.navSkip || !widget.cbAction))
		widget = widget.navParent;
		
	if (!widget)
		return false;

	widget.cbAction(widget, widget.cbData);
	return true;
}

function WidgetKeyRelease()
{
	WidgetSetFocus(widgetNavFocus);
}



//------------------------------------------------------------------------------
// WidgetKeyExplore - Recursively walk up the widget tree looking for someone
// to handle action key press.  Do nothing if nobody wants it.
//------------------------------------------------------------------------------

function WidgetKeyExplore(widget)
{
	while (widget && (widget.navSkip || !widget.cbExplore))
		widget = widget.navParent;
		
	if (!widget)
		return false;
		
	return widget.cbExplore(widget, widget.cbData);
}



//------------------------------------------------------------------------------
// WidgetMouseXXX - Handle the mouse events.
//------------------------------------------------------------------------------

function WidgetMouseOver()
{ 
	if (widgetMouseIgnore) 
		return; 
	var focus = widgetNavIndex[this.widgetIndex]; 
	if (focus != widgetNavFocus) 
		WidgetSetFocus(focus);
}

function WidgetMouseClick()
		{ WidgetKeyAction(widgetNavIndex[this.widgetIndex]); }

function WidgetMouseUp()
		{ WidgetKeyPage(widgetNavIndex[this.widgetIndex], -1); }

function WidgetMouseDn()
		{ WidgetKeyPage(widgetNavIndex[this.widgetIndex], +1); }

function WidgetMouseDelay()
{
	widgetMouseIgnore = true;
	if (!widgetMouseTimeout)
		// Only set this timeout once, until it is executed.
		widgetMouseTimeout = setTimeout(WidgetMouseRestore, 300);
}

function WidgetMouseRestore()
{
	widgetMouseIgnore = false;
	widgetMouseTimeout = null;
}

//------------------------------------------------------------------------------
// WidgetStatsEnter/Leave - Manage the stats up/down arrow highlighting.
//------------------------------------------------------------------------------

function WidgetStatsEnter()
{
	this.widgetFocus = true;
	switch (this.className)
	{
	case 'arrowUp_normal': this.className = 'arrowUp_focus'; break;
	case 'arrowDn_normal': this.className = 'arrowDn_focus'; break;
	}
}

function WidgetStatsLeave()
{
	this.widgetFocus = false;
	switch (this.className)
	{
	case 'arrowUp_focus': this.className = 'arrowUp_normal'; break;
	case 'arrowDn_focus': this.className = 'arrowDn_normal'; break;
	}
}



//------------------------------------------------------------------------------
// onRemoteEvent - Process the remote control or keyboard control input events.
// This returns true if the keypress was handled, false if nobody handled it.
// 
// If we have a widget keypress handler it only gets 0x8 (backspace).  All
// other key press events get routed through the onKeyPress() function.
//
//------------------------------------------------------------------------------

function onRemoteEvent(keyCode)
{

	try
	{
		if (!keyCode)
			keyCode = window.event.keyCode;
		switch (keyCode)
		{
			case 0x26:  // Up button selected
				WidgetKeyStep(widgetNavFocus, -1, true);
				return true;
			case 0x28:  // Down button selected
				WidgetKeyStep(widgetNavFocus, +1, true);
				return true;
			case 0x25:  // Left button selected
				WidgetKeyStep(widgetNavFocus, (document.dir.toUpperCase() == 'LTR')?-1:+1, false);
				return true;
			case 0x27:  // Right button selected
				WidgetKeyStep(widgetNavFocus, (document.dir.toUpperCase() == 'LTR')?+1:-1, false);
				return true;
			case 0x0D:    // Enter button selected, execute link to content/page
				WidgetKeyAction(widgetNavFocus);
				return true;
			case 0x21:    // Page up (plus) selected; page-up scrolling menu
				// LTD3: (currently works for keyboard pg-up, but not for remote key)
				WidgetKeyPage(widgetNavFocus, -1);
				return true;
			case 0x22:    // Page down (minus) selected; page-down scrolling menu
				// LTD3: (currently works for keyboard pg-down, but not for remote key)
				WidgetKeyPage(widgetNavFocus, +1);
				return true;
			case 0xA6:  // Browser Back button selected; handle but do still bubble down
				var status = false;
				if (widgetNavInput && widgetNavInput.cbKeypress)
					status = widgetNavInput.cbKeypress(widgetNavInput,
							keyCode, widgetNavInput.cbData);
				return status;


			case 0xB0: // Skip/Forward
				if (XPlayList)
					XPlayList.PrivateSkipForward();
				return true;
			case 0xB1: // Replay/Backward
				if (XPlayList)
					XPlayList.PrivateSkipBack();
				return true;

			case 0x08: // Backspace
				// If we have a widget keypress handler, let it consume the
				// keychar or return false if not consumed
				var status = false;
				if (widgetNavInput && widgetNavInput.cbKeypress)
					status = widgetNavInput.cbKeypress(widgetNavInput,
							keyCode, widgetNavInput.cbData);
				return status;

		}
	}
	catch(e)
	{
		// Ignore
	}


	return false;
}



//------------------------------------------------------------------------------
// onKeyDown - MCE does not route the keyboard arrow keys through onRemoteEvent
// so we need to trap and route them ourselves.  Some points of interest:
//
//	1. The return value of onKeyDown and onRemoteEvent is inverted.
//	2. Backspace (0x8) key gets passed to onRemoteEvent before onKeyDown
//
//------------------------------------------------------------------------------

function onKeyDown(keyCode)
{
	try
	{
		if (!keyCode)
			keyCode = window.event.keyCode;
		switch (keyCode)
		{
                case 0x09: // Tab key
                     return false;
		// Intercept only the keys we're interested in handling via
		// onRemoteEvent() and funnel them along
		case 0x0D: // Enter key
		case 0x21: // Page up key
		case 0x22: // Page down key
		case 0x25: // Left arrow key
		case 0x26: // Up arrow key
		case 0x27: // Right arrow key
		case 0x28: // Down arrow key
			return !onRemoteEvent(keyCode);
		}
	}
	catch(e)
	{
		// Ignore
	}
	

	// Bubble the keys so that onKeyPress() gets generated	
	return true;
}

document.onkeydown = onKeyDown;



//------------------------------------------------------------------------------
// onKeyPress - Process the keyboard typing input events.  Since onRemoteEvent
// is already handling navigation type events (including enter/backspace) just
// pass printable characters on to the widget keypress handler.
//------------------------------------------------------------------------------

var debugKeyPresses = 0;

function onKeyPress(keyChar)
{
	try
	{
		if (!keyChar)
			keyChar = window.event.keyCode;
		if (keyChar >= 31)
		{
			if (keyChar != 33)
				debugKeyPresses = 0;
				
			else if (++debugKeyPresses >= 3)
				PageLoad('../scripts/debug.htm');

			// If we have a widget keypress handler, let it consume the
			// keychar or return false if not consumed
			if (widgetNavInput && widgetNavInput.cbKeypress)
				return widgetNavInput.cbKeypress(widgetNavInput,
						keyChar, widgetNavInput.cbData);
		}
	}
	catch(e)
	{
		// Ignore
	}
	
	
	return false;
}

document.onkeypress = onKeyPress;



//======================= Widgets and Helper Functions =========================



//------------------------------------------------------------------------------
// CreateXXX - Simple one-liner helper functions to create common widgets.
//------------------------------------------------------------------------------

function CreateNavPane(navParent, vert, id)
{
	var nav = CreateWidget(navParent, id, vert, 'div');
	nav.elem.className = 'NavPane';
	return nav;
}

function CreateMenuPane(navParent, vert, id, nowrap)
{
	var menu = CreateWidget(navParent, id, vert, 'div');
	menu.elem.className = 'MenuPane';
	if (!nowrap)
		menu.cbKeyStep = WidgetKeyStepWrap;
	return menu;
}

function CreateInfoPane(navParent, vert, id)
{
	var info = CreateWidget(navParent, id, vert, 'div');
	info.elem.className = 'InfoPane';
	return info;
}


function CreateViewPane(navParent, vert, id)
{
	var view = CreateWidget(navParent, id, vert, 'div');
	view.elem.className = 'ViewPane';
	return view;
}

function CreateViewStats(navParent, id, autoVisible)
{
	var stats = CreateWidget(navParent, id, 'skip', 'div');
	stats.elem.className = 'ViewStats';

	stats.label = document.createElement('div');
	stats.elem.appendChild(stats.label);
	
	stats.arrowUp = document.createElement('a');
	stats.arrowUp.className = 'arrowUp_normal';
	stats.arrowUp.widgetFocus = false;
	stats.arrowUp.hideFocus = true;
	stats.arrowUp.onclick = WidgetMouseUp;
	stats.arrowUp.onmouseenter = WidgetStatsEnter;
	stats.arrowUp.onmouseleave = WidgetStatsLeave;
	stats.arrowUp.appendChild(document.createTextNode(' '));
	stats.elem.appendChild(stats.arrowUp);

	stats.arrowDn = document.createElement('a');
	stats.arrowDn.className = 'arrowDn_normal';
	stats.arrowDn.widgetFocus = false;
	stats.arrowDn.hideFocus = true;
	stats.arrowDn.onclick = WidgetMouseDn;
	stats.arrowDn.onmouseenter = WidgetStatsEnter;
	stats.arrowDn.onmouseleave = WidgetStatsLeave;
	stats.arrowDn.appendChild(document.createTextNode(' '));
	stats.elem.appendChild(stats.arrowDn);

	if (typeof autoVisible == 'undefined')
		autoVisible = true;
	stats.navAutoVisible = autoVisible ? true : false;


	// Let the ViewPane know where its stats child is
	while (navParent && (navParent.elem.className != 'ViewPane'))
		navParent = navParent.navParent;
	if (stats.viewPane = navParent)
	{
		navParent.stats = stats;
		if (stats.viewPane.scroller)
		{
			stats.scroller = stats.viewPane.scroller;
			stats.scroller.stats = stats;
			stats.arrowUp.widgetIndex = stats.scroller.elem.widgetIndex;
			stats.arrowDn.widgetIndex = stats.scroller.elem.widgetIndex;
		}		
	}


	return stats;
}

function CreateText(navParent, eTag, string)
{
	var text = CreateWidget(navParent, null, 'skip', eTag);
	
	// US: Fix for Bug# 5193. Set the container as read-only for header type child elements.
	if ( eTag && ((eTag.toUpperCase() == 'H1') || (eTag.toUpperCase() == 'H2')) )
	{
		if (navParent)
		{
			// Remove edit capabilities of the container.
			navParent.elem.readOnly = 'true';
		}
	}
	
	// Allows further interpretation of HTML tags - for bolding, emphasis etc
	var txtNode = document.createElement('span');
	txtNode.innerHTML = WidgetTextRegTM(string);
	text.elem.appendChild(txtNode);
	return text;
}

function CreateIcon(navParent, name)
{
	var icon = CreateWidget(navParent, null, 'skip', 'div');
	icon.elem.className = name;
	return icon;
}



//------------------------------------------------------------------------------
// CreateTitle - Create a title widget, and also set the browser title.
//------------------------------------------------------------------------------

function CreateTitle(navParent, label)
{
	document.title = label;
	var title = CreateWidget(navParent, null, 'skip', 'h1');
	title.elem.className = 'Title';
	title.elem.innerHTML = WidgetTextRegTM(label);
	return title;	
}



//------------------------------------------------------------------------------
// AddHelpIconToTitle - Adds a help icon to the title
//------------------------------------------------------------------------------

function AddHelpIconToTitle(navParent)
{
	var icon = CreateWidget(navParent, null, 'skip', 'a');
	icon.elem.id = 'TitleHelpIcon';
	return icon;
}

//------------------------------------------------------------------------------
// AddHelpIconToSubTitle - Adds a help icon to the subtitle
//------------------------------------------------------------------------------

function AddHelpIconToSubTitle(navParent)
{
	var icon = CreateWidget(navParent, null, 'skip', 'a');
	icon.elem.className = 'SubTitleHelpIcon';
	return icon;
}


//------------------------------------------------------------------------------
// AddAlertIconToTitle - Adds the alert severity icon to the title
//------------------------------------------------------------------------------
function AddAlertIconToTitle(navParent)
{
	var icon = CreateWidget(navParent, null, 'skip', 'a');
	icon.elem.id = 'TitleAlertIcon';
	return icon;
}



//------------------------------------------------------------------------------
// CreateIconTitle - Create a title widget, indented w.r.t the icon placement.
//------------------------------------------------------------------------------

function CreateIconTitle(navParent, label)
{
	document.title = label;
	var title = CreateWidget(navParent, null, 'skip', 'h1');
	title.elem.id = 'IconTitle';
	title.elem.innerHTML = WidgetTextRegTM(label);
	return title;	
}

//------------------------------------------------------------------------------
// CreateIconSubTitle - Create a subtitle widget, indented w.r.t the icon placement.
//------------------------------------------------------------------------------

function CreateIconSubTitle(navParent, label)
{
	var subTitle = CreateWidget(navParent, null, 'skip', 'h2');
	subTitle.elem.className = 'IconSubTitle';
	subTitle.elem.innerHTML = WidgetTextRegTM(label);
	return subTitle;	
}

//------------------------------------------------------------------------------
// CreateSubtitle - Create a subtitle widget, in a table for vert alignment.
//------------------------------------------------------------------------------

function CreateSubtitle(navParent, label)
{
	return CreateText(navParent, 'h2', label);
}



//------------------------------------------------------------------------------
// CreateWidget - Helper function to create a widget (aka HTML element), set
// its ID + class + navigation attributes, and append it to its parent.
//
// If an HTML element with the specified ID already exists, it is used instead
// of creating a new element.  But it's parent must match the parent given.
//
// Arguments:
//	navParent	The heirarchical parent of this widget.
//	id			ID attribute to assign to the widget, null is OK.
//	vert		True for vertical navigation, false for horizontal navigation.
//				Or specify as a 'leaf' node or the 'skip' navigation entirely.
//	eTag		If widget does not exist, widget to create (e.g. 'div', 'a').
//------------------------------------------------------------------------------

function CreateWidget(navParent, id, vert, eTag)
{
	var widget = new Object();

	widget.elem = (id ? document.getElementById(id) : null);

	// LTD0
	if (!widget.elem)
	{
		widget.elem = document.createElement(eTag);
		
		// LTD0
		if (navParent)
			navParent.elem.appendChild(widget.elem);
			
		// LTD0
		if (id)
			widget.elem.setAttribute('id', id);
	}

	// Make sure 'a' buttons never show focus border when selected
	if (widget.elem.tagName.toUpperCase() == 'A')
		widget.elem.hideFocus = true;

	// Set background of MediaCenter to match background of application
	try
	{
		if ((widget.elem.tagName.toUpperCase() == 'BODY') && (window.external.MediaCenter))
			window.external.MediaCenter.BGColor = document.bgColor;
	}
	catch(e)
	{
		// Ignore error
	}

	if (widget.elem.tagName.toUpperCase() == 'BODY') {
		WidgetMouseDelay();
	}
	
	widget.navBlock = false;
	switch (widget.elem.tagName.toUpperCase())
	{
	case 'BODY': case 'DIV': case 'FORM': case 'P': case 'TABLE':
		widget.navBlock = true;
	}


	// LTD0
	if (navParent)
	{
		var visible = true;

		// LTD0
		if (navParent.navExclusive)
		{
			for (var i = 0; i < navParent.navChild.length; i++)
				if (!(navParent.navChild[i].navSkip & SKIP_INVISIBLE))
					visible = false;
		}
		
		// LTD0
		widget.navChildIndex = navParent.navChild.length;
		navParent.navChild[widget.navChildIndex] = widget;
		
		// Make the widget visible or invisible through its style attributes
		if (!visible)
		{
			widget.elem.style.display = (visible?'inline':'none');
			widget.navSkip = widget.navSkip | SKIP_INVISIBLE;
		}
	}
	else
	{
		widgetNavRoot = widget;
		widgetNavRoot.cbKeyPageScroller = null;
		widgetNavRoot.cbKeyPage = function(widget, step)
		{
			// Iterate through all scrollers all this page
			var scroller = widget.cbKeyPageScroller;
			while (scroller)
			{
				// Only scroll if the scroll is currently visible and active
				var inactive = scroller;
				while (inactive && !(inactive.navSkip&SKIP_INVISIBLE))
					inactive = inactive.navParent;
					
				// Now call the scroller key page callback
				if (scroller.cbKeyPage && !inactive)
					scroller.cbKeyPage(scroller, step);
				scroller = scroller.cbKeyPageNext;
			}
		}
	}

	// LTD0
	widget.navChild = new Array();
	widget.navParent = navParent;
	
	// Store a reference to the newly created widget
	widgetArray[widgetArray.length] = widget;

	// LTD0
	WidgetSetNavigation(widget, vert);
	return widget;
}



//------------------------------------------------------------------------------
// CreateButn - Create a button widget, which is made using an HTML anchor
// element and assigning the appropriate onmouseover/onmousclick methods.
//
// Arguments:
//	navParent	The heirarchical parent of this widget.
//	id			The ID of the widget's HTML element, null is OK.
//	label		The initial HTML contents of the button.
//
// Callback Functions:
//	action		Function to be called when action button is pressed.
//	focus		Function to be called when navigation focus is changed.
//	explore		Function to be called when explore button is pressed.
//	data		Data to pass to each of the callback functions
//
// Button Widget Attributes:
//	label		The HTML element containing the button label.
//------------------------------------------------------------------------------

function CreateButn(navParent, id, label, action, focus, explore, data)
{

	var butn = CreateWidget(navParent, id, 'leaf', 'a');
	butn.elem.className = 'Normal';
	
	// Allows further interpretation of HTML tags - for bolding, emphasis etc
	var butnTxt = document.createElement('span');
	butnTxt.innerHTML = WidgetTextRegTM(label);

	if (label)
		butn.elem.appendChild(butnTxt);

	butn.navExplore = action ? false : true;
	butn.navActive = true;

	butn.cbAction = action;
	butn.cbFocus = focus;
	butn.cbExplore = explore;
	butn.cbData = data;


	return butn;
}



//------------------------------------------------------------------------------
// CreateHelpButn - Create a help button widget, which is made using an HTML
// anchor element wrapped by special element.
//------------------------------------------------------------------------------

function CreateHelpButn(navParent, id, action, focus, explore, data)
{
	var wrapper = CreateWidget(navParent, null, false, 'span');
	wrapper.elem.className = 'ButtonHelp';
	var butn = CreateButn(wrapper, id, ' ', action, focus, explore, data);
	
	// Play a trick to put the help icon over the button; pass through click/hover
	var icon = CreateWidget(butn, null, 'skip', 'span');
	icon.elem.className = 'ButtonHelpIcon';
	icon.elem.widgetIndex = butn.elem.widgetIndex;
	icon.elem.onclick = WidgetMouseClick;
	icon.elem.onmouseover = WidgetMouseOver;
	
	return butn;
}



//------------------------------------------------------------------------------
// ButnSetLabel - Change the label on a button.
//------------------------------------------------------------------------------

function ButnSetLabel(butn, label)
{
	for (var i = 0; i < butn.elem.childNodes.length; i++)
	{
		var elem = butn.elem.childNodes[i];
		if (elem.nodeType == 3) /* NODE_TEXT */
		{
			elem.data = label;
			return;
		}
	}
}



//------------------------------------------------------------------------------
// CreateIconButn - Same as create button, but takes the name of an icon CSS
// class and adds that icon after the button text.
//------------------------------------------------------------------------------

function CreateIconButn(navParent, id, label, icon, action, focus, explore, data, prepend)
{
	var butn = CreateButn(navParent, id, label, action, focus, explore, data);
	var span = document.createElement('span');
	span.className = icon;
	
	if (prepend)
	{
		var first = butn.elem.firstChild;
		butn.elem.insertBefore(span, first);
	}
	else
		butn.elem.appendChild(span);
		
	return butn;
}



//------------------------------------------------------------------------------
// CreateButnGap - Creates a gap between buttons which has the same pixel 
// height and width of a standard button.
//------------------------------------------------------------------------------

function CreateButnGap(navParent, id)
{
	var butn = CreateWidget(navParent, id, 'skip', 'a');
	butn.elem.className = 'Gap';
	WidgetSetNavigation(butn, false);
	return butn;
}



//------------------------------------------------------------------------------
// CreateTableRow - Create a row within the table, creating and initializing
// its individual cells with navigation and other attributes.
//------------------------------------------------------------------------------

function CreateTableRow(table, action, data)
{
	var row = table.navRows++;
	table.navGrid[row] = new Array();

	var tr = CreateWidget(table.tbody, null, table.navNavigatable?false:'skip', 'tr');
	tr.navRow = row;
	tr.navTable = table;

	for (var col = 0; col < table.navCols; col++)
	{
		var td = CreateWidget(tr, null, table.navNavigatable?'leaf':'skip', 'td');
		td.elem.className = 'Normal';
		td.navActive = true;
		td.navRow = row;
		td.navCol = col;
		td.navTable = table;
		td.cbAction = action;
		td.cbData = data;
			
		table.navGrid[row][col] = td;
	}
	
	return tr;
}



//------------------------------------------------------------------------------
// CreateTable - Create a table widget, which is made using an HTML table
// element with a one body; populate the rows and columns of the body with
// cells, and make those cells navigatable.
//
// Arguments:
//	navParent	The heirarchical parent of this widget.
//	id			The ID of the widget's HTML element, null is OK.
//
// Callback Functions:
//	action		Function to be called when action button is pressed.
//	data		Data to pass to each of the callback functions
//
// Table Widget Attributes:
//	navRows		The total number of rows in the table.
//	navCols		The total number of columns in the table.
//
// Table Datacell Widget Attributes:
//	navTable	The table owning the cells
//  navRow		The row of the cell within the table.
//	navCol		The column of the cell within the table.
//------------------------------------------------------------------------------

function CreateTable(navParent, id, rows, cols, action, data, navigatable)
{
	var table = CreateWidget(navParent, id, navigatable?false:'skip', 'table');
	table.tbody = CreateWidget(table, null, navigatable?true:'skip', 'tbody');
	table.tbody.navTable = table;

	table.navGrid = new Array();
	table.elem.width = '100%';
	table.elem.cellSpacing = 0;
	table.elem.cellPadding = 0;


	
	// Create each of the rows in the table
	table.navRows = 0;
	table.navCols = cols;
	table.navNavigatable = navigatable;
	for (var row = 0; row < rows; row++)
		CreateTableRow(table, action, data);



	//--------------------------------------------------------------------------
	// cbKeyStep - When navigating vertically up/down within the table rows,
	// keep the focus on the same row.  This merely sets the current column
	// and returns false to let the normal navigation scheme do its thing.
	//--------------------------------------------------------------------------
	
	table.tbody.cbKeyStep = function(tbody, step, vert)
	{
		var row = tbody.navCurr.navRow + step;
		var col = tbody.navCurr.navCurr.navCol;
		if ((row >= 0) && (row < tbody.navChild.length))
			tbody.navChild[row].navCurr = tbody.navChild[row].navChild[col];
		return false;
	}

	return table;

}



//=============================== Toggle Widgets ===============================



//------------------------------------------------------------------------------
// ToggleSetSticky - With the 'sticky' widget has focus, the 'view' widget
// becomes visible.  When it loses focus, the widget becomes invisible.
//------------------------------------------------------------------------------

function ToggleSetSticky(toggle, sticky, view)
{

	if (sticky.navLeaf)
	{
		sticky.navToggleView = view;
		
		if (sticky == widgetNavFocus)
			WidgetSetFocus(sticky);
		else
			WidgetSetVisible(view, false);
	}
	
	else
	
	{
		for (var i = 0; i < sticky.navChild.length; i++)
			ToggleSetSticky(toggle, sticky.navChild[i], view);
	}
}



//=============================== Radio Widgets ================================



//------------------------------------------------------------------------------
// CreateRadioButton - LTD0
//
// Arguments:
//	navParent	The heirarchical parent of this widget.
//	id			The ID of the widget's HTML element, null is OK.
//	labels		LTD0
//	checked		LTD0
//
// Callback Functions:
//	butnAction	Function to be called when action button is pressed.
//	butnrowData	Data to pass to each of the callback functions
//------------------------------------------------------------------------------

function CreateRadioButton(navParent, id, label, checked, butnAction, butnData)
{

	// If parent didn't come from CreateRadio(), initialize it to hold radio buttons
	if (!navParent.navRadio)
	{
		navParent.navRadio = new Array();
		navParent.navChecked = 0;
	}	
	

	// Create a wrapper to facilitate special radio button behavior
	var wrapper = CreateWidget(navParent, id, false, 'span');
	if (navParent.navVert)
		CreateWidget(navParent, null, 'skip', 'br');


	// Create the radio button
	var butn = CreateButn(wrapper, null, label, RadioKeyAction, null, null, butnData);
	butn.cbUserAction = butnAction;
	butn.navRadio = navParent;
	butn.navIndex = navParent.navRadio.length;


	// Add to the parent radio list, and check this button if needed
	navParent.navRadio[butn.navIndex] = wrapper.elem;
	wrapper.elem.className = 'RadioOff';
	if (checked)
		RadioSetChecked(navParent, butn.navIndex);


	return wrapper;
}



//------------------------------------------------------------------------------
// CreateRadio - Create a container to hold radio buttons vertically.
//
// Arguments:
//	labels	- An array of label strings to attach to the radio buttons
//------------------------------------------------------------------------------

function CreateRadio(navParent, id, labels, checked, butnAction, butnData, radioAction, radioData)
{
	var radio = CreateWidget(navParent, id, true, 'div');
	radio.cbAction = radioAction;
	radio.cbData = radioData;

	if (labels)
	{
		for (var i = 0; i < labels.length; i++)
			CreateRadioButton(radio, null, labels[i], checked == i, butnAction, butnData);
	}	
	
	RadioSetChecked(radio, checked);
	return radio;
}



//------------------------------------------------------------------------------
// RadioSetChecked - Set the 'checked' state of the radio button.
//------------------------------------------------------------------------------

function RadioSetChecked(radio, checked)
{
	for (var i = 0; radio.navRadio && (i < radio.navRadio.length); i++)
		radio.navRadio[i].className = (i == checked) ? 'RadioOn' : 'RadioOff';
	radio.navChecked = checked;
}



//------------------------------------------------------------------------------
// RadioKeyAction - Make sure the radio button is checked, call user callbacks.
//------------------------------------------------------------------------------

function RadioKeyAction(butn)
{
	var radio = butn.navRadio;
	
	RadioSetChecked(radio, butn.navIndex);

	if (butn.cbUserAction)
		butn.cbUserAction(butn.cbData);
		
	if (radio.cbAction)
		radio.cbAction(radio, radio.cbData);
		
}



//=============================== Grid Widgets ===============================



//------------------------------------------------------------------------------
// CreateGrid - Create a grid widget with a title row at the top, a status
// row at the bottom, and any number of rows and columns in between.  All
// navigation is taken care of automatically, with the 'update' callback used
// only when items within the grid need to be drawn.
//
// Arguments:
//	navParent	The heirarchical parent of this widget.
//	id			The ID of the widget's HTML element, null is OK.
//	rows		Number of rows to create within the grid widget.
//	cols		Number of columns to create within the grid widget.
//
// Callback Functions:
//	update		Callback to update the contents of the grid widget.
//	cellAction	Function to be called when cell action button is pressed.
//	cellData	Data to pass to each of the cell callback functions
//------------------------------------------------------------------------------

function CreateGrid(navParent, id, rows, cols, update, cellAction, cellData, widths)
{
	var table;

	var grid = CreateTable(navParent, id, rows, cols, cellAction, cellData, true);
	grid.elem.className = 'Grid';


	// Create a <thead> header to contain titles and such
	var thead = document.createElement('thead');
	var tr = document.createElement('tr');
	grid.header = document.createElement('<td colspan="'+cols+'">');
	tr.appendChild(grid.header);
	thead.appendChild(tr);
	grid.elem.appendChild(thead);

	// LTD0
	var width = Math.floor(100 / cols);
	grid.child = new Array();
	for (var i = 0; i < rows; i++)
	{
		for (var j = 0; j < cols; j++)
		{
			var cell = grid.navGrid[i][j];
			grid.child[i*cols+j] = cell.elem;
			if (widths == 'equal')
			{
				cell.navWidth = width;
				cell.elem.style.width = width+'%';
			}
			WidgetSetNavigation(cell, 'inactive');
		}
	}

	// LTD0
	grid.elem.widgetIndex = widgetNavIndex.length;
	widgetNavIndex[widgetNavIndex.length] = grid;


	grid.cbUpdate = update;
	grid.cbKeyStep = GridKeyStep;
	grid.cbKeyPage = GridKeyPage;
	
	grid.viewFirst = 0;
	grid.viewLast = 0;
	grid.viewTotal = 0;
	grid.viewCollapse = false;
	grid.viewEscape = false;


	// Let the ViewPane know where its grid child is
	while (navParent && (navParent.elem.className != 'ViewPane'))
		navParent = navParent.navParent;
	if (grid.viewPane = navParent)
		navParent.scroller = grid;


	return grid;
}




//------------------------------------------------------------------------------
// GridSetViewport - Set the active viewport within a grid widget by
// specifying the total number of items available to grid and the first item
// to show at the top of the grid widget.  This will clear and inactivate any
// cells shown which fall outside the total number of items.
//
// Arguments:
//	grid		Grid widget to set active viewport within.
//	first		First item to show within the grid widget
//	total		Total number of items within the grid widget
//	collapse	If true, collapse and make invisible the unused rows.
//------------------------------------------------------------------------------

function GridSetViewport(grid, first, total, collapse, escape)
{

	// Figure out the maximum number of items we can display
	var display = grid.navRows * grid.navCols;
	if (display > total)
		display = total;


	// Make sure the first item is a valid one		
	if (first >= total)
		first = total-display;
	if (first < 0)
		first = 0;


	// If the display is past the total count, figure out if we want to
	// display blank rows (normal) or adjust the first row (collapse)
	if (first+display >= total)
	{
		if (collapse)
			first = total-display;
		else
			display = total-first;		
	}



	// Save the first, last, total, and collapse values for later
	grid.viewTotal = total;
	grid.viewFirst = first;
	grid.viewLast = first + display - 1;
	grid.viewCollapse = collapse || escape;
	grid.viewEscape = escape;
	

	// Update each displayed cell, making sure it is visible and not skipped
	// Update the empty rows, make sure they're skipped and empty
	var visible = null, refocus = null;
	var remain = display;
	for (var row = 0; row < grid.navRows; row++)
	{
		var collapseRow = collapse && !(remain || escape);
		
		for (var col = 0; col < grid.navCols; col++)
		{
			var cell = grid.navGrid[row][col];
			if (remain)
			{
				WidgetSetNavigation(cell, 'leaf');
//				cell.navSkip = cell.navSkip & ~SKIP_INACTIVE;
				cell.elem.style.display = 'inline';

				remain--;
				if ((visible=cell) == widgetNavFocus)
					refocus = cell;
			}
			else
			{
				WidgetSetNavigation(cell, 'inactive');
//				cell.navSkip = cell.navSkip | SKIP_INACTIVE;
				cell.elem.style.display = (collapseRow?'none':'inline');
		
				GridSetCell(grid, row, col, '', cell.cbAction, cell.cbExplore, cell.cbData);
				if (cell == widgetNavFocus)
					refocus = (visible ? visible : widgetNavRoot);
			}
		}
	}

	
	// Use the callback to fill in the new contents of each displayed cell
	if (grid.cbUpdate)
		grid.cbUpdate(grid, 0, display);


	// Refocus the selection if a cell in the table is currently selected
	if (refocus)
		WidgetSetFocus(refocus);

	
	// Modify the arrow up/down styles to reflect the current display
	var arrows = grid.viewTotal && (grid.viewTotal > grid.navRows*grid.navCols);
	var stats = grid.stats ? grid.stats : grid.viewPane.stats;
	if (stats)
	{
		stats.arrowUp.className = (grid.viewFirst ? (stats.arrowUp.widgetFocus ? 'arrowUp_focus' : 'arrowUp_normal') : 'arrowUp_inactive');
		stats.arrowDn.className = ((grid.viewLast < grid.viewTotal-1) ? (stats.arrowDn.widgetFocus ? 'arrowDn_focus' : 'arrowDn_normal') : 'arrowDn_inactive');
		
		// Hide the whole stats area if not enough items
		if (stats.navAutoVisible)
			WidgetSetVisible(stats, arrows ? true : false);
	}	

}



//------------------------------------------------------------------------------
// GridSetCell - LTD0
//------------------------------------------------------------------------------

function GridSetCell(grid, row, col, cellInner, cellAction, cellExplore, cellData)
{
	if ((row >= 0) && (row < grid.navRows) && (col >= 0) && (col < grid.navCols))
	{
		// Set the cell callbacks and callback data
		var cell = grid.navGrid[row][col];
		cell.cbAction = cellAction;
		cell.cbExplore = cellExplore;
		cell.cbData = cellData;


		// If the scroll has fields, set the field values invidually
		if (grid.navFields)
		{
			for (var i = 0; i < grid.navFields[row].cells.length; i++)
			{
				grid.navFields[row].cells[i].innerHTML =
						cellInner[i] ? cellInner[i] : '';
			}

			if (typeof cellInner == 'string')
				grid.navFields[row].cells[0].innerHTML = cellInner;
		}


		// Otherwise set this child's inner HTML contents
		else
		{
			grid.child[row*grid.navCols+col].innerHTML = cellInner;
		}

		// If this is really a scroll set its explore arrow display properly
		cell.navExplore = cellExplore ? true : false;
	}
}



//------------------------------------------------------------------------------
// GridKeyPage/Step - Grid widget navigation focus routine, intercepts the
// up/down key presses to determine if we need to grid the contents or not.
//------------------------------------------------------------------------------

function GridKeyPage(grid, step)
		{ grid.cbKeyStep(grid, step*(grid.navRows-(grid.navRows>1?1:0)), true); }

function GridKeyStep(grid, step, vert)
{
	// Horizontal navigation is allowed to leave the grid
	if (!vert)
		return false;

	// Are we stepping above the top of the grid?
	var viewFirst = grid.viewFirst + step*grid.navCols;
	if (viewFirst < 0)
	{
		// In collapse mode allow navigation leave the grid vertically
		if (grid.viewCollapse && (step == -1))
			return false;

		// Otherwise move the focus if we were already at the top			
		viewFirst = 0;
	}


	// Are we stepping below the bottom of the grid?
	if ((step>0) && (grid.viewFirst + grid.navRows*grid.navCols >= grid.viewTotal))
	{
		// In collapse mode allow navigation leave the grid vertically
		if (grid.viewCollapse && (step == +1))
			return false;

		// Otherwise move the focus since we were already at the bottom by
		// figuring out which row/column are the last visible
		viewFirst = grid.viewFirst;
	}
	
	
	// Update the current viewport with the new parameters
	if (viewFirst != grid.viewFirst)
		GridSetViewport(grid, viewFirst, grid.viewTotal, grid.viewCollapse, grid.viewEscape);
	return true;
}



//------------------------------------------------------------------------------
// WidgetOnAspectRatioEvent - Designed to remove focus before the aspect ratio
// change and re-apply focus again after the aspect ratio change.
//------------------------------------------------------------------------------

function WidgetOnAspectRatioEvent(focus)
{
	if (widgetNavFocus && widgetNavFocus.cbFocus)
		widgetNavFocus.cbFocus(widgetNavFocus, focus, widgetNavFocus.cbData);
}



//=============================== Scroll Widgets ===============================



//------------------------------------------------------------------------------
// CreateScroll - Create a scroll widget with a title row at the top, a status
// row at the bottom, and any number of rows in between.  Navigation can only
// select whole rows, so this this is implemented as a grid widget with only
// one column.  All navigation of the scroll widget is automatically taken
// care of, and the 'update' function is called as necessary.
//
// Arguments:
//	navParent	The heirarchical parent of this widget.
//	id			The ID of the widget's HTML element, null is OK.
//	rows		Number of rows to create within the scroll widget.
//
// Callback Functions:
//	update		Callback to update the contents of the scroll widget.
//	rowAction	Function to be called when row action button is pressed.
//	rowExplore	Function to be called when row explore button is pressed.
//	rowData		Data to pass to each of the row callback functions
//
// Scroll Widget Attributes:
//	child		An array of the children data elements within the scroll.
//------------------------------------------------------------------------------

function CreateScroll(navParent, id, rows, update, rowAction, rowExplore, rowData)
{
	var scroll = CreateGrid(navParent, id, rows, 1, update);
	scroll.elem.className = 'Scroll';

	// LTD0
	for (var i = 0; i < rows; i++)
	{
		var row = scroll.navGrid[i][0];
		scroll.child[i] = row.elem;

		ScrollSetRow(scroll, i, '', rowAction, rowExplore, rowData);
	}

	scroll.navFields = null;
	return scroll;
}

//------------------------------------------------------------------------------
// ScrollAddField - LTD0
//------------------------------------------------------------------------------

function ScrollAddField(scroll, label, width, align)
{
		
	if (!scroll.navFields)
	{
		var table, tbody, tr, td;
		
		table = document.createElement('table');
		table.width = '100%';
		table.cellSpacing = 0;
		table.cellPadding = 0;
		tbody = document.createElement('tbody');
		tr = document.createElement('tr');
		tbody.appendChild(tr);
		table.appendChild(tbody);
		scroll.header.appendChild(table);
		scroll.header = tr;
		
		scroll.navFields = new Array();
		for (var row = 0; row < scroll.navRows; row++)
		{
			table = document.createElement('table');
			table.width = '100%';
			table.cellSpacing = 0;
			table.cellPadding = 0;
			tbody = document.createElement('tbody');
			tr = document.createElement('tr');
			tbody.appendChild(tr);
			table.appendChild(tbody);
			scroll.child[row].appendChild(table);
			scroll.navFields[row] = tr;
		}
	}
	

	var td = document.createElement('td');
	if (label)
		td.innerHTML = label;
	if (width)
		td.width = width;
	if (align)
		td.align = align;
	scroll.header.appendChild(td);
	

	for (var row = 0; row < scroll.navRows; row++)
	{
		td = document.createElement('td');
		if (width)
			td.width = width;
		if (align)
			td.align = align;
		scroll.navFields[row].appendChild(td);
	}
}



//------------------------------------------------------------------------------
// ScrollSetRow - LTD0
//------------------------------------------------------------------------------

function ScrollSetRow(scroll, index, rowInner, rowAction, rowExplore, rowData)
{
	GridSetCell(scroll, index, 0, rowInner, rowAction, rowExplore, rowData);
}



//------------------------------------------------------------------------------
// ScrollSetViewport - Identical to the GridSetViewport function.
//------------------------------------------------------------------------------

function ScrollSetViewport(scroll, first, total, collapse, escape)
{
	GridSetViewport(scroll, first, total, collapse, escape);
}




//============================== Edit Box Widgets ==============================



//------------------------------------------------------------------------------
// CreateEditBox - Create an edit box...  LTD0
//
// Arguments:
//  navParent	The heirarchical parent of this widget.
//  id			The ID of the widget's HTML element, null is OK.
//  value		Initial value for the edit box ("" is OK).
//
// Callback Functions:
//  cbAction	Function to be called when action button is pressed.
//  cbKeypress	Function to be called when other keys (A-Z, etc.) are pressed.
//  cbData		Data to pass to each of the callback functions
//
// EditBox Widget Attributes:
//	input		The HTML element for the actual input element.
//  navValue	Current value of the control edit box (user input).
//------------------------------------------------------------------------------

function CreateEditBox(navParent, id, value, cbAction, cbKeypress, cbData)
{
	var edit_box = CreateWidget(navParent, id, 'skip', 'span');
	edit_box.elem.className = 'Normal';
	edit_box.cbAction = cbAction;
	edit_box.cbKeypress = cbKeypress;
	edit_box.cbData = cbData;

	edit_box.navActive = true;
 
	// Create the edit_box input with its and append it to the SPAN element
	edit_box.input = document.createElement('<INPUT TYPE="TEXT" maxlength="256" size="40" contentEditable="false">');
	edit_box.input.className = 'Input';
	edit_box.elem.appendChild(edit_box.input);
 
	EditBoxSetValue(edit_box, value);
	return edit_box;
}

 

//------------------------------------------------------------------------------
// EditBoxSetValue - LTD0
//------------------------------------------------------------------------------
 
function EditBoxSetValue(edit_box, value)
{
	edit_box.navValue = (value ? value : '');
	edit_box.input.value = edit_box.navValue  + '|';
}

 

//============================ Text Scroll Widgets =============================



//------------------------------------------------------------------------------
// CreateTextScroll - A scrolling region of text, which can include paragraphs,
// lists, etc.  The primary assumption is that all lines within this widget are
// exactly the same size, as enforced by the style sheet.
//
// Arguments:
//	navParent	The heirarchical parent of this widget.
//	id			The ID of the widget's HTML element, null is OK.
//	rows		Number of rows to create within the scroll widget.
//------------------------------------------------------------------------------

function CreateTextScroll(navParent, id, rows, inner)
{
	var textScroll = CreateWidget(navParent, id, 'skip', 'textarea');
	textScroll.elem.className = "TextScroll";
	textScroll.navRows = rows;
	textScroll.viewTotal = textScroll.viewFirst = textScroll.viewLast = 0;
	textScroll.cbKeyPage = TextScrollKeyPage;

	
	// Assign this a widget index to receive mouse click events
	textScroll.elem.widgetIndex = widgetNavIndex.length;
	widgetNavIndex[widgetNavIndex.length] = textScroll;


	// Set events to handle resize and to prevent edit focus
	textScroll.elem.onbeforeeditfocus = TextScrollOnBeforeEditFocus;
	textScroll.elem.onresize = TextScrollOnResize;

	
	// Let the ViewPane know where its scrolling child is
	while (navParent && (navParent.elem.className != 'ViewPane'))
		navParent = navParent.navParent;
	if (textScroll.viewPane = navParent)
		navParent.scroller = textScroll;


	// Set the text scroll rows and inner text
	textScroll.elem.rows = rows;
	TextScrollSetViewport(textScroll, 0, inner);
	
	
	
	// Have the body widget call us when page up/down scrolling is needed
	textScroll.cbKeyPageNext = widgetNavRoot.cbKeyPageScroller;
	widgetNavRoot.cbKeyPageScroller = textScroll;


	return textScroll;

}



//------------------------------------------------------------------------------
// TextScrollSetViewport - Set the first line to be visible in the scrolling
// area, and the inner contents.  If 'inner' is not specified, the existing
// contents are not changed, allowing changing of the first line only.
//------------------------------------------------------------------------------

function TextScrollSetViewport(textScroll, first, inner)
{
	// Update the scroll text
	if (inner)
		textScroll.elem.innerHTML = WidgetTextRegTM(inner);


	// Set the first visible row in the scroll
	var row = Math.floor(textScroll.elem.clientHeight / textScroll.navRows);
	textScroll.elem.scrollTop = first * row;


	// Check the parameters against the new total
	textScroll.viewTotal = row ? Math.floor(textScroll.elem.scrollHeight / row) : 0;
	if (first >= textScroll.viewTotal)
		first = textScroll.viewTotal - textScroll.navRows;
	if (first < 0)
		first = 0;


	// Calculate number of rows, first and last visible, etc.
	textScroll.viewFirst = row ? Math.floor(textScroll.elem.scrollTop / row) : 0;
	textScroll.viewLast = row ? textScroll.viewFirst + textScroll.navRows - 1 : 0;


	// Determine if we can scroll up or down, and display style as needed
	var up = (textScroll.viewFirst != 0);
	var dn = (textScroll.viewLast < textScroll.viewTotal-1);
	textScroll.elem.className = "TextScroll" + (up||dn?"UpDn":"");
	

	// Make the arrows and stats bar invisible/inactive if needed
	var stats = textScroll.stats ? textScroll.stats : textScroll.navParent.stats;
	if (stats)
	{
		var visible = textScroll.viewTotal > textScroll.navRows;
		WidgetSetVisible(textScroll.navParent.stats, visible);
		
		stats.arrowUp.className = (up ? (stats.arrowUp.widgetFocus ? 'arrowUp_focus' : 'arrowUp_normal') : 'arrowUp_inactive');
		stats.arrowDn.className = (dn ? (stats.arrowDn.widgetFocus ? 'arrowDn_focus' : 'arrowDn_normal') : 'arrowDn_inactive');
		// CPD-Fixes no nav button display issue in CCU help
		stats.arrowUp.style.visibility = visible ? 'visible' : 'hidden';
		stats.arrowDn.style.visibility = visible ? 'visible' : 'hidden';

	}
		
}



//------------------------------------------------------------------------------
// TextScrollKeyPage - The page up/down events have been triggered, change
// the first line visible in the scrolling text widget.
//------------------------------------------------------------------------------

function TextScrollKeyPage(textScroll, step)
{
	var jump = step*(textScroll.navRows-(textScroll.navRows>1?1:0));
	TextScrollSetViewport(textScroll, textScroll.viewFirst + jump, null);
}



//------------------------------------------------------------------------------
// TextScrollOnBeforeEditFocus - Do not let text scroll get focus
//------------------------------------------------------------------------------

function TextScrollOnBeforeEditFocus()
{
	return false;
}



//------------------------------------------------------------------------------
// TextScrollOnResize - Use this to dyanmically add/remove scroll bars
//------------------------------------------------------------------------------

function TextScrollOnResize()
{
	try
	{
		var textScroll = widgetNavIndex[window.event.srcElement.widgetIndex];
		TextScrollSetViewport(textScroll, textScroll.viewFirst, null);
	}
	catch(e)
	{
		// Ignore error
	}		
}



//============================ Dialog Box Widgets ==============================



//------------------------------------------------------------------------------
// CreateDialog - Create a dialog box.  
//
// Arguments:
//  navParent	The heirarchical parent of this widget.
//  id			The ID of the widget's HTML element, null is OK.
//
//------------------------------------------------------------------------------

function CreateDialog(navParent, id, title, text)
{
	var dialog = CreateWidget(navParent, id, false, 'div');
	dialog.navParent = null;
	dialog.elem.className = 'Dialog';
	WidgetSetVisible(dialog, false);

	// Create the title area of the message box
	dialog.title = document.createElement('h2');
	dialog.elem.appendChild(dialog.title);
	if (title)
		dialog.title.innerHTML = title;
	
	// Create the text areas of the message box
	dialog.text = document.createElement('p');
	dialog.elem.appendChild(dialog.text);
	if (text)
		dialog.text.innerHTML = text;

	return dialog;
}

 
//------------------------------------------------------------------------------
// CreateBrand - Create the brand logo icon as a Macromedia Flash object.
//------------------------------------------------------------------------------

function CreateBrand(bodyElem)
{
	var widget = CreateWidget(bodyElem, null, false, 'embed');
	widget.elem.setAttribute("src","../scripts/zonebrand.swf");
	widget.elem.setAttribute("quality","high");
	widget.elem.setAttribute("wmode","transparent");
	widget.elem.setAttribute("name","flashBrand");
	widget.elem.setAttribute("align","center");
	widget.elem.setAttribute("allowScriptAccess","sameDomain");
	widget.elem.setAttribute("type","application/x-shockwave-flash");
	widget.elem.className="FlashBrand";
	
	return widget;

}


//------------------------------------------------------------------------------
// DialogDisplay - FOO
//------------------------------------------------------------------------------

function DialogDisplay(dialog, display)
{
	WidgetSetVisible(dialog, display);
	if (display)
		WidgetSetFocus(dialog);
}


//------------------------------------------------------------------------------
// DestroyWidgets -	Runs on body.unload(). Deletes javascript references to
//					DOM objects.
//
// Arguments:		none
//------------------------------------------------------------------------------

function DestroyWidgets()
{
	for (var i = 0; i < widgetArray.length; i++)
	{
		switch(widgetArray[i].elem.className)
		{
			case 'Dialog':
				widgetArray[i].title = null;
				widgetArray[i].text = null;
				widgetArray[i].elem = null;
				break;
			case 'RadioOff':
			case 'RadioOn':
				for (j in widgetArray[i].navParent.navRadio) //navParent is the 'form' tag
					widgetArray[i].navParent.navRadio[j] = null;
				break;
			case 'Grid':
			case 'Scroll':
			case 'Tree':
				for (j in widgetArray[i].child) //child points to DOM references of grid td's
					widgetArray[i].child[j] = null;
				var tr = widgetArray[i].header.parentNode; //nullify by removing header td from parent tr
				tr.removeNode(true);
				widgetArray[i].header = null;
				widgetArray[i].elem = null;
				break;
			case 'ViewStats':
				widgetArray[i].label = null;
				widgetArray[i].arrowUp = null;
				widgetArray[i].arrowDn = null;
				widgetArray[i].elem = null;
				break;
			default: //for everything else just null out the DOM reference stored in elem
				widgetArray[i].elem = null;
				break;
		}
	}
}

//================================ OBSOLETE! ===================================



//------------------------------------------------------------------------------
// OBSOLETE - stop using!!!
//------------------------------------------------------------------------------

function ScrollSetView(scroll, first, total)
	{ ScrollSetViewport(scroll, first, total); }

function ScrollSetRowInner(scroll, index, inner)
	{ scroll.child[index].innerHTML = inner; }
