//------------------------------------------------------------------------------
// scripts/urlFrame.js - Bounce the pageFrame between pages or targets.
//
// INTEL CONFIDENTIAL
//	Copyright 2005 Intel Corporation All Rights Reserved.  The source code
//	contained or described herein and all documents related to the source code
//	(Material) are owned by Intel Corporation or its suppliers or licensors.
//	Title to the Material remains with Intel Corporation or its suppliers and
//	licensors. The Material may contain trade secrets and 	proprietary and
//	confidential information of Intel Corporation and its 	suppliers and
//	licensors, and is protected by worldwide copyright and trade secret laws
//	and treaty provisions. No part of the Material may be used, copied,
//	reproduced, modified, published, uploaded, posted, transmitted, distributed,
//	or disclosed in any way without Intels prior express written permission. 
//	
//	No license under any patent, copyright, trade secret or other intellectual
//	property right is granted to or conferred upon you by disclosure or delivery
//	of the Materials, either expressly, by implication, inducement, estoppel or
//	otherwise. Any license under such intellectual property rights must be express
//	and approved by Intel in writing.
//
//	Unless otherwise agreed by Intel in writing, you may not remove or alter this
//	notice or any other notice embedded in Materials by Intel or Intels suppliers
//	or licensors in any way.
//
// Description:
//	This script loads an URL from the argument list (if specific) into pageFrame
//	and insures it has focus.  This takes advantage of the JavaScript threading
//	model by setting a very short timer (1ms) which gives the pageFrame time to
//	load before coming back here an attempting to set its focus.
//
//------------------------------------------------------------------------------



//------------------------------------------------------------------------------
// PageURL - Break the URL down into its href, hash and search components.
//------------------------------------------------------------------------------

function PageURL(href)
{
	var url = new Object();
	url.href = href;
	url.hash = '';
	url.search = '';
		
	// Strip off the search string from the URL
	if ((index = url.href.indexOf('?')) >= 0)
	{
		url.search = url.href.substring(index);
		url.href = url.href.substring(0, index);
	}

	// Strip off the hash string from the URL
	if ((index = url.href.indexOf('#')) >= 0)
	{
		url.hash = url.href.substring(index);
		url.href = url.href.substring(0, index);
	}
	
	url.path = url.href.split('/');
	return url;	
}



//------------------------------------------------------------------------------
// See if a page frame URL was specified, bounce pageFrame to that page if so.
//------------------------------------------------------------------------------

if (location.search.substr)
{
	var url = unescape(location.search.substr(1));

		
	// We may get permission denied in trying to look at the href when
	// back is pressed, for security reasons
	var newLoc = PageURL(url), oldLoc = '';
	try
	{
		oldLoc = PageURL(unescape(parent.pageFrame.location.href));
	}
	catch(e) { /* ignore */ }


	// Bounce to the new page, or replace with a new page
	if (parent.pageFrame.onbounce && oldLoc && !oldLoc.href.indexOf(newLoc.href))
		parent.pageFrame.onbounce(newLoc.href, newLoc.hash, newLoc.search);
	else
		parent.pageFrame.location.replace(url);


//alert('old: href='+oldLoc.href+' hash='+oldLoc.hash+' search='+oldLoc.search+'\n'+
//	  'new: href='+newLoc.href+' hash='+newLoc.hash+' search='+newLoc.search);
	  
}



//------------------------------------------------------------------------------
// Force the page frame to get focus after a very short while
//------------------------------------------------------------------------------

setTimeout('parent.pageFrame.window.focus()', 1);
