/*
  
  INTEL CONFIDENTIAL
	Copyright (c) 2004-2006 Intel Corporation All Rights Reserved.  The source code
	contained or described herein and all documents related to the source code
	(Material) are owned by Intel Corporation or its suppliers or licensors.
	Title to the Material remains with Intel Corporation or its suppliers and
	licensors. The Material may contain trade secrets and 	proprietary and
	confidential information of Intel Corporation and its 	suppliers and
	licensors, and is protected by worldwide copyright and trade secret laws
	and treaty provisions. No part of the Material may be used, copied,
	reproduced, modified, published, uploaded, posted, transmitted, distributed,
	or disclosed in any way without Intels prior express written permission. 
	
	No license under any patent, copyright, trade secret or other intellectual
	property right is granted to or conferred upon you by disclosure or delivery
	of the Materials, either expressly, by implication, inducement, estoppel or
	otherwise. Any license under such intellectual property rights must be express
	and approved by Intel in writing.

	Unless otherwise agreed by Intel in writing, you may not remove or alter this
	notice or any other notice embedded in Materials by Intel or Intels suppliers
	or licensors in any way.


  File:  wizard_parser.js
  
  Main Data Structures:
     class NavArguments
     {
       // These define the arguments that are passed using URL parameter passing.
       // They control the navigation and page content.
       
       enum    LinkType = { "Page", "Href", "Done" };
                          // Page    - means the current HTML page will be reloaded
                          //           with the data from the next page referred to
                          //           in the Link field; using the current XML data file.
                          //
                          // Href    - means a new page and new XML data file will be loaded.
                          //
                          // Done    - means the user has gone through all the wizard pages
                          //           and that the task is complete, or the user has pressed
                          //           a skip button and the wizard is "skipped".
       
       String  Link;      // Link information value depends on LinkType as follows
                          //    LinkType == "Page": < Page Id            >
                          //    LinkType == "Href": < HTML Hyperlink     >
                          //    LinkType == "Done": < 'Complete', 'Skip' >
     }
     
     class ItemData
     {
       // This class is a container for items that can go into a nav pane, view pane,
       // or info pane of the CCU UI templates.
       
       String    ItemType;   // one of { "Title", "Text", "Button", "Password" }
       String    ItemId;
       
       String    LinkType;   // one of { "Page", "Href", "Done" }
       String    Link;       // value depends on LinkType as follows
                             //    LinkType == "Page": < Page Id            >
                             //    LinkType == "Href": < HTML Hyperlink     >
                             //    LinkType == "Done": < 'Complete', 'Skip' >
                            
       String    Password;   // Used only when ItemType == Password
       String    MaxLength;  // Used only when ItemType == Password
     }
     
     class PageData
     {
       // Used as a container for the page data contained with an XML file.
       
       String    PageId;           // Unique page id for a given sequence of pages
       String    HtmlClass;        // CSS class for page layout
       String    Comment           // General purpose page comment (not displayed)
       ItemData  NavPaneItems[];   // Unsized, array of class ItemData
       ItemData  ViewPaneItems[];  // Unsized, array of class ItemData
       ItemData  InfoPaneItems[];  // Unsized, array of class ItemData
     }
       
     PageData[] PageDataList;      // Unsized, array of class PageData
     
     temp dae: need to describe the shared object structure too!
*/

// ------------------------- Global Variable Declarations (Constants) ------------------------

var g_URL_LINK_FROM_TAG            = 'FID';  // Page Id navigated from
var g_URL_LINK_TAG                 = 'LNK';  // Link value (for Page and Done link types)
var g_URL_LINK_TYPE_TAG            = 'LTP';  // LinkType field of the button press

var g_TAG_WIZARD                   = 'Wizard';    
var g_TAG_PAGE_WIZARD              = 'WizardPage';
var g_TAG_ATTR_WIZARD_ATTR_ID      = 'id';     
var g_TAG_ATTR_PAGE_ATTR_CLASS     = 'class';     
var g_TAG_ATTR_PAGE_ATTR_ID        = 'id';        
var g_TAG_PAGE_COMMENT             = 'Comment';   
var g_TAG_PAGE_NAVPANE             = 'NavPane';   
var g_TAG_PAGE_VIEWPANE            = 'ViewPane';  
var g_TAG_PAGE_INFOPANE            = 'InfoPane';  

var g_TAG_ATTR_ITEM_ATTR_ID        = 'id';        
var g_TAG_ATTR_ITEM_ATTR_LINK      = 'link';      
var g_TAG_ATTR_ITEM_ATTR_LINKTYPE  = 'link_type'; 
var g_TAG_ATTR_ITEM_ATTR_MAXLENGTH = 'max_length';
var g_TAG_ATTR_ITEM_ATTR_VALUE     = 'value';     
var g_TAG_ATTR_ITEM_DONE_COMPLETE  = 'Complete';
var g_TAG_ATTR_ITEM_DONE_SKIP      = 'Skip';

var g_TAG_VALUE_LINK_TYPE_PAGE     = 'Page';      
var g_TAG_VALUE_LINK_TYPE_HREF     = 'Href';      
var g_TAG_VALUE_LINK_TYPE_DONE     = 'Done';      

var g_TAG_ITEM_TITLE               = 'Title';     
var g_TAG_ITEM_TEXT                = 'Text';      
var g_TAG_ITEM_BUTTON              = 'Button';    
var g_TAG_ITEM_PASSWORD            = 'Password';  
var g_TAG_ITEM_CALLBACK            = 'Callback';      

var g_TAG_ITEM_BUTTON              = 'Button';    

var g_debug = false;

var g_SCAN_WIZARD_BASE = "//" + g_TAG_WIZARD;
var g_SCAN_PAGE_BASE   = "//" + g_TAG_WIZARD + "/" + g_TAG_PAGE_WIZARD;

// temp dae: not sure if this is the right way to do this but, I need a way
//           to share the shared object with methods and don't want to pass
//           it around everywhere.

var locCurrentSharedObject = null;

//------------------------------------------------------------------------------
// EditBoxSetText
//------------------------------------------------------------------------------

function EditBoxSetText(edit_box, value)
{
  edit_box.navValue = value;
}


//------------------------------------------------------------------------------
// EditKeyPressed
//------------------------------------------------------------------------------

function EditKeyPressed( widget_index )
{
  EditKeyAction(widgetNavIndex[widget_index]);
}


//------------------------------------------------------------------------------
// EditKeyAction - Make sure the radio button is checked, call user callback.
//------------------------------------------------------------------------------

function EditKeyAction(widget_obj)
{
  var nav_widget = widget_obj.navWidget;
  var edit_box = document.getElementById(nav_widget.navID);
  
  if (edit_box != null)
  {
    EditBoxSetText(nav_widget, edit_box.value);
    if (widget_obj.cbUserAction)
    {
      widget_obj.cbUserAction(widget_obj.cbData);
    }
  } else
  {
    alert("ERR: EditKeyAction - invalid widget id: " + widget_obj.navID);
  }
}


function CheckBoxStateChange(item_id, new_state)
{
}

function CreateCheckBox(parent_pane, item_id, value, text, action, focus)
{
  var html = "<input type='checkbox' name='" + item_id + "' " +
             "value='" + value + "' " + 
             "onclick='CheckBoxStateChange(" + item_id + ", !this.checked);'>" + text;

  document.write(html);
}

/*
 * GetNavigationArguments - Obtains the navigation arguments from the URL and loads
 *   them into a NavArguments structure.
 *
 * Returns:
 *   NavArguments structure.
 *
 */
function GetNavigationArguments()
{
  var nav_args = new Object();
  
  // Acquire the NEXT and FROM page arguments from the URL
  nav_args.LinkType = PageGetArgument(g_URL_LINK_TYPE_TAG);
  nav_args.Link     = PageGetArgument(g_URL_LINK_TAG);
  
  return nav_args;
}

/*
 * ClearNavigationArguments - Makes sure we start from scratch
 *
 * Returns: nothing
 *
 */
function ClearNavigationArguments()
{
  var nav_args = new Object();
  
  // Acquire the NEXT and FROM page arguments from the URL
  nav_args.LinkType = PageGetArgument(g_URL_LINK_TYPE_TAG);
  nav_args.Link     = PageGetArgument(g_URL_LINK_TAG);
  
  return nav_args;
}

/*
 * LoadPageData - Loads data for a single page (by PageId).
 *
 * Returns:
 *   PageData structure on success, null otherwise.
 *
 */
function LoadPageData(file, page_id)
{
  var dom = LoadDOM(file);
  try 
  {
    var search_str;
    if (page_id == null)
    {
      search_str = g_SCAN_PAGE_BASE;
    } else
    {
      // Query a single node.
      search_str = g_SCAN_PAGE_BASE + "[@" + 
                       g_TAG_ATTR_PAGE_ATTR_ID + "='" +
                       page_id + "']";
    }
    
    var oNode = dom.selectSingleNode(search_str);
    if (oNode == null)
    {
       alert("ERR: LoadPageData - cannot find node: " + search_str);
       return null;
    }
  
    alert("Parsing wizard page using: '" + search_str + "'");  
    return parseWizardPage(oNode);
  }
  catch (e)
  {
    alert(e.description);
    return null;
  }
}

/*
 * LoadWizardData - Loads data for all wizard pages.
 *
 * Returns:
 *   PageDataList on success, null otherwise.
 *
 */
function LoadWizardData(file)
{
  var wizard_data = new Object();
  var page_list = new Array();
  
  var dom = LoadDOM(file);
  try 
  {
    // Query a node-set.
    var oNodes = dom.selectNodes(g_SCAN_PAGE_BASE);
    for (var ii = 0; ii < oNodes.length; ii++)
    {
      oNode = oNodes.nextNode;
      if (oNode != null) 
      {
        page_list[ii] = parseWizardPage(oNode);
      }
    }
  }
  catch (e)
  {
    alert(e.description);
  }
  
  var wizard_id = 'OOBETask';
  try
  {
    var wizard_node = dom.selectNodes(g_SCAN_WIZARD_BASE);
    if (wizard_node != null)
    {
      wizard_id = parseWizardId(wizard_node.nextNode);
    }
  }
  catch(e2)
  {
    alert(e2.description);
  }
  
  wizard_data.WizardId = wizard_id;
  wizard_data.PageList = page_list;
  
  return wizard_data;
}

/*
 * CreateWizardPage - Generate HTML for the current wizard page.
 *
 * Returns: nothing
 *
 */
function CreateWizardPage(page_data, loc_doc)
{
  // Generate HTML Page
  var body = GenBodyHeaderHtml(page_data);

  var nav_pane = GenNavPaneHtml(body, page_data, loc_doc);
  
  // Create a switch statement (or equiv) that determines which templates
  // have a corresponding template body (Nav, View, Info panes), don't rely
  // on the user having the correct XML data (it could have info in from a
  // previous cut and paste issue.
  GenViewPaneHtml(body, nav_pane, page_data, loc_doc);
  
  GenInfoPaneHtml(body, nav_pane, page_data, loc_doc);

  GenBodyFooterHtml(body);
}

// ------------------------- Local Method Declarations ------------------------

function parseWizardId(wizard_node)
{
  var item;
  item = wizard_node.attributes.getNamedItem(g_TAG_ATTR_WIZARD_ATTR_ID);
  return item.value;
}

/*
 * parseWizardPage - Parse the XML from the DOC node and load the page data structure.
 *
 * Returns: 
 *   PageData structure on success, null otherwise.
 *
 */
function parseWizardPage(node)
{
  var page_data = new Object();

  page_data.PageId    = "0";
  page_data.HtmlClass = "Wizard";
  page_data.Comment   = " ** no comment ** ";
  
  if (node.attributes.length == 0)
  {
    alert("ERR: parseWizardPage - there are no page attributes for the node: \n" + node.xml);
    return null;
  }
  
  // Pull out the Class and Id fields of the page attributes.
  try
  {
    var item;
    item = node.attributes.getNamedItem(g_TAG_ATTR_PAGE_ATTR_CLASS);
    page_data.HtmlClass = item.value;
    
    item = node.attributes.getNamedItem(g_TAG_ATTR_PAGE_ATTR_ID);
    page_data.PageId = item.value;
    
    // Extract the page comment
    parsePageComment(node, page_data);
    parseNavPane(node, page_data);
    parseViewPane(node, page_data);
    parseInfoPane(node, page_data);
  }
  catch (e)
  {
    alert(e.description);
  }
  
  return page_data;
}
    
/*
 * parsePageComment
 *
 */
function parsePageComment(node, page_data)
{
  var comment = '';
  
  // Extract the <WizardPage ...><Comment /> value in the form of
  //  <Comment> ... </Comment>
  var comment_node = node.selectNodes("./" + g_TAG_PAGE_COMMENT);
  if (comment_node.length > 0)
  {
    // Only use the first one
    comment_node = comment_node.nextNode;
    if (comment_node != null)
    {
      comment = comment_node.text;
    }
  }
  
  page_data.Comment = comment;
}

/*
 * parseNavPane
 *
 * XML Structure:
 *   <NavPane>
 *     <Title  id='Page1_Title' />
 *     <Text   id='Page1_Text1' />
 *     <Button id='Page1_Btn1' link_type='Page' link='Page2' />
 *   </NavPane>
 *
 * Creates .NavPaneItems (Array)
*/
function parseNavPane(node, page_data)
{
  var nav_items = new Array();
  
  // Extract the <WizardPage ...><Comment /> value in the form of
  //  <Comment> ... </Comment>
  
  var nav_node = node.selectNodes("./" + g_TAG_PAGE_NAVPANE + "/*");
  var curr_node;
  
  for (var ii = 0; ii < nav_node.length; ii++)
  {
    // Concatenate all NavPane nodes into a single list
    curr_node = nav_node.nextNode;
    if (curr_node != null)
    {
      // Extract nodes
      
      nav_items[ii] = new Object();
      nav_items[ii].ItemType = curr_node.nodeName;
      nav_items[ii].ItemId = parseItemId(curr_node);
      
      if (curr_node.nodeName == g_TAG_ITEM_TITLE)
      {
        parseItemTitle(curr_node, nav_items[ii]);
      } else if (curr_node.nodeName == g_TAG_ITEM_TEXT)
      {
        parseItemText(curr_node, nav_items[ii]);
      } else if (curr_node.nodeName == g_TAG_ITEM_BUTTON)
      {
        parseItemButton(curr_node, nav_items[ii]);
      } else if (curr_node.nodeName == g_TAG_ITEM_PASSWORD)
      {
        parseItemPassword(curr_node, nav_items[ii]);
      } else if (curr_node.nodeName == g_TAG_ITEM_CALLBACK)
      {
        parseItemCallback(curr_node, nav_items[ii]);
      } else
      {
        alert ("ERR: invalid node name '" + curr_node.nodeName + "\n");
      }
    }
  }
  
  page_data.NavPaneItems = nav_items;
}

/*
 * parseItemId
 *
*/
function parseItemId(curr_node)
{
  var item;
  item = curr_node.attributes.getNamedItem(g_TAG_ATTR_ITEM_ATTR_ID);
  
  return item.value;
}

/*
 * parseItemTitle
 *
 */
function parseItemTitle(curr_node, item)
{
  // Nothing to do for this one.
}

/*
 * parseItemText
 *
 */
function parseItemText(curr_node, item)
{
  // Nothing to do for this one.
}

/*
 * parseItemButton
 *
 */
function parseItemButton(curr_node, item)
{
  var temp_node;
  
  try
  {
    temp_node = curr_node.attributes.getNamedItem(g_TAG_ATTR_ITEM_ATTR_LINKTYPE);
    if (temp_node != null)
    {
      item.LinkType = temp_node.value;
    } else
    {
      item.LinkType = null;
    }
  
    temp_node = curr_node.attributes.getNamedItem(g_TAG_ATTR_ITEM_ATTR_LINK);
    if (temp_node != null)
    {
      item.Link = temp_node.value;
    } else
    {
      item.Link = null;
    }
  }
  catch(e)
  {
    alert (e.description);
  }
}

/*
 * parseItemButton
 *
 */
function parseItemPassword(curr_node, item)
{
  var temp_node;
  
  try
  {
    temp_node = curr_node.attributes.getNamedItem(g_TAG_ATTR_ITEM_ATTR_VALUE);
    item.Password = temp_node.value;
  
    temp_node = curr_node.attributes.getNamedItem(g_TAG_ATTR_ITEM_ATTR_MAXLENGTH);
    if (temp_node != null)
    {
      item.MaxLength = temp_node.value;
    } else
    {
      item.MaxLength = 100;
    }
  }
  catch(e)
  {
    alert (e.description);
  }
}

function parseItemCallback(curr_node, item)
{
  // nothing to do here
}

/*
 * parseViewPane
 *
 * XML Structure:
 *   <ViewPane>
 *     <Title  id='Page1_Title' />
 *     <Text   id='Page1_Text1' />
 *     <Button id='Page1_Btn1' link_type='Page' link='Page2' />
 *   </ViewPane>
 *
 * Creates .ViewPaneItems (Array)
*/
function parseViewPane(node, page_data)
{
  page_data.ViewPaneItems = new Object();
}

/*
 * parseInfoPane
 *
 * XML Structure:
 *   <ViewPane>
 *     <Title  id='Page1_Title' />
 *     <Text   id='Page1_Text1' />
 *     <Button id='Page1_Btn1' link_type='Page' link='Page2' />
 *   </ViewPane>
 *
 * Creates .InfoPaneItems (Array)
*/
function parseInfoPane(node, page_data)
{
  var info_items = new Array();
  
  var nav_node = node.selectNodes("./" + g_TAG_PAGE_INFOPANE + "/*");
  var curr_node;
  
  for (var ii = 0; ii < nav_node.length; ii++)
  {
    // Concatenate all NavPane nodes into a single list
    curr_node = nav_node.nextNode;
    if (curr_node != null)
    {
      // Extract nodes
      
      info_items[ii] = new Object();
      info_items[ii].ItemType = curr_node.nodeName;
      info_items[ii].ItemId = parseItemId(curr_node);
      
      if (curr_node.nodeName == g_TAG_ITEM_TITLE)
      {
        parseItemTitle(curr_node, info_items[ii]);
      } else if (curr_node.nodeName == g_TAG_ITEM_TEXT)
      {
        parseItemText(curr_node, info_items[ii]);
      } else if (curr_node.nodeName == g_TAG_ITEM_BUTTON)
      {
        parseItemButton(curr_node, info_items[ii]);
      } else if (curr_node.nodeName == g_TAG_ITEM_PASSWORD)
      {
        parseItemPassword(curr_node, info_items[ii]);
      } else if (curr_node.nodeName == g_TAG_ITEM_PASSWORD)
      {
        parseItemCallback(curr_node, info_items[ii]);
      } else
      {
        alert ("ERR: invalid node name '" + curr_node.nodeName + "\n");
      }
    }
  }
  
  page_data.InfoPaneItems = info_items;
}

/* 
 * LoadDOM
 *
 */
function LoadDOM(file)
{

// temp dae: must add the ability to detect when the file doesn't exist.

   var dom;
   try {
     dom = MakeDOM(null);
     dom.load(file);
   }
   catch (e) {
     alert(e.description);
   }
   return dom;
}

/* 
 * MakeDOM
 *
 */
function MakeDOM(progID)
{
  if (progID == null) {
    progID = "msxml2.DOMDocument.4.0";
  }

  var dom;
  try {
    dom = new ActiveXObject(progID);
    dom.async = false;
    dom.validateOnParse = false;
    dom.resolveExternals = false;
  }
  catch (e) {
    alert(e.description);
  }
  return dom;
}

// ------------------------- HTML Generation Methods ------------------------

/*
 * GenBodyHeaderHtml
 *
 */
function GenBodyHeaderHtml(page_data)
{
  // Create the page <html>+<head> section, set language, direction, charset, etc.
  // Pass anything else you need in the <head> section instead of (null)
  CreateHead(null);

  // Create the body and type of page
  document.write("<body id='body' class='" + page_data.HtmlClass + "'>");


  // Create the body
  var body = CreateWidget(null, 'body');

  // Create a title
  var ccuDoc = L10NLoadStrings('../CCU/language/' + globalLang + '/ccu.xml');
  CreateTitle(body, L10NString(ccuDoc, 'EF_OOBE_TITLE'));
  
  return body;
}

/*
 * GenItemHtml
 *
 */
function GenItemHtml(parent_pane, item_data, loc_doc)
{
  if (item_data.ItemType == g_TAG_ITEM_TITLE)
  {
    document.write("<p><h2>" + L10NString(loc_doc, item_data.ItemId) + "</h2></p>"); 
  } else if (item_data.ItemType == g_TAG_ITEM_TEXT)
  {
    document.write("<p>" + L10NString(loc_doc, item_data.ItemId) + "</p>"); 
  } else if (item_data.ItemType == g_TAG_ITEM_BUTTON)
  {
    var button_text = L10NString(loc_doc, item_data.ItemId);
    var href_link;
    if (item_data.LinkType == g_TAG_VALUE_LINK_TYPE_HREF)
    {
      href_link = item_data.Link;
    } else
    {
      // Logic: (item_data.LinkType == g_TAG_VALUE_LINK_TYPE_PAGE) ||
      //        (item_data.LinkType == g_TAG_VALUE_LINK_TYPE_DONE)
      //            
      // When the type indicates that the current page will be reloaded
      // set the variable args to the link type and link
      href_link = '?' + g_URL_LINK_TAG + '=' + item_data.Link +
                  '&' + g_URL_LINK_TYPE_TAG + '=' + item_data.LinkType +
                  '&' + g_URL_LINK_FROM_TAG + '=' + "temp dae: this should be the current page";
    }
    
    // Otherwise, this is a direct link to a different page.
    CreateText(parent_pane, 'p', ' ');
    CreateButn(parent_pane, item_data.ItemId, button_text, function() { location = href_link; });
    
  } else if (item_data.ItemType == g_TAG_ITEM_PASSWORD)
  {
    var curr_pwd = L10NString(loc_doc, item_data.ItemId);
    //document.write('<p>');
    
    CreateEditBox(parent_pane, item_data.ItemId, curr_pwd, '', function() {}, function() {});
    //document.write('Add Edit Box Here...');
    //document.write('</p>');
  } else if (item_data.ItemType == g_TAG_ITEM_CALLBACK)
  {
    // temp dae: 
    //   1. create a SPAN element that can be modified by the callback fn.
    //   2. acquire the callback object
    //   3. call it with the id of the item and the element they can modify.
    //
    // NOTE: the content will not be navigable by remote, it can only be text.
    //
    var element = CreateWidget(parent_pane, item_data.ItemId,  "span");
    if (element != null)
    {
      locCurrentSharedObject.cbItemCallback(item_data, element);
    } else
    {
      alert ("ERR: GenItemHtml - unable to create SPAN element for callback!");
    }
  } else
  {
    alert ("ERR: GenItemHtml - invalid ItemType '" + item_data.ItemType + "\n");
  }
}

/*
 * GenNavPaneHtml
 *
 * temp dae: some templates don't have a nav pane
 *
 */
function GenNavPaneHtml(body, page_data, loc_doc)
{
  if (page_data.NavPaneItems.length == 0)
  {
    // Nothing to create
    return;
  }
  
  // Create a navigation for buttons, instructions, etc.
  document.write("<div class='NavPane' id='NavPane'>");
  
  // Create NavPane widget, vertical navigation
  var navPane = CreateWidget(body, 'NavPane', true);
  for (var ii = 0; ii < page_data.NavPaneItems.length; ii++)
  {
    GenItemHtml(navPane, page_data.NavPaneItems[ii], loc_doc);
  }
  
  document.write('</div>');
  
  return navPane;
}

/*
 * GenViewPaneHtml
 *
 * temp dae: this needs to be tested, don't forget.
 * temp dae: some templates don't have a view pane
 */
function GenViewPaneHtml(body, parent, page_data, loc_doc)
{
  if (page_data.ViewPaneItems.length == 0)
  {
    // Nothing to create
    return;
  }
  
  // Create the info pane at the bottom of the screen
  document.write("<div class='ViewPane' id='ViewPane'>");
  var infoPane = CreateWidget(body, 'ViewPane');

  for (var ii = 0; ii < page_data.ViewPaneItems.length; ii++)
  {
    GenItemHtml(infoPane, page_data.ViewPaneItems[ii], loc_doc);
    document.write('&nbsp;');
  }

  document.write('</div>');
}

/*
 * GenInfoPaneHtml
 *
 * temp dae: some templates don't have an info pane
 *
 */
function GenInfoPaneHtml(body, parent, page_data, loc_doc)
{   
  if (page_data.InfoPaneItems.length == 0)
  {
    // Nothing to create
    return;
  }
  
  // Create the info pane at the bottom of the screen
  document.write("<div class='InfoPane' id='InfoPane'>");
  var infoPane = CreateWidget(body, 'InfoPane');

  for (var ii = 0; ii < page_data.InfoPaneItems.length; ii++)
  {
    GenItemHtml(infoPane, page_data.InfoPaneItems[ii], loc_doc);
    document.write('&nbsp;');
  }

  document.write('</div>');
}

/*
 * GenBodyFooterHtml
 *
 */
function GenBodyFooterHtml(body)
{
  document.write('</body>');
  document.write('</html>');
  WidgetSetFocus(body);
}

     
/*
 * ProcessWizardPage - perform tasks necessary to create wizard pages
 *                     from an XML template.
 * INPUT: a 
 *   shared_obj      A shared object containing the following fields
 *                   This object must be shared to allow persistence
 *                   of the input data across all the pages in the wizard.
 * 
 *      XmlDataFile     - Name of the file containing the wizard page data.
 *      LocDataFile     - Name of the file containing the localized string table
 *                        for the page data.
 *      cbTaskComplete  - Callbeck method to indicate when a user has pressed
 *                        a button with a LinkType of "Done".
 *
 */     
function ProcessWizardPage(shared_obj)
{
  locCurrentSharedObject = shared_obj;
  
  var xml_data_file = shared_obj.XmlDataFile;
  var loc_data_file = shared_obj.LocDataFile;
  
  // Acquire the NEXT and FROM page arguments from the URL
  var nav_args  = GetNavigationArguments();

  // If the LinkType field is empty, its the first page in the list.
  if (nav_args.LinkType == null)
  {
    // Assume this is a new page load and get the first page
    nav_args.LinkType = g_TAG_VALUE_LINK_TYPE_PAGE;
  }
  
  // This was launched from a button press, check to see
  // if we're loading a new xml file.
  if (xml_data_file == null)
  {
    alert ("ERR: ProcessWizardPage - missing XML data file.");
    return;
  }
  
  if (nav_args.LinkType == g_TAG_VALUE_LINK_TYPE_HREF)
  {
    // We need to navigate to a completely different page.  Clear the nav variables
    // and set the current location to the specified link.
    document.location = nav_args.Link;
    return;
  }
  
  // temp dae: make this use the global data to improve performance
  var wizard_data = LoadWizardData(xml_data_file);
  if (wizard_data.PageList == null)
  {
    alert("ERR: ProcessWizardPage - No wizard pages found in page list.");
    return;
  }
  
  if (nav_args.Link == null)
  {
    // When the next page is not specified, use the first page in the list.
    nav_args.Link = wizard_data.PageList[0].PageId;
  }
  
  // Redraw the next page based on page data
  if (nav_args.LinkType == g_TAG_VALUE_LINK_TYPE_PAGE)
  {
    // Find the page data for the page associated w/ the Link field.
    for (var ii = 0; ii < wizard_data.PageList.length; ii++)
    {
      if (wizard_data.PageList[ii].PageId == nav_args.Link)
      {
        page_data = wizard_data.PageList[ii];
        break;
      }
    }
    
    try
    {
      // Load DOC object to parse the XML string file.
      var xml_doc = L10NLoadStrings(loc_data_file);
  
      // Create all the HTML for the page
      CreateWizardPage(page_data, xml_doc);
    }
  
    catch(e)
    {
      alert(e.description);
      return;
    }
  }
  
  // Perform OOBE completion status on the wizard task
  if (nav_args.LinkType == g_TAG_VALUE_LINK_TYPE_DONE)
  {
    // temp dae: call CCU OOBE complete status using nav_args.Link value
    //           call the CCU to load the next OOBE task.
    //
    // use wizard_data.WizardId
    shared_obj.cbTaskComplete(nav_args.Link);
  }
}
