/**************************************************************************\
 itk (Insomnia's ToolKit)

  By Insomnia (Steaphan Greene)
  (insomnia@core.binghamton.edu)

  Copyright (C) 1999 Steaphan Greene

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.

\**************************************************************************/

#ifndef IBOX_H
#define IBOX_H

#include <X11/X.h>   
#include <X11/Xlib.h>
#include "idodad.h"
#include "iwindow.h"

#define ITK_BUF_LEN 256

class IBox : public IDoDad  {
public:
  IBox(char *txt, IWindow *w, int xp, int yp, int xs, int ys);
  virtual ~IBox();
  virtual int Type()  { return DODAD_BOX; };
  void Disable();
  void Enable();
  int CurPos() { return tcp; };
  void SetCurPos(int);
  void SetCurPos(int, int);
  virtual int KeyDown(XKeyEvent ev);
  virtual int KeyUp(XKeyEvent ev);
  virtual int Press(int b, int x, int y);
  virtual int Release(int b, int x, int y);
  virtual void Redraw();
  virtual void Rebuild();
  virtual void GotFocus();
  virtual void LostFocus();
  virtual void Resize(int, int);
  void SetChangeCallback(void (*cb)(IDoDad *, IDoDad *));
  char *GetText() { return text; };
  virtual void SetText(char *txt);
  void SetNextFocus(IDoDad *in) { nextfocus = in; };
protected:
  IBox() {};
  void Init(char *txt, IWindow *w, int xp, int yp, int xs, int ys);
  Pixmap Img[2], Wrk[2];
  char text[256];
  int xpos, ypos, xsize, ysize;
  int disabled;
  int xscroll, Wlen, tcp, tcp2, gcp, gcp2;
  IDoDad *nextfocus;
  void (*changecallback)(IDoDad *, IDoDad *);
  };

#endif
