/**************************************************************************\
 itk (Insomnia's ToolKit)

  By Insomnia (Steaphan Greene)
  (insomnia@core.binghamton.edu)

  Copyright (C) 1999 Steaphan Greene

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.

\**************************************************************************/

#ifndef IBUTTON_H
#define IBUTTON_H

#define BUTTON_UP	0
#define BUTTON_DOWN	1
#define BUTTON_DISABLED	2

#include <X11/X.h>   
#include <X11/Xlib.h>
#include "idodad.h"
#include "iwindow.h"

class IButton : public IDoDad  {
public:
  IButton(char *txt, IWindow *w, int xp, int yp, int xs, int ys);
  virtual ~IButton();
  virtual int Type()  { return DODAD_BUTTON; };
  void Disable();
  void Enable();
  virtual int Press(int b, int x, int y);
  virtual int Release(int b, int x, int y);
  virtual void Redraw();
  virtual void Rebuild();
  virtual void Resize(int, int);
  virtual void Move(int, int);
  virtual void MoveAndResize(int, int, int, int);
  void SetClickCallback(void (*cb)(IDoDad *, IDoDad *, int));
  void SetUpCallback(void (*cb)(IDoDad *, IDoDad *, int));
  void SetDownCallback(void (*cb)(IDoDad *, IDoDad *, int));
  int State() { return state; };
protected:
  IButton() {};
  void Init(char *txt, IWindow *w, int xp, int yp, int xs, int ys);
  void Create();
  Pixmap Img[3];
  int xpos, ypos, xsize, ysize;
  int state;
  void (*clickcallback)(IDoDad *, IDoDad *, int);
  void (*upcallback)(IDoDad *, IDoDad *, int);
  void (*downcallback)(IDoDad *, IDoDad *, int);
  char *text;
  };

#endif

