/**************************************************************************\
 itk (Insomnia's ToolKit)

  By Insomnia (Steaphan Greene)
  (insomnia@core.binghamton.edu)

  Copyright (C) 1999 Steaphan Greene

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.

\**************************************************************************/

#ifndef IINTBOX_H
#define IINTBOX_H

#include <X11/X.h>   
#include <X11/Xlib.h>
#include "ibox.h"
#include "iwindow.h"
#include "ibutton.h"

class IIntBox : public IBox  {
public:
  IIntBox(int v, IWindow *w, int xp, int yp, int xs, int ys);
  virtual ~IIntBox();
  virtual int Type()  { return DODAD_INTBOX; };
  void Disable();
  void Enable();
  virtual int KeyDown(XKeyEvent ev);
  virtual int KeyUp(XKeyEvent ev);
  virtual void Rebuild();
  virtual void Redraw();
  char *GetText() { return text; };
  int GetVal() { return val; };
  void SetText(char *txt);
  virtual void SetVal(int v);
  void SetNextFocus(IDoDad *in) { nextfocus = in; };
  void SetMax(int mx);
  void SetMin(int mn);
protected:
  IIntBox() {};
  int val, vmax, vmin;
  IButton *upb, *dnb;
  void Increment(IDoDad *wb, int mb);
  void Decrement(IDoDad *wb, int mb);
  friend IButton;
  friend void __Callback__IIntBox__Increment(IDoDad *p, IDoDad *d, int v);
  friend void __Callback__IIntBox__Decrement(IDoDad *p, IDoDad *d, int v);
  };

#endif
