/**************************************************************************\
 itk (Insomnia's ToolKit)

  By Insomnia (Steaphan Greene)
  (insomnia@core.binghamton.edu)

  Copyright (C) 1999 Steaphan Greene

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.

\**************************************************************************/

#ifndef IREALBOX_H
#define IREALBOX_H

#include <X11/X.h>   
#include <X11/Xlib.h>
#include "ibox.h"
#include "iwindow.h"
#include "ibutton.h"

class IRealBox : public IBox  {
public:
  IRealBox(double v, IWindow *w, int xp, int yp, int xs, int ys, double i=1.0);
  virtual ~IRealBox();
  virtual int Type()  { return DODAD_REALBOX; };
  void Disable();
  void Enable();
  virtual int KeyDown(XKeyEvent ev);
  virtual int KeyUp(XKeyEvent ev);
  virtual void Redraw();
  virtual void Rebuild();
  char *GetText() { return text; };
  double GetVal() { return val; };
  void SetText(char *txt);
  virtual void SetVal(double v);
  virtual void SetIncVal(double i);
  void SetNextFocus(IDoDad *in) { nextfocus = in; };
  void SetMax(double mx);
  void SetMin(double mn);
protected:
  IRealBox() {};
  double val, vmax, vmin, inc;
  IButton *upb, *dnb;
  void Increment(IDoDad *wb, int mb);
  void Decrement(IDoDad *wb, int mb);
  friend IButton;
  friend void __Callback__IRealBox__Increment(IDoDad *p, IDoDad *d, int v);
  friend void __Callback__IRealBox__Decrement(IDoDad *p, IDoDad *d, int v);
  };

#endif
