/**************************************************************************\
 itk (Insomnia's ToolKit)

  By Insomnia (Steaphan Greene)
  (insomnia@core.binghamton.edu)

  Copyright (C) 1999 Steaphan Greene

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.

\**************************************************************************/

#include <stdio.h>
#include <string.h>

#include "istatbar.h"

IStatBar::~IStatBar()  {
  Win->RemoveClaim(this);
  }

IStatBar::IStatBar(IWindow *w, int xp, int yp, int xs, int ys)  {
  Init(w, xp, yp, xs, ys);
  }

void IStatBar::Init(IWindow *w, int xp, int yp, int xs, int ys)  {
  progress = 0;
  total = 0;
  xpos = xp; ypos = yp; xsize = xs; ysize = ys;
  Win = w;
  Window wind = w->GetWindowBuffer();
  Display *disp = w->GetDisplay();
  unsigned int s, p, b, g, gl, gd;
  Img = XCreatePixmap(disp, wind, xs, ys, DefaultDepth(disp, 0));
  GC gc = Win->GetGC();

//  printf("Depth = %d\n", DefaultDepth(disp, 0));

  s = w->GetSelectColor();
  p = w->GetPaperColor();
  b = w->GetFGColor();
  g = w->GetBGColor();
  gl = w->GetLBGColor();
  gd = w->GetDBGColor();

  XSetForeground(disp, gc, gl);
  XFillRectangle(disp, Img, gc, 0, 0, xs, ys);

  XSetForeground(disp, gc, g);
  XFillRectangle(disp, Img, gc, 2, 2, xs-4, ys-4);

  XSetForeground(disp, gc, gd);
  XFillRectangle(disp, Img, gc, 0, 0, xs-1, 2);
  XFillRectangle(disp, Img, gc, 0, 2, 2, ys-3);
  XDrawPoint(disp, Img, gc, 0, ys-1);
  XDrawPoint(disp, Img, gc, xs-1, 0);

  parent=NULL;

  w->AddClaim(this, xp, yp, xs, ys);

  Redraw();
  }

void IStatBar::Redraw()  {
  if(hidden) return;

  Window w = Win->GetWindowBuffer();
  Display *disp = Win->GetDisplay();
  GC gc = Win->GetGC();

  char txt[16];
  if(total > 0 && progress >= 0)
    sprintf(txt, "%d%% done%c", (progress*100)/total, 0);
  XFontStruct *fs;
  XCharStruct cs;
  int dir, as, des;
  fs = Win->GetFontStruct();
  XTextExtents(fs, txt, strlen(txt), &dir, &as, &des, &cs);
  int len = cs.width;
  XSetForeground(disp, gc, Win->GetBGColor());
  XFillRectangle(disp, Img, gc, 2, 2, xsize-4, ysize-4);
  XSetBackground(disp, gc, Win->GetBGColor());
  XSetForeground(disp, gc, Win->GetFGColor());
  XDrawImageString(disp, Img, gc, (xsize-(len-1))>>1,
	(ysize+ysize-(as+des-2))>>1, txt, strlen(txt));

  if(total > 0 && ((progress*(xsize-4))/total) > 0)  {
    int xbar = (xsize-4) <? ((progress*(xsize-4))/total);
    Pixmap Wrk = XCreatePixmap(disp, w, xbar, ysize-4, DefaultDepth(disp, 0));
    XSetForeground(disp, gc, Win->GetSelectColor());
    XFillRectangle(disp, Wrk, gc, 0, 0, xbar, ysize-4);
    XSetForeground(disp, gc, Win->GetPaperColor());
    XSetBackground(disp, gc, Win->GetSelectColor());
    XDrawImageString(disp, Wrk, gc, ((xsize-(len-1))>>1)-2,
	((ysize+ysize-(as+des-2))>>1)-2, txt, strlen(txt));
    XCopyArea(disp, Wrk, Img, gc, 0, 0, xbar, ysize-4, 2, 2);
    XFreePixmap(disp, Wrk);
    }

  XCopyArea(disp, Img, w, gc, 0, 0, xsize, ysize, xpos, ypos);
  }
