/**************************************************************************\
 itk (Insomnia's ToolKit)

  By Insomnia (Steaphan Greene)
  (insomnia@core.binghamton.edu)

  Copyright (C) 1999 Steaphan Greene

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.

\**************************************************************************/

#include <string.h>

#include "itextbox.h"

ITextBox::~ITextBox()  {
  Win->RemoveClaim(this);
  }

ITextBox::ITextBox(char *txt, IWindow *w, int xp, int yp, int xs, int ys)  {
  if(txt != NULL) Init(txt, w, xp, yp, xs, ys);
  }

void ITextBox::Init(char *txt, IWindow *w, int xp, int yp, int xs, int ys)  {
  xpos = xp; ypos = yp; xsize = xs; ysize = ys;
  Win = w;
  Window wind = w->GetWindowBuffer();
  Display *disp = w->GetDisplay();
  unsigned int p, b, g, gl, gd;
  Img = XCreatePixmap(disp, wind, xs, ys, DefaultDepth(disp, 0));
  GC gc = Win->GetGC();

  p = w->GetPaperColor();
  b = w->GetFGColor();
  g = w->GetBGColor();
  gl = w->GetLBGColor();
  gd = w->GetDBGColor();

  XFontStruct *fs;
  XCharStruct cs;
  int dir, as, des;
  fs = Win->GetFontStruct();
  XTextExtents(fs, txt, strlen(txt), &dir, &as, &des, &cs);
  int len = cs.width;
  switch(Win->Appearance()) {
    case(ITK_DEFAULT): {
      XSetForeground(disp, gc, g);
      XFillRectangle(disp, Img, gc, 0, 0, xs, ys);
      XSetBackground(disp, gc, g);
      XSetForeground(disp, gc, b);
      XDrawImageString(disp, Img, gc, (xs-(len-1))>>1, (ys+ys-(as+des-2))>>1,
	txt, strlen(txt));
      }break;
    case(ITK_STEP): {
      XSetForeground(disp, gc, gl);
      XFillRectangle(disp, Img, gc, 0, 0, xsize, ysize);

      XSetForeground(disp, gc, p);
      XDrawLine(disp, Img,gc, 0,0, 0,ysize-2);
      XDrawLine(disp, Img,gc, 0,0, xsize-2,0);

      XSetForeground(disp, gc, b);
      XDrawLine(disp, Img,gc, 0,ysize-1, xsize-1,ysize-1);
      XDrawLine(disp, Img,gc, xsize-1,0, xsize-1,ysize-1);

      XSetBackground(disp, gc, gl);
      XSetForeground(disp, gc, b);
      XDrawImageString(disp, Img, gc, (xs-(len-1))>>1, (ys+ys-(as+des-2))>>1,
	txt, strlen(txt));
      }break;
    }
  parent=NULL;

  w->AddClaim(this, xp, yp, xs, ys);

  Redraw();
  }

void ITextBox::Rebuild()  {
  Redraw();
  }

void ITextBox::Redraw()  {
  if(!hidden) {
    XCopyArea(Win->GetDisplay(), Img, Win->GetWindowBuffer(), Win->GetGC(),
	0, 0, xsize, ysize, xpos, ypos);
    Win->Redraw(xpos, ypos, xsize, ysize);
    }
  else {
    Win->Rebuild(xpos, ypos, xsize, ysize);        
    }
  }

int ITextBox::Press(int b, int x, int y)  {
  if(parent!=NULL)  parent->Press(b, x, y);
  return 1;
  }

int ITextBox::Release(int b, int x, int y)  {
  if(parent!=NULL)  parent->Release(b, x, y);
  return 1;
  }
