/**************************************************************************\
 itk (Insomnia's ToolKit)

  By Insomnia (Steaphan Greene)
  (insomnia@core.binghamton.edu)

  Copyright (C) 1999 Steaphan Greene

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.

\**************************************************************************/

#include <stdio.h>
#include <unistd.h>
#include "iwindow.h"
#include "isbutton.h"
#include "iintbox.h"
#include "irealbox.h"
#include "istatbar.h"
#include "islider.h"
#include "itextbox.h"
#include "ilistbox.h"
#include "igbox.h"

void tmp(IDoDad *p, IDoDad *d, int x);
void tmp1(IDoDad *p, IDoDad *d, int x);
void tmp2(IDoDad *p, IDoDad *d, int x);

IButton *B1, *B2, *B3;
IStatBar *S1;
IBox *I1, *I2;
IIntBox *I3;
int main()  {
  IWindow w("ITK Test Program", 320, 240);
  IButton b1("Hi", &w, 0, 0, 50, 20);
  ISButton b2("Bye", &w, 50, 0, 50, 20);
  ISButton b3("Foo", &w, 100, 0, 50, 20);
  IBox i1("Box 1", &w, 20, 30, 60, 20);
  IRealBox i2(13.6, &w, 20, 60, 60, 20, 0.1);
  IIntBox i3(0, &w, 20, 90, 60, 20);
  IStatBar s1(&w, 0, 120, 150, 20);
  ISlider sl1("Volume: ", &w, 0, 200, 150, 20);
  sl1.SetMin(-100); sl1.SetMax(100);
  ITextBox t1("Hit Hi To Increment", &w, 0, 150, 160, 20);
  char *lt[5] = {"file1", "file2", "file3", "file4", "lastfile" };
  IListBox l1(lt, 5, &w, 160, 10, 150, 100);
  IGBox g1(&w, 160, 120, 150, 110);

  b1.Show(); b2.Show(); b3.Show(); i1.Show(); i2.Show(); i3.Show();
  s1.Show(); sl1.Show(); t1.Show(); l1.Show(); g1.Show();

  i1.SetNextFocus(&i2);
  i2.SetNextFocus(&i3);
  i3.SetNextFocus(&i1);
  i3.SetVal(3);
  b1.SetClickCallback(&tmp);
  b2.SetUpCallback(&tmp1);
  b2.SetDownCallback(&tmp2);
  s1.SetTotalWork(88);
  g1.DrawPoint(0, 0, 255, 0, 0);
  g1.DrawPoint(75, 55, 255, 0, 0);
  g1.DrawLine(0, 0, 47, 107, 255, 0, 0);

  B1 = &b1; B2 = &b2; B3 = &b3; S1 = &s1;
  I1 = &i1; I2 = &i2; I3 = &i3;
  w.DispatchEvents();
  printf("I1 = \"%s\"\n", i1.GetText());
  printf("I2 = \"%s\"\n", i2.GetText());
  printf("I3 = \"%s\"\n", i3.GetText());
  int ctr;
  for(ctr=0; ctr<l1.NumSelections(); ctr++)
    printf("Sel = \"%s\"\n", l1.GetSelection(ctr));
  }

void tmp(IDoDad *p, IDoDad *d, int x)  {
  x = x;
  S1->SetProgress(S1->Progress() + 1);
  }

void tmp1(IDoDad *p, IDoDad *d, int x)  {
  x = x;
  B1->Enable();
  B3->Enable();
  I1->Enable();
  I2->Enable();
  I3->Enable();
  }

void tmp2(IDoDad *p, IDoDad *d, int x)  {
  x = x;
  B1->Disable();
  B3->Disable();
  I1->Disable();
  I2->Disable();
  I3->Disable();
  }
