/////////////////////////////////////////////////////////////////////////////
// Deform.h
//
#pragma once

#include <afxtempl.h>
#include <d3drmwin.h>

#define ROWS 100
#define COLS 100
#define NUMVERTEX ROWS*COLS

/////////////////////////////////////////////////////////////////////
// Rigid effector object
struct EFFECTOR {
	void Init(float Strength = 1.0f, float Radius = 1.0f,
		BOOL AffectedByExtForces = TRUE);
	D3DVECTOR Center;
	D3DVECTOR ExternalForce;
	float R;
	float Strength;
	BOOL AffectedByExtForces;
};

/////////////////////////////////////////////////////////////////////
// Planar surface object (C and 3DNow! version)
struct SURFACE {
	void Init(int NumRows = ROWS, int NumCols = COLS, float Mass = 1.0f,
		float Elasticity = 1.0f, float Damping = 0.995f, float dW = 1.0f,
		float dH = 1.0f);
	void GetData(D3DRMVERTEX* Vertex);
	void Deform(EFFECTOR& Effector);
	void Update(float dt);
	void UpdateUnroll(float dt);
	void Update2(float dt);
	void Update3DNow(float dt);
	int NumVertex, NumRows, NumCols;
	float Damping, Elasticity, Mass, dW, dH;
	D3DVECTOR Center;
	D3DVECTOR SRelaxE, SRelaxS, SRelaxSE;
	float SX[NUMVERTEX], SY[NUMVERTEX], SZ[NUMVERTEX];
	float ExternalForceX[NUMVERTEX], ExternalForceY[NUMVERTEX],
		ExternalForceZ[NUMVERTEX];
	float TotalForceX[NUMVERTEX], TotalForceY[NUMVERTEX],
		TotalForceZ[NUMVERTEX];
	float VX[NUMVERTEX], VY[NUMVERTEX], VZ[NUMVERTEX];
	D3DVECTOR Normal[NUMVERTEX];
	int Fixed[NUMVERTEX];
};

/////////////////////////////////////////////////////////////////////
// Planar surface object (D3DVECTOR version)
struct SURFACE2 {
	void Init(int NumRows = ROWS, int NumCols = COLS, float Mass = 1.0f,
		float Elasticity = 1.0f, float Damping = 0.995f, float dW = 1.0f,
		float dH = 1.0f);
	void GetData(D3DRMVERTEX* Vertex);
	void Deform(EFFECTOR& Effector);
	void Update(float dt);
	void Update2(float dt);
	void Update3DNow(float dt) {}
	int NumVertex, NumRows, NumCols;
	float Damping, Elasticity, Mass, dW, dH;
	D3DVECTOR Center;
	D3DVECTOR SRelaxE, SRelaxS, SRelaxSE;
	D3DVECTOR S[NUMVERTEX];
	D3DVECTOR ExternalForce[NUMVERTEX];
	D3DVECTOR TotalForce[NUMVERTEX];
	D3DVECTOR V[NUMVERTEX];
	D3DVECTOR Normal[NUMVERTEX];
	int Fixed[NUMVERTEX];
};
