/////////////////////////////////////////////////////////////////////////////
// Deform.h
//
#pragma once

#include <afxtempl.h>
#include <d3drmwin.h>

/////////////////////////////////////////////////////////////////////
// SIMD Vector (3DNow!)
struct VECTOR2 {
	float x[2], y[2], z[2];
};

/////////////////////////////////////////////////////////////////////
// Vertex information (3DNow!)
struct VERTEX {
	VECTOR2 S;
	VECTOR2 TotalForce;
	VECTOR2 V;
	int Fixed[2];
};

/////////////////////////////////////////////////////////////////////
// Planar surface object (C and 3DNow! version)
struct SURFACE3 {
	void Init(int NumRows = ROWS, int NumCols = COLS, float Mass = 1.0f,
		float Elasticity = 1.0f, float Damping = 0.995f, float dW = 1.0f,
		float dH = 1.0f);
	void GetData(D3DRMVERTEX* Vertex);
	void Deform(EFFECTOR& Effector);
	void Update(float dt);
	void Update3DNow(float dt);
	int NumVertex, NumRows, NumCols;
	float Damping, Elasticity, Mass, dW, dH;
	D3DVECTOR Center;
	D3DVECTOR SRelaxE, SRelaxS, SRelaxSE;
	VERTEX Vertex[NUMVERTEX/2];
	VECTOR2 ExtForce[NUMVERTEX/2];
	D3DVECTOR Normal[NUMVERTEX];
};
