// DemoView.h : interface of the CDemoView class
//
/////////////////////////////////////////////////////////////////////////////

#if !defined(AFX_LORDSVIEW_H__1AD8362B_2E53_11D3_A9C0_00C04FAE2B5A__INCLUDED_)
#define AFX_LORDSVIEW_H__1AD8362B_2E53_11D3_A9C0_00C04FAE2B5A__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "D3DFrame.h"
#include "D3DEnum.h"
#include "D3DUtil.h"
#include "D3DTextr.h"

/////////////////////////////////////////////////////////////////////////////
// CDemoView window

class CDemoView : public CWnd
{
    CD3DFramework*      m_pFramework;
    D3DDEVICEINFO*      m_pDeviceInfo;
    D3DDEVICEINFO*      m_pFullScreenDeviceInfo;

    BOOL                m_bUsingHELForWindowedMode;
    HWND                m_hwndRenderFullScreen;
    
	BOOL                m_bPaused;
	BOOL                m_bSingleStep;
    BOOL                m_bReady;
    BOOL                m_bWindowed;
	BOOL m_bTexture, m_bWireframe;

	DWORD               m_dwBaseTime;
	DWORD               m_dwPauseTime;

    HRESULT AppInitialize(HWND);
    HRESULT Initialize3DEnvironment();
	void UpdateDeviceInfo();
    HRESULT Change3DEnvironment();
    HRESULT Restore3DEnvironment();
    HRESULT OutputText(DWORD, DWORD, LPCSTR);

    void    GetSelectedDriverInfo();

// Construction
public:
	CDemoView();

// Attributes
public:
	HACCEL	m_hAcc;

// Operations
public:
    void    Cleanup3DEnvironment();
    HRESULT Render3DEnvironment();
    void    GoFullScreen();
    void    GoWindowed();
    void    Move(int, int);
	void	InitialUpdate();

// Operations
public:

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CDemoView)
	public:
	protected:
	virtual BOOL PreCreateWindow(CREATESTRUCT& cs);
	//}}AFX_VIRTUAL

// Implementation
public:
	virtual ~CDemoView();

	// Generated message map functions
protected:
	//{{AFX_MSG(CDemoView)
	afx_msg void OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags);
	afx_msg void OnToggleFullscreen();
	afx_msg void OnChangeDevice();
	afx_msg void OnPause();
	afx_msg void OnUpdatePause(CCmdUI* pCmdUI);
	afx_msg void OnUpdateFullscreen(CCmdUI* pCmdUI);
	afx_msg void OnExit();
	afx_msg void OnDithering();
	afx_msg void OnUpdateDithering(CCmdUI* pCmdUI);
	afx_msg void OnLinearFilter();
	afx_msg void OnUpdateLinearFilter(CCmdUI* pCmdUI);
	afx_msg void OnPointFilter();
	afx_msg void OnUpdatePointFilter(CCmdUI* pCmdUI);
	afx_msg void OnMippointFilter();
	afx_msg void OnUpdateMippointFilter(CCmdUI* pCmdUI);
	afx_msg void OnMiplinearFilter();
	afx_msg void OnUpdateMiplinearFilter(CCmdUI* pCmdUI);
	afx_msg void OnLinearmippointFilter();
	afx_msg void OnUpdateLinearmippointFilter(CCmdUI* pCmdUI);
	afx_msg void OnLinearmiplinearFilter();
	afx_msg void OnUpdateLinearmiplinearFilter(CCmdUI* pCmdUI);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_LORDSVIEW_H__1AD8362B_2E53_11D3_A9C0_00C04FAE2B5A__INCLUDED_)
