/////////////////////////////////////////////////////////////////////////////
// Scene.h
//

#pragma once

#include <afxtempl.h>
#include <d3drmwin.h>
#include "Deform.h"
#include "Deform2.h"

// Macros
#ifndef SAFE_RELEASE
#define SAFE_RELEASE(x) if ( x != NULL ) { x->Release(); x = NULL; }
#endif
#define MSG(str) MessageBox(NULL, str, "Application Message", MB_OK)

// Constants
#define PI 3.14159265359f
#define MAX_DRIVERS 5
#define MOVE FALSE

/////////////////////////////////////////////////////////////////////////////
// CScene
class CScene {
public:
	CScene();
	~CScene();

// Operations
	void Release();
	BOOL Create();
	HRESULT CreateDevAndView(LPDIRECT3D2 lpD3D,	LPDIRECT3DDEVICE2 lpD3DDev/*GUID* pDriverGIUD, HWND hWnd,
		LPDIRECTDRAW4 lpDD, LPDIRECTDRAWSURFACE4 lpBack*/);
	BOOL SetCamera(D3DVALUE x, D3DVALUE z);
	BOOL Render(BOOL bNoMove = TRUE);
	void SetRenderState();
	D3DVALUE GetHeight(D3DVALUE x, D3DVALUE z);
	BOOL Build();
	void DoDeformations(float dT);
	LPDIRECT3DRMFRAME3 LoadMesh(LPCSTR FileName, D3DVALUE x, D3DVALUE z);

public:
	D3DVALUE m_Alpha;
	D3DVECTOR m_ZAxis, m_CameraPos;
	LPDIRECT3DRMFRAME3 m_Camera;			// Frame describing the users POV
	LPDIRECT3DRMFRAME3 m_Scene;				// Master frame in which others are placed
	LPDIRECT3DRM3 m_D3DRM;					// D3DRM object
	SURFACE m_Surface;
	// Rendering control
	D3DRMRENDERQUALITY m_RenderQuality;		// Current shade, fill and light state
	D3DRMTEXTUREQUALITY m_TextureQuality;	// Current texture interpolation
	BOOL m_bDithering;						// Dithering enable flag
	LPDIRECT3DRMDEVICE3	m_Device;			// D3DRM device 
	LPDIRECT3DRMVIEWPORT2 m_Viewport;		// D3DRM viewport
	__int64 m_Cycles;

//private:
	BOOL m_b3DNow;
	LPDIRECT3DRMLIGHT m_Ambient, m_Parallel;
    LPDIRECT3DRMTEXTURE3 m_Background;
	LPDIRECT3DRMMESH m_Mesh;
	LPDIRECT3DRMFRAME3 m_Frame, m_Lights;
	LPDIRECT3DRMTEXTURE3 m_Texture;
	D3DRMVERTEX m_Vertex[NUMVERTEX];
	unsigned m_FaceData[(ROWS - 1)*(COLS - 1)*6];// Surface faces
};
