;Script file for Anytime Deluxe 6.0
;Copyright 2001 by by Freedom Scientific BLV Group, LLC
;version 5.10
;
;****************************************
;*	        Written By		*	
;*	Freedom Scientific Scripting	*
;*		Team Gold		*
;****************************************
;
include"HjHelp.jsh"
include "hjconst.jsh"
include "hjglobal.jsh"
include "ATW.JSH"
include "ATW.JSM"
include "common.jsm"

globals
	int iATWCurrentReal,
	int nSuppressEcho,
	int ATWFirstTime,
	int iGlobNotebookFirstTime,
	int iGlobOnlineFirstTime,
	int iGlobSpeakColors,
	int iFauxDialog,
	int iATWGlobDirection,
	int iATWGlobDateColor

void function HandleCustomWindows (handle hwnd)
var
	int iControl,
	handle hPrompt,
	string sRealName
If (GetWindowName (GetRealWindow (hwnd)) == GetWindowName (GetAppMainWindow (hwnd))) then
	let iFauxDialog = true
	return 0
EndIf
let iFauxDialog = false
let iControl = GetControlID (hwnd)
If (iATWCurrentReal == iDayPlanner) then
If (iControl ==iDDayPlannerMain) then
	SayFormattedMessage (ot_window_name, msg10_L) ; "Appointments"
	SayWindow (hwnd, read_highlighted)
	let iATWGlobDateColor = NoColor
	return 1
EndIf
If (iControl == iDToDoList) then
	let hPrompt = FindDescendantWindow (GetParent (hwnd), iDToDoListPrompt)
	SayWindow (hPrompt, read_everything)
	let iATWGlobDateColor = NoColor
	return 1
EndIf
If (iControl == iDApptEvent) then
	SayFormattedMessage (ot_window_name, msg11_L) ; "Events"
	SayWindow (hwnd, read_everything)
	let iATWGlobDateColor = NoColor
	return 1
EndIf
EndIf
If (iATWCurrentReal > 5) then
	let iControl = iControl+iATWCurrentReal
	let hPrompt = FindDescendantWindow (GetParent (hwnd), iControl)
	SayWindow (hPrompt, read_everything)
	SayWindow (hwnd, read_everything)
	let iATWGlobDateColor = NoColor
	return 0
EndIf
If (iATWCurrentReal == iYearGlance) then
	SaveCursor ()
	InvisibleCursor ()
	MoveToWindow (hwnd)
	SayTextBetween (GetWindowLeft (hwnd), GetWindowRight (hwnd))
	RestoreCursor ()
	SayWeekLetter ()
	colorEvent ()
	SayWindow (hwnd, read_highlighted)
	return 1
EndIf
If (iATWCurrentReal == iNotebook) then
	If (iGlobNotebookFirstTime == 0) then
		let sRealName = GetWindowName (GetRealWindow (hwnd))
		SayFormattedMessage (ot_smart_help, msg5_L+sRealName+msg6_L, msg5_S+sRealName+msg6_L) ; "Use F6 and Shift+F6 to switch between paines in this window"
		let iGlobNoteBookFirstTime = 1
	EndIf
	If (iControl == iDNotesTitles) then
		SayFormattedMessage (ot_window_name, msg8_L) ; "Select list box"
		SayWindow (hwnd, read_highlighted)
		return 0
	ElIf (iControl == iDNotesEdit) then
		SayFormattedMessage (ot_window_name, msg9_L) ; "Notes"
		return 0
	EndIf
EndIf
If (iATWCurrentReal == iAddressbook) then
	let hPrompt = FindDescendantWindow (GetParent (hwnd), iControl+2)
	SayWindow (hPrompt, read_everything)
		SayWindow (hwnd, read_highlighted)
	return 1
EndIf
If (iATWCurrentReal == iAnytimeOnline) then
	If (iGlobOnlineFirstTime == 0) then
		let sRealName = GetWindowName (GetRealWindow (hwnd))
		SayFormattedMessage (ot_smart_help, msg5_L+sRealName+msg6_L, msg5_S+sRealName+msg6_L) ; "Use F6 and Shift+F6 to switch between panes in this window"
		let iGlobOnlineFirstTime = 1
	EndIf
EndIf
If (iControl == iDBasicColors ||
	iControl == iDCustomColors) then
	SayWindow (GetPriorWindow (hwnd), read_everything)
	return 0
EndIf
return 0
EndFunction

void function HandleCustomeRealWindows (handle hwnd)
var
	string sRealName,
	int iWinType,
	int iCount
let sRealName = GetWindowName (GetRealWindow (hwnd))
If (sRealName == wnDayPlanner1) then
	SayFormattedMessage (ot_window_name, sRealName)
	SayDate ()
	let iATWCurrentReal = iDayPlanner
	return 1
ElIf (sRealName == wnAddressbook1) then
	let iATWCurrentReal = iAddressbook
ElIf (sRealName == wnNotebook1) then
	let iATWCurrentReal = iNotebook
ElIf (sRealName == wnWeekGlance1) then
	let iATWCurrentReal = iWeekGlance
ElIf (sRealName == wnMonthGlance1) then
	SayFormattedMessage (ot_window_name, sRealName)
	SayMonth ()
	let iATWCurrentReal = iMonthGlance
	return 1
ElIf (sRealName == wnYearGlance1) then
	let iATWGlobDirection = off
	SayFormattedMessage (ot_window_name, sRealName)
	SayYear ()
	let iATWCurrentReal = iYearGlance
	return 1
ElIf (sRealName == wnAnytimeOnline1) then
	let iATWCurrentReal = iAnytimeOnline
	return 0
else
	let iATWCurrentReal = 0
EndIf
If (IsMultiPageDialog ()) then
	SayFormattedMessage (ot_window_name, GetWindowName (hwnd))
	let hwnd = GetFirstChild (hwnd)
	While (hwnd)
	let iWinType = GetWindowSubTypeCode (hwnd)
		If (iWinType == wt_tabcontrol) then
			SayWindowTypeAndText (hwnd)
			return 1
		EndIf
		let hwnd = GetNextWindow (hwnd)
	EndWhile
	return 1
EndIf
if (sRealName == wnAppointmentConflict1) then
	SayWindowTypeAndText (hwnd)
		let hwnd = FindDescendantWindow (hwnd, iDTheAppointment)
	SayWindowTypeAndText (GetNextWindow (hwnd))
	let hwnd = GetPriorWindow (hwnd)
		SayWindowTypeAndText (hwnd)
	while (iCount < 4)
		let hwnd = GetNextWindow (hwnd)
		let iCount = iCount+1;
	EndWhile
	SayWindowTypeAndText (hwnd)
	return 1
EndIf
return 0
EndFunction

Function FocusChangedEvent (handle FocusWindow, handle PrevWindow)
var
	handle RealWindow,
	string RealWindowName,
	handle AppWindow
If (nSuppressEcho == on) then
	return
EndIf
let RealWindow = GetRealWindow (FocusWindow)
let RealWindowName = GetWindowName (RealWindow)
let AppWindow = GetAppMainWindow (FocusWindow)
if (GlobalPrevApp != AppWindow && AppWindow != FocusWindow) then
; we've switched to a different app main window,
; and it does not have the focus, so announce it
	SayWindowTypeAndText (AppWindow)
endif
If ((GlobalPrevRealName != RealWindowName) ; name has changed
|| (GlobalPrevReal != RealWindow)) then ; or handle has changed, then
	If ((RealWindow != AppWindow) && (RealWindow != FocusWindow)) then
		If (HandleCustomeRealWindows (RealWindow) == 0) then
			SayWindowTypeAndText (RealWindow)
		EndIf
	endif
EndIf
let GlobalFocusWindow = FocusWindow
if (GlobalPrevFocus != focusWindow) then
	If (HandleCustomWindows (FocusWindow) == 0) then
		SayFocusedWindow () ; will use global variable GlobalFocusWindow
	EndIf
else
	SayFocusedObject ()
EndIf
;above perform will return here to finish this routine
;now set all the global variables for next time.
let GlobalPrevReal = RealWindow
let GlobalPrevRealName = RealWindowName
let GlobalPrevApp = AppWindow
let GlobalPrevFocus = FocusWindow
EndFunction

void Function AutoStartEvent ()
If (ATWFirstTime == 0) then
	SayFormattedMessage (OT_APP_START, msgAutoStart1_L, msgAutoStart1_S)
	let ATWFirstTime = 1
EndIf
EndFunction

Script SayWindowPromptAndText ()
var
	handle hwnd,
	int iSubType,
	int nMode
let hwnd= GetCurrentWindow ()
Let iSubType = GetWindowSubTypeCode (hWnd)
If ! iSubType then
	Let iSubType = GetObjectSubTypeCode ()
EndIf
let nMode=smmTrainingModeActive()
smmToggleTrainingMode(TRUE)
If HandleCustomWindows(hwnd) then
	SayTutorialHelp (iSubType, TRUE)
	SayTutorialHelpHotKey (hWnd, TRUE)
	smmToggleTrainingMode(nMode)
else
	smmToggleTrainingMode(nMode)
	PerformScript SayWindowPromptAndText ()
EndIf
EndScript

void function ObjStateChangedEvent (handle hObj)
var
	int iObjType
Let iObjType = GetObjectTypeCode ()
if (iObjType == wt_checkbox) then
	return
EndIf
ObjStateChangedEvent (hObj)
EndFunction

Void Function NewTextEvent (handle hwnd, string buffer, int nAttributes,
int nTextColor, int nBackgroundColor, int nEcho, string sFrameName)
var
	int iControl
CheckForUrgentConversation (hwnd, buffer)
let iControl = GetControlID (hwnd)
if (iControl == iDStatusBar) then
	if (buffer == scEventBlank1) then
		SayFormattedMessage (ot_screen_message, buffer)
		return
	EndIf
EndIf
NewTextEvent (hwnd, buffer, nAttributes,
nTextColor, nBackgroundColor, nEcho, sFrameName)
EndFunction

void function SayHighlightedText (handle hwnd, string buffer, int nTextColor)
var
	int iControl
If ((DialogActive () || iFauxDialog) &&
	hwnd != GetFocus () && !(GlobalMenuMode)) then
	return
EndIf
If ((iATWCurrentReal == iDayPlanner ||
	iATWCurrentReal == iMonthGlance ||
	iATWCurrentReal == iWeekGlance ||
	iATWCurrentReal == iYearGlance) &&
	hwnd == GlobalFocusWindow) then
	let iATWGlobDateColor = nTextColor
	ColorEvent ()
	SayHighlightedText (hwnd, buffer, nTextColor)
	return
EndIf
let iControl = GetControlID (hwnd)
If (iControl == iDEventsList) then
	TypeKey (ks1)
EndIf
SayHighlightedText (hwnd, buffer, nTextColor)
EndFunction

Script ScriptFileName ()
ScriptAndAppNames (fnAnyTime1 )
EndScript

Script ScreenSensitiveHelp ()
var
	handle hwnd,
	string sClass,
	string sRealName
If (IsSameScript ()) then
	AppFileTopic (topic_Anytime_Delux)
	Return
EndIf
If UserBufferIsActive () then
	 UserBufferDeactivate ()
 	SayFormattedMessage (OT_USER_BUFFER, cMsgScreenSensitiveHelpBuf)
	 Return
EndIf
let hwnd = GetCurrentWindow ()
let sClass = GetWindowClass (hwnd)
If (sClass == wcATWListBox) then
	let sRealName = GetWindowName (GetRealWindow (hwnd))
	SayFormattedMessage (ot_user_buffer, msgScreenSensitiveHelp1_L, msgScreenSensitiveHelp1_S)
	AddHotKeyLinks ()
	return
EndIf
PerformScript ScreenSensitiveHelp ()
EndScript

Script HotKeyHelp ()
	SayFormattedMessage (ot_user_buffer, msgHotKeyHelp1_L, msgHotKeyHelp1_S)
EndScript

Script ToolbarList ()
var
	int nIncludeGraphics,
	int nIndex,
	int nRowToClick,
	int nColToClick
If (DialogActive ()) then
	SayFormattedMessage (ot_error, msg13_L, msg13_S) ; "You must exit the current dialog in order to access the toolbar"
	return
EndIf
let nIncludeGraphics = GetJcfOption(OPT_INCLUDE_GRAPHICS)
SetJcfOption (OPT_INCLUDE_GRAPHICS, 1) ; labeld graphics only
let g_strGraphicsList = ""
let g_strGraphicsListX = ""
let g_strGraphicsListY = ""
GraphicsEnumerate(GetAppMainWindow(GetFocus()),msgx1)
SetJcfOption (OPT_INCLUDE_GRAPHICS, nIncludeGraphics)
if  !(g_strGraphicsList) then
	SayFormattedMessage (ot_error, msg12_L, msg12_S) ; "Toolbar not found"
	return
EndIf
let g_strGraphicsListX = StringChopLeft (g_strGraphicsListX, 1)
let g_strGraphicsListy = StringChopLeft (g_strGraphicsListy, 1)
let nIndex = DlgSelectItemInList (g_strGraphicsList,msgListName1_L, true)
If (nIndex != 0) then
	let nSuppressEcho = on
	let nRowToClick =
	StringToInt(StringSegment(g_strGraphicsListX,Separator,nIndex))
	let nColToClick =
	StringToInt(StringSegment(g_strGraphicsListY,Separator,nIndex))
	SaveCursor()
	JawsCursor()
	MoveTo(nColToClick,nRowToClick)
	LeftMouseButton()
	RestoreCursor ()
	let nSuppressEcho = off
EndIf
EndScript

Script Tab ()
var
	handle hwnd,
	int iControl
let hwnd = GetFocus ()
let iControl = GetControlID (hwnd)
If (iControl == iDGroupColors) then
	SayCurrentScriptKeyLabel ()
	let hwnd = FindDescendantWindow (GetParent (hwnd), iDEventsList)
	SetFocus (hwnd)
	return
EndIf
PerformScript Tab ()
EndScript

Script ShiftTab ()
var
	handle hwnd,
	int iControl
let hwnd = GetFocus ()
let iControl = GetControlID (hwnd)
If (iControl == iDFiltersRadio) then
	SayCurrentScriptKeyLabel ()
	let hwnd = FindDescendantWindow (GetParent (hwnd), iDEventsList)
	SetFocus (hwnd)
	return
EndIf
PerformScript ShiftTab ()
EndScript

Script Spacebar ()
var
	int iGraphicsSetting,
	int iObjType
SayCurrentScriptKeyLabel ()
let iObjType = GetObjectSubTypeCode () 
if (iObjType == wt_checkbox) then
	TypeKey(ks1)
	delay (2)
	Say (GetObjectState (), ot_item_state)
	return
EndIf
If (iObjType != wt_treeview) then
	TypeCurrentScriptKey ()
	return
EndIf
If (IsPCCursor ()) then
	let iGraphicsSetting = GetJCFOption (opt_graphics_mode)
	SetJCFOption (opt_graphics_mode, 2)
	SaveCursor ()
	JawsCursor ()
	RouteJawsToPC ()
	PriorWord ()
	LeftMouseButton ()
	RestoreCursor ()
	SetJCFOption (opt_graphics_mode, iGraphicsSetting)
EndIf
EndScript

string function GetColorName (int iColor)
var
	string sColor
let sColor = ColorToRGBString (iColor)
let sColor = IniReadString (sectColors, sColor, "", fnAtwJsi1 )
If (sColor == "") then
	return GetColorName (iColor)
else
	return sColor
EndIf
EndFunction

void function ColorEvent ()
var
	string sForeground,
	string sValue
If (iATWGlobDateColor != NoColor) then
	let sForeground = GetColorName (iATWGlobDateColor)
else
	let sForeground = GetColorName (GetColorText ())
EndIf
let sValue = IniReadString (sectColorEvents, sForeground, "", fnAtwJsi1 )
If (sValue != "") then
	SayFormattedMessage (ot_no_disable, sValue)
	return
elIf (iGlobSpeakColors == true) then
	SayFormattedMessage (ot_no_disable, sForeground)
EndIf
EndFunction

Script SetColorEvent ()
var
	string sForeground,
	string sValue,
	string sPrompt
If (!(iATWCurrentReal == iYearGlance ||
iATWCurrentReal == iMonthGlance ||
iATWCurrentReal == iWeekGlance ||
iATWCurrentReal == iDayPlanner) ||
(DialogActive () || iFauxDialog)) then
	SayFormattedMessage (ot_error, msg19_L, msg19_S) ; This view is not available for color labelling
	return
EndIf
If (iATWGlobDateColor != NoColor) then
	let sForeground = GetColorName (iATWGlobDateColor)
else
	let sForeground = GetColorName (GetColorText ())
EndIf
let sPrompt = FormatString (msg16_L, sForeground)
let sValue = ""
InputBox (sPrompt, msg17_L, sValue)
;SayString (sValue)
If (sValue == "") then
	return
EndIf
IniWriteString (sectColorEvents, sForeground, sValue, fnAtwJsi1 )
SayFormattedMessage (ot_jaws_message, msg18_L, msg18_S)
return
EndScript

Script DeleteColorEvent ()
var
	string sForeground,
	int iValue,
	string sPrompt
If (!(iATWCurrentReal == iYearGlance ||
iATWCurrentReal == iMonthGlance ||
iATWCurrentReal == iWeekGlance ||
iATWCurrentReal == iDayPlanner) ||
(DialogActive () || iFauxDialog)) then
	SayFormattedMessage (ot_error, msg19_L, msg19_S) ; This view is not available for color labelling
	return
EndIf
If (iATWGlobDateColor != NoColor) then
	let sForeground = GetColorName (iATWGlobDateColor)
else
	let sForeground = GetColorName (GetColorText ())
EndIf
let sPrompt = FormatString (msg20_L, sForeground)
let iValue = ExMessageBox (sPrompt, msg21_L, MB_OKCANCEL|MB_ICONQUESTION)
If (!iValue) then
	return
EndIf
;SayFormattedMessage (ot_jaws_message, sPrompt)
IniRemoveKey (sectColorEvents, sForeground, fnAtwJsi1 )
EndScript

Script ToggleSpeakColors ()
If (iGlobSpeakColors == false) then
	let iGlobSpeakColors = true
	SayFormattedMessage (ot_status, msg14_L, msg14_S)
else
	let iGlobSpeakColors = false
	SayFormattedMessage (ot_status, msg15_L, msg15_S)
EndIf
EndScript

Script SayLine ()
var
	handle hwnd,
	int iControl,
	int iWinType,
	handle hPrompt,
	string sRealName
If IsSameScript () then
	SpellLine ()
	Return;
EndIf
If (DialogActive () || iFauxDialog) then
let hwnd = GetCurrentWindow ()
let iControl = GetControlID (hwnd)
	let iWinType = GetWindowSubTypeCode (hwnd)
	If ((iControl == iDAlarmSound && iWinType == wt_combobox) ||
		(iControl == iDAlarmMinutes && iWinType == wt_edit_spinbox)) then
		PerformScript SayWindowPromptAndText ()
		return
	EndIf
	PerformScript SayLine ()
	return
EndIf
If (IsPCCursor ()) then
	let hwnd = GetCurrentWindow ()
	let iControl = GetControlID (hwnd)
	;SayInteger (iControl)
	If (iATWCurrentReal == iDayPlanner) then
		If (iControl ==iDDayPlannerMain) then
			SayFormattedMessage (ot_window_name, msg10_L) ; "Appointments"
			ColorEvent ()
			SayWindow (hwnd, read_highlighted)
			return
		EndIf
		If (iControl == iDToDoList) then
			let hPrompt = FindDescendantWindow (GetParent (hwnd), iDToDoListPrompt)
			SayWindow (hPrompt, read_everything)
			colorEvent ()
			SayWindow (hwnd, read_highlighted)
			return
		EndIf
		If (iControl == iDApptEvent) then
			SayFormattedMessage (ot_window_name, msg11_L) ; "Events"
			ColorEvent ()
			SayWindow (hwnd, read_highlighted)
			return
		EndIf
	EndIf
	If (iATWCurrentReal > 5) then
		let iControl = iControl+iATWCurrentReal
		let hPrompt = FindDescendantWindow (GetParent (hwnd), iControl)
		SayWindow (hPrompt, read_everything)
		ColorEvent ()
		SayWindow (hwnd, read_highlighted)
		return
	EndIf
	If (iATWCurrentReal == iYearGlance && GlobalMenuMode == 0) then
		SayYear ()
		SaveCursor ()
		InvisibleCursor ()
		MoveToWindow (hwnd)
		SayTextBetween (GetWindowLeft (hwnd), GetWindowRight (hwnd))
		RestoreCursor ()
		SayWeekLetter ()
		ColorEvent ()
		SayWindow (hwnd, read_highlighted)
		return
	EndIf
	If (iATWCurrentReal == iNotebook) then
		If (iControl == iDNotesTitles) then
			SayFormattedMessage (ot_window_name, msg8_L) ; "Select list box"
			SayWindow (hwnd, read_highlighted)
			return
		EndIf
	EndIf
	If (iATWCurrentReal == iAddressbook) then
		let hPrompt = FindDescendantWindow (GetParent (hwnd), iControl+2)
		SayWindow (hPrompt, read_everything)
		SayWindow (hwnd, read_highlighted)
		return
	EndIf
EndIf
PerformScript SayLine ()
EndScript

Script SayNextWord ()
var
	handle hwnd,
	int iWinType
If (IsPCCursor ()) then
	let hwnd = GetCurrentWindow ()
	let iWinType = GetWindowSubTypeCode (hwnd)
	If (iWinType == wt_unknown) then
		If (iATWCurrentReal == iDayPlanner) then
			NextWord ()
			SayDate ()
			return
		ElIf (iATWCurrentReal == iWeekGlance) then
			NextWord ()
			performScript SayWindowPromptAndText ()
			return
		ElIf (iATWCurrentReal == iMonthGlance) then
			NextWord ()
			SayMonth ()
			return
		ElIf (iATWCurrentReal == iAddressbook) then
			NextWord ()
			PerformScript SayWindowPromptAndText ()
			return
		ElIf (iATWCurrentReal == iYearGlance) then
			NextWord ()
			SayYear ()
			return
		EndIf
	EndIf
EndIf
PerformScript SayNextWord ()
EndScript

Script SayPriorWord ()
var
	handle hwnd,
	int iWinType
If (IsPCCursor ()) then
	let hwnd = GetCurrentWindow ()
	let iWinType = GetWindowSubTypeCode (hwnd)
	If (iWinType == wt_unknown) then
		If (iATWCurrentReal == iDayPlanner) then
			PriorWord ()
			SayDate ()
			return
		ElIf (iATWCurrentReal == iWeekGlance) then
			PriorWord ()
			performScript SayWindowPromptAndText ()
			return
		ElIf (iATWCurrentReal == iMonthGlance) then
			PriorWord ()
			SayMonth ()
			return
		ElIf (iATWCurrentReal == iAddressbook) then
			PriorWord ()
			PerformScript SayWindowPromptAndText ()
			return
		ElIf (iATWCurrentReal == iYearGlance) then
			PriorWord ()
			SayYear ()
			return
		EndIf
	EndIf
EndIf
PerformScript SayPriorWord ()
EndScript

Function SayWeekLetter ()
;Used to read the week letters in the year view
var
	int iRestriction
If (IsKeyWaiting ()) then
	return
EndIf
SaveCursor ()
InvisibleCursor ()
RouteInvisibleToPC ()
let iRestriction = GetRestriction ()
SetRestriction (RestrictWindow)
JawsPageUp ()
NextLine ()
While (GetCharacter () == "")
	NextCharacter ()
EndWhile
SayCharacter ()
RestoreCursor ()
SetRestriction (iRestriction)
EndFunction

Script SayNextCharacter ()
If (DialogActive () || iFauxDialog) then
	PerformScript SayNextCharacter ()
	return
EndIf
If (iATWCurrentReal == iYearGlance && IsPCCursor () && GlobalMenuMode == 0) then
	let iATWGlobDirection = LeftRight
	NextCharacter ()
	return
EndIf
PerformScript SayNextCharacter ()
EndScript

Script SayPriorCharacter ()
If (DialogActive () || iFauxDialog) then
	PerformScript SayPriorCharacter ()
	return
EndIf
If (iATWCurrentReal == iYearGlance && IsPCCursor () && GlobalMenuMode == 0) then
	let iATWGlobDirection = LeftRight
	PriorCharacter ()
	return
EndIf
PerformScript SayPriorCharacter ()
EndScript

Script SayCharacter ()
var
	handle hwnd,
	int iWinType
If (iATWCurrentReal == iYearGlance && IsPCCursor () && GlobalMenuMode == 0) then
	let hwnd= GetCurrentWindow ()
	let iWinType = GetWindowSubTypeCode (hwnd)
	If (iWinType == wt_unknown) then
		SayWeekLetter ()
		ColorEvent ()
		SayWindow (hwnd, read_highlighted)
		return
	EndIf
EndIf
If (iFauxDialog == true) then
	let hwnd= GetCurrentWindow ()
	let iWinType = GetWindowSubTypeCode (hwnd)
	If (iWinType == wt_button) then
		SayWord ()
	return
	EndIf
EndIf
PerformScript SayCharacter ()
EndScript

Script SayWord ()
var
	handle hwnd,
	int iWinType
If (DialogActive () || iFauxDialog) then
	PerformScript SayWord ()
	return
EndIf
If (iATWCurrentReal == iYearGlance && IsPCCursor () && GlobalMenuMode == 0) then
	SayWeekLetter ()
	ColorEvent ()
	SayWord ()
	return
EndIf
PerformScript SayWord ()
EndScript

Script SayNextLine ()
var
	handle hwnd,
	int iControl,
	int iWinType
If ((DialogActive () || iFauxDialog) && IsPCCursor ()) then
	let hwnd = GetCurrentWindow ()
	let iControl = GetControlID (hwnd)
	let iWinType = GetWindowSubTypeCode (hwnd)
	If ((iControl == iDAlarmSound && iWinType == wt_combobox) ||
		(iControl == iDAlarmMinutes && iWinType == wt_edit_spinbox)) then
		NextLine ()
		SayWord ()
		return
	EndIf
	PerformScript SayNextLine ()
	return
EndIf
If (iATWCurrentReal == iYearGlance && IsPCCursor () && GlobalMenuMode == 0) then
	let iATWGlobDirection = upDown
	NextLine ()
	return
EndIf
pause ()
PerformScript SayNextLine ()
EndScript

Script SayPriorLine ()
var
	handle hwnd,
	int iControl,
	int iWinType
If ((DialogActive () || iFauxDialog) && IsPCCursor ()) then
	let hwnd = GetCurrentWindow ()
	let iControl = GetControlID (hwnd)
	let iWinType = GetWindowSubTypeCode (hwnd)
	If ((iControl == iDAlarmSound && iWinType == wt_combobox) ||
		(iControl == iDAlarmMinutes && iWinType == wt_edit_spinbox)) then
		PriorLine ()
		SayWord ()
		return
	EndIf
	PerformScript SayPriorLine ()
	return
EndIf
If (iATWCurrentReal == iYearGlance && IsPCCursor () && GlobalMenuMode == 0) then
	let iATWGlobDirection = upDown
	PriorLine ()
	return
EndIf
pause ()
PerformScript SayPriorLine ()
EndScript

Function SayDate ()
var
	handle hdate,
	handle hDay,
	handle hMonth
let hDate = FindDescendantWindow (GetRealWindow (GetCurrentWindow ()), iDCalendarDate)
let hDay = GetNextWindow (GetNextWindow (hDate))
let hMonth = GetNextWindow (hDay)
SayWindow (hDay, read_everything)
SayWindowTypeAndText (hDate)
SayWindow (hMonth, read_everything)
EndFunction

Script SayCalendarDate ()
var
	handle hdate
If (iATWCurrentReal != iDayPlanner) then
	SayFormattedMessage (ot_error, msg2_L, msg2_S) ; "This keystroke is only available in the Day Planner View"
	return
EndIf
let hDate = FindDescendantWindow (GetRealWindow (GetCurrentWindow ()), iDCalendarDate)
If (!IsWindowVisible (hDate) || IsWindowObscured (hDate)) then
	SayFormattedMessage (ot_error, msg1_L, msg1_S) ; "Window not found"
	return
EndIf
SayDate ()
EndScript

Function SayMonth ()
var
	handle hMonth
let hMonth = FindDescendantWindow (GetRealWindow (GetCurrentWindow ()), iDApptEvent)
SayWindow (hMonth, read_everything)
EndFunction

Script SayCalendarMonth ()
var
	handle hMonth
If (iATWCurrentReal != iMonthGlance) then
	SayFormattedMessage (ot_error, msg3_L, msg3_S) ; "This keystroke is only available in the Month Glance"
	return
EndIf
let hMonth = FindDescendantWindow (GetRealWindow (GetCurrentWindow ()), iDApptEvent)
If (!IsWindowVisible (Hmonth) || IsWindowObscured (hMonth)) then
	SayFormattedMessage (ot_error, msg1_L, msg1_S) ; "Window not found"
	return
EndIf
SayWindow (hMonth, read_everything)
EndScript

Function SayYear ()
var
	handle hYear
let hYear = FindDescendantWindow (GetRealWindow (GetCurrentWindow ()), iDApptEvent)
SayWindow (hYear, read_everything)
EndFunction

Script SayCalendarYear ()
var
	handle hYear
If (iATWCurrentReal != iYearGlance) then
	SayFormattedMessage (ot_error, msg4_L, msg4_S) ; "This keystroke is only available in the Year Glance"
	return
EndIf
let hYear = FindDescendantWindow (GetRealWindow (GetCurrentWindow ()), iDApptEvent)
If (!IsWindowVisible (hYear) || IsWindowObscured (hYear)) then
	SayFormattedMessage (ot_error, msg1_L, msg1_S) ; "Window not found"
	return
EndIf
SayWindow (hYear, read_everything)
EndScript

Script SayDaysRatio ()
var
	handle hwnd,
	string sText,
	string sDays,
	string sRemaining
If (iATWCurrentReal != iDayPlanner) then
	SayFormattedMessage (ot_error, msg2_L, msg2_S) ; "This keystroke is available in the Day Planner View"
	return
EndIf
let hwnd = FindDescendantWindow (GetRealWindow (GetCurrentWindow ()), iDDaysRatio)
If (!IsWindowVisible (hwnd) || IsWindowObscured (hwnd)) then
	SayFormattedMessage (ot_error, msg1_L, msg1_S) ; "Window not found"
	return
EndIf
let sText = GetWindowText (hwnd, false)
let sDays = StringSegment (sText, msgSlash1, 1)
let sRemaining = StringSegment (sText, msgSlash1, 2)
let sText = FormatString (msg7_L, sDays, sRemaining)
SayFormattedMessage (ot_no_disable, sText)
EndScript

Script RightMouseButton ()
If (iATWCurrentReal == iYearGlance) then
	MouseUp (3)
EndIf
PerformScript RightMouseButton ()
EndScript

Script ChangePaines ()
var
	handle hwnd,
	int iControl
If (IsPCCursor ()) Then
	let hwnd = GetCurrentWindow ()
	let iControl = GetControlID (hwnd)
	If (iATWCurrentReal == iNoteBook) then
		If (iControl == iDNotesTitles) then
			SayCurrentScriptKeyLabel ()
			let hwnd = FindDescendantWindow (GetParent (hwnd), iDNotesEdit)
			InvisibleCursor ()
			RouteInvisibleToPC ()
			MoveToWindow (hwnd)
			RoutePCToInvisible ()
			return
		EndIf
		If (iControl == iDNotesEdit) then
			SayCurrentScriptKeyLabel ()
			let hwnd = FindDescendantWindow (GetParent (hwnd), iDNotesTitles)
			InvisibleCursor ()
			RouteInvisibleToPC ()
			MoveToWindow (hwnd)
			RoutePCToInvisible ()
			return
		EndIf
	EndIf
	If (iATWCurrentReal == iAnytimeOnline) then
		If (iControl == iDOnlineTreeView) then
			SayCurrentScriptKeyLabel ()
			TypeKey (ks2)
			return
		else
			SayCurrentScriptKeyLabel ()
			let hwnd = FindDescendantWindow (GetParent (hwnd), iDOnlineTreeView)
			InvisibleCursor ()
			RouteInvisibleToPC ()
			MoveToWindow (hwnd)
			RoutePCToInvisible ()
			return
		EndIf
	EndIf
EndIf
TypeCurrentScriptKey ()
SayCurrentScriptKeyLabel ()
EndScript

Script ReadBoxInTabOrder()
var
	handle hwnd,
	string sRealName,
	int iCount
let hwnd = GetFocus ()
let hwnd = GetRealWindow (hwnd)
let sRealName = GetWindowName (hwnd)
if (sRealName == wnAppointmentConflict1 ) then
	SayWindowTypeAndText (hwnd)
	let hwnd = FindDescendantWindow (hwnd, iDTheAppointment)
	SayWindowTypeAndText (hwnd)
	let hwnd = GetPriorWindow (hwnd)
	SayWindowTypeAndText (hwnd)
	while (iCount < 4)
		let hwnd = GetNextWindow (hwnd)
		let iCount = iCount+1;
	EndWhile
	SayWindowTypeAndText (hwnd)
	return
EndIf
PerformScript ReadBoxInTabOrder ()
EndScript