; !!! TZSCRIPTS-START [Do not remove]
; JFW Time Zone Scripts
; Version 1.0
; By Andrew Hart

; Dependencies:
; Requires clock.dll to be installed and registered in 
;the Windows Registry.
;
; Development History:
; 14/7/2001
; . Script SayJFWTZScriptsVersion for announcing script and dll version numbers added
; . Error checking code enhanced
; . Obsilete Function GetTzTime removed as its function has been subsumed by Function 
; GetTzDateTime
; 12 March 2001:  original scripts created

Globals
Int ActiveTimeZone ; remembers the currently active time zone

; Function GetTzDateTime
; Returns the current date and/or time for the active time zone.
; Parameter: dt
; dt=0 -> return current time in active time zone
; dt=1 -> return current date in + name of active time zone
; dt=2 -> return current date + time in active time zone
; dt<0 or dt>2 -> dt=0
; Last updated: 14/7/2001
; 14/7/2001
; . Check for validity of dt parameter added
String Function GetTzDateTime (Int dt)
Var
  Object Clock,
  Object Null,
  String time,
String date,
String TzName,
  Int nHours,
  Int nMinutes
If (dt<0 || dt>2) Then
  Let dt = 0 ; dt invalid, so initialise it to 0
EndIf
Let Clock = CreateObject("Clock.Tz") ; Procure pointer to TZ Object
If (!Clock) Then ; TZ object not successfully obtained
  SayUsingVoice(VCTX_MESSAGE, "Error accessing Clock.TZ class module", OT_STRING)
  Return
EndIf
If (!ActiveTimeZone) Then ; active time zone not set
  Let ActiveTimeZone = Clock.ActiveTimeZone ; get default time zone
EndIf 
; The next line is commented out since access to COM is not properly implemented in JFW 3.5/3.31
;  Let Clock.ActiveTimeZone = ActiveTimeZone
; The following cludge does the same thing as above using a class method
; implemented in order to get around the deficiency in JFW 3.5/3.31
Clock.SetActiveTimeZone(ActiveTimeZone) ; Set the active time zone
Let date = Clock.TzDate() ; Fetch current UTC date
If (Clock.Error && dt>0) Then
  Return "Error!  Unable to access system date"
EndIf
Let time = Clock.Tztime() ; Fetch current UTC T time
If (Clock.Error && dt!=1) Then
  Return "Error!  Unable to access system time"
EndIf
Let TzName = Clock.TimeZone(ActiveTimeZone)
Let Clock = Null ; Release TZ object
Let nHours = StringToInt(StringSegment(time, ":", 1))
Let nMinutes = StringToInt(SubString (StringSegment (time, ":", 2), 1, 2))
; Build TZ date string
Let time = SubString(time, StringContains (time, " "), StringLength(time))
If (nMinutes == 1) Then
  Let time = " minute " + time
Else
  Let time = " minutes " + time
EndIf
Let time = IntToString(nMinutes) + time
If (nHours == 1) Then
  Let time = " hour " + time
Else
  Let time = " hours " + time
EndIf
Let time = IntToString(nHours) + time
If (dt==2) Then
  Let Date = Date + " "
ElIf (dt==1) Then
  Let date = date + " " + TzName
  Let time = ""
Else
  Let date = ""
EndIf
Return date + time
EndFunction

; Script SetTimeZone
; Allows the user to set the time zome by selecting from items in a list box.
; If the script key is pressed twice, the version of these scripts is announced.
; Last updated: 14/4/2001
; 14/4/2001
; . The error check immediately after Clock object is initialised has been removed since 
;   clock.dll no longer accesses the Windows registry
; 20/3/2001:  fixed bug so the active time zone is reported correctly when SetTimeZone is 
; called before any other TZ function.
Script SetTimeZone ()
Var
  Object Clock,
  Object Null,
  String list,
  String list2,
  Int NewTimeZone
Let Clock = CreateObject("Clock.TZ") ; Procure pointer to TZ Object
If (!Clock) Then ; TZ object not successfully obtained
  SayUsingVoice(VCTX_MESSAGE, "Error accessing Clock.TZ class module", OT_STRING)
  Return
EndIf
If (!ActiveTimeZone) Then ; active time zone not set
  Let ActiveTimeZone = Clock.ActiveTimeZone ; get default time zone
EndIf
; Build list of time zones
Let list = "Current time zone is "
; Have to shunt the Clock.TimeZone String return through list2 as the JFW Script Manager seems 
; to get confused about concatinating strings with the "+" operator.  It seems to be typing on 
; the object itself and not on the method's return type.
Let List2 = Clock.TimeZone(ActiveTimeZone)
Let List = List + List2
Let list2 = Clock.ListOfTimeZones()
Let Clock = Null ; Release clock object
let list = list + "|" + list2
Let NewTimeZone = DlgSelectItemInList (list, "Set Time Zone", 0) ; let user choose from list box
If (NewTimeZone>1) Then
Let ActiveTimeZone = NewTimeZone-1 ; set time zone
EndIf
EndScript

; Script SayTzTime
; This is a replacement for the SayTime function in default.jss.
; A single press of the script key yields the local time while a double press causes JFW to 
; announce the current date.  Three presses announces the current time in the selected time zone 
; and four presses results in the date and time in the currently selected time zone being
; spoken.
Script SayTzTime ()
If (IsSameScript()==3) Then
  SayUsingVoice ( VCTX_MESSAGE, GetTzDateTime(2), OT_STRING)
  Return
EndIf
If (IsSameScript()==2) Then
  SayUsingVoice ( VCTX_MESSAGE, GetTzDateTime(0), OT_STRING)
  Return
EndIf
If (IsSameScript ()) then
  If GetVerbosity ()==0 Then
    SayUsingVoice (	VCTX_MESSAGE, SysGetTime(), OT_STRING)
  EndIf
  SayUsingVoice (	VCTX_MESSAGE, SysGetDate(), OT_STRING)
  Return 
EndIf 
SayUsingVoice (	VCTX_MESSAGE, SysGetTime(), OT_STRING)
EndScript

; Script SayJFWTZScriptsVersion
; Says the version of the JFW Time Zone Scripts and the associated DLL
Script SayJFWTZScriptsVersion()
Var
  Object Clock,
  Object Null,
  String version
   Let Clock = CreateObject("Clock.TZ") ; Procure pointer to TZ Object
If (!Clock) Then ; TZ object not successfully obtained
  SayUsingVoice(VCTX_MESSAGE, "Error accessing Clock.TZ class module", OT_STRING)
  Return
EndIf
SayUsingVoice (	VCTX_MESSAGE, "JFW Time Zone Scripts version 1.0 by Andrew Hart utilising ", OT_STRING)
Let version = Clock.GetVersion ; Get DLL version
Let Clock = Null ; Release clock object
SayUsingVoice (	VCTX_MESSAGE, version, OT_STRING)
EndScript

; !!! TZSCRIPTS-END [Do not remove]
