; !!! TCSCRIPTS-START [Do not remove]

; JFW Temperature Conversion Scripts
; by Andrew Hart
;
; Development History:
; 12/9/2001:  Official release of Temperature Conversion Scripts for JFW
; 11/9/2001:  Documentation and packaging tidied up
; 17/7/2001:  Scripts created
;
; SYNOPSIS:
; Convert temperatures expressed in degrees Celcius to temperatures in degrees 
; Fahrenheit and vice versa.
;
; Description:
; These scripts allow the user to convert temperatures expressed in degrees Celcius to 
; temperatures in degrees Fahrenheit and vice versa.  Firstly, the user is presented with a menu 
; and invited to select a direction of conversion, that is, from Celcius to Fahrenheit or 
; Fahrenheit to Celcius.  Then, he/she is prompted for the temperature to convert.  Finally, the 
; conversion is made and the result displayed.
;
; NOTE ON ACCURACY:
; The JFW Scripting Language has no facility for performing real arithmetic.  Hence, these
; scripts perform all calculations using integer arithmetic.  Due to the formula relating 
; degrees Celcius to degrees Fahrenheit, conversions from Degrees Celcius to degrees Fahrenheit 
; are always exact.  However, conversions in the opposite direction may result in non/recurring 
; decimal numbers which have to be truncated.  This is not a problem, as computers are always 
; doing this with real numbers, but these scripts perform the truncation based on how many 
; decimal places are to the right of the number you input for conversion.  The answers rendered 
; by these scripts always have one extra decimal place, unless the resulting temperature has no 
; fractional part, in which case no decimal part is reported.  For example, these scripts will 
; convert 85 degrees Fahrenheit to 29.4 degrees Celcius or 85.0 degrees Fahrenheit to 29.44 
; degrees Celcius, etc.  So, you may obtain a desired degree of accuracy by adding an 
; appropriate number of zeros to the end of a temperature after the decimal point.  These 
; scripts can only cope with temperatures involving a maximum of 9 digits, so it is advisable not 
; to exceed this number.

Int Function Sign(String sValue)
; Returns the sign of a string-encoded integer
Var
  Int nValue
Let nValue = StringToInt(sValue)
Return 2*(nValue>0 || (nValue==0 && StringContains (sValue, "-")==0)) - 1
EndFunction

Script TemperatureConversions ()
; Allows the user to convert a temperature in degrees Celcius to a temperature in Degrees Fahrenheit and vice versa.
Var
  String sChoices,
  String sValue,
  String sResult,
  Int nValue,
  String sWholePart,
  String sFracPart,
  Int nWholePart,
  Int nFracPart,
  Int nChoice,
  Int i
Let sChoices = "Convert from degrees Fahrenheit to degrees Celcius|Convert from degrees Celcius to degrees Fahrenheit|Exit"
Let nChoice = DlgSelectItemInList (sChoices, "Conversions between Celcius and Fahrenheit", False)
If (nChoice==1) Then ; Fahrenheit to Celcius conversion
  If InputBox ("Input a temperature in Degrees Fahrenheit:", "Temperature in Degrees Fahrenheit", sValue) then
    Let sWholePart = StringSegment (sValue, ".", 1)
    Let sFracPart = StringSegment (sValue, ".", 2)
    Let i = StringLength (sFracPart)
    Let nFracPart = 1
    While (i>0)
      Let nFracPart = nFracPart * 10
      Let i = i - 1
    EndWhile
    Let nValue = StringToInt(sWholePart)*nFracPart + Sign(sWholePart)*StringToInt(sFracPart)
    Let nValue = nValue - 32*nFracPart
    Let nValue = nValue * 100 / 18
    Let nFracPart = nFracPart * 10
    Let nWholePart = nValue / nFracPart
    Let nFracPart = nValue % nFracPart
    If (nFracPart<0) Then
      Let nFracPart = 0 - nFracPart
    EndIf
    If (nWholePart==0 && nValue<0) Then
      Let sResult = "-0"
    Else
      Let sResult = IntToString (nWholePart)
    EndIf
    If (nFracPart!=0) Then
      Let sResult = sResult + "." + IntToString (nFracPart)
    EndIf
    MessageBox (sValue + " degrees Fahrenheit is " + sResult + " degrees Celcius")
  EndIf
EndIf
If (nChoice==2) Then ; Celcius to Fahrenheit conversion
  If InputBox ("Input a temperature in Degrees Celcius:", "Temperature in Degrees Celcius", sValue) then
    Let sWholePart = StringSegment (sValue, ".", 1)
    Let sFracPart = StringSegment (sValue, ".", 2)
    Let i = StringLength (sFracPart)
    Let nFracPart = 1
    While (i>0)
      Let nFracPart = nFracPart * 10
      Let i = i - 1
    EndWhile
    Let nValue = StringToInt(sWholePart)*nFracPart + Sign(sWholePart)*StringToInt(sFracPart)
    Let nFracPart = nFracPart * 10
    Let nValue = nValue*18 + 32*nFracPart
    Let nWholePart = nValue / nFracPart
    Let sResult = IntToString (nWholePart)
    Let nFracPart = nValue % nFracPart
    If (nFracPart<0) Then
      Let nFracPart = 0 - nFracPart
    EndIf
    If (nWholePart==0 && nValue<0) Then
      Let sResult = "-0"
    Else
      Let sResult = IntToString (nWholePart)
    EndIf
    If (nFracPart!=0) Then
      Let sResult = sResult + "." + IntToString (nFracPart)
    EndIf
    MessageBox (sValue + " degrees Celcius is " + sResult + " degrees Fahrenheit.")
  EndIf
EndIf
EndScript


; !!! TCSCRIPTS-END [Do not remove]
