;The tab reader script is licensed under a 
;Creative Commons Attribution-NonCommercial 4.0 International License.
;Attribution should be made to George Calvert.

include "hjconst.jsh"
include "common.jsm"

const
	STAFFLINE="-",
MEASURE = "|",
	ENDOFLINE "/n"

String Function CleanStaffLine (string rawString)var string first,
	string result

first =  StringLeft(rawString,1)
if first == " " ||  first == MEASURE  || first == "E" || first == "B" || first == "G" 
|| first == "D" || first == "A" Then

result = StringChopLeft(rawString, 1)

first =  StringLeft(result,1)
if first == " " || first == MEASURE  || first == "E" || first == "B" || first == "G" 
|| first == "D" || first == "A" Then

result = StringChopLeft(result, 1)
EndIf

first =  StringLeft(result,1)
if first == " " || first == MEASURE  || first == "E" || first == "B" || first == "G" 
|| first == "D" || first == "A" Then

result = StringChopLeft(result, 1)

EndIf


Else

result = rawString
EndIf

return result

EndFunction

Script ReadGuitarTab ()

var
	string bufferContent, ;Finished string for display in virtual buffer
	collection TabLine ;6 individual guitar strings

TabLine = new collection
;Obtain single string of a single tab line 
; Leading spaces, String Letters are stripped
TabLine.HighE=  ReadTabLine()
NextLine(0)
	TabLine.B  =  ReadTabLine() 
NextLine(0)
	TabLine.G = ReadTabLine()
NextLine(0)
	TabLine.D = ReadTabLine()
NextLine(0)
	TabLine.A = ReadTabLine()
NextLine(0)
	TabLine.LowE = ReadTabLine()
NextLine(0)

 bufferContent= ConvertGuitarTabLine (TabLine)

If UserBufferIsActive () Then
UserBufferDeactivate () ; close the virtual viewer 
EndIf
 SayMessage (OT_USER_BUFFER, bufferContent)

EndScript

String Function ConvertGuitarTabLine (collection tabLine)		

var

	string highESegment,
	string bSegment,
	string gSegment,
	string dSegment,
	string aSegment,
	string lowESegment,
	string highE,
	string b,
	string g,
	string d,
	string a,
	string lowE,
	string line,	string slice,
	int startPosition,
	int	min,
	int max,
	int counter,
	int maxWidth
 
;Determine the length of the shortest text string in the collection of guitar strings
; The value is used  to set the upper limit  of the loop that 
; controls slicing
min = GetMinStringLength(tabLine)

startPosition = 1
line = ""
;The outermost while loop Moves slicing horizontally from left to right
; Since notes can be played together on different strings, slicing
; is the technique for moving vertically across the
;tab line from top to bottom to determine if notes 
; are played together. 
While startPosition <= min 

;Calculate the width of the next slice, which represents
; the widest span of characters among the six strings

maxWidth = GetWidthOfSlice(tabLine, startPosition) 

line = line + TranslateSlice(tabLine, maxWidth, startPosition) 

startPosition = startPosition + maxWidth + 1

EndWhile

return line
EndFunction

String Function TranslateSlice (collection tabLine, int width, int startPosition)
var string collector,
	int counter,
	string rawSlice,
	int i,
	string sName
collector =""
	counter = 0
For  i = 1 to 6
	
sName = GetStringNameFromNumber(i)

; Strip hyphens and parentheses

rawSlice = (SubString(tabLine[sName], StartPosition, width)) 
rawSlice = StringReplaceSubstrings(rawSlice, "(", "")
rawSlice = StringReplaceSubstrings(rawSlice, ")", "")
rawSlice = StringReplaceSubstrings(rawSlice, "-", "")


If (StringLength(rawSlice) > 0) Then


collector  = collector + ConvertIndexToStringName(i) + ParseToken(rawSlice)

counter = counter + 1
EndIf

EndFor 

If counter > 1  Then
collector = "\r\n" + "Play the next "  + IntToString(counter) + "  strings  together" + collector
EndIf

return collector

EndFunction

String Function ReadTabLine ()
	var
		string s
s = ""
s = CleanStaffLine(StringTrimTrailingBlanks(GetLine ()))

		return s


EndFunction

Int Function GetMinStringLength (collection tabLine)

var
	int highE,
	int b,
	int g,
	int d,
	int a,
	int lowE,
	int min

highE = StringLength(tabLine.HighE)
b = StringLength(tabLine.B)
g = StringLength(tabLine.G)
d = StringLength(tabLine.D)
a = StringLength(tabLine.A)
lowE = StringLength(tabLine.LowE) 

min = Min(HighE, b)
min = Min(min, g)
min = Min (min, d)
min = Min(min, a)
min = Min(min, LowE)

return min

EndFunction

Int Function FindWidthOfNextSegment (string GuitarString, int StartPosition)

var string testChar,
	int counter,
	int extracounter

Counter = 0
	extracounter = 0

; Calculates the length of a contiguous string of characters 
; starting at the StartPosition parameter. The terminating characters are
; a hyphen or end of line character

; If character at start position is one of the
; terminating constants, then segment width is 0

testChar = SubString (GuitarString, StartPosition, 1)

While (testChar != STAFFLINE  && testChar != MEASURE &&  testChar != ENDOFLINE)

; Prevents an infinite loop by breaking out if startPosition becomes greater than the length of the string
If (StartPosition >StringLength(GuitarString))

return counter

EndIf
Counter = counter +1

StartPosition = StartPosition + 1 
testChar = SubString (GuitarString, StartPosition, 1)
EndWhile
; Special testing needs to be done  to account for 
; actions such as hammer on denoted by a letter followed by an optional hyphen and a number

; If the end of the slice is a letter used to denote
; an action, check for a number one or 2 spaces to the right of the letter 

; Is character a special character?
If IsSpecialCharacter(SubString(GuitarString, StartPosition - 1, 1)) == TRUE Then
; 2 possible patterns
; Hyphen followed by sincle digit
; Hyphen followed by two digits
;First pattern: extracounter is 2
If StartPosition + 1 <= StringLength(GuitarString) == TRUE Then

If IsNumeric(SubString(GuitarString, StartPosition + 1, 1)) == TRUE Then
extracounter = 2
EndIf
EndIf 

;Second pattern: extracounter is 3
If StartPosition + 1 <= StringLength(GuitarString) == TRUE Then

If IsNumeric(SubString(GuitarString, StartPosition + 1, 1)) == TRUE Then
extracounter = 3
EndIf
EndIf

EndIf ; Test for special char
return counter + extracounter
EndFunction

Int Function GetWidthOfSlice (collection TabLine, int StartPosition)
var	int i,
	int max,
	string sName
i = 1
max  = 0

For  i = 1 to 6
	
sName = GetStringNameFromNumber(i)

max = Max(max, FindWidthOfNextSegment(tabLine[sName], StartPosition)) 

EndFor 

return max
EndFunction

String Function GetStringNameFromNumber (int num)
If (num == 1) Then
return "HighE"
ElIf (num == 2) 
Then
return "B"
ElIf (num == 3) Then
return "G"
ElIf (num == 4) Then
return "D"
ElIf (num == 5) Then
return "A"
ElIf (num == 6) 
Then

return "LowE"
EndIf

return ""
EndFunction

String Function ConvertIndexToStringName (int number)

If (number == 1) Then
return "\r\nFirst string: "

ElIf (number ==2 ) Then
return "\r\nSecond string: "
ElIf (number ==3 ) Then
return "\r\nThirdstring: "

ElIf (number ==4 ) Then
return "\r\nFourthstring: "

ElIf (number ==5 ) Then
return "\r\nFifthstring: "
ElIf (number ==6 ) Then
return "\r\nSixthstring: "
Else

return ""
EndIf

EndFunction


String Function ParseToken (string token)

var
	string fret1,
	string fret2,
	string action,
	int position,
	int SpecialPosition

; First, check to see if purely numeric
; if so, translate fret number into fret description

If IsNumeric(token) == TRUE Then
; Test for fret 0  Open to prevent adding the word fret
If token == 0  Then
return "Open"
Else
return GetFretName(StringToInt(token)) + " fret"
EndIf
Else
; Parse the token into three components: fret 1, fret 2  and an action  

; if the token does not follow the pattern
; fret 1, action and fret 2, just return the raw token

SpecialPosition = GetSpecialCharacterPosition(token)  
If SpecialPosition > 0  Then
action = SubString(token, SpecialPosition, 1)
fret1 = SubString(token, 1, SpecialPosition - 1)
fret2 = SubString(token, SpecialPosition + 1, StringLength(token)- SpecialPosition)
fret1 = StringReplaceSubstrings(fret1, "-", "")
fret2 = StringReplaceSubstrings(fret2	, "-", "")


If StringUpper(action)  =="H" Then
token = GetFretName(StringToInt(fret1)) + " fret" + "  and hammer on to the " + GetFretName(StringToInt(fret2)) + " fret"
return token
ElIf StringUpper(action) =="P" Then
token = GetFretName(StringToInt(fret1)) + " fret" + "  and pull off to the " + GetFretName(StringToInt(fret2)) + " fret"
return token
ElIf StringUpper(action) =="R" Then
If fret1== "" && fret2 == "" Then
token = " release "

ElIf fret1== "" Then

token = "Release the bend to " + GetFretName(StringToInt(fret2)) + " fret"
ElIf fret2== "" Then

token = "Release the bend from " + GetFretName(StringToInt(fret1)) + " fret"

Else

token = "Release the bend from " + GetFretName(StringToInt(fret1)) + " fret" + "  to " + GetFretName(StringToInt(fret2)) + " fret"
EndIf
return token


ElIf StringUpper(action) =="B" Then
token = GetFretName(StringToInt(fret1)) + " fret" + "  and bend up to the note on " + GetFretName(StringToInt(fret2)) + " fret"
return token

ElIf StringUpper(action) =="V" Then
token = GetFretName(StringToInt(fret1)) + " fret" + "  with vibrato" 
return token

ElIf action =="/" Then

token = GetFretName(StringToInt(fret1)) + " fret" + "  and slide up to " + GetFretName(StringToInt(fret2)) + " fret"
return token

ElIf action =="\\" Then

token = GetFretName(StringToInt(fret1)) + " fret" + "  and slide down to " + GetFretName(StringToInt(fret2)) + " fret"
return token

EndIf
Else
return token
EndIf
EndIf
EndFunction

String Function GetFretName (int fret)
If fret == 0  Then
return "open"
ElIf fret == 1  Then
return "First "
ElIf fret == 2  Then
return "Second "
ElIf fret == 3  Then
return "Third "
ElIf fret == 4  Then
return "Fourth "
ElIf fret == 5  Then
return "Fifth "
ElIf fret == 6  Then
return "Sixth "
ElIf fret == 7  Then
return "Seventh "
ElIf fret  == 8  Then
return "Eighth "

ElIf  fret == 9  Then
return "Ninth "
ElIf fret == 10  Then
return "Tenth "
ElIf fret == 11  Then
return "eleventh "

ElIf fret == 12 Then
return "Twelth "
ElIf fret == 13 Then
return "Thirteenth "
ElIf fret == 14 Then
return "Fourteenth "
ElIf fret == 15 Then
return "Fifteenth "
ElIf fret == 16 Then
return "Sixteenth "
ElIf fret == 17 Then
return "Seventeenth "
ElIf fret == 18 Then
return "Eighteenth "
ElIf fret == 19 Then
return "Nineteenth "
ElIf fret == 20 Then
return "Twentieth "
ElIf fret == 21 Then
return "Twenty first "
ElIf fret == 22 Then
return "Twenty Second "
ElIf fret == 23 Then
return "Twenty Third "
Else
return IntToString(fret) 
EndIf

EndFunction

Int Function IsNumeric (string raw)
var
	int i,
	int max,
	int testval

max = StringLength(raw)
 For I = 1 to max
testval = GetCharacterValue(SubString(raw, i, 1))
If testval < 48 || testval > 57 Then
return FALSE
EndIf

endFor

return TRUE
EndFunction

Int Function IsSpecialCharacter (string char)

If StringUpper(char) == "H" || StringUpper(char) == "P" || StringUpper(char) == "B"  || StringUpper(char) == "R"  || StringUpper(char) == "T"  || char == "/" || StringUpper(char) == "V"   || char == "\\"  Then

return TRUE
EndIf
return FALSE
EndFunction

Int Function GetSpecialCharacterPosition (string token)

var
	int i
For i = 1 to StringLength(token)

If IsSpecialCharacter(SubString(token, i, 1))
return i
EndIf
EndFor
return 0
EndFunction

