/*
Scripts to extend the windows clipboard
author: Jim Bauer
To use, add the statement: use "HJClip.jsb" to default.jss and recompile.
project started on February 13, 2004

Revision History
*/

include "HJConst.jsh"
include "HJClip.jsm"

const
SlotSeparator = "~"



globals
string slot1,
string slot2,
string slot3,
string slot4,
string slot5,
int capture_selected,
int display_confirmation_dialogs,
string config_names,
int config_count



;The following is an undocumented jawes function recently discovered on the jaws scripts mailing list by Doug Lee.
String Function GetClipboardText ()
return (GetClipboardText ())
EndFunction



;Following is just a general string replace function, used to clean up the output written to the ini file by the ConfigurationRemove function.
String Function replace (string sInitial, string sReplace, string sReplacement, int ReplaceAll)
var
int i,
int j,
int l,
int r,
string s,
string t
let r = StringLength (sReplacement)
let i = StringContains (sInitial, sReplace)
if (i == 0) then
return ("")
EndIf
let t = StringDiff (sInitial, sReplace)
let l = (StringLength (t))+r
while (j <= l)
let j = j + 1
if (j == i) then
if (SubString (t, j, 1) == " ") then
let s = s + sReplacement
let j = j + 1
else
let s = s + sReplacement
EndIf
EndIf
let s = s + SubString (t, j, 1)
EndWhile
if (ReplaceAll) then
if (StringContains (s, sReplace)) then
replace (s, sReplace, sReplacement, 1)
else
return (s)
EndIf
else
return (s)
EndIf
EndFunction



Int Function SlotContainsText (string TheSlot)
if ((TheSlot == "1")
&& ((StringIsBlank (slot1)) == 0)) then
return (1)
elif ((TheSlot == "2")
&& ((StringIsBlank (slot2)) == 0)) then
return (1)
elif ((TheSlot == "3")
&& ((StringIsBlank (slot3)) == 0)) then
return (1)
elif ((TheSlot == "4")
&& ((StringIsBlank (slot4)) == 0)) then
return (1)
elif ((TheSlot == "5")
&& ((StringIsBlank (slot5)) == 0)) then
return (1)
else
return (0)
EndIf
EndFunction



Void Function AssignToSlot (string slot)
var
string s,
int i
 if ((SlotContainsText (slot))
&& (display_confirmation_dialogs)) then
let i = ExMessageBox (MsgOverwrite, "Warning!", MB_YesNo | MB_IconExclamation | MB_DefButton1)
if (i != IDYes) then
return
EndIf
EndIf
let s = GetSelectedText ()
if ((capture_selected)
&& (StringIsBlank (s) == 0)) then
if (slot == "1") then
let slot1 = s
elif (slot == "2") then
let slot2 = s
elif (slot == "3") then
let slot3 = s
elif (slot == "4") then
let slot4 = s
elif (slot == "5") then
let slot5 = s
EndIf
else
let s = ""
if (!ClipboardHasData ()) then
SayMessage (OT_ERROR, MsgNoDataError)
return
EndIf
let s = GetClipboardText ()
if (slot == "1") then
let slot1 = s
elif (slot == "2") then
let slot2 = s
elif (slot == "3") then
let slot3 = s
elif (slot == "4") then
let slot4 = s
elif (slot == "5") then
let slot5 = s
else
return
EndIf
EndIf
SayMessage (OT_NO_DISABLE, MsgAssignedToSlot + slot)
EndFunction



Script SetSlot1 ()
AssignToSlot ("1")
EndScript



Script SetSlot2 ()
AssignToSlot ("2")
EndScript



Script SetSlot3 ()
AssignToSlot ("3")
EndScript



Script SetSlot4 ()
AssignToSlot ("4")
EndScript



Script SetSlot5 ()
AssignToSlot ("5")
EndScript



Void Function SpeakSlot (string slot)
var
string m
if (!SlotContainsText (slot)) then
SayUsingVoice (vctx_message, MsgNotAssigned, OT_STRING)
return
EndIf
if (slot == "1") then
let m = slot1
elif (slot == "2") then
let m = slot2
elif (slot == "3") then
let m = slot3
elif (slot == "4") then
let m = slot4
elif (slot == "5") then
let m = slot5
else
return
EndIf
Say (m, OT_NO_DISABLE)
EndFunction



Void Function PasteSlot (string slot)
var
string s
if (SlotContainsText (slot)== 0) then
SayMessage (OT_ERROR, MsgNotAssigned)
return
EndIf
if (ClipboardHasData ()) then
let s = GetClipboardText ()
EndIf
if (slot == "1") then
CopyToClipboard (slot1)
elif (slot == "2") then
CopyToClipboard (slot2)
elif (slot == "3") then
CopyToClipboard (slot3)
elif (slot == "4") then
CopyToClipboard (slot4)
elif (slot == "5") then
CopyToClipboard (slot5)
else
return
EndIf
{Control+V}
pause ()
if (!StringIsBlank (s)) then
CopyToClipboard (s)
EndIf
SayMessage (OT_STATUS, FormatString (MsgSlotPasted, slot))
EndFunction



Script ReviewSlot1 ()
if (IsSameScript ()) then
PasteSlot ("1")
return
EndIf
SpeakSlot ("1")
EndScript



Script ReviewSlot2 ()
if (IsSameScript()) then
PasteSlot ("2")
return
EndIf
SpeakSlot ("2")
EndScript



Script ReviewSlot3 ()
if (IsSameScript ()) then
PasteSlot ("3")
return
EndIf
SpeakSlot ("3")
EndScript



Script ReviewSlot4 ()
if (IsSameScript ()) then
PasteSlot ("4")
return
EndIf
SpeakSlot ("4")
EndScript



Script ReviewSlot5 ()
if (IsSameScript ()) then
PasteSlot ("5")
return
EndIf
SpeakSlot ("5")
EndScript







Void Function ClearSlots (string SlotNum)
if (SlotNum == "all") then
let slot1 = ""
let slot2 = ""
let slot3 = ""
let slot4 = ""
let slot5 = ""
SayMessage (OT_STATUS, MsgSlotsCleared_l, MsgSlotsCleared_s)
return
elif (SlotNum == "1") then
let slot1 = ""
elif (SlotNum == "2") then
let slot2 = ""
elif (SlotNum == "3") then
let slot3 = ""
elif (SlotNum == "4") then
let slot4 = ""
elif (SlotNum == "5") then
let slot5 = ""
else
return
EndIf
SayUsingVoice (VCTX_MESSAGE, FormatString ("Slot %1 cleared.", SlotNum), OT_STRING)
EndFunction



Script SlotsClear ()
var
int i,
string m
let m = "1|2|3|4|5|all"
let i = DlgSelectItemInList (m, "Select a slot to clear", 0)
if (i == 0) then
return
EndIf
if (i == 6) then
ClearSlots ("all")
else
ClearSlots (IntToString (i))
EndIf
EndScript



Script SpeakClipboardContents ()
var
string m
if (!ClipboardHasData ()) then
let m = MsgNoDataError
else
let m = GetClipboardText ()
EndIf
if (StringIsBlank (m)) then
Say ("No text was retrieved.", OT_ERROR)
return
EndIf
Say (m, OT_STRING)
EndScript



Void Function LoadHJClipSettings ()
;Call this from the default AutoStartEvent
var
int x,
int y
let x = IniReadInteger ("settings", "CaptureSelectedText", -1, "HJClip.ini")
let y = IniReadInteger ("settings", "DisplayConfirmationDialogs", -1, "HJClip.ini")
let config_count = IniReadInteger ("settings", "ConfigurationCount", 0, "HJClip.ini")
let config_names = IniReadString ("settings", "ConfigurationNames", "", "HJClip.ini")
if ((x != -1)
|| (y != -1)) then
let capture_selected = x
let display_confirmation_dialogs = y
else
let capture_selected = 0
let display_confirmation_dialogs = 1
IniWriteInteger ("settings", "CaptureSelectedText", capture_selected, "HJClip.ini")
IniWriteInteger ("settings", "DisplayConfirmationDialogs", display_confirmation_dialogs, "HJClip.ini")
EndIf
EndFunction



Script ToggleSelectedTextCapture ()
let capture_selected = 1 - capture_selected
if (capture_selected) then
SayUsingVoice (VCTX_MESSAGE, MsgCaptureSelectedEnabled, OT_STRING)
else
SayUsingVoice (VCTX_MESSAGE, MsgCaptureSelectedDisabled, OT_STRING)
EndIf
IniWriteInteger ("settings", "CaptureSelectedText", capture_selected, "HJClip.ini")
EndScript



Script ToggleConfirmationDisplay ()
let display_confirmation_dialogs = 1 - display_confirmation_dialogs
if (display_confirmation_dialogs) then
SayUsingVoice (VCTX_MESSAGE, MsgConfirmationDisplayEnabled, OT_STRING)
else
SayUsingVoice (VCTX_MESSAGE, MsgConfirmationDisplayDisabled, OT_STRING)
EndIf
IniWriteInteger ("settings", "DisplayConfirmationDialogs", display_confirmation_dialogs, "HJClip.ini")
EndScript



Void Function SaveConfiguration ()
;Configurations are saved in an ini style file with a .jcs (jaws clipboard slots) extention.
var
int i,
string c,
string n,
string s
;let config_count = IniReadInteger ("settings", "ConfigurationCount", 0, "HJClip.ini")
let i = InputBox ("Enter a name:", "Save configuration as:", n)
if ((i == 0)
|| (StringIsBlank (n))) then
Say ("Canceled.", OT_NO_DISABLE)
return
EndIf
let config_count = config_count + 1
;let c = IniReadString ("settings", "ConfigurationNames", "", "HJClip.ini")
let c = config_names
if (StringIsBlank (c) == 0) then
let c = c + "|"
EndIf
let c = c + n
let s = slot1 + SlotSeparator
let s = s + slot2 + SlotSeparator
let s = s + slot3 + SlotSeparator
let s = s + slot4 + SlotSeparator
let s = s + slot5
IniWriteString ("SavedSlots", "configuration" + IntToString (config_count), s, "HJClip.jcs")
IniWriteString ("settings", "ConfigurationNames", c, "HJClip.ini")
let config_names = c
IniWriteInteger ("settings", "ConfigurationCount", config_count, "HJClip.ini")
SayUsingVoice (VCTX_MESSAGE, MsgSlotsSaved, OT_STRING)
EndFunction



Script SlotsSave ()
SaveConfiguration ()
EndScript



Void Function LoadConfiguration (int ConfigNum)
var
string s
let s = IniReadString ("SavedSlots", "configuration" + IntToString (ConfigNum), "", "HJClip.jcs")
if (StringIsBlank (s)) then
Say ("Error in retrieving configuration contents.", OT_ERROR)
return
EndIf
let slot1 = StringSegment (s, SlotSeparator, 1)
let slot2 = StringSegment (s, SlotSeparator, 2)
let slot3 = StringSegment (s, SlotSeparator, 3)
let slot4 = StringSegment (s, SlotSeparator, 4)
let slot5 = StringSegment (s, SlotSeparator, 5)
SayUsingVoice (VCTX_MESSAGE, MsgConfigLoaded, OT_STRING)
EndFunction



Script SlotsLoad ()
var
int i,
string c
let c = IniReadString ("settings", "ConfigurationNames", "", "HJClip.ini")
if (StringIsBlank (c)) then
Say (MsgNoConfiguration, OT_ERROR)
return
EndIf
let i = DlgSelectItemInList (c, "Select configuration to load.", 1)
if (i == 0) then
Say ("Canceled.", OT_NO_DISABLE)
return
EndIf
LoadConfiguration (i)
EndScript



Void Function RemoveConfiguration (int ConfigNum)
if (StringIsBlank (config_names)) then
SayMessage (OT_ERROR, MsgNoConfiguration)
return
EndIf
if (ConfigNum == 0) then
IniRemoveSection ("SavedSlots", "HJClip.jcs")
IniRemoveKey ("settings", "ConfigurationCount", "HJClip.ini")
IniRemoveKey ("settings", "ConfigurationNames", "HJClip.ini")
let config_names = ""
let config_count = 0
SayUsingVoice (VCTX_MESSAGE, "All configurations have been removed.", OT_STRING)
return
EndIf
IniRemoveKey ("SavedSlots", "configuration" + IntToString (ConfigNum), "HJClip.jcs")
let config_count = config_count - 1
let config_names = StringDiff (config_names, StringSegment (config_names, "|", ConfigNum))
if (StringContains (config_names, "| |")) then
let config_names = replace (config_names, "| |", "|", 0)
EndIf
IniWriteString ("settings", "ConfigurationNames", config_names, "HJClip.ini")
if (config_count) then
IniWriteInteger ("settings", "ConfigurationCount", config_count, "HJClip.ini")
EndIf
SayUsingVoice (vctx_message, FormatString ("Configuration %1 removed.", IntToString (ConfigNum)), OT_STRING)
EndFunction



Script SlotsRemove ()
var
string m,
int c,
int i
let c = config_count + 1
if (StringIsBlank (config_names)) then
SayMessage (OT_ERROR, MsgNoConfiguration)
return
EndIf
let m = config_names + "|all"
let i = DlgSelectItemInList (m, "Select configuration to remove.", 0)
if (i == 0) then
Say ("Canceled.", OT_NO_DISABLE)
return
EndIf
if (i == c) then
RemoveConfiguration (0)
else
RemoveConfiguration (i)
EndIf
EndScript



Script AnnounceAvailableSlots ()
var
int i,
string m,
string s
while (i < 5)
let i = i + 1
if (SlotContainsText (IntToString (i)) == 0) then
let m = m + (IntToString (i) + ",")
EndIf
EndWhile
if (StringIsBlank (m)) then
SayUsingVoice (VCTX_MESSAGE, "No slots available.", OT_STRING)
return
EndIf
if (StringLength (m) == 10) then
SayUsingVoice (VCTX_MESSAGE, "All slots available.", OT_STRING)
return
EndIf
if (StringLength (m) > 2) then
let s = "Slots %1 are available."
else
let s = "Slot %1 available."
EndIf
SayUsingVoice (VCTX_MESSAGE, FormatString (s, m), OT_STRING)
EndScript



Script HJClipHotKeyHelp ()
SayFormattedMessage (OT_USER_BUFFER, MsgHotkeyHelp)
EndScript



Script GetHelp ()
var
string s
let s = GetJawsSettingsDirectory () + "\\HJClip.htm"
if (FileExists (s) == 0) then
Say (MsgNoHelp, OT_ERROR)
return
EndIf
run (s)
EndScript



Script HJClipScriptInfo ()
Say (MsgVersionInfo, OT_NO_DISABLE)
EndScript
