; Header for Talking Clock Scripts (aka Cuckoo)

Const
	CuckooIniFile = "cuckoo.ini", ; name of file where settings are stored
	CuckooSettings= "Settings", ; name of section in data file where settings are saved
	CuckooSound15 = "Sound15", ; key for name of sound to chime at 15 and 45 minutes minutes of the hour
	CuckooSound30 = "Sound30", ; key for name of sound to chime at 30 minutes of the hour
	CuckooSound60 = "Sound60", ; key for name of sound to chime at the top of the hour
	CuckooDelay15 = "Delay15", ; approximate length of 15/45 minute sound file in tenths of a second
	CuckooDelay30 = "Delay30", ; approximate length of 30 minute sound file in tenths of a second
	CuckooDelay60 = "Delay60", ; approximate length of 60 minute sound file in tenths of a second
	CuckooState = "State", ; key for holding the current state of the cuckoo
	DefaultSound15 = "clock15.wav", ;  default name of 15/45 minute sound file
	DefaultSound30 = "clock30.wav", ;  default name of 30 minute sound file
	DefaultSound60 = "clock60.wav", ;  default name of 60 minute sound file
	DefaultDelay15 = 22,
	DefaultDelay30 = 14,
	DefaultDelay60 = 7,
	cscDoubleBackslash = "\\" ; directory delimiter character to be used in paths

Globals
	Int GlobalCuckooEpoch, ; the number of minutes separating cuckoo events
	Int GlobalCuckooEventHandle, ; handle to the next cscheduled cuckoo event
	String GlobalCuckooSound15, ; holds the name of the 15/45 minute sound file
	String GlobalCuckooSound30, ; holds the name of the 30 minute sound file
	String GlobalCuckooSound60, ; holds the name of the 60 minute sound file
	Int GlobalCuckooDelay15,
	Int GlobalCuckooDelay30,
	Int GlobalCuckooDelay60,
	Int GlobalCuckooCalls ; on the hour, keeps a count of the number of cuckoo calls made
