; Talking Clock Scripts for JFW written by
; David Truong (davidtruong@optushome.com.au) and Andrew Hart (andrew@jfwscripts.cjb.net)
; Last upated:  3 February 2003

Include "hjconst.jsh"
Include "cuckoo.jsm"
Include "cuckoo.jsh"


Void Function AutoStartEvent ()
Let GlobalCuckooSound15 = IniReadString (CuckooSettings, CuckooSound15, DefaultSound15, CuckooIniFile)
Let GlobalCuckooSound30 = IniReadString (CuckooSettings, CuckooSound30, DefaultSound30, CuckooIniFile)
Let GlobalCuckooSound60 = IniReadString (CuckooSettings, CuckooSound60, DefaultSound60, CuckooIniFile)
Let GlobalCuckooDelay15 = IniReadInteger (CuckooSettings, CuckooDelay15, DefaultDelay15, CuckooIniFile)
Let GlobalCuckooDelay30 = IniReadInteger (CuckooSettings, CuckooDelay30, DefaultDelay30, CuckooIniFile)
Let GlobalCuckooDelay60 = IniReadInteger (CuckooSettings, CuckooDelay60, DefaultDelay60, CuckooIniFile)
Let GlobalCuckooEpoch = IniReadInteger (CuckooSettings, cuckooState, 0, CuckooIniFile)
Let GlobalCuckooEventHandle = 0
Let globalCuckooCalls = 0
If (GlobalCuckooEpoch) Then
	CuckooEvent()
EndIf
EndFunction

Script SetCuckooClock ()
Var
	Int nChoice
Let nChoice =DlgSelectItemInList (TimeIntervalMenu, TimeIntervalDialogTitle, False) 
SpeechOff()
Delay(1)
Pause()
SpeechOn()
If (nChoice == 1 ) Then
Let GlobalCuckooEpoch = 15
EndIf
If (nChoice == 2) then
	Let GlobalCuckooEpoch = 30
EndIf
If (nChoice == 3) then
	Let GlobalCuckooEpoch = 60
EndIf
If (nChoice == 4) Then
	Let GlobalCuckooEpoch = 0
	If (GlobalCuckooEventHandle) Then
		UnScheduleFunction (GlobalCuckooEventHandle)
	EndIf
EndIf
; If the user does not select a menu item, exit
If (!nChoice) Then
	Return
Endif
; Save the new setting in the .ini file
IniWriteInteger (CuckooSettings, CuckooState, GlobalCuckooEpoch, CuckooIniFile)
; If GlobalEpoch is positive, fire the CuckooEvent function.
If (GlobalCuckooEpoch) then
	CuckooEvent()
EndIf
PerformScript SayCuckooState()
EndScript

Script SayCuckooState ()
If (!GlobalCuckooEpoch) Then
	SayMessage(OT_JAWS_MESSAGE, CuckooMSG2, "\n")
	Say(CuckooMSG3, OT_NO_DISABLE)
Else
	SayMessage(OT_JAWS_MESSAGE, CuckooMSG4, "\n")
	Say(IntToString(GlobalCuckooEpoch) + CuckooMSG5, OT_NO_DISABLE)
EndIf
EndScript

Void Function CuckooEvent ()
Var
	Int nMinutes,
	Int nScheduleTime
If (!GlobalCuckooEpoch) then ; if the cuckoo chimes are turned off, bail out
	Return
EndIf
Let nScheduleTime = 0
Let nMinutes = StringToInt(StringSegment(SysGetTime(), ":", 2)) ; get the minutes
; Deal with chiming on a quarter to and a quarter past the hour
If ((nMinutes == 15 || nMinutes == 45) && GlobalCuckooEpoch == 15) Then
	PlaySound(GetJAWSSettingsDirectory() + cscDoubleBackslash + globalCuckooSound15)
	ScheduleFunction("CuckooAnnounceTime", GlobalCuckooDelay15 + 5)
	Let nScheduleTime = 60 * (GlobalCuckooEpoch - 1)
EndIf
; Deal with chiming on the halfhour
If (nMinutes == 30 && GlobalCuckooEpoch <= 30) Then
	PlaySound(GetJAWSSettingsDirectory() + cscDoubleBackslash + globalCuckooSound30)
	ScheduleFunction("CuckooAnnounceTime", GlobalCuckooDelay30 + 5)
	Let nScheduleTime = 60 * (GlobalCuckooEpoch - 1)
EndIf
; Deal with chiming on the hour
If (nMinutes == 0 && GlobalCuckooEpoch <= 60) Then
	Let GlobalCuckooCalls = StringToInt(StringSegment(SysGetTime(), ":", 1))
ScheduleFunction("CuckooAnnounceTime", 0)
	ScheduleFunction("CuckooCall", 10)
	Let nScheduleTime = 60 * (GlobalCuckooEpoch - 1)
EndIf
If (nScheduleTime == 0) Then ; if no chiming has been done during this cuckoo event, decide when to schedule the next event
	If (nMinutes % GlobalCuckooEpoch == GlobalCuckooEpoch - 1) Then ; if within one minute of playing chimes
		Let nScheduleTime = 5 ; schedule the next event for half a second in the future
	Else  ; else schedule the next event for within one minute of the next time at which the chimes should be sounded
		Let nScheduleTime = 600 * (GlobalCuckooEpoch - 1 - (nMinutes % GlobalCuckooEpoch))
	EndIf
EndIf
; Schedule the next time CuckooEvent should be run to check the time
Let GlobalCuckooEventHandle = ScheduleFunction ("CuckooEvent", nScheduleTime)
EndFunction

Void Function CuckooCall ()
PlaySound(GetJAWSSettingsDirectory() + cscDoubleBackslash + globalCuckooSound60)
Let GlobalCuckooCalls=GlobalCuckooCalls - 1
If (globalCuckooCalls) then
ScheduleFunction("CuckooCall", GlobalCuckooDelay60)
EndIf
EndFunction

Void Function CuckooAnnouncetime ()
SayUsingVoice(VCTX_MESSAGE, CuckooMSG1 + SysGetTime(), OT_NO_DISABLE)
EndFunction
