// mixapp.h

#ifndef _INC_MIXAPP
#define _INC_MIXAPP

#ifndef EXTERN_C
#ifdef __cplusplus
    #define EXTERN_C extern "C"
#else
    #define EXTERN_C extern
#endif
#endif

#ifdef __cplusplus
extern "C"
{
#endif





//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - ;
//
// defines
//
//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - ;

#ifndef TVIS_FOCUSED
#define TVIS_FOCUSED            0x0001
#endif

// for compiling Unicode
#ifdef UNICODE
	#define SIZEOF(x)	(sizeof(x)/sizeof(WCHAR))
#else
	#define SIZEOF(x)	sizeof(x)
#endif

// The most characters that the name of this application can contain
#define APP_MAX_APP_NAME_CHARS          30
#define APP_MAX_APP_NAME_BYTES          (APP_MAX_APP_NAME_CHARS * sizeof(TCHAR))

// The most characters that MEditPrintf()'s formatted string can contain
#define APP_MAX_STRING_RC_CHARS         512
#define APP_MAX_STRING_RC_BYTES         (APP_MAX_STRING_RC_CHARS * sizeof(TCHAR))

// The most characters that an error message can contain
#define APP_MAX_STRING_ERROR_CHARS      512
#define APP_MAX_STRING_ERROR_BYTES      (APP_MAX_STRING_ERROR_CHARS * sizeof(TCHAR))





//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - ;
//
// extern functions
//
//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - ;

// mixapp.c
int doMsgBox(HWND hwnd, UINT fuStyle, LPCTSTR pszFormat, ...);
int doWindowText(HWND hwnd, LPCTSTR pszFormat, ...);
int MEditPrintF(HWND hedit, LPCTSTR pszFormat, ...);

// mixabout.c
BOOL APIENTRY aboutDlgProc(HWND hwnd, UINT uMsg, WPARAM wParam, LPARAM lParam);

// mixdev.c
void closeMixer(void);
HMIXER openMixer(HWND hwnd, UINT mixerID);
BOOL APIENTRY mixerDevDlgProc(HWND hwnd, UINT uMsg, WPARAM wParam, LPARAM lParam);

// mixlines.c
long redrawAudioLines(void);
BOOL redrawLineInfo(void);
LRESULT MixAppLineChange(HWND hwnd, HMIXER hmx, DWORD dwLineID);

// mixctrls.c
long editParameter(DWORD dwControlID);
long redrawParameters(void);
BOOL APIENTRY parameterInfoDlgProc(HWND hwnd, UINT uMsg, WPARAM wParam, LPARAM lParam);
LRESULT MixAppControlChange(HWND hwnd, HMIXER hmx, DWORD dwControlID);

// mixfader.c
BOOL APIENTRY faderDlgProc(HWND hwnd, UINT uMsg, WPARAM wParam, LPARAM lParam);

// mixswtch.c
BOOL APIENTRY switchDlgProc(HWND hwnd, UINT uMsg, WPARAM wParam, LPARAM lParam);

// mixmeter.c
BOOL APIENTRY meterDlgProc(HWND hwnd, UINT uMsg, WPARAM wParam, LPARAM lParam);

// mixlist.c
BOOL APIENTRY listDlgProc(HWND hwnd, UINT uMsg, WPARAM wParam, LPARAM lParam);







//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - ;
//
// global variables
//
//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - ;

extern HINSTANCE		MyInstance;
extern HWND				MainWindow;
extern HMIXER			MixerHandle;
extern MIXERLINE        CurrMixerLine;
extern MIXERCONTROL     CurrParameter;
extern BOOL             gfDisplayingControl;
extern DWORD            gdwControlID;
extern HWND             ghdlgControl;





#ifdef __cplusplus
}
#endif

#endif // _INC_MIXAPP
