/*
You must link with winmm.lib. If using Visual C++, go to Build->Settings. Flip to the Link page,
and add winmm.lib to the library/object modules.

This app plays the MIDI file C:\WINDOWS\SONG.MID using the Sequencer device (ie, High level
MIDI API).
*/

#include <windows.h>
#include <stdio.h>
#include <conio.h>
#include <mmsystem.h>





/************************** PrintMciErrorMsg() ***************************
 * Retrieves and displays an error message for the passed MCI error
 * number. It does this using mciGetErrorString().
 *************************************************************************/

void PrintMciErrorMsg(DWORD err, TCHAR * str)
{
#define BUFFERSIZE 128
	char	buffer[BUFFERSIZE];
	
	printf("ERROR: %s\r\n", str);
	if (mciGetErrorString(err, &buffer[0], sizeof(buffer)))
	{
		printf("%s\r\n", &buffer[0]);
	}
	else
	{
		printf("0x%08X returned!\r\n", err);
	}
}





/* ******************************** main() ******************************** */

int main(int argc, char **argv)
{
	DWORD			err;
	MCI_OPEN_PARMS	midiParams;

	/*	Specify the Sequencer device as the type of device. It's true that, because we're also going to ask
		to open a MIDI filename that ends with a .MID and this extension undoubtably has a registry
		association with the Sequencer Device, we don't really need to set this field, nor specify the
		MCI_OPEN_TYPE|MCI_OPEN_TYPE_ID flags. But it doesn't hurt to play it safe by explicitly asking for
		the Sequencer device.
	*/
	midiParams.lpstrDeviceType = (LPCSTR)MCI_DEVTYPE_SEQUENCER;
	
	/* Specify the MIDI file we wish operated upon (ie, played) */
	midiParams.lpstrElementName = "C:\\WINDOWS\\SONG.MID";

	/* Open a Sequencer device, associating it with C:\WINDOWS\SONG.MID, and wait for the operation to complete */
	if ((err = mciSendCommand(0, MCI_OPEN, MCI_WAIT|MCI_OPEN_ELEMENT|MCI_OPEN_TYPE|MCI_OPEN_TYPE_ID, (DWORD)(LPVOID)&midiParams)))
	{
		/* Error */
		PrintMciErrorMsg(err, "Sequencer device did not open!");

		/* Exit the program */
		return(-1);
	}

	/* The device opened successfully. waveParams.wDeviceID now contains the device ID */

	/* Play the MIDI file (from beginning to end), and wait for this operation to complete */
	if ((err = mciSendCommand(midiParams.wDeviceID, MCI_PLAY, MCI_WAIT, (DWORD)(LPVOID)&midiParams)))
	{
		/* Error */
		PrintMciErrorMsg(err, "MIDI file did not play!");
	}

	/* Close the device, and wait for this operation to complete */
	mciSendCommand(midiParams.wDeviceID, MCI_CLOSE, MCI_WAIT, (DWORD)(LPVOID)&midiParams);

	return(0);
}