// MfcReadDlg.cpp : implementation file

// This is a standard MFC produced file, except that a LISTBOX and a "Load" BUTTON have been
// added to the main dialog, and therefore the function OnLoadMidi() has been added to the
// dialog's message map to load a MIDI file and display its events as text in the listbox.
// OnLoadMidi simply call LoadMidi in the MfcMidiFile class -- the class we add to handle
// loading a MIDI file. See MfcMidiFile.cpp for all of the details about loading a MIDI file
// using MIDIFILE.DLL.

#include "stdafx.h"
#include "MfcRead.h"
#include "MfcReadDlg.h"
#include "MfcMidiFile.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif





// Main dialog message map
BEGIN_MESSAGE_MAP(CMfcReadDlg, CDialog)
	//{{AFX_MSG_MAP(CMfcReadDlg)
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_LOAD, OnLoadMidi)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()





// ************************* CMfcReadDlg() ***********************
// Constructor for Main Dialog

CMfcReadDlg::CMfcReadDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CMfcReadDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CMfcReadDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}





// ********************* DoDataExchange() ***********************

void CMfcReadDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CMfcReadDlg)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
}





// ************************ OnInitDialog() **********************
// Called before Main dialog is displayed.

BOOL CMfcReadDlg::OnInitDialog()
{
	CMenu *			hwndMenu;

	// Init dialog
	CDialog::OnInitDialog();

	// Get rid of Size and Maximize items
	hwndMenu = GetSystemMenu(FALSE);
	hwndMenu->DeleteMenu(0xF000, MF_BYCOMMAND);
	hwndMenu->DeleteMenu(0xF030, MF_BYCOMMAND);

	// Set the icon for this dialog. The framework does this automatically
	// when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// return TRUE unless you set the focus to a control
	return TRUE;
}





// ************************* OnPaint() *************************

void CMfcReadDlg::OnPaint() 
{
	// If you add a minimize button to your dialog, you will need the code below
	// to draw the icon. For MFC applications using the document/view model,
	// this is automatically done for you by the framework.
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}





// ************************** OnQueryDragIcon() *************************
// The system calls this to obtain the cursor to display while the user
// drags the minimized window.

HCURSOR CMfcReadDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}





// **************************** OnLoadMidi() ***************************
// Called when user clicks on the "Load" button.

void CMfcReadDlg::OnLoadMidi()
{
	CListBox * hwndList;

#ifdef RAMFILE_IO
	if ((hwndList = (CListBox *)GetDlgItem(IDC_MIDI)))
	{
		// Hide the listbox (so updating is much faster
		hwndList->ShowWindow(SW_HIDE);
			
		// Clear out the listbox
		hwndList->ResetContent();

		// Call MfcMidiFile's LoadMidi
		MyCMidiFile.LoadMidi(0);

		// Show the listbox
		hwndList->ShowWindow(SW_SHOW);
	}
#else
	// Create the Load File dialog
	CFileDialog fdlg(TRUE, 0, 0, OFN_FILEMUSTEXIST|OFN_LONGNAMES, (const char *)"MIDI files (*.mid)|*.mid|All files (*.*)|*.*||");

	// Present the dialog and get user's selection
	if(fdlg.DoModal() == IDOK)
	{
		if ((hwndList = (CListBox *)GetDlgItem(IDC_MIDI)))
		{
			// Hide the listbox (so updating is much faster
			hwndList->ShowWindow(SW_HIDE);
			
			// Clear out the listbox
			hwndList->ResetContent();

			// Call MfcMidiFile's LoadMidi
			MyCMidiFile.LoadMidi((LPCTSTR)fdlg.GetPathName());

			// Show the listbox
			hwndList->ShowWindow(SW_SHOW);
		}
	}
#endif
}
