// MfcWriteDlg.cpp : implementation file

// This is a standard MFC produced file, except that a "Save" BUTTON has been
// added to the main dialog, and therefore the function OnSaveMidi() has been added to the
// dialog's message map to save a format 1 MIDI file. OnSaveMidi simply call SaveMidi in the
// MfcMidiFile class -- the class we add to handle saving a MIDI file. See MfcMidiFile.cpp for all
// of the details about writing a MIDI file using MIDIFILE.DLL.

#include "stdafx.h"
#include "MfcWrite.h"
#include "MfcWriteDlg.h"
#include "MfcMidiFile.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif





// Main dialog message map
BEGIN_MESSAGE_MAP(CMfcWriteDlg, CDialog)
	//{{AFX_MSG_MAP(CMfcWriteDlg)
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_BUTTON1, OnSaveMidi)
	ON_BN_CLICKED(IDC_FORMAT, OnFormat)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()





// ************************* CMfcWriteDlg() ***********************
// Constructor for Main Dialog

CMfcWriteDlg::CMfcWriteDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CMfcWriteDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CMfcWriteDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}





// ********************* DoDataExchange() ***********************

void CMfcWriteDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CMfcWriteDlg)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
}





// ************************ OnInitDialog() **********************
// Called before Main dialog is displayed.

BOOL CMfcWriteDlg::OnInitDialog()
{
	CMenu *			hwndMenu;

	// Init dialog
	CDialog::OnInitDialog();

	// Get rid of Size and Maximize items
	hwndMenu = GetSystemMenu(FALSE);
	hwndMenu->DeleteMenu(0xF000, MF_BYCOMMAND);
	hwndMenu->DeleteMenu(0xF030, MF_BYCOMMAND);

	// Set the icon for this dialog. The framework does this automatically
	// when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// return TRUE unless you set the focus to a control
	return TRUE;
}





// ************************* OnPaint() *************************

void CMfcWriteDlg::OnPaint() 
{
	// If you add a minimize button to your dialog, you will need the code below
	// to draw the icon. For MFC applications using the document/view model,
	// this is automatically done for you by the framework.
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}





// ************************** OnQueryDragIcon() *************************
// The system calls this to obtain the cursor to display while the user
// drags the minimized window.

HCURSOR CMfcWriteDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}





// **************************** OnSaveMidi() ***************************
// Called when user clicks on the "Save" button.

void CMfcWriteDlg::OnSaveMidi()
{
	CButton *	hwndButton;
	CStatic *	hwndStatic;
	char		buf[10];

#ifdef RAMFILE_IO
	// Get handle of Static
	if ((hwndStatic = (CStatic *)GetDlgItem(IDS_STATUS)))
	{
		// Display "Saving..."
		hwndStatic->SetWindowText((LPCTSTR)"Saving...");
	}

	// Get handle of Format button
	if ((hwndButton = (CButton *)GetDlgItem(IDC_FORMAT)))
	{
		// Get the text (label) and extract the format # from "Format 0", "Format 1", or "Format 2"
		hwndButton->GetWindowText((LPTSTR)&buf[0], 10);
	}
	
	// Call MfcMidiFile's SaveMidi
	MyCMidiFile.SaveMidi(0, buf[8] - '0');

	// Restore the instructions
	if ((hwndStatic = (CStatic *)GetDlgItem(IDS_STATUS)))
	{
		hwndStatic->SetWindowText((LPCTSTR)"Press the Save button to save a MIDI file.");
	}
#else
	// Create a File Dialog for saving (list files that end in .mid)
	CFileDialog fdlg(FALSE, 0, 0, OFN_OVERWRITEPROMPT|OFN_HIDEREADONLY|OFN_NOREADONLYRETURN|OFN_LONGNAMES, (const char *)"MIDI files (*.mid)|*.mid|All files (*.*)|*.*||");

	// Present the dialog and get user's selection
	if(fdlg.DoModal() == IDOK)
	{
		// Get handle of Static
		if ((hwndStatic = (CStatic *)GetDlgItem(IDS_STATUS)))
		{
			// Display "Saving..."
			hwndStatic->SetWindowText((LPCTSTR)"Saving...");
		}

		// Get handle of Format button
		if ((hwndButton = (CButton *)GetDlgItem(IDC_FORMAT)))
		{
			// Get the text (label) and extract the format # from "Format 0", "Format 1", or "Format 2"
			hwndButton->GetWindowText((LPTSTR)&buf[0], 10);
		}
	
		// Call MfcMidiFile's SaveMidi
		MyCMidiFile.SaveMidi((LPCTSTR)fdlg.GetPathName(), buf[8] - '0');

		// Restore the instructions
		if ((hwndStatic = (CStatic *)GetDlgItem(IDS_STATUS)))
		{
			hwndStatic->SetWindowText((LPCTSTR)"Press the Save button to save a MIDI file.");
		}
	}
#endif
}





// **************************** OnFormat() ****************************
// When user clicks on the Format button. We cycle the button's label
// through the choices of "Format 0", "Format 1", and "Format 2"

void CMfcWriteDlg::OnFormat() 
{
	CButton *	hwndButton;
	char		buf[12];
	
	// Get handle of Format button
	if ((hwndButton = (CButton *)GetDlgItem(IDC_FORMAT)))
	{
		// Get the text (label)
		hwndButton->GetWindowText((LPTSTR)&buf[0], 12);

		// Increment the number after "Format ". After "2", roll over to "0"
		buf[8] += 1;
		if (buf[8] == '3') buf[8] = '0';

		// Set the text (label)
		hwndButton->SetWindowText((LPTSTR)&buf[0]);
	}
}
