/*
 * unnormal
 * by Bob Crispen
 * crispen@hiwaay.net
 *
 * Removes all "Normal" and "normalIndex" nodes and fields from
 * a VRML 1.0 file.  Believed to also work on VRML 2.0 files, but
 * not extensively tested.
 *
 * Called: unnormal [infile] [outfile]
 *
 * Why?  CAD programs that export VRML and some VRML conversion
 * utilities often create bogus normals.  Often the world looks
 * considerably better without the Normals, and in any case,
 * removing the Normals reduces the file size and speeds downloading
 * and rendering.  For some files unnormal is just the ticket.
 * For others, it messes up the appearance of the file.
 *
 * On DOS/Windows machines, if the output file is named, the
 * input file will have extra CR characters (0x0d, '\r')
 * stripped off.  If you don't want this, redirect standard
 * output to your destination file.
 *
 * Version: 1.1, 24 May 2000
 *  No functional changes.  Clean up to compile with lcc.
 */
#include <stdio.h>
#include <string.h>

#ifdef MSDOS
#define READOPTS "rb"
#define WRITEOPTS "wb"
#else
#define READOPTS "r"
#define WRITEOPTS "w"
#endif

static char *xusage = "[infile] [outfile]";
static char *progname;

int main (int argc, char **argv)
{
    FILE *infile = stdin;
    FILE *outfile = stdout;
    int c;
    char buf[1000];
    char buf2[2000];
    int bufptr = 0;
    char *token;
    char *outfilename = NULL;
    int argn=1;

    int usage();

    progname = argv[0];
    if (argc > 1)
	if (argv[argn][0] == '-')
	    return usage(); /* We ain't got no steenking options */
    if (argn < argc) {
	if ((infile = fopen(argv[argn++], READOPTS)) == NULL) {
	    perror ("Infile:");
	    return -1;
	}
    }

    if (argn < argc) {
	if ((outfile=fopen(argv[argn++], WRITEOPTS)) == NULL) {
	    perror ("Outfile:");
	    return -1;
	}
    }
    if (argn < argc)
	return usage();

    while ((c=getc(infile)) != EOF) {
	buf[bufptr++] = c;
	if ((c == '\n') || (c == '\r')) {
	    buf[--bufptr] = '\0';
	    strcpy(buf2, buf);
	    if ((token = strtok (buf2, " \t\n\r\0")) != NULL) {
		if (!strcmp(token, "Normal")) {
		    if (buf[bufptr-1] == '}') {
			bufptr=0;
		    } else {
			bufptr=0;
			while ((c=getc(infile)) != '}');
		    }
		}
		if (!strcmp(token, "normalIndex")) {
		    if (buf[bufptr-1] == ']') {
			bufptr=0;
		    } else {
			bufptr=0;
			while ((c=getc(infile)) != ']');
		    }
		}
	    }
	    if (bufptr != 0) {
		fprintf(outfile, "%s\n", buf);
		bufptr=0;
	    }
	}
    }
    return 0;
}

int usage()
{
    fprintf (stderr, "Usage: %s %s\n", progname, xusage);
    return -1;
}
