/*
* highlight
* by Bob Crispen
* 27 July 1997
* called: cat file | highlight url searchword[...]
* Takes a file and highlights each of the search words found by
* turning them red and making them blink (gross!)
*
* The user will want to modify URLHDR and FILEHDR
*/
#include <stdio.h>
#include <string.h>

#define URLHDR "http://hiwaay.net/~crispen"
#define FILEHDR "/data2/Lkr_Usr_/crispen/public_html"
#define MAXSTRLEN 100
#define MAXSTRINGS 100
#define BUFLEN 1000

main(int argc, char** argv)
{
    char url[MAXSTRLEN];
    char urlbase[MAXSTRLEN];
    char tokbuf[BUFLEN];
    char srch[MAXSTRINGS][MAXSTRLEN];
    int srches = 0;
    FILE *urlfile;
    char buf[BUFLEN];
    char buf2[BUFLEN];
    char tstbuf[BUFLEN];
    char extension[MAXSTRLEN];
    char content[MAXSTRLEN];
    char *token;
    char *tokptr;
    int c, i, j, offset, found, bufptr=0;
    int intag = 0;
    int basefixed = 0;
    char *foundpos;
    int moreline;
    int firstfound = 0;
    int inbody = 0;

    void lower(char *s);

    /* Check for bad calling arguments */
    if (argc < 2) {
	printf ("Content-type: text/plain\n\n");
	printf("%s: url searchword[...]\n", argv[0]);
	exit(-1);
    }

    /*
    * Fix up the URL to make it a local file which we'll open
    */
    bzero(url, sizeof(url));
    if (!strncmp(argv[1], URLHDR, strlen(URLHDR))) {
	strncpy(url, FILEHDR, strlen(FILEHDR));
	strcat(url, &argv[1][strlen(URLHDR)]);
    } else {
	strcpy(url, argv[1]);
    }

    /* Grab the file extension */
    bzero(extension, sizeof(extension));
    for (i=strlen(url); ((url[i] != '.') && (url[i] != '/')); --i);
    if (url[i] == '.')
	strcpy (extension, &url[i]);


    /* Save the base */
    for (i=strlen(argv[1]); argv[1][i] != '/'; --i);
    strncpy(urlbase, argv[1], i+1);

    /* Collect the search strings and convert to lower case */
    for (j=2; j<argc; j++) {
	strcpy(tokbuf, argv[j]);
	lower(tokbuf);
	tokptr = tokbuf;
	while ((token = strtok(tokptr, "()* \0")) != NULL) {
	    tokptr = NULL;
	    if (strcmp(token, "and") &&
		strcmp(token, "or") &&
		strcmp(token, "not"))
		strcpy(srch[srches++], token);
	}
    }

    /* Open the URL file */
    if ((urlfile = fopen(url, "r")) == 0) {
	printf("Content-type: text/plain\n\n");
	printf("Can't open %s\n", url);
	exit(-1);
    }

    /* 
    * Non-HTML documents just get dumped, perhaps with the
    * proper header
    */
    bzero (content, sizeof(content));
    strcpy (content, "Content-type: ");
    if ((strcmp(extension, ".html")) && (strcmp(extension, ".htm"))) {
	if ((!strcmp(extension, ".exe")) || (!strcmp(extension, ".bin")))
	    strcat (content, "application/octet-stream\n\n");
	if (!strcmp(extension, ".gif"))
	    strcat (content, "image/gif\n\n");
	if (!strcmp(extension, ".jpg"))
	    strcat (content, "image/jpeg\n\n");
	if (!strcmp(extension, ".wrl"))
	    strcat (content, "model/vrml\n\n");
	if ((!strcmp(extension, ".eps")) || (!strcmp(extension, ".ps")))
	    strcat (content, "application/postscript\n\n");
	if (!strcmp(extension, ".xbm"))
	    strcat (content, "application/x-xbitmap\n\n");
	if (!strcmp(extension, ".xpm"))
	    strcat (content, "application/x-xpixmap\n\n");
	if (!strcmp(extension, ".pdf"))
	    strcat (content, "application/pdf\n\n");
	if (!strcmp(extension, ".rtf"))
	    strcat (content, "application/rtf\n\n");
	if (!strcmp(extension, ".mpg"))
	    strcat (content, "video/mpeg\n\n");
	if (!strcmp(extension, ".au"))
	    strcat (content, "audio/basic\n\n");
	if (!strcmp(extension, ".qt"))
	    strcat (content, "video/quicktime\n\n");
	if (!strcmp(extension, ".avi"))
	    strcat (content, "video/x-msvideo\n\n");
	if (!strcmp(extension, ".doc"))
	    strcat (content, "application/msword\n\n");
	if (!strcmp(extension, ".ppt"))
	    strcat (content, "application/powerpoint\n\n");
	if (!strcmp(extension, ".xls"))
	    strcat (content, "application/excel\n\n");
	if (!strcmp(extension, ".avi"))
	    strcat (content, "video/x-msvideo\n\n");
	if ((!strcmp(extension, ".txt")) || (extension[0] == '\0'))
	    strcat (content, "text/plain\n\n");

	if (content[0] == '\0')
	    printf ("Content-type: text/plain\n\n");
	else
	    printf ("%s", content);

	while ((c=getc(urlfile)) != EOF)
	    putc(c, stdout);
	fclose(urlfile);
	exit(0);

    /*
    * If it's an HTML file, keep going
    */
    } else {
	printf ("Content-type: text/html\n\n");
    }

    while ((c=getc(urlfile)) != EOF) {
	buf[bufptr++] = c;
	/*
	* Process one line at a time
	*/
	if (buf[bufptr-1] == '\n') {
	    buf[bufptr] = '\0';
	    moreline = 1;
	    intag = 0;
	    /*
	    * Loop until there's no more of this line to process
	    */
	    while (moreline) {
		strcpy(tstbuf, buf);
		lower(tstbuf);
		/*
		* Put a base tag inside the head section
		*/
		if (!basefixed) {
		    if (strstr(tstbuf, "</head>")) {
			printf("<base href=\"%s\">\n", urlbase);
			basefixed = 1;
			inbody = 1;
		    }
		    if (strstr(tstbuf, "<body")) { /* Forgot to close head */
			printf("<base href=\"%s\">\n</head>\n", urlbase);
			basefixed = 1;
			inbody = 1;
		    }
		}
		/*
		* See if the word is one of our search words
		*/
		found = 0;
		for (i=0; i<srches; i++) {
		    if ((foundpos = strstr(tstbuf, srch[i]))) {
			offset = (int)foundpos - (int)tstbuf;
			bzero (tstbuf, sizeof(tstbuf));
			/*
			* Check to see that the word isn't inside a tag
			*/
			for (j=0; j<offset; j++) {
			    if (buf[j] == '<')
				intag = 1;
			    if (buf[j] == '>')
				intag = 0;
			}
			if (intag || !inbody) {
			    /*
			    * It is.  Print just this much of the line
			    * and keep looking in this line.
			    */
			    bzero (buf2, sizeof(buf2));
			    strncpy (buf2, buf, offset+strlen(srch[i]));
			    printf ("%s", buf2);
			    strcpy (buf, &buf[offset+strlen(srch[i])]);
			    strcpy (tstbuf, buf);
			    lower (tstbuf);
			    found = 1;
			} else {
			    /*
			    * Highlight the word, but keep the rest
			    * of the line, because a search word might
			    * appear later in the line.
			    */
			    strncat (tstbuf, buf, offset);
			    strcat (tstbuf, "<blink><font color=\"#ff0000\">");
			    strncat (tstbuf, &buf[offset], strlen(srch[i]));
			    strcat (tstbuf, "</font></blink>");
			    strcpy (buf, &buf[offset+strlen(srch[i])]);
			    printf ("%s", tstbuf);
			    if (!firstfound && inbody) {
				printf ("<a name=\"HEREHEREHERE\"></a>");
				firstfound = 1;
			    }
			    strcpy (tstbuf, buf);
			    lower (tstbuf);
			    found = 1;
			}
		    }
		}
		/*
		* If we didn't find anything the last time through,
		* we're done with this line
		*/
		if (!found) {
		    moreline = 0;
		    printf ("%s", buf);
		}
		bufptr=0;
	    }
	}
    }
    fclose(urlfile);
    exit(0);
}

void lower(char *s)
{
    int i;
    for (i=0; s[i] != '\0'; i++) {
	if (isupper(s[i]))
	    s[i]  = tolower(s[i]);
    }
}
