#include <windows.h>
#include <GL/gl.h>
#include <GL/glu.h>
#include <GL/glut.h>
#include <stdio.h>
#include <stdlib.h>
#include <limits.h>
#include <string.h>
#include "glut_test.h"

int windowId = -1;
int viewportWidth = -1;
int viewportHeight = -1;

void displayCallback() {
	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
	glMatrixMode(GL_MODELVIEW);
	glLoadIdentity();
	glTranslatef(0.0f, 0.0f, -1.0f);
	// glColor4f(1.0f, 0.0f, 0.0f, 1.0f);
	glBegin(GL_TRIANGLES);
    glColor3f(1.0f, 0.0f, 0.0f);
    glVertex2i(0,  1);
    glColor3f(0.0f, 1.0f, 0.0f);
    glVertex2i(-1, -1);
    glColor3f(0.0f, 0.0f, 1.0f);
    glVertex2i(1, -1);
	// glVertex3f(0.0f, 1.0f, 0.0f);
	// glVertex3f(1.0f, -1.0f, 0.0f);
	// glVertex3f(-1.0f, -1.0f, 0.0f);
	glEnd();
	glFlush();
	glutSwapBuffers();
}

void reshapeCallback(int width, int height) {
	viewportWidth = width;
	viewportHeight = height;
	setupViewport();
	glutPostRedisplay();
}

void setupGraphics(int argc, char **argv) {
	GLfloat ambientLight[] = { 1.0f, 1.0f, 1.0f, 1.0f };
	GLfloat emissiveLight[] = { 0.0f, 0.0f, 0.0f, 1.0f };
	GLfloat diffuseLight[] = { 1.0f, 1.0f, 1.0f, 1.0f };
	GLfloat specularLight[] = { 1.0f, 1.0f, 1.0f, 1.0f };

	GLfloat materialAmbient[] = { 0.1f, 0.1f, 0.1f, 1.0f };
	GLfloat materialDiffuse[] = { 0.1f, 0.1f, 0.1f, 1.0f };
	GLfloat materialEmission[] = { 0.0f, 0.0f, 0.0f, 1.0f };
	GLfloat materialSpecular[] = { 1.0f, 1.0f, 1.0f, 1.0f };

	GLfloat lightPosition[] = { 0.0f, 0.0f, 1.0f, 1.0f };

	// setup glut

	viewportWidth = 400;
	viewportHeight = 300;
	glutInitWindowSize(viewportWidth,viewportHeight);
	glutInitWindowPosition(70, 70);
	glutInit(&argc, argv);
	glutInitDisplayMode(GLUT_RGBA | GLUT_DOUBLE | GLUT_DEPTH);
	windowId = glutCreateWindow("GLUT TEST");
	glutSetWindow(windowId);
	glutDisplayFunc(displayCallback);
	glutReshapeFunc(reshapeCallback);
	glutVisibilityFunc(NULL);
	glutIdleFunc(NULL);
	glutMouseFunc(NULL);
	glutKeyboardFunc(NULL);
	glutKeyboardUpFunc(NULL);
	glutMotionFunc(NULL);
	glutPassiveMotionFunc(NULL);
	glutShowWindow();

	// setup gl

	glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
	glEnable(GL_LIGHTING);
	glLightfv(GL_LIGHT0, GL_AMBIENT, ambientLight);
	glLightfv(GL_LIGHT0, GL_EMISSION, emissiveLight);
	glLightfv(GL_LIGHT0, GL_DIFFUSE, diffuseLight);
	glLightfv(GL_LIGHT0, GL_SPECULAR, specularLight);
	glLightfv(GL_LIGHT0, GL_POSITION, lightPosition);
	glEnable(GL_LIGHT0);
	glEnable(GL_BLEND);
	glEnable(GL_COLOR_MATERIAL);
	glShadeModel(GL_SMOOTH);
	glColorMaterial(GL_FRONT, GL_AMBIENT_AND_DIFFUSE);
	glMaterialfv(GL_FRONT, GL_AMBIENT, materialAmbient);
	glMaterialfv(GL_FRONT, GL_DIFFUSE, materialDiffuse);
	glMaterialfv(GL_FRONT, GL_EMISSION, materialEmission);
	glMaterialfv(GL_FRONT, GL_SPECULAR, materialSpecular);
	glMateriali(GL_FRONT, GL_SHININESS, 128);
	glEnable(GL_DEPTH_TEST);
}

void setupViewport() {
	glViewport(0, 0, viewportWidth, viewportHeight);
	gluPerspective(90.0, (GLdouble) viewportWidth / (GLdouble) viewportHeight, 0.0, 100.0);
}

int main(int argc, char **argv) {
	setupGraphics(argc, argv);
	glutMainLoop();
	return 0;
}



