// functions private to newslib.c


// Data structure used by all the main process routines
typedef struct {
    HWND	hwndDlg;
    HWND	hwndProgress;
    SOCKET	sockNews;
    char	szServerName[BUFSIZE];
    char	szNewsgroup[BUFSIZE];
    char	szSearchString[BUFSIZE];
    char	szLoginName[SHORTBUFSIZE];
    char	szPassword[SHORTBUFSIZE];
    int		nStateCmd;
    int		nState;
    int		nDaysPast;
    BOOL	fListNewsgroups;
    BOOL	fShowHdrs;
    BOOL	fPastDays;
    BOOL	fArticleText;
    BOOL	fBinaryAttachments;
    BOOL	fURLs;
    BOOL	fMakeLog;
    BOOL	fDontSaveDups;
} stateMachine;

// Main process routines
int	process_connect_reply(stateMachine);
int	process_list_newsgroups_reply(stateMachine);
int	process_list_reply(stateMachine);
int	process_listing_newsgroups(stateMachine);
int	process_group_reply(stateMachine);
int	process_list_overview_fmt_reply(stateMachine);
int	process_getting_overview_fmt(stateMachine);
int	process_xover_reply(stateMachine);
int	process_reading_xover_data(stateMachine);
int	process_head_reply(stateMachine);
int	process_reading_header(stateMachine);
int	process_article_reply(stateMachine);
int	process_reading_article(stateMachine);
int	process_authinfo_user_reply(stateMachine);
int	process_authinfo_pass_reply(stateMachine);
int	process_quitting(stateMachine);

// Auxiliary routines (forward references)
int	b64decode(char*, FILE*, char*);
void	clean_up_filename(char*);
int	copy_header_file(HWND);
int	create_article_file(HWND, char*);
int	create_attachment_file(HWND, char*, BOOL, BOOL);
time_t	date_to_time_t(char*, HWND);
void	convert_alt_char_set(char*, char*);
void	get_date(char*);
int	get_hdr_file_line(HWND, char*);
int	get_hdr_file_line_and_send_body(HWND, HWND, SOCKET, char*);
void	get_hdr_text(char*, char*, BOOL, BOOL);
int	get_one_line(char*);
void	get_sender(char*, BOOL, BOOL);
void	get_subject(char*, BOOL, BOOL);
void	init_buffers();
int	match(char*, char*);
void	list_headers(HWND, HWND, BOOL, char*);
int	next_header(stateMachine);
int	open_article_file(HWND, char*);
int	open_attachment_file(HWND, char*, char*, BOOL, BOOL);
int	open_url_file(HWND, char*);
void	outdec(char*, FILE*, int);
BOOL	recv_from_news_host(HWND, SOCKET);
void	set_date_limit(int);
int	set_up_for_reading_articles(stateMachine);
time_t	systime_to_time_t(SYSTEMTIME);
time_t	time_limit(int);
void	uudecode(char*, FILE*);
int compare_newsgroups (char**, char**);

