/*
* VRML Color Picker
* by Bob Crispen <crispen@hiwaay.net>
*
* Windows 9x/NT program that brings up a color selection palette
* and copies the RGB value (0.0 <= r,g,b <= 1.0) to the clipboard.
*
* This program is free software under the terms of the GNU GPL.
*/
#include <windows.h>
#include <commdlg.h>

static char szAppName[] = "ColorPicker";

int WINAPI WinMain (HINSTANCE hInstance, HINSTANCE hPrevInstance,
                    PSTR szCmdLine, int iCmdShow)
{
     static WNDCLASSEX  wndclass;
     static CHOOSECOLOR cc;
     static COLORREF    crCustColors[16];
	 static char        *szColorString;
	 static HGLOBAL     hGlobalMemory;
	 static PSTR        pGlobalMemory;

     wndclass.hIcon    = LoadIcon(hInstance,szAppName);
     cc.lStructSize    = sizeof (CHOOSECOLOR);
     cc.hwndOwner      = NULL;
     cc.hInstance      = NULL;
     cc.rgbResult      = RGB (0x80, 0x80, 0x80);
     cc.lpCustColors   = crCustColors;
     cc.Flags          = CC_RGBINIT | CC_FULLOPEN;
     cc.lCustData      = 0L;
     cc.lpfnHook       = NULL;
     cc.lpTemplateName = NULL;

     // Pop up the color palette common dialogue and get the selection
     (void)ChooseColor (&cc);

	 // Convert the color to VRML form and stick it in a string
	 szColorString = (char *)malloc(80);
	 memset(szColorString, 0, sizeof(szColorString));
	 sprintf(szColorString, "%1.3f %1.3f %1.3f",
	   (cc.rgbResult            & 0x000000ff)/255.0,
	   ((DWORD)cc.rgbResult>>8  & 0x000000ff)/255.0,
	   ((DWORD)cc.rgbResult>>16 & 0x000000ff)/255.0);

	 // Allocate some global memory
	 hGlobalMemory = GlobalAlloc(GHND, 80);
	 if (hGlobalMemory != NULL) {
		// Copy the string we just built to global memory
		pGlobalMemory = GlobalLock(hGlobalMemory);
		strcpy(pGlobalMemory, szColorString);
		GlobalUnlock(hGlobalMemory);
		// And then to the clipboard
		OpenClipboard(NULL); // At this point, no hwnd
		EmptyClipboard();
		SetClipboardData(CF_TEXT, hGlobalMemory);
		CloseClipboard();
	 }
	 return(0);
}
