Chapter 7 - CONFIGURATION FILES


Introduction

The Jaws Menu System and several of the functions accessible
directly from the keyboard allow you to alter various Jaws speech
parameters, create and revise Jaws Frames, create and revise Jaws
Macros, and adjust many other levels and functions as well.  By
defining frames, using macros, adjusting volume and pitch levels,
etc. you can customize Jaws to work with a wide variety of
application programs.  

Naturally, you will not want to revise fifty frames, record a dozen
macros, and change the volume of the keyboard, the pitch of the
screen, and the rate of speech for the speech pad each time you use
Lotus 1-2-3.  With the ability to save and load Jaws
configurations, each application can have its own custom Jaws
configuration and any adjustments or refinements to these
configurations need only be made when necessary.  After changes
have been made, they need never be made again - the configuration
can be saved and reloaded whenever necessary.

The Jaws Configuration which is saved includes virtually anything
you might want to change - the levels of the various speech
parameters, the definitions of frames and macros, the  on/off
setting of automatic key repeat, and many other things as well. 
Jaws Configuration files can be saved or loaded through the menu
system or from the DOS command line or from a batch file.

The Configuration File Menu

Selecting Config files from the Jaws Main Menu will bring you to
the Jaws Configuration Menu, whose choices will allow you to load
or save the Jaws configuration files.  There are 5 different files,
plus an "All" choice that loads or saves all the files with the
specified name all at once.  The different config file types can
all have the same name, only the file extension is unique: Macro
(.JMF), Frame (.JFF), Environment (.JEF), Voice (.JVF), Dictionary
(.JDF).  The extensions stand for "Jaws Macro File", "Jaws Frame
File", etc.

Loading Config Files

Selecting Load will allow you to load a previously saved
configuration from the disk.  Selecting Save will save a
configuration currently being used in the computers memory on the
disk.  In either case you will then get a menu of the 5 file
choices, plus the "All" choice.  After selecting one of these you
will be asked to provide a name for the file you wish to load.  The
default name, i.e. the one most recently accessed,  will be
displayed.  If this is what you want just hit enter. To change it,
just type in the new file name, without extension, and press enter. 
Jaws automatically assumes the default "path", which is the drive
and directory that Jaws was booted from.  To change the drive
and/or directory you must specify both as part of the file name. 
The syntax  follows standard DOS file naming conventions.  For
example, to change to the "D" drive and the "TEST" subdirectory and
load a file named "T5" enter the following:

d:\test\t5

The files can all have the same name, only the file extension is
different.  For example, all the Word Perfect files would have the
name "WPJ", with the extensions of ".JMF" for Jaws Macro file,
".JFF" for Jaws Frame File, etc.  The "All" choice would load or
save them all.

Command Line Configuration Loading

The menu system interface provides a convenient and friendly way in
which to load a configuration file.  There are times, however, when
it is desirable to load a configuration from the command line or
from a batch file.  For example, if you normally use a batch file
to perform some preparatory work prior to starting an application,
you would also want to load the proper Jaws configuration from
within that batch file.  In this way, you could avoid having to
enter the menu system and type a file name each time you start the
application.

On the Jaws program diskette is a separate program called
"J_LOAD.EXE".  This program requires one argument - the name (and
optionally, drive and path) of the Jaws configuration files to
load.  The extension should not be specified, all the config files
with the specified name will be loaded, like the "All" menu
selection.  The correct syntax is:  

J_LOAD [drive:][\path\]filename

The items enclosed in brackets are optional.  Remember that DOS is
being used to find these files, therefore you must specify enough
information for DOS to find the load program and the config files.

Booting Up

When Jaws is first started, the files named Jaws.J?F (if they 
exist) are loaded as the initial configuration.  If you wish to
have certain settings become active every time Jaws is loaded,
simply save the files with the name "Jaws".  Also remember to be
"in" or defaulted to the "Jaws" subdirectory whenever Jaws is
loaded or booted.  This insures that it can find the default "Jaws"
config files, and determines the path to the other config files and
the external utility programs like the macro editor.

For further information concerning the customizing of Jaws, refer
to the section on Trouble-shooting, the application programs,  and
the Jaws training tapes.
