Chapter 1 - INTRODUCTION


JAWS (Job Access With Speech) is a program designed to control a
variety of different speech synthesizers and add speech output to
application programs.  Jaws uses configuration files to record the
current settings of the various speech parameters (volume, rate,
pitch, etc.), frame and macro definitions, etc. Several custom
configuration files are provided with Jaws to allow it to work with
some of the most popular application programs; plus, Jaws can
easily be configured to work with most other application programs. 

Requirements and Restrictions.

Jaws will run on the IBM PC, PC XT, and PC AT along with all true
IBM compatibles and the IBM PS/2 family of computers.  Jaws
requires DOS 3.x and at least 128K of RAM, although, since Jaws
must remain in memory in order to work with the various application
programs, 640K is recommended.  Jaws requires at least an 80 column
monitor, either color or monochrome.  It works with CGA, EGA, VGA,
and other high-resolution video boards, and will handle the larger
screens (more than 25 lines and 80 columns).  Jaws will also
require at least 1 floppy disk drive (although we recommend either
two floppy drives or a hard disk).

Jaws is a Terminate and Stay Resident (TSR) program.  This means
that when you invoke Jaws, it loads itself into memory, displays
and speaks some copyright information, and then returns control
back to DOS.  Jaws remains resident in memory, operating only when
it needs to and usually in the "background", so that it can be used
with any application program you might choose to run.

The only restriction which Jaws imposes on the application is that
the application program cannot use any of the special "Graphics
Modes" provided by many monitors.  Should the application use these
modes, Jaws may still operate, but many of the screen reading
functions and the menu system will no longer function. This means
that many publishing programs, "paint" programs, and video games
will not operate well with Jaws.  Applications which don't utilize
a monitor's "Graphics Modes" (including most word processors,
spread sheets, and data bases) will function properly and will
allow Jaws to function properly as well. 

Note that programs which use graphics CHARACTERS can be used. 
These characters, also known as "Extended ASCII characters", are
frequently used for drawing boxes and lines on the screen while the
monitor remains in a standard "text mode".  These characters will
generally be ignored by Jaws, although they can be spoken.  Other
enhancements or colors which the application uses are generally
ignored, but Jaws does provide functions to determine what they are
and to search for them.

Special Design

Jaws is designed with the priorities of blind computer users in
mind.  It redefines the standard IBM keyboard to give functions
which are important to blind users a "higher priority".  All
standard keyboard operations and functions are still available, but
some are accessed in a slightly different manner.  Since keyboards
manufactured by different companies tend to be laid out
differently, Jaws uses only those keys which are commonly found in
the same location on all keyboards:  The numeric pad, the numbers
row (above the Q W E R T Y row of keys), and a few other keys.

Most Jaws speech functions such as reading lines, words, and
characters and moving about the screen can be controlled entirely
with the right hand.  If the standard Jaws keyboard layout is  not
suitable it can be changed at any time by the user with the Macro
Editor.  Other functions which are used less frequently or are more
complicated can be accessed through the Jaws Menu System.

Jaws has been defined to provide a consistent and logical interface
for the user.  The menu system, for example, uses ONLY a four line
Lotus-style pop-up menu.  The basic format of the menu never
changes and several of the common Jaws screen reading functions
have been specially tailored to work with the menu system.

The Jaws Menu System

The menu system can be invoked at any time by the use of a "Hot
Key" (a key or key sequence which will cause a TSR program to
temporarily move from the "background" into the "foreground" to
perform some function).  The menu system will allow you to adjust
the volume, rate, and pitch of keyboard, screen, and speech pad
voices; search the screen for a string or enhancement; load a Jaws
configuration from a disk file; define a frame (or window - a
rectangular region of the screen); revise a macro; and many other
things as well.

Jaws Macros

Macros are an integral part of Jaws, every Jaws function is a
macro, and almost any key on the keyboard can become a macro. 
Macros allow the user to define 1 key to perform the functions of
several other keys, providing flexibility, ease of use, and power
at the touch of a single key.  The macros or Jaws functions can
easily be switched from one key to another to suit the user or to
avoid key conflicts with a particular application.  Jaws macros can
make decisions (if-then-else) and "perform" or "jump to " another
macro.  A "set" or file of macros can be defined for each
application program to fine-tune the keyboard or the desired Jaws
functions.  Macros are stored on the disk and can be loaded at any
time.

Installation of JAWS

Hardware

The only hardware required by Jaws which is not commonly provided
when a PC is purchased is the speech synthesizer.  We have provided
an appendix with installation instructions for each speech
synthesizer which Jaws currently supports.  Refer to the Table of
Contents for the appendix pertaining to your synthesizer.  In
addition you can refer to "Installing Internal Synthesizers" or
"Serial Synthesizers" in the appendix for more helpful information.

Software

The primary consideration when installing the Jaws software is
where to put the software.  Jaws is not copy protected and can
therefore be placed on any floppy disk, hard disk, or within any
subdirectory of any disk simply by using the DOS "Copy" command. 
Occasionally, depending on the make of the synthesizer which you
use, there may be additional software to install; it will be
described in the appendix for that particular synthesizer.

Installing Jaws on a Floppy Disk Based System

We recommend that you place a copy of Jaws on the disk which you
use to "boot" the computer.  Jaws configuration files can be placed
on this disk also, or on the disk containing the application to be
used.

Installing Jaws on a Hard Disk Based System

We recommend that you create a subdirectory on your hard disk
called "JAWS" and that you copy all of the relevant Jaws software
into this directory.  For more details refer to "Jaws Software
Installation" in the appendix.

Running Jaws

After the hardware and software is installed, Jaws is invoked by
"changing directories" to the Jaws subdirectory, at the DOS prompt
enter:

CD\JAWS <enter>
and then at the DOS prompt typing:

J_synthesizer   <enter>

where "synthesizer" is the type of synthesizer you are trying to
use.  The synthesizer name may need to be shortened to fit within
6 letters, so refer to the appendix for your synthesizer for
details, or "Jaws Software Installation" for a summary.  The
"READ.ME" file on the Jaws distribution disk will have the most
current information on this matter, read it if this manual does not
cover your particular synthesizer.

After Jaws loads, it may be necessary to change the volume, rate,
or pitch of the synthesizer's speech in order to understand what is
being read.  The following sequences of key strokes should help:  

Volume:  "Control-/   V  G  V  (right arrow/left arrow to
increase/decrease, repeat as often as needed)  Enter  Escape"

Rate:    "Control-/   V  G  R  (right arrow for rate higher, left
arrow for rate lower, repeat as often as needed)  Enter  Escape"

Pitch:   "Control-/   V  G  P  (right arrow for higher pitch, left
arrow for lower pitch, repeat as often as needed)  Enter  Escape"

These key sequences invoke the Jaws menu system and will quickly
select the necessary options to adjust global speech parameters
such as volume, rate, and pitch.  The Escape at the end will cause
you to quickly exit the menu system and return to DOS (or any
application program you may have been running).

Jaws' menu system will allow you to adjust many other speech
parameters as well.  The menu system is explained in much greater
detail in the chapter entitled:  "The Jaws Menu System" and is
covered in the Jaws Training Tape. 

Removing from Memory

Sometimes you may want to remove JAWS from your computers memory,
to free-up that memory or when a sighted person wants to use the
computer.  Do do so:  Be sure you are at ehe DOS prompt, hold down
the alt key and the shift key, and press F1.  JAWS will say
"Removing JAWS from memory, okay".  Your computer should continue
to function normally, if it doesn't you probably had another
program loaded after JAWS that trapped one of the interrupt
vectors.  You will have to re-boot your machine, and do not try to
unload JAWS with other programs on top of it.

The Manual
The manual is divided into chapters that cover the basic operation
of the Speech Pad, Keyboard, and Menu System as well as some of the
more advanced features of Jaws such as Frames, Macros, and
customizing Jaws for a particular application.  It also contains an
appendix covering the installation and use of each of the
synthesizers which Jaws supports.

With the aid of a word processor, editor, or reader program Jaws
can be used to read the disk version of this manual.  To use this
feature, simply invoke the word processor, load the chapter you
wish to read, and (when you're positioned at the top of the
chapter) hold down the Insert key on the numeric pad (a large key,
usually on the bottom row) and press the down arrow on the cursor
pad.  Jaws will begin reading the chapter and will continue until
it reaches the end of that chapter or until the Control key is
pressed to stop the speech.

The chapters in this manual are:

The Speech Pad and Keyboard:  Describes the changes to the standard
keyboard; the functions of the Speech Pad, Numbers Row keys, and
Jaws Cursor; and various extra screen reading functions.

The Menu System:  Describes the operation of the menu system and
provides an overview of each of the choices offered by the menu
system.

Frames:  Describes how to create or revise a frame and explains
some of the more powerful uses for frames.

Macros:  Describes how to record and revise macro definitions and
explains in detail some of the more powerful uses for macros.

Enhancements:  Describes how to search for and speak enhancements
or colors and explains some of the more powerful uses for
enhancement searches.

Searching and Go To:  Describes how to search the screen for a
string of text, how to move the Jaws Cursor to a specific screen
row or column, and some of the more powerful uses for each of these
functions.

The "Trouble-shooting" chapter will help you to understand some of
the more complex problems you may encounter, how to de-bug the
problem, and how to adjust Jaws to handle it.  Naturally this
chapter will change and evolve as we come up with more solutions,
refer to the same chapter on disk for the most current information
on this subject.

Customizing Jaws for various application programs:  Refer to the
chapter on "Application Programs" to see how we have customized
Jaws to suit these applications.  This material is also covered on
our training tapes for specific applications, and of course in the
manual on disk.

Appendixes:  The appendixes provide installation instructions for
each of the synthesizers supported by Jaws, hardware and software
installation, Toshiba lap top computers, quick reference guides,
and more.

Index:  An alphabetical cross reference to the topics covered in
this manual and the pages on which they are found.  This appears at
the end of the print manual, it is a separate file on disk, and
should be used to find specific subjects.
