Appendix J - JAWS SOFTWARE INSTALLATION


This section contains information about installing the Jaws
software, running Jaws, and the files on your Jaws distribution
disk.

The Jaws Subdirectory: We highly recommend that you create a "Jaws"
subdirectory on your hard disk in which all the Jaws software
should be placed.  If you do not have a hard disk then create a
"bootable" disk (one with the operating system and "Command.com" on
it) and copy all the Jaws software onto it.  We will call these the
Jaws subdirectory or the Jaws disk.  In order for Jaws to load
properly you must make these the "default" before invoking or
loading Jaws.  To default to a particular disk drive enter the
letter of the disk followed by a ":", e.g. "C:" and press enter. 
To default to a given subdirectory first default to the proper
disk, then enter "CD\" followed by the name of the subdirectory,
e.g. "cd\Jaws" and press enter.  

To run Jaws, set your default to the proper disk and/or
subdirectory  and then type in the name of the Jaws version for
your synthesizer.   A summary of these names appears below.

Special Versions of Jaws for each synthesizer

"J_ACNTPC.EXE" is the Jaws version for the Accent internal
synthesizers from Aicom Corporation.  This includes the Accent PC,
Accent MC, Accent Mini, Accent SE, Accent 1200, Accent 1600, and
probably any other Accent synthesizer that is not external to the
computer.  You must have the Accent device driver loaded first.

"J_ACNTSA.EXE" is the Jaws version for the Accent SA, the stand-
alone external version of the Accent.

"J_AUDAPT.EXE" is the Jaws version for the Audapter external
synthesizer from Personal Data Systems.

"J_BNS.EXE" is the Jaws version for the Braille 'n Speak from
Blazie Engineering.

"J_DECTLK.EXE" is the Jaws version for the DecTalk.  This includes
the original DecTalk (big box with speaker), the newer portable
DecTalk, the Kurzweil Personal Reader, and the internal DecTalk
circuit boards.

"J_ECHOXT.EXE" is the Jaws version for the Echo PC from Street
Electronics.  This is the external box that connects to the serial
port.

"J_ECHOPP" is the Jaws version for the Echo PC+ from Street
Electronics.  This is the internal circuit board, it requires
additional software.

"J_PROSE.EXE" is the Jaws version for the Prose 4000, Prose 2000,
and CallText synthesizers, the same boards used in the VERT Plus.

"J_PSS.EXE" is the version for the Personal speech System from
Votrax.

"J_SONIX.EXE" is the Jaws version for the Symphonix 200, 210, 215,
220, 225, and others from Artic Technology, and the VoTalker from
Votrax.

"J_SB.EXE" is the Jaws version for the Sounding Board from GW
Micro.

"J_VP.EXE" is the Jaws version for the VP synthesizer from Maryland
Computer Services, also made by Enabling Technologies.  It will
look for the VP connected to any one of the parallel ports.  See
additional information in its appendix.

We are constantly adding to this list of supported synthesizers,
the most current information is contained in the "READ.ME" file on
your Jaws disk.  For specific details refer to the appendix
concerning your particular synthesizer.

Command Line Parameters

Jaws supports several command line parameters.  These are special
codes or flags that are entered on the same line as the command to
run Jaws, therefore "command line" parameters.  They tell Jaws to
use a particular COM port, LPT port, keyboard layout, or other
important feature that will effect the way Jaws works.  for
example, if you have an Accent PC and you want to use LPT8 enter
the following at the DOS prompt to load Jaws:

J_ACNTPC LPT8

Remember the parameter follows the name of Jaws for your
synthesizer, more than one parameter can be used, they must all be
on the same line, and they must be separated by spaces or "/" or "-
".  Here is a summary of Jaws's command line parameters, an
explanation follows the summary:

/c color screen
/M monochrome screen
/e enhanced keyboard
/t Toshiba enhanced keyboard
/l Lock-out the timer interrupt 
/a ANSI.SYS compatibility
/com#:baudrate,parity,databits,stopbits
(The "#" is the number of the COM port, 1-4 are valid.  If a
parameter is left out it will default to the synthesizer's default
setting, but be sure to mark the spot with a comma.  A typical COM
port setting follows:)

/com2:9600,e,7,1

/lpt#
(Where "#" is the number of the lpt port, 1-8 are valid.)

Extended keyboard support: Use command line parameter "/e", it
makes the cursor cross and other keys on the 101-key keyboard
distinct from the numpad/cursor pad keys.  You can create
new/different macros with these keys, or just leave them alone in
their "natural" state.  If you define a macro it will show up as a
"home row" macro key, since it uses the home-row keyboard/macro
"state".  If you have a Toshiba you should use the "/t" command
line parameter.  This will give you the "extended" keys on the
toshiba.  It is the same as "/e" except the insert key is not
included.  

"/c" on the command line forces Jaws into color mode, "/m" forces
into monochrome mode.  Sometimes this is needed if Jaws cannot
recognize by itself that the machine has a color or monochrome
video board.

/l locks-out the timer interrupt.  We include this option for those
rare cases whereJaws and another program are fighting over this
interrupt.  If you have some unexplainable happenings try re-
loading Jaws with this command line parameter.

/a (ANDSI) is used to gain compatibility with some ANSI.SYS screen
drivers that cause Jaws to double-echo every character.  If you are
getting a double echo in DOS then try re-loading with this command
line parameter. 

Files on the Jaws Disk

Your distribution disk contains some of the following files:

"JAWS.JNF" is the Jaws name file, it has the owners name and
address, which gets displayed on the screen when you run Jaws.  If
Jaws cannot find this file it will assume it is a demo version and
give the appropriate "demo" message.  If you should have a "real"
Jaws and it claims it is a "demo" then you need to copy the
"Jaws.jnf" file into the jaws subdirectory (or whatever
subdirectory you are loading Jaws from) so Jaws can find it.

"J_FUNCT.TXT" is a text file that contains the names and numbers of
all the Jaws functions.  These functions are accessed through the
Macro editor (in the Jaws function window) or through the Jaws
menus.  Do not change or alter this file unless you know what you
are doing; keep a backup copy handy; be sure it is in the Jaws
subdirectory when you load Jaws.

"J_SYNTHNAME.BIN" is the menu file for the specific synthesizer you
are using.  For example, if you have the Accent PC version of Jaws,
which is named "J_ACNTPC.EXE" then the menu file will be named
"J_ACNTPC.BIN".  This is the binary version of the menu file.  It
must be in the Jaws subdirectory at load time.

"J_MREV.EXE" is the Jaws2 macro editor, known as Macro Revise.  It
is a separate executable file that can be run from DOS or loaded
through the Jaws macros menu.  It must be in the default (Jaws)
subdirectory at load time.

"J_FREV.EXE" is the Jaws2 Frame editor, known as Frame Revise.  It
is a separate executable file that can be run from DOS or loaded
through the Jaws Frame menu.  It must be in the default (Jaws)
subdirectory at load time.
 
"J_MDUP.EXE is the Jaws2 macro duplicator, known as Macro
Duplicate.  It is a separate executable file that can be run from
DOS or loaded through the Jaws macros menu.  It must be in the
default (Jaws) subdirectory at load time.

"J_MERASE.EXE" is Macro Erase, which erases the macro key that you
enter.  It is a separate executable file that can be run from DOS
or loaded through the Jaws macros menu.  It must be in the default
(Jaws) subdirectory at load time.

"J_MIDENT.EXE" is Macro Identify, which displays all the Keys that
are already defined as macros.  It is a separate executable file
that can be run from DOS or loaded through the Jaws macros menu. 
It must be in the default (Jaws) subdirectory at load time.

"J_AUTO.EXE" is the Auto-macro program, it asks for the frame to
"monitor", the macro key to perform, and a delay factor.  It is a
separate executable file that can be run from DOS or loaded through
the Jaws macros menu.  It must be in the default (Jaws)
subdirectory at load time.

"J_LOAD.EXE" is used to load Jaws config files from DOS, as in a
batch file.  If you want to load all the Word Perfect config files
(macros, frames, etc.) from a batch file just include the line:

"\jaws\j_load \jaws\wpj"

and it will get all the config files that have the name "wpj" and
a valid Jaws config file extension (JMF, JFF, JEF, JVF, JDF).

"NUMOFF.COM" is a simple utility program that turns off numlock. 
It is useful for those computers that insist on turning on numlock
at boot time.  Include the line "\jaws\numoff" in your autoexec
file (or other batch file) before loading Jaws.

"JAWS.JMF" is the default Jaws macro file.  It defines the keys to
be used when Jaws first boots up or loads.  It must be in the Jaws
subdirectory or default disk.

"JAWSDESK.JMF" is the Jaws macro file for desk top computers, that
have a numeric pad on the keyboard.  This may be the same as
"JAWS.JMF", or can be copied into a file named "JAWS.JMF" if you
want it to get loaded automatically at boot time.

"JAWSTOSH.JMF" is the default Jaws macro file for Toshiba lap top
computers.  They have a weird keyboard layout, therefore we have a
special key layout for the Jaws keys.  This may be the same as
"JAWS.JMF", or you can copy it into a file named "JAWS.JMF" if you
want it to get loaded automatically at boot time.

Files that start with "WP" are files for Word Perfect, such as
batch files, Jaws macro files, and Jaws frame files.  See "WPJ.MAN"
for more info, or the manual or tapes.

Files that end with "T" in the name are special files for the
Toshiba lap top computers, these would be batch files and Jaws
macro files.

Files that have "DESK" in the name are special files for desk top
computers (as opposed to lap tops).  These would most likely be
Jaws macro files for particular application programs.
