Chapter 3 - JAWS MENU SYSTEM


Introduction

The chapter entitled "The Speech Pad and Keyboard", or the Jaws
Training tape about the speech pad should be listened to before
proceeding with this chapter.

The Jaws menu system is designed to be user-friendly. The operator
can easily adjust the basic configuration of Jaws without having to
remember which key sequence performs what function.  By going
through the menu system, a user may adjust voice parameters such as
volume, rate, and pitch of speech; universal parameters such as
sensitivity to upper and lower case letters, and the way specific
words are pronounced; load a previously saved configuration; define
or revise window frames; or search the screen for a string of
characters or an enhancement.

After Jaws has been loaded into memory, the menu system will be
accessed by typing a "Hot Key", normally "Control-/" (holding down
the "Control" key and pressing the forward slash "/" key).  

An alternative "Hot Key" can be defined at any time by the user to
make it more convenient or to avoid conflict with the application
programs.

The video card or monitor should be in one of the "standard"
monochrome, CGA, EGA, or VGA modes, usually 80 columns or more by
25 lines or more.  If the monitor is in a graphic mode or a 40
column text mode, the menu system may not function properly.  When
using application programs which use these display modes, you
should not attempt to use the Jaws menu system.  If you have a
screen larger than 25 lines by 80 columns refer to "Larger Screens"
to see how to handle this.  

When the menu system is invoked, the menus will occupy the upper
four lines of the monitor screen and the PC Cursor will be
activated to control menu operations  (the Jaws Cursor can still be
turned on and used to read around the menu system and the rest  of
the screen).  When the menu system is exited, the original screen
contents and cursor state and position will be restored.  The menu
is enclosed in a double line border with the title of the current
menu located within the top border.  We will refer to this first
line as the title line. The side borders and bottom border are
solid double lines.  

The second line of the screen will contain the items to choose from
for the current menu.  We will refer to this line as the top or
first line of the menu.  Along this top line, one item will always
be highlighted.  The third line of the screen will contain a
general description of what you may do when the highlighted item is
selected. We will refer to this line as the bottom or second line
of the menu.

Selecting an Item

There are two ways to select an item.  You can move the highlight
bar to the desired option by using either Prior Character and  Next
Character (the Left Arrow and Right Arrow keys) or by using Prior
Word and Next Word and pressing either Enter or the Down Arrow
(Next Line) key.  Alternatively, you can simply type the letter
appearing in upper case (usually the first letter of the word) in
the name of the desired item (Jaws will inform you of the letter
appearing in upper case if you use Say Character (num pad 5).  One
of three things can happen when you select an item:  You will
"descend" to another menu, you will be asked to enter information
specific to a function, or you will cause Jaws to execute the
function you have selected.

Within the menu system, there are several keys of particular
interest:  

1.   Prior Character or Next Character (the left or right arrow
keys) will cause the highlight bar to move left or right across the
menu items.  As the highlight bar moves, the speech device will
speak the highlighted choice. Prior Word or Next Word keys act
similarly.  If the left most item is highlighted and the left arrow
key is pressed (or Prior Word), the highlight bar will
"wrap-around" to the right-most item.  Similarly, if the right-most
item is highlighted and you press the right arrow key (or Next
Word), the highlight bar will wrap around to the left-most item. 
JAWS will beep each time it wraps.  This wrapping occurs on most
menus, but not in the "get range" menus that display things like
volume or rate.

2.   The Say Line key (the Zero-8) will speak all the choices in
the current menu, just to give you a sense of what is there.

3.   The "X" key or the Up Arrow  key will cause a return to the
next higher menu, if one exists; or if you are in the main menu
(the highest level) an exit the menu system and a return to what
you were doing before you pressed the Hot Key. 

If you are being asked to provide information specific to a
function and decide not to perform the function, pressing Up arrow
will cause a return to the menu from which the function was called.

4.             The Enter key will select the currently highlighted item and
either bring you to a "lower" menu, bring you to a prompt
requesting further information, or begin to perform a function. 
The Down Arrow key will function similarly to the Enter key.

5.   Pressing Escape or "Z" or Page Up will usually cause you to
immediately leave the menu system and return to what you were doing
before you typed the Hot Key.  If you are being prompted for
information, you will immediately stop and return to the
application.  Any information entered prior to exiting will be
discarded.

Level Adjusting Menus

Level Adjusting Menus are frequently used to adjust volume, rate,
and pitch. In most respects, a Level Adjusting Menu functions vary
much like the standard menu described above.  Pressing Prior
Character or Next Character (the Left Arrow or Right Arrow keys),
or Prior Word and Next Word will cause the highlight bar to move
left or right, Up Arrow will take you up one level, Escape  will
exit the menus completely.  The differences from standard menus are
discussed in the paragraphs below.

The current setting of the level will be highlighted.  This will be
spoken when you enter this menu.  Move left to decrease or right to
increase, the number will be spoken.  Press Enter or Down Arrow to
select and exit, or Up Arrow to exit without selecting a new level. 
Or you can simply press the number you want and hit Enter.  

For example, selecting the option Volume from the Jaws Global Voice
Menu will bring up the Adjust Global Volume Menu.  Assume that Line
1 of the menu has numbers in the range of 1 to 10 displayed on it. 
If the volume is currently at level 5, the number 5 on line 1 will
be highlighted.  If you wish to decrease the volume but you're not
sure to what level, you can use Prior Word or Prior Character. 
Each time you press Prior Word, the volume will be decreased and
the speech device will speak the new level.  When the volume is
correct, you can press Enter or Down Arrow to select it and return
to the previous menu.

If you know beforehand that volume level 7 is the most comfortable
and the current level is 3, you can simply type the character 7 and
press Enter.  The volume will be set to level 7 and the speech
device will say "seven".

The Main Menu

When you type the Hot Key from DOS or from within an application
program, you will enter the Jaws menu system.  The first menu which
will appear is the Jaws Main Menu.  The speech device will respond
"Jaws Main Menu".  The choices offered by the Main Menu are:  

Voice        - Adjust all voice parameters.

Config Files - Load from disk or save to disk a configuration     
               file.

Frames       - Speak, activate, quiet, or revise a frame.

Macro        - Create, revise, duplicate, or erase a macro.

Enhance      - Find and speak screen enhancements or colors.

Search       - Search forward or backward on the screen for
              a string of characters.

Go to        - Go to a screen row or column.

Place Marker - Mark the cursor position on the screen.

Most of the main menu items will move you to a lower level menu. 
Search and Go to will ask for further information and then perform
their respective functions.

Selecting Voice will allow you to adjust the manner in which
characters and words are spoken.  Among other things, volume, rate,
and pitch  can be adjusted; multiple identical character filtering
can be adjusted or disabled; and Jaws' sensitivity to upper and
lower case letters can be enabled or disabled.

Selecting Config Files will allow you to save the existing
configuration of Jaws to a file for later recall or to load a
previously saved Jaws configuration.  See the chapter on Config
Files for more details.

Selecting Frames will allow you to speak, activate, quiet, revise
or Monitor a window frame.  See the chapter on Frames for details.

Selecting Macro will allow you to create or revise, duplicate,
erase, or identify a Jaws macro key definition.  You will be able
to customize the current Jaws configuration for easier use with
various application programs.  Refer to the "Macros" chapter.

Selecting Enhance will allow you to search for a screen enhancement
or color.  You will be able to repeat the most recent enhancement
search, search for an enhancement different from the current one,
or search for a specific enhancement.  Refer to the "Enhancements"
chapter
Selecting Search will allow you to search for a specific string of
characters on the screen.

Selecting Go to will allow you to move the Jaws Cursor to a
specific row and column location on the screen.

Place markers offer the choice of "Set" or "go to", to mark a spot
on the screen and return to it.

The Voice Menu

Selecting Voice from the Jaws Main Menu will bring you to the Jaws
Voice Menu, whose choices will allow you to control the behavior of
the speech device attached to your computer.  The choices offered
by the Voice menu are:

Global    - Adjust speech parameters for keyboard, screen, and
            speech pad.

Keyboard  - Adjust voice parameters for keyboard echo.

Screen    - Adjust voice parameters for screen echo.

Speech Pad - Adjust voice parameters for the speech pad.

Universal - Dictionary, numbers, symbols, pause, case, filter,
            etc.

Jaws cursor voice - Set the voice parameters to be used when the
Jaws cursor is active.

Extra - Extra voice characteristic controls specific to each
synthesizer, like intonation or abbreviations.

Each selection will bring you to a lower menu.

Selecting Keyboard, Screen, speech Pad, and Global will allow you
to adjust such things as whether or not characters or words from
that particular source will be spoken and the level at which the
volume, rate, and pitch for the speaking of those characters or
words will be set.

Selecting Universal will allow you to adjust the manner in which
words are spoken.  For example, Dictionary will allow you to adjust
the way the speech device pronounces certain words while Numbers
will allow you to specify whether you want numbers spoken as digits
(i.e. one two three) or as full numbers (one hundred twenty-three).

The Global Menu
Selecting Global from the Jaws Voice Menu will bring you to the
Jaws Global Menu, whose choices will allow you to adjust the speech
parameters for the keyboard, screen, and speech pad simultaneously. 
Additionally, the selections Keyboard, Screen, and speech Pad on
the Voice menu will allow you to adjust the speech parameters for
each of the three sources of speech independently of one another.
The Global Menu selection Volume, for example, will allow you to
increase or decrease the volume level for all three sources of
speech at once while the Keyboard Menu selection Volume will change
the volume level for only those characters typed at the keyboard. 

The Keyboard Menu

Selecting Keyboard from the Jaws Voice Menu will bring you to the
Jaws Keyboard Menu, whose choices will allow you to alter the way
characters typed at the keyboard are spoken by the speech device. 
These choices are:

Echo          - Characters, words, off.

Volume        - Adjust the volume level for keyboard echoing.

Rate          - Adjust the rate of speech for keyboard echoing.

Pitch         - Adjust the pitch for keyboard echoing.

Interruptable - Enable or disable interruptable speech for
                keyboard echoing.

Keyrepeat     - Turn automatic key repeat on or off.

Selecting any of the choices on this menu will bring you to another
menu; however, the choices Volume, Rate, and Pitch will bring you
to a special Level Adjusting menu which will allow you to adjust
the level of that particular speech attribute.  

Selecting Echo will bring you to a menu where you will be able to
specify whether you want keyboard input echoed as individual
characters, as entire words, or not echoed at all.  The current
setting will be highlighted.

Selecting Interruptable will bring you to a menu where you can
enable or disable the interruptability of keyboard input.  The
current setting will be highlighted.  For example, while typing
within a word processor you might want individual characters to be
echoed; but, for speed and easier typing you might enable
interruptable speech so that when you type a letter, any previous
letter being spoken will be interrupted by the new letter.

Selecting Keyrepeat will bring you to a menu where you can enable
or disable automatic key repeat.  The current setting will be
highlighted.  If Keyrepeat is on, holding down a key will cause
that character to automatically repeat after about one second.

The Screen Menu

Selecting Screen from the Jaws Voice Menu will bring you to the 
Jaws Screen Menu, whose choices will allow you to adjust voice
parameters for the echoing of characters to the screen.  The
choices offered by this menu are:

Echo   - Enable or disable screen echoing.

Volume - Adjust the volume for screen echoing.

Rate   - Adjust the rate of speech for screen echoing.

Pitch  - Adjust the pitch for screen echoing.

Selecting Echo will bring you to a menu which will allow you to
either enable or disable the echoing of characters being written to
the screen.  The current setting will be highlighted, either on or
off.  You can select "Toggle" to simply change from on to off or
vice versa, or definitely select on or off.

The selections Volume, Rate, and Pitch will bring you to Level
Adjusting menus which will allow you to adjust the level of that
particular speech attribute.  

The Speech Pad Menu

Selecting speech Pad from the Jaws Voice Menu will bring you to the
Jaws Speech Pad Menu, whose choices will allow you to adjust the
voice parameters for the speech pad.  The choices offered are:

Volume        - Adjust the volume level for the speech pad.

Rate          - Adjust the rate of speech for the speech pad.

Pitch         - Adjust the pitch for the speech pad. 

Interruptable - Enable or disable interruptable speech for the
                speech pad.

The selections Volume, Rate, and Pitch will bring you to Level
Adjusting menus which will allow you to change the level of that
particular speech attribute.  

Selecting Interruptable will bring you to a menu which will allow
you to either enable or disable interruptable speech for the speech
pad.  The current setting for interruptable speech for the speech
pad will be highlighted.  If interruptable speech is turned on,
speech pad commands will be interrupted whenever another key is
pressed or whenever another speech pad command is issued.  

The Speech Pad is used to read the screen, or more accurately read
the data that is visible on the screen.  When you are using the
speech pad to read this data then these Speech Pad voice parameters
or settings will take effect.  For more information on the speech
pad refer to the chapter on that subject.

The Universal Menu

Selecting Universal from the Jaws Voice Menu will allow you to
alter certain "universal" speech parameters which are described in
detail below.  The choices offered by the Jaws Universal Menu are:

Dictionary - Adjust the pronunciation of words.

Numbers    - Adjust the pronunciation of numbers.

Symbols    - Adjust the speaking of punctuation and special
             characters.

Pause      - Adjust the length of the pause between words or lines.

Case       - Enable or disable the sensing of upper and lower
             case letters.

Filter     - Limit the speaking of multiple identical characters.

Acronyms   - Spell acronyms that are all upper case.

All of the selections will bring you to other menus.


Selecting Numbers will allow you to specify whether numbers 
should be spoken as individual digits or as full numbers.  The
current setting will be highlighted.  For example, if numbers are
to be spoken as digits, the value 123 will be spoken as "one two
three".  On the other hand, if numbers are to be spoken as full
numbers, 123 will be spoken as "one hundred twenty three".

Selecting Pause will bring you to a special Level Adjusting menu
which will allow you to adjust the duration of the pause between
words.

Selecting Case will bring you to a menu which will allow you to
either enable or disable the sensing of upper and lower case
letters.  The current setting will be highlighted.  If case
sensitivity in spell mode is enabled, Jaws will differentiate
between upper and lower case letters by pausing and then speaking
upper case letters in a higher pitch.  If case sensitivity in full
speech mode is enabled then Jaws will say "cap" if the first letter
of the word is capitalized.  If the whole is capitalized Jaws will
say "cap cap".  If any other situation exists, such as the first
two letters capitalized, probably an error, Jaws will say "cap"
three times. 

The Dictionary Menu

Selecting Dictionary from the Jaws Universal Speech Menu will bring
you to the Jaws Dictionary Menu, whose choices will allow you to
turn on or off the speech translation dictionary.  If an entry for
a word is found in the dictionary, the revised pronunciation will
be sent to the speech device in place of the original word. For
example, without a dictionary entry, the word echo is often
pronounced "etch-o".  If the a dictionary entry has been created
for echo, the speech device will pronounce it using the stored
pronunciation (such as "ekko").  Typing Escape will return you to
the Jaws Universal Speech Menu.

Selecting oN will allow you to use the currently loaded dictionary
words.  Selecting ofF will disable dictionary translation, but the
words will remain in memory in case you want to turn them on again. 

Dictionary files can be saved on disk or loaded from disk using the
Config files menu.  They must be created or edited with an editor
or word processor, just be sure to "save" the file in ASCII text
format, also known as DOS text format.

If a word is being mispronounced by the speech device and the word
does not already exist in the dictionary, adding an entry for the 
word along with a revised pronunciation should correct the problem. 
The word or phrase you add to the dictionary must be preceded by a
delimiter character.  The same delimiter must separate the word or
phrase being entered from the substitution string, and the
substitution string must be followed by the same delimiter.  The
delimiter can be any character, the first character entered is
selected by Jaws to be the delimiter.  For example, to change
"goodbye" to "adios" enter anyone of the following examples:

.goodbye.adios.
;goodbye; adios ;
"goodbye"adios"

Remember that any character can be used as a delimiter, the first
one entered at the beginning of the line is the delimiter.  This
technique allows changing any character or string of characters
into any other character or string of characters, eliminating the
limitations posed by other dictionary systems.  the file must have
one "rule" per line, separated by carriage returns (press the enter
key).

If you want to put in a rule for a "graphic" or extended ASCII
character  you must use the decimal value, three digits preceded by
a "\" (back slash).  For example, a "left arrow" symbol has a
decimal value of 26, the rule would look like this:

.\026.left arrow.

The rule for the right arrow symbol would look like this:

.\027.right arrow.

A "enter" symbol uses three graphics characters, so a rule to speak
it properly would look like this:

.\017\196\217.enter.


THE SYMBOLS MENU

Selecting Symbols from the  Jaws Universal Speech Menu will bring
you to the Jaws Symbols Menu, whose choices will allow you to
specify whether you wish to have all, most, or only some symbols,
punctuation marks, and special characters verbalized.  The choices
offered by this menu are:

All  - Speak all symbols.

Most - Speak most symbols.

Some - Speak only some symbols.

None - Speak no symbols.

ofF - do not manipulate the symbols at all.

Selecting All will cause the speech device to speak every symbol,
punctuation mark, or special character as text is being read.  This
mode would be most useful when proof reading a document to check
punctuation and spelling.

Selecting Most will cause the speech device to speak all symbols
except for some common punctuation marks.  This mode would be most
useful when using a word processor or other program to read a
letter, manual, or other document.

Selecting Some will cause the speech device to speak only a few
punctuation or special symbols.

Selecting None will eliminate the speaking of punctuation and other
special characters.  JAWS will actually strip them out of the
output string.

Some synthesizers have their own choices for symbols and
punctuation.  In those cases we provide an "OFF" choice, so you can
skip the processing that JAWS does and just let the synthesizer
handle it.  The controls or options for the synthesizer will be
found in the "Extra" menu.  Naturally these vary according to
synthesizer, so we will not say much about them here.  Refer to the
appendix on your synthesizer or just take a "look" at them and try
a few settings to see what you like.  Remember, you must have the
"symbols" setting to "off" for best results, otherwise you will
have two different systems trying to affect the speaking of
symbols.  If your symbols are getting spoken twice it is probably
that you do not have "off" selected.

The Filter Menu

Selecting Filter from the Jaws Universal Speech Menu will bring you
to the Jaws Filter Menu, whose choices will allow you to adjust the
manner in which multiple identical characters will be spoken.  The
current setting will be highlighted.  The choices offered are 1
through 6 and "All" (say all the characters).

For example, when reading the table of contents of a manual,
periods are often used to help a reader match a section description
with the page number where that section begins.  A user would find
it annoying to hear the speech device say "period" fifty seven
times between the description and the page number when reading the
manual from disk.  To eliminate this problem, the user might tell
Jaws to filter multiple identical characters down to three
characters.  So now the speech device will speak the description,
say "period period period" and say the page number.

The String Search Menu

Selecting Search from the Jaws Main Menu will bring you to the Jaws
String Search Menu.  This is not a true menu in that it offers no
choices or selections - it simply asks you to enter the string you
wish to find and then asks you to specify a frame number and
options - such as the direction to search.

Line 1 of the menu will display the word "Find": Followed by the
last string searched for, should one exist.  Line 2 of the menu
will display the message "Enter the string to search for...". If
you press Enter at this point, the previous string (if any) will be
used as the default.  Typing Escape before you press Enter will
cause you to return to the Jaws Main Menu.

After entering a string, Jaws will ask you for "Options".   Options
can be either a frame number, the direction to search, or both. The
currently active frame number will be the default and the default
search direction will be from the cursor forward (toward the bottom
of the screen).  You can specify the frame to search by entering
the frame's number (selecting frame 0 will search the entire
screen). You can select a different direction or starting position
by specifying the letter T for Top of frame and forward, the letter
B for Bottom of frame and backward, or the letter C for Cursor
position and backward.  Either the frame number, the direction, or
both may be omitted to use the defaults.  However, if both are
specified, the frame number must appear first.  You can also use a
letter representing "use the frame the cursor is in": "J" means use
the frame the Jaws cursor is in, "P" means use the PC cursor, and
"A" means use the Active cursor, the one that is turned on.  Refer
to "Search Options" for more details.

After you have specified the string and any options, Jaws will
perform the search.  If the string has been found, the menu system
will be exited, the Jaws Cursor will be turned on and positioned at
the beginning of that string and the string will be spoken;
otherwise, Jaws will produce an error tone and exit the menu
system.

If you want to search for a "graphic" or extended ASCII character 
you must use the decimal value, three digits preceded by a "\"
(back slash).  For example, a "left arrow" symbol has a decimal
value of 26, therefore enter "\026" without the quote marks.  A
right arrow is "\027".  A "enter" symbol uses three graphics
characters, therefore "\017\196\217".


The Go To Menu

Selecting Go to from the Jaws Main Menu will bring you to the Jaws
Go To Menu. This is not a true menu in that it offers no true
choices or selections - it simply asks you to specify the position
you wish to go to.

Line 1 of the menu will say: "Enter the position to go to:" and
line 2 of the menu will say: "Enter the number of the row and
column you wish to go to."  At this point you may enter the number
of the row and/or column to which you wish to go.

The position can be entered in a variety of ways, and either the
row or the column may be omitted.  For example, to move to row 12,
column 40 you could enter any of the following:  r12c40, 12r40c,
40c12r, c40r12, r12 c40, r 12 c 40, etc.  The important point is
that the row number must be preceded or followed by the letter r
and the column number must be preceded or followed by the letter c. 
The row and column numbers also cannot be immediately next to each
other - they must be separated from one another by either a letter
or a space (R12 40C is acceptable, but r1240c is not).

The above paragraph describes moving to an absolute screen
position, but you can also move relative to the current cursor
position.  Precede the number with a "+" or "-" to move forward or
backward the specified number of rows or columns.

After you have specified the requested information, press Enter,
and the Jaws Cursor will be moved to the screen position indicated
and you will be returned to the application.

This "Go to" feature is very powerful when used in a macro.  It can
be used to read the titles/headings of columns or fields on
formatted screens, analogous to "looking" at the top of the column
or the end of the row to see the heading.

Place Markers

Place markers are used to mark or save the cursors'spot on the
screen in case you want to go back their.  To mark your spot select
"Set" from the Place Marker menu, then press a letter key to
"remember" that spot.  It also remembers which cursor you are
"setting" there, the Jaws cursor or the PC cursor.  Then to return
that cursor to that spot select "Go To" from the Place Marker menu
and press the letter key you are using to remember that spot.

If you had set the Jaws cursor there then it will be returned
there.  If you had set the PC cursor there then maybe it will be
returned there.  The PC cursor is subject to the will of the
application program, if the application is willing then Jaws will
move it there.  However the application may not be willing to move
the cursor  to that spot, then you will hear an error tone, and the
cursor will be as close as Jaws could get it.  Even though the PC
cursor was on that spot at one time, because that is where you set
it, the screen may have changed or you may be in another section of
the application.  Jaws makes note of the physical location on the
screen, usually 25 lines by 80 columns, and not the logical
location in a document.
