;JFW 3.0 Scripts for Real Player 5.0
;By Bryan Smart (Email: bsmart@pobox.com)
;
;Last modified 12/24/1997

include "hjconst.jsh"
include "Realplay.jsm"
include "Realplay.jsh"
		
;Modified to automagicly speak Real Player prompts
Function SayNonHighlightedText (handle whnd, string buffer)
var
string MyControlClass,
int MyControlID

let MyControlID = GetControlID(whnd)
let MyControlClass = GetWindowClass(whnd)

;Process nonhighlighted text in other echo modes
if ((GetScreenEcho() > 1)
   || (MyControlClass == wn36 )) then
	SayString(buffer)
EndIf
;Intercept text written to the status bar
if (MyControlID == RP_StatusBarID) then
;Process if it is a new status message only
if (buffer != PrevStatusMessage) then
SayString(buffer)
let PrevStatusMessage = buffer
endif
endif
EndFunction

Function AutoStartEvent ()
if not(RP_RunBefore) then
if (GetVerbosity() == 0) then
SayString(RP_msg3) ;extended message for beginners
else
SayString(RP_msg4) ;Press Insert+h for hotkey list
endif
let RP_RunBefore = true
endif
EndFunction

Script HotkeyHelp ()
SayString(RP_msg5) ;Here are some hotkeys
SayString(RP_msg6) ;f2=play
SayString(RP_msg7) ;f2/f3 rewind/fast forward
SayString(RP_msg8) ;f5=stop
SayString(RP_msg9) ;PgUp/PgDown previous/next clip
SayString(RP_msg10) ;f6 for zoom
SayString(RP_msg11) ;Control+1-Control+6 for destination presets
SayString(RP_msg12) ;Control+o to open
SayString(RP_msg13) ;Control+l to open by URL
SayString(RP_msg14) ;Control+t for current/total time
SayString(RP_msg15) ;Control+i for info display
SayString(RP_msg16) ;Control+p = prefs
EndScript

;Returns true if the control was activated, false if the control was disabled or not found.
int Function ActivateControl (int MyControlId, string MyControlName)
var
handle MyControlHandle

;Can not activate a control while a lockable control is active, so unlock that control on this call.
if (RP_LockedControl) then
LeftMouseButtonLock()
let RP_LockedControl = false
SayString(RP_msg17) ;Resuming playback
Pause()
SayClipTime(RP_SayTime_Current)
else
;If no controls are locked, activate the indicated control.
SayString(MyControlName)
SaveCursor()
;Find the control on the screen so that it can be activated.
if (MoveToControl(GetAppMainWindow(GetCurrentWindow()), MyControlID)) then
let MyControlHandle = GetCurrentWindow()
;Try to activate the control if it is not disabled.
if not(IsWindowDisabled(MyControlHandle)) then
;Handle special cases when controls are lockable.
if (MyControlId == RP_TransportRewindID)
|| (MyControlID == RP_TransportFastForwardID) then
if (GetVerbosity() == 0) then
SayString(RP_msg1) ;Extended message for beginners
else
SayString(RP_msg18) ;Press again to stop
endif
LeftMouseButtonLock()
let RP_LockedControl = true
else
;Activate the control.
LeftMouseButton()
endif
else
;Control is disabled
RestoreCursor()
if (GetVerbosity() == 0) then
SayString(RP_msg2) ;Extended message for beginners
else
SayString(RP_msg19) ;Command disabled
endif
return false
endif
else
;Could not find the control on the screen.
RestoreCursor()
SayString(RP_msg20) ;Command unavailable
return false
endif
RestoreCursor()
endif
return true
EndFunction

;Activate the controls on the transport.

Script PlayOrPause ()
ActivateControl(RP_TransportPlayOrStopID, "play")
EndScript

Script Stop ()
ActivateControl(RP_TransportStopID, "stop")
EndScript

Script Rewind ()
ActivateControl(RP_TransportRewindID, "rewind")
EndScript

Script FastForward ()
ActivateControl(RP_TransportFastForwardID, "fast forward")
EndScript

Script PreviousClip ()
JawsPageUp()
if IsPCCursor() then
	if (GetWindowTypeCode(GetCurrentWindow()) == WT_TABCONTROL ||
	   GetWindowTypeCode(GetCurrentWindow()) == WT_SLIDER) then
		SayWord()
		return
else
SayString(RP_msg21) ;Previous clip
endif
else
SayString(RP_msg32) ;Page up
endif
EndScript

Script NextClip ()
JawsPageDown()
if IsPCCursor() then
	if (GetWindowTypeCode(GetCurrentWindow()) == WT_TABCONTROL ||
	   GetWindowTypeCode(GetCurrentWindow()) == WT_SLIDER) then
		SayWord()
		return
else
SayString(RP_msg22) ;Next clip
endif
else
SayString(RP_msg33) ;Page down
endif
EndScript

Script Zoom ()
;Automagicly speak a prompt if the zoom menu can be activated.
if (ActivateControl(RP_TransportZoomID, "zoom")) then
SayString(RP_msg23) ;Select with arrows and press return{DownArrow}
endif
EndScript

;Activate destination buttons.

Script Destination1 ()
ActivateControl(RP_TransportDestination1ID, "destination 1")
EndScript

Script Destination2 ()
ActivateControl(RP_TransportDestination2ID, "destination 2")
EndScript

Script Destination3 ()
ActivateControl(RP_TransportDestination3ID, "destination 3")
EndScript

Script Destination4 ()
ActivateControl(RP_TransportDestination4ID, "destination 4")
EndScript

Script Destination5 ()
ActivateControl(RP_TransportDestination5ID, "destination 5")
EndScript

Script Destination6 ()
ActivateControl(RP_TransportDestination6ID, "destination 6")
EndScript

int Function SayInfo ()
var
handle Mainwhnd,
string Title,
string Author,
string Copyright

;Find the info region of the window.
let Mainwhnd = GetAppMainWindow(GetFocus())
SaveCursor()
JawsCursor()
RouteJawsToPC()
JawsPageUp()
if (FindString(Mainwhnd, "Title:", S_BOTTOM, S_UNRESTRICTED)) then
;Extract the important fields from the info region.
NextWord()
let Title = GetChunk()
FindString(Mainwhnd, "Author:", S_BOTTOM, S_UNRESTRICTED)
NextWord()
let Author = GetChunk()
FindString(Mainwhnd, "Copyright:", S_BOTTOM, S_UNRESTRICTED)
NextWord()
let Copyright = GetChunk()
else
;The region was not found.
RestoreCursor()
return false
endif
;Speak the info window's fields.
RestoreCursor()
if (GetVerbosity() == 0) then
SayString(RP_msg34) ;Extended message for beginners
else
SayString(RP_msg25) ;Clip info
endif
SayString(RP_msg26) ;Title
SayString(Title)
SayString(RP_msg27) ;Author
SayString(Author)
SayString(RP_msg28) ;Copyright
SayString(Copyright)
return true
EndFunction

;User routine to SayInfo
Script SayCurrentInfo ()
if not(SayInfo()) then
SayString(RP_msg24) ;Info not available
endif
EndScript

;Speak the current and total time from the time display region.
Void Function SayClipTime (int SayMode)
var
string Time1,
string Time2

;Find the time region.
SaveCursor()
JawsCursor()
RouteJawsToPC()
JawsPageUp()
if (FindString(GetAppMainWindow(GetCurrentWindow()), "/", S_BOTTOM, S_UNRESTRICTED)) then
;Extract the needed fields.
PriorWord()
let Time1 = GetWord()
NextWord()
NextWord()
let Time2 = GetWord()
else
;The time field could not be found.
RestoreCursor()
SayString(RP_msg29) ;Could not be found
return
endif
;Speak the information retrieved from the time region fields.
RestoreCursor()
if (GetVerbosity() == 0) then
SayString(RP_msg35) ;Extended message for beginners
else
SayString(RP_msg30) ;current time
endif
SayString(Time1)
if (SayMode == RP_SayTime_All) then
if (GetVerbosity() == 0) then
SayString(RP_msg36) ;Extended message for beginners
else
SayString(RP_msg31) ;of
endif
SayString(Time2)
endif
EndFunction

;User routine for SayClipTime
Script SayCurrentClipTime ()
SayClipTime(RP_SayTime_All)
EndScript
