; PROVOX VERSION 6.0, THE DOS DEVICE DRIVER
; BUILD THE .EXE FILE LIKE THIS:
; TASM PROVOX
; TLINK PROVOX
;
; Screen Review Program for speech access to DOS systems.
; Copyright (C) 1985 - 1997  KANSYS, Inc.
; This program is free software; you can redistribute it and/or 
; modify it under the terms of the GNU General Public License as 
; published by the Free Software Foundation; either version 2 of 
; the License, or (at your option) any later version.
; This program is distributed in the hope that it will be useful, 
; but WITHOUT ANY WARRANTY; without even the implied warranty of 
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU 
; General Public License for more details.
; You should have received a copy of the GNU General Public License 
; along with this program; if not, write to the Free Software 
; Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
; Author: Charles E. Hallenbeck, Ph.D.
; KanSys, Inc.
; 4301 Wimbledon Terr. #2B
; Lawrence, KS 66047
; Telephone: 913-843-0351
;
 PROVOX SEGMENT PARA
 ASSUME CS:PROVOX,DS:PROVOX,ES:PROVOX,SS:PROVOX
; DEFAULTS AND OTHER EQUATES
REVISION EQU SPC SHL 8 OR '6' ; CHANGE FIRST BYTE FIRST
F3DEF EQU 0 ; SAY NUMBERS
F4DEF EQU 0 ; SAY CAP
F5DEF EQU 2 ; PUNCTUATION
F6DEF EQU 0 ; SMART SCREEN
F7DEF EQU 1 ; KEYBOARD ECHO
F8DEF EQU 1 ; SCREEN ECHO
F9DEF EQU 2 ; SPEED
F10DEF EQU 2 ; VOLUME
F19DEF EQU 80 ; WARNING BELL COLUMN
F20DEF EQU 1 ; WATCHDOG THRESHOLD
SYSNUMBER EQU 239 ; FOR MULTIPLEX IDENTIFICATION
DEC_SYSNUMBER EQU 208
; EQUATES FOR STATES0
ENHANCED EQU 1 SHL 0
TSR_TYPE EQU 1 SHL 1
BUZZER EQU 1 SHL 2
WATCHDOG EQU 1 SHL 3
ROUTING EQU 1 SHL 4
OUTPUT_BUSY EQU 1 SHL 5
ANSI1FLAG EQU 1 SHL 6
ANSI2FLAG EQU 1 SHL 7
; EQUATES FOR STATES1
HOLDING EQU 1 SHL 0
JOINED EQU 1 SHL 1
CLOSED EQU 1 SHL 2
I8BUSY EQU 1 SHL 3
I9BUSY EQU 1 SHL 4
DEC_READY EQU 1 SHL 5
GRAPHICS EQU 1 SHL 6
CONTINUOUS EQU 1 SHL 7
PASSTHRU EQU 1 SHL 8
PH1FLAG EQU 1 SHL 9
PH2FLAG EQU 1 SHL 10
DIGIT2 EQU 1 SHL 11
SUPPRESS EQU 1 SHL 12
I16FLIP EQU 1 SHL 13 ; BACKSPACE TOGGLE
PORTOPEN EQU 1 SHL 14 ; OPENPORT ACTIVE
DATAFLOW EQU 1 SHL 15 ; HANDSHAKE ACTIVE
; EQUATES FOR STATES2
EMAIL1 EQU 1 SHL 0 ; ACTIVE
EMAIL2 EQU 1 SHL 1 ; DUMPING
EMAIL3 EQU 1 SHL 2 ; IGNORING
; EQUATES FOR STATES3
PASTING EQU 1 SHL 0 ; PASTING THE CLIPBOARD
ENDOFLINE EQU 1 SHL 1 ; CURSOR MOVED LEFT
; OTHER EQUATES
STDERR EQU 2
BSP EQU 8
TAB EQU 9
LF EQU 10
CR EQU 13
ESCP EQU 27
SILENCE EQU 30
SPC EQU 32
RO EQU 127
STACKSIZE EQU 256 ; BYTES
MAXLINES EQU 60
MAXVOXNUM EQU 10
SHELFSIZE EQU 80
CLIPSIZE EQU 512
BUFSIZE EQU MAXLINES*82 ; 80 BYTES + CR + LF PER LINE
; DATA REQUIRED FOR DEVICE DRIVER STRUCTURE
 DW -1, -1 ; LINK TO OTHER DEVICE DRIVERS
 DW 1 SHL 15 ; CHARACTER DEVICE
 DW OFFSET STRATEGY
 DW OFFSET ACTIVITY
 DB 8 DUP (SYSNUMBER)
; DATA AND CODE FOR DEVICE DRIVER SUPPORT
CONFIGDATA LABEL NEAR ; START OF CONFIG AREA
VOXNUMBER DW MAXVOXNUM SHL 1 ; ILLEGAL UNTIL INITIALIZED
VOXPORT DW 0 ; LPT#, COM#, TTS#
BOXDRIVE DB 'C' ; FOR "FILENAME"
PREFIX DB '/'
F9FLAG DB F9DEF
F10FLAG DB F10DEF
AUTOLOAD DB 0
STATES0 DB 0
BANK0NAME DB '>', 15 DUP (0) ; DOS PROMPT
BANK0SUB DB 8 DUP (0)
BANK0FLAG DB F3DEF, F4DEF, F5DEF, F6DEF, F7DEF, F8DEF, F19DEF, F20DEF
BANK0TABLE LABEL NEAR
 DB 0, 0, 1, 1, 80, MAXLINES ; SUBSCREEN #0
 DB 0, 0, 1, 1, 80, MAXLINES ; SUBSCREEN #1
 DB 0, 0, 1, 1, 80, MAXLINES ; SUBSCREEN #2
 DB 0, 0, 1, 1, 80, MAXLINES ; SUBSCREEN #3
 DB 0, 0, 1, 1, 80, MAXLINES ; SUBSCREEN #4
 DB 0, 0, 1, 1, 80, MAXLINES ; SUBSCREEN #5
 DB 0, 0, 1, 1, 80, MAXLINES ; SUBSCREEN #6
 DB 0, 0, 1, 1, 80, MAXLINES ; SUBSCREEN #7
 DB 0, 0, 1, 1, 80, MAXLINES ; SUBSCREEN #8
 DB 0, 0, 1, 1, 80, MAXLINES ; SUBSCREEN #9
BANK1NAME DB '>B', 14 DUP (0) ; BRIEF EDITOR
BANK1SUB DB '00', 6 DUP (0)
BANK1FLAG DB F3DEF, F4DEF, F5DEF, 2, F7DEF, F8DEF, F19DEF, F20DEF
BANK1TABLE LABEL NEAR
 DB 0, 0, 1, 25, 48, 25 ; SUBSCREEN #0
 DB 0, 0, 49, 25, 80, 25 ; SUBSCREEN #1
 DB 0, 0, 1, 25, 80, 25 ; SUBSCREEN #2
 DB 0, 0, 1, 1, 80, 25 ; SUBSCREEN #3
 DB 0, 0, 1, 1, 80, 25 ; SUBSCREEN #4
 DB 0, 0, 1, 1, 80, 25 ; SUBSCREEN #5
 DB 0, 0, 1, 1, 80, 25 ; SUBSCREEN #6
 DB 0, 0, 1, 1, 80, 25 ; SUBSCREEN #7
 DB 0, 0, 1, 1, 80, 25 ; SUBSCREEN #8
 DB 0, 0, 1, 1, 80, 25 ; SUBSCREEN #9
BANK2NAME DB '>WP', 13 DUP (0) ; WORDPERFECT
BANK2SUB DB '00', 6 DUP (0)
BANK2FLAG DB F3DEF, F4DEF, F5DEF, 2, F7DEF, F8DEF, F19DEF, F20DEF
BANK2TABLE LABEL NEAR
 DB 0, 0, 1, 25, 48, 25 ; SUBSCREEN #0
 DB 0, 0, 49, 25, 80, 25 ; SUBSCREEN #1
 DB 0, 0, 1, 25, 80, 25 ; SUBSCREEN #2
 DB 119, 112, 1, 1, 80, 14 ; SUBSCREEN #3
 DB 119, 7, 1, 15, 80, 23 ; SUBSCREEN #4
 DB 119, 112, 1, 5, 80, 23 ; SUBSCREEN #5
 DB 0, 0, 1, 24, 80, 25 ; SUBSCREEN #6
 DB 119, 112, 1, 1, 80, 24 ; SUBSCREEN #7
 DB 7, 0, 2, 3, 79, 24 ; SUBSCREEN #8
 DB 7, 0, 1, 1, 80, 25 ; SUBSCREEN #9
BANK3NAME DB '>FIRST', 10 DUP (0) ; FIRST CHOICE
BANK3SUB DB '00', 6 DUP (0)
BANK3FLAG DB F3DEF, F4DEF, F5DEF, 2, F7DEF, F8DEF, F19DEF, F20DEF
BANK3TABLE LABEL NEAR
 DB 8, 8, 1, 1, 80, 25 ; SUBSCREEN #0
 DB 0, 0, 1, 2, 80, 24 ; SUBSCREEN #1
 DB 0, 0, 1, 1, 80, 1 ; SUBSCREEN #2
 DB 0, 0, 49, 2, 80, 2 ; SUBSCREEN #3
 DB 0, 0, 1, 25, 80, 25 ; SUBSCREEN #4
 DB 119, 19, 1, 4, 80, 24 ; SUBSCREEN #5
 DB 0, 0, 1, 4, 80, 23 ; SUBSCREEN #6
 DB 0, 0, 1, 4, 80, 5 ; SUBSCREEN #7
 DB 0, 0, 1, 2, 45, 2 ; SUBSCREEN #8
 DB 255, 3, 1, 2, 80, 23 ; SUBSCREEN #9
BANK4NAME DB '>PROCOMM', 8 DUP (0) ; PROCOMM
BANK4SUB DB 2 DUP (0), '2', 5 DUP (0)
BANK4FLAG DB F3DEF, F4DEF, F5DEF, 2, F7DEF, F8DEF, F19DEF, F20DEF
BANK4TABLE LABEL NEAR
 DB 0, 0, 1, 25, 48, 25 ; SUBSCREEN #0
 DB 0, 0, 49, 25, 80, 25 ; SUBSCREEN #1
 DB 0, 0, 1, 25, 80, 25 ; SUBSCREEN #2
 DB 0, 0, 1, 1, 80, 25 ; SUBSCREEN #3
 DB 0, 0, 1, 1, 80, 25 ; SUBSCREEN #4
 DB 0, 0, 1, 1, 80, 25 ; SUBSCREEN #5
 DB 0, 0, 1, 1, 80, 25 ; SUBSCREEN #6
 DB 0, 0, 1, 1, 80, 25 ; SUBSCREEN #7
 DB 0, 0, 1, 1, 80, 25 ; SUBSCREEN #8
 DB 0, 0, 1, 1, 80, 25 ; SUBSCREEN #9
BANK5NAME DB '>WS', 13 DUP (0) ; WORDSTAR
BANK5SUB DB 8 DUP (0)
BANK5FLAG DB F3DEF, F4DEF, F5DEF, 2, F7DEF, F8DEF, F19DEF, F20DEF
BANK5TABLE LABEL NEAR
 DB 0, 0, 1, 1, 80, 25 ; SUBSCREEN #0
 DB 0, 0, 1, 1, 80, 25 ; SUBSCREEN #1
 DB 0, 0, 1, 1, 80, 25 ; SUBSCREEN #2
 DB 0, 0, 1, 1, 80, 25 ; SUBSCREEN #3
 DB 0, 0, 1, 1, 80, 25 ; SUBSCREEN #4
 DB 0, 0, 1, 1, 80, 25 ; SUBSCREEN #5
 DB 0, 0, 1, 1, 80, 25 ; SUBSCREEN #6
 DB 0, 0, 1, 1, 80, 25 ; SUBSCREEN #7
 DB 0, 0, 1, 1, 80, 25 ; SUBSCREEN #8
 DB 0, 0, 1, 1, 80, 25 ; SUBSCREEN #9
BANK6NAME DB '>HEXEDIT', 8 DUP (0) ; HEX EDITOR
BANK6SUB DB '00', 6 DUP (0)
BANK6FLAG DB F3DEF, F4DEF, F5DEF, 2, F7DEF, F8DEF, F19DEF, F20DEF
BANK6TABLE LABEL NEAR
 DB 0, 0, 1, 1, 80, 1 ; SUBSCREEN #0
 DB 0, 0, 1, 1, 80, 25 ; SUBSCREEN #1
 DB 0, 0, 1, 1, 80, 25 ; SUBSCREEN #2
 DB 0, 0, 1, 1, 80, 25 ; SUBSCREEN #3
 DB 0, 0, 1, 1, 80, 25 ; SUBSCREEN #4
 DB 0, 0, 1, 1, 80, 25 ; SUBSCREEN #5
 DB 0, 0, 1, 1, 80, 25 ; SUBSCREEN #6
 DB 0, 0, 1, 1, 80, 25 ; SUBSCREEN #7
 DB 0, 0, 1, 1, 80, 25 ; SUBSCREEN #8
 DB 0, 0, 1, 1, 80, 25 ; SUBSCREEN #9
BANK7NAME DB '>BOOKMGR', 8 DUP (0) ; BOOK MANAGER
BANK7SUB DB 8 DUP (0)
BANK7FLAG DB F3DEF, F4DEF, F5DEF, 2, F7DEF, F8DEF, F19DEF, F20DEF
BANK7TABLE LABEL NEAR
 DB 0, 0, 1, 1, 80, 25 ; SUBSCREEN #0
 DB 0, 0, 1, 1, 80, 25 ; SUBSCREEN #1
 DB 0, 0, 1, 1, 80, 25 ; SUBSCREEN #2
 DB 0, 0, 1, 1, 80, 25 ; SUBSCREEN #3
 DB 0, 0, 1, 1, 80, 25 ; SUBSCREEN #4
 DB 0, 0, 1, 1, 80, 25 ; SUBSCREEN #5
 DB 0, 0, 1, 1, 80, 25 ; SUBSCREEN #6
 DB 0, 0, 1, 1, 80, 25 ; SUBSCREEN #7
 DB 0, 0, 1, 1, 80, 25 ; SUBSCREEN #8
 DB 0, 0, 1, 1, 80, 25 ; SUBSCREEN #9
BANK8NAME DB '>NT', 13 DUP (0) ; NETTAMER
BANK8SUB DB 2 DUP (0), '2', 5 DUP (0)
BANK8FLAG DB F3DEF, F4DEF, F5DEF, 1, F7DEF, F8DEF, F19DEF, F20DEF
BANK8TABLE LABEL NEAR
 DB 0, 0, 1, 1, 80, 25 ; SUBSCREEN #0
 DB 0, 0, 1, 1, 80, 25 ; SUBSCREEN #1
 DB 0, 0, 1, 25, 80, 25 ; SUBSCREEN #2
 DB 0, 0, 1, 1, 80, 25 ; SUBSCREEN #3
 DB 0, 0, 1, 1, 80, 25 ; SUBSCREEN #4
 DB 0, 0, 1, 1, 80, 25 ; SUBSCREEN #5
 DB 0, 0, 1, 1, 80, 25 ; SUBSCREEN #6
 DB 0, 0, 1, 1, 80, 25 ; SUBSCREEN #7
 DB 0, 0, 1, 1, 80, 25 ; SUBSCREEN #8
 DB 0, 0, 1, 1, 80, 25 ; SUBSCREEN #9
BANK9NAME DB 16 DUP (0)
BANK9SUB DB 8 DUP (0)
BANK9FLAG DB F3DEF, F4DEF, F5DEF, F6DEF, F7DEF, F8DEF, F19DEF, F20DEF
BANK9TABLE LABEL NEAR
 DB 0, 0, 1, 1, 80, 25 ; SUBSCREEN #0
 DB 0, 0, 1, 1, 80, 25 ; SUBSCREEN #1
 DB 0, 0, 1, 1, 80, 25 ; SUBSCREEN #2
 DB 0, 0, 1, 1, 80, 25 ; SUBSCREEN #3
 DB 0, 0, 1, 1, 80, 25 ; SUBSCREEN #4
 DB 0, 0, 1, 1, 80, 25 ; SUBSCREEN #5
 DB 0, 0, 1, 1, 80, 25 ; SUBSCREEN #6
 DB 0, 0, 1, 1, 80, 25 ; SUBSCREEN #7
 DB 0, 0, 1, 1, 80, 25 ; SUBSCREEN #8
 DB 0, 0, 1, 1, 80, 25 ; SUBSCREEN #9
VOX1DATA DB '50/5M1/' ; DOUBLE TALK LT
VOX2DATA DB '0H/' ; PORTTALK
VOX3DATA DB '50/5M1/' ; DTPC
VOX4DATA DB 'F11/' ; AUDAPTER
VOX5DATA DB '7/' ; VOTRAX PSS
VOX7DATA DB '5/5/' ; ACCENT
VOX8DATA DB '0/' ; DECTALK PC
VOX9DATA DB '50/5M1/' ; LITETALK 
VOX10DATA DB '0H/' ; BRAILLE MATE
 DB SYSNUMBER ; FILLER FOR EVEN BYTE ALIGNMENT
CONFIGSIZE EQU $ - CONFIGDATA ; END OF CONFIGDATA
; STATES -- AVAILABLE BUT NOT OVERWRITTEN BY PV
STATES1 DW JOINED OR I8BUSY 
STATES2 DB 0 ; FOR EMAIL FILTER
STATES3 DB 0
; COMMON DATA AREA
AX_SAVE DW ? ; CALLER DATA
BX_SAVE DW ? ; CALLER DATA
LAST1IN DW 0 ; CHAR RECEIVED
LAST1OUT DB 0 ; CHAR SENT
LAST2OUT DB 0 ; CHAR SENT
LAST3OUT DB 0 ; CHAR SENT
LAST4OUT DB 0 ; CHAR SENT
LAST1MOVED DB 0 ; CHAR MOVED
LATER1 DB 0 ; FOR CURSOR TRACKING
LATER2 DB 0 ; HOW MANY TIMES TO TRY
LATER EQU LATER1 ; FOR TESTING BOTH AT ONCE
HL1TEST DB 0
OLD2LOX DB 0
DIGIT DB 0
CHARCOUNT DW 0
STUFCOUNT DW 0
CLIPCOUNT DW 0
BUFCOUNT DW 0
BUFHEAD DW OFFSET FREESPACE
BUFTAIL DW OFFSET FREESPACE
OLD_IRQ DD ? ; OLD IRQ VECTOR
COMBASE DW ? ; SET FROM OPENPORT_COM
INT_MASK DB ? ; SET FROM OPENPORT_COM
OLD_MASK DB ? ; PREVIOUS INTERRUPT MASK
; SHARED COMMANDS IN DIRECT AND REVIEW MODES
TABLE3 DB '.', 52 ; CURSOR POSITION
 DW RVW10
 DB '.', 83 ; CURSOR POSITION
 DW RVW10
 DB '+', 78 ; CURRENT LINE
 DW RVW08
 DB 'T', 20 ; TIME OF DAY
 DW I9TS32
 DB 'L', 38 ; CURSOR LINE
 DW RVW08
 DB '<', 51 ; LEFT PART
 DW GET1SCREEN
 DB '>', 52 ; RIGHT PART
 DW GET1SCREEN
 DB 'C', 46 ; CURRENT CHAR
 DW RVW11
 DB '-', 74 ; CURRENT WORD
 DW RVW16
 DB 'W', 17 ; CURRENT WORD
 DW RVW16
 DB '*', 9 ; CURRENT CHARACTER
 DW RVW19
 DB '*', 55 ; CURRENT CHARACTER
 DW RVW19
 DB 'S', 31 ; WHOLE SCREEN
 DW GET1SCREEN
 DB '-', 12 ; UPPER PART
 DW GET1SCREEN
 DB '+', 13 ; LOWER PART
 DW GET1SCREEN
 DB 'G', 34 ; GET INTO CLIPBOARD
 DW I9TS35
 DB 'K', 37 ; KILL THE CLIPBOARD
 DW I9TS36
 DB 0, 59 ; F1
 DW I9TS28
 DB 0, 60 ; F2
 DW I9TS29
 DB 0, 61 ; F3
 DW I9TS03
 DB 0, 62 ; F4
 DW I9TS04
 DB 0, 63 ; F5
 DW I9TS05
 DB 0, 65 ; F7
 DW I9TS07
 DB 0, 66 ; F8
 DW I9TS08
 DB 0, 67 ; F9
 DW I9TS09
 DB 0, 68 ; F10
 DW I9TS10
 DB 0, 75 ; LEFT ARROW
 DW RVW01
 DB 224, 75 ; LEFT ARROW
 DW RVW01
 DB 240, 76 ; CENTER KEY
 DW RVW11
 DB 0, 77 ; RIGHT ARROW
 DW RVW03
 DB 224, 77 ; RIGHT ARROW
 DW RVW03
 DB 0, 86 ; SHIFT F3
 DW I9PR77
 DB 0, 87 ; SHIFT F4
 DW I9PR78
 DB 0, 115 ; CTRL LEFT ARROW
 DW RVW13
 DB 224, 115 ; CTRL LEFT ARROW
 DW RVW13
 DB 0, 116 ; CTRL RIGHT ARROW
 DW RVW17
 DB 224, 116 ; CTRL RIGHT ARROW
 DW RVW17
 DW 0 ; END OF TABLE3
; COMMANDS IN DIRECT MODE ONLY
TABLE4 DB '/', 53 ; CHANGE PREFIX
 DW I9PR14
 DB '`', 41 ; CHANGE PREFIX
 DW I9PR14
 DB 'N', 49 ; NAME SCREEN BANK
 DW I9PR40
 DB 'P', 25 ; PASTE FROM CLIPBOARD
 DW I9PR93
 DB '=', 13 ; DEFINE A SUB SCREEN
 DW I9PR67
 DB 0, 64 ; F6
 DW I9PR85
 DB '?', 53 ; INTERROGATE
 DW I9PR86
 DB 0, 71 ; HOME -- READ TOP LINE
 DW I9PR45
 DB 224, 71 ; HOME -- READ TOP LINE
 DW I9PR45
 DB 0, 72 ; UP ARROW
 DW I9PR80
 DB 224, 72 ; UP ARROW
 DW I9PR81
 DB 0, 80 ; DOWN ARROW
 DW I9PR82
 DB 224, 80 ; DOWN ARROW
 DW I9PR83
 DB 0, 79 ; END -- READ BOTTOM LINE
 DW I9PR47
 DB 224, 79 ; END -- READ BOTTOM LINE
 DW I9PR47
 DB 9, 15 ; TAB RIGHT -- READ A BOX
 DW I9PR50
 DB 'B', 48 ; BACKGROUND ATTRIBUTES
 DW I9PR62
 DB 'E', 18 ; EMAIL FILTER
 DW I9PR91
 DB 'F', 33 ; FOREGROUND ATTRIBUTES
 DW I9PR62
 DB 'H', 35 ; HIGHLIGHTS
 DW I9PR05
 DB 'O', 24 ; OPENPORT
 DW I9PR88
 DB 0, 81 ; PAGE DOWN -- READ CONTINUOUS
 DW I9PR15
 DB 224, 81 ; PAGE DOWN -- READ CONTINUOUS
 DW I9PR15
 DB 0, 82 ; INS -- REPORT KEYSTROKE
 DW I9PR44
 DB 224, 82 ; INS -- REPORT KEYSTROKE
 DW I9PR44
 DB 13, 28 ; ENTER REVIEW
 DW I9PR07
 DB 13, 224 ; ENTER REVIEW
 DW I9PR07
 DB 0, 84 ; SHIFT F1
 DW I9PR39
 DB 0, 85 ; SHIFT F2
 DW I9PR20
 DB 0, 88 ; SHIFT F5
 DW I9PR33
 DB 0, 89 ; SHIFT F6
 DW I9PR35
 DB 0, 92 ; SHIFT F9
 DW I9PR28
 DB 0, 93 ; SHIFT F10
 DW I9PR31
 DW 0 ; END OF TABLE4
; COMMANDS IN REVIEW MODE ONLY
TABLE5 DB 10, 28 ; ROUTE CURSOR AND EXIT REVIEW
 DW I9PR10
 DB 13, 224 ; JOIN CURSORS
 DW I9DR09
 DB 'H', 35 ; HIGHLIGHTS
 DW I9PR05
 DB 0, 72 ; UP ARROW
 DW RVW05
 DB 224, 72 ; UP ARROW
 DW RVW05
 DB 0, 80 ; DOWN ARROW
 DW RVW06
 DB 224, 80 ; DOWN ARROW
 DW RVW06
 DB 0, 117 ; CTRL-END
 DW I9PR25
 DB 224, 117 ; CTRL-END
 DW I9PR25
 DB 0, 119 ; CTRL-HOME
 DW I9PR25
 DB 224, 119 ; CTRL-HOME
 DW I9PR25
 DB 0, 118 ; CTRL-PAGE DOWN
 DW I9PR27
 DB 224, 118 ; CTRL-PAGE DOWN
 DW I9PR27
 DB 0, 132 ; CTRL-PAGE UP
 DW I9PR27
 DB 224, 132 ; CTRL-PAGE UP
 DW I9PR27
 DB 13, 28 ; EXIT REVIEW
 DW I9PR11
 DB 27, 1 ; EXIT REVIEW
 DW I9PR11
 DB '/', 53 ; PREFIX CAPTURE
 DW I9PR03
 DB '`', 41 ; PREFIX CAPTURE
 DW I9PR03
 DB 0, 71 ; HOME
 DW RVW21
 DB 224, 71 ; HOME
 DW RVW21
 DB 0, 73 ; PAGE UP
 DW RVW23
 DB 224, 73 ; PAGE UP
 DW RVW23
 DB 0, 79 ; END
 DW RVW24
 DB 224, 79 ; END
 DW RVW24
 DB 0, 81 ; PAGE DOWN
 DW RVW26
 DB 224, 81 ; PAGE DOWN
 DW RVW26
 DB 0, 82 ; INSERT
 DW I9PR24
 DB 224, 82 ; INSERT
 DW I9PR24
 DB 0, 83 ; CURSOR POSITION
DW RVW10
 DB 224, 83 ; CURSOR POSITION
DW RVW10
 DW 0 ; END OF TABLE5
; ENHANCED MODE KEYPAD COMMANDS
TABLE6 DB 10, 224 ; CURSOR ROUTING
 DW I9DR07
 DB 13, 224 ; JOIN CURSORS
 DW I9DR09
 DB 0, 71 ; HOME
 DW RVW21
 DB 0, 72 ; UP
 DW RVW05
 DB 0, 73 ; PAGE UP
 DW RVW23
 DB 0, 75 ; LEFT
 DW RVW01
 DB 240, 76 ; CENTER KEY
 DW RVW11
 DB 0, 77 ; RIGHT
 DW RVW03
 DB 0, 79 ; END
 DW RVW24
 DB 0, 80 ; DOWN
 DW RVW06
 DB 0, 81 ; PAGE DOWN
 DW RVW26
 DB 0, 82 ; INSERT
 DW I9DR13
 DB 0, 83 ; CURSOR POSITION
 DW RVW10
 DB 0, 115 ; CTRL LEFT
 DW RVW13
 DB 0, 116 ; CTRL RIGHT
 DW RVW17
 DB 0, 117 ; CTRL-END
 DW I9DR11
 DB 0, 118 ; CTRL-PAGE DOWN
 DW I9DR14
 DB 0, 119 ; CTRL-HOME
 DW I9DR11
 DB 0, 132 ; CTRL-PAGE UP
 DW I9DR14
 DB '.', 83 ; CURSOR POSITION
 DW RVW10
 DB '/', 224 ; PASSTHROUGH
 DW I9DR10
 DB '*', 55 ; CURRENT CHARACTER
 DW RVW19
 DB '-', 74 ; CURRENT WORD
 DW RVW16
 DB '+', 78 ; CURRENT LINE
 DW RVW08
; CLASSIC MODE KEYPAD COMMANDS
TABLE7 DB '/', 53 ; PREFIX
 DW I9DR08
 DB '`', 41 ; PREFIX
 DW I9DR08
 DW 0 ; END OF TABLE6-TABLE7
; END OF JUMP TABLES
I8MODE DW 8 SHL 8
I8VIDSEG DW 0 ; SEGMENT OF VIDEO PAGE
I8VIDOFF DW 0 ; OFFSET OF VIDEO PAGE
I8LINE DB 24
I8WIDTH DB 80 ; LINE WIDTH
I8CURSOR DW 0 ; CURSOR LOCATION
CRT_MODE DW 8 SHL 8
CRT_VIDSEG DW 0 ; SEGMENT OF VIDEO PAGE
CRT_VIDOFF DW 0 ; OFFSET OF VIDEO PAGE
CRT_LINE DB 24
CRT_WIDTH DB 80 ; LINE WIDTH
CRT_CURSOR DW 0 ; CURSOR LOCATION
CORNER1 DW 0
CORNER2 DW 0
THISCURSOR DW 0 ; CURSOR LOCATION
LASTCURSOR DW 0 ; CURSOR LOCATION
I22SHELF DB 10 DUP (?)
BANKNAME DB 16 DUP (0) ; ACTIVE CONFIGURATION DATA
BANKSUB DB 8 DUP (0)
F3FLAG DB F3DEF
F4FLAG DB F4DEF
F5FLAG DB F5DEF
F6FLAG DB F6DEF
F7FLAG DB F7DEF
F8FLAG DB F8DEF
F19FLAG DB F19DEF
F20FLAG DB F20DEF
BANKTABLE LABEL NEAR
 DB 0, 0, 1, 1, 80, 25 ; SUBSCREEN #0
 DB 0, 0, 1, 1, 80, 25 ; SUBSCREEN #1
 DB 0, 0, 1, 1, 80, 25 ; SUBSCREEN #2
 DB 0, 0, 1, 1, 80, 25 ; SUBSCREEN #3
 DB 0, 0, 1, 1, 80, 25 ; SUBSCREEN #4
 DB 0, 0, 1, 1, 80, 25 ; SUBSCREEN #5
 DB 0, 0, 1, 1, 80, 25 ; SUBSCREEN #6
 DB 0, 0, 1, 1, 80, 25 ; SUBSCREEN #7
 DB 0, 0, 1, 1, 80, 25 ; SUBSCREEN #8
 DB 0, 0, 1, 1, 80, 25 ; SUBSCREEN #9
BANKSIZE EQU $-BANKNAME
PREPLIST DW VOX3PREP, VOX2PREP, VOX3PREP, VOX4PREP, VOX5PREP
 DW DUMMY, VOX7PREP, VOX8PREP, VOX3PREP, VOX10PREP
F3HOLD DB 4 ; ILLEGAL VALUE
F4HOLD DB 4 ; ILLEGAL VALUE
F9HOLD DB 4 ; ILLEGAL VALUE
F10HOLD DB 4 ; ILLEGAL VALUE
HOTSUB DB 2*6 DUP (?) ; SMART SCREEN
 DW ? ; CRC FOR SMART SCREEN
BOXES_THIS DB 9*4 DUP (?) ; X1Y1 X2Y2 FOR NINE BOXES
BG_THIS DW 4*3 DUP (?) ; MASKS, SUM, AND CRC
FG_THIS DW 4*3 DUP (?) ; MASKS, SUM, AND CRC
CRC_THIS DW ? ; FULL SCREEN CRC ON THIS TICK
NLZ1LENGTH EQU $ - OFFSET BOXES_THIS ; FOR CLEARING
BOXES_LAST DB 9*4 DUP (?) ; X1Y1 X2Y2 FOR NINE BOXES
BG_LAST DW 4*3 DUP (?) ; MASKS, SUM, AND CRC
FG_LAST DW 4*3 DUP (?) ; MASKS, SUM, AND CRC
CRC_LAST DW ? ; FULL SCREEN CRC ON LAST TICK
DEADSUB DB 2*6 DUP (?) ; SUBSCREEN WORK SPACE
TEMPSUB DB 6 DUP (?) ; SUBSCREEN WORK SPACE
INITIALIZE PROC NEAR
 CALL ASK2INIT
 MOV AL, BYTE PTR AUTOLOAD
 CALL BANKLOAD
 MOV BYTE PTR F9HOLD, 4
 AND WORD PTR STATES1, NOT I8BUSY
 RET
INITIALIZE ENDP
; DATA AND CODE FOR I5 -- PRINT SCREEN
I5SP DW ?
I5SS DW ?
I5ENTRY: PUSH DS
 PUSH CS
 POP DS
 CMP WORD PTR VOXNUMBER, MAXVOXNUM SHL 1 ; INITIALIZED?
 JE I5SKIP ; IF NOT
 CMP WORD PTR I9STATE, OFFSET I9ST2
 JE I5L1
I5SKIP: POP DS
I5RETURN DB 234 ; FAR JUMP
 DD ? ; ORIGINAL I5 VECTOR
I5L1: MOV WORD PTR I9STATE, OFFSET I9DIRECT
 AND BYTE PTR STATES0, NOT BUZZER
 PUSH AX
 MOV WORD PTR I5SS,SS
 MOV WORD PTR I5SP, SP
 MOV AX, CS
 CLI ; HOLD INTERRUPTS
 MOV SS, AX
 MOV SP, OFFSET INT5_STACK
 STI ; TAKE INTERRUPTS
 PUSH ES
 PUSH SI
 PUSH DI
 PUSH BX
 PUSH CX
 PUSH DX
 CALL COMPRESS
 JC I5DONE ; IF ERROR
 MOV BX, OFFSET I8MSG3
 CALL SENDSTRING
I5DONE: POP DX
 POP CX
 POP BX
 POP DI
 POP SI
 POP ES
 CLI ; HOLD INTERRUPTS
 MOV SS, WORD PTR I5SS
 MOV SP, WORD PTR I5SP
 POP AX
 POP DS
 IRET ; END OF I5 CODE
COMPRESS PROC NEAR
 MOV AX, 64
 MOV ES, AX
 TEST BYTE PTR ES:[23], 3 ; SHIFT?
 JZ CMPR05 ; IF NO
 MOV DX, OFFSET BINFILE
 MOV AX, 61 SHL 8 OR 2 ; open for read and write
 INT 33
 JC CMPR01 ; IF NO FILE
 MOV BX, AX ; HANDLE
 MOV AX, 66 SHL 8 OR 2 ; find end of file
 XOR CX, CX
 XOR DX, DX
 INT 33
 JMP SHORT CMPR02
CMPR01: MOV AX, 60 SHL 8 ; open new file
 XOR CX, CX
 INT 33
 JC CMPR04; if no file
 MOV BX, AX ; HANDLE
CMPR02: PUSH BX
 MOV AL, BYTE PTR ES:[132] ; LINES PER SCREEN
 INC AL
 CBW
 SHL AX, 1
 MOV BL, BYTE PTR ES:[74] ; LINE WIDTH
 MUL BL
 POP BX
 MOV CX, AX
 MOV DX, WORD PTR ES:[78] ; PAGE OFFSET
 MOV AX, 0B800H ; CGA VIDEO SEGMENT
 CMP BYTE PTR ES:[73], 4
 JB CMPR03
 MOV AX, 0B000H ; MODE 7 VIDEO SEGMENT
CMPR03: PUSH DS
 MOV DS, AX
 MOV AX, 64 SHL 8 ; write file
 INT 33
 POP DS
 JC CMPR04
 CMP AX, CX
 JNE CMPR04
 MOV AX, 62 SHL 8 ; close file
 INT 33
CMPR04: RET
CMPR05: MOV BH, BYTE PTR ES:[132] ; LINES PER SCREEN
 INC BH
 MOV BL, BYTE PTR ES:[74] ; LINE WIDTH
 PUSH BX
 MOV WORD PTR BUFCOUNT, 0
 CALL STOPVOX
 MOV SI, WORD PTR ES:[78] ; PAGE OFFSET
 MOV DI, OFFSET BUFFER
 MOV AL, BH
 CBW
 MUL BL
 MOV CX, AX
 POP DX
 MOV AX, 0B800H ; CGA VIDEO SEGMENT
 CMP BYTE PTR ES:[73], 4
 JB CMPR06
 MOV AX, 0B000H ; MODE 7 VIDEO SEGMENT
CMPR06: PUSH DS
 MOV DS, AX
 POP ES
 XOR BH, BH
CMPR07: CLD
 LODSW ; get video word
 CMP BL, BYTE PTR ES:I8WIDTH
 JB CMPR08
 INC BH
 XOR BL, BL
CMPR08: INC BL
 PUSH DS
 PUSH ES
 POP DS
 CMP BH, 1 ; top test
 JB CMPR09
 CMP BH, DH ; bottom test
 JA CMPR09
 CMP BL, 1 ; left test
 JB CMPR09
 CMP BL, DL ; right test
 JA CMPR09
 CLD
 STOSB
 INC WORD PTR BUFCOUNT
 CMP BL, DL ; last char?
 JB CMPR09
 MOV AX, 10 SHL 8 OR 13
 CLD
 STOSW
 ADD WORD PTR BUFCOUNT, 2
CMPR09: POP DS
 LOOP CMPR07
 PUSH ES
 POP DS
 MOV CX, WORD PTR BUFCOUNT ; drop trailing blanks
 JCXZ CMPR15
 MOV BX, CX
CMPR10: DEC BX
 MOV AL, BYTE PTR BUFFER[BX]
 CMP AL, SPC
 JNE CMPR11
 CMP BYTE PTR DIGIT, CR
 JNE CMPR12
 MOV BYTE PTR BUFFER[BX], 0
 JMP SHORT CMPR12
CMPR11: MOV BYTE PTR DIGIT, AL
CMPR12: LOOP CMPR10
 MOV CX, WORD PTR BUFCOUNT
 MOV WORD PTR BUFCOUNT, 0
 MOV SI, OFFSET BUFFER
 MOV DI, SI
CMPR13: CLD
 LODSB
 TEST AL, AL
 JZ CMPR14
 CLD
 STOSB
 INC WORD PTR BUFCOUNT
CMPR14: LOOP CMPR13
CMPR15: MOV DX, OFFSET FILENAME
 MOV AX, 61 SHL 8 OR 2 ; open for read and write
 INT 33
 JC CMPR16 ; NO FILE
 MOV BX, AX
 MOV AX, 66 SHL 8 OR 2 ; find end of file
 XOR CX, CX
 XOR DX, DX
 INT 33
 JMP SHORT CMPR17
CMPR16: MOV AX, 60 SHL 8 ; open new file
 XOR CX, CX
 INT 33
 JC CMPR19 ; if no file
 MOV BX, AX
CMPR17: MOV AX, 64 SHL 8 ; write file
 MOV CX, BUFCOUNT
 JCXZ CMPR18
 MOV DX, OFFSET BUFFER
 INT 33
 JC CMPR19
 CMP AX, CX
 JNE CMPR19
CMPR18: MOV AX, 62 SHL 8 ; close file
 INT 33
CMPR19: RET
FILENAME DB 'C:\PV000000.TXT', 0
BINFILE DB 'C:\PV000000.BIN', 0
COMPRESS ENDP
BANKLOAD PROC NEAR
 PUSH CS
 POP ES
 AND AX, 8 OR 4 OR 2 OR 1
 MOV CX, BANKSIZE
 MUL CL
 MOV SI, OFFSET BANK0NAME
 ADD SI, AX
 MOV DI, OFFSET BANKNAME
 SHR CX, 1
 CLD
 REP MOVSW
 CALL SET1ALERT
 CALL SET1IGNORE
 MOV BX, OFFSET BANKNAME
 MOV BYTE PTR [BX+15], 0
 RET
BANKLOAD ENDP
EXITROUTE PROC NEAR
 MOV WORD PTR THISCURSOR, DX
 OR BYTE PTR STATES0, ROUTING
 MOV WORD PTR I8COUNT, 0
 MOV BX, OFFSET XRTM2
 JMP SENDSTRING
XRTM2 DB 'moving cursor', RO, 0
EXITROUTE ENDP
GET1SCREEN PROC NEAR
; AL CONTAINS < > S - + OR A DIGIT, DX=CURSOR
 CALL PREP4REGS
 JC GET1S5
 MOV AL, BYTE PTR I8WIDTH
 CMP AL, CL
 JLE GET1S4
 MOV AL, CL
GET1S4: CALL SCAN1LINE
 MOV DL, BYTE PTR TEMPSUB[2]
 DEC DL
 INC DH
 CMP DH, BYTE PTR TEMPSUB[5]
 JL GET1S4
 STC ; FOUND
 RET
GET1S5: MOV BX, OFFSET I8MSG5
SENDSTRING PROC NEAR
 MOV WORD PTR LATER, 0
 MOV AX, SILENCE
 PUSH AX
 TEST BX, BX
 JNZ SENDS2
 POP AX
 STC
 RET
SENDS1: MOV AL, BYTE PTR [BX] ; NEXT CHAR TO AL
 TEST AL, AL ; MESSAGE DONE?
 JZ SENDS3 ; IF YES
 PUSH AX
 INC BX
SENDS2: CALL SAVE3DATA
 POP AX
 JMP SHORT SENDS1
SENDS3: MOV AX, 1 SHL 7 OR SILENCE
 JMP SAVE1DATA
SENDSTRING ENDP
GET1SCREEN ENDP
PREP4REGS PROC NEAR
 MOV WORD PTR TEMPSUB, 0 ; NO MASKS
 MOV BX, DX ; CURSOR
 MOV CX, DX
 INC CH
 INC CL
 INC DH
 MOV DL, 1 ; COLUMN #1
 CMP AL,'<' ; LEFT HALF?
 JE P4R3 ; IF SO
 MOV DL, CL
 MOV CL, BYTE PTR I8WIDTH
 CMP AL,'>' ; RIGHT HALF?
 JE P4R3 ; IF SO
 MOV DX, 1 SHL 8 + 1 ; TOP LEFT
 MOV CH, BYTE PTR I8LINE
 INC CH
 MOV CL, BYTE PTR I8WIDTH
 CMP AL, 'S' ; ENTIRE SCREEN?
JE P4R3 ; IF SO
 CMP AL,'-' ; TOP HALF?
 JE P4R1
 CMP AL,'+' ; BOTTOM HALF?
 JNE P4R2
 MOV DH, BH
 INC DH
 JMP SHORT P4R3
P4R1: MOV CH, BH
 INC CH
 JMP SHORT P4R3
P4R2: CALL SET4REGS ; IF DIGIT
 JC P4R4 ; IF ERROR
P4R3: MOV WORD PTR TEMPSUB+2, DX
 DEC DH
 DEC DL
 MOV WORD PTR TEMPSUB+4, CX
 CLC
P4R4: RET
PREP4REGS ENDP
; DATA AND CODE FOR I8 -- TIMER
I8SP DW ?
I8SS DW ?
I8COUNT DW 0
I8PACE DB 18
I8WAIT1 DB 1
I8WAIT2 DB 73 ; FOUR SECONDS
I8TONE DW 0
I8TICK DB 0
I8WDG DB 0
I8WARBLE DW 256+10, 256+12
I8FALL DW 256+10, 256+12, 0
I8RISE DW 256+12, 256+10, 256+8, 0
I8MID DW 256+10, 0
SHELFCOUNT DW 0
SHELF DB SHELFSIZE DUP (?)
SCANTERM DB 10 DUP (?)
DIGITS DB 6 DUP (?)
I8MSG1 DB 'not found', 0
I8MSG2 DB 'time out ', 0
I8MSG3 DB 'o k'
I8MSG4 DB RO, 0
I8MSG5 DB 'not defined', 0
I8MSG6 DB RO, 'screen bank', 0
I8MSG7 DB RO, 'sub screen to describe', 0
I8MSG8 DB RO, 'screen bank to describe', 0
I8MSG9 DB 'line', 0
I8MSG10 DB 'column', 0
I8MSG11 DB 'now', 0
I8MSG12 DB 'starting windows', 0
I8MSG13 DB 'closing windows', 0
I8ENTRY: PUSH DS ; USE THE CALLER STACK
 PUSH CS
 POP DS
 INC WORD PTR I8COUNT
 CALL SPEAKER
 CMP BYTE PTR I8WAIT1, 1 ; CHECK FOR 0 OR 1+
 JB I8INIT
 DEC BYTE PTR I8WAIT1
I8SKIP: POP DS
I8RETURN DB 234 ; FAR JUMP
 DD ? ; ORIGINAL I8 VECTOR
I8INIT: TEST WORD PTR STATES1, I8BUSY
 JNZ I8SKIP
 OR WORD PTR STATES1, I8BUSY
 PUSH AX
 MOV WORD PTR I8SS,SS
 MOV WORD PTR I8SP,SP
 MOV AX,CS
 CLI ; HOLD INTERRUPTS
 MOV SS, AX
 MOV SP, OFFSET INT8_STACK
 STI ; TAKE INTERRUPTS
 PUSHF
 CALL DWORD PTR I8RETURN+1
 PUSH ES
 PUSH BX
 PUSH CX
 PUSH DX
 PUSH SI
 PUSH DI
TEST WORD PTR STATES1, CLOSED OR GRAPHICS OR PORTOPEN
 JNZ I8SET1
 DEC BYTE PTR I8WAIT2
 CMP BYTE PTR I8WAIT2, 0
 JNE I8SET1
 CALL CONTEXT
I8SET1: TEST BYTE PTR STATES0, OUTPUT_BUSY
 JNZ I8SET2
MOV BX, WORD PTR VOXNUMBER
 CALL WORD PTR PREPLIST[BX]
I8SET2: TEST WORD PTR STATES1, PORTOPEN
 JZ I8SET3
 DEC BYTE PTR OPENPORT_WATCH
 CMP BYTE PTR OPENPORT_WATCH, 0
 JNE I8SET3
 MOV WORD PTR I8TONE, OFFSET I8RISE+4
I8SET3: MOV AX, 64 ; DOS SEGMENT
 MOV ES, AX
 MOV AL, BYTE PTR ES:[98] ; VIDEO PAGE
 SHL AX, 1
 MOV BX, 80 ; CURSOR LIST
 ADD BX, AX
 MOV DX, WORD PTR ES:[BX] ; CURSOR LOCATION
 MOV WORD PTR I8CURSOR, DX
 TEST WORD PTR STATES1, JOINED
 JZ I8SET4
 MOV WORD PTR THISCURSOR, DX
I8SET4: MOV CX, WORD PTR ES:[74] ; LINE WIDTH
 MOV BYTE PTR I8WIDTH, CL
 MOV BX, WORD PTR ES:[78] ; PAGE OFFSET
 MOV WORD PTR I8VIDOFF, BX
 MOV AL, BYTE PTR ES:[73] ; VIDEO MODE
 MOV BYTE PTR I8MODE, AL
 MOV AL, BYTE PTR ES:[132] ; MAX LINES-1
 CMP AL, 25
 JB I8SET5
 CMP AL, MAXLINES
 JB I8SET6
I8SET5: MOV AL, 24
I8SET6: MOV BYTE PTR I8LINE, AL
 OR WORD PTR STATES1, GRAPHICS
 MOV AX, 0B800H ; VIDEO SEGMENT FOR CGA
 CMP BYTE PTR ES:[73], 4
 JB I8SET7
 MOV AX, 0B000H ; VIDEO SEGMENT IF MODE 7
 CMP BYTE PTR ES:[73], 7
 JNE I8SET8
I8SET7: AND WORD PTR STATES1, NOT GRAPHICS
I8SET8: MOV WORD PTR I8VIDSEG, AX
 MOV ES, AX
 TEST WORD PTR STATES1, CLOSED OR GRAPHICS OR PORTOPEN
 JNZ I8SET12
 TEST WORD PTR I8COUNT, 1 ; SKIP EVERY OTHER TICK
 JNZ I8SET12
 MOV AX, WORD PTR LATER ; WAITING DATA
 CMP BYTE PTR F6FLAG, 1 ; SMART SCREEN?
 JA I8SET9 ; IF YES
 CMP AL, '?' ; LINE REQUEST WAITING?
 JE I8SET9
 CMP AL, 'A' ; ATTRIBUTES WAITING?
 JNB I8SET9 ; IF YES
 CALL ISDIGIT ; BOX REQUEST WAITING?
 JNC I8SET10 ; IF NOT
I8SET9: CALL ANALYZE
I8SET10: TEST AX, AX ; ANYTHING ELSE WAITING?
 JZ I8SET11 ; IF NOT
 CALL DEFERRED
I8SET11: CMP BYTE PTR F6FLAG, 2 ; SMART SCREEN?
 JB I8SET12 ; IF NOT
 CALL DYNAMICS
 CALL HOTSCREEN
I8SET12: MOV BX, WORD PTR BUFHEAD
 CMP BX, WORD PTR BUFTAIL
 JE I8EXIT ; IF NO DATA
I8GET1: TEST WORD PTR STATES1, HOLDING
 JNZ I8EXIT
 MOV AL, BYTE PTR [BX] ; NEXT CHAR TO AL
 INC BX
 CMP BX, OFFSET BUFFER+BUFSIZE
 JB I8GET2
 MOV BX, OFFSET BUFFER
I8GET2: MOV WORD PTR BUFHEAD, BX
 TEST AL, 1 SHL 7
 JNZ I8GET3
 CALL CALLSIGN
 CALL SET1CHAR
 JC I8GET4 ; DROP CHAR
 CALL FIND3REPEAT
 JC I8GET4 ; DROP CHAR
 CALL FIND6REPEAT
 JC I8GET4 ; DROP CHAR
I8GET3: PUSH AX
 CALL SEND1CHAR
 POP AX
I8GET4: MOV BX, WORD PTR LAST1OUT ; FETCH #1 AND #2
 MOV WORD PTR LAST2OUT, BX ; STORE IN #2 AND #3
 MOV BYTE PTR LAST1OUT, AL
 AND BYTE PTR LAST1OUT, NOT (1 SHL 7)
 MOV BX, WORD PTR BUFHEAD
 CMP BX, WORD PTR BUFTAIL
 JNE I8GET1 ; IF MORE DATA
 MOV WORD PTR BUFHEAD, OFFSET BUFFER
 MOV WORD PTR BUFTAIL, OFFSET BUFFER
 MOV AL, SILENCE
 CALL FIND3REPEAT
 CALL FIND6REPEAT
 MOV AL, 1 SHL 7 OR CR
 CALL SEND1CHAR
 MOV BX, WORD PTR LAST1OUT ; FETCH #1 AND #2
 MOV WORD PTR LAST2OUT, BX ; STORE IN #2 AND #3
 MOV BYTE PTR LAST1OUT, CR
I8EXIT: MOV AX, DS
 MOV ES, AX
 TEST BYTE PTR STATES0, OUTPUT_BUSY
 JNZ I8POST5
 MOV WORD PTR CHARCOUNT, 0
I8POST1: MOV CX, WORD PTR SHELFCOUNT
 JCXZ I8POST3
 MOV SI, OFFSET SHELF
 MOV DI, SI
 CLD
 LODSB
 CALL SEND_CHAR
 JC I8POST2 ; IF BUSY
 MOV CX, WORD PTR SHELFCOUNT
 JCXZ I8POST3
 DEC WORD PTR SHELFCOUNT
 INC WORD PTR CHARCOUNT
 CLD
 REP MOVSB
 JMP SHORT I8POST1
I8POST2: CMP WORD PTR SHELFCOUNT, 0
 JNE I8POST5
I8POST3: AND WORD PTR STATES1, NOT HOLDING
 MOV AX, WORD PTR CHARCOUNT
 CMP AX, SHELFSIZE SHR 1
 JB I8POST4
 MOV AX, SHELFSIZE SHR 1
I8POST4: SHR AX, 1
 AND AX, 12
 MOV BYTE PTR I8WAIT1, AL
 MOV WORD PTR CHARCOUNT, 0
I8POST5: TEST BYTE PTR STATES0, ROUTING
 JZ I8MOV6
 AND BYTE PTR STATES0, NOT ROUTING
 MOV AX, WORD PTR THISCURSOR
 MOV BX, WORD PTR I8CURSOR
 CMP AX, BX
 JE I8MOV6
 CMP WORD PTR I8COUNT, 144 ; 8 SECONDS
 JB I8MOV1
 MOV BX, OFFSET I8MSG2
 CALL SENDSTRING
 JMP SHORT I8MOV6
I8MOV1: XOR CL, CL
 OR BYTE PTR STATES0, WATCHDOG + ROUTING
 TEST WORD PTR I8COUNT, 1
 JNZ I8MOV3
 MOV CH, 80 ; DOWN
 CMP BH, AH
 JB I8MOV5
 JA I8MOV4
I8MOV3: MOV CH, 77 ; RIGHT
 CMP BL, AL
 JB I8MOV5
 JE I8MOV6
 MOV CH, 75 ; LEFT
 JMP SHORT I8MOV5
I8MOV4: MOV CH, 72 ; UP
I8MOV5: MOV AH, 5
 PUSHF
 CALL DWORD PTR I22RETURN+1
I8MOV6: TEST BYTE PTR STATES1, CONTINUOUS
 JZ I8MOV8 ; IF NOT
 CMP BYTE PTR I8PACE, 0
 JNE I8MOV7
 MOV AX, WORD PTR BUFHEAD
 XOR AX, WORD PTR BUFTAIL
 OR AX, WORD PTR SHELFCOUNT
 OR AX, WORD PTR CHARCOUNT
 OR AX, WORD PTR LATER
 TEST AX, AX ; WAIT FOR QUIET
 JNZ I8MOV8
 MOV BYTE PTR I8PACE, 20
 MOV CX, 80 SHL 8; DOWN
 MOV AX, 5 SHL 8 ; STUFF
 PUSHF
 CALL DWORD PTR I22RETURN+1
I8MOV7: DEC BYTE PTR I8PACE
I8MOV8: TEST BYTE PTR STATES3, PASTING
 JZ I8MOV10
 AND BYTE PTR STATES3, NOT PASTING
 MOV BX, WORD PTR STUFCOUNT
 CMP WORD PTR CLIPCOUNT, BX
 JNA I8MOV10
 OR BYTE PTR STATES3, PASTING
 MOV CL, BYTE PTR CLIPBOARD[BX]
 XOR CH, CH
 CMP CL, CR
 JNE I8MOV9
 MOV CH, 28
I8MOV9: INC WORD PTR STUFCOUNT
 MOV AX, 5 SHL 8 ; STUFF IT
 PUSHF
 CALL DWORD PTR I22RETURN+1
I8MOV10: POP DI
 POP SI
 POP DX
 POP CX
 POP BX
 POP ES
 CLI ; HOLD INTERRUPTS
 MOV SS, WORD PTR I8SS
 MOV SP, WORD PTR I8SP
 POP AX
 AND WORD PTR STATES1, NOT I8BUSY
 POP DS
 IRET ; END OF CODE FOR I8 -- TIMER
SPEAKER PROC NEAR
 CMP WORD PTR I8TONE, 0
 JE SPKR4
 CMP BYTE PTR I8TICK, 0
 JE SPKR1
 DEC BYTE PTR I8TICK
 RET
SPKR1: PUSH BX
 PUSH AX
 MOV BX, WORD PTR I8TONE
 CMP WORD PTR [BX], 0
 JNE SPKR2
 MOV WORD PTR I8TONE, 0
 IN AL, 97
 AND AL, NOT 3
 OUT 97, AL
 JMP SHORT SPKR3
SPKR2: ADD WORD PTR I8TONE, 2
 MOV AX, 182
 OUT 67, AL
 XOR AL, AL
 OUT 66, AL
 MOV AX, WORD PTR [BX]
 MOV BYTE PTR I8TICK, AH
 OUT 66, AL
 IN AL, 97
 OR AL, 3
 OUT 97, AL
SPKR3: POP AX
 POP BX
 RET
SPKR4: CMP WORD PTR I8COUNT, 10
 JA SPKR5
 PUSH AX ; TURN IT OFF
 IN AL, 97 ; SPEAKER OFF
 AND AL, NOT 3
 OUT 97, AL
 POP AX
 JMP SHORT SPKR6
SPKR5: TEST BYTE PTR STATES0, BUZZER
 JZ SPKR6
 PUSH AX ; TURN IT ON
 MOV AX, 182
 OUT 67, AL
 MOV AX, 16383 ; BUZZ PITCH
 OUT 66, AL
 XCHG AH, AL
 OUT 66, AL
 IN AL, 97 ; SPEAKER ON
 OR AL, 3
 OUT 97, AL
 MOV WORD PTR I8COUNT, 0
 POP AX
SPKR6: TEST BYTE PTR STATES0, WATCHDOG
 JNZ SPKR8
 CMP BYTE PTR I8WDG, 0
 JE SPKR7
 DEC BYTE PTR I8WDG
SPKR7: RET
SPKR8: PUSH AX
 MOV AL, BYTE PTR F20FLAG
 TEST AL, AL
 JZ SPKR9
 INC BYTE PTR I8WDG
 CMP BYTE PTR I8WDG, AL
 JB SPKR9
 DEC BYTE PTR I8WDG
 IN AL, 97
 OR AL, 1
 XOR AL, 3
 OUT 97, AL
SPKR9: AND BYTE PTR STATES0, NOT WATCHDOG
 POP AX
 RET
SPEAKER ENDP
VOX2PREP PROC NEAR
 MOV AL, BYTE PTR F3FLAG
 CMP BYTE PTR F3HOLD, AL
 JNE VOX2P1
 MOV AL, BYTE PTR F9FLAG
 CMP BYTE PTR F9HOLD, AL
 JNE VOX2P3
 MOV AL, BYTE PTR F10FLAG
 CMP BYTE PTR F10HOLD, AL
 JNE VOX2P5
 RET
VOX2P1: MOV BYTE PTR F3HOLD, AL
 MOV AH,'1' ; USE IF AL =0
 TEST AL, 1
 JZ VOX2P2
 MOV AH,'0' ; USE IF AL = 1
VOX2P2: MOV BYTE PTR VOX2PM[2], AH
 MOV AL,BYTE PTR F9FLAG
VOX2P3: MOV BYTE PTR F9HOLD, AL
 MOV AH, '6' ; USE IF AL IS 0
 ADD AH, AL ; OTHERWISE USE HIGHER VALUE
; ADD AH, AL
 MOV BYTE PTR VOX2PM[6], AH
VOX2P4: MOV AL, BYTE PTR F10FLAG
VOX2P5: MOV BYTE PTR F10HOLD, AL
 MOV AH,'2' ; USE IF AL=0
 ADD AH, AL
 ADD AH, AL
VOX2P6: MOV BYTE PTR VOX2PM[10], AH
 MOV BX, OFFSET VOX2PM
PUT2STRING PROC NEAR
 OR BYTE PTR STATES0, OUTPUT_BUSY
PUT2S1: MOV AL, BYTE PTR [BX] ; NEXT CHAR
 TEST AL, AL
 JZ PUT2S3
 INC BX
 PUSH BX
 MOV BX, WORD PTR VOXNUMBER
 MOV DX, WORD PTR VOXPORT
 CMP BX, 4 ; DOUBLETALK?
 JNE PUT2S2
 MOV AH, AL
 CALL DT2OUTPUT
 POP BX
 JMP SHORT PUT2S1
PUT2S2: CMP DX, 4 ; PARALLEL?
 JB PUT2S5
 AND DX, NOT (1 SHL 2)
 CMP DX, 4 ; SERIAL?
 JB PUT2S4
 POP BX
PUT2S3: AND BYTE PTR STATES0, NOT OUTPUT_BUSY
 STI ; TAKE INTERRUPTS
 RET
PUT2S4: MOV AH, 1 ; SERIAL WRITE
 INT 20
 POP BX
 JMP SHORT PUT2S1
PUT2S5: XOR AH, AH ; PARALLEL WRITE
 PUSHF
 CALL DWORD PTR I23PORT
 POP BX
 JMP SHORT PUT2S1
PUT2STRING ENDP
VOX2PM DB 5,'N1', SPC, 5,'R6', SPC, 5,'V7', SPC, 0
VOX2PREP ENDP
VOX3PREP PROC NEAR
 MOV AL, BYTE PTR F3FLAG
 CMP BYTE PTR F3HOLD, AL
 JNE VOX3P1
 MOV AL, BYTE PTR F9FLAG
 CMP BYTE PTR F9HOLD, AL
 JNE VOX3P3
 MOV AL, BYTE PTR F10FLAG
 CMP BYTE PTR F10HOLD, AL
 JNE VOX3P5
 RET
VOX3P1: MOV BYTE PTR F3HOLD, AL
 MOV AH,'2'
 TEST AL, AL
 JNZ VOX3P2
 MOV AH,'6'
VOX3P2: MOV BYTE PTR VOX3PM[7], AH
 MOV AL, BYTE PTR F9FLAG
VOX3P3: MOV BYTE PTR F9HOLD, AL
 MOV AH,'9'
 CMP AL, 3
 JE VOX3P4
 MOV AH,'7'
 CMP AL, 2
 JE VOX3P4
 MOV AH,'5'
 CMP AL, 1
 JE VOX3P4
 MOV AH, '3'
VOX3P4: MOV BYTE PTR VOX3PM[1], AH
 MOV AL, BYTE PTR F10FLAG
VOX3P5: MOV BYTE PTR F10HOLD, AL
 MOV AH,'5'
 CMP AL, 3
 JE VOX3P6
 MOV AH,'4'
 CMP AL, 2
 JE VOX3P6
 MOV AH,'2'
 CMP AL, 1
 JE VOX3P6
 MOV AH,'1'
VOX3P6: MOV BYTE PTR VOX3PM[4], AH
 MOV BX, OFFSET VOX3PM
 JMP PUT2STRING
VOX3PM DB 1, '7S', 1, '5V', 1, '6B', 0
VOX3PREP ENDP
VOX4PREP PROC NEAR
 MOV AL, BYTE PTR F9FLAG
 CMP BYTE PTR F9HOLD, AL
 JNE VOX4P3
 MOV AL, BYTE PTR F10FLAG
 CMP BYTE PTR F10HOLD, AL
 JNE VOX4P5
 RET
VOX4P3: MOV BYTE PTR F9HOLD, AL
 MOV BX,'66'
 CMP AL, 3
 JE VOX4P4
 MOV BX,'44'
 CMP AL, 2
 JE VOX4P4
 MOV BX,'22'
 CMP AL, 1
 JE VOX4P4
 MOV BX, '00'
VOX4P4: MOV WORD PTR VOX4PM[4], BX
 MOV AL, BYTE PTR F10FLAG
VOX4P5: MOV BYTE PTR F10HOLD, AL
 MOV BX,'41' ; BACKWORDS 14
 CMP AL, 3
 JE VOX4P6
 MOV BX,'11'
 CMP AL, 2
 JE VOX4P6
 MOV BX,'80' ; BACKWORDS 08
 CMP AL, 1
 JE VOX4P6
 MOV BX,'50' ; BACKWORDS 05
VOX4P6: MOV WORD PTR VOX4PM[8], BX
 MOV BX, OFFSET VOX4PM
 JMP PUT2STRING
VOX4PM DB 5,'[r-00]', 5,'11V', 0
VOX4PREP ENDP
VOX5PREP PROC NEAR
 MOV AL, BYTE PTR F9FLAG
 CMP BYTE PTR F9HOLD, AL
 JNE VOX5P3
 MOV AL, BYTE PTR F10FLAG
 CMP BYTE PTR F10HOLD, AL
 JNE VOX5P4
 RET
VOX5P3: MOV BYTE PTR F9HOLD, AL
 MOV AH,'5' ; USE IF AL IS 0
 SUB AH, AL ; OTHERWISE USE LOWER VALUE
 MOV BYTE PTR VOX5PM[7], AH
 MOV AL, BYTE PTR F10FLAG
VOX5P4: MOV BYTE PTR F10HOLD, AL
 MOV AH,'C' ; USE IF AL=3
 CMP AL, 3
 JE VOX5P5
 MOV AH,'A' ; USE IF AL=2
 CMP AL, 2
 JE VOX5P5
 MOV AH,'8' ; USE IF AL=1
 CMP AL, 1
 JE VOX5P5
 MOV AH,'6' ; USE IF AL=0
VOX5P5: MOV BYTE PTR VOX5PM[11], AH
 MOV BX, OFFSET VOX5PM
 JMP PUT2STRING
VOX5PM DB SPC, '@C1 @R3 @AC1', SPC, 0
VOX5PREP ENDP
VOX7PREP PROC NEAR
 MOV AL, BYTE PTR F9FLAG
 CMP BYTE PTR F9HOLD, AL
 JNE VOX7P2
 MOV AL, BYTE PTR F10FLAG
 CMP BYTE PTR F10HOLD, AL
 JNE VOX7P4
 RET
VOX7P2: MOV BYTE PTR F9HOLD, AL
 MOV AH,'3' ; USE IF AL IS 0
 TEST AL, AL
 JZ VOX7P3
 MOV AH,'7' ; USE IF AL IS 1
 CMP AL, 1
 JE VOX7P3
 MOV AH,'B' ; USE IF AL IS 2
 CMP AL, 2
 JE VOX7P3
 MOV AH,'F' ; USE IF AL IS 3
VOX7P3: MOV BYTE PTR VOX7PM[2], AH
 MOV AL, BYTE PTR F10FLAG
VOX7P4: MOV BYTE PTR F10HOLD, AL
 MOV AH,'9' ; USE IF AL=3
 CMP AL, 3
 JE VOX7P5
 MOV AH,'7' ; USE IF AL=2
 CMP AL, 2
 JE VOX7P5
 MOV AH,'5' ; USE IF AL=1
 CMP AL, 1
 JE VOX7P5
 MOV AH,'3' ; USE IF AL=0
VOX7P5: MOV BYTE PTR VOX7PM[5], AH
 MOV BX, OFFSET VOX7PM
 JMP PUT2STRING
VOX7PM DB ESCP,'R7', ESCP,'A9', ESCP,'N1', 0
VOX7PREP ENDP
VOX8PREP PROC NEAR
 MOV AL, BYTE PTR F9FLAG
 CMP BYTE PTR F9HOLD, AL
 JNE VOX8P2
 MOV AL, BYTE PTR F10FLAG
 CMP BYTE PTR F10HOLD, AL
 JNE VOX8P4
 RET
VOX8P2: MOV BYTE PTR F9HOLD, AL
 ADD AL, '1'
 CMP AL, '1'
 JB VOX8P3
 CMP AL, '4'
 JA VOX8P3
 MOV BYTE PTR VOX8PM[5], AL
VOX8P3: MOV AL, BYTE PTR F10FLAG
VOX8P4: MOV BYTE PTR F10HOLD, AL
 MOV BL, 30
 CMP AL, 3
 JE VOX8P5
 MOV BL, 12
 CMP AL, 2
 JE VOX8P5
 MOV BL, 5
 CMP AL, 1
 JE VOX8P5
 MOV BL, 2
VOX8P5: MOV AX, DEC_SYSNUMBER SHL 8 + 6 ; SET VOLUME
 INT 47
 MOV BX, OFFSET VOX8PM
PUT8STRING PROC NEAR
 PUSH DX
 OR BYTE PTR STATES0, OUTPUT_BUSY
PUT8S1: MOV AL, BYTE PTR [BX]
 TEST AL, AL
 JNZ PUT8S2
 AND BYTE PTR STATES0, NOT OUTPUT_BUSY
 POP DX
 RET
PUT8S2: PUSH BX
 PUSH AX
PUT8S3: MOV AX, DEC_SYSNUMBER SHL 8 + 3 ; DECTALK STATUS
 INT 47
 TEST DL, 1 SHL 4 ; CTS?
 JZ PUT8S3
 POP AX
 MOV AH, 1
 MOV DX, WORD PTR VOXPORT
 AND DX, NOT (1 SHL 2)
 INT 20
 POP BX
 INC BX
 JMP SHORT PUT8S1
PUT8STRING ENDP
VOX8PM DB '[:ra 200]', 0
VOX8PREP ENDP
VOX10PREP PROC NEAR
 MOV AL, BYTE PTR F3FLAG
 CMP BYTE PTR F3HOLD, AL
 JNE VOX10P1
 MOV AL, BYTE PTR F9FLAG
 CMP BYTE PTR F9HOLD, AL
 JNE VOX10P3
 MOV AL, BYTE PTR F10FLAG
 CMP BYTE PTR F10HOLD, AL
 JNE VOX10P5
 RET
VOX10P1: MOV BYTE PTR F3HOLD, AL
 MOV AH,'1' ; USE IF AL =0
 TEST AL, 1
 JZ VOX10P2
 MOV AH,'0' ; USE IF AL = 1
VOX10P2: MOV BYTE PTR VOX10PM[2], AH
 MOV AL,BYTE PTR F9FLAG
VOX10P3: MOV BYTE PTR F9HOLD, AL
 MOV AH,'3' ; USE IF AL IS 0
 ADD AH, AL ; OTHERWISE USE HIGHER VALUE
 ADD AH, AL
 MOV BYTE PTR VOX10PM[6], AH
VOX10P4: MOV AL, BYTE PTR F10FLAG
VOX10P5: MOV BYTE PTR F10HOLD, AL
 MOV AH,'2' ; USE IF AL=0
 ADD AH, AL
 ADD AH, AL
VOX10P6: MOV BYTE PTR VOX10PM[10], AH
 MOV BX, OFFSET VOX10PM
 JMP PUT2STRING
VOX10PM DB 5,'N1', SPC, 5,'R6', SPC, 5,'V7', SPC, 0
VOX10PREP ENDP
FIND3REPEAT PROC NEAR
 INC WORD PTR FIND3COUNT ; INC OR ZERO REPEAT COUNT
 CMP BYTE PTR LAST1OUT, AL
 JNE FIND3R1
 CMP AL, SPC
 JB FIND3R1
 CMP WORD PTR FIND3COUNT, 3
 JB FIND3R3
 STC ; DROP CHAR
 RET
FIND3R1: CMP WORD PTR FIND3COUNT, 3
 JNA FIND3R2
 MOV BX, WORD PTR FIND3COUNT
 CALL SEND1REPEAT
FIND3R2: MOV WORD PTR FIND3COUNT, 0
FIND3R3: CLC ; KEEP CHAR
 RET
FIND3COUNT DW 0 ; REPEAT COUNT
FIND3REPEAT ENDP
FIND6REPEAT PROC NEAR
 INC WORD PTR FIND6COUNT ; INC OR ZERO REPEAT COUNT
 MOV AH, BYTE PTR LAST1OUT ; AX = #1, #0
 CMP AH, AL ; #1=#0?
 JE FIND6R1
 MOV BX, WORD PTR LAST2OUT ; BX = #3, #2
 CMP AX, BX ; #3=#1, #2=#0?
 JNE FIND6R1
 CMP AL, SPC
 JB FIND6R1
 CMP WORD PTR FIND6COUNT, 4
 JB FIND6R3
 STC ; DROP CHAR
 RET
FIND6R1: MOV BX, WORD PTR FIND6COUNT
 CMP BX, 4
 JNA FIND6R2
 INC BX
 INC BX
 CALL SEND1REPEAT
FIND6R2: MOV WORD PTR FIND6COUNT, 0
FIND6R3: CLC ; KEEP CHAR
 RET
FIND6COUNT DW 0 ; REPEAT COUNT
FIND6REPEAT ENDP
SEND1REPEAT PROC NEAR
 PUSH AX
 PUSH BX
 MOV AL,'<' OR 1 SHL 7
 CALL SEND1CHAR
 POP AX
 MOV BL,'0'
 CMP AL, 10 ; ONE DIGIT?
 JB SD1R4 ; IF YES
 CMP AL, 100 ; TWO DIGITS?
 JB SD1R2 ; IF YES
SD1R1: INC BL
 SUB AL, 100
 CMP AL, 100
 JNB SD1R1
 PUSH AX
 MOV AL, BL
 CALL SEND1CHAR
 POP AX
 MOV BL,'0'
 CMP AL, 10
 JB SD1R3
SD1R2: INC BL
 SUB AL, 10
 CMP AL, 10
 JNB SD1R2
SD1R3: PUSH AX
 MOV AL, BL
 CALL SEND1CHAR
 POP AX
SD1R4: ADD AL, '0'
 CALL SEND1CHAR
 MOV AL,'>' OR 1 SHL 7
 CALL SEND1CHAR
 POP AX
 RET
SEND1REPEAT ENDP
CALLSIGN PROC NEAR
 CMP BYTE PTR SPELCOUNT, 1
 JB CLSN2
 JA CLSN1
 MOV BYTE PTR CAPCOUNT, 0
CLSN1: DEC BYTE PTR SPELCOUNT
 RET
CLSN2: MOV SI, AX
 INC BYTE PTR CAPCOUNT
 CALL ISALPHA
 JC CLSN3
 MOV BYTE PTR CAPCOUNT, 0
CLSN3: CMP BYTE PTR CAPCOUNT, 1
 JA CLSN4
 CALL HAMSIGN
 JNC CLSN4 ; IF NOT
 MOV BYTE PTR SPELCOUNT, AH
CLSN4: MOV AX, SI
 RET
CAPCOUNT DB 0
SPELCOUNT DB 0
CALLSIGN ENDP
HAMSIGN PROC NEAR
 CALL ISALPHA ; FIRST CHAR
 JNC HSGN4 ; IF NOT
 MOV AL, BYTE PTR [BX] ; SECOND CHAR
 CALL ISDIGIT
 JNC HSGN2 ; IF NOT
 MOV AL, BYTE PTR [BX+1] ; THIRD CHAR
 CALL ISALPHA
 JNC HSGN4 ; IF NOT
 MOV AL, BYTE PTR [BX+2] ; FOURTH CHAR
 CALL ISALPHA
 JNC HSGN4 ; IF NOT
 MOV AL, BYTE PTR [BX+3] ; FIFTH CHAR
 CALL ISALPHA
 JC HSGN1 ; IF YES
 CALL ISDIGIT
 JC HSGN4 ; IF YES
 MOV AH, 4
 STC ; 1 BY 2 CALL SIGN
 RET
HSGN1: MOV AL, BYTE PTR [BX+4] ; SIXTH CHAR
 CALL ISALPHA
 JC HSGN4 ; IF YES
 CALL ISDIGIT
 JC HSGN4 ; IF YES
 MOV AH, 5
 STC ; 1 BY 3 CALL SIGN
 RET
HSGN2: MOV AL, BYTE PTR [BX+1] ; THIRD CHAR
 CALL ISDIGIT
 JNC HSGN4 ; IF NOT
 MOV AL, BYTE PTR [BX+2] ; FOURTH CHAR
 CALL ISALPHA
 JNC HSGN4 ; IF NOT
 MOV AH, 4
 MOV AL, BYTE PTR [BX+3] ; FIFTH CHAR
 CALL ISALPHA
 JNC HSGN3 ; IF NOT
 INC AH
 MOV AL, BYTE PTR [BX+4] ; SIXTH CHAR
 CALL ISALPHA
 JNC HSGN3 ; IF NOT
 INC AH
 MOV AL, BYTE PTR [BX+5] ; SEVENTH CHAR
 CALL ISALPHA
 JC HSGN4 ; IF YES
HSGN3: CALL ISDIGIT
 JC HSGN4 ; IF YES
 STC ; 2 BY 1, 2 BY 2, 2 BY 3 CALL SIGN
 RET
HSGN4: CLC ; NOT CALL SIGN
 RET
HAMSIGN ENDP
TOUPPER PROC NEAR
 CALL ISLOWER
 JNC TPR1
 AND AL, NOT (1 SHL 5)
TPR1: RET
TOUPPER ENDP
ISALPHA PROC NEAR
 CALL ISUPPER
 JC ISLO1 ; YES
ISLOWER PROC NEAR
 CMP AL, 'A' OR (1 SHL 5)
 JB ISLO2
 CMP AL, 'Z' OR (1 SHL 5)
 JA ISLO2
ISLO1: STC ; YES
 RET
ISLO2: CLC ; NO
 RET
ISLOWER ENDP
ISALPHA ENDP
ISUPPER PROC NEAR
 CMP AL, 'A'
 JB ISU1
 CMP AL, 'Z'
 JA ISU1
 STC ; YES
 RET
ISU1: CLC ; NO
 RET
ISUPPER ENDP
SEND_CHAR PROC NEAR
 TEST BYTE PTR STATES0, OUTPUT_BUSY
 JZ S_C0
 STC ; BUSY
 RET
S_C0: AND AX, RO
 PUSH AX
 MOV BX, WORD PTR VOXNUMBER
 MOV DX, WORD PTR VOXPORT
 CMP BX, 4 ; DOUBLETALK?
 JE S_C5
 CMP DX, 4 ; PARALLEL?
 JB S_C3 ; IF YES
 AND DX, NOT (1 SHL 2)
 CMP DX, 4 ; SERIAL?
 JNB S_C9 ; IF NOT
 CMP BX, 14 ; DECTALK PC?
 JE S_C6
 MOV AX, 3 SHL 8 ; STATUS
 INT 20
 TEST AH, 1 ; DATA READY?
 JZ S_C4 ; IF NOT
 PUSH AX
 MOV AX, 2 SHL 8 ; SERIAL READ
 INT 20
 MOV BYTE PTR HANDSHAKE, AL
 POP AX
S_C4: CMP BYTE PTR HANDSHAKE, 19 ; X OFF?
 JE S_C9 ; IF SO
 TEST AL, 1 SHL 4 ; CTS?
 JZ S_C9 ; IF NOT
 POP AX
 MOV AH, 1 ; WRITE
 INT 20
 JMP SHORT S_C7
S_C3: POP AX
 PUSHF
 CALL DWORD PTR I23PORT
 JMP SHORT S_C7
S_C5: IN AL, DX ; DTPC STATUS
 TEST AL, 1 SHL 2 ; ALMOST EMPTY?
 JZ S_C9 ; IF NOT
 POP AX
 MOV AH, AL
 CALL DT2OUTPUT
 JMP SHORT S_C7
S_C6: TEST WORD PTR STATES1, DEC_READY
 JNZ S_C8
 MOV AX, DEC_SYSNUMBER SHL 8 OR 3 ; DECTALK STATUS
 PUSH DX
 INT 47
 TEST DL, 1 SHL 4 ; CTS?
 POP DX
 JZ S_C9 ; IF NOT
 POP AX
 MOV AH, 1 ; WRITE
 INT 20
S_C7: CLC ; CLEAR
 RET
S_C8: AND WORD PTR STATES1, NOT DEC_READY
 MOV AX, DEC_SYSNUMBER SHL 8 OR 22 ; RESUME
 INT 47
S_C9: ADD SP, 2
 STC ; BUSY
 RET
HANDSHAKE DB 0 ; X-ON X-OFF
SEND_CHAR ENDP
VOX1INIT PROC NEAR
 MOV AX, WORD PTR VOX1DATA
 CALL ISDIGIT
 JNC VOX1I1
 CMP AH, '0'
 JB VOX1I1
 CMP AH, '9'
 JA VOX1I1
 MOV WORD PTR VOX1MX[2], AX
VOX1I1: MOV AL, BYTE PTR VOX1DATA[3] ; F#
 CMP AL, '1'
 JB VOX1I2
 CMP AL, '9'
 JA VOX1I2
 MOV BYTE PTR VOX1MX[6], AL
VOX1I2: MOV AX, WORD PTR VOX1DATA[4] ; M/I, TONE
 CMP AH, '0'
 JB VOX1I3
 CMP AH, '1'
 JA VOX1I3
 MOV BYTE PTR VOX1MX[9], AH
VOX1I3: AND AL, NOT (1 SHL 5)
 CMP AL, 'I'
 JE VOX1I4
 CMP AL, 'M'
 jNE VOX1I5
VOX1I4: MOV BYTE PTR VOX1MX[12], AL
VOX1I5: MOV BX, OFFSET VOX1MX
 JMP PUT2STRING
VOX1INIT ENDP
VOX2INIT PROC NEAR
 MOV AX, WORD PTR VOX2DATA ; PITCH AND TONE
 CALL ISDIGIT
 JNC VOX2I1
 MOV BYTE PTR VOX2MX[2], AL
VOX2I1: AND AH, NOT 32
 CMP AH,'A' ; LETTER?
 JB VOX2I2
 CMP AH,'Z'
 JA VOX2I2
 MOV BYTE PTR VOX2MX[6], AH
VOX2I2: MOV BX, OFFSET VOX2MX
 JMP PUT2STRING
VOX2INIT ENDP
VOX3INIT PROC NEAR
 MOV AX, WORD PTR VOX3DATA
 CALL ISDIGIT
 JNC VOX3I1
 CMP AH, '0'
 JB VOX3I1
 CMP AH, '9'
 JA VOX3I1
 MOV WORD PTR VOX3MX[2], AX
VOX3I1: MOV AL, BYTE PTR VOX3DATA[3] ; F#
 CMP AL, '1'
 JB VOX3I2
 CMP AL, '9'
 JA VOX3I2
 MOV BYTE PTR VOX3MX[6], AL
VOX3I2: MOV AX, WORD PTR VOX3DATA[4] ; M/I, TONE
 CMP AH, '0'
 JB VOX3I3
 CMP AH, '1'
 JA VOX3I3
 MOV BYTE PTR VOX3MX[9], AH
VOX3I3: AND AL, NOT (1 SHL 5)
 CMP AL, 'I'
 JE VOX3I4
 CMP AL, 'M'
 JNE VOX3I5
VOX3I4: MOV BYTE PTR VOX3MX[12], AL
VOX3I5: MOV BX, OFFSET VOX3MX0
 JMP PUT2STRING
VOX3INIT ENDP
VOX4INIT PROC NEAR
 MOV AL, BYTE PTR VOX4DATA ; PITCH OR FLAT?
 CMP AL,'F' OR (1 SHL 5)
 JE VOX4I1
 CMP AL,'P' OR (1 SHL 5)
 JNE VOX4I2
VOX4I1: MOV BYTE PTR VOX4MX[8], AL
VOX4I2: MOV AX, WORD PTR VOX4DATA[1]
 CALL ISDIGIT
 JNC VOX4I4
 CMP AH,'0'
 JB VOX4I4
 CMP AH,'6'
 JB VOX4I3
 JA VOX4I4
 CMP AL,'4'
 JA VOX4I4
VOX4I3: MOV WORD PTR VOX4MX[6], AX
VOX4I4: MOV BX, OFFSET VOX4MX
 JMP PUT2STRING
VOX4INIT ENDP
VOX5INIT PROC NEAR
 MOV AL, BYTE PTR VOX5DATA ; INFLECTION
 CMP AL, '0'
 JB VOX5I1
 CMP AL, '7'
 JA VOX5I1
 MOV BYTE PTR VOX5PM[7], AL
VOX5I1: MOV BX, OFFSET VOX5MX
 JMP PUT2STRING
VOX5INIT ENDP
VOX7INIT PROC NEAR
 MOV AL, BYTE PTR VOX7DATA
 CALL ISDIGIT
 JNC VOX7I1
 MOV BYTE PTR VOX7MX2[2], AL
VOX7I1: MOV AL, BYTE PTR VOX7DATA[2]
 CALL ISDIGIT
 JNC VOX7I2
 MOV BYTE PTR VOX7MX2[5], AL
VOX7I2: MOV BX, OFFSET VOX7MX
 JMP PUT2STRING
VOX7INIT ENDP
VOX8INIT PROC NEAR
 MOV BX, OFFSET VOX8DATA
 MOV AL, BYTE PTR [BX]
 CALL ISDIGIT
 JC VOX8I1
 MOV AL, '0'
 MOV BYTE PTR [BX], AL
VOX8I1: AND AX, 15
 JMP SET1VOICE
VOX8INIT ENDP
VOX9INIT PROC NEAR
 MOV AX, WORD PTR VOX9DATA
 CALL ISDIGIT
 JNC VOX9I1
 CMP AH, '0'
 JB VOX9I1
 CMP AH, '9'
 JA VOX9I1
 MOV WORD PTR VOX9MX[2], AX
VOX9I1: MOV AL, BYTE PTR VOX9DATA[3] ; F#
 CMP AL, '1'
 JB VOX9I2
 CMP AL, '9'
 JA VOX9I2
 MOV BYTE PTR VOX9MX[6], AL
VOX9I2: MOV AX, WORD PTR VOX9DATA[4] ; M/I, TONE
 CMP AH, '0'
 JB VOX9I3
 CMP AH, '1'
 JA VOX9I3
 MOV BYTE PTR VOX9MX[9], AH
VOX9I3: AND AL, NOT (1 SHL 5)
 CMP AL, 'I'
 JE VOX9I4
 CMP AL, 'M'
 jNE VOX9I5
VOX9I4: MOV BYTE PTR VOX9MX[12], AL
VOX9I5: MOV BX, OFFSET VOX9MX0
 JMP PUT2STRING
VOX9INIT ENDP
VOX10INIT PROC NEAR
 MOV AX, WORD PTR VOX10DATA ; PITCH AND TONE
 CALL ISDIGIT
 JNC VOX10I1
 MOV BYTE PTR VOX10MX[2], AL
VOX10I1: AND AH, NOT (1 SHL 5)
 CMP AH,'A' ; LETTER?
 JB VOX10I2
 CMP AH,'Z'
 JA VOX10I2
 MOV BYTE PTR VOX10MX[6], AH
VOX10I2: MOV BX, OFFSET VOX10MX
 JMP PUT2STRING
VOX10INIT ENDP
VOX2HUSH PROC NEAR
 MOV BX, OFFSET VOX2HM
 JMP PUT2STRING
VOX2HM DB 24, 0 ; CTRL-X
VOX2HUSH ENDP
VOX3HUSH PROC NEAR
 MOV AH, 24 ; CARET X
 MOV DX, WORD PTR VOXPORT
DT2OUTPUT PROC NEAR
DT2O0: IN AL, DX
 TEST AL, 1 SHL 4
 JZ DT2O0 ; WAIT FOR BIT=1
 MOV AL, AH
 PUSHF
 CLI
 OUT DX, AL
DT2O1: IN AL, DX
 TEST AL, 1 SHL 4
 JNZ DT2O1 ; WAIT FOR BIT=0
 POPF
 RET
DT2OUTPUT ENDP
VOX3HUSH ENDP
VOX5HUSH PROC NEAR
 MOV BYTE PTR F3HOLD, 4
 MOV BX, OFFSET VOX5HM
 JMP PUT2STRING
VOX5HM DB 27, 'Q.', 0
VOX5HUSH ENDP
VOX7HUSH PROC NEAR
 MOV BX, OFFSET VOX7HM
 JMP PUT2STRING
VOX7HM DB 27, '=x', 0
VOX7HUSH ENDP
VOX8HUSH PROC NEAR
 TEST WORD PTR STATES1, DEC_READY
 JNZ VOX8H1
 OR WORD PTR STATES1, DEC_READY
 MOV AX, DEC_SYSNUMBER SHL 8 + 21 ; PAUSE
 INT 47
 MOV AX, DEC_SYSNUMBER SHL 8 + 23 ; FLUSH
 INT 47
VOX8H1: RET
VOX8HUSH ENDP
VOX1MENU PROC NEAR
 MOV BX, AX ; 0, 2, 4, ... 14
 JMP WORD PTR VOX1JL[BX]
VOX1M1: MOV WORD PTR VOX1MX[2],'05'
 MOV BYTE PTR VOX1MX[6],'5'
 MOV BYTE PTR VOX1MX[9],'1'
 MOV BYTE PTR VOX1MX[12],'M'
VOX1M1A: MOV BX, OFFSET VOX1MX
 CALL PUT2STRING
VOX1M0: CLC ; NOT THROUGH
 RET
VOX1M3: MOV BX, WORD PTR VOX1MX[2]
 CMP BX,'00' ; DO NOTHING IF MINIMUM
 JE VOX1M0
 DEC BH
 CMP BH,'0'-1
 JA VOX1M4A
 MOV BH,'9'
 DEC BL
 JMP SHORT VOX1M4A
VOX1M4: MOV BX, WORD PTR VOX1MX[2]
 CMP BX,'99' ; IGNORE IF MAXIMUM
 JE VOX1M0
 INC BH
 CMP BH,'9'+1
 JB VOX1M4A
 MOV BH,'0'
 INC BL
VOX1M4A: MOV WORD PTR VOX1MX[2], BX
 JMP SHORT VOX1M1A
VOX1M5: MOV AL, BYTE PTR VOX1MX[6]
 CMP AL, '0' ; IGNORE IF MINIMUM
 JE VOX1M0
 DEC AL
 JMP SHORT VOX1M6A
VOX1M6: MOV AL, BYTE PTR VOX1MX[6]
 CMP AL, '9' ; IGNORE IF MAXIMUM
 JE VOX1M6A
 INC AL
VOX1M6A: MOV BYTE PTR VOX1MX[6], AL
 JMP SHORT VOX1M1A
VOX1M10: MOV AX, WORD PTR VOX1MX[2]
 MOV WORD PTR VOX1DATA, AX
 MOV AL, BYTE PTR VOX1MX[6]
 MOV BYTE PTR VOX1DATA[3], AL
 MOV AH, BYTE PTR VOX1MX[9]
 MOV AL, BYTE PTR VOX1MX[12]
 MOV WORD PTR VOX1DATA[4], AX
 STC ; THROUGH
 RET
VOX1JL DW VOX1M0, VOX1M1, VOX1M0, VOX1M3, VOX1M4, VOX1M5, VOX1M6, VOX1M10
VOX1MX0 DB CR, 1, '@'
VOX1MX DB CR, 1, '50P', 1, '5F', 1, '1X', 1, 'I', 1, 'T', 0
VOX1MENU ENDP
VOX2MENU PROC NEAR
 MOV BX, AX ; 0, 2, 4, ... 14
 JMP WORD PTR VOX2JL[BX]
VOX2M1: MOV BYTE PTR VOX2MX[2],'0'
 MOV BYTE PTR VOX2MX[6], 'H'
VOX2M1A: MOV AL, BYTE PTR VOX2MX[2]
 MOV AH, BYTE PTR VOX2MX[6]
 MOV WORD PTR VOX2DATA, AX
 MOV BX, OFFSET VOX2MX
 CALL PUT2STRING
VOX2M0: CLC ; NOT THROUGH
 RET
VOX2M3: MOV AL, BYTE PTR VOX2MX[2] ; PITCH
 CMP AL,'0'
 JE VOX2M0
 DEC AL
 JMP SHORT VOX2M4A
VOX2M4: MOV AL, BYTE PTR VOX2MX[2] ; PITCH
 CMP AL,'9'
 JE VOX2M0
 INC AL
VOX2M4A: MOV BYTE PTR VOX2MX[2], AL
 JMP VOX2M1A
VOX2M5: MOV AL, BYTE PTR VOX2MX[6] ; TONE
 CMP AL,'A'
 JE VOX2M0
 DEC AL
 JMP SHORT VOX2M6A
VOX2M6: MOV AL, BYTE PTR VOX2MX[6] ; TONE?
 CMP AL,'Z'
 JE VOX2M0
 INC AL
VOX2M6A: MOV BYTE PTR VOX2MX[6], AL
 JMP SHORT VOX2M1A
VOX2M10: MOV AL, BYTE PTR VOX2MX[2]
 MOV AH, BYTE PTR VOX2MX[6]
 MOV WORD PTR VOX2DATA, AX
 STC ; THROUGH
 RET
VOX2JL DW VOX2M0, VOX2M1, VOX2M0, VOX2M3, VOX2M4, VOX2M5, VOX2M6, VOX2M10
VOX2MX DB 5, 'P6', SPC, 5, 'TH', SPC, 0
VOX2MENU ENDP
VOX3MENU PROC NEAR
 MOV BX, AX ; 0, 2, 4, ... 14
 JMP WORD PTR VOX3JL[BX]
VOX3M1: MOV WORD PTR VOX3MX[2],'05'
 MOV BYTE PTR VOX3MX[6],'5'
 MOV BYTE PTR VOX3MX[9],'1'
 MOV BYTE PTR VOX3MX[12],'M'
VOX3M1A: MOV BX, OFFSET VOX3MX
 CALL PUT2STRING
VOX3M0: CLC ; NOT THROUGH
 RET
VOX3M3: MOV BX, WORD PTR VOX3MX[2]
 CMP BX,'00' ; DO NOTHING IF MINIMUM
 JE VOX3M0
 DEC BH
 CMP BH,'0'-1
 JA VOX3M4A
 MOV BH,'9'
 DEC BL
 JMP VOX3M4A
VOX3M4: MOV BX, WORD PTR VOX3MX[2]
 CMP BX,'99' ; IGNORE IF MAXIMUM
 JE VOX3M0
 INC BH
 CMP BH,'9'+1
 JB VOX3M4A
 MOV BH,'0'
 INC BL
VOX3M4A: MOV WORD PTR VOX3MX[2], BX
 JMP VOX3M1A
VOX3M5: MOV AL, BYTE PTR VOX3MX[6]
 CMP AL, '0' ; IGNORE IF MINIMUM
 JE VOX3M0
 DEC AL
 JMP SHORT VOX3M6A
VOX3M6: MOV AL, BYTE PTR VOX3MX[6]
 CMP AL, '9' ; IGNORE IF mAXIMUM
 JE VOX3M0
 INC AL
VOX3M6A: MOV BYTE PTR VOX3MX[6], AL
 JMP SHORT VOX3M1A
VOX3M10: MOV AX, WORD PTR VOX3MX[2]
 MOV WORD PTR VOX3DATA, AX
 MOV AL, BYTE PTR VOX3MX[6]
 MOV BYTE PTR VOX3DATA[3], AL
 MOV AH, BYTE PTR VOX3MX[9]
 MOV AL, BYTE PTR VOX3MX[12]
 MOV WORD PTR VOX3DATA[4], AX
 STC ; THROUGH
 RET
VOX3JL DW VOX3M0, VOX3M1, VOX3M0, VOX3M3, VOX3M4, VOX3M5, VOX3M6, VOX3M10
VOX3MX0 DB CR, 1, '@'
VOX3MX DB CR, 1, '50P', 1, '5F', 1, '1X', 1, 'I', 1, 'T', 0
VOX3MENU ENDP
VOX4MENU PROC NEAR
 MOV BX, AX ; 0, 2, 4, ... 14
 JMP WORD PTR VOX4JL[BX]
VOX4M1: MOV WORD PTR VOX4MX[6],'11'
 MOV BYTE PTR VOX4MX[8],'F'+32
VOX4M1A: MOV BX, OFFSET VOX4MX
 CALL PUT2STRING
VOX4M0: CLC ; NOT THROUGH
 RET
VOX4M3: MOV BX, WORD PTR VOX4MX[6] ; PITCH
 CMP BX,'00' ; DO NOTHING IF MINIMUM
 JE VOX4M0
 DEC BH
 CMP BH,'0'-1
 JA VOX4M4A
 MOV BH,'9'
 DEC BL
 JMP VOX4M4A
VOX4M4: MOV BX, WORD PTR VOX4MX[6] ; PITCH
 CMP BX,'36' ; IGNORE IF MAXIMUM
 JE VOX4M0
 INC BH
 CMP BH,'9'+1
 JB VOX4M4A
 MOV BH,'0'
 INC BL
 CMP BX,'64'
 JE VOX4M0 ; DO NOTHING IF MAXIMUM
VOX4M4A: MOV WORD PTR VOX4MX[6], BX
 JMP SHORT VOX4M1A
VOX4M10: MOV AX, WORD PTR VOX4MX[6]
 MOV WORD PTR VOX4DATA[1], AX
 MOV AL, BYTE PTR VOX4MX[8]
 MOV BYTE PTR VOX4DATA, AL
 STC ; THROUGH
 RET
VOX4JL DW VOX4M0, VOX4M1, VOX4M0, VOX4M3, VOX4M4, VOX4M0, VOX4M0, VOX4M10
VOX4MX DB 5, '[AM]', 5, '11f', 0
VOX4MENU ENDP
VOX5MENU PROC NEAR
 MOV BX, AX ; 0, 2, 4, ... 14
 JMP WORD PTR VOX5JL[BX]
VOX5M1: MOV BYTE PTR VOX5MX[7],'7' ; INFLECTION
VOX5M1A: MOV AL, BYTE PTR VOX5MX[7]
 MOV BYTE PTR VOX5DATA, AL
 MOV BX, OFFSET VOx5MX
 CALL PUT2STRING
VOX5M0: CLC ; NOT THROUGH
 RET
VOX5M3: MOV AL, BYTE PTR VOX5MX[7]
 CMP AL,'4' ; MINIMUM?
 JE VOX5M0
 DEC AL
 JMP VOX5M4A
VOX5M4: MOV AL, BYTE PTR VOX5MX[7]
 CMP AL,'7' ; MAXIMUM?
 JE VOX5M0
 INC AL
VOX5M4A: MOV BYTE PTR VOX5MX[7], AL
 JMP SHORT VOX5M1A
VOX5M10: MOV AL, BYTE PTR VOX5MX[7]
 MOV BYTE PTR VOX5DATA, AL
 STC ; THROUGH
 RET
VOX5JL DW VOX5M0, VOX5M1, VOX5M0, VOX5M3, VOX5M4, VOX5M0, VOX5M0, VOX5M10
VOX5MX DB 27, 'M00. @7', SPC, 0
VOX5MENU ENDP
VOX7MENU PROC NEAR
 MOV BX, AX ; 0, 2, 4, ... 14
 JMP WORD PTR VOX7JL[BX]
VOX7M1: MOV BYTE PTR VOX7MX2[2],'5' ; STANDARD PITCH
 MOV BYTE PTR VOX7MX2[5],'5' ; STANDARD VOICE
VOX7M1A: MOV BX, OFFSET VOX7MX
 CALL PUT2STRING
VOX7M0: CLC ; NOT THROUGH
 RET
VOX7M3: CMP BYTE PTR VOX7MX2[2],'0' ; MINIMUM?
 JE VOX7M0
 DEC BYTE PTR VOX7MX2[2]
 JMP SHORT VOX7M1A
VOX7M4: CMP BYTE PTR VOX7MX2[2],'9' ; MAXIMUM?
 JE VOX7M0
 INC BYTE PTR VOX7MX2[2]
 JMP SHORT VOX7M1A
VOX7M5: CMP BYTE PTR VOX7MX2[5],'0' ; MINIMUM?
 JE VOX7M0
 DEC BYTE PTR VOX7MX2[5]
 JMP SHORT VOX7M1A
VOX7M6: CMP BYTE PTR VOX7MX2[5],'9'
 JE VOX7M0
 INC BYTE PTR VOX7MX2[5]
 JMP SHORT VOX7M1A
VOX7M10: MOV AL, BYTE PTR VOX7MX2[2]
 MOV BYTE PTR VOX7DATA, AL
 MOV AL, BYTE PTR VOX7MX2[5]
 MOV BYTE PTR VOX7DATA[2], AL
 STC ; THROUGH
 RET
VOX7JL DW VOX7M0, VOX7M1, VOX7M0, VOX7M3, VOX7M4, VOX7M5, VOX7M6, VOX7M10
VOX7MX DB ESCP,'=c', ESCP,'=A', ESCP,'=q', ESCP,'=F'
 DB ESCP,'=B', ESCP,'OT', ESCP,'OP', ESCP,'OM', ESCP,'Or'
VOX7MX2 DB ESCP,'P5', ESCP,'V5', ESCP,'N1', 0
VOX7MENU ENDP
VOX8MENU PROC NEAR
 MOV BX, AX ; 0, 2, 4, ... 14
 JMP WORD PTR VOX8JL[BX]
VOX8M1: XOR AX, AX
 JMP SHORT VOX8M3A
VOX8M3: CALL GET1VOICE
 INC AX
VOX8M3A: CALL SET1VOICE
 CALL GET1VOICE
 CALL SENDSTRING
VOX8M0: CLC ; NOT THROUGH
 RET
VOX8M10: CALL GET1VOICE
 ADD AL, '0'
 MOV BYTE PTR VOX8DATA, AL
 STC ; THROUGH
 RET
VOX8JL DW VOX8M0, VOX8M1, VOX8M0, VOX8M3, VOX8M0, VOX8M0, VOX8M0, VOX8M10
VOX8MX DB '[:say line][:np]', 0
VOX8MENU ENDP
VOX9MENU PROC NEAR
 MOV BX, AX ; 0, 2, 4, ... 14
 JMP WORD PTR VOX9JL[BX]
VOX9M1: MOV WORD PTR VOX9MX[2],'05'
 MOV BYTE PTR VOX9MX[6],'5'
 MOV BYTE PTR VOX9MX[9],'1'
 MOV BYTE PTR VOX9MX[12],'M'
VOX9M1A: MOV BX, OFFSET VOX9MX
 CALL PUT2STRING
VOX9M0: CLC ; NOT THROUGH
 RET
VOX9M3: MOV BX, WORD PTR VOX9MX[2]
 CMP BX,'00' ; DO NOTHING IF MINIMUM
 JE VOX9M0
 DEC BH
 CMP BH,'0'-1
 JA VOX9M4A
 MOV BH,'9'
 DEC BL
 JMP SHORT VOX9M4A
VOX9M4: MOV BX, WORD PTR VOX9MX[2]
 CMP BX,'99' ; IGNORE IF MAXIMUM
 JE VOX9M0
 INC BH
 CMP BH,'9'+1
 JB VOX9M4A
 MOV BH,'0'
 INC BL
VOX9M4A: MOV WORD PTR VOX9MX[2], BX
 JMP SHORT VOX9M1A
VOX9M5: MOV AL, BYTE PTR VOX9MX[6]
 CMP AL, '0' ; IGNORE IF MINIMUM
 JE VOX9M0
 DEC AL
 JMP SHORT VOX9M6A
VOX9M6: MOV AL, BYTE PTR VOX9MX[6]
 CMP AL, '9' ; IGNORE IF MAXIMUM
 JE VOX9M6A
 INC AL
VOX9M6A: MOV BYTE PTR VOX9MX[6], AL
 JMP SHORT VOX9M1A
VOX9M10: MOV AX, WORD PTR VOX9MX[2]
 MOV WORD PTR VOX9DATA, AX
 MOV AL, BYTE PTR VOX9MX[6]
 MOV BYTE PTR VOX9DATA[3], AL
 MOV AH, BYTE PTR VOX9MX[9]
 MOV AL, BYTE PTR VOX9MX[12]
 MOV WORD PTR VOX9DATA[4], AX
 STC ; THROUGH
 RET
VOX9JL DW VOX9M0, VOX9M1, VOX9M0, VOX9M3, VOX9M4, VOX9M5, VOX9M6, VOX9M10
VOX9MX0 DB CR, 1, '@'
VOX9MX DB CR, 1, '50P', 1, '5F', 1, '1X', 1, 'I', 1, 'T', 0
VOX9MENU ENDP
VOX10MENU PROC NEAR
 MOV BX, AX ; 0, 2, 4, ... 14
 JMP WORD PTR VOX10JL[BX]
VOX10M1: MOV BYTE PTR VOX10MX[2],'0'
 MOV BYTE PTR VOX10MX[6],'H'
VOX10M1A: MOV AL, BYTE PTR VOX10MX[2]
 MOV AH, BYTE PTR VOX10MX[6]
 MOV WORD PTR VOX10DATA, AX
 MOV BX, OFFSET VOX10MX
 CALL PUT2STRING
VOX10M0: CLC ; NOT THROUGH
 RET
VOX10M3: MOV AL, BYTE PTR VOX10MX[2] ; PITCH
 CMP AL,'0'
 JE VOX10M0
 DEC AL
 JMP SHORT VOX10M4A
VOX10M4: MOV AL, BYTE PTR VOX10MX[2] ; PITCH
 CMP AL,'9'
 JE VOX10M0
 INC AL
VOX10M4A: MOV BYTE PTR VOX10MX[2], AL
 JMP VOX10M1A
VOX10M5: MOV AL, BYTE PTR VOX10MX[6] ; TONE
 CMP AL,'A'
 JE VOX10M0
 DEC AL
 JMP SHORT VOX10M6A
VOX10M6: MOV AL, BYTE PTR VOX10MX[6] ; TONE?
 CMP AL,'Z'
 JE VOX10M0
 INC AL
VOX10M6A: MOV BYTE PTR VOX10MX[6], AL
 JMP VOX10M1A
VOX10M10: MOV AL, BYTE PTR VOX10MX[2]
 MOV AH, BYTE PTR VOX10MX[6]
 MOV WORD PTR VOX10DATA, AX
 STC ; THROUGH
 RET
VOX10JL DW VOX10M0, VOX10M1, VOX10M0, VOX10M3, VOX10M4, VOX10M5, VOX10M6
 DW VOX10M10
VOX10MX DB 5, 'P6', SPC, 5, 'TH', SPC, 0
VOX10MENU ENDP
SET1VOICE PROC NEAR
 CMP AX, 9
 JL SET1V1
 XOR AX, AX
SET1V1: SHL AX, 1
 MOV BX, AX
 MOV BX, WORD PTR DEC4LIST[BX]
 MOV AL, BYTE PTR [BX]
 MOV BYTE PTR VOX8MX[14], AL
 MOV BX, OFFSET VOX8MX
 JMP PUT8STRING
DEC4LIST DW DEC0NAME, DEC1NAME, DEC2NAME, DEC3NAME
 DW DEC4NAME, DEC5NAME, DEC6NAME, DEC7NAME, DEC8NAME
DEC0NAME DB 'perfect paul', 0
DEC1NAME DB 'huge harry', 0
DEC2NAME DB 'frail frank', 0
DEC3NAME DB 'doctor dennis', 0
DEC4NAME DB 'beautiful betty', 0
DEC5NAME DB 'uppity ursula', 0
DEC6NAME DB 'rough rita', 0
DEC7NAME DB 'whispering wendy', 0
DEC8NAME DB 'kit the kid', 0
SET1VOICE ENDP
GET1VOICE PROC NEAR
 MOV AL, BYTE PTR VOX8MX[14]
 XOR BX, BX
 MOV CX, 10
GET1V2: PUSH BX
 MOV BX, WORD PTR DEC4LIST[BX]
 MOV AH, BYTE PTR [BX]
 MOV DX, BX
 POP BX
 CMP AH, AL
 JE GET1V3
 INC BX
 INC BX
 LOOP GET1V2
GET1V3: MOV AX, BX
 SHR AX, 1
 MOV BX, DX
GET1V4: RET
GET1VOICE ENDP
SET1DIGIT PROC NEAR
 MOV WORD PTR [BX],'0+' ; BACK-WORDS ORDER
 CMP AL, 9
 JA SET1D1
 ADD BYTE PTR [BX+1], AL
 RET
SET1D1: CMP AL, 247
 JB SET1D3
 MOV BYTE PTR [BX],'-'
SET1D2: INC BYTE PTR [BX+1]
 INC AL
 TEST AL, AL
 JNZ SET1D2
SET1D3: RET
SET1DIGIT ENDP
SET3DIGITS PROC NEAR
 MOV WORD PTR [BX],'00'
 PUSH AX
 PUSH CX
 XOR AH, AH
 CMP AX, 10 ; ONE DIGIT?
 JL SET3D6 ; IF YES
 CMP AX, 100 ; TWO DIGITS?
 JL SET3D3 ; IF YES
 MOV CL,'0'
SET3D2: SUB AX, 100
 INC CL
 CMP AX, 100
 JGE SET3D2
 MOV BYTE PTR [BX], CL
SET3D3: MOV CL,'0'
SET3D4: CMP AX, 10
 JL SET3D5
 SUB AX, 10
 INC CL
 JMP SHORT SET3D4
SET3D5: MOV BYTE PTR [BX+1], CL
SET3D6: ADD AL,'0'
 MOV BYTE PTR [BX+2], AL
 POP CX
 POP AX
 RET
SET3DIGITS ENDP
SET1CHAR PROC NEAR
 CMP BYTE PTR SPELCOUNT, 0 ; SPELLING?
 JE SET1C2 ; IF NOT
 CMP AL, SPC
 JE SET1C3 ; IF SO
 PUSH AX ; INSERT SILENT SPACE IF ALPHA
 CALL ISALPHA
 JNC SET1C1
 MOV AL, SILENCE
 CALL SEND1CHAR
 POP AX
 JMP SHORT SET1C6
SET1C1: POP AX
SET1C2: CMP AL, SPC
 JNE SET1C6
 CMP BYTE PTR F5FLAG, 3 ; SAY ALL PUNCTUATION?
 JE SET1C6
 MOV AL, BYTE PTR LAST1OUT ; AFTER ALPHA?
 CALL ISALPHA
 JC SET1C4 ; IF SO
SET1C3: MOV AL, RO ; USE PAUSE
 JMP SHORT SET1C5
SET1C4: MOV AL, SILENCE
SET1C5: CMP BYTE PTR LAST1OUT, SILENCE
 JE SET1C7
 CMP BYTE PTR LAST1OUT, RO
 JE SET1C7
SET1C6: CLC ; KEEP CHAR
 RET
SET1C7: STC ; DROP CHAR
 RET
SET1CHAR ENDP
HOT1JMP DW HTSC3 ; SWITCHES TO HTSC4, 5, 6
HOTSCREEN PROC NEAR
 MOV BX, OFFSET HOTSUB
 CMP WORD PTR [BX+4], 0 ; IDLE?
 JNE HTSC2
 MOV WORD PTR HOT1JMP, OFFSET HTSC3
HTSC1: RET
HTSC2: CALL GET1CRC
 JMP WORD PTR HOT1JMP
HTSC3: CALL GET1CRC
 MOV WORD PTR [BX+12], DI
 MOV WORD PTR HOT1JMP, OFFSET HTSC4
 RET
HTSC4: CMP WORD PTR [BX+12], DI
 JE HTSC1 ; IF NO CHANGE
 MOV WORD PTR [BX+12], DI
 MOV WORD PTR HOT1JMP, OFFSET HTSC5
 RET
HTSC5: CMP WORD PTR [BX+12], DI
 JE HTSC6 ; IF NO CHANGE
 MOV WORD PTR [BX+12], DI
 RET
HTSC6: MOV WORD PTR HOT1JMP, OFFSET HTSC4
 ADD BX, 6
 JMP SAVE1SCREEN
HOTSCREEN ENDP
DEFERRED PROC NEAR
; AX=LATER, DX=CURSOR
 CMP AL, '@' ; ARROWS, BOXES, MESSAGES, OR ATTRIBUTES?
 JB DFRD05 ; IF ARROWS OR BOXES
 JA DFRD02 ; IF ATTRIBUTES
 RET
DFRD02: MOV SI, OFFSET BG_THIS ; ASSUME BACKGROUND
 MOV DI, OFFSET I8MSG5
 CMP AL, 'E' ; FOREGROUND?
 JB DFRD03 ; IF NOT
 SUB AL, 4 ; ASSUME FOREGROUND
 MOV SI, OFFSET FG_THIS
 MOV DI, OFFSET I8MSG5
DFRD03: DEC AL
 AND AX, 3 ; NOW IT IS 0, 1, 2, 3
 CALL TIMES6 ; BX = 6*AX
 MOV BX, WORD PTR [SI+BX] ; MASKS
 TEST BX, BX
 JZ DFRD04
 JMP SAVE2SCREEN
DFRD04: MOV BX, DI
 JMP SENDSTRING
DFRD05: CALL ISDIGIT ; BOXES?
 JNC DFRD07 ; IF NOT
 AND AX, 15 ; NOW IT IS 0-8
 SHL AX, 1
 SHL AX, 1
 MOV BX, AX
 MOV SI, WORD PTR BOXES_THIS[BX+0] ; UPPER LEFT CORNER
 TEST SI, SI
 JZ DFRD06
 MOV DI, WORD PTR BOXES_THIS[BX+2] ; LOWER RIGHT CORNER
 JMP SAVE1BOX
DFRD06: MOV BX, OFFSET I8MSG5
 JMP SENDSTRING
DFRD07: CMP WORD PTR LASTCURSOR, DX ; DID CURSOR MOVE?
 JNE DFRD09 ; IF SO
 TEST AH, AH ; TIME UP?
 JNZ DFRD08 ; IF NOT
 JMP WORD PTR POSTJUMP ; WHEN TIME IS UP
DFRD08: DEC BYTE PTR LATER2 ; COUNT DOWN
 CMP AL,'?' ; LINE?
 JNE DFRD12
 MOV BX, WORD PTR CRC_THIS
 CMP BX, WORD PTR CRC_LAST
 JE DFRD12 ; IF NO CHANGE
DFRD09: MOV BYTE PTR LATER2, 0 ; INSIST ON STABILITY
 CMP AL, '?' ; LINE?
 JNE DFRD10
 MOV WORD PTR POSTJUMP, OFFSET DFRD13 ; MUST BE LINE
 MOV WORD PTR LASTCURSOR, DX
 RET
DFRD10: MOV CX, WORD PTR LASTCURSOR
 MOV WORD PTR LASTCURSOR, DX
 MOV WORD PTR POSTJUMP, OFFSET DFRD14 ; MUST BE WORD
 CMP AL, ':' ; WORD?
 JE DFRD12
 INC CL
 CMP CL, DL
 JE DFRD11
 DEC CL
 DEC CL
 CMP CL, DL
 JNE DFRD12
DFRD11: MOV WORD PTR POSTJUMP, OFFSET DFRD15
DFRD12: RET
DFRD13: CALL GET2LINE
 JMP SHORT DFRD16
DFRD14: CALL GET0WORD
 JMP SHORT DFRD16
DFRD15: XOR AX, AX
 XCHG DH, AL
 SHL AX, 1
 SHL DX, 1
 ADD BX, DX
 MUL CL
 ADD BX, AX
 MOV AX, WORD PTR ES:[BX]
 CALL SAVE2DATA
DFRD16: MOV WORD PTR LATER, 0
 MOV WORD PTR POSTJUMP, OFFSET DFRD12
 RET
POSTJUMP DW DFRD12 ; SWITCHES TO DFRD13, DFRD14, DFRD15
DEFERRED ENDP
TELL1CHAR PROC NEAR
 PUSH AX
 CMP AL, RO ; ASCII GRAPHICS?
 JB TELL1C1 ; IF NOT
 MOV BX, OFFSET TELL1CM4
 CALL SENDSTRING
 POP AX
 PUSH AX
 CALL SAVE3DIGITS
 POP AX
 XOR AH, AH
 SUB AX, RO
 SHL AX, 1
 MOV BX, AX
 MOV BX, WORD PTR TLCL2[BX]
 JMP SENDSTRING
TELL1C1: CMP WORD PTR LAST1IN, 0 ; FROM KEYBOARD?
 JNE TELL1C2
 CMP AL, SPC ; CONTROL CHAR?
 JNB TELL1C4
 MOV BX, OFFSET TELL1CM4
 CALL SENDSTRING
 POP AX
 PUSH AX
 CALL SAVE3DIGITS
 POP AX
 CBW
 SHL AX, 1
 MOV BX, AX
 MOV BX, WORD PTR TLCL1[BX]
 JMP SENDSTRING
TELL1C2: MOV AH, AL ; TEST AH, KEEP AL
 MOV AL, 31
 CMP AH, CR
 JE TELL1C4 ; IF SO
 CMP AH, SPC ; CONTROL CHAR?
 JB TELL1C3 ; IF SO
 MOV AL, AH ; RESTORE CHAR
 JMP SHORT TELL1C4
TELL1C3: MOV AX, 1 SHL 7 + '^'
 CALL SAVE1DATA
 POP AX
 PUSH AX
 OR AL, 1 SHL 6
 CALL ISUPPER
 JNC TELL1C4
 OR AL, 1 SHL 5
TELL1C4:
 TEST WORD PTR STATES1, PH2FLAG
 JZ TELL1C5
 AND WORD PTR STATES1, NOT (PH1FLAG OR PH2FLAG)
 CALL ISALPHA
 JNC TELL1C5
 OR AL, 1 SHL 5
 AND AX, RO
 SUB AX,'A' OR (1 SHL 5)
 SHL AX, 1
 MOV BX, AX
 MOV BX, WORD PTR TELL1LIST[BX]
 CALL SENDSTRING
 POP AX
 RET
TELL1C5: OR AL, 1 SHL 7
 TEST WORD PTR STATES1, PORTOPEN
 JZ TELL1C6
 AND AL, RO
 CMP AL, SPC
 JA TELL1C6
 MOV AL, SILENCE
TELL1C6: CALL SAVE1DATA
 POP AX
 RET
TELL1CM4 DB 'askey', 0
TLCL1 DW TLC0, TLC1, TLC2, TLC3, TLC4, TLC5, TLC6, TLC7
 DW TLC8, TLC9, TLC10, TLC11, TLC12, TLC13, TLC14, TLC15
 DW TLC16, TLC17, TLC18, TLC19, TLC20, TLC21, TLC22, TLC23
 DW TLC24, TLC25, TLC26, TLC27, TLC28, TLC29, TLC30, TLC31
TLCL2 DW TLC127, TLC128, TLC129
 DW TLC130, TLC131, TLC132, TLC133, TLC134, TLC135, TLC136, TLC137
 DW TLC138, TLC139, TLC140, TLC141, TLC142, TLC143, TLC144, TLC145
 DW TLc146, TLC147, TLC148, TLC149, TLC150, TLC151, TLC152, TLC153
 DW TLC154, TLC155, TLC156, TLC157, TLC158, TLC159, TLC160, TLC161
 DW TLC162, TLC163, TLC164, TLC165, TLC166, TLC167, TLC168, TLC169
 DW TLC170, TLC171, TLC172, TLC173, TLC174, TLC175, TLC176, TLC177
 DW TLC178, TLC179, TLC180, TLC181, TLC182, TLC183, TLC184, TLC185
 DW TLC186, TLC187, TLC188, TLC189, TLC190, TLC191, TLC192, TLC193
 DW TLC194, TLC195, TLC196, TLC197, TLC198, TLC199, TLC200, TLC201
 DW TLC202, TLC203, TLC204, TLC205, TLC206, TLC207, TLC208, TLC209
 DW TLC210, TLC211, TLC212, TLC213, TLC214, TLC215, TLC216, TLC217
 DW TLC218, TLC219, TLC220, TLC221, TLC222, TLC223, TLC224, TLC225
 DW TLC226, TLC227, TLC228, TLC229, TLC230, TLC231, TLC232, TLC233
 DW TLC234, TLC235, TLC236, TLC237, TLC238, TLC239, TLC240, TLC241
 DW TLC242, TLC243, TLC244, TLC245, TLC246, TLC247, TLC248, TLC249
 DW TLC250, TLC251, TLC252, TLC253, TLC254, TLC255
TLC0 DB 'space (null)', 0
TLC1 DB 'face', 0
TLC2 DB 'face inverted', 0
TLC3 DB 'hearts', 0
TLC4 DB 'diamonds', 0
TLC5 DB 'clubs', 0
TLC6 DB 'spades', 0
TLC7 DB 'dot', 0
TLC8 DB 'inverted dot', 0
TLC9 DB 'circle', 0
TLC10 DB 'inverted circle', 0
TLC11 DB 'man symbol', 0
TLC12 DB 'woman symbol', 0
TLC13 DB 'note', 0
TLC14 DB 'note double', 0
TLC15 DB 'sun', 0
TLC16 DB 'triangle right', 0
TLC17 DB 'triangle left', 0
TLC18 DB 'arrow up and down', 0
TLC19 DB 'exclamation sign double', 0
TLC20 DB 'paragraph English', 0
TLC21 DB 'paragraph German', 0
TLC22 DB 'block horizontal', 0
TLC23 DB 'arrow up, down, underlined', 0
TLC24 DB 'arrow up', 0
TLC25 DB 'arrow down', 0
TLC26 DB 'arrow right', 0
TLC27 DB 'arrow left', 0
TLC28 DB 'rectangle half', 0
TLC29 DB 'arrow left and right', 0
TLC30 DB 'triangle up', 0
TLC31 DB 'triangle down', 0
TLC127 DB 'open triangle', 0
TLC128 DB 'capital c cedille', 0
TLC129 DB 'u diaeresis', 0
TLC130 DB 'e accent aigu', 0
TLC131 DB 'a circumflex', 0
TLC132 DB 'a diaeresis', 0
TLC133 DB 'a accent grave', 0
TLC134 DB 'a circle (scandinavian)', 0
TLC135 DB 'c cedille', 0
TLC136 DB 'e circumflex', 0
TLC137 DB 'e diaeresis', 0
TLC138 DB 'e accent grave', 0
TLC139 DB 'i diaeresis', 0
TLC140 DB 'i circumflex', 0
TLC141 DB 'i accent grave', 0
TLC142 DB 'capital a diaeresis (umlaut)', 0
TLC143 DB 'capital a circle', 0
TLC144 DB 'capital e aigu', 0
TLC145 DB 'ae (scandinavian)', 0
TLC146 DB 'capital ae (scandinavian)', 0
TLC147 DB 'o circumflex', 0
TLC148 DB 'o diaeresis', 0
TLC149 DB 'o accent grave', 0
TLC150 DB 'u circumflex', 0
TLC151 DB 'u accent grave', 0
TLC152 DB 'y diaeresis (Dutch ij)', 0
TLC153 DB 'capital o diaeresis', 0
TLC154 DB 'capital u diaeresis', 0
TLC155 DB 'dollar cent', 0
TLC156 DB 'pound', 0
TLC157 DB 'yen', 0
TLC158 DB 'peseta', 0
TLC159 DB 'gulden (Dutch)', 0
TLC160 DB 'a accent aigu', 0
TLC161 DB 'i accent aigu', 0
TLC162 DB 'o accent aigu', 0
TLC163 DB 'u accent aigu', 0
TLC164 DB 'n tilde (Spanish)', 0
TLC165 DB 'capital n tilde', 0
TLC166 DB 'a underline', 0
TLC167 DB 'o underline', 0
TLC168 DB 'reversed question mark (Spanish)', 0
TLC169 DB 'angle left/up', 0
TLC170 DB 'angle right/up', 0
TLC171 DB 'half', 0
TLC172 DB 'quarter', 0
TLC173 DB 'reversed exclamation sign (Spanish)', 0
TLC174 DB 'double arrow left', 0
TLC175 DB 'double arrow right', 0
TLC176 DB 'dotted area', 0
TLC177 EQU OFFSET TLC176
TLC178 EQU OFFSET TLC176
TLC179 DB 'line up/down', 0
TLC180 DB 'line up/down/left', 0
TLC181 EQU OFFSET TLC180
TLC182 EQU OFFSET TLC180
TLC183 DB 'line left/down', 0
TLC184 EQU OFFSET TLC183
TLC185 EQU OFFSET TLC180
TLC186 EQU OFFSET TLC179
TLC187 EQU OFFSET TLC183
TLC188 DB 'line left/up', 0
TLC189 EQU OFFSET TLC188
TLC190 EQU OFFSET TLC188
TLC191 EQU OFFSET TLC183
TLC192 DB 'line up/right', 0
TLC193 DB 'line left/right/up', 0
TLC194 DB 'line left/right/down', 0
TLC195 DB 'line up/down/right', 0
TLC196 DB 'line left/right', 0
TLC197 DB 'line up/down/left/right', 0
TLC198 EQU OFFSET TLC195
TLC199 EQU OFFSET TLC195
TLC200 EQU OFFSET TLC192
TLC201 DB 'line down/right', 0
TLC202 EQU OFFSET TLC193
TLC203 EQU OFFSET TLC194
TLC204 EQU OFFSET TLC195
TLC205 EQU OFFSET TLC196
TLC206 EQU OFFSET TLC197
TLC207 EQU OFFSET TLC193
TLC208 EQU OFFSET TLC193
TLC209 EQU OFFSET TLC194
TLC210 EQU OFFSET TLC194
TLC211 EQU OFFSET TLC192
TLC212 EQU OFFSET TLC192
TLC213 EQU OFFSET TLC201
TLC214 EQU OFFSET TLC201
TLC215 DB 'line left/right/up/down', 0
TLC216 EQU OFFSET TLC215
TLC217 EQU OFFSET TLC188
TLC218 DB 'line right/down', 0
TLC219 DB 'block', 0
TLC220 DB 'block lower half', 0
TLC221 DB 'block left half', 0
TLC222 DB 'block right half', 0
TLC223 DB 'block upper half', 0
TLC224 DB 'alpha', 0
TLC225 DB 'beta', 0
TLC226 DB 'gamma capital', 0
TLC227 DB 'pi', 0
TLC228 DB 'sigma capital', 0
TLC229 DB 'sigma', 0
TLC230 DB 'mu', 0
TLC231 DB 'tau', 0
TLC232 DB 'phi capital', 0
TLC233 DB 'theta', 0
TLC234 DB 'omega capital', 0
TLC235 DB 'delta', 0
TLC236 DB 'infinite', 0
TLC237 DB 'phi small', 0
TLC238 DB 'element of (capital epsilon)', 0
TLC239 DB 'intersection (reversed u)', 0
TLC240 DB 'identical', 0
TLC241 DB 'plus minus', 0
TLC242 DB 'greater or equal', 0
TLC243 DB 'less or equal', 0
TLC244 DB 'integral sign upper part', 0
TLC245 DB 'integral sign lower part', 0
TLC246 DB 'divide by (dash, dot above and below)', 0
TLC247 DB 'approximately equal', 0
TLC248 DB 'grade mark', 0
TLC249 DB 'filled grade mark', 0
TLC250 DB 'dot (bold)', 0
TLC251 DB 'root', 0
TLC252 DB 'enth power', 0
TLC253 DB 'power 2', 0
TLC254 DB 'vertical small block', 0
TLC255 DB 'space (''ff'')', 0
TELL1LIST DW TLC224, TELL1B, TELL1C, TELL1D
 DW TELL1E,TELL1F,TELL1G,TELL1H,TELL1I
 DW TELL1J,TELL1K,TELL1L,TELL1M,TELL1N
 DW TELL1O,TELL1P,TELL1Q,TELL1R,TELL1S
 DW TELL1T,TELL1U,TELL1V,TELL1W,TELL1X
 DW TELL1Y,TELL1Z
TELL1B DB 'brahvo', 0
TELL1C DB 'charlie', 0
TELL1D DB 'delta', 0
TELL1E DB 'echo', 0
TELL1F DB 'fox trot', 0
TELL1G DB 'golf', 0
TELL1H DB 'ho tel', 0
TELL1I DB 'item', 0
TELL1J DB 'juliet', 0
TELL1K DB 'keelo', 0
TELL1L DB 'lima', 0
TELL1M DB 'mike', 0
TELL1N DB 'november', 0
TELL1O DB 'oscar', 0
TELL1P DB 'poppa', 0
TELL1Q DB 'quebec', 0
TELL1R DB 'romeo', 0
TELL1S DB 'sierra', 0
TELL1T DB 'tango', 0
TELL1U DB 'uniform', 0
TELL1V DB 'victoria', 0
TELL1W DB 'whiskey', 0
TELL1X DB 'x ray', 0
TELL1Y DB 'yankee', 0
TELL1Z DB 'zulu', 0
TELL1CHAR ENDP
GET0WORD PROC NEAR
 MOV AL, BYTE PTR I8WIDTH
GET0W1: PUSH AX ; SAVE LINE LENGTH
 PUSH DX ; AND CURSOR POSITION
 CALL REGMUL
 TEST AL, 1 SHL 7
 JNZ GET0W2 ; SKIP IF SO
 CMP AL, SPC ; DROP CTRL CHARS
 JG GET1W3 ; IF SO
GET0W2: POP DX
 POP AX
 INC DL
 CMP DL, AL
 JL GET0W1
 JMP SHORT GET1W4
GET1WORD PROC NEAR
 MOV AL, BYTE PTR I8WIDTH
GET1W1: PUSH AX ; SAVE LINE LENGTH
 PUSH DX ; AND CURSOR POSITION
 CALL REGMUL
 TEST AL, 1 SHL 7 ; BIT #7 ON?
 JNZ GET1W2 ; USE SPACE IF SO
 CMP AL, SPC ; DROP CTRL CHARS
 JG GET1W3 ; IF SO
GET1W2: MOV AL, SPC
GET1W3: CALL SAVE1DATA
 CMP AL, SPC
 JE GET1W5
 POP DX
 POP AX
 INC DL
 CMP DL, AL
 JL GET1W1
GET1W4: PUSH AX
 PUSH DX
 MOV AX, 1 SHL 7 OR CR
 CALL SAVE1DATA
GET1W5: POP DX
 POP AX
 RET
GET1WORD ENDP
GET0WORD ENDP
GET1CRC PROC NEAR
; BX = ADDRESS OF MASKS, ES = VIDEO SEGMENT
 CALL FIX4REGS ; SETS CX AND DX
 XOR DI, DI ; INITIALIZE CRC
 PUSH BX
 MOV BX, WORD PTR [BX] ; MASKS
GCRC1: PUSH DX ; TOP LEFT
 MOV SI, WORD PTR I8VIDOFF
 XOR AX, AX
 XCHG AL, DH
 PUSH DX ; LEFT
 SHL AX, 1
 SHL DX, 1
 ADD SI, DX
 MOV DX, CX
 MOV CL, BYTE PTR I8WIDTH
 MUL CL
 ADD SI, AX
 XOR CH, CH
 CMP CL, DL
 JLE GCRC2
 MOV CL, DL
GCRC2: POP AX
 SUB CX, AX
GCRC3: MOV AX, WORD PTR ES:[SI]
 AND AH, BL
 CMP AH, BH
 JNE GCRC4
 XOR DI, AX
 ROL DI, 1
GCRC4: INC SI
 INC SI
 LOOP GCRC3 ; ANOTHER CHAR
 MOV CX, DX
 POP DX
 INC DH
 CMP DH, CH
 JL GCRC1 ; ANOTHER LINE
 POP BX
 RET
GET1CRC ENDP
SAVE1SCREEN PROC NEAR
; BX = ADDRESS OF MASKS, ES = VIDEO SEGMENT
 CALL FIX4REGS ; SETS CX AND DX
 PUSH BX
 MOV BX, WORD PTR [BX] ; MASKS
 MOV WORD PTR LAST1IN, 0 ; NOT FROM KBD
SAVE1S1: MOV DI, DX ; TOP LEFT
 MOV SI, WORD PTR I8VIDOFF
 XOR AX, AX
 XCHG AL, DH
 PUSH DX ; LEFT
 SHL AX, 1
 SHL DX, 1
 ADD SI, DX
 MOV DX, CX
 MOV CL, BYTE PTR I8WIDTH
 MUL CL
 ADD SI, AX
 XOR CH, CH
 CMP CL, DL
 JNA SAVE1S2
 MOV CL, DL
SAVE1S2: POP AX
 SUB CX, AX
SAVE1S3: MOV AX, WORD PTR ES:[SI]
 CMP AL, SPC ; CTRL CHAR?
 JL SAVE1S4
 AND AH, BL
 CMP AH, BH
 JE SAVE1S5
SAVE1S4: MOV AL, SPC
SAVE1S5: CALL SAVE1DATA
 INC SI
 INC SI
 LOOP SAVE1S3
 MOV CX, DX
 MOV DX, DI
 INC DH
 CMP DH, CH
 JL SAVE1S1
 POP BX
 RET
SAVE1SCREEN ENDP
; DATA AND CODE FOR I9 -- KEYBOARD (HARDWARE)
I9AX DW ?
I9SP DW ?
I9SS DW ?
ALTKEY DW ?
I9STATE DW I9DIRECT ; PROVOX STATE SWITCH
I9ENTRY: PUSH DS
 PUSH CS
 POP DS
 CMP WORD PTR VOXNUMBER, MAXVOXNUM SHL 1 ; INITIALIZED?
 JE I9SKIP ; IF NOT
 TEST WORD PTR STATES1, CLOSED OR I9BUSY
 JZ I9INIT
I9SKIP: POP DS
I9RETURN DB 234 ; FAR JUMP
 DD ? ; ORIGINAL I9 VECTOR
I9INIT: OR WORD PTR STATES1, I9BUSY
 PUSH AX
 MOV AX, CS
 MOV WORD PTR I9SS, SS
 MOV WORD PTR I9SP, SP
 CLI ; HOLD INTERRUPTS
 MOV SS, AX
 MOV SP, OFFSET INT9_STACK
 STI ; TAKE INTERRUPTS
 PUSH ES
 PUSH SI
 PUSH DI
 PUSH BX
 PUSH CX
 PUSH DX
 MOV AX, 64 ; DOS SEGMENT
 MOV ES, AX
 PUSH WORD PTR ES:[28] ; KBD BUFFER TAIL
 PUSH WORD PTR ES:[23] ; KBD STATES
 PUSHF
 CALL DWORD PTR I9RETURN+1
 POP AX ; OLD KBD STATES
 CALL I9TELL
 POP BX ; OLD KBD BUFFER TAIL
 CMP WORD PTR ES:28, BX ; DID THE TAIL MOVE?
 JE I9EXIT ; IF NOT
 MOV AX, WORD PTR ES:[BX] ; GET THE NEW KEYSTROKE
 PUSH BX
 PUSH ES
 CALL I9KEYSTROKE
 POP ES
 POP AX ; OLD BUFFER TAIL
 JNC I9EXIT
 MOV WORD PTR ES:28, AX ; RESET BUFFER TAIL
I9EXIT: POP DX
 POP CX
 POP BX
 POP DI
 POP SI
 POP ES
 CLI ; HOLD INTERRUPTS
 MOV SS, WORD PTR I9SS
 MOV SP, WORD PTR I9SP
 POP AX
 AND WORD PTR STATES1, NOT I9BUSY
 POP DS
 IRET ; END OF CODE FOR I9 -- KEYBOARD (HARDWARE)
; SUBROUTINES
I9KEYSTROKE PROC NEAR
 MOV BYTE PTR ALTKEY, 0 ; CLEAR ALT STATUS
 AND BYTE PTR STATES1, NOT CONTINUOUS
 JMP WORD PTR I9STATE
I9ST1: CALL INSERT ; GET SCAN TARGET
 STC ; DROP CHAR
 RET
I9ST2: CMP AL, BYTE PTR PREFIX ; BUZZING -- FOR DOS?
 JNE I9ST3
 MOV WORD PTR I9STATE, OFFSET I9DIRECT ; BACK TO DIRECT MODE
 AND BYTE PTR STATES0, NOT BUZZER
 CLC ; KEEP CHAR
 RET
I9ST3: MOV WORD PTR I9STATE, OFFSET I9ST4 ; REVIEW MODE
I9ST4: TEST WORD PTR STATES1, GRAPHICS
 JNZ I9ST5 ; IF SO
 MOV WORD PTR ES:28, BX
I9ST5: CALL STOPVOX
 CALL I9PROVOX
 STC ; DROP CHAR
 RET
I9KEYSTROKE ENDP
I9TELL PROC NEAR
 MOV AH, AL
 MOV AL, BYTE PTR ES:[23] ; GET STATUS
CMP WORD PTR I9STATE, OFFSET I9ST4
 JE I9TLX1
 TEST BYTE PTR STATES0, ENHANCED
 JZ I9TL1 ; IF NOT
I9TLX1: AND BYTE PTR ES:[23], NOT (1 SHL 5) ; CLEAR NUMLOCK
 AND AH, NOT (1 SHL 5)
I9TL1: AND AX, RO SHL 8 OR RO
 CMP AH, AL ; DID IT CHANGE?
 JE I9TL4 ; IF NOT
 XOR AH, AL ; KEEP CHANGES
 MOV SI, AX
 MOV BX, OFFSET I9TLM5 ; SHIFT
 TEST AH, 2 OR 1 ; BITS 1 OR 0?
 JZ I9TL2 ; IF NEITHER
 MOV AH, BYTE PTR ALTKEY ; UPDATE ALTKEY
 MOV BYTE PTR ALTKEY, AL
 AND AH, 2 OR 1 ; KEEP SHIFT BITS
 JE I9TL4 ; IF NEITHER
 JMP SENDSTRING
I9TL2: TEST AH, 8 OR 4 ; ALT OR CTRL?
 JZ I9TL5 ; IF NEITHER
 MOV AH, BYTE PTR ALTKEY ; UPDATE ALTKEY
 MOV BYTE PTR ALTKEY, AL
 AND AH, 8 OR 4 ; KEEP OLD CTRL AND ALT
 JE I9TL4 ; IF NEITHER
 CALL STOPVOX
 MOV BX, OFFSET I9TLM6 ; CONTROL
MOV AX, SI
 AND AL, 1 SHL 3 ; ALT?
 JNE I9TL4
 CMP AH, 1 SHL 3 ; ALT?
 JNE I9TL3
 MOV BX, OFFSET I9TLM4 ; ALT
I9TL3: JMP SENDSTRING
I9TL4: RET
I9TL5: TEST AH, 1 SHL 6 ; CAP LOCK?
 JZ I9TL6 ; IF NOT
 MOV BX, OFFSET I9TLM1
 CALL SENDSTRING
 MOV AX, SI
 AND AL, 1 SHL 6
 JMP LOCKSTATUS
I9TL6: TEST AH, 1 SHL 5 ; NUM LOCK?
 JZ I9TL8 ; IF NOT
 CMP WORD PTR I9STATE, OFFSET I9ST2 ; PREFIX NUMLOCK?
 JNE I9TL7 ; IF NOT
 MOV WORD PTR I9STATE, OFFSET I9DIRECT
 AND BYTE PTR STATES0, NOT BUZZER
 XOR AL, 1 SHL 5 ; REVERSE THE CHANGE
 MOV BYTE PTR ES:[23], AL
 AND WORD PTR STATES1, NOT (PASSTHRU OR DIGIT2 OR PH2FLAG OR PH1FLAG)
 TEST BYTE PTR ES:[150], 1 SHL 4 ; ENHANCED?
 JZ I9TL7
 XOR BYTE PTR STATES0, ENHANCED
 MOV BX, OFFSET I9TLM7
 CALL SENDSTRING
 MOV AL, BYTE PTR STATES0
 AND AX, ENHANCED
 JMP LOCKSTATUS
I9TL7: MOV BX, OFFSET I9TLM2
 CALL SENDSTRING
CMP WORD PTR I9STATE, OFFSET I9ST4
 JE I9TLX2
 MOV AX, SI
 AND AL, 1 SHL 5
 TEST BYTE PTR STATES0, ENHANCED
 JZ LOCKSTATUS
I9TLX2: RET
I9TL8: CMP WORD PTR I9STATE, OFFSET I9ST2 ; PREFIX SCROLL LOCK?
 JNE I9TL11 ; IF NOT
 MOV WORD PTR I9STATE, OFFSET I9DIRECT
 AND BYTE PTR STATES0, NOT BUZZER
 XOR AL, 1 SHL 4 ; REVERSE THE CHANGE
 MOV BYTE PTR ES:[23], AL
 OR WORD PTR STATES1, CLOSED
 RET
I9TL11: MOV BX, OFFSET I9TLM3
 CALL SENDSTRING
 MOV AX, SI
 AND AL, 1 SHL 4
LOCKSTATUS PROC NEAR
 MOV BX, OFFSET LOCKSM1
 TEST AL, AL
 JZ LOCKS1
 MOV BX, OFFSET LOCKSM2
LOCKS1: JMP SENDSTRING
LOCKSM1 DB 'off', RO, 0
LOCKSM2 DB 'on', RO, 0
LOCKSTATUS ENDP
I9TLM1 DB 'caps lock', 0
I9TLM2 DB 'num lock', 0
I9TLM3 DB 'scroll lock', 0
I9TLM4 DB 'alt', 0
I9TLM5 DB 'shift', 0
I9TLM6 DB 'control', 0
I9TLM7 DB 'enhanced mode', 0
I9TELL ENDP
I9DIRECT PROC NEAR
 CMP BYTE PTR F7FLAG, 1 ; KILL SPEECH?
 JA I9DR01 ; IF NOT
 CALL STOPVOX
I9DR01: AND WORD PTR STATES1, NOT PH2FLAG
 ADD WORD PTR STATES1, PH1FLAG
 AND WORD PTR STATES1, NOT PH1FLAG
 TEST WORD PTR STATES1, DIGIT2
 JNZ I9DR03
 MOV BX, OFFSET TABLE7 - 4 ; SIMPLE THINGS
 MOV DX, WORD PTR THISCURSOR
 TEST BYTE PTR STATES0, ENHANCED
 JZ I9DR02 ; IF NOT
 MOV BX, OFFSET TABLE6 - 4 ; ENHANCED THINGS
 TEST WORD PTR STATES1, JOINED
 JZ I9DR02 ; IF SPLIT
 MOV DX, WORD PTR I8CURSOR
I9DR02: AND BYTE PTR STATES0, NOT ROUTING
 TEST WORD PTR STATES1, PASSTHRU
 JNZ I9DR05 ; IF SO
 CALL DISPATCH
 TEST BYTE PTR STATES0, ENHANCED
 JZ I9DR06 ; IF NOT
 CALL ISNUMBER
 JNC I9DR06 ; IF NOT
 MOV BYTE PTR DIGIT, AL
 CALL SAVE2DATA
 OR WORD PTR STATES1, DIGIT2
 STC ; FOUND
 RET
I9DR03: AND WORD PTR STATES1, NOT DIGIT2
 CALL ISNUMBER
 JNC I9DR04 ; IF NOT
 CALL GET2DIGITS
 TEST AX, AX
 JZ I9DR04
 XCHG AH, AL
 DEC AH
 CMP AH, BYTE PTR I8LINE
 JA I9DR04
 MOV DX, AX
 JMP RVW07
I9DR04: MOV BX, OFFSET I9PRM04 ; ERROR MESSAGE
 CALL SENDSTRING
 STC ; FOUND
 RET
I9DR05: AND WORD PTR STATES1, NOT PASSTHRU
 AND BYTE PTR STATES0, NOT BUZZER
I9DR06: CLC ; NOT FOUND
 RET
I9DR07: CALL EXITROUTE
 STC ; FOUND
 RET
I9DR08: CMP BYTE PTR PREFIX, AL
 JNE I9DR06
 MOV WORD PTR I9STATE, OFFSET I9ST2
 OR BYTE PTR STATES0, BUZZER
 STC ; FOUND
 RET
I9DR09: MOV WORD PTR THISCURSOR, DX ; JOIN CURSORS
 OR WORD PTR STATES1, JOINED
 MOV BX, OFFSET I9DRM1
 CALL SENDSTRING
 STC ; FOUND
 RET
I9DR10: OR WORD PTR STATES1, PASSTHRU
 OR BYTE PTR STATES0, BUZZER
 STC ; FOUND
 RET
I9DR11: CALL SEARCH
 JC I9DR12
 CALL SENDSTRING
 STC
I9DR12: RET
I9DR13: MOV WORD PTR I9STATE, OFFSET I9ST1
 MOV BYTE PTR SCANSIZE, 0
 MOV BX, OFFSET I9PRM06
 CALL SENDSTRING
 OR BYTE PTR STATES0, BUZZER
 STC ; FOUND
 RET
I9DR14: CALL SCANATT
 JC I9DR15
 CALL SENDSTRING
 STC
I9DR15: RET
I9DRM1 DB 'go to cursor', 0
I9DIRECT ENDP
I9PROVOX PROC NEAR
 MOV WORD PTR LATER, 0
 JMP WORD PTR I9SWITCH
I9SW01: ; NOT IN REVIEW MODE
 MOV DX, WORD PTR I8CURSOR
 MOV BX, OFFSET TABLE4 - 4 ; DIRECT MODE COMMANDS
 AND BYTE PTR STATES0, NOT BUZZER
 CALL DISPATCH
 CALL I9TEST ; SHARED COMMANDS
 JC I9PR02 ; IF FOUND
 CALL ISDIGIT
 JNC I9PR09 ; IF NOT
 CALL GET1SCREEN
I9PR02: MOV WORD PTR I9STATE, OFFSET I9DIRECT ; BACK TO DIRECT MODE
 MOV BYTE PTR HL1TEST, 0
 AND BYTE PTR STATES0, NOT BUZZER
 RET
I9SW02: ; ALREADY IN REVIEW MODE
 AND WORD PTR STATES1, NOT PH2FLAG
 ADD WORD PTR STATES1, PH1FLAG
 AND WORD PTR STATES1, NOT PH1FLAG
 MOV DX, WORD PTR THISCURSOR
 MOV BX, OFFSET TABLE5 - 4 ; REVIEW MODE COMMANDS
 CALL DISPATCH
 CALL I9TEST ; SHARED COMMANDS
 JC I9PR03 ; IF FOUND
 CALL ISDIGIT
 JNC I9PR04 ; IF NOT
 MOV BYTE PTR DIGIT, AL ; FIRST DIGIT OF LINE NUMBER
 CALL SAVE2DATA
 MOV WORD PTR I9SWITCH, OFFSET I9SW03
I9PR03: RET
I9PR04: MOV WORD PTR I9SWITCH, OFFSET I9SW02 ; REVIEW MODE ERROR
 MOV BX, OFFSET I9PRM03
 JMP SHORT I9PR08
I9PR05: MOV BYTE PTR HL1TEST, 1 ; HIGHLIGHT TEST
 RET
I9PR07: CALL ENTER_REVIEW
 JC I9PR09
 MOV BX, OFFSET I9PRM01
I9PR08: JMP SENDSTRING
I9PR09: MOV BX, OFFSET I9PRM04 ; DIRECT MODE ERROR
 JMP SHORT I9PR13
I9PR10: CALL EXITROUTE
I9PR11: CALL EXIT_REVIEW
I9PR12: MOV WORD PTR I9SWITCH, OFFSET I9SW01
I9PR13: CALL SENDSTRING
 JMP I9PR02
I9SW03: CALL ISDIGIT
 JNC I9PR04 ; IF NOT
 CALL GET2DIGITS
 TEST AX, AX
 JZ I9PR04
 XCHG AH, AL
 DEC AH
 CMP AH, BYTE PTR I8LINE
 JA I9PR04
 MOV WORD PTR THISCURSOR, AX
 MOV DX, AX
 CALL GET1LINE
 MOV WORD PTR I9SWITCH, OFFSET I9SW02
 RET
I9PR14: CMP BYTE PTR HL1TEST, 0
 JNE I9PR09
 MOV BYTE PTR PREFIX, AL ; CHANGE PREFIX
 MOV BX, OFFSET I9PRM13
 JMP SHORT I9PR13
I9PR15: OR BYTE PTR STATES1, CONTINUOUS
 CALL GET2LINE
 JMP I9PR02
I9SW04: MOV BX, 14 ; ALLOW F1 TO F6
 CMP AL, ESCP
 JE I9PR17
 XOR BX, BX
 TEST AL, AL
 JNZ I9PR17
 CMP AH, 59 ; F1
 JB I9PR17
 CMP AH, 64 ; F6
 JA I9PR17
 SUB AH, 58
 SHL AH, 1
 MOV BL, AH 
I9PR17: MOV AX, WORD PTR VOXNUMBER
 XCHG AX, BX
 CALL WORD PTR MENU2LIST[BX]
 JC I9PR19 ; IF FINISHED
I9PR16: MOV WORD PTR I9SWITCH, OFFSET I9SW04
 MOV BX, WORD PTR VOXNUMBER
 MOV BX, WORD PTR MENU1LIST[BX]
I9PR18: PUSH BX
 MOV BX, WORD PTR [BX]
 CALL SENDSTRING
 POP BX
 INC BX
 INC BX
 CMP WORD PTR [BX], 0
 JNE I9PR18
 MOV BX, OFFSET I9PRM23
 JMP SENDSTRING
I9PR19: MOV BX, OFFSET I8MSG3
 JMP I9PR12
I9PR20: MOV WORD PTR I9SWITCH, OFFSET I9SW05
 MOV BX, OFFSET I9PRM21
 CALL SENDSTRING
 MOV BX, WORD PTR VOXNUMBER
 MOV BX, WORD PTR NAMELIST[BX]
 CALL SENDSTRING
 MOV BX, OFFSET I9PRM22
 JMP SENDSTRING
I9SW05: CMP AL,'1' ; DEVICE MENU?
 JE I9PR16
 CMP AL, '2' ; AUTO ALERT?
 JE I9PR23
 CMP AL, '3' ; AUTO IGNORE?
 JE I9PR22
 CALL SAVE2DATA
 CMP AL, ESCP
 JNE I9PR20
I9PR21: MOV BX, OFFSET I8MSG3
 JMP I9PR12
I9PR22: MOV WORD PTR I9SWITCH, OFFSET I9SW06
 XOR AX, AX
I9SW06: CALL SAVE2DATA
 CALL GET1IGNORE
 JC I9PR19 ; IF DONE
 JMP SENDSTRING
I9PR23: MOV WORD PTR I9SWITCH, OFFSET I9SW07
 XOR AX, AX
I9SW07: CALL SAVE2DATA
 CALL GET1ALERT
 JC I9PR19 ; IF DONE
 JMP SENDSTRING
I9PR24: MOV WORD PTR I9STATE, OFFSET I9ST1
 MOV BYTE PTR SCANSIZE, 0
 MOV BX, OFFSET I9PRM06
 OR BYTE PTR STATES0, BUZZER
 JMP SENDSTRING
I9PR25: CALL SEARCH
 JNC I9PR26 ; FOUND
 RET
I9PR26: JMP SENDSTRING
I9PR27: CALL SCANATT
 JNC I9PR26 ; FOUND
 RET
I9PR28: MOV WORD PTR I9SWITCH, OFFSET I9SW08
 MOV AL, BYTE PTR F19FLAG
 MOV BX, OFFSET I9PRM09
 CALL TELL3DIGITS
 MOV BX, OFFSET I9PRM14
 JMP SENDSTRING
I9SW08: CALL SAVE2DATA
 CALL ISDIGIT
 JC I9PR28 ; IF SO
 CMP AL,'*'
 JNE I9PR21
 MOV AL, BYTE PTR I8CURSOR
 INC AL
 MOV BYTE PTR F19FLAG, AL
 JMP SHORT I9PR28
I9PR29: MOV BYTE PTR DIGIT, AL
 MOV WORD PTR I9SWITCH, OFFSET I9SW09
 RET
I9SW09: CALL SAVE2DATA
 CALL ISDIGIT
 JNC I9PR28
 CALL GET2DIGITS
 MOV BYTE PTR F19FLAG, AL
I9PR30: JMP I9PR21
I9PR31: MOV WORD PTR I9SWITCH, OFFSET I9SW10
 MOV AL, BYTE PTR F20FLAG
 MOV BX, OFFSET I9PRM10
 CALL TELL3DIGITS
 MOV BX, OFFSET I9PRM15
 JMP SENDSTRING
I9SW10: CALL SAVE2DATA
 CALL ISDIGIT
 JNC I9PR30 ; IF NOT
 SUB AL, '0'
 MOV BYTE PTR F20FLAG, AL
 JMP SHORT I9PR30
I9PR33: MOV WORD PTR I9SWITCH, OFFSET I9SW11
 MOV BX, OFFSET I9PRM11
 JMP SENDSTRING
I9SW11: CALL SAVE2DATA
 CMP AL, ESCP
 JE I9PR30
 CMP AL, '/' ; DEFAULTS
 JE I9PR34
 CALL ISDIGIT
 JNC I9PR33 ; ERROR
 CALL BANKLOAD
 JMP I9PR12
I9PR34: CALL DEFAULTS
 JMP SHORT I9PR30
I9PR35: MOV WORD PTR I9SWITCH, OFFSET I9SW12
 MOV BX, OFFSET I9PRM12
 JMP SENDSTRING
I9SW12: CALL SAVE2DATA
 CMP AL, ESCP
 JE I9PR38
 CALL ISDIGIT
 JNC I9PR35 ; ERROR
 MOV BYTE PTR DIGIT, AL
 MOV WORD PTR I9SWITCH, OFFSET I9SW13
 XOR AX, AX
I9SW13: CMP AL, ESCP
 JE I9SW12
 CALL FIXNAME
 JC I9PR36 ; WHEN DONE
 RET
I9PR36: PUSH ES
 PUSH CS
 POP ES
 MOV AL, BYTE PTR DIGIT
 AND AX, 15 ; BITS 3-0
 MOV CX, BANKSIZE
 MUL CL
 MOV DI, OFFSET BANK0NAME
 ADD DI, AX
 MOV SI, OFFSET BANKNAME
 SHR CX, 1
 CLD
 REP MOVSW
 POP ES
I9PR38: JMP I9PR21
I9PR39: MOV BX, OFFSET I9PRM08
 JMP I9PR13
I9PR40: MOV WORD PTR I9SWITCH, OFFSET I9SW14
 MOV BX, OFFSET I8MSG8
 JMP SENDSTRING
I9SW14: MOV BX, OFFSET BANKNAME ; CURRENT SCREEN BANK
 CALL ISDIGIT
 JNC I9PR41
 AND AX, 8 OR 4 OR 2 OR 1
 MOV BX, BANKSIZE
 MUL BL
 MOV BX, OFFSET BANK0NAME
 ADD BX, AX
I9PR41: CMP BYTE PTR [BX], SPC
 JNB I9PR42
 MOV BX, OFFSET I9PRM05
I9PR42: JMP I9PR12
I9PR44: MOV WORD PTR I9SWITCH, OFFSET I9SW15
 MOV BX, OFFSET I9PRM16
 JMP SENDSTRING
I9SW15: PUSH AX
 MOV BX, OFFSET I9PRM17
 CALL SENDSTRING
 POP AX
 PUSH AX
 CALL SAVE3DIGITS
 MOV BX, OFFSET I9PRM18
 CALL SENDSTRING
 POP AX
 MOV AL, AH
 CALL SAVE3DIGITS
 JMP I9PR12
I9PR45: XOR DH, DH ; READ TOP LINE
I9PR46: CALL TEST1LINE ; FOR NONBLANK
 JNC I9PR49
 INC DH ; DOWN
 CMP DH, BYTE PTR I8LINE
 JNE I9PR46
 JMP SHORT I9PR49
I9PR47: MOV DH, BYTE PTR I8LINE ; READ BOTTOM LINE
I9PR48: CALL TEST1LINE ; FOR NONBLANK
 JNC I9PR49
 DEC DH
 TEST DH, DH ; UP IF NOT 0
 JNZ I9PR48
I9PR49: CALL RVW07
 JMP I9PR02
I9PR50: MOV WORD PTR I9SWITCH, OFFSET I9SW16
 RET
I9SW16: CMP AX, 15 SHL 8 OR 9 ; SECOND TAB?
 JE I9PR51
 MOV WORD PTR I9SWITCH, OFFSET I9SW01
 CMP AL, '1' ; ACCEPT ONLY DIGITS 1 TO 9
 JB I9PR61
 CMP AL, '9'
 JA I9PR61
 DEC AL
 MOV AH, 1
 MOV WORD PTR LATER, AX
 JMP I9PR02
I9PR51: MOV WORD PTR I9SWITCH, OFFSET I9SW17
 RET
I9SW17: MOV WORD PTR I9SWITCH, OFFSET I9SW01
 CMP AL, '1' ; ACCEPT ONLY DIGITS 1 TO 9
 JB I9PR61
 CMP AL, '9'
 JA I9PR61
 DEC AL
 MOV DL, AL
 MOV DH, 1
 AND AX, 15 ; NOW IT IS 0-8
 SHL AX, 1
 SHL AX, 1
 MOV BX, AX
 MOV AX, WORD PTR BOXES_LAST[BX+0]
 MOV WORD PTR TEMPSUB[2], AX
 MOV AX, WORD PTR BOXES_LAST[BX+2]
 MOV WORD PTR TEMPSUB[4], AX
 TEST AX, AX
 JNZ I9PR60
 MOV AX, WORD PTR BOXES_THIS[BX+0]
 MOV WORD PTR TEMPSUB[2], AX
 MOV AX, WORD PTR BOXES_THIS[BX+2]
 MOV WORD PTR TEMPSUB[4], AX
 TEST AX, AX
 JNZ I9PR60
 MOV WORD PTR LATER, DX
 JMP I9PR02
I9PR60: CALL TELLSUBS
 JMP I9PR02
I9PR61: JMP I9PR09 ; ERROR EXIT
I9PR62: MOV BYTE PTR DIGIT, AH ; SCAN CODE OF 'B' OR 'F'
 MOV WORD PTR I9SWITCH, OFFSET I9SW18
 RET
I9SW18: CMP AH, BYTE PTR DIGIT ; 'BB' OR 'FF'?
 JNE I9PR63
 MOV WORD PTR I9SWITCH, OFFSET I9SW19
 RET
I9PR63: MOV WORD PTR I9SWITCH, OFFSET I9SW01
 CMP AL, '1' ; ACCEPT 1, 2, 3, 4
 JB I9PR61
 CMP AL, '4'
 JA I9PR61
 MOV DX, 1 SHL 8 OR 'A'-'1'
 CMP BYTE PTR DIGIT, 48 ; 'B' SCAN CODE?
 JE I9PR64
 MOV DX, 1 SHL 8 OR 'E'-'1'
I9PR64: ADD DL, AL
 MOV WORD PTR LATER, DX
 JMP I9PR02
I9SW19: MOV WORD PTR I9SWITCH, OFFSET I9SW01
 CMP AL, '1' ; ACCEPT 1, 2, 3, 4
 JB I9PR61
 CMP AL, '4'
 JA I9PR61
 DEC AL
 AND AX, 3 ; NOW IT IS 0-3
 MOV BX, AX
 SHL BX, 1 ; SI = 6*AX
 MOV SI, BX
 SHL BX, 1
 ADD SI, BX
 MOV CX, WORD PTR BG_THIS[SI] ; BACKGROUND MASKS
 MOV BL, CH
 AND BX, 7 SHL 4
 SHR BX, 1
 SHR BX, 1
 SHR BX, 1
 MOV DX, 1 SHL 8 OR 'A'
 MOV DI, OFFSET TLFM4
 CMP BYTE PTR DIGIT, 48 ; 'B' SCAN CODE?
 JE I9PR65
 MOV CX, WORD PTR FG_THIS[SI]
 MOV BL, CH
 AND BX, 15
 SHL BX, 1 ; TIMES 2
 MOV DX, 1 SHL 8 OR 'E'
 MOV DI, OFFSET TLFM5
I9PR65: JCXZ I9PR66
 PUSH BX
 MOV BX, DI
 CALL SENDSTRING
 POP BX
 MOV BX, WORD PTR GET1COLOR[BX]
 CALL SENDSTRING
 JMP I9PR02
I9PR66: ADD DL, AL
 MOV WORD PTR LATER, DX
 JMP I9PR02
I9PR67: MOV AX, WORD PTR CORNER1 ; DEFINE SUBSCREEN
 OR AX, WORD PTR CORNER2
 JNZ I9PR68
 MOV BX, OFFSET I9PRM30
 JMP I9PR12
I9PR68: MOV WORD PTR I9SWITCH, OFFSET I9SW20
 MOV WORD PTR TEMPSUB, 0
 MOV BX, OFFSET I9PRM33
 JMP SENDSTRING
I9SW20: CALL SAVE2DATA ; BACKGROUND FILTER
 CMP AL, ESCP
 JE I9PR72
 CMP AL, '0'
 JB I9PR69
 CMP AL, '7'
 JA I9PR69
 MOV AH, 7
 AND AL, AH
 SHL AX, 1
 SHL AX, 1
 SHL AX, 1
 SHL AX, 1
 MOV WORD PTR TEMPSUB, AX
I9PR69: MOV WORD PTR I9SWITCH, OFFSET I9SW21
 MOV BX, OFFSET I9PRM34
 JMP SENDSTRING
I9SW21: CALL SAVE2DATA ; FOREGROUND FILTER
 CMP AL, ESCP
 JE I9PR72
 CMP AL, '0'
 JB I9PR70
 CMP AL, '7'
 JA I9PR70
 MOV AH, 7
 AND AL, AH
 OR WORD PTR TEMPSUB, AX
I9PR70: MOV WORD PTR I9SWITCH, OFFSET I9SW22
 MOV BX, OFFSET I9PRM35
 JMP SENDSTRING
I9SW22: CALL SAVE2DATA ; INTENSITY FILTER
 CMP AL, ESCP
 JE I9PR72
 CMP AL, '0'
 JB I9PR71
 CMP AL, '1'
 JA I9PR71
 MOV AH, 1
 AND AL, AH
 SHL AX, 1
 SHL AX, 1
 SHL AX, 1
 OR WORD PTR TEMPSUB, AX
I9PR71: MOV WORD PTR I9SWITCH, OFFSET I9SW23
 MOV BX, OFFSET I9PRM19
 JMP SENDSTRING
I9SW23: CALL SAVE2DATA
I9PR72: CMP AL, ESCP
 JE I9PR76
 CALL ISDIGIT
 JC I9PR73
 MOV WORD PTR I9SWITCH, OFFSET I9SW01
 JMP I9PR09 ; ERROR
I9PR73: AND AX, 8 OR 4 OR 2 OR 1
 CALL TIMES6 ; BX = 6*AX
 MOV CX, WORD PTR CORNER1
 MOV DX, WORD PTR CORNER2
 XOR AX, AX
 MOV WORD PTR CORNER1, AX
 MOV WORD PTR CORNER2, AX
 MOV AX, WORD PTR TEMPSUB
 XCHG AH, AL
 MOV WORD PTR BANKTABLE[BX], AX
 CMP CH, DH
 JB I9PR74
 XCHG CH, DH
I9PR74: CMP CL, DL
 JB I9PR75
 XCHG CL, DL
I9PR75: INC CH
 INC CL
 MOV WORD PTR BANKTABLE[BX+2], CX
 INC DH
 INC DL
 MOV WORD PTR BANKTABLE[BX+4], DX
I9PR76: JMP I9PR21
I9PR77: MOV AX, WORD PTR THISCURSOR
 MOV WORD PTR CORNER1, AX
 PUSH AX
 MOV BX, OFFSET I9PRM31
 JMP SHORT I9PR79
I9PR78: MOV AX, WORD PTR THISCURSOR
 MOV WORD PTR CORNER2, AX
 PUSH AX
 MOV BX, OFFSET I9PRM32
I9PR79: CALL SENDSTRING
 POP AX
 JMP TELLCURSOR
I9PR80: MOV DX, WORD PTR THISCURSOR
I9PR81: TEST DH, DH ; UP IF NOT 0
 JZ I9PR84
 DEC DH
 CALL TEST1LINE ; FOR NONBLANK
 JC I9PR81
 JMP SHORT I9PR84
I9PR82: MOV DX, WORD PTR THISCURSOR
I9PR83: CMP DH, BYTE PTR I8LINE
 JE I9PR84
 INC DH ; DOWN
 CALL TEST1LINE ; FOR NONBLANK
 JC I9PR83
I9PR84: CALL RVW07
 JMP I9PR02
I9PR85: MOV WORD PTR I9SWITCH, OFFSET I9SW24 ; SMART SCREEN
 MOV AL, BYTE PTR F6FLAG
 MOV BX, OFFSET I9PRM20
 CALL TELL3DIGITS
 MOV BX, OFFSET I9PRM15
 JMP SENDSTRING
I9SW24: CALL SAVE2DATA
 CALL ISDIGIT
 JNC I9PR76 ; IF NOT
 AND AL, 8 OR 4 OR 2 OR 1
 MOV BYTE PTR F6FLAG, AL
 JMP SHORT I9PR76
I9PR86: MOV WORD PTR I9SWITCH, OFFSET I9SW25 ; REPORT SUBSCREEN
 MOV BX, OFFSET I8MSG7
 JMP SENDSTRING
I9SW25: CALL TOUPPER
 CALL SAVE2DATA
 MOV WORD PTR I9SWITCH, OFFSET I9SW01
 MOV DX, WORD PTR I8CURSOR
 CALL PREP4REGS
 JNC I9PR87
 MOV BX, OFFSET I8MSG5 ; NOT DEFINED
 JMP I9PR13
I9PR87: CALL TELLSUBS
 CALL TELLFILTER
 JMP I9PR02
I9PR88: TEST WORD PTR STATES1, PORTOPEN ; OPENPORT TOGGLE
 JNZ I9PR89 ; IF OPEN
 MOV WORD PTR I9SWITCH, OFFSET I9SW26
 MOV BX, OFFSET I9PRM36
 JMP SENDSTRING
I9SW26: CALL SAVE2DATA
 MOV WORD PTR I9SWITCH, OFFSET I9SW01
 CALL START_OPENPORT
 JNC I9PR90 ; IF OKAY
 JMP I9PR13 ; ERROR
I9PR89: CALL CLOSE_OPENPORT
 MOV BX, OFFSET I9PRM37
I9PR90: XOR WORD PTR STATES1, PORTOPEN
 JMP I9PR13
I9PR91: XOR BYTE PTR STATES2, EMAIL1
 MOV BX, OFFSET I9PRM39
 TEST BYTE PTR STATES2, EMAIL1
 JZ I9PR92
 MOV WORD PTR EMLP1, 0
 AND BYTE PTR STATES2, NOT (EMAIL2 OR EMAIL3)
 MOV BX, OFFSET I9PRM40
I9PR92: JMP I9PR13
I9PR93: MOV WORD PTR STUFCOUNT, 0
 MOV BX, OFFSET I9PRM41
 CMP WORD PTR CLIPCOUNT, 0
 JE I9PR92
 OR BYTE PTR STATES3, PASTING
 JMP I9PR02 ; SILENT EXIT
I9PRM01 DB 'review mode', 0
I9PRM02 DB 'exit review', 0
I9PRM03 DB 'review mode '
I9PRM04 DB 'error', RO,'try again', 0
I9PRM05 DB RO, 'no name', 0
I9PRM06 DB 'scan target', 0
I9PRM07 DB 'scan target ready', 0
I9PRM08 DB 'provox shift function keys', RO
 DB 'shift f2 speech menu and special options', RO
 DB 'shift f3 and shift f4 mark sub screen corners', RO
 DB 'shift f5 load screen bank', RO
 DB 'shift f6 save screen bank', RO
 DB 'shift f9 column where keyboard beeps', RO
 DB 'shift f ten', RO, 'watchdog threshold', RO, 0
I9PRM09 DB 'the keyboard beeps after column', 0
I9PRM10 DB 'watchdog threshold is', 0
I9PRM11 DB 'screen bank to load 0/9', RO, 'press slash to clear', 0
I9PRM12 DB 'screen bank to save 0/9', 0
I9PRM13 DB 'changing prefix', 0
I9PRM14 DB RO, 'enter two digits or star for cursor', RO,'or space', 0
I9PRM15 DB RO, 'press 0/9', RO, 'or space', 0
I9PRM16 DB 'keystroke to describe', 0
I9PRM17 DB 'asky', 0
I9PRM18 DB 'scan code', 0
I9PRM19 DB RO, 'sub screen 0/9', 0
I9PRM20 DB 'smart screen is', 0
I9PRM21 DB 'press 1 for the', 0
I9PRM22 DB 'menu', RO,'press 2 to edit auto alert', RO
 DB 'press 3 to edit auto ignore'
I9PRM23 DB RO, 'or press escape', 0
I9PRM24 DB 'f1 set standard voice', 0
I9PRM25 DB 'f3 change voice', 0
I9PRM26 DB 'f3 and f4 change pitch', 0
I9PRM27 DB 'f5 and f6 change filter', 0
I9PRM28 DB 'f3 and f4 change inflection', 0
I9PRM29 DB 'f5 and f6 change voice', 0
I9PRM30 DB 'sub screen corners are not marked', 0
I9PRM31 DB 'corner 1', RO, 0
I9PRM32 DB 'corner 2', RO, 0
I9PRM33 DB 'background 0/7', RO, 'or space', 0
I9PRM34 DB RO, 'fore ground 0/7', RO, 'or space', 0
I9PRM35 DB RO, 'intensity 0/1', RO, 'or space', 0
I9PRM36 DB 'open which port? 1 2 3 or 4', 0
I9PRM37 DB RO, 'open port closed', 0
I9PRM38 DB RO, 'open port active', 0
I9PRM39 DB RO, 'e mail filter closed', 0
I9PRM40 DB RO, 'e mail filter active', 0
I9PRM41 DB 'count=0', 0
SCANSIZE DB 0
SCANFLAG DB 0
SCANFIND DB 0
MENU1LIST DW VOX1ML, VOX1ML, VOX1ML, VOX4ML, VOX5ML
 DW 0, VOX7ML, VOX8ML, VOX1ML, VOX1ML
VOX1ML DW I9PRM24, I9PRM26, I9PRM27, 0
VOX4ML DW I9PRM24, I9PRM26, 0
VOX5ML DW I9PRM24, I9PRM28, 0
VOX7ML DW I9PRM24, I9PRM26, I9PRM29, 0
VOX8ML DW I9PRM24, I9PRM25, 0
MENU2LIST DW VOX1MENU, VOX2MENU, VOX3MENU, VOX4MENU, VOX5MENU
 DW DUMMY, VOX7MENU, VOX8MENU, VOX9MENU, VOX10MENU
I9SWITCH DW I9SW01
I9PROVOX ENDP
; DISPATCH -- JUMPS IF FOUND, RETURNS IF NOT FOUND
DISPATCH: CALL TOUPPER
DISP0: ADD BX, 4
 CMP WORD PTR [BX], 0
 JNE DISP1
 RET
DISP1: CMP WORD PTR [BX], AX
 JNE DISP0
 ADD SP, 2
 JMP WORD PTR [BX+2] ; END OF DISPATCH
ENTER_REVIEW PROC NEAR
 TEST BYTE PTR STATES0, ENHANCED
 JZ ENRVW1
 STC ; ERROR
 RET
ENRVW1: MOV WORD PTR THISCURSOR, DX
 MOV AX, 64 ; DOS SEGMENT
 MOV ES, AX
 MOV AL, BYTE PTR ES:[23] ; SAVE OLD STATUS
 MOV BYTE PTR OLD2LOX, AL
 AND BYTE PTR ES:[23], NOT (1 SHL 5) ; CLEAR NUMLOCK
 MOV WORD PTR I9SWITCH, OFFSET I9SW02 ; ENTER REVIEW
 AND WORD PTR STATES1, NOT (DIGIT2 OR PH1FLAG OR PH2FLAG)
 CLC ; OKAY
 RET
ENTER_REVIEW ENDP
START_OPENPORT PROC NEAR
 CMP AL, '1' ; COM1?
 JB CPTR2
 CMP AL, '4' ; COM4?
 JA CPTR2
 MOV BL, AL ; SAVE COM#
 AND AX, 4 OR 2 OR 1
 ADD AX, 3
 CMP AX, WORD PTR VOXPORT
 JE CPTR2
 XOR AX, AX ; GET OLD INT VECTOR
 MOV ES, AX
 MOV BYTE PTR OPENPORT_COUNT, AL
 MOV BYTE PTR OPENPORT_WATCH, AL
 MOV AL, BL ; GET COM# BACK
 MOV AH, 1 SHL 4 ; IRQ4
 MOV DX, WORD PTR ES:[1024] ; COM1
 CMP AL, '1'
 JE CPTR1
 MOV DX, WORD PTR ES:[1028] ; COM3
 CMP AL, '3'
 JE CPTR1
 MOV AH, 1 SHL 3 ; IRQ3
 MOV DX, WORD PTR ES:[1026] ; COM2
 CMP AL, '2'
 JE CPTR1
 MOV DX, WORD PTR ES:[1030] ; COM4
 CMP AL, '4'
 JE CPTR1
 XOR DX, DX ; ERROR
CPTR1: TEST DX, DX
 JNZ CPTR3
CPTR2: MOV BX, OFFSET CPTRM
 STC ; ERROR
 RET
CPTR3: MOV BYTE PTR INT_MASK, AH ; IRQ MASK
 MOV WORD PTR COMBASE, DX
 CLI ; HOLD INTERRUPTS
 CMP AH, 1 SHL 4 ; IRQ4?
 JE CPTR4 ; IF YES
 MOV AX, WORD PTR ES:[44]
 MOV WORD PTR OLD_IRQ [0], AX
 MOV AX, WORD PTR ES:[46]
 MOV WORD PTR OLD_IRQ [2], AX
 MOV WORD PTR ES:[44], OFFSET REQUEST
 MOV WORD PTR ES:[46], DS
 JMP SHORT CPTR5
CPTR4: MOV AX, WORD PTR ES:[48]
 MOV WORD PTR OLD_IRQ [0], AX
 MOV AX, WORD PTR ES:[50]
 MOV WORD PTR OLD_IRQ [2], AX
 MOV WORD PTR ES:[48], OFFSET REQUEST
 MOV WORD PTR ES:[50], DS
CPTR5: INC DX ; INTERRUPT ENABLE REGISTER
 MOV AL, 1
 OUT DX, AL
 INC DX
 INC DX ; LINE CONTROL REGISTER
 MOV AL, 83H
 OUT DX, AL
 SUB DX, 3 ; BACK TO BASE ADDRESS
 MOV AX, 12 ; 9600 BAUD
 OUT DX, AL
 ADD DX, 3 ; BACK TO LINE CONTROL REGISTER
 MOV AL, 3 ; 8N1
 OUT DX, AL
 INC DX ; set modem-control register
 MOV AL, 8 OR 2 OR 1 ; DTR RTS and OUT2 bits
 OUT DX, AL
 SUB DX, 4 ; BACK TO BASE ADDRESS
 IN AL, DX ; CLEAR RX HOLD REGISTER
 IN AL, 33 ; GET PIC STATUS
 PUSH AX
 AND AL, BYTE PTR INT_MASK
 MOV BYTE PTR OLD_MASK, AL
 POP AX
 OR AL, BYTE PTR INT_MASK
 XOR AL, BYTE PTR INT_MASK
 OUT 33, AL
 STI ; TAKE INTERRUPTS
 OR WORD PTR STATES1, DATAFLOW
 MOV BX, OFFSET I9PRM38
 CLC ; SUCCESS
 RET
CPTRM DB RO, 'port not open', 0
START_OPENPORT ENDP
CLOSE_OPENPORT PROC NEAR
 MOV DX, WORD PTR COMBASE
 INC DX ; set interrupt-enable register
 XOR AL, AL
 OUT DX, AL
 IN AL, 33 ; GET PIC STATUS
 OR AL, BYTE PTR OLD_MASK
 OUT 33, AL
 AND WORD PTR STATES1, NOT DATAFLOW
 CLI ; HOLD INTERRUPTS
 XOR AX, AX
 MOV ES, AX
 CMP BYTE PTR INT_MASK, 1 SHL 4 ; IRQ4?
 JE RELEASE1 ; IF YES
 MOV AX, WORD PTR OLD_IRQ[0]
 MOV WORD PTR ES:[44], AX
 MOV AX, WORD PTR OLD_IRQ[2]
 MOV WORD PTR ES:[46], AX
 JMP SHORT RELEASE2
RELEASE1: MOV AX, WORD PTR OLD_IRQ[0]
 MOV WORD PTR ES:[48], AX
 MOV AX, WORD PTR OLD_IRQ[2]
 MOV WORD PTR ES:[50], AX
RELEASE2: STI ; TAKE INTERRUPTS
 RET
CLOSE_OPENPORT ENDP
REQUEST: PUSH AX ; READ DATA FOR OPENPORT
 PUSH DS
 MOV AX, CS
 MOV DS, AX
 PUSH CX
 PUSH DX
 MOV DX, WORD PTR COMBASE
 IN AL, DX ; ACCEPT CHAR
 CMP AL, BSP ; CHECK FOR GARBAGE
 JE RQST1 ; IF OKAY
 CMP AL, TAB
 JE RQST1 ; IF OKAY
 CMP AL, CR
 JE RQST1 ; IF OKAY
 CMP AL, SPC
 JB RQST3 ; IF GARBAGE
 TEST AL, 1 SHL 7
 JNZ RQST3 ; IF GARBAGE
RQST1: CBW ; STUFF IT
 MOV CX, AX
 INC BYTE PTR OPENPORT_COUNT
 CMP BYTE PTR OPENPORT_COUNT, 14
 JB RQST2
 MOV AX, 8 OR 1 ; STOP SENDING -- DROP RTS
 ADD DX, 4
 OUT DX, AL
 AND WORD PTR STATES1, NOT DATAFLOW
RQST2: MOV AX, 5 SHL 8
 PUSHF
 CALL DWORD PTR I22RETURN+1
RQST3: POP DX
 POP CX
 POP DS
 MOV AX, 32
 OUT 32, AL
 POP AX
 IRET ; END OF REQUEST
OPENPORT_COUNT DB 0
OPENPORT_WATCH DB 0
EXIT_REVIEW PROC NEAR
 MOV AX, 64 ; DOS SEGMENT
 MOV ES, AX
 MOV AL, BYTE PTR OLD2LOX
 MOV BYTE PTR ES:[23], AL ; RESTORE OLD STATUS
 MOV BX, OFFSET I9PRM02 ; EXIT REVIEW
 RET
EXIT_REVIEW ENDP
FIXNAME PROC NEAR
 TEST AX, AX
 JNZ FXNM1
 MOV WORD PTR NAMESIZE, AX
 MOV DI, OFFSET TEMPNAME
 MOV CX, 15
 PUSH DS
 POP ES
 CLD
 REP STOSB
 MOV BX, OFFSET FXNMM1
 CALL SENDSTRING
 MOV BX, OFFSET BANKNAME
 CALL SENDSTRING
 MOV BX, OFFSET FXNMM2
 CALL SENDSTRING
 CLC ; CONTINUE
 RET
FXNM1: XOR AH, AH ; TRAILING ZERO
 MOV BX, WORD PTR NAMESIZE
 CMP AL, BSP
 JE FXNM3
 CMP AL, SPC ; DONE?
 JB FXNM5
 JA FXNM2
 TEST BX, BX
 JZ FXNM6
FXNM2: CALL TOUPPER
 MOV WORD PTR TEMPNAME[BX], AX
 PUSH BX
 CALL SAVE2DATA
 POP BX
 CMP BX, 14
 JNB FXNM5
 INC WORD PTR NAMESIZE
 CLC
 RET
FXNM3: TEST BX, BX
 JZ FXNM4
 DEC BX
 DEC WORD PTR NAMESIZE
 MOV AX, WORD PTR TEMPNAME[BX]
 PUSH BX
 CALL SAVE2DATA
 POP BX
 XOR AX, AX
 MOV WORD PTR TEMPNAME[BX], AX
FXNM4: CLC
 RET
FXNM5: MOV SI, OFFSET TEMPNAME
 MOV DI, OFFSET BANKNAME
 MOV CX, 15
 PUSH DS
 POP ES
 CLD
 REP MOVSB
FXNM6: STC
 RET
FXNMM1 DB 'current name', RO, 0
FXNMM2 DB RO, 'new name', RO, 'press space if okay', 0
NAMESIZE DW 0
TEMPNAME DB 15 DUP (0)
FIXNAME ENDP
REVIEW PROC NEAR
RVW01: TEST DX, DX ; CHARACTER LEFT
 JZ RVW09
 TEST DL, DL
 JNZ RVW02
 DEC DH
 MOV DL, BYTE PTR I8WIDTH
 MOV WORD PTR I8TONE, OFFSET I8RISE+2
RVW02: DEC DL
 JMP SHORT RVW04
RVW03: MOV AH, BYTE PTR I8LINE ; CHARACTER RIGHT
 MOV AL, BYTE PTR I8WIDTH
 DEC AL
 CMP DX, AX
 JE RVW09
 INC DL
 CMP DL, BYTE PTR I8WIDTH
 JL RVW04
 INC DH
 XOR DL, DL
 MOV WORD PTR I8TONE, OFFSET I8FALL
RVW04: AND WORD PTR STATES1, NOT (JOINED OR PH1FLAG OR PH2FLAG)
 MOV WORD PTR THISCURSOR, DX ; REMEMBER THIS
 CALL REGMUL
 CALL SAVE2DATA
 STC ; FOUND
 RET
RVW05: TEST DH, DH ; UP IF NOT 0
 JZ RVW09
 DEC DH
 JMP SHORT RVW07
RVW06: CMP DH, BYTE PTR I8LINE
 JE RVW09
 INC DH ; DOWN
RVW07: MOV WORD PTR THISCURSOR, DX ; REMEMBER THIS
 AND WORD PTR STATES1, NOT JOINED
RVW08: CALL GET1LINE
RVW09: STC ; FOUND
 RET
RVW10: MOV AX, DX
 CALL TELLCURSOR
 STC ; FOUND
 RET
RVW11: CALL REGMUL
 OR WORD PTR STATES1, PH1FLAG
 CALL SAVE2DATA
 STC ; FOUND
 RET
RVW13: TEST DL, DL ; WORD LEFT
 JNZ RVW14
 MOV DL, BYTE PTR I8WIDTH
 TEST DH, DH
 JZ RVW16
 DEC DH
 MOV WORD PTR I8TONE, OFFSET I8RISE+2
RVW14: DEC DL
 CALL REGMUL
 CMP AL, 33
 JL RVW13
RVW15: MOV SI, DX ; SAVE WITHOUT PUSH
 TEST DL, DL
 JZ RVW16
 DEC DL
 CALL REGMUL
 CMP AL, SPC
 JG RVW15
 MOV DX, SI
RVW16: MOV WORD PTR THISCURSOR, DX
 CALL GET1WORD
 AND WORD PTR STATES1, NOT JOINED
 STC ; FOUND
 RET
RVW17: CALL REGMUL
 CMP AL, 33
 JL RVW18
 INC DL
 CMP DL, CL
 JB RVW17
 CMP DH, BYTE PTR I8LINE
 JE RVW20
 XOR DL, DL
 INC DH
RVW18: CALL REGMUL
 CMP AL, SPC
 JG RVW16
 INC DL
 CMP DL, CL
 JB RVW18
 CMP DH, BYTE PTR I8LINE
 JE RVW20
 XOR DL, DL
 INC DH
 MOV WORD PTR I8TONE, OFFSET I8FALL
 JMP SHORT RVW18
RVW19: MOV AX, DX
 CALL TELLCURSOR
 MOV BX, OFFSET I9TSM01
 CALL SENDSTRING
 CALL GET1CHAR
RVW20: STC ; FOUND
 RET
RVW21: TEST DX, DX ; HOME
 JZ RVW20
 TEST  DL, DL
 JZ RVW22
 XOR DL, DL
 MOV WORD PTR I8TONE, OFFSET I8MID
 JMP SHORT RVW16
RVW22: XOR DH, DH
 MOV WORD PTR I8TONE, OFFSET I8RISE+2
 JMP RVW07
RVW23: TEST DH, DH ; PAGE UP
 JZ RVW20
 XOR DH, DH
 MOV WORD PTR I8TONE, OFFSET I8RISE+2
 JMP RVW16
RVW24: MOV AH, BYTE PTR I8LINE ; END
 MOV AL, BYTE PTR I8WIDTH
 DEC AL
 CMP DX, AX
 JE RVW20
 CMP DL, AL
 JE RVW25
 MOV DL, AL
 MOV WORD PTR I8TONE, OFFSET I8MID
 JMP RVW16
RVW25: MOV DH, AH
 MOV WORD PTR I8TONE, OFFSET I8FALL
 JMP RVW16
RVW26: MOV AH, BYTE PTR I8LINE ; PAGE DOWN
 CMP DH, AH
 JE RVW20
 MOV DH, AH
 MOV WORD PTR I8TONE, OFFSET I8FALL
 JMP RVW16
REVIEW ENDP
INSERT PROC NEAR
 CMP AX, 28 SHL 8 + 13 ; CR?
 JE INS4
 CMP AX, 224 SHL 8 + 13 ; CR?
 JE INS4
 CMP AH, 82 ; INSERT?
 JE INS4
 MOV BL, BYTE PTR SCANSIZE
 XOR BH, BH
 CMP BL, 8 ; MAX SIZE 9
 JG INS4
 CMP AX, 14 SHL 8 + 8 ; BACKSPACE?
 JE INS1
 MOV BYTE PTR SCANTERM[BX], AL
 INC BL
 JMP SHORT INS3
INS1: TEST BL, BL
 JNZ INS2
 RET
INS2: DEC BL
 MOV AL, BYTE PTR SCANTERM[BX]
INS3: MOV BYTE PTR SCANSIZE, BL
 JMP SAVE2DATA
INS4: MOV WORD PTR I9STATE, OFFSET I9DIRECT
 AND BYTE PTR STATES0, NOT BUZZER
 TEST BYTE PTR STATES0, ENHANCED
 JNZ INS5
 MOV WORD PTR I9STATE, OFFSET I9ST2
INS5: MOV BX, OFFSET I9PRM07
 JMP SENDSTRING
INSERT ENDP
SEARCH PROC NEAR
 CMP BYTE PTR SCANSIZE, 0
 JNE SRCH1
 MOV BYTE PTR SCANFIND, 0
 MOV BX, OFFSET SRCHM2
 CLC ; NO SCAN TARGET
 RET
SRCH1: MOV BYTE PTR SCANFLAG, AH ; SAVE DIRECTION
 MOV AL, BYTE PTR SCANSIZE
 CBW
 MOV CX, AX
 MOV AL, BYTE PTR I8WIDTH
 SUB AL, CL
 INC AL
 CMP BYTE PTR SCANFIND, 0
 JNE SRCH3
SRCH2: PUSH AX
 PUSH CX
 PUSH DX
 CALL SCANTEST
 POP DX
 POP CX
 POP AX
 JC SRCH7 ; IF FOUND
SRCH3: MOV BYTE PTR SCANFIND, 0
 CMP BYTE PTR SCANFLAG, 117 ; TEST DIRECTION
 JNE SRCH4 ; IF BACKWARD
 INC DL
 CMP DL, AL
 JL SRCH2
 CMP DH,BYTE PTR I8LINE
 JE SRCH6
 XOR DL, DL
 INC DH
 JMP SHORT SRCH2
SRCH4: CMP DL, DL
 JNZ SRCH5
 MOV DL, AL
 TEST DH, DH
 JZ SRCH6 ; IF DONE
 DEC DH
SRCH5: DEC DL
 JMP SHORT SRCH2
SRCH6: MOV BX, OFFSET I8MSG1
 CLC ; NOT FOUND
 RET
SRCH7: MOV WORD PTR THISCURSOR, DX ; RESET CURSOR
 AND WORD PTR STATES1, NOT JOINED
 MOV BYTE PTR SCANFIND, 1
 MOV AX, DX
 CALL TELLCURSOR
 CALL GET1WORD
 STC ; FOUND
 RET
SRCHM2 DB 'no target to scan', 0
SEARCH ENDP
SCANATT PROC NEAR
 MOV BYTE PTR SCANFLAG, AH
 CALL REGMUL
 MOV BYTE PTR DIGIT, AH
SCAN4A1: CMP BYTE PTR SCANFLAG, 118 ; TEST DIRECTION
 JNE SCAN4A2 ; IF BACKWARD
 INC DL
 CMP DL, BYTE PTR I8WIDTH
 JL SCAN4A4
 CMP DH, BYTE PTR I8LINE
 JE SCAN4A5
 MOV DL, 0
 INC DH
 JMP SHORT SCAN4A4
SCAN4A2: TEST DL, DL
 JNZ SCAN4A3
 MOV DL, BYTE PTR I8WIDTH
 TEST DH, DH
 JZ SCAN4A5 ; IF DONE
 DEC DH
SCAN4A3: DEC DL
SCAN4A4: CALL REGMUL
 CMP BYTE PTR DIGIT, AH
 JE SCAN4A1
 AND WORD PTR STATES1, NOT JOINED
 MOV WORD PTR THISCURSOR, DX ; RESET CURSOR
 MOV AX, DX
 CALL TELLCURSOR
 MOV BX, OFFSET I9TSM01
 CALL SENDSTRING
 CALL GET1CHAR
 STC ; FOUND
 RET
SCAN4A5: MOV BX, OFFSET I8MSG1
 CLC ; NOT FOUND
 RET
SCANATT ENDP
DEFAULTS PROC NEAR
 MOV AX, DS
 MOV ES, AX
 XOR AX, AX
 MOV DI, OFFSET BANKNAME
 MOV CX, BANKSIZE SHR 1 ; WORDS
 CLD
 REP STOSW
 MOV WORD PTR F3FLAG, F4DEF SHL 8 + F3DEF
 MOV WORD PTR F5FLAG, F6DEF SHL 8 + F5DEF
 MOV WORD PTR F7FLAG, F8DEF SHL 8 + F7DEF
 MOV WORD PTR F19FLAG, F20DEF SHL 8 + F19DEF
 MOV BX, AX
 MOV CX, 10
 MOV DH, BYTE PTR I8LINE
 INC DH
 MOV DL, BYTE PTR I8WIDTH
DFLTS1: MOV WORD PTR BANKTABLE[BX+2], 1 SHL 8 + 1
 MOV WORD PTR BANKTABLE[BX+4], DX
 ADD BX, 6
 LOOP DFLTS1
 CALL SET1ALERT
SET1IGNORE PROC NEAR
 PUSH CS
 POP ES
 MOV DI, OFFSET DEADSUB
 MOV AL, BYTE PTR BANKSUB[2]
 CALL GETSMART
 MOV AL, BYTE PTR BANKSUB[3]
 JMP GETSMART
SET1IGNORE ENDP
DEFAULTS ENDP
NAMELIST DW VOX1NAME, VOX2NAME, VOX3NAME, VOX4NAME, VOX5NAME
 DW VOX6NAME, VOX7NAME, VOX8NAME, VOX9NAME, VOX10NAME
VOX1NAME DB 'double talk L T', 0
VOX2NAME DB 'port talk', 0
VOX3NAME DB 'double talk p c', 0
VOX4NAME DB 'audapter', 0
VOX5NAME DB 'votrax p s s', 0
VOX6NAME DB 'braille and speak', 0
VOX7NAME DB 'accent', 0
VOX8NAME DB 'dectalk p c', 0
VOX9NAME DB 'lite talk', 0
VOX10NAME DB 'braille mate', 0
ISNUMBER PROC NEAR
 CMP AH, 71
 JB ISDIGIT1
 CMP AH, 82
 JA ISDIGIT1
ISDIGIT PROC NEAR
 CMP AL,'0'
 JB ISDIGIT1
 CMP AL,'9'
 JA ISDIGIT1
 STC ; YES
 RET
ISDIGIT1: CLC ; NO
 RET
ISDIGIT ENDP
ISNUMBER ENDP
TIMES6 PROC NEAR
 SHL AX, 1
 MOV BX, AX
 SHL AX, 1
 ADD BX, AX
 RET
TIMES6 ENDP
GET2DIGITS PROC NEAR
 AND AX, 8 OR 4 OR 2 OR 1
 MOV CX, AX
 MOV AL, BYTE PTR DIGIT
 AND AL, 8 OR 4 OR 2 OR 1
 MOV BL, 10
 MUL BL
 ADD AX, CX
 RET
GET2DIGITS ENDP
SCANTEST PROC NEAR
 MOV WORD PTR SCANTEMP, 0
SCANT1: PUSH CX
 PUSH DX
 CALL REGMUL
 MOV BX, WORD PTR SCANTEMP
 MOV AH, BYTE PTR SCANTERM[BX]
 INC WORD PTR SCANTEMP
 POP DX
 POP CX
 CMP AH, AL
 JNE SCANT2
 INC DL
 LOOP SCANT1
 STC ; FOUND IT
 RET
SCANT2: CLC ; NOT FOUND
 RET
SCANTEMP DW 0
SCANTEST ENDP
I9TEST PROC NEAR
 MOV BX, OFFSET TABLE3 - 4 ; SHARED COMMANDS
 CALL DISPATCH
 CLC ; NOT FOUND
 RET
I9TS03: MOV BX, OFFSET F3FLAG ; NUMBERS
 XOR BYTE PTR [BX], 1
 JMP SHORT I9TS12
I9TS04: MOV BX, OFFSET F4FLAG ; CAPITALS
 XOR BYTE PTR [BX], 1
 JMP SHORT I9TS12
I9TS05: MOV BX, OFFSET F5FLAG ; PUNCTUATION
 INC BYTE PTR [BX]
 CMP BYTE PTR [BX], 4 ; MAX
 JA I9TS11
 JMP SHORT I9TS12
I9TS07: MOV BX, OFFSET F7FLAG ; KEYSTROKE ECHO
 INC BYTE PTR [BX]
 CMP BYTE PTR [BX], 2 ; MAX
 JA I9TS11
 JMP SHORT I9TS12
I9TS08: MOV BX, OFFSET F8FLAG ; SCREEN ECHO
 INC BYTE PTR [BX]
 CMP BYTE PTR [BX], 2 ; MAX
 JA I9TS11
 JMP SHORT I9TS12
I9TS09: MOV BX, OFFSET F9FLAG ; SPEED
 INC BYTE PTR [BX]
 CMP BYTE PTR [BX], 3 ; MAX
 JA I9TS11
 JMP SHORT I9TS12
I9TS10: MOV BX, OFFSET F10FLAG ; VOLUME
 INC BYTE PTR [BX]
 CMP BYTE PTR [BX], 4 ; MAX+1
 JB I9TS12
I9TS11: MOV BYTE PTR [BX], 0 ; RESET
I9TS12: MOV AX, 1 SHL 7 OR '0'
 ADD AL, BYTE PTR [BX]
 JMP SAVE1DATA
I9TS28: MOV BX, OFFSET I9TSM02
 MOV AL, BYTE PTR F3FLAG
 CALL SENDSTATUS
 MOV BX, OFFSET I9TSM03
 MOV AL, BYTE PTR F4FLAG
 CALL SENDSTATUS
 MOV BX, OFFSET I9TSM04
 MOV AL, BYTE PTR F5FLAG
 CALL SENDSTATUS
 MOV BX, OFFSET I9TSM05
 MOV AL, BYTE PTR F6FLAG
 CALL SENDSTATUS
 MOV BX, OFFSET I9TSM06
 MOV AL, BYTE PTR F7FLAG
 CALL SENDSTATUS
 MOV BX, OFFSET I9TSM07
 MOV AL, BYTE PTR F8FLAG
 CALL SENDSTATUS
 MOV BX, OFFSET I9TSM08
 MOV AL, BYTE PTR F9FLAG
 CALL SENDSTATUS
 MOV BX, OFFSET I9TSM09
 MOV AL, BYTE PTR F10FLAG
 JMP SENDSTATUS
I9TS29: MOV BX, OFFSET I9TLM1
 CALL SENDSTRING
 MOV AX, 64 ; DOS SEGMENT
 MOV ES, AX
 MOV AL, BYTE PTR ES:[23] ; GET STATUS
 PUSH AX
 AND AL, 1 SHL 6 ; CAPS?
 CALL LOCKSTATUS
 MOV BX, OFFSET I9TLM2
 CALL SENDSTRING
 POP AX
 PUSH AX
 AND AL, 1 SHL 5 ; NUM?
 CALL LOCKSTATUS
 MOV BX, OFFSET I9TLM3
 CALL SENDSTRING
 POP AX
 AND AL, 16 ; SCROLL?
 CALL LOCKSTATUS
 MOV BX, OFFSET I9TLM7
 CALL SENDSTRING
 MOV AL, BYTE PTR STATES0
 AND AX, ENHANCED
 CALL LOCKSTATUS
 MOV BX, OFFSET I9PRM38
 TEST WORD PTR STATES1, PORTOPEN
 JNZ I9TS30
 MOV BX, OFFSET I9PRM37
I9TS30: CALL SENDSTRING
 MOV BX, OFFSET I9PRM40
 TEST BYTE PTR STATES2, EMAIL1
 JNZ I9TS31
 MOV BX, OFFSET I9PRM39
I9TS31: CALL SENDSTRING
 MOV BX, OFFSET I9TSM13
 MOV AX, WORD PTR CLIPCOUNT
 CALL TELL5DIGITS
 MOV BX, OFFSET I9TSM10
 CALL SENDSTRING
 MOV AL, BYTE PTR ES:[73]
 JMP SAVE3DIGITS ; AND RETURN
I9TS32: MOV AX, 64 ; TIME OF DAY
 PUSH ES
 MOV ES, AX
 MOV AL, BYTE PTR ES:[110]
 XOR BX, BX
 CMP AL, 12
 JB I9TS33
 MOV BX, OFFSET I9TSM11 ; PM
 SUB AL, 12
I9TS33: PUSH BX
 TEST AL, AL
 JNZ I9TS34
 MOV AL, 12
I9TS34: MOV BX, OFFSET I9TSM12
 CALL TELL3DIGITS
 MOV AL, BYTE PTR ES:[109]
 MOV BL, 60
 MUL BL
 XCHG AL, AH
 CALL SAVE3DIGITS
 POP BX
 POP ES
 JMP SENDSTRING
I9TS35: CALL GETCLIP
 JMP SHORT I9TS39
I9TS36: MOV BX, WORD PTR CLIPCOUNT
 TEST BX, BX
 JZ I9TS39
 CMP BYTE PTR CLIPBOARD-1[BX], CR
 JNE I9TS37
 MOV WORD PTR CLIPCOUNT, 0
 JMP SHORT I9TS39
I9TS37: CMP BYTE PTR CLIPBOARD-1[BX], SPC
 JE I9TS38
 CMP BX, CLIPSIZE
 JNB I9TS38
 INC BX
 INC WORD PTR CLIPCOUNT
I9TS38: MOV BYTE PTR CLIPBOARD-1[BX], CR
I9TS39: MOV BX, OFFSET I9TSM14
 MOV AX, WORD PTR CLIPCOUNT
 JMP TELL5DIGITS ; AND RETURN
I9TSM01 DB 'contayns', 0
I9TSM02 DB 'provox function keys', RO
 DB 'f2 lock keys and modes', RO
 DB 'f3 numbers', 0
I9TSM03 DB 'f4 capitals', 0
I9TSM04 DB 'f5 punctuation', 0
I9TSM05 DB 'f6 smart screen', 0
I9TSM06 DB 'f7 keystroke echo', 0
I9TSM07 DB 'f8 screen echo', 0
I9TSM08 DB 'f9 speed', 0
I9TSM09 DB 'f ten', RO,'volume', 0
I9TSM10 DB RO, 'video mode', 0
I9TSM11 DB 'pm', 0
I9TSM12 DB 'its', 0
I9TSM13 DB RO, 'clip board', 0
I9TSM14 DB 'count=', 0
I9TEST ENDP
GETCLIP PROC NEAR
 MOV AL, SPC ; LINE SEPARATOR
 CALL SAVE4DATA
 MOV AL, BYTE PTR I8WIDTH
 MOV DX, WORD PTR THISCURSOR
 XOR DL, DL
GCLP1: PUSH AX ; SAVE LINE LENGTH
 CALL REGMUL
 CALL SAVE4DATA
 POP AX
 JC GCLP2 ; IF OVERFLOW
 INC DL
 CMP DL, AL
 JL GCLP1
 RET
GCLP2: MOV WORD PTR I8TONE, OFFSET I8WARBLE ; OVERFLOW ALARM
 RET
GETCLIP ENDP
SAVE4DATA PROC NEAR
 MOV BX, WORD PTR CLIPCOUNT
 CMP BX, CLIPSIZE
 JL SAVE4D1
 STC ; OVERFLOW
 RET
SAVE4D1: CMP AL, CR
 JE SAVE4D3
 CMP AL, SPC
 JL SAVE4D2
 TEST AL, 1 SHL 7
 JZ SAVE4D3
SAVE4D2: MOV AL, SPC
SAVE4D3: TEST BX, BX
 JNZ SAVE4D4
 CMP AL, SPC ; LEADING SPACE
 JE SAVE4D6
SAVE4D4: CMP AL, SPC ; NO CONSECUTIVE SPACES
 JNE SAVE4D5
 CMP BYTE PTR CLIPBOARD-1[BX], AL
 JE SAVE4D6
 CMP BYTE PTR CLIPBOARD-1[BX], CR
 JE SAVE4D6
SAVE4D5: MOV BYTE PTR CLIPBOARD[BX], AL
 INC WORD PTR CLIPCOUNT
SAVE4D6: CLC ; SUCCESSFUL
 RET
SAVE4DATA ENDP
REGMUL PROC NEAR
 MOV AX, 64 ; DOS SEGMENT
 PUSH ES
 MOV ES, AX
 MOV BX, WORD PTR ES:[78] ; PAGE OFFSET
 MOV CX, WORD PTR ES:[74] ; LINE WIDTH
 MOV AX, 0B800H ; CGA VIDEO SEGMENT
 CMP BYTE PTR ES:[73], 4
 JB RGML1
 MOV AX, 0B000H ; MODE 7 VIDEO SEGMENT
RGML1: MOV ES, AX
 XOR AX, AX
 PUSH DX
 XCHG AL, DH
 SHL DX, 1
 ADD BX, DX
 MUL CL
 SHL AX, 1
 ADD BX, AX
 MOV AX, WORD PTR ES:[BX]
 POP DX
 POP ES
 RET
REGMUL ENDP
TELLSUBS PROC NEAR
 MOV BX, OFFSET HTM13
 CALL SENDSTRING
 MOV AX, WORD PTR TEMPSUB+2
 DEC AH
 DEC AL
 CALL TELLCURSOR
 MOV BX, OFFSET HTM17
 CALL SENDSTRING
 MOV AX, WORD PTR TEMPSUB+4
 DEC AH
 DEC AL
TELLCURSOR PROC NEAR
 PUSH AX
 MOV BX, OFFSET I8MSG10
 CALL SENDSTRING
 POP AX
 PUSH AX
 INC AX
 CALL SAVE3DIGITS
 MOV BX, OFFSET I8MSG9
 CALL SENDSTRING
 POP AX
 MOV AL, AH
 INC AX
 JMP SAVE3DIGITS
TELLCURSOR ENDP
HTM13 DB 'top left', 0
HTM17 DB 'bottom right', 0
TELLSUBS ENDP
TELLFILTER PROC NEAR
 MOV BX, OFFSET TLFM1
 MOV AX, WORD PTR TEMPSUB
 TEST AX, AX
 JZ TLF5
CMP AL, 64 OR 32 OR 16 OR 8 OR 4 OR 2 OR 1
 JE TLF1
CMP AL, 64 OR 32 OR 16 OR 4 OR 2 OR 1
 JE TLF1
CMP AL, 64 OR 32 OR 16 OR 8
 JE TLF1
CMP AL, 64 OR 32 OR 16
 JE TLF1
CMP AL, 8 OR 4 OR 2 OR 1
 JE TLF1
CMP AL, 4 OR 2 OR 1
 JE TLF1
CMP AL, 8
 JE TLF1
 PUSH AX
 MOV BX, OFFSET TLFM2
 CALL TELL3DIGITS
 POP AX
 XCHG AH, AL
 MOV BX, OFFSET TLFM3
 JMP TELL3DIGITS
TLF1: XCHG AH, AL
 PUSH AX
 SHR AX, 1
 SHR AX, 1
 SHR AX, 1
 SHR AX, 1
 AND AH, 4 OR 2 OR 1
 CMP AH, 4 OR 2 OR 1
 JNE TLF2
 MOV BX, OFFSET TLFM4
 AND AL, 4 OR 2 OR 1
 CALL TELL3DIGITS
TLF2: POP AX
 PUSH AX
 AND AH, 4 OR 2 OR 1
 CMP AH, 4 OR 2 OR 1
 JNE TLF3
 MOV BX, OFFSET TLFM5
 AND AL, 4 OR 2 OR 1
 CALL TELL3DIGITS
TLF3: POP AX
 AND AH, 8
 JNZ TLF4
 RET
TLF4: MOV BX, OFFSET TLFM6
 AND AL, 8
 JNZ TLF5
 MOV BX, OFFSET TLFM7
TLF5: JMP SENDSTRING
TLFM1 DB RO, 'no filter', 0
TLFM2 DB RO, 'bit mask', 0
TLFM3 DB RO, 'bit value', 0
TLFM4 DB RO, 'back ground', 0
TLFM5 DB RO, 'fore ground', 0
TLFM6 DB RO, 'high intensity', 0
TLFM7 DB RO, 'low intensity', 0
TELLFILTER ENDP
GET1CHAR PROC NEAR
 CALL REGMUL
 CALL SAVE2DATA
 MOV AL, AH
 PUSH AX
 MOV BX, OFFSET TLFM4
 CALL SENDSTRING
 POP AX
 PUSH AX
 AND AX, 7 SHL 4
 MOV CL, 3
 SHR AX, CL
 MOV BX, AX
 MOV BX, WORD PTR GET1COLOR[BX]
 CALL SENDSTRING
 MOV BX, OFFSET TLFM5
 CALL SENDSTRING
 POP AX
 TEST AL, 1 SHL 7 ; BLINKING?
 JZ GET1C1 ; IF NOT
 PUSH AX
 MOV BX, OFFSET GET1CM3
 CALL SENDSTRING
 POP AX
GET1C1: AND AX, 15
 SHL AX, 1 ; TIMES 2
 MOV BX, AX
 MOV BX, WORD PTR GET1COLOR[BX]
 CALL SENDSTRING
GET1C3: RET
GET1CM3 DB 'blinking', 0
GET1COLOR DW GET1CM5,GET1CM6,GET1CM7,GET1CM8
 DW GET1CM9,GET1CM10,GET1CM11,GET1CM12
 DW GET1CM13,GET1CM14,GET1CM15,GET1CM16
 DW GET1CM17,GET1CM18,GET1CM19,GET1CM20
GET1CM5 DB 'black (0)', 0
GET1CM6 DB 'blue (1)', 0
GET1CM7 DB 'green (2)', 0
GET1CM8 DB 'cyan (3)', 0
GET1CM9 DB 'red (4)', 0
GET1CM10 DB 'magenta (5)', 0
GET1CM11 DB 'brown (6)', 0
GET1CM12 DB 'light gray (7)', 0
GET1CM13 DB 'dark gray (8)', 0
GET1CM14 DB 'light blue (9)', 0
GET1CM15 DB 'light green (10)', 0
GET1CM16 DB 'light cyan (11)', 0
GET1CM17 DB 'light red (12)', 0
GET1CM18 DB 'light magenta (13)', 0
GET1CM19 DB 'yellow (14)', 0
GET1CM20 DB 'white (15)', 0
GET1CHAR ENDP
GET1LINE PROC NEAR
 MOV AL, DH ; CURSOR LINE
 INC AL
 MOV BX, OFFSET I8MSG9
 CALL TELL3DIGITS
GET2LINE PROC NEAR
 MOV WORD PTR TEMPSUB+0, 0
 MOV AL, BYTE PTR I8WIDTH
 XOR DL, DL
SCAN1LINE PROC NEAR
 MOV BYTE PTR SCAN1LC1, 0
 PUSH CX
SCAN1L1: PUSH AX ; SAVE LINE LENGTH
 CALL REGMUL
 CMP AL, SPC ; DROP CTRL CHARS
 JL SCAN1L3 ; IF SO
 CMP BYTE PTR HL1TEST, 1 ; TEST FOR HIGHLIGHTS?
 JNE SCAN1L4 ; IF NOT
 TEST AH, 1 SHL 3 ; INTENSITY BIT
 JNZ SCAN1L4 ; IF HIGHLIGHT
SCAN1L3: MOV AL, SPC
SCAN1L4: CMP BYTE PTR TEMPSUB+0, 0
 JE SCAN1L5
 AND AH, BYTE PTR TEMPSUB+0
 CMP AH, BYTE PTR TEMPSUB+1
 JE SCAN1L5
 MOV AL, SPC
SCAN1L5: CALL SAVE1DATA
 CMP AL, SPC
 JE SCAN1L6 ; IF SO
 MOV BYTE PTR SCAN1LC1, 1
SCAN1L6: POP AX
 INC DL
 CMP DL, AL
 JL SCAN1L1
 CMP BYTE PTR SCAN1LC1, 0 ; BLANK LINE?
 JE SCAN1L7 ; IF SO
 PUSH AX
 MOV AX, CR
 CALL SAVE3DATA
 POP AX
SCAN1L7: POP CX
 RET
SCAN1LC1 DB 0
SCAN1LINE ENDP
GET2LINE ENDP
GET1LINE ENDP
TEST1LINE PROC NEAR
 MOV AL, BYTE PTR I8WIDTH
 XOR DL, DL
TS1L1: PUSH AX ; SAVE LINE LENGTH
 CALL REGMUL
 CMP AL, SPC ; IGNORE CTRL CHARS
 JNA TS1L2 ; IF NOT
 CMP AL, RO
 JB TS1L3 ; FOUND NON BLANK
TS1L2: POP AX
 INC DL
 CMP DL, AL
 JL TS1L1
 STC ; BLANK LINE
 RET
TS1L3: POP AX
 CLC ; HAS NON BLANKS
 RET
TEST1LINE ENDP
TELL3DIGITS PROC NEAR
 PUSH AX
 CALL SENDSTRING
 POP AX
SAVE3DIGITS PROC NEAR
 MOV WORD PTR DIGITS[0], SPC SHL 8 OR SPC
 MOV WORD PTR DIGITS[2], '0'
 PUSH AX
 PUSH BX
 XOR AH, AH
 MOV BL,'0'
 CMP AX, 10 ; ONE DIGIT?
 JB SV3D4 ; IF YES
 CMP AX, 100 ; TWO DIGITS?
 JB SV3D2 ; IF YES
SV3D1: INC BL
 SUB AX, 100
 CMP AX, 100
 JNB SV3D1
 MOV BYTE PTR DIGITS[0], BL
 MOV BL,'0'
 CMP AL, 10
 JB SV3D3
SV3D2: INC BL
 SUB AX, 10
 CMP AX, 10
 JNB SV3D2
SV3D3: MOV BYTE PTR DIGITS[1], BL
SV3D4: ADD BYTE PTR DIGITS[2], AL
 MOV BX, OFFSET DIGITS
 CALL SENDSTRING
 POP BX
 POP AX
 RET
SAVE3DIGITS ENDP
TELL3DIGITS ENDP
TELL5DIGITS PROC NEAR
 PUSH AX
 CALL SENDSTRING
 POP AX
SAVE5DIGITS PROC NEAR
 MOV WORD PTR DIGITS[0], SPC SHL 8 OR SPC
 MOV WORD PTR DIGITS[2], SPC SHL 8 OR SPC
 MOV WORD PTR DIGITS[4], '0'
 PUSH AX
 PUSH BX
 MOV BL,'0'
 CMP AX, 10 ; ONE DIGIT?
 JB SV5D8 ; IF YES
 CMP AX, 100 ; TWO DIGITS?
 JB SV5D6 ; IF YES
 CMP AX, 1000 ; THREE DIGITS?
 JB SV5D4 ; IF YES
 CMP AX, 10000 ; FOUR DIGITS?
 JB SV5D2 ; IF YES
SV5D1: INC BL
 SUB AX, 10000
 CMP AX, 10000
 JNB SV5D1
 MOV BYTE PTR DIGITS[0], BL
 MOV BL,'0'
 CMP AX, 1000
 JB SV5D3
SV5D2: INC BL
 SUB AX, 1000
 CMP AX, 1000
 JNB SV5D2
SV5D3: MOV BYTE PTR DIGITS[1], BL
 MOV BL,'0'
 CMP AX, 100
 JB SV5D5
SV5D4: INC BL
 SUB AX, 100
 CMP AX, 100
 JNB SV5D4
SV5D5: MOV BYTE PTR DIGITS[2], BL
 MOV BL,'0'
 CMP AX, 10
 JB SV5D7
SV5D6: INC BL
 SUB AX, 10
 CMP AX, 10
 JNB SV5D6
SV5D7: MOV BYTE PTR DIGITS[3], BL
SV5D8: ADD BYTE PTR DIGITS[4], AL
 MOV BX, OFFSET DIGITS
 CALL SENDSTRING
 POP BX
 POP AX
 RET
SAVE5DIGITS ENDP
TELL5DIGITS ENDP
SAVE3DATA PROC NEAR
 CMP AL, SPC
 JA SAVE3D1
 MOV AX, SILENCE
SAVE3D1: OR AL, 1 SHL 7
 JMP SHORT SAVE1DATA ; SPEAK IT
SAVE3DATA ENDP
SENDSTATUS PROC NEAR
 PUSH AX
 CALL SENDSTRING
 MOV BX, OFFSET I8MSG11
 CALL SENDSTRING
 POP AX
 ADD AL,'0'
 CALL SAVE1DATA
 MOV AX, RO
SAVE1DATA PROC NEAR
 CMP BYTE PTR F7FLAG, 2 ; WHOLE WORDS?
 JB SAVE1D1 ; IF NOT
 CMP BYTE PTR I8WAIT1, 2
 JB SAVE1D1
 CMP AL, 1 SHL 7 OR SPC
 JNE SAVE1D1
 AND AL, NOT (1 SHL 7)
SAVE1D1: PUSH ES
 PUSH DS
 POP ES
 PUSH SI
 PUSH DI
 PUSH AX
 PUSH BX
SAVE1D2: CALL EMAILFILTER
 TEST AX, AX
 JZ SAVE1D9
 MOV BX, WORD PTR BUFTAIL
 MOV BYTE PTR [BX], AL
 INC BX
 CMP BX, OFFSET BUFFER+BUFSIZE
 JB SAVE1D3
 MOV BX, OFFSET BUFFER
SAVE1D3: MOV WORD PTR BUFTAIL, BX
 SUB BX, WORD PTR BUFHEAD
 JNZ SAVE1D4
 MOV WORD PTR I8TONE, OFFSET I8WARBLE ; OVERFLOW ALARM
SAVE1D4: CMP BX, 32
 JA SAVE1D8
 TEST AL, 1 SHL 7 ; FROM SCREEN OR KEYSTROKE?
 JZ SAVE1D5 ; IF SCREEN
 CMP BYTE PTR F7FLAG, 2
 JB SAVE1D7 ; IF 0, 1
 AND AL, NOT (1 SHL 7)
 JMP SHORT SAVE1D6
SAVE1D5: CMP BYTE PTR F8FLAG, 2
 JB SAVE1D7 ; IF 0, 1,
SAVE1D6: CALL ISALPHA
 JNC SAVE1D7
 MOV BYTE PTR I8WAIT1, 18
 JMP SHORT SAVE1D8
SAVE1D7: MOV BYTE PTR I8WAIT1, 1 ; SKIP A BEAT
SAVE1D8: TEST BYTE PTR STATES2, EMAIL2 ; DUMPING?
 JZ SAVE1D9 ; IF NOT
 XOR AX, AX
 JMP SHORT SAVE1D2
SAVE1D9: POP BX
 POP AX
 POP DI
 POP SI
 POP ES
 STC ; FOUND
 RET
SAVE1DATA ENDP
SENDSTATUS ENDP
EMAILFILTER PROC NEAR
 TEST BYTE PTR STATES2, EMAIL1 ; active?
 JZ EMLF4 ; RETURN if not
 TEST BYTE PTR STATES2, EMAIL2 ; DUMPING?
 JNZ EMLF6 ; IF YES
 TEST AL, 1 SHL 7 ; FROM KEYBOARD?
 JNZ EMLF1 ; IF YES
 TEST BYTE PTR STATES2, EMAIL3 ; IGNORING?
 JNZ EMLF3 ; IF YES
EMLF1: AND BYTE PTR STATES2, NOT EMAIL3 ; QUIT IGNORING
 MOV BX, WORD PTR EMLP1 ; SAVE THE CHAR
 MOV BYTE PTR EMLBUF1[BX], AL
 OR AL, 1 SHL 5
 MOV BYTE PTR EMLBUF2[BX], AL
 INC WORD PTR EMLP1
 MOV BX, OFFSET EMAILLIST ; START TESTING
EMLF2: MOV DI, WORD PTR [BX]
 TEST DI, DI
 JZ EMLF5 ; ALL TESTS FAILED
 MOV SI, OFFSET EMLBUF2
 INC BX
 INC BX
 MOV CX, WORD PTR EMLP1 ; COUNT
 CLD
 REPZ CMPSB
 JNZ EMLF2 ; ONE TEST FAILED
 CMP BYTE PTR [DI], 0
 JNE EMLF3 ; NO MATCH
 MOV BYTE PTR STATES2, EMAIL1 OR EMAIL3 ; IGNORE FURTHER DATA
 MOV WORD PTR EMLP1, 0
EMLF3: XOR AX, AX ; CONTINUE
EMLF4: RET
EMLF5: MOV BYTE PTR STATES2, EMAIL1 OR EMAIL2 ; START DUMPING
 MOV WORD PTR EMLP2, 0
EMLF6: MOV BX, WORD PTR EMLP2
 MOV AL, BYTE PTR EMLBUF1[BX]
 INC BX
 MOV WORD PTR EMLP2, BX
 CMP BX, WORD PTR EMLP1 ; FINISHED?
 JB EMLF7 ; IF NOT
 AND BYTE PTR STATES2, NOT EMAIL2 ; QUIT DUMPING
 MOV WORD PTR EMLP1, 0
EMLF7: RET
EMLBUF1 DB 20 DUP (?) ; FOR DUMPING
EMLBUF2 DB 20 DUP (?) ; FOR TESTING
EMLP1 DW 0
EMLP2 DW 0
EMAILLIST DW EML1, EML2, EML3, EML4, EML5, EML6, EML7, EML8, EML9
 DW EML10, EML11, EML12, EML13, EML14, EML15, EML16, EML17, EML18
 DW EML19, EML20, EML21, EML22, EML23, EML24, EML25, EML26
 DW EML27, EML28, EML29, EML30, 0
EML1 DB 'x-authentication-', 0
EML2 DB 'x-listprocess', 0
EML3 DB 'mime version:', 0
EML4 DB 'mime-version:', 0
EML5 DB 'organization:', 0
EML6 DB 'in-reply-to:', 0
EML7 DB 'return-path:', 0
EML8 DB 'x-pop3-rcpt:', 0
EML9 DB 'x-priority:', 0
EML10 DB 'message-id:', 0
EML11 DB 'precedence:', 0
EML12 DB 'errors-to:', 0
EML13 DB 'content-t', 0
EML14 DB 'boundary=', 0
EML15 DB 'received:', 0
EML16 DB 'reply-to:', 0
EML17 DB 'x-mailer:', 0
EML18 DB 'x-msmail-', 0
EML19 DB 'x-sender:', 0
EML20 DB 'x-status:', 0
EML21 DB 'resent-', 0
EML22 DB 'sender:', 0
EML23 DB 'status:', 0
EML24 DB 'x-juno-', 0
EML25 DB 'x-vms-', 0
EML26 DB 'date:', 0
EML27 DB 'subj:', 0
EML28 DB ' id ', 0
EML29 DB 'cc:', 0
EML30 DB 'to:', 0
EMAILFILTER ENDP
; DATA AND CODE FOR I16 -- VIDEO
I16LAST DW 0 ; AH/AL OF LAST WAC/WCO/WTT
I16ENTRY: PUSH DS ; USE THE CALLER STACK
 PUSH CS
 POP DS
 TEST BYTE PTR STATES0, ANSI2FLAG
 JZ I16PREP2
 TEST BYTE PTR STATES0, ANSI1FLAG
 JZ I16PREP1
 AND BYTE PTR STATES0, NOT ANSI1FLAG
 JMP SHORT I16EXIT
I16PREP1: CMP WORD PTR AX_SAVE, AX
 JNE I16SKIP
 AND BYTE PTR STATES0, NOT ANSI2FLAG
 JMP SHORT I16SKIP
I16PREP2: CMP AH, 9
 JE I16INIT
 CMP AH, 10
 JE I16INIT
 CMP AH, 14
 JE I16INIT
 CMP WORD PTR AX_SAVE, 2 SHL 8 OR CR
 JNE I16EXIT
 CMP AX, WORD PTR I8MODE; AH=8, AL=MODE?
 JNE I16EXIT
 OR BYTE PTR STATES0, ANSI1FLAG OR ANSI2FLAG
I16EXIT: MOV WORD PTR AX_SAVE, AX
I16SKIP: POP DS
I16RETURN DB 234 ; FAR JUMP
 DD ? ; ORIGINAL I6 VECTOR
I16INIT: MOV WORD PTR AX_SAVE, AX
 MOV WORD PTR BX_SAVE, BX
 CMP WORD PTR VOXNUMBER, MAXVOXNUM SHL 1 ; INITIALIZED?
 JE I16PREP3
 TEST WORD PTR STATES1, CLOSED
 JNZ I16PREP3
 OR BYTE PTR STATES0, WATCHDOG
I16PREP3: PUSH BX
 PUSH CX
 PUSH DX
 PUSH ES
 PUSH 64 ; DOS SEGMENT
 POP ES
 MOV BX, WORD PTR I16LAST ; LAST AH/AL
 CMP AX, BX ; SAME CHAR, SAME SERVICE?
 JE I16GOOD ; IF SO
 CMP AL, BL ; SAME CHAR, DIFFERENT SERVICE?
 JE I16QUIT0 ; IF SO
 MOV WORD PTR I16LAST, AX ; SAVE NEW CHAR AND SERVICE
I16GOOD: TEST AL, 1 SHL 7 ; FUNNY CHAR?
 JNZ I16QUIT0 ; IF SO
 CMP WORD PTR LAST1IN, 0 ; FROM SYSTEM?
 JE I16STEP2 ; IF SO
 CMP AL, BSP ; BACKSPACE?
 JNE I16STEP1 ; IF NOT
 XOR WORD PTR STATES1, I16FLIP ; TOGGLE
I16QUIT0: JMP SHORT I16QUIT
I16STEP1: TEST WORD PTR STATES1, I16FLIP ; SWITCH ON?
 JNZ I16QUIT ; IGNORE IF SO
I16STEP2: PUSH AX ; FIND CURSOR
 MOV BX, 80
 MOV AL, BYTE PTR ES:[98] ; PAGE
 CBW
 SHL AX, 1
 ADD BX, AX
 MOV BX, WORD PTR ES:[BX]
 MOV DX, WORD PTR LASTCURSOR
 MOV WORD PTR LASTCURSOR, BX
 POP AX
 CMP BYTE PTR LATER,';' ; WAITING FOR CURSOR TO MOVE?
 JNE I16STEP3 ; IF NOT
 CMP DX, BX ; SAME POSITION?
 JE I16QUIT ; IF SO
I16STEP3: CMP DL, BL ; RETRO MOVEMENT?
 JA I16STEP4 ; IF NOT
 CMP DH, BH ; SAME LINE?
 JE I16STEP5 ; IF SO
I16STEP4: OR BYTE PTR STATES3, ENDOFLINE
I16STEP5: CMP BYTE PTR F6FLAG, 1 ; DEAD ZONE?
 JNE I16KEEP
 CALL DEADZONE
 JC I16QUIT
I16KEEP: CALL TEST1CHAR
 JC I16QUIT
 MOV BH, BYTE PTR BX_SAVE[1]
 CMP BYTE PTR ES:98, BH ; SAME PAGE?
 JNE I16SAVE ; IF NOT
 TEST BYTE PTR STATES3, ENDOFLINE
 JZ I16SAVE ; IF NOT
 AND BYTE PTR STATES3, NOT ENDOFLINE
 PUSH AX
 MOV AX, 1 SHL 7 OR CR ; END OF LINE
 CALL SAVE1DATA
 POP AX
I16SAVE: CALL SAVE1DATA
I16QUIT: POP ES
 POP DX
 POP CX
 POP BX
 MOV AX, WORD PTR AX_SAVE
 JMP I16EXIT ; END OF CODE FOR I16
TEST1CHAR PROC NEAR
 MOV AH, AL ; KEEP AL, TEST AH
 CMP AH, SPC
 JE TEST1C2 ; IF YES
 CMP AH, CR
 JNE TEST1C1 ; IF NOT
 MOV AL, 31 ; USE RS FOR CR
TEST1C1: CMP BYTE PTR LAST1IN, TAB ; CHAR AFTER TAB?
 JE TEST1C5 ; IF SO
 CMP WORD PTR LAST1IN, 0 ; FROM SYSTEM?
 JE TEST1C6 ; IF YES
 CMP AH, BYTE PTR LAST1IN ; FROM KEYBOARD?
 JE TEST1C3 ; IF SO
 CMP BYTE PTR LAST1IN,'^' ; CONTROL CHAR?
 JE TEST1C3 ; IF SO
 MOV BYTE PTR LAST1IN, AH
 CMP AH,'^' ; CTRL CHAR?
 JE TEST1C4 ; IF SO
 JMP SHORT TEST1C5 ; MUST BE FROM SYSTEM
TEST1C2: CMP BYTE PTR LAST1IN, SPC ; AFTER SPACE?
 JE TEST1C3 ; IF SO
 CMP BYTE PTR LAST1IN, TAB ; AFTER TAB?
 JE TEST1C4 ; IF SO
 MOV WORD PTR LAST1IN, 0 ; FROM SYSTEM
 JMP SHORT TEST1C6
TEST1C3: MOV WORD PTR LAST1IN, 0 ; DROP CHAR
TEST1C4: STC ; DROP CHAR
 RET
TEST1C5: MOV WORD PTR LAST1IN, 0 ; DROP CHAR
TEST1C6: CMP BYTE PTR F8FLAG, 0 ; KEEP SCREEN CHAR?
 JE TEST1C4 ; IF NOT
 CMP BYTE PTR F5FLAG, 3 ; MAX DETAIL?
 JE TEST1C7 ; IF SO
 CMP AL, SPC ; CTRL CHAR?
 JB TEST1C4 ; IF SO
TEST1C7: CLC ; KEEP CHAR
 RET
TEST1CHAR ENDP
SAVE2DATA PROC NEAR
 PUSH AX
 CMP AL, BSP
 JE SAVE2D3 ; IF SO
 MOV BX, OFFSET SAVE2DM1
 CMP AL, TAB
 JE SAVE2D1 ; IF SO
 MOV BX, OFFSET SAVE2DM2
 CMP AL, ESCP
 JE SAVE2D1 ; IF SO
 TEST AL, AL ; ARROWS?
 JNZ SAVE2D2 ; IF NOT
 CMP AH, 3 ; CONTROL @?
 JE SAVE2D2 ; IF SO
 MOV BX, OFFSET SAVE2DM3
 CMP AH, 15 ; TAB LEFT?
 JE SAVE2D1 ; IF SO
 MOV BX, OFFSET SAVE2DM4
 CMP AH, 71 ; HOME?
 JE SAVE2D1 ; IF SO
 MOV BX, OFFSET SAVE2DM5
 CMP AH, 73 ; PAGE UP?
 JE SAVE2D1 ; IF SO
 MOV BX, OFFSET SAVE2DM6
 CMP AH, 79 ; END?
 JE SAVE2D1 ; IF SO
 MOV BX, OFFSET SAVE2DM7
 CMP AH, 81 ; PAGE DOWN?
 JE SAVE2D1 ; IF SO
 MOV BX, OFFSET SAVE2DM8
 CMP AH, 82 ; INSERT?
 JE SAVE2D1 ; IF SO
 MOV BX, OFFSET SAVE2DM9
 CMP AH, 83 ; DELETE?
 JNE SAVE2D3 ; IF NOT
SAVE2D1: CALL SENDSTRING
 JMP SHORT SAVE2D3
SAVE2D2: CALL TELL1CHAR
SAVE2D3: POP AX
SAVE2D4: RET
SAVE2DM1 DB 'tab', 0
SAVE2DM2 DB 'escape', 0
SAVE2DM3 DB 'tab left', 0
SAVE2DM4 DB 'home', 0
SAVE2DM5 DB 'page up', 0
SAVE2DM6 DB 'end', 0
SAVE2DM7 DB 'page down', 0
SAVE2DM8 DB 'insert', 0
SAVE2DM9 DB 'delete', 0
SAVE2DATA ENDP
STOPVOX PROC NEAR
 AND WORD PTR STATES1, NOT HOLDING
 MOV WORD PTR SHELFCOUNT, 0
 MOV BYTE PTR I8WAIT1, 0
 PUSH AX
 PUSH BX
 PUSH DX
 MOV WORD PTR BUFHEAD, OFFSET BUFFER
 MOV WORD PTR BUFTAIL, OFFSET BUFFER
 MOV BX, WORD PTR VOXNUMBER
 CALL WORD PTR HUSHLIST[BX]
 POP DX
 POP BX
 POP AX
 CLC
DUMMY PROC NEAR
 RET
DUMMY ENDP
HUSHLIST DW VOX2HUSH, VOX2HUSH
 DW VOX3HUSH, VOX2HUSH, VOX5HUSH
 DW VOX2HUSH, VOX7HUSH
 DW VOX8HUSH, VOX2HUSH, VOX2HUSH
STOPVOX ENDP
; DATA AND CODE FOR I22 -- KEYBOARD
I22ENTRY: PUSH DS ; USE THE CALLER STACK
 PUSH CS
 POP DS
 CMP WORD PTR VOXNUMBER, MAXVOXNUM SHL 1 ; INITIALIZED?
 JE I22SKIP ; IF NOT
 TEST WORD PTR STATES1, CLOSED
 JNZ I22SKIP
 TEST AH, AH
 JZ I22INIT
 CMP AH, 1 SHL 4
 JE I22INIT
I22SKIP: POP DS
I22RETURN DB 234 ; FAR JUMP
 DD ? ; ORIGINAL I22 VECTOR
I22INIT: PUSH ES
 PUSH SI
 PUSH DI
 PUSH BX
 PUSH CX
 PUSH DX
 PUSHF
 CALL DWORD PTR I22RETURN+1
 PUSH AX
 CALL I22PROVOX
 POP AX
 CMP AL, CR
 JNE I22EXIT1
 PUSH AX
 CALL CONTEXT
 POP AX
I22EXIT1: TEST WORD PTR STATES1, PORTOPEN
 JZ I22EXIT2
 CALL STOPVOX
 DEC BYTE PTR OPENPORT_COUNT
 MOV BYTE PTR OPENPORT_WATCH, 0
 CMP BYTE PTR OPENPORT_COUNT, 1
 JA I22EXIT2
 TEST WORD PTR STATES1, DATAFLOW
 JNZ I22EXIT2
 PUSH AX
 MOV AX, 8 OR 2 OR 1 ; REQUEST TO SEND
 MOV DX, WORD PTR COMBASE
 ADD DX, 4 ; MODEM CONTROL REGISTER
 OUT DX, AL
 POP AX
 OR WORD PTR STATES1, DATAFLOW
I22EXIT2: POP DX
 POP CX
 POP BX
 POP DI
 POP SI
 POP ES
POP DS
 IRET ; END OF CODE FOR I22
CONTEXT PROC NEAR
 MOV AX, CS
 MOV ES, AX
 XOR AX, AX
 MOV DI, OFFSET I22SHELF
 MOV CX, 5
 CLD
 REP STOSW ; CLEAR THE SHELF
 MOV SI, WORD PTR I8VIDOFF
 MOV CL, BYTE PTR I8WIDTH
 MOV DX, WORD PTR I8CURSOR
 XOR AX, AX
 XCHG AL, DH
 MUL CL
 SHL AX, 1
 ADD SI, AX
 PUSH DS
 MOV DS, WORD PTR I8VIDSEG
 MOV DI, OFFSET I22SHELF
 MOV CX, DX
 CLD
 LODSW ; FIRST CHAR DRIVE LETTER?
 CALL ISALPHA
 JNC cTXT4 ; FAIL
 CLD
 LODSW ; SECOND CHAR ':'?
 CMP AL, ':'
 JNE CTXT4 ; FAIL
 CLD
 LODSW ; THIRD CHAR '\'?
 CMP AL, '\'
 JNE CTXT4 ; FAIL
CTXT2: CLD
 LODSW ; SUBDIRECTORY NAME?
 CMP AL, '>'
 JE CTXT5 ; SUCCESS!
 CMP AL, '\'
 JE CTXT3 ; CONTINUE
 CMP AL, '.'
 JE CTXT3 ; CONTINUE
 CALL ISDIGIT
 JC CTXT3 ; CONTINUE
 CALL ISALPHA
 JNC CTXT4 ; FAIL
CTXT3: LOOP CTXT2
CTXT4: POP DS
CT_EXIT: RET
CTXT5: CLD
 STOSB ; SAVE IT
 LODSW ; GET NEXT CHAR
 CALL ISDIGIT
 JC CTXT6 ; CONTINUE
 CALL ISUPPER
 JC CTXT6 ; CONTINUE
 CALL ISLOWER
 JNC CTXT7 ; FINISHED
 AND AL, NOT (1 SHL 5)
CTXT6: LOOP CTXT5
CTXT7: POP DS ; LOOK FOR MATCH
 CMP AL, ':' ; UNLESS THIS
 JE CTXT9
 MOV SI, OFFSET BANKNAME
 MOV DI, OFFSET I22SHELF
 MOV CX, 10
CTXT8: MOV AH, BYTE PTR ES:[DI]
 MOV AL, BYTE PTR DS:[SI]
 TEST AX, AX ; AH=0, AL=0 SUCCESS
 JZ CTXT9
 CMP AH, AL
 JNE CTXT10 ; NO MATCH HERE
 INC SI
 INC DI
 LOOP CTXT8
CTXT9: RET
CTXT10: MOV CX, 10
 MOV SI, OFFSET BANK0NAMe
CTXT11: PUSH CX
 PUSH SI
 MOV DI, OFFSET I22SHELF
 MOV CX, 10
CTXT12: MOV AH, BYTE PTR ES:[DI]
 MOV AL, BYTE PTR DS:[SI]
 TEST AX, AX ; AH=0, AL=0 SUCCESS
 JZ CTXT14
 CMP AH, AL
 JNE CTXT13 ; NO MATCH HERE
 INC SI
 INC DI
 LOOP CTXT12
CTXT13: POP SI
 POP CX
 ADD SI, BANKSIZE
 LOOP CTXT11
 RET ; NOT FOUND
CTXT14: POP SI ; FOUND
 POP CX
 MOV CX, BANKSIZE SHR 1
 MOV DI, OFFSET BANKNAME
 CLD
 REP MOVSW
 CALL SET1ALERT
 CALL SET1IGNORE
 MOV BX, OFFSET I8MSG6
 JMP SENDSTRING
CONTEXT ENDP
ANALYZE PROC NEAR
 PUSH AX
 PUSH BX
 PUSH CX
 PUSH DX
 PUSH ES
 PUSH DS
 POP ES
 MOV SI, OFFSET BOXES_THIS
 MOV DI, OFFSET BOXES_LAST
 MOV CX, NLZ1LENGTH SHR 1 ; NUMBER OF WORDS TO COPY
 CLD
 REP MOVSW ; MOVE NEW DATA TO OLD
 MOV DI, OFFSET BOXES_THIS
 MOV CX, NLZ1LENGTH SHR 1 ; NUMBER OF WORDS TO CLEAR
 XOR AX, AX
 CLD
 REP STOSW ; SET BOXES TO 0
 MOV DI, OFFSET CORNERS
 MOV CX, NLZ2LENGTH SHR 1 ; NUMBER OF WORDS TO CLEAR
 CLD
 REP STOSW ; SET CORNERS SUMS AND CRCS TO 0
 MOV AL, BYTE PTR I8LINE ; COMPUTE SCREEN SIZE
 INC AL
 MOV BL, BYTE PTR I8WIDTH
 MUL BL
 MOV CX, AX ; SCREEN SIZE
 MOV SI, WORD PTR I8VIDOFF
 XOR DI, DI ; FULL SCREEN CRC
 POP DS ; REVERSE SEGMENT REGS
 CLD
NLZ1: LODSW ; AH=ATTRIBUTE CODE, AL=CHARACTER CODE
 XOR DI, AX ; COMPUTE CRC
 ROL DI, 1
 TEST AL, 1 SHL 7 ; UPPER ASCII?
 JZ NLZ2 ; IF NOT
 CALL SETCORNERS
NLZ2: MOV DX, AX
 MOV AL, AH
 AND AX, 15 ; KEEP BITS 3, 2, 1, 0
 SHL AX, 1
 MOV BX, AX
 INC WORD PTR ES:FG_SUM[BX]
 MOV AX, WORD PTR ES:FG_CRC[BX]
 XOR AX, DX
 ROL AX, 1
 MOV WORD PTR ES:FG_CRC[BX], AX
 MOV AL, DH
 AND AX, 7 SHL 4 ; KEEP BITS 5, 6, 7
 SHR AX, 1
 SHR AX, 1
 SHR AX, 1
 MOV BX, AX
 INC WORD PTR ES:BG_SUM[BX]
 MOV AX, WORD PTR ES:BG_CRC[BX]
 XOR AX, DX
 ROL AX, 1
 MOV WORD PTR ES:BG_CRC[BX], AX
 LOOP NLZ1
 PUSH DS ; RESTORE REGS
 PUSH ES
 POP DS
 POP ES
 MOV WORD PTR CRC_THIS, DI ; SAVE CRC
 MOV CX, 4 ; GET FOUR BEST BG SCREENS
NLZ3: PUSH CX
 MOV CX, 8 ; SCAN BG SCREENS
 XOR AX, AX
 XOR BX, BX
NLZ3A: CMP WORD PTR BG_SUM[BX], AX
 JNA NLZ3B
 MOV AX, WORD PTR BG_SUM[BX]
 MOV DX, BX
NLZ3B: INC BX
 INC BX
 LOOP NLZ3A
 POP CX
 TEST AX, AX
 JZ NLZ3C
 MOV BX, DX
 MOV WORD PTR BG_SUM[BX], 0
 MOV SI, AX ; SUM
 MOV DI, WORD PTR BG_CRC[BX]
 MOV AX, 4
 SUB AX, CX ; CX=4 AX=0, CX=3 AX=1, CX=2 AX=2, CX=1 AX=3
 CALL TIMES6 ; BX = 6*AX
 MOV WORD PTR BG_THIS[BX+4], DI ; CRC
 MOV WORD PTR BG_THIS[BX+2], SI ; SUM
 MOV DH, 7 SHL 1
 SHL DX, 1
 SHL DX, 1
 SHL DX, 1
 XCHG DH, DL
 MOV WORD PTR BG_THIS[BX+0], DX ; MASKS
NLZ3C: LOOP NLZ3
 MOV CX, 4 ; GET FOUR BEST FG SCREENS
NLZ4: PUSH CX
 MOV CX, 16 ; SCAN FG SCREENS
 XOR AX, AX
 XOR BX, BX
NLZ4A: CMP WORD PTR FG_SUM[BX], AX
 JNA NLZ4B
 MOV AX, WORD PTR FG_SUM[BX]
 MOV DX, BX
NLZ4B: INC BX
 INC BX
 LOOP NLZ4A
 POP CX
 TEST AX, AX
 JZ NLZ4C
 MOV BX, DX
 MOV WORD PTR FG_SUM[BX], 0
 MOV SI, AX ; SUM
 MOV DI, WORD PTR FG_CRC[BX]
 MOV AX, 4
 SUB AX, CX ; CX=4 AX=0, CX=3 AX=1, CX=2 AX=2, CX=1 AX=3
 CALL TIMES6
 MOV WORD PTR FG_THIS[BX+4], DI ; CRC
 MOV WORD PTR FG_THIS[BX+2], SI ; SUM
 SHR DX, 1
 MOV DH, 15
 XCHG DH, DL
 MOV WORD PTR FG_THIS[BX+0], DX ; MASKS
NLZ4C: LOOP NLZ4
 XOR BX, BX ; INDEX FOR CORNERS
 XOR DI, DI ; INDEX FOR BOXES
NLZ05: MOV AX, WORD PTR CORNERS[BX+3] ; AH=Y1 AL=X1
 MOV SI, BX ; SAVE WITHOUT PUSHING
 TEST BYTE PTR CORNERS[BX+2], 1 ; UPPER LEFT?
 JZ NLZ15 ; IF NOT
NLZ06: INC BX
 INC BX
 INC BX
 MOV CX, WORD PTR CORNERS[BX+3] ; CH=Y2 CL=X2
 TEST BYTE PTR CORNERS[BX+2], 2 ; UPPER RIGHT?
 JZ NLZ07 ; IF NOT
 CMP AH, CH ; Y1=Y2?
 JE NLZ08 ; IF YES
NLZ07: TEST CX, CX ; DONE EARLY?
 JZ NLZ15 ; IF YES
 CMP BX, 96-9 ; MINIMUM FOR 3/4 BOX
 JNA NLZ06
 JMP SHORT NLZ15
NLZ08: MOV DL, CL ; SAVE X2
NLZ09: INC BX
 INC BX
 INC BX
 MOV CX, WORD PTR CORNERS[BX+3] ; CH=Y2 CL=X2
 TEST BYTE PTR CORNERS[BX+2], 4 ; LOWER LEFT?
 JZ NLZ10 ; IF NOT
 CMP AL, CL ; X1=X2?
 JE NLZ11 ; IF YES
NLZ10: TEST CX, CX ; DONE EARLY?
 JZ NLZ15 ; IF YES
 CMP BX, 96-6 ; MINIMUM FOR 2/4 BOX
 JNA NLZ09
 JMP SHORT NLZ15
NLZ11: MOV DH, CH ; SAVE Y2
NLZ12: INC BX
 INC BX
 INC BX
 MOV CX, WORD PTR CORNERS[BX+3] ; CH=Y2 CL=X2
 TEST BYTE PTR CORNERS[BX+2], 8 ; LOWER RIGHT?
 JZ NLZ13 ; IF NOT
 CMP CX, DX ; LAST CORNER?
 JE NLZ14 ; IF YES
NLZ13: TEST CX, CX ; DONE EARLY?
 JZ NLZ15
 CMP BX, 96-3 ; MINIMUM FOR 1/4 BOX
 JNA NLZ12
 JMP SHORT NLZ15
NLZ14: XCHG BX, DI ; BOX INDEX IN BX
 MOV WORD PTR BOXES_THIS[BX+0], AX ; SAVE X1Y1
 MOV WORD PTR BOXES_THIS[BX+2], CX ; SAVE X2Y2
 XCHG BX, DI ; CORNER INDEX IN BX
 INC DI
 INC DI
 INC DI
 INC DI
NLZ15: TEST AX, AX ; DONE EARLY?
 JZ NLZ16 ; IF YES
 MOV BX, SI ; RESTORE WITHOUT POPPING
 INC BX
 INC BX
 INC BX
 CMP BX, 96-12 ; MINIMUM FOR WHOLE BOX
 JA NLZ16
 JMP NLZ05
NLZ16: POP DX
 POP CX
 POP BX
 POP AX
 RET
CORNERS DW ? ; INDEX AND DATA FOR 36 CORNERS
 DB 36*3 DUP (?) ; CORNER TYPE, LINE, AND COLUMN
BG_SUM DW 8 DUP (?) ; BACKGROUND ATTRIBUTE SUMS
FG_SUM DW 16 DUP (?) ; FOREGROUND ATTRIBUTE SUMS
BG_CRC DW 8 DUP (?) ; BACKGROUND ATTRIBUTE CRC
FG_CRC DW 16 DUP (?) ; FOREGROUND ATTRIBUTE CRC
NLZ2LENGTH EQU $ - OFFSET CORNERS ; FOR CLEARING
ANALYZE ENDP
SETCORNERS PROC NEAR
; AL = UPPER ASCII, SI = OFFSET+2, DS/ES REVERSED
 CMP AL, 180 ; SMALLEST CORNER CODE
 JB SCNR1
 CMP AL, 218 ; HIGHEST CORNER CODE
 JA SCNR1
 CMP AL, 186 ; LINE
 JE SCNR1
 CMP AL, 196 ; LINE
 JE SCNR1
 CMP AL, 205 ; LINE
 JNE SCNR2
SCNR1: RET
SCNR2: PUSH AX
 MOV AH, 1 ; LINE DOWN/RIGHT
 CMP AL, 201
 JE SCNR3
 CMP AL, 213
 JE SCNR3
 CMP AL, 214
 JE SCNR3
 CMP AL, 218
 JE SCNR3
 MOV AH, 1+2 ; LINE LEFT/RIGHT/DOWN
 CMP AL, 194
 JE SCNR3
 CMP AL, 203
 JE SCNR3
 CMP AL, 209
 JE SCNR3
 CMP AL, 210
 JE SCNR3
 MOV AH, 1+4 ; LINE UP/DOWN/RIGHT
 CMP AL, 195
 JE SCNR3
 CMP AL, 198
 JE SCNR3
 CMP AL, 199
 JE SCNR3
 CMP AL, 204
 JE SCNR3
 MOV AH, 1+2+4+8 ; LINE UP/DOWN/LEFT/RIGHT
 CMP AL, 197
 JE SCNR3
 CMP AL, 206
 JE SCNR3
 CMP AL, 215
 JE SCNR3
 CMP AL, 216
 JNE SCNR4
SCNR3: JMP SHORT SCNR5
SCNR4: MOV AH, 2 ; LINE LEFT/DOWN
 CMP AL, 183
 JE SCNR5
 CMP AL, 184
 JE SCNR5
 CMP AL, 187
 JE SCNR5
 CMP AL, 191
 JE SCNR5
 MOV AH, 2+8 ; LINE UP/DOWN/LEFT
 CMP AL, 180
 JE SCNR5
 CMP AL, 181
 JE SCNR5
 CMP AL, 182
 JE SCNR5
 CMP AL, 185
 JE SCNR5
 MOV AH, 4 ; LINE UP/RIGHT
 CMP AL, 192
 JE SCNR5
 CMP AL, 200
 JE SCNR5
 CMP AL, 211
 JE SCNR5
 CMP AL, 212
 JE SCNR5
 MOV AH, 4+8 ; LINE LEFT/RIGHT/UP
 CMP AL, 193
 JE SCNR5
 CMP AL, 202
 JE SCNR5
 CMP AL, 207
 JE SCNR5
 CMP AL, 208
 JE SCNR5
 MOV AH, 8 ; LINE LEFT/UP
 CMP AL, 188
 JE SCNR5
 CMP AL, 189
 JE SCNR5
 CMP AL, 190
 JE SCNR5
 CMP AL, 217
 JNE SCNR8
SCNR5: PUSH DI ; CHANGE OFFSET+2 TO LINE AND COLUMN
 PUSH BX
 PUSH AX
 MOV AX, SI
 SHR AX, 1
 XOR DI, DI
 MOV BL, BYTE PTR ES:I8WIDTH
 XOR BH, BH
 ADD AX, BX
SCNR6: SUB AX, BX
 INC DI
 CMP AX, BX
 JA SCNR6
 MOV BX, DI
 MOV AH, BL ; AH=LINE, AL=COLUMN
 MOV DI, AX
 POP AX
 MOV BX, WORD PTR ES:CORNERS ; INDEX
 CMP BX, 108 ; 3*36
 JNB SCNR7
 MOV BYTE PTR ES:CORNERS[BX+2], AH ; CORNER TYPE
 MOV WORD PTR ES:CORNERS[BX+3], DI ; CORNER LOCATION
 INC BX
 INC BX
 INC BX
 MOV WORD PTR ES:CORNERS, BX
SCNR7: POP BX
 POP DI
SCNR8: POP AX
 RET
SETCORNERS ENDP
DYNAMICS PROC NEAR
 MOV CX, 9
DNMC1: MOV BX, 9
 SUB BX, CX
 SHL BX, 1
 SHL BX, 1
 MOV SI, WORD PTR BOXES_THIS[BX+0] ; LEFT UPPER CORNER
 TEST SI, SI ; FINISHED?
 JZ DNMC7
 MOV DI, WORD PTR BOXES_THIS[BX+2] ; RIGHT LOWER CORNER
 PUSH CX
 MOV CX, 9
DNMC3: MOV BX, 9
 SUB BX, CX
 SHL BX, 1
 SHL BX, 1
 CMP WORD PTR BOXES_LAST[BX+0], 0
 JE DNMC5
 CMP WORD PTR BOXES_LAST[BX+0], SI
 JNE DNMC4
 CMP WORD PTR BOXES_LAST[BX+2], DI
 JE DNMC6
DNMC4: LOOP DNMC3
DNMC5: CALL SAVE1BOX
DNMC6: POP CX
DNMC2: LOOP DNMC1
DNMC7: PUSH ES
 PUSH DS
 POP ES
 MOV CX, 3
 MOV WORD PTR LAST1IN, 0 ; NOT FROM KBD
 CMP BYTE PTR F6FLAG, 3 ; IS IT 3-, 3, OR 3+?
 JB DNMC05 ; IF 3-
 JE DNMC01 ; IF 3
 CMP BYTE PTR F6FLAG, 5 ; IS IT 4, 5, OR 6+?
 JB DNMC02 ; IF 4
 JE DNMC10 ; IF 5
 MOV SI, OFFSET FG_THIS ; F6FLAG=7
 MOV DI, OFFSET FG_LAST
 JMP SHORT DNMC11
DNMC01: MOV SI, OFFSET BG_THIS ; F6FLAG=3
 MOV DI, OFFSET BG_LAST
 JMP SHORT DNMC03
DNMC02: MOV SI, OFFSET FG_THIS ; F6FLAG=4
 MOV DI, OFFSET FG_LAST
DNMC03: MOV AX, CX
 CALL TIMES6
 MOV AX, WORD PTR [SI+BX+2] ; NEW SUM
 TEST AX, AX
 JZ DNMC04
 CMP AX, WORD PTR [DI+BX+2] ; NEW SUM
 JNE DNMC06
 MOV AX, WORD PTR [SI+BX+0] ; OLD MASKS
 CMP AX, WORD PTR [DI+BX+0] ; NEW MASKS
 JNE DNMC06
 MOV AX, WORD PTR [SI+BX+4] ; NEW CRC
 CMP AX, WORD PTR [DI+BX+4] ; OLD CRC
 JNE DNMC06
DNMC04: LOOP DNMC03
DNMC05: POP ES ; NO CHANGES
 RET
DNMC06: POP ES ; FOUND CHANGES
 MOV BX, WORD PTR [SI] ; MASKS
 MOV AL, BYTE PTR I8LINE ; COMPUTE SCREEN SIZE
 CBW
 INC AL
 MOV CL, BYTE PTR I8WIDTH
 MUL CL
 MOV CX, AX ; SCREEN SIZE
 MOV SI, WORD PTR I8VIDOFF
DNMC07: MOV AX, WORD PTR ES:[SI]
 CMP AL, SPC ; CTRL CHAR OR UPPER ASCII?
 JL DNMC08
 AND AH, BL
 CMP AH, BH
 JNE DNMC09
DNMC08: MOV AL, SPC
DNMC09: CALL SAVE1DATA
 INC SI
 INC SI
 LOOP DNMC07
 RET
DNMC10: MOV SI, OFFSET BG_THIS ; F6FLAG=5
 MOV DI, OFFSET BG_LAST
DNMC11: MOV AX, CX
 CALL TIMES6
 MOV AX, WORD PTR [SI+BX+2] ; NEW SUM
 TEST AX, AX
 JZ DNMC12
 CMP AX, WORD PTR [DI+BX+2] ; NEW SUM
 JNE DNMC13
 MOV AX, WORD PTR [SI+BX+0] ; OLD MASKS
 CMP AX, WORD PTR [DI+BX+0] ; NEW MASKS
 JNE DNMC13
 MOV AX, WORD PTR [SI+BX+4] ; NEW CRC
 CMP AX, WORD PTR [DI+BX+4] ; OLD CRC
 JNE DNMC13
DNMC12: LOOP DNMC11
 POP ES ; NO CHANGES
 RET
DNMC13: POP ES ; FOUND CHANGES
 MOV BX, WORD PTR [BX+SI] ; MASKS
SAVE2SCREEN PROC NEAR
; BX=MASKS, ES=VIDEO SEGMENT
 MOV WORD PTR LATER,  0
 MOV AL, BYTE PTR I8LINE ; COMPUTE SCREEN SIZE
 CBW
 INC AL
 MOV CL, BYTE PTR I8WIDTH
 MUL CL
 MOV CX, AX ; SCREEN SIZE
 MOV SI, WORD PTR I8VIDOFF
SAVE2S1: MOV AX, WORD PTR ES:[SI]
 CMP AL, SPC ; CTRL CHAR?
 JL SAVE2S2 ; CONTROL CHAR OR UPPER ASCII?
 AND AH, BL
 CMP AH, BH
 JE SAVE2S3
SAVE2S2: MOV AL, SPC
SAVE2S3: CALL SAVE1DATA
 INC SI
 INC SI
 LOOP SAVE2S1
 RET
SAVE2SCREEN ENDP
DYNAMICS ENDP
SAVE1BOX PROC NEAR
; SI=TOP LEFT, DI=BOTTOM RIGHT, ES=VIDEO SEGMENT
 MOV WORD PTR LATER,  0
 MOV CX, DI
 MOV DX, SI
 DEC DH
 DEC DL
 MOV WORD PTR LAST1IN, 0 ; NOT FROM KBD
SAVE1B1: MOV BX, DX ; SAVES TOP LEFT
 MOV SI, WORD PTR I8VIDOFF
 XOR AX, AX
 XCHG AL, DH
 MOV DI, DX ; SAVE LEFT
 SHL AX, 1
 SHL DX, 1
 ADD SI, DX
 MOV DX, CX
 MOV CL, BYTE PTR I8WIDTH
 MUL CL
 ADD SI, AX
 XOR CH, CH
 CMP CL, DL
 JLE SAVE1B2
 MOV CL, DL
SAVE1B2: SUB CX, DI
SAVE1B3: MOV AX, WORD PTR ES:[SI]
 CMP AL, SPC ; CTRL CHAR OR UPPER ASCII?
 JNL SAVE1B4
 MOV AL, SPC
SAVE1B4: CALL SAVE1DATA
 INC SI
 INC SI
 LOOP SAVE1B3
 MOV CX, DX
 MOV DX, BX
 INC DH
 CMP DH, CH
 JL SAVE1B1
 RET
SAVE1BOX ENDP
SET1ALERT PROC NEAR
 MOV AX, CS
 MOV ES, AX
 MOV DI, OFFSET HOTSUB
 MOV AL, BYTE PTR BANKSUB[0] ; SMART SCREEN #1
 CALL GETSMART
 MOV AL, BYTE PTR BANKSUB[1]
GETSMART PROC NEAR
 MOV CX, 6
 CALL ISDIGIT
 JNC GTSM1
 AND AX, 15
 MUL CL
 MOV SI, OFFSET BANKTABLE
 ADD SI, AX
 CLD
 REP MOVSB
 RET
GTSM1: XOR AX, AX
 CLD
 REP STOSB
 RET
GETSMART ENDP
SET1ALERT ENDP
GET1ALERT PROC NEAR
 JMP WORD PTR GLRTSW
GLRX1: MOV WORD PTR GLRTSW, OFFSET GLRX5
 MOV BX, OFFSET GLRM1
 CALL SENDSTRING
 MOV AL, BYTE PTR BANKSUB[0]
 CALL ISDIGIT
 JNC GLRX2
 MOV BYTE PTR GLRM5[0], AL
 MOV BX, OFFSET GLRM4
 CALL SENDSTRING
 MOV AL, BYTE PTR BANKSUB[1]
 CALL SAYNUMBER
 JMP SHORT GLRX3
GLRX2: MOV BX, OFFSET GLRM3
 CALL SENDSTRING
GLRX3: MOV BX, OFFSET GLRM6
GLRX4: CALL SENDSTRING
 MOV BX, OFFSET GLRM10
 CLC ; NOT DONE
 RET
GLRX5: CALL ISDIGIT
 JC GLRX6
 CMP AL, ESCP
 JE GLRX11
 CMP AL, SPC
 JE GLRX7
 CMP AL, '/'
 JNE GLRX3
 MOV WORD PTR BANKSUB[0], 0
 JMP SHORT GLRX11
GLRX6: MOV BYTE PTR BANKSUB[0], AL
GLRX7: MOV WORD PTR GLRTSW, OFFSET GLRX9
GLRX8: MOV BX, OFFSET GLRM7
 JMP SHORT GLRX4
GLRX9: CALL ISDIGIT
 JC GLRX10
 CMP AL, ESCP
 JE GLRX11
 CMP AL, SPC
 JE GLRX11
 CMP AL, '/'
 JNE GLRX8
 MOV BYTE PTR BANKSUB[1], 0
 JMP SHORT GLRX11
GLRX10: MOV BYTE PTR BANKSUB[1], AL
GLRX11: MOV WORD PTR GLRTSW, OFFSET GLRX1
 CALL SET1ALERT
 STC
 RET
GLRTSW DW OFFSET GLRX1
GLRM1 DB 'auto alert', 0
GLRM3 DB 'not asssigned', 0
GLRM4 DB 'monitoring sub screen #'
GLRM5 DB '#', RO, 'reading sub screen', 0
GLRM6 DB 'sub screen to monitor', 0
GLRM7 DB 'sub screen to read', 0
GLRM10 DB 'enter #', RO
 db 'or press slash to cancel', RO, 'press escape or space if o k', 0
GET1ALERT ENDP
GET1IGNORE PROC NEAR
 JMP WORD PTR GGNRSW
GGNR1: MOV WORD PTR GGNRSW, OFFSET GGNR5
 MOV BX, OFFSET GGNRM1
 CALL SENDSTRING
 MOV AX, WORD PTR BANKSUB[2]
 CALL ISDIGIT
 JNC GGNR2
 CALL SAY2NUMS
 JMP SHORT GGNR3
GGNR2: MOV BX, OFFSET GLRM3
 CALL SENDSTRING
GGNR3: MOV BX, OFFSET GGNRM2
GGNR4: CALL SENDSTRING
 MOV BX, OFFSET GLRM10
 CLC ; NOT DONE
 RET
GGNR5: CALL ISDIGIT
 JC GGNR6
 CMP AL, ESCP
 JE GGNR11
 CMP AL, SPC
 JE GGNR7
 CMP AL, '/'
 JNE GGNR3
 MOV WORD PTR BANKSUB[2], 0
 JMP SHORT GGNR11
GGNR6: MOV BYTE PTR BANKSUB[2], AL
GGNR7: MOV WORD PTR GGNRSW, OFFSET GGNR9
GGNR8: MOV BX, OFFSET GGNRM3
 JMP SHORT GGNR4
GGNR9: CALL ISDIGIT
 JC GGNR10
 CMP AL, ESCP
 JE GGNR11
 CMP AL, SPC
 JE GGNR11
 CMP AL, '/'
 JNE GGNR8
 MOV BYTE PTR BANKSUB[3], 0
 JMP SHORT GGNR11
GGNR10: MOV BYTE PTR BANKSUB[3], AL
GGNR11: MOV WORD PTR GGNRSW, OFFSET GGNR1
 CALL SET1IGNORE
 STC ; DONE
 RET
GGNRSW DW OFFSET GGNR1
GGNRM1 DB 'auto ignore', 0
GGNRM2 DB 'first sub screen to ignore', 0
GGNRM3 DB 'second sub screen to ignore', 0
GET1IGNORE ENDP
SAY2NUMS PROC NEAR
 PUSH AX
 CALL SAYNUMBER
 POP AX
 XCHG AH, AL
SAYNUMBER PROC NEAR
 CALL ISDIGIT
 JNC SN1
 MOV BX, OFFSET SNM
 MOV BYTE PTR [BX+1], AL
 JMP SENDSTRING
SN1: RET
SNM DB '##', 0
SAYNUMBER ENDP
SAY2NUMS ENDP
SET4REGS PROC NEAR
 AND AX, 8 OR 4 OR 2 OR 1
 CMP AL, 9 ; IS IT 0-9?
 JA SET4R5 ; IF NOT
 CALL TIMES6 ; BX = 6*AX
 MOV AX, WORD PTR BANKTABLE+0[BX] ; ATTRIBUTES & MASK
 MOV CX, WORD PTR BANKTABLE+4[BX] ; BOTTOM RIGHT CORNER
 MOV DX, WORD PTR BANKTABLE+2[BX] ; TOP LEFT CORNER
 MOV WORD PTR TEMPSUB+0, AX
 MOV AX, WORD PTR THISCURSOR ; CURSOR LOCATION
 INC AH
 INC AL
 CMP CH, 255 ; CURSOR LINE?
 JNE SET4R1
 MOV CH, AH
SET4R1: CMP DH, 255
 JNE SET4R2
 MOV DH, AH
SET4R2: CMP CL, 255 ; CURSOR COLUMN?
 JNE SET4R3
 MOV CL, AL
SET4R3: CMP DL, 255
 JNE SET4R4
 MOV DL, AL
SET4R4: CMP DH, 1
 JL SET4R5
 CMP CH, DH
 JL SET4R5
 DEC CH
 CMP CH,BYTE PTR I8LINE
 JA SET4R5
 INC CH
 CMP DL, 1
 JL SET4R5
 CMP CL, DL
 JL SET4R5
 CMP CL,BYTE PTR I8WIDTH
 JA SET4R5
 CLC ; IF OKAY
 RET
SET4R5: STC ; IF ERROR
 RET
SET4REGS ENDP
FIX4REGS PROC NEAR
; BX = ADDRESS OF MASKS
; SETS CX/DX TO SUBSCREEN
 MOV AX, WORD PTR I8CURSOR ; CURSOR LOCATION
 MOV CX, WORD PTR [BX+4] ; BOTTOM RIGHT CORNER
 MOV DX, WORD PTR [BX+2] ; TOP LEFT CORNER
 INC AH
 INC AL
 CMP CH, 255 ; CURSOR LINE?
 JNE FIX4R01
 MOV CH, AH
FIX4R01: CMP DH, 255
 JNE FIX4R02
 MOV DH, AH
FIX4R02: CMP CL, 255 ; CURSOR COLUMN?
 JNE FIX4R03
 MOV CL, AL
FIX4R03: CMP DL, 255
 JNE FIX4R04
 MOV DL, AL
FIX4R04: CMP DH, 1
 JNB FIX4R05
 MOV DH, 1
FIX4R05: CMP CH, DH
 JNB FIX4R06
 MOV CH, DH
FIX4R06: DEC CH
 CMP CH,BYTE PTR I8LINE
 JNA FIX4R07
 MOV CH,BYTE PTR I8LINE
FIX4R07: INC CH
 CMP DL, 1
 JNB FIX4R08
 MOV DL, 1
FIX4R08: CMP CL, DL
 JNB FIX4R09
 MOV CL, DL
FIX4R09: CMP CL,BYTE PTR I8WIDTH
 JNA FIX4R10
 MOV CL,BYTE PTR I8WIDTH
FIX4R10: DEC DH
 DEC DL
 RET
FIX4REGS ENDP
DEADZONE PROC NEAR
 PUSH AX
 PUSH BX
 MOV AX, BX
 CMP BYTE PTR AX_SAVE[1], 9 ; WRITE ATTRIB & CHAR?
 JE DEADZ0 ; SKIP IF YES
 PUSH AX
 MOV BX, WORD PTR ES:[78] ; PAGE OFFSET
 MOV CX, WORD PTR ES:[74] ; LINE WIDTH
 MOV AX, 0B800H ; CGA VIDEO SEGMENT
 CMP BYTE PTR ES:[73], 4
 JB DDZN1
 MOV AX, 0B000H ; MODE 7 VIDEO SEGMENT
DDZN1: MOV ES, AX
 XOR AX, AX
 PUSH DX
 XCHG AL, DH
 SHL DX, 1
 ADD BX, DX
 MUL CL
 SHL AX, 1
 ADD BX, AX
 MOV AX, WORD PTR ES:[BX]
 MOV BYTE PTR BX_SAVE, AH
 POP DX
 POP ES
 POP AX
DEADZ0: INC AH
 INC AL
 MOV BX, OFFSET DEADSUB
 CALL TEST4REGS
 JC DEADZ1
 ADD BX, 6
 CALL TEST4REGS
DEADZ1: POP BX
 POP AX
 RET
DEADZONE ENDP
TEST4REGS PROC NEAR
 MOV CX, WORD PTR [BX+4] ; BOTTOM RIGHT CORNER
 JCXZ TEST4R5
 MOV DX, WORD PTR [BX+0]
 AND DL, BYTE PTR BX_SAVE
 CMP DH, DL
 JNE TEST4R5
 MOV DX, WORD PTR [BX+2] ; TOP LEFT CORNER
 CMP CH, 255 ; CURSOR LINE?
 JNE TEST4R1
 MOV CH, AH
TEST4R1: CMP DH, 255
 JNE TEST4R2
 MOV DH, AH
TEST4R2: CMP CL, 255 ; CURSOR COLUMN?
 JNE TEST4R3
 MOV CL, AL
TEST4R3: CMP DL, 255
 JNE TEST4R4
 MOV DL, AL
TEST4R4: CMP DH, 1
 JB TEST4R5
 CMP CH, DH
 JB TEST4R5
 DEC CH
 CMP CH, BYTE PTR I8LINE
 JA TEST4R5
 INC CH
 CMP DL, 1
 JB TEST4R5
 CMP CL, DL
 JL TEST4R5
 CMP CL, BYTE PTR I8WIDTH
 JA TEST4R5
 CMP AH, DH
 JB TEST4R5
 CMP CH, AH
 JB TEST4R5
 CMP AL, DL
 JB TEST4R5
 CMP CL, AL
 JB TEST4R5
 STC ; IF IGNORE
 RET
TEST4R5: CLC ; IF OKAY
 RET
TEST4REGS ENDP
ASK2INIT PROC NEAR
 MOV BX, WORD PTR VOXNUMBER
 CMP BX, MAXVOXNUM SHL 1
 JB ASK2I0 ; IF OKAY
 RET
ASK2I0: CMP BX, 14 ; DECTALK PC?
 JE ASK2I1
 CMP WORD PTR VOXPORT, 4 ; PARALLEL?
 JB ASK2I1 ; IF SO
 CMP WORD PTR VOXPORT, 8 ; SERIAL?
 JNB ASK2I1 ; IF NOT
 MOV AX, 227 ; 9600, 8N2
 MOV DX, WORD PTR VOXPORT
 AND DX, NOT (1 SHL 2)
 INT 20
ASK2I1: JMP WORD PTR INIT1LIST[BX]
INIT1LIST DW VOX1INIT, VOX2INIT, VOX3INIT, VOX4INIT, VOX5INIT
 DW DUMMY, VOX7INIT, VOX8INIT, VOX9INIT, VOX10INIT
ASK2INIT ENDP
I22PROVOX PROC NEAR
 MOV BYTE PTR I8WAIT2, 73 ; FOUR SECONDS FOR CONTEXT
 CMP AL, 224 ; ALTERNATE ARROWS?
 JNE I22PR1
 XOR AL, AL
I22PR1: MOV WORD PTR LAST1IN, AX
 AND WORD PTR STATES1, NOT (PH1FLAG OR PH2FLAG) ; NO PHONETICS
 MOV BX, WORD PTR I8VIDOFF ; VIDEO OFFSET
 MOV ES, WORD PTR I8VIDSEG
 MOV CL, BYTE PTR I8WIDTH
 MOV DX, WORD PTR I8CURSOR
 CMP AL, BSP
 JNE I22PR2 ; IF NOT
 XOR AX, AX
 XCHG AL, DH
 MUL CL
 SHL AX, 1
 ADD BX, AX
 TEST DL, DL ; LEFT COLUMN?
 JZ I22PR8 ; IF SO
 DEC DL
 SHL DX, 1
 ADD BX, DX
 MOV AX, WORD PTR ES:[BX]
 JMP SAVE2DATA
I22PR2: TEST AL, AL ; ARROWS?
 JNZ I22PR4 ; IF NOT
 MOV BX, 18 SHL 8 OR ';' ; CHAR LEFT OR RIGHT
 CMP AH, 75 ; LEFT?
 JE I22PR3
 CMP AH, 77 ; RIGHT?
 JE I22PR3
 MOV BL, ':' ; WORD LEFT OR RIGHT
 CMP AH, 115 ; LEFT?
 JE I22PR3
 CMP AH, 116 ; RIGHT?
 JE I22PR3
 MOV BL, '?' ; LINE UP OR DOWN
 CMP AH, 72 ; UP?
 JE I22PR3
 CMP AH, 80 ; DOWN?
 JNE I22PR4
I22PR3: MOV WORD PTR LATER, BX
 MOV WORD PTR LASTCURSOR, DX
 RET
I22PR4: CALL ISLOWER
 JNC I22PR5
 PUSH AX
 MOV AX, 64
 MOV ES, AX
 POP AX
 TEST BYTE PTR ES:[23], 1 SHL 6
 JNZ I22PR6
I22PR5: INC DL
 CMP BYTE PTR F19FLAG, DL
 JNE I22PR7
I22PR6: MOV WORD PTR I8TONE, OFFSET I8MID
I22PR7: CMP BYTE PTR F7FLAG, 0
 JE I22PR8
 CALL SAVE2DATA
I22PR8: RET
I22PROVOX ENDP
; DATA AND CODE FOR I23 -- PRINTER
I23PORT DD ? ; FILLED IN AT LOAD TIME
; DATA AND CODE FOR I47 -- MULTIPLEX
I47COUNT DW 0
I47ENTRY: CMP AH,SYSNUMBER ; FOR PROVOX?
 JE I47OKAY ; IF SO
 CMP AX, 22 SHL 8 OR 5 ; WINDOWS OPENING?
 JE I47LINK1
 CMP AX, 22 SHL 8 OR 6 ; WINDOWS CLOSING?
 JNE I47LINK3
 PUSH DS
 PUSH AX
 MOV AX, CS
 MOV DS, AX
 PUSH BX
 CALL INITIALIZE
 MOV BX, OFFSET I8MSG13
 CALL SENDSTRING
 JMP SHORT I47LINK2
I47LINK1: PUSH DS
 PUSH AX
 MOV AX, CS
 MOV DS, AX
 PUSH BX
 MOV BX, OFFSET I8MSG12
 MOV AX, DI
 XCHG AH, AL
 CALL TELL3DIGITS
 MOV AL, '.'
 CALL SAVE3DATA
 MOV AX, DI
 CALL SAVE3DIGITS
I47LINK2: POP BX
 POP AX
 POP DS
I47LINK3:
I47RETURN DB 234 ; FAR JUMP
 DD ? ; CHAIN TO ORIGINAL I47 VECTOR
I47OKAY: PUSH DS ; USE THE CALLER STACK
 PUSH CS
 POP DS
 TEST AL, AL ; IDENTIFICATION?
 JNZ I47NOT0
 MOV AX, NOT 0
 MOV BX, REVISION
 MOV CX, CONFIGSIZE
 POP DS
 IRET
I47NOT0: CMP AL, 1 ; WAKE?
 JNE I47NOT1
 PUSH ES
 MOV AX, 64
 MOV ES, AX
 TEST BYTE PTR STATES0, ENHANCED
 JZ I47NOT0A ; IF NOT
 AND BYTE PTR ES:[23], NOT (1 SHL 5) ; CLEAR NUMLOCK
I47NOT0A: POP ES
 AND WORD PTR STATES1, NOT CLOSED
 POP DS
 IRET
I47NOT1: CMP AL, 2 ; DOZE?
 JNE I47NOT2
 OR WORD PTR STATES1, CLOSED
 POP DS
 IRET
I47NOT2: MOV WORD PTR AX_SAVE, AX
 CBW ; SETS AH TO ZERO
 PUSH DI
 PUSH SI
 PUSH BX
 PUSH CX
 PUSH DX
 PUSH ES
 CALL GROUP0 ; FUNCTIONS 3 - 10
 POP ES
 POP DX
 POP CX
 POP BX
 POP SI
 POP DI
 MOV AX, WORD PTR AX_SAVE
 POP DS
 IRET ; END OF I47 CODE
; SUBROUTINES
GROUP0 PROC NEAR
 CMP AL, 3 ; CONFIGURE PROVOX?
 JNE G0NOT3
 JMP INITIALIZE
G0NOT3: CMP AL, 4 ; CHAR FOR I9PROVOX?
 JNE G0NOT4
 MOV AX, BX
 JMP I9PROVOX
G0NOT4: CMP AL, 5 ; CHAR FOR S16PROVOX?
 JNE G0NOT5
 MOV AL, BL
 JMP SAVE1DATA
G0NOT5: CMP AL, 6 ; CHAR FOR I22PROVOX?
 JNE G0NOT6
 MOV AX, BX
 JMP I22PROVOX
G0NOT6: CMP AL, 7 ; EXPORT DATA?
 JNE G0NOT7
 MOV AX, WORD PTR CONFIGDATA[BX]
 MOV WORD PTR AX_SAVE, AX
 RET
G0NOT7: CMP AL, 8 ; IMPORT WORD?
 JNE G0NOT8
 MOV WORD PTR CONFIGDATA[BX], CX
 RET
G0NOT8: CMP AL, 9 ; IMPORT BYTE?
 JNE G0NOT9
 MOV BYTE PTR CONFIGDATA[BX], CL
 RET
G0NOT9: CMP AL, 10 ; DUMP BUFFER
 JNE G0EXIT
 MOV AX, NOT 0
 MOV BX, WORD PTR BUFHEAD
 CMP BX, WORD PTR BUFTAIL
 JE G0DUMP
 MOV AL, BYTE PTR [BX]
 AND AL, NOT (1 SHL 7)
 CBW
 INC BX
 CMP BX, OFFSET BUFFER + BUFSIZE
 JNE G0ADJUST
 MOV BX, OFFSET BUFFER
G0ADJUST: MOV WORD PTR BUFHEAD, BX
G0DUMP: MOV WORD PTR AX_SAVE, AX
G0EXIT: RET
GROUP0 ENDP
SEND1CHAR PROC NEAR
 TEST WORD PTR STATES1, CLOSED
 JZ SEND1CH0 ; IF NOT
 RET
SEND1CH0: XOR AH, AH
 TEST AL, 1 SHL 7 ; FROM SYSTEM?
 JNZ SEND1CH4 ; IF NOT
 CMP BYTE PTR F5FLAG, 3 ; SAY ALL PUNCTUATION?
 JE SEND1CH5 ; IF YES
 CMP BYTE PTR F5FLAG, 1 ; 0 = PASS THROUGH
 JE SEND1CH2 ; IF 1
 JA SEND1CH1 ; IF 2
 MOV BX, MAXVOXNUM SHL 1 - 2 ; VANILLA
 JMP SHORT SEND1CH8
SEND1CH1: CMP AL, SPC ; SPACE FROM SYSTEM?
 JNE SEND1CH5 ; IF NOT
 JMP SHORT SEND1CH3
SEND1CH2: CALL ISALPHA
 JC SEND1CH5 ; IF OKAY
 CALL ISDIGIT
 JC SEND1CH5 ; IF OKAY
SEND1CH3: MOV AL, SPC ; USE TRUE SPACE
 JMP VOX3MOVE
SEND1CH4: AND AL, NOT (1 SHL 7) ; DROP BIT #7
SEND1CH5: MOV BX, WORD PTR VOXNUMBER
 MOV AH, BYTE PTR LAST4OUT
 MOV BYTE PTR LAST4OUT, AL
 CMP AL, SPC
 JNE SEND1CH6
 CMP AH, '.'
 JNE SEND1CH8
 MOV AL, '.'
 JMP SHORT SEND1CH11
SEND1CH6: CMP BYTE PTR F3FLAG, 0
 JNE SEND1CH8
 CMP AL, '.'
 JE SEND1CH7
 CMP AL, ','
 JE SEND1CH7
 CMP AL, '-'
 JNE SEND1CH8
SEND1CH7: CMP AH, '0'
 JB SEND1CH8
 CMP AH, '9'
 JLE SEND1CH11
SEND1CH8: MOV BX, WORD PTR CODELIST[BX]
SEND1CH9: CMP BYTE PTR [BX], 0
 JE SEND1CH11
 CMP BYTE PTR [BX], AL
 JE SEND1CH10
 ADD BX, 3
 JMP SHORT SEND1CH9
SEND1CH10: MOV BX, WORD PTR [BX+1]
 JMP MOVE1STRING
SEND1CH11: CALL ISUPPER
 JNC SEND1CH15 ; IF NOT
 PUSH AX ; SAVE THE CHAR
 CMP BYTE PTR F4FLAG, 0 ; SAY CAPITAL?
 JE SEND1CH13 ; IF NOT
 MOV BX, OFFSET SEND1CAP
 CALL MOVE1STRING
 JMP SHORT SEND1CH14
SEND1CH13: XCHG AH, AL
 CALL ISUPPER
 JC SEND1CH14 ; IF YES
 MOV AX, SPC
 CALL VOX3MOVE
SEND1CH14: POP AX ; GET CHAR BACK
SEND1CH15: JMP VOX3MOVE
CODELIST DW VOX1CODE, VOX2CODE, VOX3CODE, VOX4CODE
 DW VOX5CODE, VOX6CODE, VOX7CODE, VOX8CODE, VOX9CODE, VOX10CODE
VOX1CODE LABEL WORD ; FOR DTLT
VOX3CODE LABEL WORD ; FOR DOUBLE TALK
VOX9CODE LABEL WORD ; FOR LITE TALK
 DB 31
 DW X1F
 DB 32
 DW X20
 DB '!'
 DW X21
 DB '"'
 DW X22
 DB '$'
 DW X24
 DB 39
 DW X27A
 DB '('
 DW X28
 DB ')'
 DW X29
 DB ','
 DW X2C
 DB '-'
 DW X2D
 DB '.'
 DW X2E1
 DB '/'
 DW X2F
 DB ':'
 DW X3A
 DB ';'
 DW X3B
 DB '<'
 DW X3C
 DB '>'
 DW X3E
 DB '?'
 DW X3F
 DB '@'
 DW X40
 DB '['
 DW X5B
 DB ']'
 DW X5D
 DB '_'
 DW X5F
 DB '`'
 DW X60
 DB '{'
 DW X7B
 DB '|'
 DW X7C
 DB '}'
 DW X7D
 DB '~'
 DW X7E
 DB RO
 DW X7F1
 DB 0 ; END OF TABLE
VOX2CODE LABEL WORD ; FOR PORTTALK
 DB 31
 DW X1F
 DB 32
 DW X20
 DB '!'
 DW X21
 DB '"'
 DW X22
 DB '#'
 DW X23
 DB '$'
 DW X24
 DB '%'
 DW X25
 DB '&'
 DW X26
 DB 39
 DW X27
 DB '('
 DW X28
 DB ')'
 DW X29
 DB '*'
 DW X2A
 DB '+'
 DW X2B
 DB ','
 DW X2C
 DB '-'
 DW X2D
 DB '.'
 DW X2E
 DB '/'
 DW X2F
 DB ':'
 DW X3A
 DB ';'
 DW X3B
 DB '<'
 DW X3C
 DB '='
 DW X3D
 DB '>'
 DW X3E
 DB '?'
 DW X3F
 DB '@'
 DW X40
 DB '['
 DW X5B
 DB '\'
 DW X5C
 DB ']'
 DW X5D
 DB '^'
 DW X5E
 DB '_'
 DW X5F
 DB '`'
 DW X60
 DB '{'
 DW X7B
 DB '|'
 DW X7C
 DB '}'
 DW X7D
 DB '~'
 DW X7E
 DB RO
 DW X7F1
 DB 0 ; END OF TABLE
VOX8CODE LABEL WORD ; FOR DECTALK PC
 DB 31
 DW X1F
 DB 32
 DW X20
 DB '!'
 DW X21
 DB '"'
 DW X22
 DB '#'
 DW X23
 DB '$'
 DW X24
 DB '%'
 DW X25
 DB '&'
 DW X26
 DB 39
 DW X27A
 DB '('
 DW X28
 DB ')'
 DW X29
 DB '*'
 DW X2A
 DB '+'
 DW X2B
 DB ','
 DW X2C
 DB '-'
 DW X2D
 DB '.'
 DW X2E1
 DB '/'
 DW X2F
 DB ':'
 DW X3A1
 DB ';'
 DW X3B1
 DB '<'
 DW X3C
 DB '='
 DW X3D
 DB '>'
 DW X3E
 DB '?'
 DW X3F
 DB '@'
 DW X40
 DB '['
 DW X5B
 DB '\'
 DW X5C
 DB ']'
 DW X5D
 DB '^'
 DW X5E
 DB '_'
 DW X5F
 DB '`'
 DW X60
 DB '{'
 DW X7B
 DB '|'
 DW X7C
 DB '}'
 DW X7D
 DB '~'
 DW X7E
 DB RO
 DW X7F
 DB 0 ; END OF TABLE
VOX4CODE LABEL WORD ; FOR AUDAPTER
 DB 31
 DW X1F
 DB 32
 DW X20
 DB '#'
 DW X23
 DB ','
 DW X2C
 DB RO
 DW X7F
 DB 0 ; END OF TABLE
VOX5CODE LABEL WORD ; FOR VOTRAX PSS
 DB 31
 DW X1F
 DB 32
 DW X20
 DB '!'
 DW X21
 DB '"'
 DW X22
 DB 39
 DW X27
 DB '('
 DW X28
 DB ')'
 DW X29
 DB ','
 DW X2C
 DB '-'
 DW X2D
 DB '.'
 DW X2E
 DB ':'
 DW X3A
 DB ';'
 DW X3B
 DB '='
 DW X3D
 DB '?'
 DW X3F
 DB '@'
 DW X40
 DB '['
 DW X5B
 DB '\'
 DW X5C
 DB ']'
 DW X5D
 DB '^'
 DW X5E
 DB '_'
 DW X5F
 DB '`'
 DW X60
 DB '{'
 DW X7B
 DB '|'
 DW X7C
 DB '}'
 DW X7D
 DB '~'
 DW X7E
 DB RO
 DW X7F
 DB 0 ; END OF TABLE
VOX6CODE LABEL WORD ; FOR BRAILLE & SPEAK
VOX7CODE LABEL WORD ; FOR ACCENT
VOX10CODE LABEL WORD ; FOR BRAILLE MATE
 DB 31
 DW X1F
 DB 32
 DW X20
 DB '!'
 DW X21
 DB '"'
 DW X22
 DB 39
 DW X27
 DB '('
 DW X28
 DB ')'
 DW X29
 DB '*'
 DW X2A
 DB '+'
 DW X2B
 DB ','
 DW X2C
 DB '-'
 DW X2D
 DB '.'
 DW X2E
 DB ':'
 DW X3A
 DB ';'
 DW X3B
 DB '<'
 DW X3C
 DB '>'
 DW X3E
 DB '?'
 DW X3F
 DB '['
 DW X5B
 DB '\'
 DW X5C
 DB ']'
 DW X5D
 DB '^'
 DW X5E
 DB '_'
 DW X5F
 DB '`'
 DW X60
 DB '{'
 DW X7B
 DB '|'
 DW X7C
 DB '}'
 DW X7D
 DB '~'
 DW X7E
 DB RO
 DW X7F
 DB 0 ; END OF TABLE
; HEX CODES
X1F DB 'enter', 0
X20 DB 'space', 0
X21 DB 'exclamation', 0
X40 DB 'at sign', 0
X5E DB 'carit', 0
X29 DB 'right '
X28 DB 'paren ', 0
X2A DB 'star', 0
X2B DB 'plus', 0
X2C DB 'comma ', CR, 0
X2D DB 'dash', 0
X5F DB 'underscore', 0
X5D DB 'right '
X5B DB 'brackit', 0
X7D DB 'right '
X7B DB 'brace', 0
X3B DB 'semi'
X3A DB 'colen', 0
X3B1 DB 'semi'
X3A1 DB 'colOn', 0
X22 DB 'quote', 0
X23 DB 'number', 0
X24 DB 'dollar', 0
X25 DB 'percent', 0
X26 DB 'and', 0
X27 DB 'uhposstruphy', 0
X27A DB 'tick', 0
X60 DB 'axent', 0
X7E DB 'tillda', 0
X7F DB 13, 0
X7F1 DB ',', 0
X5C DB 'back slash', 0
X7C DB 'vertical line', 0
X2E DB 'pirRyid', 0
X2E1 DB 'period', 0
X2F DB 'slash', 0
X3C DB 'less than', 0
X3D DB 'equals', 0
X3E DB 'grater than', 0
X3F DB 'question', 0
SEND1CAP DB 'cap', 0
SEND1CHAR ENDP
MOVE1STRING PROC NEAR
 MOV AX, SPC
 PUSH AX
 JMP SHORT MOVE1S2
MOVE1S1: MOV AL, BYTE PTR [BX] ; NEXT CHAR TO AL
 TEST AL, AL ; MESSAGE DONE?
 JZ MOVE1S3 ; IF YES
 PUSH AX
 INC BX
MOVE1S2: PUSH BX
 CALL VOX3MOVE
 POP BX
 POP AX
 JMP SHORT MOVE1S1
MOVE1S3: MOV AX, SPC
VOX3MOVE PROC NEAR
 AND AL, NOT (1 SHL 7)
 CMP AL, SPC ; CTRL CHAR?
 JA VOX3MV3
 MOV AH, BYTE PTR LAST1MOVED
 TEST AL, AL ; NULL CHAR?
 JNZ VOX3MV1
 MOV AL, CR ; USE CR IF SO
VOX3MV1: CMP AL, CR
 JE VOX3MV2 ; KEEP IT
 CMP AH, SPC ; AFTER SPACE?
 JE VOX3MV6
 MOV AL, SPC
VOX3MV2: CMP AH, CR ; AFTER CR?
 JE VOX3MV6
VOX3MV3: CBW
 MOV BX, WORD PTR SHELFCOUNT
 CMP AL,CR
 JE VOX3MV5 ; IF SO
 CMP BX, SHELFSIZE SHR 1
 JL VOX3MV5
 CMP AL, SPC
 JE VOX3MV4
 CMP BX, SHELFSIZE-3
 JL VOX3MV5
 MOV WORD PTR SHELF[BX], AX
 INC BX
 INC WORD PTR SHELFCOUNT
VOX3MV4: MOV AL, CR
VOX3MV5: MOV WORD PTR SHELF[BX], AX
 MOV BYTE PTR LAST1MOVED, AL
 INC WORD PTR SHELFCOUNT
 CMP AL, CR
 JNE VOX3MV6
 OR WORD PTR STATES1, HOLDING
VOX3MV6: RET
VOX3MOVE ENDP
MOVE1STRING ENDP
GETNUMBER PROC NEAR
 XOR AX, AX
 XOR DX, DX
 CMP BYTE PTR [BX],'+'
 JE GETNUMB1
 CMP BYTE PTR [BX],'-'
 JNE GETNUMB2
 INC DX
GETNUMB1: INC BX
GETNUMB2: PUSH DX
 CALL GETDIGIT
 POP DX
 TEST DX, DX
 JZ GETNUMB3
 MOV DX, AX
 XOR AX, AX
 SUB AX, DX
GETNUMB3: RET
GETNUMBER ENDP
GETDIGIT PROC NEAR ; RECURSIVE
 CMP BYTE PTR [BX],'0'
 JL GETDIGIT0
 CMP BYTE PTR [BX],'9'+1
 JL GETDIGIT1
GETDIGIT0: RET
GETDIGIT1: MOV CL, 10
 MUL CL
 MOV CX, AX
 MOV AL, BYTE PTR [BX]
 AND AX, 15
 ADD AX, CX
 INC BX
 CALL GETDIGIT
 RET
GETDIGIT ENDP
; START UP CODE OVERLAPS WITH STACKS AND BUFFERS
PTRSAV  DD ?  ; Request packet pointer
STRATEGY PROC FAR
 MOV WORD PTR CS:PTRSAV, BX
 MOV WORD PTR CS:PTRSAV+2, ES
 RET
STRATEGY ENDP
ACTIVITY PROC FAR
 PUSH AX
 PUSH BX
 PUSH DS
 PUSH ES
 MOV AX, CS
 MOV DS, AX
 LES BX, PTRSAV ; Get packet addr
 MOV AL, ES:[BX+2] ; Get command
 TEST AL, AL ; Is command valid ?
 JZ CMD_OKAY 
 MOV AL, 3 ; Get UNKNOWN CODE
 MOV AH, 1 SHL 7 OR 1 ; Mark error and done
 JMP SHORT EXIT1 ; Join code
CMD_OKAY: CALL INSTALL
 AND WORD PTR STATES0, NOT TSR_TYPE
 MOV DX, OFFSET RESIDENTEND  ; DS:DX Points to end
 LES BX, PTRSAV
 MOV ES:[BX+14], DX
 MOV ES:[BX+16],CS 
 MOV AH, 1 ; Mark as done
EXIT1: LES BX, CS:PTRSAV ; Get packet addr
 MOV ES:[BX+3], AX ; Store status
 POP ES  ; Restore regs
 POP DS
 POP BX
 POP AX
 RET
MSG DB CR, LF
 DB 'provox 6.00 -- Copyright (c) 1985 - 1997 KanSys, Inc.'
 DB CR, LF, 0
ACTIVITY ENDP
INSTALL PROC NEAR
 XOR AX, AX ; SET UP INTERRUPT VECTORS
 MOV ES, AX
 CLI ; HOLD INTERRUPTS
 MOV AX, WORD PTR ES:[20] ; I5 -- PRINT SCREEN
 MOV WORD PTR I5RETURN+1, AX
 MOV AX, WORD PTR ES:[22]
 MOV WORD PTR I5RETURN+3, AX
 MOV AX, WORD PTR ES:[32] ; I8 -- SYSTEM CLOCK
 MOV WORD PTR I8RETURN+1, AX
 MOV AX, WORD PTR ES:[34]
 MOV WORD PTR I8RETURN+3, AX
 MOV AX, WORD PTR ES:[36] ; I9 -- KEYBOARD (HARDWARE)
 MOV WORD PTR I9RETURN+1, AX
 MOV AX, WORD PTR ES:[38]
 MOV WORD PTR I9RETURN+3, AX
 MOV AX, WORD PTR ES:[64] ; I16 -- VIDEO SERVICES
 MOV WORD PTR I16RETURN+1, AX
 MOV AX, WORD PTR ES:[66]
 MOV WORD PTR I16RETURN+3, AX
 MOV AX, WORD PTR ES:[88] ; I22 -- KEYBOARD (SOFTWARE)
 MOV WORD PTR I22RETURN+1, AX
 MOV AX, WORD PTR ES:[90]
 MOV WORD PTR I22RETURN+3, AX
 MOV AX, WORD PTR ES:[92] ; I23 -- PRINTER
 MOV WORD PTR I23PORT, AX
 MOV AX, WORD PTR ES:[94]
 MOV WORD PTR I23PORT+2, AX
 MOV AX, WORD PTR ES:[188] ; I47 -- DOS MULTIPLEX
 MOV WORD PTR I47RETURN+1, AX
 MOV AX, WORD PTR ES:[190]
 MOV WORD PTR I47RETURN+3, AX
 MOV AX,CS ; GET THIS SEGMENT
 MOV WORD PTR ES:20, OFFSET I5ENTRY
 MOV WORD PTR ES:22, AX
 MOV WORD PTR ES:32, OFFSET I8ENTRY
 MOV WORD PTR ES:34, AX
 MOV WORD PTR ES:36, OFFSET I9ENTRY
 MOV WORD PTR ES:38, AX
 MOV WORD PTR ES:64, OFFSET I16ENTRY
 MOV WORD PTR ES:66, AX
 MOV WORD PTR ES:88, OFFSET I22ENTRY
 MOV WORD PTR ES:90, AX
 MOV WORD PTR ES:188, OFFSET I47ENTRY
 MOV WORD PTR ES:190, AX
 STI ; TAKE INTERRUPTS
 MOV AX, 64
 MOV ES, AX
 MOV SI, WORD PTR ES:[78] ; PAGE OFFSET
 MOV AX, 0B800H ; CGA VIDEO SEGMENT
 CMP BYTE PTR ES:[73], 4
 JB INST1
 MOV AX, 0B000H ; MODE 7 VIDEO SEGMENT
INST1: MOV DS, AX
 MOV AL, BYTE PTR ES:[98] ; VIDEO PAGE
 SHL AX, 1
 MOV BX, 80 ; CURSOR LIST
 ADD BX, AX
 MOV BL, BYTE PTR ES:[74] ; LINE WIDTH
 XOR BH, BH
 MOV CL, BYTE PTR ES:[BX+1] ; CURSOR LINE
 INC CL
 XOR CH, CH
INSTX2: PUSH CX
 MOV CX, BX
 XOR DX, DX
INST3: CLD
 LODSW ; get video word
 TEST AL, 1 SHL 7
 JNZ INST2
 CMP AL, SPC
 JA INST4
INST2: MOV AL, SPC
 CMP DL, AL
 JE INST5
INST4: MOV DL, AL
 PUSH CX
 PUSH DX
 PUSH DS
 PUSH CS
 POP DS
 CALL SAVE1DATA
 POP DS
 POP DX
 POP CX
INST5: LOOP INST3
 MOV AL, CR
 PUSH DS
 PUSH CS
 POP DS
 CALL SAVE1DATA
 POP DS
 POP CX
 LOOP INSTX2
 MOV AX, CS
 MOV DS, AX
 MOV WORD PTR MSG[11], REVISION
 XOR BX, BX ; SIGN ON BANNER
INST6: MOV AL, BYTE PTR MSG[BX]
 TEST AL, AL ; DONE?
 JZ INST7
 PUSH BX
 MOV BH, BYTE PTR ES:[98] ; CURRENT PAGE
 MOV AH, 14 ; WTT
 INT 16
 POP BX
 INC BX
 JMP SHORT INST6
INST7: AND BYTE PTR STATES0, NOT ENHANCED ; CHECK THE KEYBOARD
 TEST BYTE PTR ES:[150], 1 SHL 4 ; ENHANCED?
 JZ INST8 ; IF NOT
 OR BYTE PTR STATES0, ENHANCED
 AND BYTE PTR ES:[23], NOT (1 SHL 5) ; CLEAR NUMLOCK
INST8: MOV WORD PTR I8TONE, OFFSET I8RISE ; SAY HELLO
 MOV AL, BYTE PTR BOXDRIVE
 CALL ISUPPER
 JNC INST9
 MOV BYTE PTR FILENAME+0, AL
 MOV BYTE PTR BINFILE+0, AL
INST9: MOV AX, 4 SHL 8 ; CHECK THE DATE
 INT 26
 MOV AH, CL ; YEAR
 AND AH, 8 OR 4 OR 2 OR 1
 MOV AL, CL
 SHR AL, 1
 SHR AL, 1
 SHR AL, 1
 SHR AL, 1
 ADD WORD PTR FILENAME+5, AX
 ADD WORD PTR BINFILE+5, AX
 MOV AH, DH ; MONTH
 AND AH, 8 OR 4 OR 2 OR 1
 MOV AL, DH
 SHR AL, 1
 SHR AL, 1
 SHR AL, 1
 SHR AL, 1
 ADD WORD PTR FILENAME+7, AX
 ADD WORD PTR BINFILE+7, AX
 MOV AH, DL ; DAY
 AND AH, 8 OR 4 OR 2 OR 1
 MOV AL, DL
 SHR AL, 1
 SHR AL, 1
 SHR AL, 1
 SHR AL, 1
 ADD WORD PTR FILENAME+9, AX
 ADD WORD PTR BINFILE+9, AX
 RET
INSTALL ENDP
; ENTRY FOR TSR
TSR_ENTRY: MOV AX, CS
 MOV DS, AX
 MOV AX,SYSNUMBER SHL 8 ; ASK IF PROVOX PRESENT
 INT 47
 CMP AX, NOT 0
 JE TSR_ERROR
 CALL INSTALL
 OR WORD PTR STATES0, TSR_TYPE
 MOV AX,CS ; TIME TO TSR
 MOV ES, AX ; RESTORE ES
 MOV DX, OFFSET RESIDENTEND+256
 INT 39 ; EXIT, KEEP RESIDENT ROUTINES
TSR_ERROR: MOV DX, OFFSET MSG1
 MOV CX, OFFSET FREESPACE - OFFSET MSG1
 MOV BX, STDERR
 MOV AX, 64 SHL 8 ; WRITE
 INT 33
 MOV AX, 76 SHL 8 + 1 ; EXIT WITH ERROR CODE
 INT 33
MSG1 DB CR, LF, ' * * PROVOX already installed', CR, LF
FREESPACE LABEL NEAR
; VIRTUAL BUFFER AND STACKS
INT5_STACK EQU PTRSAV + STACKSIZE
INT8_STACK EQU INT5_STACK + STACKSIZE
INT9_STACK EQU INT8_STACK + STACKSIZE
CLIPBOARD EQU INT9_STACK
BUFFER EQU CLIPBOARD + CLIPSIZE
RESIDENTEND EQU BUFFER + BUFSIZE
PROVOX ENDS
 END TSR_ENTRY

