/*
 ***********************************************************************
 *                                                                      
 *                           Copyright                               
 *    Copyright  2000-2001 Force Computers, Inc., a Solectron company. All rights reserved.
 *     Digital Equipment Corporation 1995, 1996, 1997. All rights reserved.        
 *
 *    Restricted Rights: Use, duplication, or disclosure by the U.S.    
 *    Government is subject to restrictions as set forth in subparagraph
 *    (c) (1) (ii) of DFARS 252.227-7013, or in FAR 52.227-19, or in FAR
 *    52.227-14 Alt. III, as applicable.                                
 *                                                                      
 *    This software is proprietary to and embodies the confidential     
 *    technology of Force Computers Incorporated and other parties.    
 *    Possession, use, or copying of this software and media is authorized
 *    only pursuant to a valid written license from Force or an        
 *    authorized sublicensor.                                            
 *                                                                       
 *********************************************************************** 
 *    File Name:	l_fr_rta.c
 *    Author:		
 *    Creation Date:
 *                                                                             
 *    Functionality:                                                           
 *    The French Rule tables                                                                             
 *                                                                             
 ***********************************************************************       
 *    Revision History:
 *                                                                             
 * Rev	Who		Date			Description                    
 * ---	-----	-----------		---------------------------------------
 * 001	CHJ		07/20/2000		Created from old fregles.c and fp2regls.c
 * 002 	CAB		10/16/2000		Changed copyright info
 * 003 	CAB		01/15/2001		Merged Michel Divay changes to French
 * 004	CAB		01/25/2001		Replaced defines with U8 and U16
 *
 */

#include "ls_def.h"
/* * Generation de : c:\temp\reglesf.cpp * source file   : francais/reglesf.lre */

const int NbTCod = 0x0273;
const short NC     = 0x0090;
const short PtCar = 0x0000;
const short PgCar = 0x00FF;

const U16 IndAlph [] = {
/*   0 */ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
/*   8 */ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
/*  16 */ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
/*  24 */ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
/*  32 */ 0x0001, 0x0005, 0x0009, 0x000D, 0x0011, 0x0015, 0x0019, 0x001D,
/*  40 */ 0x0021, 0x0025, 0x0029, 0x002D, 0x0031, 0x0035, 0x0039, 0x0000,
/*  48 */ 0x003D, 0x0041, 0x0045, 0x0049, 0x004D, 0x0051, 0x0055, 0x0059,
/*  56 */ 0x005D, 0x0061, 0x0065, 0x0069, 0x0000, 0x006D, 0x0000, 0x0071,
/*  64 */ 0x0075, 0x0079, 0x007D, 0x0081, 0x0085, 0x0089, 0x008D, 0x0091,
/*  72 */ 0x0095, 0x0099, 0x009D, 0x00A1, 0x00A5, 0x00A9, 0x00AD, 0x00B1,
/*  80 */ 0x00B5, 0x00B9, 0x00BD, 0x00C1, 0x00C5, 0x00C9, 0x00CD, 0x00D1,
/*  88 */ 0x00D5, 0x00D9, 0x00DD, 0x00E1, 0x0000, 0x01BC, 0x0000, 0x0000,
/*  96 */ 0x0000, 0x01C0, 0x01C4, 0x01C8, 0x01CC, 0x01D0, 0x01D4, 0x01D8,
/* 104 */ 0x01DC, 0x01E0, 0x01E4, 0x01E8, 0x01EC, 0x01F0, 0x01F4, 0x01F8,
/* 112 */ 0x01FC, 0x0200, 0x0204, 0x0208, 0x020C, 0x0210, 0x0214, 0x0218,
/* 120 */ 0x021C, 0x0220, 0x0224, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
/* 128 */ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
/* 136 */ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
/* 144 */ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
/* 152 */ 0x0000, 0x0000, 0x0000, 0x0000, 0x0228, 0x0000, 0x0000, 0x0000,
/* 160 */ 0x0000, 0x0000, 0x0000, 0x0000, 0x022C, 0x0000, 0x0000, 0x0000,
/* 168 */ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
/* 176 */ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
/* 184 */ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
/* 192 */ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0230,
/* 200 */ 0x0000, 0x0234, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
/* 208 */ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
/* 216 */ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
/* 224 */ 0x0238, 0x0000, 0x023C, 0x0000, 0x0000, 0x0000, 0x0240, 0x0244,
/* 232 */ 0x0248, 0x024C, 0x0250, 0x0254, 0x0000, 0x0000, 0x0258, 0x025C,
/* 240 */ 0x0000, 0x0000, 0x0000, 0x0000, 0x0260, 0x0000, 0x0264, 0x0000,
/* 248 */ 0x0000, 0x0268, 0x0000, 0x026C, 0x0270, 0x0000, 0x0000, 0x0000

} ;

const U8 TCod [] = {
/*   0 */ 0x00, 0x01, 0x01, 0x20, 0x5B, 0x01, 0x01, 0x21,
/*   8 */ 0x52, 0x01, 0x01, 0x22, 0x5F, 0x01, 0x01, 0x23,
/*  16 */ 0x5D, 0x01, 0x01, 0x24, 0x4F, 0x01, 0x01, 0x25,
/*  24 */ 0x63, 0x01, 0x01, 0x26, 0x53, 0x01, 0x01, 0x27,
/*  32 */ 0x57, 0x01, 0x01, 0x28, 0x60, 0x01, 0x01, 0x29,
/*  40 */ 0x61, 0x01, 0x01, 0x2A, 0x50, 0x01, 0x01, 0x2B,
/*  48 */ 0x54, 0x01, 0x01, 0x2C, 0x55, 0x01, 0x01, 0x2D,
/*  56 */ 0x5C, 0x01, 0x01, 0x2E, 0x4E, 0x01, 0x01, 0x30,
/*  64 */ 0x44, 0x01, 0x01, 0x31, 0x45, 0x01, 0x01, 0x32,
/*  72 */ 0x46, 0x01, 0x01, 0x33, 0x47, 0x01, 0x01, 0x34,
/*  80 */ 0x48, 0x01, 0x01, 0x35, 0x49, 0x01, 0x01, 0x36,
/*  88 */ 0x4A, 0x01, 0x01, 0x37, 0x4B, 0x01, 0x01, 0x38,
/*  96 */ 0x4C, 0x01, 0x01, 0x39, 0x4D, 0x01, 0x01, 0x3A,
/* 104 */ 0x58, 0x01, 0x01, 0x3B, 0x56, 0x01, 0x01, 0x3D,
/* 112 */ 0x5E, 0x01, 0x01, 0x3F, 0x5A, 0x01, 0x01, 0x40,
/* 120 */ 0x51, 0x01, 0x01, 0x41, 0x28, 0x01, 0x01, 0x42,
/* 128 */ 0x2F, 0x01, 0x01, 0x43, 0x30, 0x01, 0x01, 0x44,
/* 136 */ 0x32, 0x01, 0x01, 0x45, 0x29, 0x01, 0x01, 0x46,
/* 144 */ 0x33, 0x01, 0x01, 0x47, 0x34, 0x01, 0x01, 0x48,
/* 152 */ 0x35, 0x01, 0x01, 0x49, 0x2A, 0x01, 0x01, 0x4A,
/* 160 */ 0x36, 0x01, 0x01, 0x4B, 0x37, 0x01, 0x01, 0x4C,
/* 168 */ 0x38, 0x01, 0x01, 0x4D, 0x39, 0x01, 0x01, 0x4E,
/* 176 */ 0x3A, 0x01, 0x01, 0x4F, 0x2B, 0x01, 0x01, 0x50,
/* 184 */ 0x3B, 0x01, 0x01, 0x51, 0x3C, 0x01, 0x01, 0x52,
/* 192 */ 0x3D, 0x01, 0x01, 0x53, 0x3E, 0x01, 0x01, 0x54,
/* 200 */ 0x3F, 0x01, 0x01, 0x55, 0x2C, 0x01, 0x01, 0x56,
/* 208 */ 0x40, 0x01, 0x01, 0x57, 0x41, 0x01, 0x01, 0x58,
/* 216 */ 0x42, 0x01, 0x01, 0x59, 0x2D, 0x01, 0x01, 0x5A,
/* 224 */ 0x43, 0x29, 0x03, 0x5B, 0x41, 0x5D, 0x01, 0x04,
/* 232 */ 0x5B, 0x41, 0x6E, 0x5D, 0x0D, 0x04, 0x5B, 0x41,
/* 240 */ 0x70, 0x5D, 0x11, 0x04, 0x5B, 0x41, 0x75, 0x5D,
/* 248 */ 0x04, 0x03, 0x5B, 0x42, 0x5D, 0x1E, 0x04, 0x5B,
/* 256 */ 0x43, 0x68, 0x5D, 0x17, 0x03, 0x5B, 0x44, 0x5D,
/* 264 */ 0x1F, 0x04, 0x5B, 0x45, 0x45, 0x5D, 0x8F, 0x03,
/* 272 */ 0x5B, 0x45, 0x5D, 0x05, 0x04, 0x5B, 0x45, 0x75,
/* 280 */ 0x5D, 0x07, 0x03, 0x5B, 0x46, 0x5D, 0x18, 0x03,
/* 288 */ 0x5B, 0x47, 0x5D, 0x20, 0x04, 0x5B, 0x47, 0x6E,
/* 296 */ 0x5D, 0x24, 0x03, 0x5B, 0x49, 0x5D, 0x08, 0x04,
/* 304 */ 0x5B, 0x49, 0x6E, 0x5D, 0x0E, 0x03, 0x5B, 0x4A,
/* 312 */ 0x5D, 0x19, 0x03, 0x5B, 0x4B, 0x5D, 0x21, 0x03,
/* 320 */ 0x5B, 0x4C, 0x5D, 0x12, 0x03, 0x5B, 0x4D, 0x5D,
/* 328 */ 0x25, 0x03, 0x5B, 0x4E, 0x5D, 0x26, 0x04, 0x5B,
/* 336 */ 0x4E, 0x67, 0x5D, 0x27, 0x04, 0x5B, 0x4F, 0x36,
/* 344 */ 0x5D, 0x0A, 0x03, 0x5B, 0x4F, 0x5D, 0x09, 0x04,
/* 352 */ 0x5B, 0x4F, 0x6E, 0x5D, 0x0F, 0x04, 0x5B, 0x4F,
/* 360 */ 0x75, 0x5D, 0x0B, 0x03, 0x5B, 0x50, 0x5D, 0x22,
/* 368 */ 0x03, 0x5B, 0x52, 0x5D, 0x13, 0x04, 0x5B, 0x52,
/* 376 */ 0x78, 0x5D, 0x1A, 0x03, 0x5B, 0x53, 0x5D, 0x1B,
/* 384 */ 0x03, 0x5B, 0x54, 0x5D, 0x23, 0x03, 0x5B, 0x55,
/* 392 */ 0x5D, 0x0C, 0x04, 0x5B, 0x55, 0x6E, 0x5D, 0x10,
/* 400 */ 0x03, 0x5B, 0x56, 0x5D, 0x1C, 0x03, 0x5B, 0x57,
/* 408 */ 0x5D, 0x14, 0x04, 0x5B, 0x57, 0x75, 0x5D, 0x15,
/* 416 */ 0x03, 0x5B, 0x59, 0x5D, 0x16, 0x03, 0x5B, 0x5A,
/* 424 */ 0x5D, 0x1D, 0x03, 0x5B, 0xE2, 0x5D, 0x02, 0x03,
/* 432 */ 0x5B, 0xE8, 0x5D, 0x03, 0x03, 0x5B, 0xE9, 0x5D,
/* 440 */ 0x06, 0x01, 0x5B, 0x62, 0x01, 0x01, 0x5D, 0x59,
/* 448 */ 0x01, 0x01, 0x61, 0x73, 0x01, 0x01, 0x62, 0x7A,
/* 456 */ 0x01, 0x01, 0x63, 0x7B, 0x01, 0x01, 0x64, 0x7C,
/* 464 */ 0x01, 0x01, 0x65, 0x74, 0x01, 0x01, 0x66, 0x7D,
/* 472 */ 0x01, 0x01, 0x67, 0x7E, 0x01, 0x01, 0x68, 0x7F,
/* 480 */ 0x01, 0x01, 0x69, 0x75, 0x01, 0x01, 0x6A, 0x80,
/* 488 */ 0x01, 0x01, 0x6B, 0x81, 0x01, 0x01, 0x6C, 0x82,
/* 496 */ 0x01, 0x01, 0x6D, 0x83, 0x01, 0x01, 0x6E, 0x84,
/* 504 */ 0x01, 0x01, 0x6F, 0x76, 0x01, 0x01, 0x70, 0x86,
/* 512 */ 0x01, 0x01, 0x71, 0x87, 0x01, 0x01, 0x72, 0x88,
/* 520 */ 0x01, 0x01, 0x73, 0x89, 0x01, 0x01, 0x74, 0x8A,
/* 528 */ 0x01, 0x01, 0x75, 0x77, 0x01, 0x01, 0x76, 0x8B,
/* 536 */ 0x01, 0x01, 0x77, 0x8C, 0x01, 0x01, 0x78, 0x8D,
/* 544 */ 0x01, 0x01, 0x79, 0x78, 0x01, 0x01, 0x7A, 0x8E,
/* 552 */ 0x01, 0x01, 0x9C, 0x67, 0x01, 0x01, 0xA4, 0x85,
/* 560 */ 0x01, 0x01, 0xC7, 0x31, 0x01, 0x01, 0xC9, 0x2E,
/* 568 */ 0x01, 0x01, 0xE0, 0x64, 0x01, 0x01, 0xE2, 0x65,
/* 576 */ 0x01, 0x01, 0xE6, 0x66, 0x01, 0x01, 0xE7, 0x79,
/* 584 */ 0x01, 0x01, 0xE8, 0x69, 0x01, 0x01, 0xE9, 0x68,
/* 592 */ 0x01, 0x01, 0xEA, 0x6A, 0x01, 0x01, 0xEB, 0x6B,
/* 600 */ 0x01, 0x01, 0xEE, 0x6C, 0x01, 0x01, 0xEF, 0x6D,
/* 608 */ 0x01, 0x01, 0xF4, 0x6E, 0x01, 0x01, 0xF6, 0x6F,
/* 616 */ 0x01, 0x01, 0xF9, 0x70, 0x01, 0x01, 0xFB, 0x71,
/* 624 */ 0x01, 0x01, 0xFC, 0x72
} ;

const U16 InvAlph [] = {
/*   0 */ 0x0000, 0x00E2, 0x01AA, 0x01AF, 0x00F3, 0x010F, 0x01B4, 0x0114,
/*   8 */ 0x012A, 0x015A, 0x0154, 0x0165, 0x0185, 0x00E7, 0x012F, 0x015F,
/*  16 */ 0x018A, 0x00ED, 0x013F, 0x0170, 0x0195, 0x019A, 0x01A0, 0x00FE,
/*  24 */ 0x011A, 0x0135, 0x0175, 0x017B, 0x0190, 0x01A5, 0x00F9, 0x0104,
/*  32 */ 0x011F, 0x013A, 0x016B, 0x0180, 0x0124, 0x0144, 0x0149, 0x014E,
/*  40 */ 0x007A, 0x008A, 0x009A, 0x00B2, 0x00CA, 0x00DA, 0x0235, 0x007E,
/*  48 */ 0x0082, 0x0231, 0x0086, 0x008E, 0x0092, 0x0096, 0x009E, 0x00A2,
/*  56 */ 0x00A6, 0x00AA, 0x00AE, 0x00B6, 0x00BA, 0x00BE, 0x00C2, 0x00C6,
/*  64 */ 0x00CE, 0x00D2, 0x00D6, 0x00DE, 0x003E, 0x0042, 0x0046, 0x004A,
/*  72 */ 0x004E, 0x0052, 0x0056, 0x005A, 0x005E, 0x0062, 0x003A, 0x0012,
/*  80 */ 0x002A, 0x0076, 0x0006, 0x001A, 0x002E, 0x0032, 0x006A, 0x001E,
/*  88 */ 0x0066, 0x01BD, 0x0072, 0x0002, 0x0036, 0x000E, 0x006E, 0x000A,
/*  96 */ 0x0022, 0x0026, 0x01B9, 0x0016, 0x0239, 0x023D, 0x0241, 0x0229,
/* 104 */ 0x024D, 0x0249, 0x0251, 0x0255, 0x0259, 0x025D, 0x0261, 0x0265,
/* 112 */ 0x0269, 0x026D, 0x0271, 0x01C1, 0x01D1, 0x01E1, 0x01F9, 0x0211,
/* 120 */ 0x0221, 0x0245, 0x01C5, 0x01C9, 0x01CD, 0x01D5, 0x01D9, 0x01DD,
/* 128 */ 0x01E5, 0x01E9, 0x01ED, 0x01F1, 0x01F5, 0x022D, 0x01FD, 0x0201,
/* 136 */ 0x0205, 0x0209, 0x020D, 0x0215, 0x0219, 0x021D, 0x0225, 0x0109

} ; 
const int NbTabCl = 0x005B;
const int NbTTUC  = 0x131F;
const int NbChCl  = 0x3F52;
const int NbNdCl  = 0x0000;


#ifdef DEBG
const char* NomCl[] = {
"C",
"CSSLI",
"C-LR",
"CE",
"CEHTB",
"LR",
"LMNR",
"C-H",
"C-N",
"C-NH",
"C-NS",
"C-R",
"C-S",
"MN",
"C-MN",
"C-MNH",
"C-MNS",
"C-MNSH",
"CPS",
"SXZ",
"V",
"VPB",
"VME",
"VC",
"VCS",
"VSCG",
"VP",
"VPSV",
"VPSOFI",
"LRP",
"LNRP",
"CP",
"OBSTR",
"SV",
"VHMUET",
"DT",
"N",
"FINSXZ",
"PRSTIR",
"ELISION",
"FinMot",
"PCF",
"PDF",
"PENTF",
"MENTF",
"PERF",
"NPERF",
"PERF2",
"PGF",
"MIENTF",
"PILF",
"PPF",
"PPSF",
"NPSF",
"PTF",
"NPTF",
"PASF",
"PSF",
"PISF",
"POSF",
"PUSF",
"PUSFGR",
"PSF",
"PXF",
"MXF",
"MONF",
"MMANF",
"PANF",
"MINF",
"MOMF",
"PREFIX",
"SS",
"SEU",
"VATER",
"VITER",
"VOTER",
"VUTER",
"VNTER",
"VCTER",
"VPTER",
"VTIONS",
"PGN",
"PCH",
"PILLD",
"PILL",
"PPT",
"PTI",
"PTIEN",
"PTIA",
"TFIN",
"PAY",
"SCH"
};
#endif


const U8 TypClas [] = {
/*   0 */   1,   1,   1,   1,   1,   1,   1,   1,
/*   8 */   1,   1,   1,   1,   1,   1,   1,   1,
/*  16 */   1,   1,   1,   1,   1,   1,   1,   1,
/*  24 */   1,   1,   1,   1,   1,   1,   1,   1,
/*  32 */   1,   1,   5,   4,   4,   4,   4,   4,
/*  40 */   5,   5,   4,   5,   4,   4,   5,   4,
/*  48 */   4,   4,   4,   4,   4,   5,   4,   5,
/*  56 */   4,   4,   4,   4,   4,   4,   4,   5,
/*  64 */   4,   4,   4,   4,   4,   4,   4,   5,
/*  72 */   5,   4,   4,   4,   4,   4,   4,   4,
/*  80 */   4,   4,   4,   4,   5,   5,   5,   4,
/*  88 */   4,   4,   4,   5
} ; 

const U16 DebClasse [] = {
/*   0 */     0,   144,   288,   432,   576,   720,   864,  1008,
/*   8 */  1152,  1296,  1440,  1584,  1728,  1872,  2016,  2160,
/*  16 */  2304,  2448,  2592,  2736,  2880,  3024,  3168,  3312,
/*  24 */  3456,  3600,  3744,  3888,  4032,  4176,  4320,  4464,
/*  32 */  4608,  4752,     0,   411,   610,   648,  1013,  1031,
/*  40 */  1112,  1123,  1209,  1651,  1848,  3040,  4175,  4237,
/*  48 */  4681,  5030,  5187,  5240,  5628,  5814,  5922,  7360,
/*  56 */  7390,  7807,  7975,  9156,  9595, 10498, 11420, 11532,
/*  64 */ 11550, 11618, 11857, 12129, 12197, 12348, 12423, 13193,
/*  72 */ 13249, 13284, 13379, 13646, 13752, 13904, 14334, 14374,
/*  80 */ 14431, 14682, 14768, 15138, 15332, 15388, 15415, 15481,
/*  88 */ 15609, 15882, 15941, 16041
} ; 

const U8 TTUC [] = {
/*   0 */ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/*   8 */ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7F,
/*  16 */ 0xFB, 0xFE, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/*  24 */ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/*  32 */ 0x00, 0x77, 0xF3, 0x98, 0x00, 0x00, 0x00, 0x00,
/*  40 */ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/*  48 */ 0x00, 0x00, 0x00, 0x7F, 0xDB, 0x7E, 0x00, 0x00,
/*  56 */ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/*  64 */ 0x00, 0x00, 0x00, 0x00, 0x00, 0x2E, 0x02, 0x18,
/*  72 */ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/*  80 */ 0x00, 0x00, 0x01, 0x18, 0x00, 0x00, 0x00, 0x2F,
/*  88 */ 0x02, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/*  96 */ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 104 */ 0x00, 0x00, 0x20, 0x80, 0x00, 0x00, 0x00, 0x00,
/* 112 */ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 120 */ 0x00, 0x00, 0x00, 0x00, 0x38, 0x80, 0x00, 0x00,
/* 128 */ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 136 */ 0x00, 0x00, 0x00, 0x00, 0x00, 0x7E, 0xFB, 0xFE,
/* 144 */ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 152 */ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7F,
/* 160 */ 0xF3, 0xFE, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 168 */ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 176 */ 0x00, 0x7E, 0xF3, 0xFE, 0x00, 0x00, 0x00, 0x00,
/* 184 */ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 192 */ 0x00, 0x00, 0x00, 0x7F, 0xF3, 0xBE, 0x00, 0x00,
/* 200 */ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 208 */ 0x00, 0x00, 0x00, 0x00, 0x00, 0x7F, 0xFB, 0x7E,
/* 216 */ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 224 */ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7F,
/* 232 */ 0xFB, 0xBE, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 240 */ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 248 */ 0x00, 0x00, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 256 */ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 264 */ 0x00, 0x00, 0x00, 0x7F, 0xE3, 0xFE, 0x00, 0x00,
/* 272 */ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 280 */ 0x00, 0x00, 0x00, 0x00, 0x00, 0x7E, 0xE3, 0xFE,
/* 288 */ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 296 */ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7F,
/* 304 */ 0xE3, 0xBE, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 312 */ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 320 */ 0x00, 0x7E, 0xE3, 0xBE, 0x00, 0x00, 0x00, 0x00,
/* 328 */ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 336 */ 0x00, 0x00, 0x00, 0x10, 0x02, 0x40, 0x00, 0x00,
/* 344 */ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 352 */ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46,
/* 360 */ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 368 */ 0x00, 0x00, 0x01, 0x00, 0x0E, 0xFF, 0xFF, 0x80,
/* 376 */ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 384 */ 0x00, 0x00, 0x00, 0x00, 0x01, 0x18, 0x0C, 0xFF,
/* 392 */ 0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 400 */ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
/* 408 */ 0x0C, 0xFF, 0xF7, 0x80, 0x00, 0x00, 0x00, 0x00,
/* 416 */ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 424 */ 0x01, 0x00, 0x0C, 0xFF, 0xFF, 0xFF, 0xFB, 0xFE,
/* 432 */ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 440 */ 0x00, 0x00, 0x01, 0x00, 0x0C, 0xFF, 0xFF, 0xFF,
/* 448 */ 0xFB, 0xBE, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 456 */ 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x02, 0xFC,
/* 464 */ 0x0C, 0x80, 0x00, 0x00, 0x7F, 0xFF, 0x80, 0x00,
/* 472 */ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 480 */ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7F, 0xFF,
/* 488 */ 0x8E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 496 */ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 504 */ 0x7F, 0x7F, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 512 */ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 520 */ 0x00, 0x00, 0x00, 0x00, 0x30, 0x00, 0x00, 0x00,
/* 528 */ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 536 */ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x00,
/* 544 */ 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 552 */ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 560 */ 0x3F, 0xDF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 568 */ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 576 */ 0x00, 0x00, 0x01, 0xDF, 0xF0, 0x00, 0x00, 0x00,
/* 584 */ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 592 */ 0x00, 0x00, 0x00, 0x00, 0x0E, 0x00, 0x00, 0x00,
/* 600 */ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 608 */ 0x00, 0x00, 0x00, 0x00, 0x00
} ; 

const U8 ChCl [] = {
/*   0 */   1, 101,   1, 104,   1, 105,   1, 106,
/*   8 */   1, 108,   1, 111,   1, 115,   1, 116,
/*  16 */   1, 117,   1, 118,   1, 119,   4, 120,
/*  24 */ 116, 119, 141,   3, 127, 104, 122,   3,
/*  32 */ 127, 104, 123,   3, 127, 104, 124,   3,
/*  40 */ 127, 104, 126,   3, 127, 104, 130,   3,
/*  48 */ 127, 104, 131,   3, 127, 104, 134,   5,
/*  56 */ 127, 104, 136, 104, 124,   5, 127, 104,
/*  64 */ 136, 117, 138,   5, 127, 104, 136, 118,
/*  72 */ 109,   4, 127, 104, 137, 117,   4, 127,
/*  80 */ 104, 138, 104,   3, 127, 110, 138,   3,
/*  88 */ 127, 115, 122,   4, 127, 115, 126, 117,
/*  96 */   5, 127, 115, 130, 130, 119,   5, 127,
/* 104 */ 115, 130, 138, 104,   5, 127, 115, 130,
/* 112 */ 138, 105,   5, 127, 115, 131, 116, 121,
/* 120 */   4, 127, 115, 136, 131,   5, 127, 116,
/* 128 */ 119, 136, 116,   3, 127, 116, 122,   3,
/* 136 */ 127, 116, 123,   3, 127, 116, 130,   3,
/* 144 */ 127, 116, 134,   4, 127, 116, 136, 122,
/* 152 */   4, 127, 116, 136, 123,   4, 127, 116,
/* 160 */ 136, 131,   4, 127, 116, 136, 134,   4,
/* 168 */ 127, 116, 136, 138,   4, 127, 116, 141,
/* 176 */ 115,   3, 127, 117, 116,   5, 127, 117,
/* 184 */ 122, 116, 136,   4, 127, 117, 130, 115,
/* 192 */   3, 127, 117, 132,   6, 127, 117, 134,
/* 200 */ 134, 117, 135,   6, 127, 117, 134, 134,
/* 208 */ 117, 137,   5, 127, 117, 134, 134, 118,
/* 216 */   3, 127, 117, 136,   4, 127, 117, 137,
/* 224 */ 134,   4, 127, 117, 137, 138,   3, 127,
/* 232 */ 117, 138,   3, 127, 117, 139,   4, 127,
/* 240 */ 118, 130, 118,   4, 127, 118, 131, 104,
/* 248 */   4, 127, 118, 131, 117,   4, 127, 118,
/* 256 */ 131, 118,   4, 127, 118, 131, 131,   4,
/* 264 */ 127, 118, 132, 118,   5, 127, 118, 132,
/* 272 */ 132, 106,   5, 127, 118, 132, 132, 116,
/* 280 */   4, 127, 118, 136, 115,   4, 127, 118,
/* 288 */ 136, 117,   4, 127, 118, 136, 118,   4,
/* 296 */ 127, 118, 136, 130,   5, 127, 118, 136,
/* 304 */ 131, 118,   4, 127, 118, 136, 136,   4,
/* 312 */ 127, 118, 136, 138,   3, 127, 118, 137,
/* 320 */   3, 127, 119, 108,   4, 127, 119, 117,
/* 328 */ 130,   4, 127, 119, 117, 137,   5, 127,
/* 336 */ 119, 131, 104, 136,   5, 127, 119, 131,
/* 344 */ 115, 117,   5, 127, 119, 131, 115, 132,
/* 352 */   5, 127, 119, 131, 116, 119,   5, 127,
/* 360 */ 119, 131, 116, 123,   4, 127, 119, 131,
/* 368 */ 117,   4, 127, 119, 131, 118,   4, 127,
/* 376 */ 119, 131, 119,   4, 127, 119, 131, 122,
/* 384 */   5, 127, 119, 136, 130, 119,   3, 127,
/* 392 */ 120, 122,   3, 127, 120, 124,   3, 127,
/* 400 */ 120, 126,   3, 127, 120, 131,   3, 127,
/* 408 */ 120, 134,   0,   7, 104, 138, 115, 117,
/* 416 */ 116, 132, 138,   5, 104, 138, 115, 117,
/* 424 */ 138,   8, 115, 119, 136, 115, 117, 116,
/* 432 */ 132, 138,   6, 115, 119, 136, 115, 117,
/* 440 */ 138,   7, 115, 139, 115, 117, 116, 132,
/* 448 */ 138,   5, 115, 139, 115, 117, 138,   3,
/* 456 */ 116, 137, 138,   3, 118, 132, 138,   4,
/* 464 */ 123, 116, 132, 138,   4, 124, 118, 132,
/* 472 */ 138,   6, 124, 119, 136, 115, 132, 138,
/* 480 */   6, 125, 116, 136, 118, 132, 138,   4,
/* 488 */ 125, 118, 132, 138,   4, 125, 118, 136,
/* 496 */ 138,   5, 126, 136, 115, 132, 124,   4,
/* 504 */ 127, 119, 117, 138,   7, 134, 115, 136,
/* 512 */ 138, 118, 119, 138,   4, 134, 116, 119,
/* 520 */ 138,   7, 134, 116, 132, 124, 115, 132,
/* 528 */ 138,   5, 134, 116, 138, 117, 138,   5,
/* 536 */ 135, 119, 115, 132, 124,   5, 135, 119,
/* 544 */ 115, 132, 138,   5, 137, 115, 117, 132,
/* 552 */ 138,   6, 137, 116, 123, 118, 132, 124,
/* 560 */   8, 137, 116, 136, 115, 117, 116, 132,
/* 568 */ 138,   4, 137, 118, 117, 138,   4, 137,
/* 576 */ 118, 132, 138,   7, 137, 119, 117, 139,
/* 584 */ 115, 132, 138,  10, 138, 115, 132, 138,
/* 592 */ 137, 116, 136, 115, 117, 138,   4, 138,
/* 600 */ 118, 119, 138,   5, 139, 117, 132, 126,
/* 608 */ 138,   0,   5, 115, 119, 123, 119, 132,
/* 616 */   2, 116, 132,   2, 118, 132,   2, 119,
/* 624 */ 132,   4, 122, 117, 116, 132,   3, 131,
/* 632 */ 118, 132,   4, 136, 117, 116, 132,   3,
/* 640 */ 137, 118, 132,   3, 138, 118, 132,   0,
/* 648 */   5, 104, 138, 115, 117, 137,   6, 104,
/* 656 */ 138, 117, 118, 132, 137,   4, 106, 138,
/* 664 */ 116, 137,   6, 115, 119, 136, 115, 117,
/* 672 */ 137,   6, 115, 119, 136, 117, 116, 142,
/* 680 */   7, 115, 119, 136, 117, 118, 132, 137,
/* 688 */   3, 115, 119, 141,   5, 115, 134, 136,
/* 696 */ 105, 137,   5, 115, 139, 115, 117, 137,
/* 704 */   4, 115, 139, 116, 142,   5, 115, 139,
/* 712 */ 117, 116, 142,   6, 115, 139, 117, 118,
/* 720 */ 132, 137,   5, 115, 139, 118, 132, 137,
/* 728 */   5, 116, 130, 130, 116, 137,   2, 116,
/* 736 */ 137,   3, 117, 130, 137,   5, 122, 116,
/* 744 */ 115, 119, 141,   6, 122, 116, 130, 130,
/* 752 */ 116, 137,   6, 122, 118, 132, 132, 116,
/* 760 */ 137,   4, 122, 118, 132, 137,   3, 123,
/* 768 */ 116, 137,   6, 123, 127, 105, 136, 116,
/* 776 */ 137,   5, 123, 127, 116, 136, 137,   4,
/* 784 */ 123, 127, 116, 142,   3, 124, 105, 137,
/* 792 */   4, 124, 115, 132, 137,   4, 124, 116,
/* 800 */ 119, 141,   6, 124, 116, 134, 119, 117,
/* 808 */ 137,   3, 124, 116, 137,   3, 124, 117,
/* 816 */ 141,   4, 125, 115, 119, 141,   5, 125,
/* 824 */ 118, 136, 138, 137,   6, 126, 136, 115,
/* 832 */ 132, 124, 137,   5, 130, 116, 119, 136,
/* 840 */ 137,   3, 130, 116, 137,   4, 131, 115,
/* 848 */ 117, 137,   3, 131, 116, 137,   5, 131,
/* 856 */ 117, 116, 119, 141,   5, 131, 118, 117,
/* 864 */ 132, 137,   4, 132, 118, 119, 137,   3,
/* 872 */ 132, 118, 137,   3, 134, 115, 137,   6,
/* 880 */ 134, 116, 138, 117, 138, 137,   4, 134,
/* 888 */ 119, 117, 137,   4, 134, 130, 119, 137,
/* 896 */   7, 135, 119, 116, 130, 130, 116, 137,
/* 904 */   8, 135, 119, 116, 130, 135, 119, 116,
/* 912 */ 137,   5, 135, 119, 116, 130, 137,   4,
/* 920 */ 137, 115, 132, 137,   6, 137, 116, 136,
/* 928 */ 115, 117, 137,   3, 137, 116, 137,   3,
/* 936 */ 137, 117, 141,   4, 137, 118, 119, 137,
/* 944 */   6, 137, 118, 131, 131, 116, 137,   4,
/* 952 */ 137, 119, 117, 137,   4, 138, 116, 130,
/* 960 */ 137,   3, 138, 116, 137,   4, 138, 118,
/* 968 */ 119, 137,   4, 138, 136, 105, 137,   5,
/* 976 */ 138, 136, 118, 117, 137,   8, 139, 117,
/* 984 */ 116, 117, 130, 130, 116, 137,   5, 139,
/* 992 */ 117, 116, 119, 141,   6, 139, 117, 132,
/* 1000 */ 126, 138, 137,   4, 139, 118, 119, 137,
/* 1008 */   3, 139, 118, 137,   0,   5, 116, 130,
/* 1016 */ 130, 116, 137,   2, 116, 132,   3, 117,
/* 1024 */ 130, 137,   3, 130, 116, 137,   0,   7,
/* 1032 */ 115, 119, 128, 118, 119, 136, 124,   4,
/* 1040 */ 116, 132, 138, 136,   1, 121,   1, 123,
/* 1048 */   1, 124,   1, 128,   5, 128, 119, 137,
/* 1056 */ 135, 119,   1, 130,   6, 130, 118, 136,
/* 1064 */ 137, 135, 119,   1, 131,   1, 132,   6,
/* 1072 */ 134, 119, 117, 137, 135, 119,   6, 134,
/* 1080 */ 136, 116, 137, 135, 119,   4, 134, 136,
/* 1088 */ 119, 124,   2, 135, 119,   6, 135, 119,
/* 1096 */ 116, 130, 135, 119,   6, 135, 119, 118,
/* 1104 */ 117, 135, 119,   1, 137,   1, 138,   0,
/* 1112 */   1,  91,   1,  92,   2, 137,  91,   2,
/* 1120 */ 137,  92,   0,   5, 115, 123, 123, 136,
/* 1128 */ 118,   4, 115, 128, 118, 132,   6, 116,
/* 1136 */ 137, 138, 118, 131, 115,   3, 122, 115,
/* 1144 */ 132,   4, 122, 130, 115, 132,   3, 122,
/* 1152 */ 136, 118,   9, 123, 115, 118, 119, 138,
/* 1160 */ 123, 127, 118, 119,   4, 123, 130, 116,
/* 1168 */ 136,   3, 123, 136, 118,   4, 125, 130,
/* 1176 */ 115, 132,   4, 125, 136, 115, 132,   3,
/* 1184 */ 128, 118, 132,   3, 134, 118, 136,   6,
/* 1192 */ 136, 115, 123, 123, 136, 118,   4, 138,
/* 1200 */ 115, 122, 115,   4, 138, 136, 118, 132,
/* 1208 */   0,   4, 104, 134, 127, 118,   6, 115,
/* 1216 */ 119, 128, 118, 119, 136,   3, 115, 130,
/* 1224 */ 119,   4, 115, 130, 129, 120,   8, 115,
/* 1232 */ 134, 115, 136, 138, 127, 116, 117,   2,
/* 1240 */ 116, 132,   1, 117,   5, 118, 141, 125,
/* 1248 */ 118, 136,   5, 118, 142, 115, 130, 117,
/* 1256 */  10, 119, 132, 124, 116, 136, 126, 136,
/* 1264 */ 118, 119, 132,   3, 120, 115, 136,   2,
/* 1272 */ 120, 118,   9, 122, 115, 123, 129, 126,
/* 1280 */ 136, 118, 119, 132,   3, 122, 115, 132,
/* 1288 */   5, 122, 115, 136, 118, 119,   6, 122,
/* 1296 */ 115, 136, 131, 115, 117,   7, 122, 117,
/* 1304 */ 123, 129, 125, 118, 136,   4, 122, 130,
/* 1312 */ 115, 117,   3, 122, 130, 116,   3, 123,
/* 1320 */ 115, 109,   8, 123, 116, 130, 130, 119,
/* 1328 */ 130, 118, 109,   3, 123, 118, 130,   7,
/* 1336 */ 123, 118, 131, 134, 118, 119, 132,   3,
/* 1344 */ 123, 136, 117,   4, 124, 115, 139, 117,
/* 1352 */   4, 125, 115, 136, 117,   3, 125, 116,
/* 1360 */ 130,   4, 125, 117, 118, 136,   3, 125,
/* 1368 */ 118, 118,   5, 125, 118, 136, 131, 117,
/* 1376 */   4, 125, 128, 116, 130,   4, 125, 128,
/* 1384 */ 118, 136,   3, 126, 118, 118,   3, 126,
/* 1392 */ 118, 130,   4, 126, 119, 115, 136,   5,
/* 1400 */ 126, 136, 118, 119, 132,   3, 127, 115,
/* 1408 */ 132,   3, 127, 115, 136,   3, 127, 116,
/* 1416 */ 136,   4, 127, 118, 119, 132,   3, 127,
/* 1424 */ 118, 130,   3, 129, 115, 109,   2, 129,
/* 1432 */ 117,   5, 129, 118, 122, 118, 130,   4,
/* 1440 */ 130, 115, 117, 136,   3, 130, 115, 132,
/* 1448 */   3, 130, 118, 136,   3, 131, 115, 117,
/* 1456 */   5, 131, 115, 124, 136, 117,   7, 131,
/* 1464 */ 115, 132, 117, 125, 118, 130,   7, 131,
/* 1472 */ 115, 136, 120, 130, 115, 132,   6, 131,
/* 1480 */ 118, 119, 130, 118, 119,   4, 131, 118,
/* 1488 */ 119, 132,   7, 134, 104, 126, 115, 131,
/* 1496 */ 118, 109,   4, 134, 115, 130, 119,   7,
/* 1504 */ 134, 117, 130, 123, 127, 115, 136,   4,
/* 1512 */ 134, 118, 119, 132,   7, 134, 118, 130,
/* 1520 */ 115, 136, 118, 109,   7, 134, 118, 136,
/* 1528 */ 138, 130, 115, 132,   4, 134, 130, 115,
/* 1536 */ 117,   3, 134, 136, 119,   3, 136, 115,
/* 1544 */ 117,   5, 136, 115, 123, 127, 117,   3,
/* 1552 */ 136, 115, 132,   4, 136, 118, 119, 132,
/* 1560 */   9, 136, 119, 138, 127, 116, 136, 125,
/* 1568 */ 118, 136,   6, 136, 127, 118, 124, 118,
/* 1576 */ 109,   3, 137, 115, 109,   4, 137, 115,
/* 1584 */ 136, 118,   2, 137, 119,   4, 137, 123,
/* 1592 */ 115, 130,   7, 137, 127, 116, 138, 130,
/* 1600 */ 115, 132,   4, 137, 138, 115, 132,   6,
/* 1608 */ 137, 138, 116, 140, 115, 136,   3, 137,
/* 1616 */ 138, 119,   6, 138, 115, 122, 130, 118,
/* 1624 */ 109,   5, 138, 115, 130, 131, 119,   3,
/* 1632 */ 139, 116, 130,   7, 140, 127, 117, 134,
/* 1640 */ 123, 118, 136,   2, 142, 105,   3, 142,
/* 1648 */ 116, 132,   0,   2,  92, 139,   4, 101,
/* 1656 */ 138, 117, 131,   3, 104, 115, 131,   2,
/* 1664 */ 104, 123,   2, 104, 131,   3, 104, 135,
/* 1672 */ 119,   2, 104, 136,   2, 113, 131,   3,
/* 1680 */ 115, 131, 131,   2, 116, 131,   3, 116,
/* 1688 */ 131, 131,   5, 116, 132, 138, 117, 131,
/* 1696 */   2, 117, 123,   4, 117, 126, 115, 131,
/* 1704 */   4, 117, 130, 115, 131,   4, 118, 130,
/* 1712 */ 117, 131,   4, 118, 130, 119, 131,   4,
/* 1720 */ 122, 116, 137, 123,   3, 123, 115, 131,
/* 1728 */   4, 123, 116, 137, 123,   6, 123, 118,
/* 1736 */ 131, 134, 104, 138,   4, 123, 119, 136,
/* 1744 */ 136,   4, 124, 116, 137, 123,   3, 124,
/* 1752 */ 117, 131,   3, 124, 119, 131,   4, 126,
/* 1760 */ 116, 137, 123,   3, 126, 119, 131,   2,
/* 1768 */ 126, 131,   4, 127, 117, 137, 123,   3,
/* 1776 */ 128, 115, 123,   4, 130, 116, 137, 123,
/* 1784 */   3, 131, 115, 131,   4, 131, 116, 137,
/* 1792 */ 123,   4, 132, 116, 137, 123,   3, 132,
/* 1800 */ 118, 123,   4, 134, 117, 137, 123,   5,
/* 1808 */ 135, 119, 116, 137, 123,   3, 136, 115,
/* 1816 */ 131,   4, 136, 116, 137, 123,   4, 136,
/* 1824 */ 138, 117, 131,   4, 137, 138, 115, 131,
/* 1832 */   4, 138, 116, 137, 123,   4, 139, 116,
/* 1840 */ 137, 123,   4, 139, 117, 137, 123,   0,
/* 1848 */   5, 104, 130, 118, 135, 119,   5, 104,
/* 1856 */ 131, 116, 136, 126,   4, 104, 131, 117,
/* 1864 */ 132,   8, 104, 135, 119, 117, 134, 118,
/* 1872 */ 130, 130,   7, 104, 135, 119, 117, 134,
/* 1880 */ 118, 138,   7, 104, 135, 119, 117, 139,
/* 1888 */ 115, 130,   2, 104, 139,   4, 104, 139,
/* 1896 */ 117, 124,   3, 115, 119, 139,   5, 115,
/* 1904 */ 122, 136, 117, 139,   3, 115, 122, 137,
/* 1912 */   7, 115, 122, 137, 138, 116, 136, 126,
/* 1920 */   6, 115, 122, 137, 138, 117, 132,   3,
/* 1928 */ 115, 123, 123,   5, 115, 123, 123, 117,
/* 1936 */ 124,   2, 115, 124,   5, 115, 125, 125,
/* 1944 */ 130, 119,   2, 115, 126,   4, 115, 130,
/* 1952 */ 117, 131,   7, 115, 131, 122, 117, 139,
/* 1960 */ 115, 130,   7, 115, 132, 138, 104, 123,
/* 1968 */ 104, 124,   5, 115, 134, 134, 115, 136,
/* 1976 */   3, 115, 136, 124,   3, 115, 136, 126,
/* 1984 */   3, 115, 136, 134,   7, 115, 137, 138,
/* 1992 */ 136, 117, 132, 126,   2, 115, 139,   5,
/* 2000 */ 116, 125, 125, 130, 119,   8, 116, 132,
/* 2008 */ 126, 118, 119, 130, 116, 139,   6, 116,
/* 2016 */ 132, 138, 136, 116, 126,   5, 116, 141,
/* 2024 */ 123, 104, 124,   6, 116, 141, 123, 116,
/* 2032 */ 130, 130,   5, 117, 131, 131, 115, 132,
/* 2040 */   5, 117, 131, 131, 117, 132,   7, 117,
/* 2048 */ 131, 134, 104, 132, 117, 138,   8, 117,
/* 2056 */ 131, 134, 116, 136, 138, 117, 132,   5,
/* 2064 */ 117, 131, 134, 118, 138,   5, 117, 131,
/* 2072 */ 134, 119, 124,   6, 117, 131, 134, 136,
/* 2080 */ 119, 124,  10, 117, 132, 117, 132, 138,
/* 2088 */ 116, 130, 130, 117, 126,   5, 117, 132,
/* 2096 */ 123, 117, 124,   8, 117, 132, 123, 118,
/* 2104 */ 131, 134, 104, 138,   8, 117, 132, 123,
/* 2112 */ 118, 132, 138, 117, 132,   9, 117, 132,
/* 2120 */ 124, 104, 125, 117, 132, 117, 131,   5,
/* 2128 */ 117, 132, 124, 117, 126,   5, 117, 132,
/* 2136 */ 124, 118, 130,   6, 117, 132, 124, 119,
/* 2144 */ 130, 126,   7, 117, 132, 125, 117, 132,
/* 2152 */ 117, 131,   5, 117, 132, 125, 130, 119,
/* 2160 */   7, 117, 132, 126, 104, 132, 119, 131,
/* 2168 */   5, 117, 132, 137, 118, 130,   7, 117,
/* 2176 */ 132, 137, 138, 136, 119, 131,   8, 117,
/* 2184 */ 132, 138, 116, 130, 130, 117, 126,   9,
/* 2192 */ 117, 132, 138, 116, 136, 131, 117, 138,
/* 2200 */ 138,   5, 118, 123, 123, 117, 124,   7,
/* 2208 */ 118, 131, 132, 117, 134, 118, 138,   8,
/* 2216 */ 118, 131, 132, 117, 134, 136, 104, 137,
/* 2224 */   4, 118, 132, 126, 119,   4, 118, 134,
/* 2232 */ 119, 130,   5, 118, 136, 134, 117, 131,
/* 2240 */   4, 119, 132, 117, 131,   6, 119, 132,
/* 2248 */ 117, 139, 115, 130,   3, 119, 136, 126,
/* 2256 */   3, 122, 117, 124,   9, 122, 117, 136,
/* 2264 */ 104, 125, 136, 117, 132, 126,   5, 122,
/* 2272 */ 117, 139, 115, 130,   5, 122, 118, 132,
/* 2280 */ 117, 131,   8, 122, 130, 115, 132, 123,
/* 2288 */ 127, 117, 131,   5, 122, 136, 115, 117,
/* 2296 */ 131,   1, 123,   3, 123, 117, 131,   7,
/* 2304 */ 123, 118, 109, 132, 123, 117, 124,   4,
/* 2312 */ 123, 118, 119, 139,   4, 123, 118, 131,
/* 2320 */ 131,   6, 123, 118, 131, 134, 104, 138,
/* 2328 */   7, 123, 118, 131, 134, 130, 117, 131,
/* 2336 */   6, 123, 118, 132, 125, 117, 124,   6,
/* 2344 */ 123, 118, 132, 125, 130, 119,   6, 123,
/* 2352 */ 118, 132, 126, 136, 119,   6, 123, 118,
/* 2360 */ 132, 132, 117, 139,   4, 123, 118, 132,
/* 2368 */ 137,   4, 123, 118, 132, 138,   6, 123,
/* 2376 */ 118, 132, 138, 117, 132,   7, 123, 118,
/* 2384 */ 132, 138, 117, 132, 126,   7, 123, 118,
/* 2392 */ 132, 138, 136, 116, 139,   4, 123, 118,
/* 2400 */ 132, 139,   7, 123, 118, 132, 139, 116,
/* 2408 */ 136, 126,   8, 123, 118, 134, 136, 104,
/* 2416 */ 137, 117, 124,   6, 123, 118, 136, 134,
/* 2424 */ 119, 130,   6, 123, 127, 117, 116, 132,
/* 2432 */ 124,   4, 123, 130, 104, 131,   1, 124,
/* 2440 */   5, 124, 104, 123, 115, 124,   6, 124,
/* 2448 */ 104, 125, 125, 130, 119,   5, 124, 104,
/* 2456 */ 125, 130, 119,   5, 124, 104, 134, 118,
/* 2464 */ 132,   6, 124, 104, 138, 116, 136, 126,
/* 2472 */   6, 124, 104, 138, 136, 117, 131,   6,
/* 2480 */ 124, 117, 125, 125, 130, 119,   5, 124,
/* 2488 */ 117, 130, 117, 126,   6, 124, 117, 137,
/* 2496 */ 137, 117, 124,   6, 124, 117, 139, 116,
/* 2504 */ 136, 126,   5, 124, 118, 123, 119, 131,
/* 2512 */   3, 124, 118, 130,   5, 125, 104, 123,
/* 2520 */ 119, 130,   4, 125, 116, 136, 131,   4,
/* 2528 */ 125, 116, 136, 139,   8, 125, 117, 122,
/* 2536 */ 136, 118, 123, 117, 131,   7, 125, 118,
/* 2544 */ 119, 136, 132, 117, 131,   6, 125, 130,
/* 2552 */ 115, 138, 119, 130,   4, 125, 130, 118,
/* 2560 */ 136,   4, 125, 136, 118, 131,   1, 126,
/* 2568 */   4, 126, 115, 108, 131,  10, 126, 136,
/* 2576 */ 115, 132, 124, 117, 130, 118, 135, 119,
/* 2584 */   3, 128, 119, 131,   1, 130,   4, 130,
/* 2592 */ 115, 119, 136,   3, 130, 115, 138,   5,
/* 2600 */ 130, 117, 132, 117, 131,   1, 131,   6,
/* 2608 */ 131, 104, 123, 118, 132, 138,   3, 131,
/* 2616 */ 118, 131,   7, 131, 118, 132, 118, 139,
/* 2624 */ 115, 130,   5, 131, 118, 132, 119, 131,
/* 2632 */   6, 132, 104, 126, 130, 117, 126,   6,
/* 2640 */ 132, 119, 138, 136, 117, 131,   5, 134,
/* 2648 */ 104, 132, 117, 138,   3, 134, 115, 136,
/* 2656 */   5, 134, 115, 136, 115, 139,   3, 134,
/* 2664 */ 115, 138,   6, 134, 116, 136, 131, 115,
/* 2672 */ 132,   6, 134, 116, 136, 138, 117, 132,
/* 2680 */   6, 134, 116, 137, 138, 117, 130,   3,
/* 2688 */ 134, 117, 131,   7, 134, 118, 130, 120,
/* 2696 */ 139, 115, 130,   8, 134, 119, 130, 139,
/* 2704 */ 104, 136, 119, 130,   5, 134, 119, 136,
/* 2712 */ 119, 130,   8, 134, 130, 119, 136, 117,
/* 2720 */ 139, 115, 130,   7, 134, 136, 104, 104,
/* 2728 */ 131, 117, 132,   6, 134, 136, 104, 123,
/* 2736 */ 104, 124,   4, 134, 136, 104, 137,   6,
/* 2744 */ 134, 136, 104, 137, 117, 124,   4, 134,
/* 2752 */ 136, 117, 126,   7, 134, 136, 118, 104,
/* 2760 */ 131, 117, 132,   4, 134, 136, 119, 124,
/* 2768 */   6, 135, 119, 115, 137, 117, 131,   7,
/* 2776 */ 136, 104, 125, 136, 117, 132, 126,   3,
/* 2784 */ 136, 104, 126,   5, 136, 104, 126, 117,
/* 2792 */ 131,   5, 136, 104, 131, 115, 132,   6,
/* 2800 */ 136, 104, 131, 117, 138, 138,   5, 136,
/* 2808 */ 104, 132, 117, 138,   5, 136, 104, 137,
/* 2816 */ 117, 124,   6, 136, 104, 137, 117, 130,
/* 2824 */ 117,   6, 136, 104, 137, 119, 136, 126,
/* 2832 */   5, 136, 104, 138, 117, 123,   3, 136,
/* 2840 */ 116, 130,   3, 136, 116, 134,   4, 136,
/* 2848 */ 116, 137, 137,   8, 136, 116, 137, 138,
/* 2856 */ 136, 117, 132, 126,   1, 137,   9, 137,
/* 2864 */ 115, 132, 126, 119, 117, 132, 118, 130,
/* 2872 */   4, 137, 115, 136, 131,   4, 137, 116,
/* 2880 */ 136, 126,   4, 137, 116, 136, 131,   4,
/* 2888 */ 137, 116, 136, 134,   4, 137, 118, 119,
/* 2896 */ 139,   6, 137, 119, 123, 123, 119, 130,
/* 2904 */   8, 137, 119, 134, 116, 136, 123, 117,
/* 2912 */ 131,   7, 137, 119, 136, 104, 131, 117,
/* 2920 */ 132,   4, 137, 119, 136, 124,   5, 137,
/* 2928 */ 138, 136, 117, 124,   3, 138, 115, 130,
/* 2936 */   4, 138, 115, 132, 126,   5, 138, 118,
/* 2944 */ 119, 136, 131,   4, 138, 118, 136, 136,
/* 2952 */   6, 138, 119, 136, 122, 119, 130,   8,
/* 2960 */ 138, 136, 115, 132, 137, 134, 115, 136,
/* 2968 */   4, 138, 136, 117, 124,   6, 138, 136,
/* 2976 */ 117, 139, 115, 130,   6, 138, 136, 119,
/* 2984 */ 123, 119, 130,   1, 139,   9, 139, 116,
/* 2992 */ 132, 138, 136, 117, 134, 118, 138,   4,
/* 3000 */ 139, 117, 118, 130,  11, 139, 117, 123,
/* 3008 */ 116,  92, 134, 136, 104, 137, 117, 124,
/* 3016 */   5, 139, 117, 124, 115, 131,   4, 139,
/* 3024 */ 117, 132, 123,   5, 139, 117, 136, 119,
/* 3032 */ 130,   5, 139, 136, 115, 117, 131,   0,
/* 3040 */   4, 104, 130, 115, 138,   3, 104, 138,
/* 3048 */ 127,   3, 115, 119, 122,   4, 115, 119,
/* 3056 */ 137, 138,   2, 115, 122,   9, 115, 123,
/* 3064 */ 104, 138, 118, 122, 115, 123, 138,  11,
/* 3072 */ 115, 123, 127, 136, 118, 131, 118, 122,
/* 3080 */ 115, 123, 138,   7, 115, 125, 136, 117,
/* 3088 */ 129, 115, 132,   8, 115, 125, 136, 117,
/* 3096 */ 129, 115, 132, 124,   3, 115, 130, 138,
/* 3104 */   2, 115, 131,   9, 115, 131, 120, 130,
/* 3112 */ 118, 122, 115, 123, 138,   3, 115, 137,
/* 3120 */ 138,   7, 115, 142, 118, 122, 115, 123,
/* 3128 */ 138,   9, 115, 142, 118, 138, 118, 122,
/* 3136 */ 115, 123, 138,   3, 116, 117, 124,   3,
/* 3144 */ 116, 132, 125,   6, 116, 132, 138, 136,
/* 3152 */ 116, 125,   6, 116, 132, 138, 136, 116,
/* 3160 */ 131,   3, 116, 132, 139,   3, 116, 137,
/* 3168 */ 129,   3, 116, 137, 138,   3, 117, 131,
/* 3176 */ 134,   3, 117, 132, 138,   6, 118, 119,
/* 3184 */ 138, 136, 116, 131,   6, 118, 119, 138,
/* 3192 */ 137, 117, 124,   3, 118, 122, 139,   2,
/* 3200 */ 118, 139,   2, 118, 141,   4, 119, 130,
/* 3208 */ 137, 138,   4, 119, 132, 117, 139,   6,
/* 3216 */ 122, 116, 137, 137, 116, 131,   5, 122,
/* 3224 */ 117, 136, 123, 127,   4, 122, 117, 138,
/* 3232 */ 138,   2, 122, 118,   3, 122, 118, 141,
/* 3240 */   7, 122, 119, 130, 130, 124, 118, 142,
/* 3248 */   4, 122, 119, 132, 129,   4, 122, 130,
/* 3256 */ 115, 142,   5, 122, 130, 117, 137, 138,
/* 3264 */   4, 123, 115, 132, 123,   4, 123, 115,
/* 3272 */ 136, 138,   5, 123, 115, 137, 123, 127,
/* 3280 */   4, 123, 115, 137, 127,   6, 123, 115,
/* 3288 */ 138, 127, 104, 138,   5, 123, 115, 140,
/* 3296 */ 123, 127,   3, 123, 117, 123,   4, 123,
/* 3304 */ 118, 123, 129,   4, 123, 118, 132, 125,
/* 3312 */   7, 123, 118, 132, 138, 115, 117, 132,
/* 3320 */   4, 123, 118, 132, 139,   4, 123, 118,
/* 3328 */ 136, 132,   9, 123, 118, 138, 118, 132,
/* 3336 */ 104, 115, 137, 138,   5, 123, 119, 117,
/* 3344 */ 130, 130,   4, 123, 119, 138, 138,   2,
/* 3352 */ 123, 127,   8, 123, 127, 115, 130, 130,
/* 3360 */ 116, 132, 126,   5, 123, 127, 115, 136,
/* 3368 */ 138,   5, 123, 127, 116, 137, 138,   7,
/* 3376 */ 123, 136, 104, 131, 115, 137, 138,   5,
/* 3384 */ 123, 136, 115, 123, 129,   3, 124, 104,
/* 3392 */ 139,   5, 124, 115, 134, 117, 125,   4,
/* 3400 */ 124, 116, 137, 137,   3, 124, 116, 139,
/* 3408 */   8, 124, 117, 137, 134, 115, 138, 123,
/* 3416 */ 127,   3, 124, 117, 139,   4, 124, 118,
/* 3424 */ 123, 129,   4, 124, 118, 126, 126,   6,
/* 3432 */ 124, 119, 130, 123, 117, 131,   6, 124,
/* 3440 */ 136, 115, 126, 137, 138,   4, 124, 136,
/* 3448 */ 117, 139,   1, 125,   4, 125, 115, 119,
/* 3456 */ 122,   5, 125, 116, 136, 118, 119,   2,
/* 3464 */ 125, 117,   6, 125, 130, 116, 138, 138,
/* 3472 */ 132,   4, 125, 136, 115, 138,   1, 126,
/* 3480 */   5, 126, 104, 115, 137, 138,   7, 126,
/* 3488 */ 115, 119, 130, 116, 117, 138,   6, 126,
/* 3496 */ 115, 132, 126, 137, 138,   4, 126, 115,
/* 3504 */ 137, 138,   4, 126, 116, 120, 137,   4,
/* 3512 */ 126, 116, 138, 138,   3, 127, 104, 124,
/* 3520 */   5, 127, 115, 131, 137, 138,   2, 127,
/* 3528 */ 117,   4, 127, 117, 137, 138,   3, 127,
/* 3536 */ 117, 139,   4, 127, 118, 130, 129,   5,
/* 3544 */ 127, 118, 130, 137, 138,   4, 128, 117,
/* 3552 */ 126, 126,   3, 128, 118, 129,   5, 128,
/* 3560 */ 119, 134, 117, 138,   4, 129, 115, 117,
/* 3568 */ 137,   5, 129, 115, 137, 123, 127,   4,
/* 3576 */ 129, 116, 119, 134,   4, 129, 117, 125,
/* 3584 */ 125,   4, 129, 117, 134, 134,   4, 129,
/* 3592 */ 118, 123, 127,   3, 129, 127, 131,   6,
/* 3600 */ 129, 136, 116, 119, 138, 142,   3, 130,
/* 3608 */ 115, 137,  10, 130, 116, 134, 118, 124,
/* 3616 */ 118, 126, 115, 137, 138,   3, 130, 117,
/* 3624 */ 122,   4, 130, 117, 132, 138,   1, 131,
/* 3632 */   6, 131, 101, 123, 127, 116, 125,   4,
/* 3640 */ 131, 115, 119, 137,   6, 131, 115, 123,
/* 3648 */ 127, 116, 125,   6, 131, 115, 126, 117,
/* 3656 */ 137, 138,   5, 131, 115, 132, 115, 126,
/* 3664 */   3, 131, 115, 137,   6, 131, 115, 137,
/* 3672 */ 137, 104, 138,   3, 131, 115, 138,   4,
/* 3680 */ 131, 116, 136, 136,   4, 131, 116, 137,
/* 3688 */ 137,   5, 131, 119, 132, 137, 138,   3,
/* 3696 */ 132, 116, 134,   3, 132, 116, 139,   9,
/* 3704 */ 132, 117, 138, 136, 118, 122, 115, 123,
/* 3712 */ 138,   4, 132, 118, 137, 138,   6, 134,
/* 3720 */ 104, 124, 115, 130, 125,   4, 134, 115,
/* 3728 */ 130, 131,   4, 134, 115, 132, 142,   5,
/* 3736 */ 134, 115, 134, 115, 139,   5, 134, 115,
/* 3744 */ 136, 138, 132,   3, 134, 115, 138,   4,
/* 3752 */ 134, 116, 136, 139,   6, 134, 117, 132,
/* 3760 */ 137, 123, 127,   3, 134, 118, 129,   7,
/* 3768 */ 134, 118, 130, 120, 116, 137, 138,   4,
/* 3776 */ 134, 118, 130, 124,   9, 134, 130, 115,
/* 3784 */ 132, 137, 117, 123, 127, 138,   5, 134,
/* 3792 */ 136, 118, 137, 134,   4, 135, 119, 115,
/* 3800 */ 138,   4, 136, 115, 117, 124,  11, 136,
/* 3808 */ 115, 124, 117, 118, 136, 116, 134, 118,
/* 3816 */ 136, 138,   6, 136, 116, 134, 118, 136,
/* 3824 */ 138,   4, 136, 116, 137, 137,   3, 136,
/* 3832 */ 116, 139,   6, 136, 116, 139, 118, 130,
/* 3840 */ 139,   6, 136, 118, 115, 124, 137, 138,
/* 3848 */   4, 137, 116, 138, 138,   6, 137, 117,
/* 3856 */ 130, 139, 115, 132,   3, 137, 119, 122,
/* 3864 */   3, 137, 119, 134,   7, 137, 119, 134,
/* 3872 */ 134, 118, 136, 138,   6, 137, 120, 130,
/* 3880 */ 139, 115, 132,   5, 137, 123, 115, 132,
/* 3888 */ 132,   5, 137, 123, 115, 138, 138,   5,
/* 3896 */ 137, 123, 118, 118, 138,   7, 137, 123,
/* 3904 */ 127, 132, 116, 117, 124,   5, 137, 123,
/* 3912 */ 136, 115, 134,   5, 137, 134, 115, 130,
/* 3920 */ 138,   5, 137, 134, 116, 132, 123,   4,
/* 3928 */ 137, 134, 117, 124,   7, 137, 134, 117,
/* 3936 */ 132, 132, 115, 129,   6, 137, 134, 117,
/* 3944 */ 136, 117, 125,   7, 137, 134, 127, 117,
/* 3952 */ 132, 123, 138,   6, 137, 134, 136, 117,
/* 3960 */ 132, 126,   7, 137, 134, 136, 117, 132,
/* 3968 */ 129, 130,   6, 137, 135, 119, 115, 138,
/* 3976 */ 138,   4, 137, 138, 115, 120,   8, 137,
/* 3984 */ 138, 115, 124, 127, 118, 119, 124,   5,
/* 3992 */ 137, 138, 115, 136, 138,   8, 137, 138,
/* 4000 */ 115, 138, 127, 118, 119, 124,   9, 137,
/* 4008 */ 138, 115, 138, 138, 127, 115, 130, 138,
/* 4016 */  10, 138, 104, 130, 104, 136, 116, 134,
/* 4024 */ 118, 136, 138,   4, 138, 115, 132, 129,
/* 4032 */   4, 138, 116, 132, 124,   2, 138, 117,
/* 4040 */   3, 138, 119, 132,   4, 138, 127, 115,
/* 4048 */ 130,   3, 138, 127, 117,   6, 138, 127,
/* 4056 */ 136, 117, 130, 130,   6, 138, 136, 115,
/* 4064 */ 131, 117, 132,   4, 138, 136, 115, 139,
/* 4072 */   5, 138, 136, 117, 126, 126,   5, 138,
/* 4080 */ 136, 117, 131, 131,   8, 138, 136, 118,
/* 4088 */ 123, 127, 115, 132, 138,   7, 138, 136,
/* 4096 */ 118, 123, 127, 117, 138,   5, 139, 104,
/* 4104 */ 138, 117, 139,   5, 139, 104, 138, 120,
/* 4112 */ 139,   5, 139, 118, 119, 123, 127,   5,
/* 4120 */ 139, 118, 123, 117, 125,   3, 139, 118,
/* 4128 */ 131,   4, 140, 115, 126, 132,   6, 140,
/* 4136 */ 115, 130, 129, 118, 139,   4, 140, 115,
/* 4144 */ 130, 138,   3, 140, 115, 138,   3, 140,
/* 4152 */ 116, 122,   4, 140, 116, 130, 138,   8,
/* 4160 */ 140, 117, 132, 123, 127, 116, 137, 138,
/* 4168 */   5, 141, 120, 130, 118, 125,   0,   3,
/* 4176 */ 115, 119, 126,   3, 115, 119, 131,   2,
/* 4184 */ 115, 120,   2, 115, 126,   3, 115, 132,
/* 4192 */ 126,   3, 116, 132, 126,   3, 116, 136,
/* 4200 */ 126,   1, 117,   2, 117, 126,   3, 117,
/* 4208 */ 130, 130,   2, 118, 119,   3, 118, 119,
/* 4216 */ 126,   2, 118, 120,   2, 118, 126,   3,
/* 4224 */ 118, 132, 126,   2, 119, 120,   2, 123,
/* 4232 */ 127,   2, 126, 132,   0,   3, 115, 125,
/* 4240 */ 138,   8, 115, 132, 126, 130, 116, 124,
/* 4248 */ 118, 142,   9, 117, 132, 138, 116, 136,
/* 4256 */ 139, 117, 116, 140,   6, 118, 119, 138,
/* 4264 */ 137, 117, 124,   7, 122, 118, 118, 129,
/* 4272 */ 131, 115, 129,   5, 122, 118, 118, 137,
/* 4280 */ 138,   8, 122, 118, 118, 138, 130, 116,
/* 4288 */ 126, 126,   5, 122, 118, 119, 130, 124,
/* 4296 */   4, 122, 119, 131, 134,   4, 122, 119,
/* 4304 */ 138, 130,   4, 122, 119, 142, 142,   5,
/* 4312 */ 122, 130, 118, 118, 131,   5, 122, 136,
/* 4320 */ 116, 116, 124,   4, 122, 136, 118, 129,
/* 4328 */   4, 123, 115, 132, 138,   8, 123, 115,
/* 4336 */ 132, 138, 117, 130, 116, 139,   4, 123,
/* 4344 */ 116, 132, 138,   6, 123, 118, 131, 134,
/* 4352 */ 119, 138,   5, 123, 118, 136, 118, 132,
/* 4360 */  10, 123, 127, 116, 116, 137, 116, 122,
/* 4368 */ 119, 136, 126,   5, 123, 130, 117, 134,
/* 4376 */ 134,   5, 123, 136, 115, 123, 129,   5,
/* 4384 */ 123, 136, 118, 118, 132,   5, 123, 136,
/* 4392 */ 119, 117, 137,   4, 124, 116, 115, 130,
/* 4400 */   5, 124, 116, 122, 115, 138,   6, 124,
/* 4408 */ 116, 137, 117, 126, 132,   7, 124, 116,
/* 4416 */ 137, 138, 136, 118, 120,   8, 124, 117,
/* 4424 */ 137, 123, 118, 119, 132, 138,   5, 124,
/* 4432 */ 136, 117, 125, 138,   5, 124, 136, 119,
/* 4440 */ 131, 131,   4, 125, 114, 127, 136,   4,
/* 4448 */ 125, 116, 116, 124,   8, 125, 118, 118,
/* 4456 */ 138, 122, 115, 130, 130,   5, 125, 130,
/* 4464 */ 117, 134, 134,   5, 125, 136, 116, 116,
/* 4472 */ 142,   4, 126, 118, 134, 127,   4, 126,
/* 4480 */ 136, 115, 124,   7, 127, 115, 131, 122,
/* 4488 */ 119, 136, 126,   4, 128, 117, 126, 126,
/* 4496 */   4, 129, 117, 134, 134,   5, 129, 132,
/* 4504 */ 117, 123, 129,   4, 130, 116, 115, 124,
/* 4512 */   3, 131, 115, 129,   4, 131, 117, 137,
/* 4520 */ 138,   3, 131, 117, 141,   7, 134, 115,
/* 4528 */ 123, 116, 131, 115, 129,   4, 134, 117,
/* 4536 */ 123, 129,   4, 136, 116, 115, 124,   4,
/* 4544 */ 136, 117, 134, 134,   4, 136, 118, 123,
/* 4552 */ 129,   3, 136, 118, 139,   4, 137, 116,
/* 4560 */ 130, 130,   4, 137, 117, 138, 138,   9,
/* 4568 */ 137, 119, 134, 116, 136, 138, 115, 132,
/* 4576 */ 129,   9, 137, 119, 134, 116, 136, 140,
/* 4584 */ 116, 130, 138,   5, 137, 123, 118, 118,
/* 4592 */ 138,   6, 137, 123, 127, 118, 118, 132,
/* 4600 */   5, 137, 129, 117, 134, 134,   5, 137,
/* 4608 */ 132, 116, 115, 129,   4, 137, 132, 117,
/* 4616 */ 134,   5, 137, 134, 116, 115, 129,   6,
/* 4624 */ 137, 135, 119, 115, 138, 138,   5, 137,
/* 4632 */ 138, 116, 115, 131,   6, 137, 138, 136,
/* 4640 */ 117, 134, 134,   5, 137, 140, 116, 115,
/* 4648 */ 138,   6, 138, 119, 136, 132, 118, 139,
/* 4656 */   5, 138, 136, 117, 131, 131,   5, 138,
/* 4664 */ 136, 118, 138, 138,   6, 140, 115, 130,
/* 4672 */ 129, 118, 139,   4, 140, 118, 118, 125,
/* 4680 */   0,   4, 115, 126, 136, 104,   7, 115,
/* 4688 */ 132, 138, 117, 126, 115, 132,   5, 115,
/* 4696 */ 138, 115, 122, 116,   2, 116, 136,   5,
/* 4704 */ 116, 136, 130, 115, 132,   6, 117, 123,
/* 4712 */ 116, 122, 116, 136,   4, 117, 130, 115,
/* 4720 */ 132,   8, 117, 132, 137, 116, 130, 122,
/* 4728 */ 116, 136,   5, 118, 125, 125, 130, 115,
/* 4736 */   4, 118, 125, 130, 115,   3, 120, 115,
/* 4744 */ 132,   3, 122, 115, 132,   2, 122, 117,
/* 4752 */   2, 122, 118,   8, 122, 118, 118, 131,
/* 4760 */ 116, 136, 115, 132,   8, 122, 118, 119,
/* 4768 */ 131, 116, 136, 115, 132,   2, 124, 117,
/* 4776 */   2, 124, 118,   5, 124, 119, 126, 118,
/* 4784 */ 132,   3, 124, 136, 115,   6, 125, 117,
/* 4792 */ 130, 117, 122, 116,   3, 125, 130, 115,
/* 4800 */   2, 126, 115,   3, 126, 115, 132,   2,
/* 4808 */ 126, 117,   6, 126, 117, 132, 137, 116,
/* 4816 */ 132,   5, 126, 118, 119, 130, 115,   3,
/* 4824 */ 126, 118, 132,   9, 126, 118, 137, 134,
/* 4832 */ 116, 130, 137, 118, 132,   3, 126, 136,
/* 4840 */ 118,   5, 128, 115, 132, 126, 115,   3,
/* 4848 */ 128, 118, 132,   4, 129, 115, 122, 117,
/* 4856 */   5, 129, 127, 130, 118, 132,   6, 130,
/* 4864 */ 115, 132, 124, 138, 115,   2, 130, 116,
/* 4872 */   6, 130, 117, 132, 137, 115, 132,   2,
/* 4880 */ 131, 117,   6, 131, 119, 137, 138, 115,
/* 4888 */ 132,   3, 134, 117, 132,   3, 134, 118,
/* 4896 */ 132,   6, 134, 125, 116, 132, 132, 117,
/* 4904 */   7, 134, 127, 117, 130, 117, 122, 116,
/* 4912 */   2, 136, 115,   2, 136, 116,   5, 136,
/* 4920 */ 118, 138, 115, 132,   6, 137, 115, 132,
/* 4928 */ 138, 117, 115,   5, 137, 115, 136, 118,
/* 4936 */ 132,   7, 137, 118, 119, 123, 127, 118,
/* 4944 */ 132,   3, 137, 118, 132,   4, 137, 130,
/* 4952 */ 115, 132,   3, 137, 131, 118,   5, 137,
/* 4960 */ 138, 115, 130, 115,   5, 137, 138, 115,
/* 4968 */ 140, 119,   6, 138, 115, 126, 115, 130,
/* 4976 */ 118,   5, 138, 115, 130, 140, 116,   6,
/* 4984 */ 138, 118, 119, 115, 136, 116,   6, 138,
/* 4992 */ 127, 115, 130, 140, 116,   3, 138, 127,
/* 5000 */ 119,   5, 140, 115, 120, 115, 132,   8,
/* 5008 */ 140, 115, 138, 116, 136, 126, 115, 132,
/* 5016 */   3, 140, 127, 117,   2, 142, 117,   5,
/* 5024 */ 142, 117, 126, 142, 115,   0,   5, 104,
/* 5032 */ 131, 118, 130, 130,   5, 116, 125, 125,
/* 5040 */ 117, 123,   3, 116, 137, 123,   5, 116,
/* 5048 */ 141, 123, 117, 134,   5, 116, 141, 134,
/* 5056 */ 104, 124,   5, 117, 131, 134, 115, 138,
/* 5064 */   7, 117, 132, 116, 125, 125, 117, 123,
/* 5072 */   7, 117, 132, 123, 118, 132, 137, 123,
/* 5080 */   8, 117, 132, 123, 118, 132, 139, 104,
/* 5088 */ 132,  10, 117, 132, 125, 136, 115, 123,
/* 5096 */ 118, 132, 137, 123,   6, 117, 132, 126,
/* 5104 */ 136, 104, 124,   4, 117, 132, 137, 123,
/* 5112 */   6, 118, 131, 132, 117, 137, 123,   2,
/* 5120 */ 118, 136,   7, 123, 118, 116, 125, 125,
/* 5128 */ 117, 123,   5, 123, 118, 132, 137, 123,
/* 5136 */   5, 124, 104, 125, 117, 123,   4, 126,
/* 5144 */ 136, 115, 124,   3, 134, 115, 138,   8,
/* 5152 */ 134, 136, 104, 123, 118, 132, 137, 123,
/* 5160 */   5, 134, 136, 116, 137, 123,   4, 135,
/* 5168 */ 119, 118, 138,   5, 136, 104, 123, 117,
/* 5176 */ 134,   8, 137, 119, 122, 123, 118, 132,
/* 5184 */ 137, 123,   0,   3, 118, 119, 138,   5,
/* 5192 */ 123, 118, 119, 136, 138,   4, 123, 118,
/* 5200 */ 119, 138,   5, 125, 118, 119, 136, 132,
/* 5208 */   3, 125, 119, 137,   4, 126, 116, 132,
/* 5216 */ 138,   5, 132, 118, 131, 122, 136,   4,
/* 5224 */ 134, 116, 136, 137,   5, 137, 118, 119,
/* 5232 */ 136, 123,   4, 138, 118, 136, 138,   0,
/* 5240 */   7, 115, 119, 138, 118, 137, 138, 118,
/* 5248 */   3, 115, 123, 115,   1, 119,   3, 120,
/* 5256 */ 118, 119,   2, 122, 117,   5, 122, 117,
/* 5264 */ 123, 127, 118,   5, 122, 117, 137, 127,
/* 5272 */ 118,   2, 122, 118,   6, 122, 118, 137,
/* 5280 */ 129, 118, 118,   4, 123, 104, 126, 116,
/* 5288 */   2, 123, 115,   2, 123, 116,   2, 123,
/* 5296 */ 118,   4, 123, 127, 116, 115,   3, 123,
/* 5304 */ 127, 117,   3, 123, 130, 115,   4, 123,
/* 5312 */ 130, 115, 131,   3, 123, 130, 117,   4,
/* 5320 */ 123, 136, 118, 119,   3, 124, 136, 118,
/* 5328 */   3, 125, 130, 115,   3, 125, 130, 117,
/* 5336 */   3, 125, 130, 118,   2, 126, 115,   5,
/* 5344 */ 126, 115, 130, 118, 119,   5, 126, 115,
/* 5352 */ 130, 130, 119,   3, 126, 130, 118,   3,
/* 5360 */ 126, 136, 117,   4, 126, 136, 118, 119,
/* 5368 */   4, 127, 115, 132, 115,   7, 127, 115,
/* 5376 */ 132, 124, 117, 123, 115,   2, 127, 116,
/* 5384 */   2, 127, 118,   3, 127, 118, 118,   3,
/* 5392 */ 127, 118, 119,   2, 128, 115,   4, 128,
/* 5400 */ 115, 130, 115,   3, 128, 116, 116,   4,
/* 5408 */ 128, 119, 130, 116,   3, 128, 119, 131,
/* 5416 */   6, 129, 116, 138, 123, 127, 119,   2,
/* 5424 */ 129, 117,   4, 129, 136, 116, 116,   2,
/* 5432 */ 130, 115,   2, 130, 116,   9, 130, 116,
/* 5440 */ 115, 124, 116, 136, 137, 127, 117,   3,
/* 5448 */ 130, 119, 131,   4, 131, 115, 132, 117,
/* 5456 */   6, 131, 117, 124, 137, 127, 117,   8,
/* 5464 */ 131, 118, 138, 118, 136, 137, 127, 117,
/* 5472 */   2, 134, 116,   2, 134, 118,   8, 134,
/* 5480 */ 127, 118, 138, 118, 137, 138, 118,   3,
/* 5488 */ 134, 136, 118,   2, 136, 116,   4, 137,
/* 5496 */ 115, 130, 116,   2, 137, 116,   9, 137,
/* 5504 */ 117, 137, 138, 116, 136, 137, 127, 117,
/* 5512 */   4, 137, 123, 115, 130,   4, 137, 123,
/* 5520 */ 118, 118,   4, 137, 123, 136, 115,   3,
/* 5528 */ 137, 127, 117,   3, 137, 127, 118,   3,
/* 5536 */ 137, 129, 117,   3, 137, 130, 117,   4,
/* 5544 */ 137, 130, 118, 118,   3, 137, 138, 116,
/* 5552 */   3, 137, 138, 118,   3, 137, 138, 119,
/* 5560 */   4, 137, 138, 136, 117,   3, 137, 140,
/* 5568 */ 115,   2, 138, 115,   2, 138, 116,   2,
/* 5576 */ 138, 118,   5, 138, 119, 136, 132, 116,
/* 5584 */   3, 138, 136, 115,   4, 138, 136, 115,
/* 5592 */ 131,   3, 138, 136, 117,   3, 139, 115,
/* 5600 */ 131,   6, 139, 115, 136, 117, 123, 115,
/* 5608 */   8, 139, 117, 124, 104, 118, 123, 130,
/* 5616 */ 117,   3, 140, 127, 117,   2, 142, 117,
/* 5624 */   2, 142, 119,   0,   5,  87, 126, 117,
/* 5632 */ 130, 118,   3, 104, 130, 115,   5, 104,
/* 5640 */ 138, 127, 117, 118,   6, 115, 132, 115,
/* 5648 */ 122, 130, 116,   1, 117,   4, 122, 117,
/* 5656 */ 123, 116,   3, 122, 130, 115,   4, 123,
/* 5664 */ 120, 132, 117,   7, 123, 127, 115, 131,
/* 5672 */  87, 136, 118,   7, 123, 127, 115, 131,
/* 5680 */ 104, 136, 118,   3, 123, 127, 117,   7,
/* 5688 */ 123, 130, 115, 139, 117, 123, 116,   3,
/* 5696 */ 123, 136, 115,   3, 123, 136, 116,   5,
/* 5704 */ 125, 118, 136, 123, 116,   4, 127, 104,
/* 5712 */ 130, 118,   2, 130, 115,   6, 134, 136,
/* 5720 */ 117, 132, 123, 116,   7, 134, 136, 118,
/* 5728 */ 131, 104, 136, 118,   8, 135, 119, 115,
/* 5736 */ 124, 136, 117, 123, 116,   2, 136, 116,
/* 5744 */   4, 136, 116, 130, 115,   6, 136, 118,
/* 5752 */ 130, 130, 131, 118,   2, 137, 116,   4,
/* 5760 */ 137, 117, 132, 117,   3, 137, 123, 118,
/* 5768 */   5, 137, 123, 127, 132, 115,   3, 137,
/* 5776 */ 138, 119,   5, 138, 119, 136, 132, 116,
/* 5784 */   4, 138, 127, 136, 117,   9, 138, 136,
/* 5792 */ 117, 123, 104, 136, 115, 138, 118,   5,
/* 5800 */ 138, 136, 117, 123, 116,   7, 142, 118,
/* 5808 */ 137, 138, 104, 136, 118,   0,   3,  91,
/* 5816 */ 122, 115,   2, 115, 117,   3, 117, 116,
/* 5824 */ 136,   2, 118, 117,   2, 119, 117,   3,
/* 5832 */ 122, 136, 115,   2, 123, 115,   4, 123,
/* 5840 */ 115, 131, 119,   4, 123, 115, 131, 134,
/* 5848 */   4, 123, 118, 130, 115,   5, 123, 127,
/* 5856 */ 115, 131, 134,   3, 123, 130, 118,   3,
/* 5864 */ 123, 136, 118,   4, 124, 116, 132, 117,
/* 5872 */   2, 124, 118,   4, 124, 119, 131, 115,
/* 5880 */   3, 126, 136, 115,   3, 126, 136, 117,
/* 5888 */   3, 126, 136, 118,   4, 130, 117, 130,
/* 5896 */ 115,   2, 134, 115,   3, 134, 115, 120,
/* 5904 */   6, 134, 115, 136, 115, 124, 117,   5,
/* 5912 */ 138, 127, 118, 131, 115,   3, 139, 116,
/* 5920 */ 136,   0,  11, 104, 130, 116, 123, 138,
/* 5928 */ 136, 118, 132, 139, 118, 130,   2, 115,
/* 5936 */ 109,   3, 115, 109, 116,   3, 115, 118,
/* 5944 */ 113,   4, 115, 119, 124, 117,   6, 115,
/* 5952 */ 119, 124, 117, 131, 115,   7, 115, 119,
/* 5960 */ 138, 118, 123, 118, 115,   5, 115, 123,
/* 5968 */ 118, 132, 117,   7, 115, 123, 123, 116,
/* 5976 */ 137, 137, 117,   7, 115, 123, 127, 136,
/* 5984 */ 118, 131, 115,   8, 115, 125, 125, 117,
/* 5992 */ 124, 115, 139, 117,   3, 115, 128, 119,
/* 6000 */   6, 115, 129, 119, 115, 139, 117,   6,
/* 6008 */ 115, 129, 139, 115, 139, 117,   9, 115,
/* 6016 */ 132, 115, 137, 138, 117, 126, 131, 115,
/* 6024 */   8, 115, 132, 138, 117, 138, 136, 119,
/* 6032 */ 137,   6, 115, 135, 119, 115, 139, 117,
/* 6040 */   7, 115, 136, 138, 116, 125, 115, 123,
/* 6048 */   4, 115, 137, 123, 118,   5, 115, 142,
/* 6056 */ 117, 131, 119,   4, 116, 139, 116, 132,
/* 6064 */   4, 116, 141, 116, 115,   3, 116, 141,
/* 6072 */ 117,   6, 116, 141, 119, 130, 138, 116,
/* 6080 */   4, 117, 132, 119, 117,   6, 117, 132,
/* 6088 */ 123, 117, 134, 117,   5, 117, 132, 124,
/* 6096 */ 119, 130,   4, 117, 132, 130, 116,   4,
/* 6104 */ 117, 132, 134, 119,   5, 117, 132, 137,
/* 6112 */ 116, 136,   5, 117, 132, 137, 138, 117,
/* 6120 */   6, 117, 132, 138, 136, 118, 109,   2,
/* 6128 */ 118, 119,   3, 118, 122, 117,   6, 118,
/* 6136 */ 123, 123, 117, 134, 119,   5, 118, 125,
/* 6144 */ 125, 137, 116,   4, 118, 132, 137, 116,
/* 6152 */   1, 119,   5, 119, 131, 130, 115, 119,
/* 6160 */   7, 119, 134, 134, 116, 136, 123, 119,
/* 6168 */   5, 120, 115, 118, 119, 136,   6, 120,
/* 6176 */ 118, 126, 118, 119, 136,   7, 120, 118,
/* 6184 */ 126, 127, 118, 119, 136,   6, 122, 104,
/* 6192 */ 127, 104, 131, 118,   6, 122, 115, 130,
/* 6200 */ 130, 115, 137,   5, 122, 115, 137, 129,
/* 6208 */ 116,   3, 122, 116, 115,   2, 122, 117,
/* 6216 */   3, 122, 118, 115,   3, 122, 118, 118,
/* 6224 */   6, 122, 118, 136, 126, 127, 118,   2,
/* 6232 */ 122, 119,   3, 122, 130, 116,   5, 122,
/* 6240 */ 136, 117, 126, 127,   3, 122, 136, 119,
/* 6248 */   6, 123, 115, 128, 116, 134, 119,   3,
/* 6256 */ 123, 115, 132,   5, 123, 115, 134, 118,
/* 6264 */ 119,   3, 123, 115, 136,   5, 123, 115,
/* 6272 */ 138, 126, 119,   2, 123, 116,   7, 123,
/* 6280 */ 116, 130, 116, 122, 136, 116,  10, 123,
/* 6288 */ 116, 132, 138, 119, 131, 139, 117, 136,
/* 6296 */ 115,   3, 123, 118, 109,   3, 123, 118,
/* 6304 */ 115,   5, 123, 118, 122, 115, 130,   6,
/* 6312 */ 123, 118, 123, 129, 134, 117,   3, 123,
/* 6320 */ 118, 130,   5, 123, 118, 131, 134, 119,
/* 6328 */   8, 123, 118, 134, 120, 136, 117, 126,
/* 6336 */ 127,   3, 123, 127, 119,   9, 123, 127,
/* 6344 */ 136, 117, 137, 123, 136, 115, 125,   5,
/* 6352 */ 123, 130, 118, 137, 116,   3, 123, 132,
/* 6360 */ 116,   4, 123, 136, 115, 125,   6, 123,
/* 6368 */ 136, 117, 123, 129, 116,   6, 124, 104,
/* 6376 */ 125, 117, 123, 117,   7, 124, 116, 136,
/* 6384 */ 116, 130, 117, 123,   5, 124, 117, 126,
/* 6392 */ 116, 137,   4, 124, 117, 126, 117,   5,
/* 6400 */ 124, 117, 129, 138, 115,   7, 124, 117,
/* 6408 */ 137, 123, 118, 119, 132,   4, 124, 117,
/* 6416 */ 141, 117,   2, 124, 118,   8, 124, 119,
/* 6424 */ 119, 131, 139, 117, 136, 115,   4, 124,
/* 6432 */ 119, 136, 117,   3, 124, 136, 116,  10,
/* 6440 */ 124, 136, 116, 115, 124, 132, 118, 119,
/* 6448 */ 126, 127,   4, 124, 136, 117, 125,   2,
/* 6456 */ 125, 115,   9, 125, 115, 127, 136, 116,
/* 6464 */ 132, 127, 116, 117,   3, 125, 115, 136,
/* 6472 */   3, 125, 117, 115,   3, 125, 118, 118,
/* 6480 */   5, 125, 118, 136, 117, 132,   4, 125,
/* 6488 */ 130, 117, 132,   4, 125, 130, 117, 136,
/* 6496 */   3, 125, 136, 116,   5, 126, 115, 124,
/* 6504 */ 126, 116,   5, 126, 115, 131, 122, 117,
/* 6512 */   6, 126, 116, 137, 138, 115, 130,   2,
/* 6520 */ 126, 119,   3, 126, 119, 117,   3, 126,
/* 6528 */ 127, 101,   5, 126, 136, 115, 132, 117,
/* 6536 */   3, 127, 116, 115,   2, 127, 117,   2,
/* 6544 */ 127, 118,   9, 127, 118, 139, 116, 136,
/* 6552 */ 123, 136, 115, 125,   7, 127, 120, 124,
/* 6560 */ 136, 118, 128, 116,   4, 128, 115, 123,
/* 6568 */ 116,   5, 128, 115, 123, 129, 116,   6,
/* 6576 */ 128, 115, 123, 129, 134, 118,   5, 129,
/* 6584 */ 115, 134, 118, 119,   3, 129, 115, 136,
/* 6592 */   2, 129, 117,   3, 129, 117, 130,   7,
/* 6600 */ 129, 117, 130, 118, 139, 118, 130,   6,
/* 6608 */ 129, 119, 131, 135, 119, 115,   3, 129,
/* 6616 */ 127, 115,   6, 129, 132, 116, 137, 137,
/* 6624 */ 116,   4, 129, 132, 118, 119,   4, 129,
/* 6632 */ 136, 115, 125,   2, 130, 116,   3, 130,
/* 6640 */ 117, 125,   7, 130, 117, 130, 130, 117,
/* 6648 */ 134, 119,   3, 130, 117, 137,   3, 130,
/* 6656 */ 118, 125,   2, 130, 119,   2, 131, 115,
/* 6664 */   9, 131, 115, 126, 132, 117, 125, 117,
/* 6672 */ 123, 115,   5, 131, 115, 127, 118, 119,
/* 6680 */   3, 131, 115, 130,   5, 131, 115, 142,
/* 6688 */ 118, 119,   8, 131, 117, 123, 136, 118,
/* 6696 */ 139, 118, 130,   8, 131, 117, 130, 130,
/* 6704 */ 117, 139, 118, 130,   8, 131, 117, 132,
/* 6712 */ 115, 127, 118, 119, 116,   4, 131, 118,
/* 6720 */ 119, 130,   7, 131, 118, 119, 138, 131,
/* 6728 */ 118, 119,   7, 132, 115, 139, 117, 123,
/* 6736 */ 116, 136,   2, 132, 116,   2, 132, 117,
/* 6744 */   3, 132, 117, 116,   2, 134, 101,   2,
/* 6752 */ 134, 115,   5, 134, 115, 132, 124, 117,
/* 6760 */   9, 134, 116, 134, 134, 116, 136, 131,
/* 6768 */ 117, 132,   9, 134, 117, 123, 129, 134,
/* 6776 */ 118, 123, 129, 116,   4, 134, 117, 134,
/* 6784 */ 117,   9, 134, 117, 134, 134, 116, 136,
/* 6792 */ 131, 117, 132,   5, 134, 117, 138, 134,
/* 6800 */ 117,   4, 134, 118, 119, 106,   5, 134,
/* 6808 */ 118, 123, 129, 116,   3, 134, 123, 127,
/* 6816 */   3, 134, 125, 119,   3, 134, 125, 125,
/* 6824 */   3, 134, 127, 118,   7, 134, 136, 104,
/* 6832 */ 123, 117, 134, 119,   7, 134, 136, 104,
/* 6840 */ 138, 104, 136, 117,   4, 134, 136, 118,
/* 6848 */ 119,   5, 134, 136, 118, 122, 117,   5,
/* 6856 */ 134, 136, 118, 137, 117,   5, 134, 136,
/* 6864 */ 119, 136, 117,   3, 134, 137, 117,   4,
/* 6872 */ 134, 137, 123, 127,   5, 134, 137, 123,
/* 6880 */ 127, 119,   2, 135, 115,   5, 135, 119,
/* 6888 */ 117, 136, 115,   8, 135, 119, 118, 124,
/* 6896 */ 130, 117, 122, 116,   6, 135, 119, 131,
/* 6904 */ 135, 119, 115,   1, 136,   7, 136, 104,
/* 6912 */ 135, 119, 117, 137, 117,   4, 136, 115,
/* 6920 */ 118, 119,   7, 136, 115, 123, 115, 127,
/* 6928 */ 118, 119,   5, 136, 115, 123, 129, 116,
/* 6936 */  10, 136, 115, 124, 117, 118, 123, 118,
/* 6944 */ 122, 115, 130,   6, 136, 116, 134, 136,
/* 6952 */ 117, 132,   4, 136, 117, 122, 101,   3,
/* 6960 */ 136, 117, 125,   3, 136, 118, 118,   5,
/* 6968 */ 136, 118, 123, 129, 116,   8, 136, 119,
/* 6976 */ 132, 115, 122, 118, 119, 138,   6, 137,
/* 6984 */ 104, 123, 119, 136, 117,   7, 137, 104,
/* 6992 */ 134, 127, 117, 136, 118,   7, 137, 115,
/* 7000 */ 131, 117, 142, 124, 115,   9, 137, 115,
/* 7008 */ 138, 117, 137, 125, 116, 123, 117,   2,
/* 7016 */ 137, 116,   5, 137, 116, 130, 116, 123,
/* 7024 */   6, 137, 117, 116, 139, 116, 136,   7,
/* 7032 */ 137, 117, 132, 123, 117, 134, 119,   5,
/* 7040 */ 137, 118, 123, 129, 116,   5, 137, 118,
/* 7048 */ 139, 117, 116,   3, 137, 119, 116,   7,
/* 7056 */ 137, 119, 132, 130, 117, 126, 127,   7,
/* 7064 */ 137, 119, 134, 116, 136, 128, 116,   3,
/* 7072 */ 137, 123, 115,   4, 137, 123, 118, 119,
/* 7080 */   6, 137, 123, 118, 136, 122, 119,   5,
/* 7088 */ 137, 127, 116, 122, 115,   6, 137, 127,
/* 7096 */ 116, 132, 138, 117,   3, 137, 127, 117,
/* 7104 */   4, 137, 127, 117, 136,   3, 137, 127,
/* 7112 */ 118,   4, 137, 127, 118, 118,   4, 137,
/* 7120 */ 127, 118, 136,   4, 137, 127, 119, 132,
/* 7128 */   4, 137, 129, 116, 116,   4, 137, 131,
/* 7136 */ 115, 130,   4, 137, 131, 115, 136,   4,
/* 7144 */ 137, 131, 118, 130,   4, 137, 134, 115,
/* 7152 */ 136,   7, 137, 134, 115, 136, 129, 130,
/* 7160 */ 116,   5, 137, 134, 117, 136, 117,   3,
/* 7168 */ 137, 134, 118,   4, 137, 134, 136, 115,
/* 7176 */   5, 137, 134, 136, 117, 132,   4, 137,
/* 7184 */ 135, 119, 115,   5, 137, 138, 115, 122,
/* 7192 */ 115,   6, 137, 138, 115, 122, 130, 115,
/* 7200 */   8, 137, 138, 116, 115, 131, 122, 118,
/* 7208 */ 115,   4, 137, 138, 118, 119,   9, 137,
/* 7216 */ 140, 116, 115, 138, 137, 127, 117, 136,
/* 7224 */   2, 138, 115,   4, 138, 115, 123, 116,
/* 7232 */   3, 138, 117, 130,   5, 138, 117, 130,
/* 7240 */ 137, 117,   2, 138, 119,   4, 138, 119,
/* 7248 */ 138, 119,   6, 138, 136, 115, 132, 137,
/* 7256 */ 115,   7, 138, 136, 115, 132, 137, 116,
/* 7264 */ 134,   6, 138, 136, 115, 132, 137, 117,
/* 7272 */   4, 138, 136, 119, 137,   2, 139, 115,
/* 7280 */   5, 139, 116, 130, 139, 116,   5, 139,
/* 7288 */ 116, 132, 117, 115,   6, 139, 116, 136,
/* 7296 */ 131, 118, 119,   3, 139, 118, 130,   6,
/* 7304 */ 140, 115, 136, 136, 115, 132,  10, 140,
/* 7312 */ 115, 138, 116, 136, 123, 130, 118, 137,
/* 7320 */ 116,   5, 140, 117, 123, 129, 116,   6,
/* 7328 */ 140, 117, 130, 124, 123, 115,   6, 140,
/* 7336 */ 117, 132, 126, 130, 116,   5, 140, 118,
/* 7344 */ 131, 122, 115,   8, 142, 117, 126, 126,
/* 7352 */ 118, 119, 136, 115,   2, 142, 119,   0,
/* 7360 */   2, 115, 116,   3, 115, 118, 119,   2,
/* 7368 */ 117, 115,   2, 118, 115,   1, 122,   2,
/* 7376 */ 122, 117,   3, 122, 136, 115,   2, 129,
/* 7384 */ 115,   3, 134, 136, 115,   0,   8, 104,
/* 7392 */ 134, 117, 137, 134, 115, 124, 117,   5,
/* 7400 */ 115, 122, 136, 115, 141,   7, 115, 123,
/* 7408 */ 115, 132, 138, 127, 117,   3, 115, 130,
/* 7416 */ 117,   5, 115, 130, 118, 134, 117,   7,
/* 7424 */ 115, 130, 123, 115, 136, 115, 142,   6,
/* 7432 */ 115, 130, 138, 119, 126, 130,   5, 115,
/* 7440 */ 131, 122, 116, 137,   2, 115, 132,   4,
/* 7448 */ 115, 132, 115, 122,   4, 115, 132, 115,
/* 7456 */ 132,   8, 115, 132, 124, 136, 118, 124,
/* 7464 */ 115, 131,   8, 115, 134, 137, 115, 136,
/* 7472 */ 115, 136, 126,   3, 115, 138, 130,   2,
/* 7480 */ 119, 134,   3, 122, 118, 130,   8, 123,
/* 7488 */ 115, 138, 118, 122, 130, 104, 134,   3,
/* 7496 */ 123, 115, 139,   3, 123, 115, 140,   6,
/* 7504 */ 123, 116, 136, 115, 138, 117,   3, 123,
/* 7512 */ 120, 123,   4, 123, 120, 123, 130,  11,
/* 7520 */ 123, 127, 130, 115, 131, 120, 124, 118,
/* 7528 */ 131, 118, 132,   6, 123, 127, 136, 117,
/* 7536 */ 138, 131,   2, 123, 130,   5, 123, 137,
/* 7544 */ 115, 136, 124,   5, 123, 142, 115, 136,
/* 7552 */ 124,   5, 124, 118, 119, 126, 130,   6,
/* 7560 */ 125, 115, 131, 117, 130, 117,   4, 126,
/* 7568 */ 115, 131, 122,   5, 126, 136, 115, 138,
/* 7576 */ 117,   3, 127, 104, 130,   7, 127, 115,
/* 7584 */ 131, 115, 124, 136, 120,   3, 127, 115,
/* 7592 */ 139,   7, 127, 117, 134, 134, 118, 123,
/* 7600 */ 136,   6, 127, 120, 134, 118, 123, 136,
/* 7608 */   9, 127, 120, 134, 118, 137, 134, 115,
/* 7616 */ 124, 117,   1, 128,   5, 128, 115, 123,
/* 7624 */ 118, 132,   5, 128, 119, 131, 115, 136,
/* 7632 */   2, 129, 139,   2, 129, 140,   3, 130,
/* 7640 */ 104, 134,   4, 130, 115, 131, 134,   2,
/* 7648 */ 130, 117,   1, 131,   4, 131, 115, 124,
/* 7656 */ 136,   5, 131, 115, 136, 115, 123,   4,
/* 7664 */ 131, 117, 130, 130,   3, 132, 115, 109,
/* 7672 */   3, 132, 116, 125,   3, 132, 117, 132,
/* 7680 */   5, 132, 118, 137, 138, 136,   6, 134,
/* 7688 */ 115, 132, 123, 136, 104,   3, 134, 115,
/* 7696 */ 134,   6, 134, 115, 138, 115, 119, 126,
/* 7704 */   9, 134, 127, 120, 138, 104, 130, 104,
/* 7712 */ 134, 127,   7, 134, 130, 116, 141, 117,
/* 7720 */ 126, 130,   9, 134, 137, 116, 119, 124,
/* 7728 */ 118, 131, 118, 132,   3, 134, 137, 118,
/* 7736 */   1, 136,   1, 137,   6, 137, 104, 136,
/* 7744 */ 115, 134, 117,   5, 137, 115, 138, 115,
/* 7752 */ 132,   4, 137, 116, 132, 137,   4, 137,
/* 7760 */ 118, 119, 130,   6, 137, 134, 118, 132,
/* 7768 */ 124, 117,   3, 137, 138, 136,   4, 138,
/* 7776 */ 104, 138, 136,   3, 138, 136, 117,   9,
/* 7784 */ 138, 136, 117, 123, 127, 118, 131, 118,
/* 7792 */ 132,   6, 139, 115, 137, 117, 137, 138,
/* 7800 */   5, 139, 116, 136, 117, 138,   0,   3,
/* 7808 */ 115, 126, 132,   3, 115, 130, 118,   6,
/* 7816 */ 115, 130, 129, 116, 136, 131,   6, 115,
/* 7824 */ 137, 134, 116, 136, 126,   4, 116, 141,
/* 7832 */ 134, 136,   3, 122, 115, 130,   7, 122,
/* 7840 */ 118, 119, 123, 130, 115, 136,   6, 123,
/* 7848 */ 115, 123, 115, 138, 118,   5, 123, 118,
/* 7856 */ 123, 118, 124,   4, 123, 118, 136, 138,
/* 7864 */   6, 124, 115, 131, 118, 123, 130,   4,
/* 7872 */ 125, 115, 123, 117,   4, 127, 116, 136,
/* 7880 */ 131,   4, 127, 116, 136, 134,   4, 128,
/* 7888 */ 115, 119, 136,   6, 129, 115, 129, 115,
/* 7896 */ 138, 118,   4, 129, 116, 136, 131,   5,
/* 7904 */ 129, 127, 115, 131, 131,   5, 130, 118,
/* 7912 */ 132, 124, 136,   2, 130, 119,  12, 131,
/* 7920 */ 104, 134, 127, 117, 137, 138, 118, 134,
/* 7928 */ 127, 104, 130,   7, 132, 104, 134, 116,
/* 7936 */ 132, 138, 127,   6, 134, 115, 130, 131,
/* 7944 */ 115, 136,   6, 134, 115, 138, 115, 135,
/* 7952 */ 119,   4, 136, 116, 126, 136,   7, 137,
/* 7960 */ 117, 136, 139, 116, 132, 138,   3, 138,
/* 7968 */ 115, 122,   3, 141, 104, 136,   0,   3,
/* 7976 */  87, 118, 130,   6,  87, 134, 120, 118,
/* 7984 */ 136, 132,   3, 104, 130,  87,   3, 104,
/* 7992 */ 130, 104,  11, 104, 130, 104, 134, 127,
/* 8000 */ 115, 132, 138, 117, 115, 137,   5, 104,
/* 8008 */ 134, 115, 123, 136,   6, 104, 134, 117,
/* 8016 */ 118, 136, 132,   7, 104, 134, 117, 137,
/* 8024 */ 138, 115, 141,   6, 104, 134, 120, 118,
/* 8032 */ 136, 132,   4, 115, 116, 118, 130,   5,
/* 8040 */ 115, 119, 141, 105, 137,   4, 115, 124,
/* 8048 */ 118, 132,   6, 115, 126, 136, 118, 137,
/* 8056 */ 138,   5, 115, 126, 136, 118, 138,   4,
/* 8064 */ 115, 131, 115, 124,   7, 115, 131, 115,
/* 8072 */ 136, 120, 130, 130,   4, 115, 131, 120,
/* 8080 */ 136,   8, 115, 131, 122, 130, 120, 118,
/* 8088 */ 134, 137,   8, 115, 131, 122, 130, 120,
/* 8096 */ 118, 136, 132,   8, 115, 131, 134, 104,
/* 8104 */ 130, 118, 134, 137,   2, 115, 132,   7,
/* 8112 */ 115, 132, 115, 126, 115, 130, 130,   8,
/* 8120 */ 115, 132, 138, 117, 122, 117, 118, 137,
/* 8128 */   6, 115, 132, 138, 127, 104, 131,   7,
/* 8136 */ 115, 132, 138, 127, 120, 130, 130,   2,
/* 8144 */ 115, 134,   3, 115, 136, 137,   5, 115,
/* 8152 */ 137, 123, 115, 136,   2, 115, 141,   5,
/* 8160 */ 116, 119, 124, 104, 131,   7, 116, 132,
/* 8168 */ 126, 136, 115, 119, 130,   4, 116, 134,
/* 8176 */ 119, 130,   6, 116, 141, 138, 136, 116,
/* 8184 */ 131,   2, 117, 122,   8, 117, 123, 127,
/* 8192 */ 138, 120, 118, 136, 132,   7, 117, 132,
/* 8200 */ 130, 115, 132, 124, 137,   2, 117, 136,
/* 8208 */   4, 117, 136, 117, 138,   3, 117, 136,
/* 8216 */ 122,   4, 117, 137, 115, 138,   3, 118,
/* 8224 */ 115, 137,   8, 118, 123, 138, 115, 104,
/* 8232 */ 138, 104, 136,   4, 118, 132, 118, 132,
/* 8240 */   4, 118, 132, 120, 141,   6, 118, 134,
/* 8248 */ 127, 117, 115, 137,   4, 118, 136, 123,
/* 8256 */ 127,   8, 118, 137, 138, 104, 118, 130,
/* 8264 */ 116, 134,   6, 118, 138, 118, 123, 118,
/* 8272 */ 136,   7, 118, 138, 118, 134, 117, 104,
/* 8280 */ 137,   7, 118, 139, 118, 138, 116, 137,
/* 8288 */ 138,   4, 118, 141, 115, 130,   4, 119,
/* 8296 */ 132, 126, 119,   1, 122,   4, 122, 116,
/* 8304 */ 130, 130,   4, 122, 130, 117, 132,   4,
/* 8312 */ 123, 115, 119, 136,   5, 123, 115, 124,
/* 8320 */ 104, 124,   7, 123, 115, 130, 115, 137,
/* 8328 */ 117, 136,   6, 123, 115, 132, 132, 115,
/* 8336 */ 122,   4, 123, 115, 137, 137,   7, 123,
/* 8344 */ 115, 138, 127, 115, 136, 137,   6, 123,
/* 8352 */ 118, 123, 127, 120, 130,   7, 123, 118,
/* 8360 */ 132, 123, 127, 120, 130,   7, 123, 118,
/* 8368 */ 136, 104, 118, 134, 137,   7, 123, 118,
/* 8376 */ 136, 120, 124, 115, 130,   8, 123, 118,
/* 8384 */ 136, 120, 130, 118, 134, 137,   9, 123,
/* 8392 */ 127, 104, 117, 136, 118, 130, 104, 134,
/* 8400 */   6, 123, 127, 104, 131, 118, 137,   5,
/* 8408 */ 123, 127, 117, 118, 132,  10, 123, 127,
/* 8416 */ 117, 136, 118, 138, 116, 119, 138, 127,
/* 8424 */   3, 123, 127, 136,   6, 123, 130, 117,
/* 8432 */ 138, 118, 136,   8, 124, 115, 137, 120,
/* 8440 */ 134, 116, 130, 138,   4, 124, 116, 117,
/* 8448 */ 141,   7, 124, 117, 115, 137, 138, 115,
/* 8456 */ 137,   6, 124, 117, 132, 118, 136, 132,
/* 8464 */   8, 124, 118, 130, 117, 123, 127, 118,
/* 8472 */ 138,   5, 124, 118, 130, 118, 136,   3,
/* 8480 */ 124, 118, 136,   7, 126, 115, 130, 104,
/* 8488 */ 118, 134, 137,   5, 126, 116, 132, 116,
/* 8496 */ 136,   4, 126, 116, 136, 136,   6, 126,
/* 8504 */ 130, 118, 131, 104, 136,   4, 126, 136,
/* 8512 */ 115, 138,  12, 127, 104, 136, 104, 124,
/* 8520 */ 118, 137, 120, 134, 127, 117, 130,   6,
/* 8528 */ 127, 115, 130, 117, 118, 138,   7, 127,
/* 8536 */ 115, 131, 115, 131, 104, 130,   7, 127,
/* 8544 */ 116, 132, 124, 117, 115, 124,   9, 127,
/* 8552 */ 117, 134, 134, 118, 138, 117, 126, 136,
/* 8560 */   5, 127, 118, 132, 118, 136,   5, 127,
/* 8568 */ 119, 131, 117, 130,   9, 127, 120, 124,
/* 8576 */ 136, 118, 123, 127, 115, 136,   8, 127,
/* 8584 */ 120, 130, 118, 123, 127, 115, 136,   8,
/* 8592 */ 127, 120, 137, 138, 104, 136, 104, 137,
/* 8600 */   3, 128, 115, 124,   3, 128, 119, 122,
/* 8608 */   4, 129, 118, 119, 131,   7, 129, 136,
/* 8616 */ 115, 119, 136, 118, 137,   8, 130, 104,
/* 8624 */ 118, 132, 138, 117, 115, 137,   5, 130,
/* 8632 */ 115, 126, 118, 138,   4, 130, 115, 126,
/* 8640 */ 119,   3, 130, 115, 134,   4, 130, 116,
/* 8648 */ 134, 138,   3, 130, 116, 141,   4, 130,
/* 8656 */ 117, 122, 136,   5, 130, 117, 134, 115,
/* 8664 */ 136,   3, 130, 117, 138,   4, 130, 118,
/* 8672 */ 132, 126,   3, 130, 118, 136,   5, 130,
/* 8680 */ 120, 123, 127, 132,   3, 130, 120, 137,
/* 8688 */   8, 131, 104, 123, 118, 132, 118, 134,
/* 8696 */ 137,   5, 131, 104, 136, 104, 137,   3,
/* 8704 */ 131, 104, 138,   9, 131, 115, 123, 136,
/* 8712 */ 118, 123, 120, 137, 138,   7, 131, 115,
/* 8720 */ 136, 115, 139, 104, 124,   6, 131, 115,
/* 8728 */ 138, 127, 104, 137,   5, 131, 117, 130,
/* 8736 */ 136, 116,   5, 131, 117, 131, 116, 137,
/* 8744 */   7, 131, 117, 136, 115, 122, 117, 130,
/* 8752 */   6, 131, 119, 138, 115, 132, 124,   5,
/* 8760 */ 131, 119, 138, 115, 138,   4, 131, 120,
/* 8768 */ 118, 137,   6, 131, 120, 118, 137, 118,
/* 8776 */ 138,  11, 132, 116, 119, 136, 118, 137,
/* 8784 */ 120, 134, 127, 117, 130,   8, 134, 104,
/* 8792 */ 123, 118, 134, 138, 104, 136,   3, 134,
/* 8800 */ 104, 132,   8, 134, 104, 136, 117, 118,
/* 8808 */ 132, 120, 141,   4, 134, 115, 119, 123,
/* 8816 */   3, 134, 115, 132,  10, 134, 115, 136,
/* 8824 */ 115, 134, 127, 117, 131, 118, 137,   4,
/* 8832 */ 134, 115, 137, 138,   4, 134, 116, 130,
/* 8840 */ 139,   4, 134, 117, 123, 136,   8, 134,
/* 8848 */ 117, 138, 120, 136, 117, 115, 137,   3,
/* 8856 */ 134, 119, 122,   5, 134, 120, 136, 118,
/* 8864 */ 137,   9, 134, 120, 136, 136, 127, 118,
/* 8872 */ 123, 118, 136,   6, 134, 127, 117, 131,
/* 8880 */ 118, 137,   6, 134, 127, 120, 137, 115,
/* 8888 */ 130,   8, 134, 127, 138, 117, 136, 117,
/* 8896 */ 115, 137,   4, 134, 136, 115, 141,   7,
/* 8904 */ 134, 136, 118, 122, 118, 137, 123,   7,
/* 8912 */ 134, 136, 118, 125, 118, 132, 124,   8,
/* 8920 */ 134, 136, 118, 126, 130, 118, 138, 138,
/* 8928 */   6, 134, 136, 118, 134, 118, 130,   7,
/* 8936 */ 134, 137, 118, 136, 117, 115, 137,   4,
/* 8944 */ 134, 138, 118, 137,   4, 136, 115, 123,
/* 8952 */ 127,  10, 136, 115, 131, 117, 132, 115,
/* 8960 */ 126, 136, 118, 122,   5, 136, 116, 131,
/* 8968 */ 118, 138,   6, 137, 104, 131, 117, 118,
/* 8976 */ 137,  10, 137, 115, 130, 134, 117, 126,
/* 8984 */ 130, 118, 137, 137,   8, 137, 115, 138,
/* 8992 */ 120, 136, 117, 115, 137,   4, 137, 117,
/* 9000 */ 115, 130,   5, 137, 117, 132, 115, 134,
/* 9008 */   5, 137, 117, 138, 115, 136,   9, 137,
/* 9016 */ 118, 134, 127, 136, 118, 132, 117, 138,
/* 9024 */   5, 137, 120, 123, 118, 137,   6, 137,
/* 9032 */ 120, 132, 118, 134, 137,   7, 137, 120,
/* 9040 */ 132, 123, 127, 120, 137,   6, 137, 120,
/* 9048 */ 134, 127, 117, 130,   8, 137, 123, 127,
/* 9056 */ 117, 132, 118, 134, 137,  15, 137, 134,
/* 9064 */ 118, 132, 124, 120, 130, 118, 130, 117,
/* 9072 */ 137, 138, 127, 104, 137,   5, 138, 115,
/* 9080 */ 131, 115, 136,   4, 138, 116, 132, 132,
/* 9088 */   7, 138, 118, 119, 136, 132, 116, 139,
/* 9096 */   8, 138, 119, 134, 117, 132, 115, 131,
/* 9104 */ 122,   4, 138, 127, 104, 137,   8, 138,
/* 9112 */ 136, 117, 123, 127, 117, 115, 137,   1,
/* 9120 */ 139,   4, 139, 116, 136, 131,   4, 139,
/* 9128 */ 117, 123, 138,   3, 139, 118, 123,   7,
/* 9136 */ 139, 118, 130, 119, 122, 117, 130,   5,
/* 9144 */ 141, 104, 136, 118, 137,   5, 142, 115,
/* 9152 */ 131, 116, 132,   0,   2, 104, 134,   2,
/* 9160 */ 104, 136,   9, 115, 125, 117, 123, 117,
/* 9168 */ 118, 132, 115, 124,  10, 115, 125, 125,
/* 9176 */ 117, 123, 117, 118, 132, 115, 124,   3,
/* 9184 */ 115, 130, 117,   6, 115, 130, 122, 115,
/* 9192 */ 138, 136,   5, 115, 130, 122, 117, 132,
/* 9200 */   4, 115, 131, 132, 117,  10, 115, 131,
/* 9208 */ 134, 104, 130, 118, 124, 116, 137, 131,
/* 9216 */   3, 115, 134, 117,   5, 115, 138, 136,
/* 9224 */ 118, 134,   4, 115, 142, 120, 126,  10,
/* 9232 */ 116, 137, 123, 115, 131, 134, 115, 138,
/* 9240 */ 117, 139,   4, 116, 138, 127, 132,   3,
/* 9248 */ 117, 138, 127,   4, 118, 139, 117, 122,
/* 9256 */   4, 122, 115, 137, 138,   5, 122, 116,
/* 9264 */ 132, 138, 127,   3, 122, 117, 138,   5,
/* 9272 */ 122, 119, 123, 104, 136,   4, 122, 120,
/* 9280 */ 122, 130,   6, 123, 115, 130, 115, 132,
/* 9288 */ 124,   6, 123, 115, 130, 116, 132, 124,
/* 9296 */   6, 123, 115, 130, 139, 115, 124,   4,
/* 9304 */ 123, 115, 131, 134,   4, 123, 118, 118,
/* 9312 */ 130,   4, 123, 118, 119, 136,   4, 123,
/* 9320 */ 118, 137, 131,   6, 123, 136, 115, 117,
/* 9328 */ 126, 132,   4, 124, 118, 119, 130,   4,
/* 9336 */ 124, 136, 118, 131,   9, 127, 115, 130,
/* 9344 */ 118, 122, 116, 132, 138, 127,   6, 127,
/* 9352 */ 115, 130, 118, 122, 117,   7, 127, 116,
/* 9360 */ 117, 131, 115, 138, 130,   8, 127, 120,
/* 9368 */ 124, 136, 115, 131, 132, 117,   4, 129,
/* 9376 */ 118, 119, 136,   1, 130,   3, 130, 115,
/* 9384 */ 126,   7, 130, 117, 131, 132, 118, 122,
/* 9392 */ 117,   7, 131, 104, 126, 115, 123, 104,
/* 9400 */ 136,   5, 131, 104, 136, 117, 132,   9,
/* 9408 */ 131, 104, 137, 118, 132, 104, 134, 127,
/* 9416 */ 136,   9, 131, 104, 138, 115, 132, 104,
/* 9424 */ 134, 127, 136,   3, 131, 116, 130,   2,
/* 9432 */ 131, 118,   3, 131, 119, 136,   2, 132,
/* 9440 */ 115,   3, 132, 118, 138,   5, 134, 115,
/* 9448 */ 134, 120, 136,   4, 134, 115, 134, 127,
/* 9456 */   3, 134, 115, 136,   5, 134, 115, 136,
/* 9464 */ 118, 124,   4, 134, 115, 138, 127,   5,
/* 9472 */ 134, 116, 130, 115, 126,   5, 134, 127,
/* 9480 */ 115, 130, 130,   8, 134, 136, 118, 132,
/* 9488 */ 104, 134, 127, 136,   5, 134, 136, 118,
/* 9496 */ 132, 115,   5, 136, 115, 134, 117, 124,
/* 9504 */   8, 136, 127, 117, 132, 118, 123, 104,
/* 9512 */ 136,   3, 137, 115, 136,   3, 137, 119,
/* 9520 */ 136,   3, 137, 134, 104,   7, 137, 134,
/* 9528 */ 104, 123, 119, 130, 118,   5, 137, 138,
/* 9536 */ 115, 131, 132,   7, 137, 138, 136, 120,
/* 9544 */ 123, 127, 132,   5, 138, 104, 138, 115,
/* 9552 */ 132,   6, 138, 115, 123, 118, 132, 116,
/* 9560 */   5, 138, 116, 131, 116, 132,   6, 138,
/* 9568 */ 127, 115, 132, 115, 138,   5, 138, 127,
/* 9576 */ 116, 136, 131,   4, 138, 127, 118, 130,
/* 9584 */   9, 138, 136, 115, 132, 135, 119, 117,
/* 9592 */ 130, 130,   0,   1,  91,  10, 104, 123,
/* 9600 */ 127, 117, 132, 118, 123, 115, 123, 138,
/* 9608 */   8, 104, 134, 117, 123, 115, 132, 138,
/* 9616 */ 127,   4, 111, 137, 138, 136,   4, 115,
/* 9624 */ 117, 136, 122,   5, 115, 119, 138, 118,
/* 9632 */ 122,   7, 115, 119, 138, 118, 125, 118,
/* 9640 */ 123,   5, 115, 122, 136, 117, 122,   4,
/* 9648 */ 115, 123, 115, 136,   4, 115, 123, 117,
/* 9656 */ 132,   3, 115, 126, 132,   9, 115, 130,
/* 9664 */ 138, 118, 123, 119, 131, 119, 130,   9,
/* 9672 */ 115, 130, 138, 118, 137, 138, 136, 115,
/* 9680 */ 138,   7, 115, 131, 134, 127, 117, 118,
/* 9688 */ 141,   2, 115, 132,   5, 115, 132, 126,
/* 9696 */ 104, 130,   7, 115, 136, 122, 118, 139,
/* 9704 */ 117, 136,   3, 115, 136, 126,   7, 115,
/* 9712 */ 137, 134, 115, 136, 115, 126,   8, 116,
/* 9720 */ 119, 123, 115, 130, 120, 134, 138,   3,
/* 9728 */ 117, 123, 138,   3, 117, 130, 104,   7,
/* 9736 */ 117, 132, 125, 115, 136, 123, 138,   5,
/* 9744 */ 118, 116, 137, 138, 136,   4, 118, 123,
/* 9752 */ 119, 130,   6, 118, 130, 117, 122, 136,
/* 9760 */ 117,   5, 118, 131, 132, 117, 122,   2,
/* 9768 */ 118, 134,   4, 118, 136, 104, 131,   4,
/* 9776 */ 118, 136, 117, 122,   8, 119, 130, 138,
/* 9784 */ 136, 115, 139, 117, 136,   2, 119, 136,
/* 9792 */   3, 119, 136,  87,   4, 119, 138, 104,
/* 9800 */ 136,   1, 122,   7, 122, 117, 122, 130,
/* 9808 */ 117, 118, 122,   5, 122, 117, 125, 117,
/* 9816 */ 124,   3, 122, 118, 132,   4, 122, 120,
/* 9824 */ 137, 137,   4, 122, 130, 118, 123,   4,
/* 9832 */ 123, 115, 123, 138,   4, 123, 115, 131,
/* 9840 */ 134,   5, 123, 115, 136, 118, 130,   3,
/* 9848 */ 123, 115, 137,   4, 123, 115, 137, 138,
/* 9856 */   4, 123, 117, 136, 136,   4, 123, 117,
/* 9864 */ 138, 136,   4, 123, 118, 123, 123,   7,
/* 9872 */ 123, 118, 130, 130, 115, 134, 137,   7,
/* 9880 */ 123, 118, 132, 137, 116, 132, 137,   9,
/* 9888 */ 123, 118, 132, 139, 118, 130, 139, 119,
/* 9896 */ 130,   4, 123, 118, 136, 134,   5, 123,
/* 9904 */ 118, 137, 117, 132,   4, 123, 118, 137,
/* 9912 */ 137,   5, 123, 119, 122, 117, 138,   3,
/* 9920 */ 123, 119, 128,   5, 123, 119, 131, 119,
/* 9928 */ 130,   4, 123, 119, 136, 137,   4, 123,
/* 9936 */ 127, 118, 136,   5, 123, 130, 115, 119,
/* 9944 */ 137,   4, 123, 130, 118, 132,   4, 123,
/* 9952 */ 136, 104, 137,   4, 123, 136, 118, 123,
/* 9960 */   7, 124, 104, 123, 119, 122, 117, 138,
/* 9968 */   6, 124, 104, 138, 136, 117, 138,   8,
/* 9976 */ 124, 117, 134, 130, 118, 124, 118, 123,
/* 9984 */   3, 125, 111, 138,   3, 125, 115, 139,
/* 9992 */   3, 125, 117, 123,   4, 125, 118, 116,
/* 10000 */ 138,   4, 125, 118, 132, 126,   3, 125,
/* 10008 */ 119, 123,   1, 126,   3, 126, 117, 122,
/* 10016 */   4, 126, 136, 115, 124,   5, 127, 115,
/* 10024 */ 122, 117, 138,   4, 127, 117, 115, 138,
/* 10032 */   6, 127, 117, 122, 117, 137, 123,   3,
/* 10040 */ 127, 119, 131,   5, 127, 119, 131, 104,
/* 10048 */ 136,  10, 127, 120, 134, 118, 138, 127,
/* 10056 */ 115, 130, 115, 131,   5, 128, 115, 123,
/* 10064 */ 118, 122,   3, 130, 115, 109,   4, 130,
/* 10072 */ 115, 134, 137,   3, 130, 118, 138,   3,
/* 10080 */ 130, 119, 134,   4, 131, 104, 124, 117,
/* 10088 */   3, 131, 115, 130,   6, 131, 117, 123,
/* 10096 */ 136, 118, 122,   3, 131, 117, 132,   5,
/* 10104 */ 131, 117, 132, 117, 122,   4, 131, 118,
/* 10112 */ 136, 122,   6, 131, 118, 136, 124, 117,
/* 10120 */ 123,   3, 131, 118, 138,   3, 131, 119,
/* 10128 */ 123,   3, 132,  87, 139,   3, 132, 104,
/* 10136 */ 126,   6, 132, 115, 119, 134, 130, 117,
/* 10144 */   4, 132, 117, 131, 122,   5, 132, 119,
/* 10152 */ 123, 130, 104,   5, 132, 119, 131, 104,
/* 10160 */ 136,   5, 132, 119, 131, 116, 136,   7,
/* 10168 */ 132, 120, 137, 138, 115, 126, 131,   3,
/* 10176 */ 134, 115, 126,   6, 134, 115, 132, 124,
/* 10184 */ 115, 132,   5, 134, 115, 134, 120, 136,
/* 10192 */   6, 134, 115, 136, 138, 117, 122,   5,
/* 10200 */ 134, 127, 115, 130, 130,   4, 134, 130,
/* 10208 */ 116, 141,   7, 134, 136, 118, 123, 116,
/* 10216 */ 137, 137,   7, 134, 136, 118, 130, 115,
/* 10224 */ 134, 137,   8, 134, 136, 118, 137, 134,
/* 10232 */ 116, 123, 138,   9, 134, 136, 118, 138,
/* 10240 */ 118, 123, 118, 123, 123,   4, 134, 136,
/* 10248 */ 119, 132,   4, 135, 119, 117, 138,   3,
/* 10256 */ 136, 104, 122,   8, 136, 104, 138, 136,
/* 10264 */ 118, 139, 117, 136,   4, 136, 115, 124,
/* 10272 */ 117,   4, 136, 115, 134, 138,   5, 136,
/* 10280 */ 115, 137, 117, 122,   4, 136, 117, 123,
/* 10288 */ 138,   6, 136, 117, 137, 118, 136, 117,
/* 10296 */   4, 136, 127, 104, 137,   8, 136, 127,
/* 10304 */ 117, 132, 118, 139, 117, 136,   1, 137,
/* 10312 */   5, 137, 115, 132, 123, 138,   3, 137,
/* 10320 */ 117, 132,   6, 137, 120, 130, 130, 115,
/* 10328 */ 122,   6, 137, 138, 117, 131, 119, 130,
/* 10336 */  10, 137, 138, 136, 115, 124, 117, 139,
/* 10344 */ 115, 136, 117,   5, 137, 138, 136, 115,
/* 10352 */ 138,   9, 137, 138, 136, 118, 134, 127,
/* 10360 */ 115, 132, 138,   6, 138, 116, 136, 131,
/* 10368 */ 117, 132,   3, 138, 118, 132,   4, 138,
/* 10376 */ 118, 134, 127,   5, 138, 119, 131, 119,
/* 10384 */ 130,   7, 138, 120, 130, 116, 132, 123,
/* 10392 */ 127,   4, 138, 120, 134, 127,   7, 138,
/* 10400 */ 127, 104, 137, 115, 119, 136,   6, 138,
/* 10408 */ 127, 115, 130, 115, 131,   4, 138, 127,
/* 10416 */ 120, 131,   6, 138, 127, 136, 118, 131,
/* 10424 */ 122,   5, 138, 136, 115, 123, 138,   4,
/* 10432 */ 138, 136, 115, 126,   5, 138, 136, 117,
/* 10440 */ 137, 131,   8, 138, 136, 118, 130, 130,
/* 10448 */ 116, 120, 122,   3, 139, 104, 132,   4,
/* 10456 */ 139, 115, 130, 126,   3, 139, 115, 136,
/* 10464 */   4, 139, 116, 136, 137,   5, 139, 117,
/* 10472 */ 124, 117, 131,   3, 139, 117, 136,   6,
/* 10480 */ 139, 117, 138, 116, 130, 130,   6, 139,
/* 10488 */ 118, 130, 139, 119, 130,   3, 141, 104,
/* 10496 */ 136,   0,   6, 104, 118, 127, 117, 134,
/* 10504 */ 134,   8, 104, 130, 116, 123, 138, 136,
/* 10512 */ 118, 122,  10, 104, 130, 116, 123, 138,
/* 10520 */ 136, 118, 138, 118, 132,   4, 104, 131,
/* 10528 */ 104, 136,   2, 111, 123,   5, 115, 104,
/* 10536 */ 136, 118, 122,   4, 115, 119, 136, 116,
/* 10544 */   6, 115, 122, 118, 131, 115, 137,   8,
/* 10552 */ 115, 124, 104, 132, 118, 139, 117, 136,
/* 10560 */   4, 115, 124, 118, 141,   5, 115, 126,
/* 10568 */ 136, 117, 130,   8, 115, 130, 123, 116,
/* 10576 */ 130, 115, 134, 127,   8, 115, 131, 115,
/* 10584 */ 119, 136, 118, 122, 117,  12, 115, 131,
/* 10592 */ 118, 136, 134, 127, 118, 134, 127, 115,
/* 10600 */ 130, 130,   7, 115, 131, 120, 126, 124,
/* 10608 */ 115, 130,   5, 115, 131, 122, 117, 138,
/* 10616 */   4, 115, 132, 117, 131,   8, 115, 132,
/* 10624 */ 138, 117, 138, 136, 115, 126,   7, 115,
/* 10632 */ 132, 138, 117, 139, 117, 136,   2, 115,
/* 10640 */ 134,   6, 115, 134, 127, 117, 124, 117,
/* 10648 */   9, 115, 137, 134, 116, 136, 126, 117,
/* 10656 */ 130, 130,   5, 115, 137, 138, 115, 123,
/* 10664 */   6, 115, 138, 116, 119, 123, 127,   5,
/* 10672 */ 115, 138, 138, 115, 123,   7, 115, 138,
/* 10680 */ 138, 116, 130, 115, 122,   5, 116, 130,
/* 10688 */ 115, 134, 127,   5, 116, 131, 122, 118,
/* 10696 */ 130,   9, 116, 132, 138, 104, 136, 118,
/* 10704 */ 139, 117, 136,   6, 116, 141, 118, 115,
/* 10712 */ 137, 123,   6, 116, 141, 123, 119, 136,
/* 10720 */ 137,   5, 117, 122, 117, 137, 123,   5,
/* 10728 */ 117, 131, 134, 116, 138,   8, 117, 132,
/* 10736 */ 125, 136, 115, 139, 117, 136,   9, 117,
/* 10744 */ 132, 138, 116, 136, 136, 115, 124, 117,
/* 10752 */   5, 118, 123, 123, 115, 122,   4, 118,
/* 10760 */ 130, 116, 132,   7, 118, 130, 116, 132,
/* 10768 */ 116, 130, 130,   4, 118, 136, 116, 131,
/* 10776 */   3, 119, 130, 123,   3, 119, 132, 123,
/* 10784 */   5, 119, 132, 123, 117, 132,   5, 122,
/* 10792 */ 115, 123, 123, 127,   6, 122, 115, 137,
/* 10800 */ 117, 130, 116,   8, 122, 116, 132, 116,
/* 10808 */ 124, 117, 123, 138,   3, 122, 117, 122,
/* 10816 */  12, 122, 136, 115, 132, 123, 127, 117,
/* 10824 */ 118, 137, 115, 119, 136,   7, 123, 115,
/* 10832 */ 132, 138, 127, 115, 136,   3, 123, 115,
/* 10840 */ 136,  10, 123, 117, 136, 136, 118, 123,
/* 10848 */ 119, 131, 119, 130,  10, 123, 117, 136,
/* 10856 */ 136, 118, 137, 138, 136, 115, 138,   4,
/* 10864 */ 123, 118, 117, 138,   4, 123, 118, 130,
/* 10872 */ 104,   7, 123, 118, 131, 134, 130, 116,
/* 10880 */ 141,   4, 123, 118, 137, 138,  10, 123,
/* 10888 */ 119, 131, 119, 130, 118, 132, 117, 131,
/* 10896 */ 122,  11, 123, 119, 131, 119, 130, 118,
/* 10904 */ 137, 138, 136, 115, 138,  10, 123, 119,
/* 10912 */ 132, 132, 117, 130, 117, 132, 123, 138,
/* 10920 */   9, 123, 119, 132, 132, 117, 130, 117,
/* 10928 */ 132, 126,   7, 123, 119, 134, 136, 116,
/* 10936 */ 137, 137,   6, 124, 104, 122, 130, 118,
/* 10944 */ 123,   4, 124, 115, 119, 123,   7, 124,
/* 10952 */ 117, 118, 116, 137, 138, 136,   5, 125,
/* 10960 */ 115, 131, 119, 130,   5, 125, 117, 130,
/* 10968 */ 117, 122,   5, 125, 136, 115, 123, 138,
/* 10976 */   6, 125, 136, 115, 141, 117, 132,   7,
/* 10984 */ 126, 115, 119, 124, 116, 115, 131,   3,
/* 10992 */ 126, 115, 136,   3, 126, 120, 136,   5,
/* 11000 */ 126, 120, 136, 118, 122,   4, 126, 130,
/* 11008 */ 118, 131,   5, 127, 104, 130, 117, 122,
/* 11016 */   8, 127, 116, 134, 138, 115, 132, 123,
/* 11024 */ 127,   9, 127, 117, 134, 134, 118, 138,
/* 11032 */ 136, 115, 126,   6, 127, 120, 126, 136,
/* 11040 */ 118, 138,   3, 128, 115, 132,   7, 128,
/* 11048 */ 119, 132, 117, 134, 116, 136,   6, 130,
/* 11056 */ 115, 138, 127, 120, 136,   6, 130, 117,
/* 11064 */ 135, 119, 117, 124,   4, 130, 117, 138,
/* 11072 */ 119,   3, 130, 118, 123,   5, 130, 118,
/* 11080 */ 123, 119, 130,   6, 130, 118, 136, 115,
/* 11088 */ 132, 138,   3, 130, 120, 126,   9, 131,
/* 11096 */ 104, 130, 115, 132, 118, 123, 116, 138,
/* 11104 */  10, 131, 117, 123, 136, 118, 132, 119,
/* 11112 */ 123, 130, 104,   3, 131, 117, 136,   4,
/* 11120 */ 131, 118, 124, 117,   7, 131, 120, 141,
/* 11128 */ 118, 139, 117, 136,   9, 132, 115, 138,
/* 11136 */ 119, 136, 115, 130, 117, 122,   3, 132,
/* 11144 */ 118, 124,   5, 132, 119, 123, 130, 104,
/* 11152 */   5, 132, 119, 130, 130, 117,   3, 134,
/* 11160 */ 115, 132,   4, 134, 115, 132, 132,   8,
/* 11168 */ 134, 115, 136, 124, 115, 132, 138, 127,
/* 11176 */  12, 134, 115, 136, 138, 127, 104, 132,
/* 11184 */ 118, 123, 117, 137, 137,   3, 134, 116,
/* 11192 */ 123,   7, 134, 116, 131, 134, 127, 117,
/* 11200 */ 126,   9, 134, 116, 132, 138, 115, 123,
/* 11208 */ 136, 117, 132,   8, 134, 118, 130, 117,
/* 11216 */ 118, 139, 117, 136,   6, 134, 118, 132,
/* 11224 */ 123, 117, 136,   4, 134, 127, 104, 122,
/* 11232 */   4, 134, 127, 111, 122,   5, 134, 127,
/* 11240 */ 138, 117, 136,   6, 134, 127, 138, 117,
/* 11248 */ 136, 117,  11, 134, 130, 116, 119, 136,
/* 11256 */ 115, 123, 115, 132, 138, 127,   5, 134,
/* 11264 */ 130, 119, 138, 104,   8, 134, 136, 118,
/* 11272 */ 132, 119, 123, 130, 104,   5, 134, 136,
/* 11280 */ 118, 138, 116,   6, 134, 136, 118, 139,
/* 11288 */ 117, 136,   4, 135, 119, 117, 122,   6,
/* 11296 */ 136, 127, 117, 142, 118, 134,   5, 136,
/* 11304 */ 127, 118, 131, 122,   4, 137, 115, 130,
/* 11312 */ 138,   8, 137, 115, 136, 123, 115, 132,
/* 11320 */ 138, 127,   4, 137, 115, 136, 126,   4,
/* 11328 */ 137, 118, 123, 117,   5, 137, 118, 130,
/* 11336 */ 117, 124,   5, 137, 123, 127, 117, 132,
/* 11344 */   5, 137, 134, 130, 104, 132,   4, 137,
/* 11352 */ 138, 115, 138,   9, 137, 138, 116, 126,
/* 11360 */ 118, 137, 115, 119, 136,   6, 138, 115,
/* 11368 */ 130, 117, 138, 136,   4, 138, 119, 136,
/* 11376 */ 124,  10, 138, 136, 115, 132, 137, 130,
/* 11384 */ 119, 123, 117, 124,   6, 138, 136, 117,
/* 11392 */ 122, 119, 130,   7, 138, 136, 118, 123,
/* 11400 */ 127, 117, 130,   5, 141, 104, 132, 118,
/* 11408 */ 134,   4, 141, 115, 132, 123,   4, 142,
/* 11416 */ 104, 138, 127,   0,   1, 105,  10, 115,
/* 11424 */ 123, 138, 117, 132, 118, 134, 127, 136,
/* 11432 */ 120,   4, 115, 136, 126, 115,   3, 118,
/* 11440 */ 119, 136,   6, 122, 115, 132, 120, 119,
/* 11448 */ 130,   4, 122, 118, 118, 138,   8, 122,
/* 11456 */ 130, 118, 123, 129, 127, 115, 119,   3,
/* 11464 */ 123, 116, 132,   7, 123, 118, 119, 137,
/* 11472 */ 123, 118, 119,   5, 123, 118, 131, 117,
/* 11480 */ 123,   9, 123, 118, 132, 138, 136, 116,
/* 11488 */ 137, 116, 132,   4, 123, 130, 116, 122,
/* 11496 */   2, 130, 120,   3, 131, 115, 109,   4,
/* 11504 */ 131, 115, 118, 119,   5, 131, 115, 127,
/* 11512 */ 118, 119,   3, 131, 115, 136,   4, 136,
/* 11520 */ 116, 117, 131,   3, 137, 116, 132,   3,
/* 11528 */ 138, 118, 119,   0,   1, 115,   1, 116,
/* 11536 */   1, 118,   1, 120,   2, 120, 132,   2,
/* 11544 */ 130, 117,   2, 132, 117,   0,   2, 115,
/* 11552 */ 117,   6, 119, 130, 118, 138, 136, 117,
/* 11560 */   4, 123, 127, 115, 117,   8, 130, 115,
/* 11568 */ 126, 118, 138, 127, 136, 117,   4, 130,
/* 11576 */ 115, 136, 117,   2, 130, 119,   5, 134,
/* 11584 */ 136, 104, 125, 117,   5, 137, 115, 132,
/* 11592 */ 124, 117,   5, 137, 134, 127, 117, 132,
/* 11600 */  11, 137, 138, 136, 116, 134, 138, 118,
/* 11608 */ 138, 127, 136, 117,   4, 137, 138, 136,
/* 11616 */ 117,   0,   3, 115, 119, 138,   4, 115,
/* 11624 */ 124, 120, 138,   6, 115, 132, 115, 130,
/* 11632 */ 118, 126,   5, 116, 130, 116, 117, 137,
/* 11640 */   5, 116, 134, 137, 117, 130,   5, 118,
/* 11648 */ 131, 117, 123, 136,   6, 118, 137, 138,
/* 11656 */ 136, 115, 123,   6, 118, 137, 138, 136,
/* 11664 */ 115, 129,   5, 119, 134, 137, 117, 130,
/* 11672 */   3, 122, 115, 123,   8, 122, 115, 123,
/* 11680 */ 129, 126, 115, 131, 131,   7, 122, 115,
/* 11688 */ 124, 131, 117, 132, 138,   8, 122, 115,
/* 11696 */ 136, 115, 130, 117, 134, 138,   4, 122,
/* 11704 */ 118, 137, 138,   4, 123, 115, 132, 120,
/* 11712 */   8, 123, 127, 115, 136, 130, 116, 137,
/* 11720 */ 138,   8, 123, 127, 115, 138, 138, 116,
/* 11728 */ 136, 138,   6, 123, 130, 115, 123, 129,
/* 11736 */ 137,   4, 124, 115, 130, 138,   3, 124,
/* 11744 */ 116, 139,   6, 124, 118, 131, 117, 132,
/* 11752 */ 117,   5, 125, 115, 137, 127, 117,   9,
/* 11760 */ 127, 115, 122, 136, 118, 122, 136, 115,
/* 11768 */ 123,   6, 127, 117, 131, 115, 138, 117,
/* 11776 */   4, 129, 130, 115, 141,   6, 131, 118,
/* 11784 */ 119, 137, 116, 117,   4, 132, 116, 123,
/* 11792 */ 138,   4, 132, 116, 140, 138,   7, 134,
/* 11800 */ 115, 136, 129, 117, 132, 137,   3, 136,
/* 11808 */ 115, 123,   4, 136, 127, 120, 138,   6,
/* 11816 */ 137, 129, 116, 130, 116, 138,   5, 137,
/* 11824 */ 138, 116, 138, 137,   5, 137, 138, 117,
/* 11832 */ 130, 138,   4, 138, 118, 119, 136,   6,
/* 11840 */ 138, 136, 119, 124, 126, 116,   1, 140,
/* 11848 */   7, 140, 116, 137, 137, 116, 130, 138,
/* 11856 */   0,   2, 101, 138,   5, 115, 130, 124,
/* 11864 */ 116, 136,   3, 115, 138, 127,   1, 117,
/* 11872 */   6, 118, 131, 122, 119, 124, 137,   5,
/* 11880 */ 120, 115, 123, 127, 138,   6, 120, 115,
/* 11888 */ 123, 127, 138, 137,   3, 120, 116, 118,
/* 11896 */   3, 122, 115, 136,   5, 122, 118, 137,
/* 11904 */ 137, 116,   8, 122, 119, 137, 117, 132,
/* 11912 */ 116, 137, 137,   5, 122, 130, 119, 116,
/* 11920 */ 137,   4, 122, 136, 115, 127,   5, 123,
/* 11928 */ 115, 122, 130, 116,   6, 123, 115, 131,
/* 11936 */ 104, 136, 115,   6, 123, 115, 131, 116,
/* 11944 */ 136, 115,   3, 123, 127, 115,   6, 123,
/* 11952 */ 130, 116, 136, 126, 120,   4, 123, 130,
/* 11960 */ 119, 122,   5, 123, 136, 118, 137, 137,
/* 11968 */   5, 124, 118, 122, 116, 136,   3, 126,
/* 11976 */ 115, 126,   6, 126, 116, 132, 138, 130,
/* 11984 */ 116,   3, 127, 116, 138,   4, 128, 115,
/* 11992 */ 142, 142,   3, 129, 115, 136,   7, 131,
/* 12000 */ 117, 124, 137, 127, 117, 134,   5, 134,
/* 12008 */ 116, 136, 123, 127,   6, 134, 118, 130,
/* 12016 */ 117, 123, 116,   4, 134, 119, 130, 130,
/* 12024 */   6, 136, 115, 123, 117, 132, 126,   6,
/* 12032 */ 136, 115, 130, 130, 120, 116,   6, 136,
/* 12040 */ 116, 123, 118, 136, 124,   8, 136, 116,
/* 12048 */ 123, 118, 136, 124, 140, 118,   5, 136,
/* 12056 */ 119, 126, 122, 120,   5, 137, 119, 134,
/* 12064 */ 116, 136,   3, 137, 127, 115,   5, 137,
/* 12072 */ 134, 118, 136, 138,   6, 137, 134, 118,
/* 12080 */ 136, 138, 137,   8, 137, 134, 118, 136,
/* 12088 */ 138, 137, 140, 118,   7, 137, 134, 118,
/* 12096 */ 136, 138, 140, 118,   4, 138, 115, 141,
/* 12104 */ 117,   6, 138, 116, 132, 132, 117, 137,
/* 12112 */   4, 140, 115, 130, 129,   5, 140, 115,
/* 12120 */ 138, 123, 127,   4, 140, 115, 138, 138,
/* 12128 */   0,   1, 125,   6, 127, 118, 118, 130,
/* 12136 */ 117, 126,   6, 127, 118, 119, 130, 117,
/* 12144 */ 126,   6, 128, 116, 136, 136, 117, 123,
/* 12152 */   6, 128, 116, 136, 136, 120, 123,   2,
/* 12160 */ 129, 118,   1, 131,   7, 131, 115, 132,
/* 12168 */ 127, 115, 138, 138,   5, 134, 136, 118,
/* 12176 */ 134, 125,   4, 136, 117, 118, 129,   5,
/* 12184 */ 137, 134, 118, 136, 136,   6, 138, 123,
/* 12192 */ 127, 116, 136, 129,   0,   2, 115, 131,
/* 12200 */   1, 120,   5, 123, 127, 115, 131, 137,
/* 12208 */   4, 124, 115, 137, 116,   5, 124, 136,
/* 12216 */ 119, 131, 130,   5, 125, 116, 124, 115,
/* 12224 */ 120,   6, 125, 116, 124, 124, 115, 120,
/* 12232 */   1, 126,   8, 127, 116, 132, 124, 117,
/* 12240 */ 115, 124, 120,   8, 127, 116, 132, 124,
/* 12248 */ 120, 115, 124, 120,   4, 129, 115, 131,
/* 12256 */ 137,   4, 129, 116, 130, 139,   5, 129,
/* 12264 */ 127, 115, 131, 137,  10, 131, 118, 119,
/* 12272 */ 124, 128, 115, 127, 117, 124, 124,   6,
/* 12280 */ 131, 118, 126, 136, 118, 122,   5, 131,
/* 12288 */ 119, 116, 142, 142,   4, 131, 119, 125,
/* 12296 */ 125,   4, 134, 117, 124, 126,   4, 134,
/* 12304 */ 117, 132, 120,   2, 136, 110,   3, 136,
/* 12312 */ 118, 132,   7, 137, 115, 132, 132, 120,
/* 12320 */ 101, 137,   7, 137, 115, 132, 132, 120,
/* 12328 */ 115, 137,   6, 137, 116, 115, 130, 137,
/* 12336 */ 129,   2, 137, 134,   3, 138, 123, 127,
/* 12344 */   2, 138, 140,   0,   3, 116, 137, 138,
/* 12352 */   1, 120,   4, 122, 118, 138, 138,   4,
/* 12360 */ 123, 118, 132, 124,   4, 123, 119, 137,
/* 12368 */ 138,   1, 124,   4, 125, 115, 138, 127,
/* 12376 */   1, 127,   7, 131, 115, 116, 130, 137,
/* 12384 */ 138, 136,   6, 131, 115, 130, 137, 138,
/* 12392 */ 136,   4, 134, 118, 126, 136,   1, 136,
/* 12400 */   4, 137, 127, 117, 130,   4, 137, 130,
/* 12408 */ 115, 130,   1, 138,   9, 138, 123, 127,
/* 12416 */ 116, 136, 132, 118, 142, 117,   0,   3,
/* 12424 */ 104, 123, 118,   4, 104, 123, 127, 118,
/* 12432 */   7, 104, 130, 116, 123, 138, 136, 118,
/* 12440 */   4, 104, 135, 119, 117,   1, 115,   4,
/* 12448 */ 115, 104, 136, 118,   4, 115, 119, 138,
/* 12456 */ 118,   5, 115, 122, 118, 131, 115,   4,
/* 12464 */ 115, 122, 122, 115,   4, 115, 124, 124,
/* 12472 */ 117,   4, 115, 130, 131, 115,   4, 115,
/* 12480 */ 131, 122, 117,   4, 115, 132, 138, 117,
/* 12488 */   5, 115, 136, 123, 127, 117,   5, 115,
/* 12496 */ 136, 123, 127, 118,   3, 115, 141, 117,
/* 12504 */   4, 116, 119, 136, 118,   5, 116, 132,
/* 12512 */ 138, 136, 116,   5, 116, 141, 138, 136,
/* 12520 */ 115,   6, 117, 123, 127, 138, 120, 118,
/* 12528 */   4, 117, 124, 117, 118,   6, 117, 131,
/* 12536 */ 131, 119, 132, 118,   6, 117, 131, 134,
/* 12544 */ 115, 136, 117,   5, 117, 132, 125, 136,
/* 12552 */ 115,   6, 117, 132, 139, 136, 115, 117,
/* 12560 */   3, 117, 137, 118,   4, 118, 123, 138,
/* 12568 */ 118,   5, 118, 130, 117, 126, 118,   6,
/* 12576 */ 118, 136, 126, 115, 132, 118,   5, 118,
/* 12584 */ 136, 138, 127, 118,   5, 118, 137, 138,
/* 12592 */ 104, 118,   3, 118, 141, 120,   5, 119,
/* 12600 */ 130, 138, 136, 115,   3, 119, 132, 117,
/* 12608 */   2, 122, 117,   3, 122, 117, 118,   5,
/* 12616 */ 122, 118, 124, 127, 117,   4, 122, 118,
/* 12624 */ 136, 118,   5, 123, 115, 130, 123, 118,
/* 12632 */   5, 123, 115, 131, 134, 118,   4, 123,
/* 12640 */ 115, 134, 104,   6, 123, 115, 136, 136,
/* 12648 */ 118, 119,   2, 123, 118,   6, 123, 118,
/* 12656 */ 132, 138, 136, 116,   7, 123, 118, 136,
/* 12664 */ 138, 117, 123, 118,   6, 123, 118, 138,
/* 12672 */ 120, 130, 118,   6, 123, 127, 117, 131,
/* 12680 */ 117, 118,   4, 123, 136, 120, 118,   4,
/* 12688 */ 124, 104, 123, 115,   4, 124, 117, 132,
/* 12696 */ 118,   6, 124, 118, 124, 104, 123, 115,
/* 12704 */   4, 125, 130, 119, 118,   3, 126, 104,
/* 12712 */ 118,   4, 126, 115, 131, 118,   4, 126,
/* 12720 */ 117, 136, 115,   5, 126, 120, 131, 132,
/* 12728 */ 118,   4, 127, 104, 130, 117,   5, 127,
/* 12736 */ 104, 130, 117, 118,   4, 127, 104, 131,
/* 12744 */ 118,   6, 127, 104, 136, 104, 124, 118,
/* 12752 */   6, 127, 104, 138, 104, 136, 118,   4,
/* 12760 */ 127, 115, 130, 118,   5, 127, 115, 139,
/* 12768 */ 136, 116,   5, 127, 116, 134, 138, 115,
/* 12776 */   5, 127, 117, 104, 136, 118,   4, 127,
/* 12784 */ 118, 131, 118,   5, 127, 120, 124, 136,
/* 12792 */ 118,   5, 127, 120, 134, 116, 136,   4,
/* 12800 */ 127, 120, 134, 118,   5, 128, 115, 119,
/* 12808 */ 136, 104,   5, 128, 115, 119, 136, 105,
/* 12816 */   6, 130, 104, 134, 117, 124, 118,   5,
/* 12824 */ 130, 115, 123, 138, 118,   4, 130, 117,
/* 12832 */ 134, 118,   5, 130, 117, 138, 127, 118,
/* 12840 */   4, 130, 118, 136, 117,   4, 131, 104,
/* 12848 */ 132, 117,   4, 131, 104, 138, 115,   6,
/* 12856 */ 131, 115, 119, 136, 136, 115,   5, 131,
/* 12864 */ 115, 123, 136, 118,   5, 131, 116, 132,
/* 12872 */ 124, 104,   5, 131, 117, 123, 136, 118,
/* 12880 */   4, 131, 118, 132, 118,   6, 131, 118,
/* 12888 */ 136, 134, 127, 118,   5, 131, 119, 130,
/* 12896 */ 138, 117,   5, 132, 115, 136, 123, 118,
/* 12904 */   5, 132, 116, 119, 136, 118,   6, 132,
/* 12912 */ 119, 123, 130, 104, 118,   4, 134, 104,
/* 12920 */ 136, 117,   5, 134, 104, 138, 136, 118,
/* 12928 */   4, 134, 105, 138, 116,   5, 134, 115,
/* 12936 */ 130, 104, 118,   5, 134, 115, 130, 131,
/* 12944 */ 117,   4, 134, 115, 136, 115,   5, 134,
/* 12952 */ 116, 130, 139, 117,   6, 134, 116, 136,
/* 12960 */ 118, 141, 120,   7, 134, 116, 136, 126,
/* 12968 */ 104, 130, 117,   4, 134, 118, 130, 120,
/* 12976 */   4, 134, 120, 136, 118,   7, 134, 127,
/* 12984 */ 118, 137, 134, 127, 118,   5, 134, 127,
/* 12992 */ 118, 138, 118,   5, 134, 127, 120, 137,
/* 13000 */ 117,   5, 134, 127, 120, 138, 118,   6,
/* 13008 */ 134, 130, 115, 137, 138, 117,   3, 134,
/* 13016 */ 136, 104,   5, 134, 136, 117, 131, 116,
/* 13024 */   3, 134, 136, 118,   6, 134, 136, 118,
/* 13032 */ 138, 104, 118,   6, 134, 137, 120, 123,
/* 13040 */ 127, 118,   5, 134, 138, 104, 136, 118,
/* 13048 */   5, 135, 119, 115, 137, 117,   4, 136,
/* 13056 */ 104, 126, 118,   5, 136, 115, 124, 117,
/* 13064 */ 118,   2, 136, 116,   5, 136, 116, 123,
/* 13072 */ 138, 118,   4, 137, 104, 136, 118,   6,
/* 13080 */ 137, 118, 119, 122, 136, 116,   5, 137,
/* 13088 */ 119, 130, 125, 118,   5, 137, 119, 134,
/* 13096 */ 116, 136,   5, 137, 119, 134, 136, 115,
/* 13104 */   5, 137, 138, 104, 126, 118,   5, 137,
/* 13112 */ 138, 116, 126, 118,   4, 138, 104, 130,
/* 13120 */ 104,   5, 138, 104, 130, 104, 118,   4,
/* 13128 */ 138, 104, 132, 118,   5, 138, 104, 138,
/* 13136 */ 136, 115,   5, 138, 115, 123, 127, 120,
/* 13144 */   6, 138, 118, 119, 136, 132, 116,   4,
/* 13152 */ 138, 118, 134, 118,   5, 138, 119, 136,
/* 13160 */ 122, 118,   6, 138, 127, 116, 136, 131,
/* 13168 */ 118,   4, 138, 127, 117, 118,   3, 138,
/* 13176 */ 136, 117,   4, 139, 117, 139, 117,   4,
/* 13184 */ 139, 136, 115, 117,   3, 142, 118, 118,
/* 13192 */   0,   8, 115, 123, 123, 127, 115, 136,
/* 13200 */ 117, 124,   5, 115, 136, 123, 118, 131,
/* 13208 */   5, 116, 132, 137, 117, 122,   2, 116,
/* 13216 */ 141,   6, 117, 130, 117, 123, 115, 138,
/* 13224 */   3, 118, 130,  91,   4, 118, 130, 137,
/* 13232 */  91,   3, 119, 130, 125,   5, 120, 130,
/* 13240 */ 130, 115, 122,   4, 120, 132, 138, 127,
/* 13248 */   0,   1,  91,   2, 116,  91,   3, 116,
/* 13256 */ 137,  91,   4, 131, 116, 137,  91,   5,
/* 13264 */ 136, 116, 132, 138,  91,   2, 137,  91,
/* 13272 */   2, 137, 137,   2, 138,  91,   4, 138,
/* 13280 */ 116, 137,  91,   0,   3, 104, 123, 130,
/* 13288 */   2, 104, 134,   6, 115, 123, 123, 130,
/* 13296 */ 117, 131,   5, 115, 132, 138, 117, 124,
/* 13304 */   4, 123, 115, 130, 125,   5, 123, 115,
/* 13312 */ 136, 115, 134,   5, 123, 115, 137, 116,
/* 13320 */ 131,   4, 123, 118, 130, 131,   5, 123,
/* 13328 */ 118, 132, 137, 138,   6, 123, 136, 115,
/* 13336 */ 139, 115, 138,   1, 124,   3, 124, 104,
/* 13344 */ 136,   3, 124, 117, 130,   4, 125, 136,
/* 13352 */ 116, 130,   1, 131,   4, 131, 115, 132,
/* 13360 */ 124,   3, 134, 117, 136,   5, 134, 118,
/* 13368 */ 137, 138, 124,   1, 136,   4, 137, 119,
/* 13376 */ 130, 125,   0,   6, 104, 122, 136, 119,
/* 13384 */ 117, 138,   2, 104, 139,   3, 115, 122,
/* 13392 */ 136,   6, 115, 123, 123, 136, 104, 124,
/* 13400 */   2, 115, 126,   3, 116, 141, 123,   6,
/* 13408 */ 116, 141, 134, 130, 117, 123,   5, 116,
/* 13416 */ 141, 134, 130, 118,   2, 117, 131,   6,
/* 13424 */ 117, 132, 126, 119, 136, 126,   3, 117,
/* 13432 */ 132, 139,   3, 117, 136, 136,   2, 122,
/* 13440 */ 118,   1, 123,   5, 123, 117, 136, 123,
/* 13448 */ 119,   5, 123, 118, 127, 115, 122,   7,
/* 13456 */ 123, 118, 131, 131, 115, 132, 124,   5,
/* 13464 */ 123, 118, 132, 139, 118,   4, 123, 136,
/* 13472 */ 104, 124,   3, 124, 104, 122,   5, 124,
/* 13480 */ 104, 123, 115, 134,   5, 124, 104, 130,
/* 13488 */ 117, 131,   5, 124, 104, 131, 104, 136,
/* 13496 */   3, 124, 104, 134,   6, 124, 104, 137,
/* 13504 */ 127, 104, 136,   5, 125, 104, 130, 117,
/* 13512 */ 123,   5, 125, 115, 123, 117, 130,   4,
/* 13520 */ 126, 136, 115, 139,   3, 127, 104, 136,
/* 13528 */   3, 127, 104, 137,   3, 127, 115, 122,
/* 13536 */   5, 127, 115, 122, 117, 130,   3, 130,
/* 13544 */ 117, 131,   3, 131, 104, 124,   3, 131,
/* 13552 */ 104, 136,   3, 131, 117, 130,   6, 132,
/* 13560 */ 104, 123, 116, 137, 137,   6, 134, 104,
/* 13568 */ 136, 117, 123, 130,   4, 134, 115, 130,
/* 13576 */ 134,   5, 134, 115, 136, 115, 137,   6,
/* 13584 */ 134, 136, 104, 123, 117, 134,   6, 134,
/* 13592 */ 136, 104, 131, 104, 124,   4, 134, 136,
/* 13600 */ 118, 125,   3, 136, 104, 123,   6, 136,
/* 13608 */ 104, 126, 119, 136, 126,   7, 136, 104,
/* 13616 */ 127, 115, 122, 117, 130,   7, 136, 116,
/* 13624 */ 137, 137, 119, 137, 123,   6, 137, 118,
/* 13632 */ 130, 130, 117, 123,   4, 137, 119, 137,
/* 13640 */ 123,   3, 139, 117, 137,   0,   3, 115,
/* 13648 */ 126, 117,   3, 115, 132, 132,   3, 116,
/* 13656 */ 136, 126,   5, 116, 137, 123, 115, 131,
/* 13664 */   7, 122, 118, 119, 136, 137, 117, 123,
/* 13672 */   1, 123,   5, 123, 118, 131, 134, 130,
/* 13680 */   5, 123, 127, 119, 123, 127,   1, 124,
/* 13688 */   4, 124, 118, 136, 130,   5, 126, 136,
/* 13696 */ 117, 126, 132,   3, 130, 117, 126,   5,
/* 13704 */ 132, 119, 131, 104, 136,   4, 134, 117,
/* 13712 */ 115, 132,   3, 134, 117, 130,   3, 134,
/* 13720 */ 117, 139,   3, 136, 115, 122,   3, 137,
/* 13728 */ 115, 122,   5, 137, 115, 132, 126, 130,
/* 13736 */   3, 138, 115, 134,   4, 138, 136, 117,
/* 13744 */ 123,   1, 139,   3, 139, 117, 139,   0,
/* 13752 */   3, 104, 123, 118,   3, 115, 128, 118,
/* 13760 */   3, 115, 131, 116,   3, 115, 131, 134,
/* 13768 */   3, 117, 131, 134,   1, 122,   3, 122,
/* 13776 */ 136, 118,   4, 123, 119, 130, 122,   2,
/* 13784 */ 123, 127,   5, 123, 127, 115, 136, 123,
/* 13792 */   4, 124, 104, 122, 118,   3, 124, 104,
/* 13800 */ 134,   4, 124, 104, 136, 118,   4, 124,
/* 13808 */ 117, 137, 123,   4, 124, 117, 137, 134,
/* 13816 */   2, 124, 118,   1, 131,   3, 131, 117,
/* 13824 */ 132,   4, 132, 118, 120, 115,   6, 134,
/* 13832 */ 115, 136, 115, 123, 127,   4, 134, 116,
/* 13840 */ 136, 131,   3, 136, 104, 125,   6, 136,
/* 13848 */ 104, 134, 116, 136, 123,   4, 136, 115,
/* 13856 */ 128, 118,   4, 136, 115, 131, 116,   3,
/* 13864 */ 136, 116, 122,   4, 136, 116, 123, 127,
/* 13872 */   4, 136, 116, 123, 136,   4, 136, 116,
/* 13880 */ 124, 118,   2, 136, 118,   2, 137, 115,
/* 13888 */   4, 137, 119, 134, 134,   5, 137, 119,
/* 13896 */ 136, 137, 115,   3, 137, 123, 136,   0,
/* 13904 */   6, 104, 134, 118, 119, 139, 115,   4,
/* 13912 */ 104, 136, 116, 117,   5, 115, 119, 126,
/* 13920 */ 131, 116,   5, 115, 125, 125, 136, 118,
/* 13928 */   6, 115, 126, 136, 104, 131, 116,   5,
/* 13936 */ 115, 130, 117, 131, 116,   6, 115, 134,
/* 13944 */ 134, 115, 136, 116,   5, 115, 134, 134,
/* 13952 */ 118, 117,   6, 115, 136, 126, 119, 131,
/* 13960 */ 116,   4, 115, 136, 134, 116,   5, 116,
/* 13968 */ 131, 134, 136, 119,   5, 116, 132, 123,
/* 13976 */ 127, 115,   8, 116, 132, 136, 116, 126,
/* 13984 */ 117, 131, 116,   8, 116, 141, 134, 104,
/* 13992 */ 136, 117, 131, 116,   5, 117, 131, 134,
/* 14000 */ 130, 115,   6, 117, 132, 132, 118, 123,
/* 14008 */ 116,   4, 118, 136, 117, 116,   4, 123,
/* 14016 */ 117, 131, 116,   5, 123, 118, 131, 131,
/* 14024 */ 116,  10, 123, 118, 131, 134, 115, 136,
/* 14032 */ 138, 117, 131, 116,   8, 123, 118, 131,
/* 14040 */ 134, 130, 117, 131, 116,   6, 123, 118,
/* 14048 */ 132, 125, 136, 118,   5, 123, 118, 132,
/* 14056 */ 137, 116,   5, 123, 118, 132, 138, 116,
/* 14064 */   8, 123, 118, 132, 138, 117, 132, 126,
/* 14072 */ 116,   3, 123, 127, 115,   4, 124, 104,
/* 14080 */ 123, 115,   5, 124, 104, 123, 127, 115,
/* 14088 */   4, 124, 104, 131, 116,   4, 124, 104,
/* 14096 */ 131, 118,   7, 124, 104, 137, 118, 136,
/* 14104 */ 117, 116,   6, 124, 118, 123, 119, 131,
/* 14112 */ 116,   4, 125, 118, 131, 116,   6, 125,
/* 14120 */ 136, 104, 135, 119, 116,   6, 125, 136,
/* 14128 */ 115, 126, 131, 116,   2, 127, 115,   4,
/* 14136 */ 130, 115, 131, 116,   7, 131, 104, 123,
/* 14144 */ 118, 132, 138, 116,   2, 131, 118,   7,
/* 14152 */ 134, 115, 136, 130, 116, 131, 116,   5,
/* 14160 */ 134, 115, 138, 117, 116,   3, 134, 118,
/* 14168 */ 117,   3, 134, 130, 115,   6, 134, 130,
/* 14176 */ 115, 117, 137, 115,   5, 134, 136, 104,
/* 14184 */ 137, 116,   6, 134, 136, 116, 137, 137,
/* 14192 */ 116,   7, 136, 104, 116, 131, 134, 136,
/* 14200 */ 119,   7, 136, 104, 117, 131, 134, 130,
/* 14208 */ 115,   6, 136, 104, 117, 132, 139, 116,
/* 14216 */   6, 136, 104, 118, 136, 117, 116,   4,
/* 14224 */ 136, 104, 126, 116,   7, 136, 104, 126,
/* 14232 */ 130, 116, 131, 116,   4, 136, 115, 123,
/* 14240 */ 118,   4, 136, 116, 131, 118,   4, 136,
/* 14248 */ 116, 134, 116,   5, 136, 116, 134, 130,
/* 14256 */ 115,   7, 136, 116, 134, 136, 104, 137,
/* 14264 */ 116,   5, 136, 116, 137, 137, 116,   2,
/* 14272 */ 137, 116,   5, 137, 116, 126, 131, 116,
/* 14280 */   6, 137, 119, 134, 134, 130, 115,   8,
/* 14288 */ 137, 119, 136, 115, 130, 117, 131, 116,
/* 14296 */   5, 137, 119, 136, 131, 118,   4, 137,
/* 14304 */ 134, 136, 117,   2, 138, 116,   3, 138,
/* 14312 */ 116, 117,   6, 138, 118, 119, 136, 131,
/* 14320 */ 116,   8, 138, 136, 115, 132, 137, 134,
/* 14328 */ 130, 115,   2, 139, 115,   0,   3, 104,
/* 14336 */ 124, 117,   5, 123, 118, 132, 132, 116,
/* 14344 */   5, 123, 118, 132, 138, 115,   4, 127,
/* 14352 */ 119, 131, 116,   5, 136, 104, 138, 136,
/* 14360 */ 115,   5, 136, 116, 137, 134, 116,   5,
/* 14368 */ 137, 119, 137, 134, 116,   0,   3, 115,
/* 14376 */ 124, 115,   5, 116, 137, 123, 118, 131,
/* 14384 */   2, 123, 115,   3, 123, 118, 118,   3,
/* 14392 */ 123, 118, 131,   5, 124, 104, 123, 118,
/* 14400 */ 131,   3, 124, 118, 131,   5, 136, 104,
/* 14408 */ 115, 124, 115,   7, 136, 104, 116, 137,
/* 14416 */ 123, 118, 131,   5, 136, 116, 123, 118,
/* 14424 */ 131,   4, 137, 123, 119, 130,   0,   1,
/* 14432 */ 104,   5, 104, 122, 136, 119, 117,   4,
/* 14440 */ 104, 123, 115, 136,   5, 104, 123, 118,
/* 14448 */ 119, 136,   5, 115, 125, 125, 136, 104,
/* 14456 */   4, 115, 130, 116, 136,   5, 115, 134,
/* 14464 */ 134, 118, 136,   4, 115, 139, 118, 136,
/* 14472 */   5, 116, 131, 134, 117, 104,   5, 116,
/* 14480 */ 131, 134, 118, 136,   5, 116, 132, 123,
/* 14488 */ 115, 136,   5, 116, 137, 123, 118, 136,
/* 14496 */   5, 116, 141, 127, 118, 136,   5, 116,
/* 14504 */ 141, 134, 118, 136,   5, 117, 131, 134,
/* 14512 */ 118, 136,   6, 117, 132, 135, 119, 117,
/* 14520 */ 104,   6, 123, 118, 130, 134, 118, 136,
/* 14528 */   6, 123, 118, 131, 134, 118, 136,   6,
/* 14536 */ 123, 118, 131, 134, 130, 104,   6, 123,
/* 14544 */ 118, 132, 123, 116, 136,   6, 123, 118,
/* 14552 */ 132, 125, 118, 136,   5, 124, 104, 122,
/* 14560 */ 118, 117,   8, 124, 104, 123, 118, 132,
/* 14568 */ 123, 116, 136,   5, 124, 104, 123, 136,
/* 14576 */ 104,   5, 124, 104, 130, 116, 123,   5,
/* 14584 */ 124, 104, 134, 118, 136,   3, 125, 136,
/* 14592 */ 104,   4, 127, 116, 119, 136,   3, 134,
/* 14600 */ 115, 136,   7, 136, 104, 116, 141, 134,
/* 14608 */ 118, 136,   7, 136, 104, 117, 131, 134,
/* 14616 */ 118, 136,   8, 136, 104, 123, 118, 132,
/* 14624 */ 125, 118, 136,   4, 136, 104, 134, 104,
/* 14632 */   6, 136, 115, 134, 134, 118, 136,   6,
/* 14640 */ 136, 116, 131, 134, 118, 136,   5, 136,
/* 14648 */ 116, 134, 115, 136,   5, 136, 116, 134,
/* 14656 */ 118, 136,   6, 136, 116, 137, 137, 118,
/* 14664 */ 136,   3, 137, 118, 136,   6, 137, 119,
/* 14672 */ 134, 134, 118, 136,   4, 139, 104, 126,
/* 14680 */ 104,   0,   3, 115, 132, 115,   7, 115,
/* 14688 */ 137, 138, 104, 136, 104, 118,   6, 117,
/* 14696 */ 132, 116, 141, 134, 119,   5, 119, 136,
/* 14704 */ 118, 130, 115,   5, 134, 115, 138, 127,
/* 14712 */ 118,   2, 134, 119,   8, 134, 127, 115,
/* 14720 */ 136, 131, 115, 123, 118,   6, 134, 127,
/* 14728 */ 120, 137, 117, 118,   6, 134, 130, 116,
/* 14736 */ 123, 138, 118,   3, 134, 136, 104,   3,
/* 14744 */ 134, 136, 118,   3, 137, 120, 132,   4,
/* 14752 */ 137, 134, 127, 115,   6, 137, 138, 104,
/* 14760 */ 136, 104, 118,   3, 137, 138, 115,   0,
/* 14768 */   3, 111, 132, 118,   6, 115, 123, 104,
/* 14776 */ 138, 120, 130,   4, 115, 130, 130, 118,
/* 14784 */   5, 115, 132, 104, 131, 118,   3, 115,
/* 14792 */ 132, 115,   4, 115, 132, 118, 136,   5,
/* 14800 */ 115, 132, 126, 117, 118,   4, 115, 138,
/* 14808 */ 116, 119,   4, 115, 138, 136, 117,   2,
/* 14816 */ 116, 119,   4, 116, 119, 132, 119,   4,
/* 14824 */ 116, 119, 136, 120,   4, 116, 141, 115,
/* 14832 */ 136,   1, 117,   2, 117, 137,   3, 117,
/* 14840 */ 137, 118,   4, 118, 116, 132, 118,   5,
/* 14848 */ 118, 130, 117, 126, 118,   3, 118, 132,
/* 14856 */ 120,   2, 118, 136,   3, 118, 136, 117,
/* 14864 */   7, 118, 141, 120, 136, 127, 120, 132,
/* 14872 */   3, 119, 136, 118,   3, 122, 136, 115,
/* 14880 */   3, 123, 117, 132,   3, 123, 118, 132,
/* 14888 */   7, 123, 136, 120, 134, 138, 118, 136,
/* 14896 */   2, 124, 117,   3, 124, 117, 115,   4,
/* 14904 */ 124, 118, 130, 117,   4, 126, 118, 132,
/* 14912 */ 118,   3, 126, 130, 104,   4, 127, 115,
/* 14920 */ 130, 117,   4, 127, 116, 124, 120,   6,
/* 14928 */ 127, 116, 134, 138, 115, 132,   5, 127,
/* 14936 */ 120, 124, 136, 118,   4, 127, 120, 134,
/* 14944 */ 118,   7, 130, 116, 119, 123, 118, 132,
/* 14952 */ 120,   8, 130, 116, 119, 123, 118, 138,
/* 14960 */ 136, 117,   8, 131, 104, 138, 116, 131,
/* 14968 */ 134, 137, 120,   4, 131, 115, 130, 115,
/* 14976 */   4, 131, 115, 132, 117,   3, 131, 116,
/* 14984 */ 130,   4, 131, 117, 138, 118,   4, 131,
/* 14992 */ 118, 132, 115,   5, 131, 118, 132, 118,
/* 15000 */ 136,   9, 131, 118, 136, 134, 127, 118,
/* 15008 */ 134, 137, 120,   4, 131, 119, 132, 117,
/* 15016 */   4, 132, 115, 122, 119,   4, 132, 118,
/* 15024 */ 138, 118,   4, 134, 104, 136, 117,   7,
/* 15032 */ 134, 115, 130, 104, 118, 115, 136,   4,
/* 15040 */ 134, 115, 136, 118,   4, 134, 118, 130,
/* 15048 */ 120,   7, 134, 118, 130, 120, 118, 132,
/* 15056 */ 120,   6, 134, 118, 130, 120, 118, 136,
/* 15064 */   5, 134, 136, 118, 138, 118,   4, 136,
/* 15072 */ 104, 118, 136,   4, 136, 127, 120, 132,
/* 15080 */   3, 137, 120, 132,   5, 137, 134, 117,
/* 15088 */ 136, 118,   8, 137, 134, 118, 136, 118,
/* 15096 */ 138, 136, 117,   3, 137, 138, 111,   3,
/* 15104 */ 137, 138, 115,   3, 137, 138, 117,   3,
/* 15112 */ 137, 138, 118,   4, 137, 138, 118, 116,
/* 15120 */   5, 138, 115, 119, 136, 118,   4, 138,
/* 15128 */ 115, 136, 117,   5, 138, 120, 130, 116,
/* 15136 */ 132,   0,  10, 104, 130, 116, 123, 138,
/* 15144 */ 136, 118, 123, 115, 134,   5, 115, 122,
/* 15152 */ 122, 116, 139,   3, 115, 123, 127,   3,
/* 15160 */ 115, 132, 123,   6, 115, 136, 123, 127,
/* 15168 */ 117, 131,   3, 115, 136, 131,   2, 115,
/* 15176 */ 141,   6, 117, 132, 137, 116, 123, 138,
/* 15184 */   4, 117, 132, 137, 138,   8, 117, 132,
/* 15192 */ 138, 116, 136, 131, 115, 141,   3, 118,
/* 15200 */ 137, 123,   3, 122, 117, 131,   4, 123,
/* 15208 */ 115, 130, 139,   3, 123, 115, 134,   6,
/* 15216 */ 123, 115, 138, 116, 136, 134,   3, 123,
/* 15224 */ 120, 136,   3, 124, 104, 137,   4, 125,
/* 15232 */ 136, 117, 138,   1, 130,   3, 130, 115,
/* 15240 */ 134,   1, 131,   3, 131, 115, 131,   3,
/* 15248 */ 131, 115, 141,   6, 131, 117, 123, 136,
/* 15256 */ 118, 131,   6, 131, 117, 123, 136, 118,
/* 15264 */ 139,   6, 131, 119, 130, 138, 117, 131,
/* 15272 */   9, 132, 116, 119, 136, 118, 125, 117,
/* 15280 */ 122, 136,   3, 134, 119, 134,   3, 134,
/* 15288 */ 119, 137,   2, 137, 123,   3, 137, 123,
/* 15296 */ 127,   2, 137, 127,   2, 137, 138,   4,
/* 15304 */ 138, 104, 134, 127,   4, 138, 116, 134,
/* 15312 */ 127,   5, 138, 127, 104, 134, 127,   3,
/* 15320 */ 138, 127, 136,   1, 139,   3, 139, 116,
/* 15328 */ 141,   1, 140,   0,   2,  91, 126,   2,
/* 15336 */ 104, 123,   4, 115, 117, 132, 139,   4,
/* 15344 */ 115, 132, 135, 119,   6, 115, 137, 134,
/* 15352 */ 116, 136, 126,   2, 117, 123,   4, 117,
/* 15360 */ 132, 123, 127,   3, 117, 137, 138,   3,
/* 15368 */ 118, 132, 139,   3, 122, 115, 123,   3,
/* 15376 */ 124, 116, 139,   3, 136, 116, 139,   3,
/* 15384 */ 142, 115, 139,   0,   5,  91, 134, 136,
/* 15392 */ 118, 131,   2, 122, 115,   3, 123, 118,
/* 15400 */ 131,   3, 124, 118, 131,   4, 137, 123,
/* 15408 */ 119, 130,   3, 141, 116, 131,   0,   1,
/* 15416 */ 104,   3, 104, 131, 115,   2, 116, 134,
/* 15424 */   1, 117,   2, 117, 118,   3, 117, 131,
/* 15432 */ 115,   3, 117, 132, 117,   3, 118, 122,
/* 15440 */ 115,   3, 119, 136, 115,   4, 119, 136,
/* 15448 */ 116, 132,   2, 122, 119,   2, 122, 120,
/* 15456 */   3, 123, 136, 115,   3, 124, 115, 123,
/* 15464 */   2, 126, 119,   3, 132, 116, 136,   2,
/* 15472 */ 132, 119,   5, 134, 130, 118, 131, 115,
/* 15480 */   0,   4, 104, 126, 120, 134,   3, 115,
/* 15488 */ 118, 113,   5, 115, 123, 117, 132, 104,
/* 15496 */   5, 115, 130, 104, 118, 119,   4, 117,
/* 15504 */ 126, 132, 115,   3, 122, 104, 118,   4,
/* 15512 */ 123, 115, 134, 104,   5, 124, 115, 130,
/* 15520 */ 131, 115,   3, 126, 136, 115,   3, 127,
/* 15528 */ 115, 109,   5, 127, 116, 130, 139, 104,
/* 15536 */   5, 127, 116, 136, 131, 117,   3, 129,
/* 15544 */ 115, 132,   3, 130, 115, 118,   7, 130,
/* 15552 */ 117, 130, 130, 117, 134, 119,   4, 130,
/* 15560 */ 119, 138, 104,   3, 131, 115, 136,   3,
/* 15568 */ 131, 118, 132,   5, 131, 118, 142, 115,
/* 15576 */ 136,   6, 132, 104, 118, 129, 115, 132,
/* 15584 */   5, 132, 104, 131, 116, 136,   4, 138,
/* 15592 */ 115, 127, 117,   7, 138, 136, 117, 122,
/* 15600 */ 119, 132, 117,   4, 139, 104, 132, 117,
/* 15608 */   0,   4, 104, 126, 120, 134,   7, 115,
/* 15616 */ 104, 136, 118, 137, 134, 115,   6, 115,
/* 15624 */ 119, 122, 136, 117, 104,   4, 115, 122,
/* 15632 */ 122, 115,   7, 115, 132, 138, 104, 132,
/* 15640 */ 119, 134,   8, 115, 132, 138, 117, 123,
/* 15648 */ 118, 131, 117,   6, 115, 137, 138, 136,
/* 15656 */ 115, 132,   5, 117, 131, 134, 115, 136,
/* 15664 */   4, 117, 132, 137, 115,   9, 117, 132,
/* 15672 */ 137, 119, 122, 137, 138, 115, 132,   4,
/* 15680 */ 118, 134, 119, 132,   9, 122, 116, 136,
/* 15688 */ 138, 127, 118, 130, 130, 116,   4, 123,
/* 15696 */ 118, 131, 117,   6, 123, 118, 132, 137,
/* 15704 */ 118, 136,  10, 123, 118, 132, 137, 119,
/* 15712 */ 122, 137, 138, 115, 132,   5, 124, 117,
/* 15720 */ 139, 118, 136,   2, 125, 104,   3, 126,
/* 15728 */ 116, 132,   3, 131, 115, 136,   3, 131,
/* 15736 */ 118, 132,   3, 132, 119, 134,   7, 134,
/* 15744 */ 104, 132, 117, 138, 116, 132,   6, 134,
/* 15752 */ 115, 132, 123, 136, 115,   3, 134, 115,
/* 15760 */ 136,  10, 134, 130, 104, 132, 117, 134,
/* 15768 */ 118, 138, 116, 132,   6, 134, 136, 104,
/* 15776 */ 132, 119, 134,   5, 134, 136, 104, 134,
/* 15784 */ 119,   8, 134, 136, 104, 137, 117, 124,
/* 15792 */ 116, 132,   6, 134, 136, 104, 138, 116,
/* 15800 */ 132,   5, 134, 136, 117, 131, 115,   5,
/* 15808 */ 134, 136, 118, 134, 117,   7, 136, 116,
/* 15816 */ 139, 115, 130, 116, 132,   6, 137, 115,
/* 15824 */ 134, 117, 116, 132,   7, 137, 119, 122,
/* 15832 */ 137, 138, 115, 132,   3, 137, 134, 115,
/* 15840 */   4, 137, 134, 115, 136,   5, 137, 138,
/* 15848 */ 136, 118, 132,   3, 138, 116, 136,   2,
/* 15856 */ 138, 117,   9, 138, 136, 115, 124, 116,
/* 15864 */ 137, 123, 115, 132,  12, 138, 136, 115,
/* 15872 */ 132, 137, 137, 119, 122, 137, 138, 115,
/* 15880 */ 132,   0,   5, 115, 137, 134, 116, 123,
/* 15888 */   5, 116, 141, 116, 131, 134,   9, 117,
/* 15896 */ 132, 124, 117, 137, 138, 117, 132, 123,
/* 15904 */   7, 117, 132, 137, 138, 117, 132, 123,
/* 15912 */   7, 124, 117, 137, 138, 117, 132, 123,
/* 15920 */   5, 134, 136, 118, 131, 134,   6, 136,
/* 15928 */ 116, 137, 134, 116, 123,   6, 137, 119,
/* 15936 */ 137, 134, 116, 123,   0,   1, 122,   3,
/* 15944 */ 122, 115, 138,   4, 122, 117, 137, 123,
/* 15952 */   2, 122, 136,   1, 123,   3, 123, 117,
/* 15960 */ 134,   3, 123, 118, 122,   4, 123, 118,
/* 15968 */ 132, 126,   3, 123, 118, 134,   1, 124,
/* 15976 */   1, 125,   3, 125, 116, 124,   1, 126,
/* 15984 */   4, 127, 115, 136, 134,   5, 127, 117,
/* 15992 */ 131, 115, 130,   1, 128,   7, 128, 115,
/* 16000 */ 123, 115, 134, 119, 123,   1, 129,   1,
/* 16008 */ 131,   3, 131, 115, 130,   3, 134, 115,
/* 16016 */ 134,   2, 134, 117,   3, 136, 117, 131,
/* 16024 */   3, 137, 115, 122,   1, 138,   3, 139,
/* 16032 */ 117, 130,   1, 140,   3, 140, 117, 130,
/* 16040 */   0,   3, 104, 117, 130,   4, 104, 117,
/* 16048 */ 130, 118,   4, 104, 117, 136, 115,   4,
/* 16056 */ 104, 117, 136, 118,   3, 104, 130, 115,
/* 16064 */   3, 104, 130, 117,   3, 104, 130, 118,
/* 16072 */   3, 104, 131, 118,   3, 104, 132, 118,
/* 16080 */   3, 104, 138, 118,   3, 111, 119, 136,
/* 16088 */   3, 115, 118, 137,   3, 115, 118, 138,
/* 16096 */   3, 115, 130, 123,   3, 115, 130, 124,
/* 16104 */   3, 115, 131, 104,   5, 115, 131, 117,
/* 16112 */ 138, 118,   5, 115, 136, 115, 124, 136,
/* 16120 */   5, 115, 136, 117, 137, 131,   4, 116,
/* 16128 */ 117, 130, 117,   5, 117, 115, 132, 138,
/* 16136 */ 117,   4, 117, 115, 137, 131,   5, 117,
/* 16144 */ 118, 132, 117, 137,   4, 117, 130, 115,
/* 16152 */ 130,   4, 117, 130, 118, 134,   4, 117,
/* 16160 */ 130, 118, 136,   3, 117, 131, 118,   4,
/* 16168 */ 117, 136, 115, 126,   3, 117, 136, 118,
/* 16176 */   3, 117, 138, 117,   3, 117, 138, 118,
/* 16184 */   2, 118, 104,   2, 118, 115,   4, 118,
/* 16192 */ 116, 119, 136,   2, 118, 130,   3, 118,
/* 16200 */ 132, 124,   2, 118, 136,   4, 120, 138,
/* 16208 */ 136, 117,   0
} ; 

const U8 NdCl [] = {
/*   0 */   0
} ; 

const U16 LHCl [] = {
/*   0 */     0
} ; 

const int NbNd        = 0x03E8;
const short NbInst      = 0x0280;
const int NbSNd       = 0x01E0;
const short NbTabBasePG = 0x0004;
const int NbAid       = 0x02CE;
const int NbChPD      = 0x0AAE;
const int NbContxt    = 0x06B9;

const U8 Nd [] = {
/*   0 */   0,  91, 255,   2, 127, 119, 117, 138,
/*   8 */ 255,   2, 132, 116, 119, 125, 255,   1,
/*  16 */ 124,  91,  92,  91, 255,   2, 116, 137,
/*  24 */ 138,  91,  92,  91, 255,   2,  92,  91,
/*  32 */ 255,   2, 122,  91, 255,   1, 123,  91,
/*  40 */ 255,   1, 255,   1, 125,  91, 255,   1,
/*  48 */ 126,  91, 255,   1,  91, 255,   1, 128,
/*  56 */  91, 255,   1, 129,  91, 255,   1, 130,
/*  64 */  91, 255,   1, 131,  91, 255,   1,  91,
/*  72 */ 255,   1, 134,  91, 255,   1, 135,  91,
/*  80 */ 255,   1, 136,  91, 255,   1, 137,  91,
/*  88 */ 255,   1, 138,  91, 255,   1, 139,  91,
/*  96 */ 255,   1, 140,  91, 255,   1, 141,  91,
/* 104 */ 255,   1, 120,  91, 255,   1, 142,  91,
/* 112 */ 255,   1, 115, 116, 132, 255,   1, 117,
/* 120 */ 130, 130, 255,   1, 255,   1, 132, 255,
/* 128 */   1, 131, 255,   1, 255,   2, 108, 255,
/* 136 */   1, 130, 130, 255,   2, 115, 131, 255,
/* 144 */   1, 131, 255,   2, 132, 255,   2, 118,
/* 152 */ 132, 255,   2, 119, 255,   1, 119, 255,
/* 160 */   2, 140, 255,   1, 120, 255,   2, 255,
/* 168 */   1, 101, 255,   1, 100, 255,   1, 102,
/* 176 */ 255,   1, 118, 131, 122, 255,   1, 255,
/* 184 */   2, 127, 255,   2, 136, 115, 123, 127,
/* 192 */ 255,   1,  87, 127, 255,   2, 123, 127,
/* 200 */ 255,   1, 118, 255,   1, 255,   2, 255,
/* 208 */   1,  91, 255,   1, 138, 255,   1, 121,
/* 216 */ 255,   1,  87, 255,   1,  91, 255,   1,
/* 224 */ 255,   2, 101, 255,   1, 115, 119, 255,
/* 232 */   1, 255,   2, 124, 255,   1, 116, 255,
/* 240 */   2, 125, 255,   1, 117, 130, 255,   1,
/* 248 */ 130, 255,   1, 132, 255,   1, 131, 255,
/* 256 */   1, 255,   1, 131, 131, 116, 132, 138,
/* 264 */ 255,   1, 255,   2, 132, 138, 137, 255,
/* 272 */   1, 255,   2, 255,   2, 136, 255,   2,
/* 280 */ 116, 137, 137, 117, 116, 119, 136, 137,
/* 288 */ 255,   1, 137, 255,   2, 255,   2, 255,
/* 296 */   2, 138, 255,   1, 127, 255,   1, 119,
/* 304 */ 255,   2, 113, 255,   2, 140, 255,   2,
/* 312 */ 120, 255,   2, 142, 255,   2, 116, 255,
/* 320 */   1, 116, 255,   1, 255,   2, 104, 255,
/* 328 */   1, 105, 255,   1, 106, 255,   1, 107,
/* 336 */ 255,   2, 255,   2, 116, 255,   1, 132,
/* 344 */ 255,   2, 119, 116, 255,   1, 107, 255,
/* 352 */   1, 255,   2, 255,   2, 126, 255,   2,
/* 360 */ 255,   1, 117, 116, 132, 255,   2, 138,
/* 368 */ 255,   1, 127, 255,   1, 130, 130, 255,
/* 376 */   2, 127, 255,   2, 255,   2, 131, 255,
/* 384 */   2, 109, 131, 255,   2, 132, 126, 255,
/* 392 */   1, 127, 255,   1, 138, 116, 136, 255,
/* 400 */   1, 255,   2, 132, 255,   1, 108, 132,
/* 408 */ 255,   1, 255,   2, 255,   2, 255,   2,
/* 416 */ 255,   1, 255,   2,  87, 255,   1,  91,
/* 424 */ 255,   1, 255,   2, 137, 255,   2, 138,
/* 432 */ 255,   1, 255,   2,  87, 255,   1,  91,
/* 440 */ 255,   1, 255,   2,  87, 255,   1,  91,
/* 448 */ 255,   1, 255,   2,  87, 255,   1,  91,
/* 456 */ 255,   1, 106, 255,   1, 116, 255,   2,
/* 464 */ 117, 255,   2, 132, 255,   1, 108, 255,
/* 472 */   1, 255,   2, 132, 137, 117, 116, 119,
/* 480 */ 136, 255,   1, 255,   2,  92, 255,   1,
/* 488 */ 118, 255,   2, 119, 116, 132, 138, 255,
/* 496 */   1, 255,   2, 255,   1, 112, 255,   1,
/* 504 */ 113, 255,   1, 127, 255,   1, 140, 255,
/* 512 */   2, 120, 116, 132, 138, 255,   1, 255,
/* 520 */   2, 255,   2, 103, 119, 125, 137, 255,
/* 528 */   1, 119, 125, 137, 255,   1, 255,   2,
/* 536 */ 255,   2, 255,   2, 110, 255,   1, 111,
/* 544 */ 255,   1, 127, 255,   1, 138, 255,   2,
/* 552 */ 137, 255,   1, 255,   2, 135, 119, 115,
/* 560 */ 255,   1, 119, 115, 255,   2, 117, 255,
/* 568 */   2, 255,   2,  87, 255,   1,  91, 255,
/* 576 */   1, 255,   2, 137, 255,   1, 255,   2,
/* 584 */ 255,   2, 137, 255,   1, 123, 127, 255,
/* 592 */   2, 255,   1, 127, 255,   2,  87, 255,
/* 600 */   1,  91, 255,   1, 255,   2, 127, 255,
/* 608 */   1, 117, 116, 131, 255,   1, 132, 255,
/* 616 */   1,  87, 255,   1,  91, 255,   1,  92,
/* 624 */ 255,   1, 138, 255,   2, 119, 116, 255,
/* 632 */   2, 117, 130, 130, 255,   1, 130, 255,
/* 640 */   1, 131, 255,   2, 114, 131, 255,   2,
/* 648 */ 132, 255,   2, 132, 255,   1, 120, 255,
/* 656 */   1, 255,   2, 112, 255,   1, 113, 255,
/* 664 */   1, 255,   1, 255,   2, 255,   2, 255,
/* 672 */   2, 141, 255,   2, 116, 255,   1, 132,
/* 680 */ 255,   1, 131, 255,   2, 255,   2,  92,
/* 688 */ 255,   1, 255,   2, 142, 255,   1,  87,
/* 696 */ 255,   1, 143, 255,   1,  91,  92,  91,
/* 704 */  31,   5,  91,  92,  91, 255,   1,  18,
/* 712 */   5,  91,  92,  91, 255,   1,   5,  91,
/* 720 */  92,  91, 255,   2, 255,   1, 255,   2,
/* 728 */  22, 255,   1,  35, 255,   1,  27, 255,
/* 736 */   1, 255,   2,  87, 255,   1, 255,   1,
/* 744 */  92, 255,   1,  30, 255,   1,   3, 255,
/* 752 */   2,  12, 255,   2,  11, 255,   2, 115,
/* 760 */  78, 255,   1, 122,  78, 255,   1, 123,
/* 768 */  78, 255,   1, 124,  78, 255,   1, 116,
/* 776 */  78, 255,   1, 125,  78, 255,   1, 126,
/* 784 */  78, 255,   1, 127,  78, 255,   1, 117,
/* 792 */  78, 255,   1, 128,  78, 255,   1, 129,
/* 800 */  78, 255,   1, 130,  78, 255,   1, 131,
/* 808 */  78, 255,   1, 132,  78, 255,   1, 118,
/* 816 */  78, 255,   1, 134,  78, 255,   1, 135,
/* 824 */  78, 255,   1, 136,  78, 255,   1, 137,
/* 832 */  78, 255,   1, 138,  78, 255,   1, 119,
/* 840 */  78, 255,   1, 139,  78, 255,   1, 140,
/* 848 */  78, 255,   1, 141,  78, 255,   1, 120,
/* 856 */  78, 255,   1, 142,  78, 255,   1,  85,
/* 864 */ 255,   1,  86, 255,   1,  88, 255,   1,
/* 872 */  78, 255,   1,  90, 255,   1,  82, 255,
/* 880 */   1,  91, 255,   1,  87, 255,   1,  92,
/* 888 */ 255,   1,  40, 255,   1,  47, 255,   1,
/* 896 */  48, 255,   1,  50, 255,   1,  41, 255,
/* 904 */   1,  51, 255,   1,  52, 255,   1,  53,
/* 912 */ 255,   1,  42, 255,   1,  54, 255,   1,
/* 920 */  55, 255,   1,  56, 255,   1,  57, 255,
/* 928 */   1,  58, 255,   1,  43, 255,   1,  59,
/* 936 */ 255,   1,  60, 255,   1,  61, 255,   1,
/* 944 */  62, 255,   1,  63, 255,   1,  44, 255,
/* 952 */   1,  64, 255,   1,  65, 255,   1,  66,
/* 960 */ 255,   1,  45, 255,   1,  67, 255,   1,
/* 968 */  46, 255,   1,   2, 255,   1,   4, 255,
/* 976 */   1,   6, 255,   1,   7, 255,   1,  10,
/* 984 */ 255,   1,  22, 255,   1,  21, 255,   1,
/* 992 */  20, 255,   1,  16, 255,   1,  91, 255,
/* 1000 */   1
} ; 

const U16 LH [] = {
/*   0 */     0,     0,    30,     3,     0,    52,     0,     0,
/*   8 */     0,     1,     0,    71,     0,     0,     0,     7,
/*  16 */     0,   218,    42,     0,     0,    15,     0,   226,
/*  24 */   290,   295,     0,     0,     0,    17,     0,     0,
/*  32 */     0,    19,     0,   183,     0,    24,     0,   185,
/*  40 */     0,    25,     0,    26,     0,   338,     0,    27,
/*  48 */     0,   340,     0,    28,   141,     0,    29,     0,
/*  56 */   318,     0,    30,     0,   426,     0,    31,     0,
/*  64 */   428,     0,    32,     0,   280,     0,    33,   450,
/*  72 */     0,    34,     0,   546,     0,    35,     0,   562,
/*  80 */     0,    36,     0,   579,     0,    37,     0,   321,
/*  88 */     0,    38,     0,   188,     0,    39,     0,   667,
/*  96 */     0,    40,     0,   669,     0,    41,     0,   671,
/* 104 */     0,    42,     0,   676,     0,    43,     0,   687,
/* 112 */     0,    44,     0,   119,     0,     0,    45,   134,
/* 120 */   126,   124,     0,    46,     0,    47,   129,     0,
/* 128 */    48,   132,     0,    48,     0,    24,   137,     0,
/* 136 */    50,   145,     0,     0,    26,   360,     0,     0,
/* 144 */    53,   148,     0,    28,   151,     0,    30,   158,
/* 152 */   155,     0,    32,     0,     0,    60,   161,     0,
/* 160 */    34,   164,     0,    63,   167,     0,    36,     0,
/* 168 */    71,     0,     0,    72,     0,     0,    73,     0,
/* 176 */     0,    74,     0,   458,   473,     0,    75,     0,
/* 184 */    43,   194,     0,    46,   604,     0,     0,     0,
/* 192 */     0,    91,   198,   207,     0,    67,   202,     0,
/* 200 */     0,    99,   205,     0,   104,   212,    70,   209,
/* 208 */   107,     0,     0,   107,     0,     0,   108,     0,
/* 216 */     0,   114,   224,   221,   115,     0,     0,   115,
/* 224 */   626,    77,   229,     0,   123,   235,   233,     0,
/* 232 */   124,     0,    84,   238,     0,   130,   241,     0,
/* 240 */    89,   244,     0,   133,   259,   251,   248,   134,
/* 248 */     0,     0,   135,   254,     0,   136,   257,     0,
/* 256 */   136,     0,   137,   268,   266,     0,     0,     0,
/* 264 */     0,   138,     0,    91,   277,   275,   273,     0,
/* 272 */   144,     0,    96,     0,   103,   297,     0,   125,
/* 280 */   442,     0,     0,     0,     0,     0,     0,     0,
/* 288 */     0,   183,   293,     0,   134,     0,   136,     0,
/* 296 */   142,   300,     0,   194,   303,     0,   194,   306,
/* 304 */     0,   144,   309,     0,   151,   312,     0,   155,
/* 312 */   315,     0,   157,   324,     0,   159,   418,     0,
/* 320 */   210,   584,     0,   211,   673,   162,     0,   557,
/* 328 */   223,     0,     0,   224,     0,     0,   224,     0,
/* 336 */     0,   173,     0,   175,   343,     0,   231,   346,
/* 344 */     0,   179,   355,   350,     0,   242,   353,     0,
/* 352 */   243,     0,   189,   357,   197,     0,     0,   205,
/* 360 */     0,   261,     0,   370,   414,   367,   207,     0,
/* 368 */     0,   264,   373,     0,   269,   382,   377,     0,
/* 376 */   213,   380,     0,   220,     0,   222,   389,     0,
/* 384 */   224,     0,   403,     0,   227,   412,   393,     0,
/* 392 */   284,   396,     0,   285,   401,     0,     0,     0,
/* 400 */   286,     0,   229,   410,     0,   288,     0,   416,
/* 408 */     0,   289,     0,   237,     0,   231,     0,   234,
/* 416 */     0,   302,   420,   250,     0,   423,   304,     0,
/* 424 */     0,   304,     0,   252,   431,     0,   254,   434,
/* 432 */     0,   309,   436,   256,     0,   439,   312,     0,
/* 440 */     0,   312,   444,   259,     0,   447,   314,     0,
/* 448 */     0,   314,   452,   261,     0,   455,   316,     0,
/* 456 */     0,   316,   461,     0,   317,   464,   529,   302,
/* 464 */   470,   467,   263,     0,     0,   320,   475,     0,
/* 472 */   321,     0,   265,   488,   483,     0,     0,     0,
/* 480 */     0,     0,   327,   485,   270,     0,     0,   329,
/* 488 */   491,     0,   272,   501,   497,   499,     0,     0,
/* 496 */   336,   507,   277,     0,   339,   504,     0,   342,
/* 504 */   510,     0,   342,     0,     0,   342,   513,     0,
/* 512 */   282,   521,   519,     0,     0,     0,   346,     0,
/* 520 */   285,   586,   290,     0,   538,   534,     0,     0,
/* 528 */   360,     0,   536,     0,     0,   360,     0,   298,
/* 536 */     0,   300,     0,   304,     0,     0,   365,     0,
/* 544 */     0,   366,   549,     0,   367,   552,     0,   307,
/* 552 */   555,     0,   371,     0,   310,     0,     0,     0,
/* 560 */     0,   377,   577,   566,     0,   315,   569,     0,
/* 568 */   317,   571,   320,     0,   574,   386,     0,     0,
/* 576 */   386,     0,   324,   582,     0,   389,     0,   326,
/* 584 */   589,   328,     0,     0,   398,   595,   593,     0,
/* 592 */   345,     0,   412,   598,     0,   347,     0,   601,
/* 600 */   431,     0,     0,   431,   606,   369,   609,     0,
/* 608 */   438,   617,     0,   614,     0,   454,     0,     0,
/* 616 */   458,   623,   620,   467,     0,     0,   467,     0,
/* 624 */     0,   468,     0,     0,   399,     0,   633,     0,
/* 632 */   404,   638,     0,     0,     0,   478,   641,     0,
/* 640 */   479,   648,     0,   406,     0,   651,     0,   412,
/* 648 */   654,     0,   414,   665,     0,   488,   657,     0,
/* 656 */   489,     0,   417,     0,     0,   497,     0,     0,
/* 664 */   497,     0,   497,     0,   425,     0,   427,     0,
/* 672 */   430,     0,     0,   434,   679,     0,   516,   682,
/* 680 */     0,   517,   685,     0,   443,     0,   445,   690,
/* 688 */     0,   526,   692,   451,     0,     0,   529,     0,
/* 696 */     0,   532,     0,     0,   533,     0,   737,     0,
/* 704 */   711,     0,     0,     0,     0,     0,   534,   742,
/* 712 */     0,     0,     0,     0,     0,   535,     0,   726,
/* 720 */   724,     0,     0,   455,     0,   537,     0,   457,
/* 728 */     0,     0,   555,     0,     0,   556,     0,     0,
/* 736 */   557,     0,   473,     0,     0,   560,     0,   561,
/* 744 */     0,     0,   561,     0,     0,   562,     0,     0,
/* 752 */   475,     0,     0,   477,     0,     0,   479,     0,
/* 760 */     0,     0,   569,     0,     0,     0,   570,     0,
/* 768 */     0,     0,   571,     0,     0,     0,   572,     0,
/* 776 */     0,     0,   573,     0,     0,     0,   574,     0,
/* 784 */     0,     0,   575,     0,     0,     0,   576,     0,
/* 792 */     0,     0,   577,     0,     0,     0,   578,     0,
/* 800 */     0,     0,   579,     0,     0,     0,   580,     0,
/* 808 */     0,     0,   581,     0,     0,     0,   582,     0,
/* 816 */     0,     0,   583,     0,     0,     0,   584,     0,
/* 824 */     0,     0,   585,     0,     0,     0,   586,     0,
/* 832 */     0,     0,   587,     0,     0,     0,   588,     0,
/* 840 */     0,     0,   589,     0,     0,     0,   590,     0,
/* 848 */     0,     0,   591,     0,     0,     0,   592,     0,
/* 856 */     0,     0,   593,     0,     0,     0,   594,     0,
/* 864 */     0,   595,     0,     0,   596,     0,     0,   597,
/* 872 */     0,     0,   598,     0,     0,   599,     0,     0,
/* 880 */   600,     0,     0,   601,     0,     0,   602,     0,
/* 888 */     0,   603,     0,     0,   604,     0,     0,   605,
/* 896 */     0,     0,   606,     0,     0,   607,     0,     0,
/* 904 */   608,     0,     0,   609,     0,     0,   610,     0,
/* 912 */     0,   611,     0,     0,   612,     0,     0,   613,
/* 920 */     0,     0,   614,     0,     0,   615,     0,     0,
/* 928 */   616,     0,     0,   617,     0,     0,   618,     0,
/* 936 */     0,   619,     0,     0,   620,     0,     0,   621,
/* 944 */     0,     0,   622,     0,     0,   623,     0,     0,
/* 952 */   624,     0,     0,   625,     0,     0,   626,     0,
/* 960 */     0,   627,     0,     0,   628,     0,     0,   629,
/* 968 */     0,     0,   630,     0,     0,   631,     0,     0,
/* 976 */   632,     0,     0,   633,     0,     0,   634,     0,
/* 984 */     0,   635,     0,     0,   636,     0,     0,   637,
/* 992 */     0,     0,   638,     0,     0,   639,     0,     0,
/* 1000 */   640
} ;


#ifdef DEBG
const long Num [] = {
      10,      15,      16,      20,      21,      24,      25,      30,
      35,      40,      45,      50,      55,      60,      65,      70,
      71,      72,      73,      74,      75,      76,      77,      80,
     201,     202,     203,     205,     206,     207,     209,     210,
     211,     212,     213,     215,     216,     217,     218,     219,
     221,     222,     223,     224,     225,    1000,    1040,    1050,
    1060,    1070,    1080,    1081,    1082,    1090,    1095,    1100,
    1101,    1110,    1111,    1112,    1113,    1120,    1130,    1131,
    1140,    1150,    1160,    1161,    1165,    1170,    1180,    1190,
    1200,    1210,    1220,    2000,    2010,    2020,    2030,    3040,
    3050,    3060,    3070,    3071,    3090,    3091,    3100,    3110,
    3111,    3120,    3121,    3125,    3130,    3131,    3140,    3150,
    3154,    3155,    3160,    3170,    3175,    3180,    3185,    3186,
    3187,    3189,    3190,    3195,    3200,    3210,    3220,    3230,
    3240,    3250,    3260,    4000,    4011,    4015,    4016,    4020,
    4030,    4035,    4040,    5060,    5061,    5062,    5063,    5064,
    5065,    5068,    5070,    5071,    5072,    5080,    5090,    5110,
    5120,    5130,    5140,    5150,    5160,    5170,    5180,    5190,
    5250,    5255,    5260,    5265,    5266,    5270,    5271,    5275,
    5280,    5285,    5286,    5290,    5295,    5300,    5305,    5306,
    5307,    5310,    5311,    5315,    5320,    5325,    5330,    5335,
    5340,    5342,    5344,    5345,    5346,    5347,    5350,    5360,
    5361,    5370,    5371,    5372,    5373,    5375,    5380,    5390,
    5391,    5392,    5394,    5395,    5400,    5415,    5420,    5430,
    5460,    5461,    5470,    5480,    5490,    5500,    5510,    5520,
    5530,    5540,    5560,    5561,    5562,    5570,    5580,    5585,
    5586,    5590,    5630,    5640,    5645,    5646,    5650,    5655,
    5658,    5659,    5660,    5665,    5666,    5670,    5680,    5690,
    5700,    5710,    5720,    6000,    6010,    6020,    6030,    7000,
    7005,    7010,    7020,    7030,    7040,    7041,    7043,    7050,
    7060,    7070,    7080,    7090,    7100,    7103,    7105,    7110,
    7115,    7120,    7130,    7140,    7150,    7151,    7152,    7160,
    7170,    7175,    7176,    7180,    7190,    8000,    9010,    9020,
    9030,    9040,    9050,    9060,    9070,    9109,    9090,    9095,
    9096,    9100,    9101,    9110,    9120,    9130,    9140,    9150,
    9160,    9170,    9180,    9190,    9195,    9200,    9201,    9202,
    9210,    9220,    9230,    9240,    9241,    9242,    9243,    9250,
    9251,    9260,    9270,    9280,    9290,    9300,    9310,   10000,
   10010,   11000,   11010,   12010,   12011,   12012,   12020,   12040,
   12050,   13020,   13030,   14010,   14020,   15000,   15010,   15020,
   15030,   15040,   15050,   15060,   15065,   15070,   15080,   15090,
   15100,   15110,   15120,   15130,   15140,   15150,   15160,   15170,
   15200,   15210,   15220,   15230,   15240,   15250,   15260,   15270,
   15280,   15290,   15300,   15310,   15320,   15330,   15340,   15350,
   15355,   15356,   15360,   15365,   15366,   15367,   15370,   15380,
   15390,   15400,   15410,   15420,   15430,   15440,   15450,   16000,
   16010,   16011,   16020,   16025,   16028,   16030,   16031,   16040,
   16050,   17000,   17005,   17010,   17015,   17020,   17021,   17030,
   17040,   17050,   17060,   17065,   17070,   18010,   18011,   18020,
   19010,   19020,   19030,   19040,   19050,   19052,   19055,   19060,
   19065,   19070,   19100,   19110,   19120,   19140,   19150,   19160,
   19170,   19175,   19180,   19190,   19191,   19200,   19210,   19220,
   19230,   19235,   19240,   19245,   19250,   19270,   19275,   19280,
   19281,   19282,   19283,   19284,   19289,   19290,   19291,   19292,
   19300,   19310,   19320,   19321,   20000,   20010,   20020,   20025,
   20030,   20040,   20050,   20060,   20070,   20080,   20090,   20100,
   20110,   20130,   20135,   20136,   20137,   20140,   20150,   20160,
   20170,   20200,   20240,   20250,   20260,   20265,   20270,   20275,
   20280,   20290,   20300,   20310,   20320,   20330,   20340,   20341,
   20342,   20350,   20360,   20370,   21010,   21020,   21030,   21040,
   21060,   21070,   21071,   21075,   21076,   21080,   21090,   21110,
   21120,   21130,   21135,   21140,   21141,   21142,   21150,   21151,
   21152,   21160,   22000,   22001,   23000,   23010,   23020,   24000,
   24020,   24040,   24045,   24050,   24051,   24052,   24053,   24060,
   24070,   24071,   24080,   24090,   25000,   25010,   25020,   25021,
   25025,   25030,   25040,   25050,   25060,   25070,   26000,   26010,
   26020,   26021,   26030,   26040,   27000,  100010,  100020,  100030,
  100040,  100045,  100050,  100060,  100070,  100090,  100091,  100092,
  100093,  100094,  100095,  100096,  100097,  100100,  100120,  100130,
  100140,  100150,  100160,  100170,  100180,  100190,  100200,  100210,
  100220,  100230,  100240,  200010,  200020,  200030,  200040,  200050,
  200060,  300100,  300101,  300102,  300103,  300104,  300105,  300106,
  300107,  300108,  300109,  300110,  300111,  300112,  300113,  300114,
  300115,  300116,  300117,  300118,  300119,  300120,  300121,  300122,
  300123,  300124,  300125,  340000,  340010,  340020,  340030,  340040,
  340050,  340060,  340080,  340090,  340100,  340101,  340102,  340103,
  340104,  340105,  340106,  340107,  340108,  340109,  340110,  340111,
  340112,  340113,  340114,  340115,  340116,  340117,  340118,  340119,
  340120,  340121,  340122,  340123,  340124,  340125,  340126,   50000,
   50010,   50020,   50030,   50035,   50040,   50050,   50060,   50070,
   50080} ; 
#endif


const U16 PrtDrte [] = {
/*   0 */     1,    17,    34,    55,    55,    85,     1,   113,
/*   8 */     1,     1,     1,     1,    55,    85,   129,     0,
/*  16 */   137,   143,   162,   117,   121,   121,   121,   123,
/*  24 */   200,   203,   206,   209,   212,   215,   218,   221,
/*  32 */   224,   227,   230,   233,   236,   239,   242,   245,
/*  40 */   248,   251,   259,   263,   265,   269,   274,   274,
/*  48 */   277,   279,   285,   287,   287,   306,   314,   269,
/*  56 */   318,   269,   269,   314,   326,   339,   343,   345,
/*  64 */   352,   352,   274,   274,   285,   367,   285,   314,
/*  72 */   370,   314,   372,   374,   376,     0,   384,   386,
/*  80 */   386,   386,   386,   386,   386,   386,   386,   386,
/*  88 */   386,   386,   386,   558,   582,   386,   386,   386,
/*  96 */   386,   386,   386,   386,   582,   386,   582,   582,
/* 104 */   693,   705,   705,   119,     0,     0,     0,   119,
/* 112 */     0,   386,   119,   137,   137,   137,   137,     0,
/* 120 */     0,   121,   137,   314,   343,   285,   285,   742,
/* 128 */   742,   263,   372,   372,   263,   372,   367,   367,
/* 136 */   277,   285,   765,   314,   269,   277,   269,   227,
/* 144 */   269,     0,   269,   269,   269,   269,   269,     0,
/* 152 */   277,   277,   277,   277,   277,   277,   277,   277,
/* 160 */   277,   285,   230,   314,   917,   931,   931,   269,
/* 168 */   269,   314,   277,   230,   230,   269,   239,   239,
/* 176 */   239,   239,   239,   372,   239,  1088,   372,  1091,
/* 184 */   242,  1119,  1119,   242,  1127,   372,   285,  1127,
/* 192 */   162,   285,   372,  1153,  1153,  1160,  1160,  1160,
/* 200 */  1160,  1175,  1160,  1179,  1182,   367,   285,  1185,
/* 208 */  1185,   372,  1212,   119,   285,   372,   285,   372,
/* 216 */     0,   279,  1127,   285,   372,   285,  1127,   372,
/* 224 */   285,   285,  1127,     0,     0,     0,  1263,  1212,
/* 232 */  1269,  1269,  1269,  1269,  1269,  1269,  1269,  1269,
/* 240 */   123,  1321,  1323,  1326,   705,  1332,  1332,  1332,
/* 248 */  1343,  1343,  1332,   705,     0,   705,   705,     0,
/* 256 */  1212,     0,  1373,     0,   705,     0,  1379,  1386,
/* 264 */   263,  1419,   263,  1419,  1419,   263,  1425,  1428,
/* 272 */  1428,  1428,  1428,  1425,  1441,  1428,  1425,   263,
/* 280 */  1441,   277,   277,   277,  1461,  1464,  1467,  1464,
/* 288 */   277,   277,  1441,   263,   263,   263,   263,  1523,
/* 296 */   263,  1441,  1441,  1441,  1425,  1425,   263,  1441,
/* 304 */  1212,     0,   386,   119,     0,     0,     0,     0,
/* 312 */  1562,     0,  1564,     0,   123,  1566,  1566,   339,
/* 320 */  1572,  1566,   339,  1575,  1575,  1578,   374,  1581,
/* 328 */  1586,  1589,   374,   339,  1597,  1597,  1597,   326,
/* 336 */   326,   326,   326,   326,  1632,  1634,   326,   343,
/* 344 */  1637,   326,  1566,  1650,  1650,  1650,  1674,  1566,
/* 352 */   343,   339,   343,   343,   343,   343,   339,   339,
/* 360 */  1160,  1175,  1160,  1175,   372,   343,  1175,  1263,
/* 368 */     0,   121,   121,  1718,   376,   376,     0,     0,
/* 376 */   376,  1721,   221,  1760,  1788,  1788,  1788,  1837,
/* 384 */  1848,     0,   386,     0,   386,     0,     0,  1870,
/* 392 */   117,   117,   117,   117,   117,   117,  1919,   119,
/* 400 */   119,   117,   119,   119,     0,     0,   119,   117,
/* 408 */   119,   119,  2072,   582,   582,   117,   582,   117,
/* 416 */   119,   117,   117,   117,   117,     0,     0,   119,
/* 424 */   119,   119,   119,   119,   119,     0,   119,   119,
/* 432 */     0,     0,   117,   119,     0,     0,     0,   119,
/* 440 */   121,   121,   121,   121,   121,   121,   121,   121,
/* 448 */   121,   121,   119,   119,   119,   119,  2354,   121,
/* 456 */   119,   121,  2368,   119,   119,   119,   119,   119,
/* 464 */   119,   121,     0,   121,   121,     0,   121,   121,
/* 472 */   121,     0,     0,   121,  1153,  1175,  2443,  1153,
/* 480 */   931,  1575,   374,  1575,  1575,   931,   374,   374,
/* 488 */   931,  2443,  1153,  1153,  1153,  1153,  2545,  1175,
/* 496 */  1175,  1153,     0,  2553,  2553,     0,  1632,     0,
/* 504 */   119,   119,   119,  2579,  2579,  2579,  2592,   117,
/* 512 */  2609,  2609,     0,  2609,   263,   277,   277,   277,
/* 520 */   274,  1441,  1441,  1425,  1425,   263,   117,   119,
/* 528 */     0,  2633,     0,   117,     0,  1127,   137,  1562,
/* 536 */  1127,  2639,     0,  1127,     0,  1127,  1127,  1127,
/* 544 */  1127,  1127,  1127,  1127,  1127,  1127,  1127,  1127,
/* 552 */  1127,     0,     0,     0,     0,     0,     0,     0,
/* 560 */     0,     0,   376,   372,   372,  1153,  2545,   326,
/* 568 */  1632,   314,   200,   203,   206,   279,   209,   212,
/* 576 */   215,   263,   218,   221,   224,   227,   230,   343,
/* 584 */   233,   236,   239,   242,   245,  1153,   248,   251,
/* 592 */   259,  2689,   265,  2695,  2698,  2701,  2704,  2707,
/* 600 */  2710,     0,  2713,  1149,   528,   290,   292,   173,
/* 608 */   359,   281,  1155,   127,   602,  1367,   740,   337,
/* 616 */   309,   316,   433,   321,  2731,   341,   283,   168,
/* 624 */   456,  1177,  2733,  1227,   166,   816,   530,   314,
/* 632 */   339,   285,  1127,  1127,   263,  1153,   326,   277,
/* 640 */     0
} ; 

const short ContG [] = {
/*   0 */     0,     5,     8,    11,    15,    20,    -1,    -1,
/*   8 */    -1,    37,    40,    45,    51,    56,    59,    62,
/*  16 */    64,    66,    66,    73,    78,    83,    90,    97,
/*  24 */    66,    66,    66,    66,    66,    66,    66,    66,
/*  32 */    66,    66,    66,    66,    66,    66,    66,    66,
/*  40 */    66,    66,    66,    66,    66,    99,    -1,    -1,
/*  48 */    -1,   106,    -1,   111,   115,    66,   124,    -1,
/*  56 */   130,    -1,   139,   139,   146,    -1,    -1,    -1,
/*  64 */   155,   159,   163,    -1,   168,    -1,    -1,    -1,
/*  72 */    -1,    -1,    -1,    -1,   172,   179,    -1,   181,
/*  80 */   194,   205,   209,    -1,   215,   215,   234,   239,
/*  88 */   247,   251,   257,   266,   278,   278,   287,   299,
/*  96 */   306,   310,   313,    -1,    66,    -1,    -1,    -1,
/* 104 */    66,   335,   339,    66,   343,   346,   348,    -1,
/* 112 */   356,    -1,    -1,    66,   358,   362,   365,    -1,
/* 120 */   375,   181,    -1,   377,    -1,   381,   385,   390,
/* 128 */   377,   377,   398,    -1,    -1,   401,    -1,    -1,
/* 136 */    -1,    -1,    -1,   106,   405,   251,    -1,    -1,
/* 144 */    -1,    -1,    -1,    -1,    -1,   415,   418,    -1,
/* 152 */   420,   424,   432,   124,   444,   448,   454,    -1,
/* 160 */   465,    66,   432,   474,    66,   486,   492,   497,
/* 168 */   506,   514,   516,    -1,   377,    -1,   528,    -1,
/* 176 */   535,   540,   543,   548,    -1,   550,    -1,    -1,
/* 184 */   553,   553,   553,   553,   124,    -1,   571,    -1,
/* 192 */   575,    66,    66,    66,   580,   585,   587,    -1,
/* 200 */    66,    -1,    -1,    -1,    -1,    -1,    -1,   605,
/* 208 */    -1,    -1,    -1,    -1,    -1,    -1,    -1,    66,
/* 216 */   651,   580,    -1,    -1,    -1,    -1,    -1,    -1,
/* 224 */    -1,    -1,    -1,   680,   683,   688,    -1,    -1,
/* 232 */    -1,   181,   703,   708,    66,   723,   728,   730,
/* 240 */   733,    -1,    -1,    -1,   737,   737,   741,   194,
/* 248 */   750,   752,    -1,    -1,   762,    -1,   765,   768,
/* 256 */    -1,   777,   779,   781,    -1,    -1,   783,   785,
/* 264 */   788,   795,    -1,   379,   806,    -1,   403,   810,
/* 272 */    -1,   817,   822,   825,   118,   829,   832,   834,
/* 280 */   118,   118,    66,    -1,    -1,    -1,    66,   842,
/* 288 */    -1,    -1,   846,    -1,   852,   432,   211,   377,
/* 296 */   377,   873,   883,   887,   890,   893,    -1,   898,
/* 304 */    -1,   356,    -1,   900,   902,   904,   906,   909,
/* 312 */    -1,   911,    -1,   913,    -1,   155,   403,    66,
/* 320 */    -1,    -1,   379,   917,   337,    -1,    -1,   403,
/* 328 */   926,   585,    -1,   929,    99,    66,   938,    -1,
/* 336 */    -1,    -1,   950,   377,    -1,   377,    -1,    -1,
/* 344 */    -1,   783,    -1,   965,   432,    -1,    -1,    -1,
/* 352 */    -1,    -1,   986,   990,    -1,   994,  1000,    -1,
/* 360 */    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
/* 368 */  1009,  1012,  1018,  1020,  1023,  1027,    -1,  1030,
/* 376 */    -1,  1032,    -1,    -1,  1051,   181,  1057,  1070,
/* 384 */    66,   356,    -1,   356,    -1,  1082,  1084,    -1,
/* 392 */   181,  1097,  1108,  1113,  1123,  1131,    -1,  1141,
/* 400 */   118,  1146,  1149,  1166,  1170,  1179,  1181,  1131,
/* 408 */  1185,  1187,    -1,    -1,  1196,  1198,    -1,  1202,
/* 416 */    64,  1207,  1213,   278,   118,  1228,   118,  1245,
/* 424 */  1249,  1253,  1257,  1261,  1268,  1271,    -1,    66,
/* 432 */    -1,   348,  1274,    -1,  1280,  1284,  1289,  1292,
/* 440 */  1296,  1303,  1307,  1312,  1316,  1320,  1324,  1328,
/* 448 */  1332,  1340,    -1,  1355,    -1,    -1,  1372,    -1,
/* 456 */  1380,    -1,  1372,  1382,  1388,    -1,  1400,  1407,
/* 464 */  1412,    -1,    -1,    66,  1418,  1420,  1423,    -1,
/* 472 */  1427,    -1,  1429,    -1,    -1,    -1,   377,  1431,
/* 480 */  1439,  1441,    -1,    -1,  1456,    -1,    66,   155,
/* 488 */    -1,   377,    -1,    -1,  1477,  1479,  1484,  1491,
/* 496 */   783,    -1,  1498,    -1,    66,    -1,    -1,   904,
/* 504 */  1504,  1509,  1511,  1513,   444,   251,    66,  1523,
/* 512 */  1527,  1532,    -1,    -1,   377,    -1,  1538,    -1,
/* 520 */  1543,  1551,  1554,  1558,   893,    -1,  1418,   379,
/* 528 */  1565,  1568,  1571,    -1,  1573,    -1,  1576,  1580,
/* 536 */  1582,  1588,  1591,  1594,    -1,  1598,  1603,  1612,
/* 544 */  1618,  1625,  1632,  1636,  1641,  1646,  1646,  1652,
/* 552 */    -1,  1580,  1661,  1664,  1666,  1668,    66,    -1,
/* 560 */    -1,    -1,    -1,    -1,    -1,  1700,  1705,  1700,
/* 568 */  1705,  1708,  1708,  1708,  1708,  1708,  1708,  1708,
/* 576 */  1708,  1708,  1708,  1708,  1708,  1708,  1708,  1708,
/* 584 */  1708,  1708,  1708,  1708,  1708,  1708,  1708,  1708,
/* 592 */  1708,  1708,  1708,    -1,    -1,    -1,    -1,    -1,
/* 600 */    -1,    66,  1711,    -1,    -1,    -1,    -1,    -1,
/* 608 */    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
/* 616 */    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
/* 624 */    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
/* 632 */    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
/* 640 */    -1
} ; 

const short ContD [] = {
/*   0 */     3,    -1,    -1,    13,    18,    22,    25,    32,
/*   8 */    35,    -1,    -1,    48,    54,    54,    54,    54,
/*  16 */    54,    68,    54,    75,    54,    54,    93,    54,
/*  24 */    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
/*  32 */    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
/*  40 */    -1,    -1,    -1,    -1,    -1,    -1,    -1,   101,
/*  48 */   103,   108,    -1,   101,   118,   120,   126,   128,
/*  56 */   101,   136,   101,   143,   149,   151,    -1,   153,
/*  64 */   157,   161,   118,   166,   170,   118,    -1,    -1,
/*  72 */    -1,    -1,    -1,   101,   176,    -1,    -1,   183,
/*  80 */   196,   207,   211,   213,   217,   228,   236,   241,
/*  88 */   249,   253,   259,   270,   280,   284,   289,   303,
/*  96 */   308,    -1,   101,    -1,   321,   327,   101,    -1,
/* 104 */   331,   337,   341,    48,   101,   101,   350,   352,
/* 112 */    -1,    -1,    -1,    48,    66,   101,    66,   101,
/* 120 */    -1,   108,    -1,   379,    -1,   124,   388,   392,
/* 128 */    66,   395,   101,    66,    -1,   101,   101,    -1,
/* 136 */   103,    -1,    66,   403,   403,   408,   411,   101,
/* 144 */    66,    66,    66,    66,    66,    66,    66,    66,
/* 152 */   422,   430,   434,   442,   446,   450,   456,   462,
/* 160 */   467,   469,   472,   476,   479,   124,   379,   504,
/* 168 */   504,   126,   101,   519,   101,   523,    -1,   532,
/* 176 */   101,   101,    66,   101,   101,   101,   101,    -1,
/* 184 */   555,   118,   564,   377,   566,   569,    66,    66,
/* 192 */    66,    66,    66,   578,   582,   151,   592,   595,
/* 200 */   377,   597,    -1,   153,    -1,   118,    -1,    66,
/* 208 */    66,    66,   611,   613,   615,   625,   628,   640,
/* 216 */   653,   656,   658,   667,   670,   673,    -1,    -1,
/* 224 */    -1,   327,    -1,   101,   685,    -1,    -1,   690,
/* 232 */   696,   699,   705,   710,   712,   726,   207,    -1,
/* 240 */    -1,   118,   735,   101,   739,   735,   743,   746,
/* 248 */   611,   756,   759,   118,    66,    66,   101,   771,
/* 256 */   350,   124,   350,    -1,    -1,    -1,   379,   379,
/* 264 */    66,   798,   801,   803,   472,    -1,   651,   812,
/* 272 */   101,    -1,   170,    -1,    -1,    -1,    -1,   101,
/* 280 */   101,   101,   837,   840,   101,    -1,    -1,   101,
/* 288 */   103,   403,   101,   849,   118,   854,   862,   867,
/* 296 */   870,   877,   877,   877,   877,   877,    -1,   118,
/* 304 */    -1,    -1,    -1,    66,    66,    66,   126,    -1,
/* 312 */    -1,    -1,    -1,    -1,    -1,   149,   149,   915,
/* 320 */   103,    -1,   126,   101,   920,   920,   923,    -1,
/* 328 */   101,   118,   136,    -1,   931,   377,    -1,    -1,
/* 336 */    66,   943,   118,   953,   956,   959,    -1,   101,
/* 344 */   962,   126,    66,   118,   708,   101,   972,    -1,
/* 352 */   976,   983,   101,   670,   108,   997,   331,    -1,
/* 360 */    -1,  1003,    -1,   735,    -1,    -1,    -1,    -1,
/* 368 */   101,  1014,   118,    66,    66,   101,   101,    -1,
/* 376 */    -1,  1040,  1042,  1044,    -1,  1054,  1059,  1074,
/* 384 */  1078,    -1,    -1,    -1,    -1,    66,    -1,    -1,
/* 392 */  1086,  1099,  1110,  1115,  1125,   710,  1133,   118,
/* 400 */  1144,   611,  1151,  1168,  1173,   124,   118,  1183,
/* 408 */   207,  1189,  1194,    -1,   739,   118,    -1,  1204,
/* 416 */   211,  1209,  1215,  1224,   118,  1230,  1234,    66,
/* 424 */    66,    66,    66,    66,    66,    66,    -1,    48,
/* 432 */    66,    -1,  1277,    -1,  1282,  1286,   403,  1183,
/* 440 */  1301,  1301,  1301,  1301,  1301,  1301,  1301,  1301,
/* 448 */  1301,  1346,  1350,  1361,  1363,  1369,  1375,  1377,
/* 456 */  1377,  1377,    -1,  1385,  1394,  1396,  1402,  1410,
/* 464 */  1415,    66,    66,    48,   118,   101,   101,    66,
/* 472 */    66,   101,    -1,    -1,   101,   735,    -1,   101,
/* 480 */   101,   101,  1448,  1452,   377,   840,  1462,  1465,
/* 488 */   103,  1467,  1472,  1475,   308,  1482,  1487,  1493,
/* 496 */  1495,    -1,    -1,    -1,  1500,   613,    -1,  1502,
/* 504 */  1506,   118,    66,    48,   118,  1518,  1520,  1183,
/* 512 */    66,    66,    66,    -1,   101,   103,   101,  1540,
/* 520 */  1548,   118,   118,  1561,  1561,    -1,    -1,    -1,
/* 528 */   101,    -1,    -1,    -1,    -1,    -1,  1578,  1578,
/* 536 */  1578,  1578,  1580,    66,    66,  1600,  1605,  1615,
/* 544 */  1622,  1627,  1634,  1638,  1643,  1649,    -1,  1655,
/* 552 */  1649,  1658,    -1,    -1,    -1,    -1,    -1,  1670,
/* 560 */    -1,    -1,  1668,  1674,  1687,  1703,  1580,  1580,
/* 568 */  1580,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
/* 576 */    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
/* 584 */    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
/* 592 */    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
/* 600 */    -1,    -1,    48,    -1,    -1,    -1,    -1,    -1,
/* 608 */    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
/* 616 */    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
/* 624 */    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
/* 632 */    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
/* 640 */    -1
} ; 

const U16 SNd [] = {
/*   0 */     0,     2,     0,     4,     5,     6,     7,     8,
/*   8 */     9,    10,    11,    12,    13,    14,     0,    16,
/*  16 */     0,    18,     0,    20,    21,    22,    23,     0,
/*  24 */    25,     0,    27,     0,    29,     0,    31,     0,
/*  32 */    33,     0,    35,     0,    37,    38,    39,    40,
/*  40 */    41,    42,     0,    44,    45,     0,    47,    48,
/*  48 */    49,    50,    51,    52,    53,    54,    55,    56,
/*  56 */    57,    58,    59,    60,    61,    62,    63,    64,
/*  64 */    65,    66,    69,    68,     0,     0,    71,    72,
/*  72 */    73,    74,    75,    76,     0,    78,    79,    80,
/*  80 */    81,    82,    83,     0,    85,    86,    87,    88,
/*  88 */     0,    90,     0,    92,    93,    94,    95,     0,
/*  96 */    97,    98,    99,   100,   101,   102,     0,   104,
/* 104 */   105,   106,   107,   108,   109,   110,   111,   112,
/* 112 */   113,   114,   115,   116,   117,   118,   119,   120,
/* 120 */   121,   122,   123,   124,     0,   126,   127,   128,
/* 128 */   129,   130,   131,   132,   133,     0,   135,     0,
/* 136 */   137,   138,   139,   140,   141,     0,   143,     0,
/* 144 */   145,   146,   147,   148,   149,   150,   153,   152,
/* 152 */   154,     0,     0,   156,     0,   158,     0,   160,
/* 160 */   161,     0,   163,   164,   165,   166,   167,   168,
/* 168 */   169,   170,   171,   172,     0,   174,     0,   176,
/* 176 */   177,   178,     0,   180,   181,   182,   183,   184,
/* 184 */   185,   186,   187,   188,     0,   190,   191,   192,
/* 192 */   193,   194,   195,   196,     0,   198,   199,   200,
/* 200 */   201,   202,   203,   204,     0,   206,     0,   208,
/* 208 */   209,   210,   211,   212,     0,   214,   215,   216,
/* 216 */   217,   218,   219,     0,   221,     0,   223,     0,
/* 224 */   225,   226,     0,   228,     0,   230,     0,   232,
/* 232 */   233,   239,   235,   236,     0,   238,   240,   241,
/* 240 */   242,   243,   244,   245,   246,   247,   249,   248,
/* 248 */     0,     0,   251,     0,   253,     0,   255,     0,
/* 256 */   257,   258,     0,   260,     0,   262,     0,   264,
/* 264 */     0,   266,   267,   268,   269,     0,   271,     0,
/* 272 */   273,   274,   275,   276,     0,   278,   279,   280,
/* 280 */   281,     0,   283,   284,     0,   286,   287,   288,
/* 288 */   289,     0,   291,   292,   293,   294,   295,   296,
/* 296 */   297,     0,   299,     0,   301,     0,   303,   306,
/* 304 */   305,     0,     0,   308,   309,     0,   311,   312,
/* 312 */   313,   314,     0,   316,     0,   318,   319,     0,
/* 320 */   321,   322,   323,     0,   325,     0,   327,     0,
/* 328 */   329,   330,   331,   332,   333,   334,   335,   336,
/* 336 */   337,   338,   339,   340,   341,   342,   343,   344,
/* 344 */   349,   346,     0,   348,     0,   350,   351,   352,
/* 352 */   353,   354,   355,   356,   357,   358,   359,   360,
/* 360 */   361,   362,   363,   364,   365,   366,   367,   368,
/* 368 */     0,   370,   371,   372,   373,   374,   375,   376,
/* 376 */   377,   378,   379,   380,   381,   382,   383,   384,
/* 384 */   385,   386,   387,   388,   389,   390,   391,   392,
/* 392 */   393,   394,   395,   396,   397,   398,   400,     0,
/* 400 */   401,   402,   403,     0,   405,     0,   407,   408,
/* 408 */   409,   410,   411,     0,   413,     0,   415,   416,
/* 416 */     0,   418,   419,   420,   421,   422,   423,   424,
/* 424 */     0,   426,     0,   428,   429,     0,   431,   432,
/* 432 */   433,   437,   435,   436,     0,   438,   439,   440,
/* 440 */   441,   442,     0,   444,     0,   446,   447,   448,
/* 448 */   449,   450,     0,   452,   453,   454,     0,   456,
/* 456 */     0,   458,   459,   460,   461,   462,   463,   464,
/* 464 */   465,   466,   467,   468,   469,   470,   471,   472,
/* 472 */     0,   474,     0,   476,     0,   478,     0,   480,
/* 480 */     0
} ; 

const U16 SLH [] = {
/*   0 */     0,     1,     2,     0,     3,     4,     5,     6,
/*   8 */     8,     9,    10,    11,    12,    13,    14,    15,
/*  16 */    16,    17,    18,    19,    20,    21,    22,    23,
/*  24 */    49,    50,    51,    52,    54,    55,    56,    57,
/*  32 */    58,    59,    61,    62,    64,    65,    66,    67,
/*  40 */    68,    69,    70,    76,    77,    78,    79,    80,
/*  48 */    81,    82,    83,    84,    85,    86,    87,    88,
/*  56 */    89,    90,    92,    93,    94,    95,    96,    97,
/*  64 */    98,   100,   101,    98,   102,   103,   105,   106,
/*  72 */   109,   110,   111,   112,   113,   116,   117,   118,
/*  80 */   119,   120,   121,   122,   125,   126,   127,   128,
/*  88 */   129,   131,   132,   139,   140,   141,   142,   143,
/*  96 */   145,   146,   147,   148,   149,   150,   151,   152,
/* 104 */   153,   154,   155,   156,   157,   158,   159,   160,
/* 112 */   161,   162,   163,   164,   165,   166,   167,   168,
/* 120 */   169,   170,   171,   172,   173,   174,   175,   176,
/* 128 */   177,   178,   179,   180,   181,   182,   184,   185,
/* 136 */   186,   187,   188,   189,   190,   191,   192,   193,
/* 144 */   195,   196,   197,   198,   199,   200,   201,   195,
/* 152 */   201,   202,   202,   203,   204,   205,   206,   207,
/* 160 */   208,   209,   212,   213,   214,   215,   216,   217,
/* 168 */   218,   219,   220,   221,   222,   225,   226,   227,
/* 176 */   228,   229,   230,   232,   233,   234,   235,   236,
/* 184 */   237,   238,   239,   240,   241,   244,   245,   246,
/* 192 */   247,   248,   249,   250,   251,   252,   253,   254,
/* 200 */   255,   256,   257,   259,   260,   258,   260,   262,
/* 208 */   263,   265,   266,   267,   268,   270,   271,   272,
/* 216 */   273,   274,   275,   276,   277,   278,   279,   280,
/* 224 */   281,   282,   283,   281,   283,   287,   288,   291,
/* 232 */   292,   293,   294,   295,   296,   290,   297,   297,
/* 240 */   298,   298,   299,   299,   300,   300,   301,   301,
/* 248 */   302,   302,   303,   304,   305,   306,   307,   308,
/* 256 */   310,   311,   312,   313,   314,   315,   316,   319,
/* 264 */   321,   322,   323,   324,   325,   326,   328,   330,
/* 272 */   331,   332,   333,   334,   335,   337,   338,   340,
/* 280 */   341,   342,   343,   344,   345,   347,   348,   349,
/* 288 */   350,   351,   352,   353,   354,   355,   356,   357,
/* 296 */   358,   359,   361,   362,   361,   362,   318,   363,
/* 304 */   363,   364,   364,   368,   369,   370,   372,   373,
/* 312 */   374,   375,   376,   378,   379,   380,   381,   382,
/* 320 */   383,   384,   385,   386,   387,   388,   390,   391,
/* 328 */   392,   393,   394,   395,   396,   397,   399,   400,
/* 336 */   401,   402,   403,   404,   405,   406,   407,   408,
/* 344 */   409,   410,   411,   413,   414,   415,   416,   417,
/* 352 */   418,   419,   420,   421,   422,   423,   424,   425,
/* 360 */   426,   427,   428,   429,   430,   432,   433,   434,
/* 368 */   435,   436,   437,   439,   440,   441,   442,   443,
/* 376 */   444,   445,   446,   447,   448,   449,   450,   451,
/* 384 */   452,   453,   455,   456,   457,   459,   460,   461,
/* 392 */   462,   463,   464,   465,   466,   469,   470,   471,
/* 400 */   472,   473,   474,   475,   476,   477,   480,   481,
/* 408 */   482,   483,   484,   485,   481,   485,   486,   487,
/* 416 */   488,   490,   491,   492,   493,   494,   495,   496,
/* 424 */   497,   498,   499,   500,   501,   502,   503,   504,
/* 432 */   505,   506,   507,   508,   509,   510,   511,   512,
/* 440 */   513,   514,   515,   518,   519,   520,   521,   522,
/* 448 */   523,   524,   525,   527,   528,   530,   531,   536,
/* 456 */   538,   539,   540,   541,   542,   543,   544,   545,
/* 464 */   546,   547,   548,   549,   550,   551,   552,   553,
/* 472 */   554,   558,   559,   563,   564,   565,   566,   567,
/* 480 */   568
} ; 

const signed char CtG [] = {
/*   0 */   0,  -1,  -1,  -1,  -1,  -1,  -1,  -1,
/*   8 */  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,
/*  16 */  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,
/*  24 */  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,
/*  32 */  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,
/*  40 */  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,
/*  48 */  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,
/*  56 */  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,
/*  64 */  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,
/*  72 */  -1,  -1,  -1,  -1,  -1,  -1,  -1,   0,
/*  80 */  -1,  -1,  -1,  -1,  -1,  -1,  -1,   0,
/*  88 */  -1,   0,  -1,  -1,  -1,  -1,  -1,  -1,
/*  96 */   1,   0,  32,  37,  -1,  -1,  -1,  -1,
/* 104 */  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,
/* 112 */  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,
/* 120 */  -1,  -1,  -1,  -1,  -1,  -1,   0,  -1,
/* 128 */  -1,   0,   0,   0,  -1,  -1,  -1,  -1,
/* 136 */  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,
/* 144 */  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,
/* 152 */  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,
/* 160 */   0,  -1,  -1,  -1,  -1,  -1,  -1,  -1,
/* 168 */  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,
/* 176 */  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,
/* 184 */  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,
/* 192 */  -1,  -1,  -1,  -1,  -1,   0,   0,  -1,
/* 200 */  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,
/* 208 */  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,
/* 216 */  -1,   0,  -1,  -1,  -1,  -1,  -1,  -1,
/* 224 */  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,
/* 232 */  -1,  -1,  -1,   0,  -1,  -1,  -1,  -1,
/* 240 */  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,
/* 248 */  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,
/* 256 */  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,
/* 264 */  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,
/* 272 */  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,
/* 280 */  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,
/* 288 */  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,
/* 296 */  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,
/* 304 */  -1,  -1,  -1,  -1,  -1,  -1,   0,  -1,
/* 312 */  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,
/* 320 */  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,
/* 328 */  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,
/* 336 */  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,
/* 344 */  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,
/* 352 */  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,
/* 360 */  -1,  -1,  -1,   0,   0,  -1,  -1,  -1,
/* 368 */  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,
/* 376 */  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,
/* 384 */  -1,  -1,  43,  -1,  -1,  -1,  -1,  -1,
/* 392 */  -1,  -1,  -1,  12,   1,  -1,  -1,   0,
/* 400 */   0,  -1,  -1,  -1,  -1,  -1,  -1,  -1,
/* 408 */  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,
/* 416 */  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,
/* 424 */  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,
/* 432 */  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,
/* 440 */   0,  -1,  -1,  -1,  -1,  -1,  -1,  -1,
/* 448 */  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,
/* 456 */  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,
/* 464 */  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,
/* 472 */  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,
/* 480 */  -1
} ; 

const U16 TabBasePG [] = {
/*   0 */   143,   287,   431,   575,   719
} ; 

const U16 Aid [] = {
/*   0 */     0,     0,     0,     0,     0,     0,     0,     0,
/*   8 */     0,     0,     0,     0,     0,     0,     0,     0,
/*  16 */     0,     0,     0,     0,     0,     0,     0,     0,
/*  24 */     0,     0,     0,     0,     0,     0,     0,     0,
/*  32 */     0,     0,     0,     0,     0,     0,     0,     0,
/*  40 */     0,     0,     0,     0,     0,     0,     0,     0,
/*  48 */     0,     0,     0,     0,     0,     0,     0,     0,
/*  56 */     0,     0,     0,     0,     0,     0,     0,     0,
/*  64 */     0,     0,     0,     0,     0,     0,     0,     0,
/*  72 */     0,     0,     0,     0,     0,     0,     0,     0,
/*  80 */     0,     0,     0,     0,     0,     0,     0,     0,
/*  88 */     0,     0,     0,     0,     0,     0,     0,     0,
/*  96 */     0,     0,     0,     0,     0,     0,     0,     0,
/* 104 */     0,     0,     0,     0,     0,     0,     0,     0,
/* 112 */     0,     0,     0,     0,     0,     0,     0,     0,
/* 120 */     0,     0,     0,     0,     0,     0,     0,     0,
/* 128 */     0,     0,     0,     0,     0,     0,     0,     0,
/* 136 */     0,     0,     0,     0,     0,     0,     0,     0,
/* 144 */     0,     0,     0,     0,     0,     0,     0,     0,
/* 152 */     0,     0,     0,     0,     0,     0,     0,     0,
/* 160 */     0,     0,     0,     0,     0,     0,     0,     0,
/* 168 */     0,     0,     0,     0,     0,     0,     0,     0,
/* 176 */     0,     0,     0,     0,     0,     0,     0,     0,
/* 184 */     0,     0,     0,     0,     0,     0,     0,     0,
/* 192 */     0,     0,     0,     0,     0,     0,     0,     0,
/* 200 */     0,     0,     0,     0,     0,     0,     0,     0,
/* 208 */     0,     0,     0,     0,     0,     0,     0,     0,
/* 216 */     0,     0,     0,     0,     0,     0,     0,     0,
/* 224 */     0,     0,     0,     0,     0,     0,   695,     0,
/* 232 */     0,     0,     1,     0,     0,     0,     0,     0,
/* 240 */     0,     0,     0,   172,   169,   175,   523,   326,
/* 248 */   329,   332,   335,   406,   385,   540,   543,   659,
/* 256 */   662,   644,   114,    22,   362,   178,   629,   106,
/* 264 */   215,    34,    38,    16,    44,    48,     4,    55,
/* 272 */    59,    63,    67,    10,     0,    74,    78,    82,
/* 280 */    86,    90,    94,    98,   102,   110,     0,     0,
/* 288 */     0,     0,     0,     0,   718,     0,     0,     0,
/* 296 */     0,     0,     0,     0,     0,     0,     0,     0,
/* 304 */     0,     0,     0,     0,     0,   728,     0,     0,
/* 312 */     0,     0,   734,     0,     0,   747,     0,     0,
/* 320 */     0,     0,   731,     0,     0,     0,     0,     0,
/* 328 */     0,     0,     0,     0,     0,     0,     0,     0,
/* 336 */     0,     0,     0,     0,     0,     0,     0,     0,
/* 344 */     0,     0,     0,     0,     0,     0,     0,     0,
/* 352 */     0,     0,     0,     0,     0,     0,     0,     0,
/* 360 */     0,     0,     0,     0,     0,     0,     0,     0,
/* 368 */     0,     0,     0,     0,     0,     0,   739,     0,
/* 376 */     0,     0,   701,   744,     0,     0,     0,     0,
/* 384 */     0,     0,     0,     0,     0,     0,     0,     0,
/* 392 */     0,     0,     0,     0,     0,     0,     0,     0,
/* 400 */     0,     0,     0,     0,     0,     0,     0,     0,
/* 408 */     0,     0,     0,     0,     0,     0,     0,     0,
/* 416 */     0,     0,     0,     0,     0,     0,     0,     0,
/* 424 */     0,     0,     0,     0,     0,     0,   698,     0,
/* 432 */     0,     0,   750,     0,     0,     0,     0,     0,
/* 440 */     0,     0,   756,   753,     0,     0,     0,     0,
/* 448 */     0,     0,     0,     0,     0,     0,     0,     0,
/* 456 */     0,     0,     0,     0,     0,     0,     0,     0,
/* 464 */     0,     0,     0,     0,     0,     0,     0,     0,
/* 472 */     0,     0,     0,     0,     0,     0,     0,     0,
/* 480 */     0,     0,     0,     0,     0,     0,     0,     0,
/* 488 */     0,     0,     0,     0,     0,     0,     0,     0,
/* 496 */     0,     0,     0,     0,     0,     0,     0,     0,
/* 504 */     0,     0,     0,     0,     0,     0,     0,     0,
/* 512 */     0,     0,     0,     0,     0,     0,     0,     0,
/* 520 */     0,     0,     0,     0,     0,     0,     0,     0,
/* 528 */     0,     0,     0,     0,     0,     0,     0,     0,
/* 536 */     0,     0,     0,     0,     0,     0,     0,     0,
/* 544 */     0,     0,     0,     0,     0,     0,     0,     0,
/* 552 */     0,     0,     0,     0,     0,     0,     0,     0,
/* 560 */     0,     0,     0,     0,     0,     0,     0,     0,
/* 568 */     0,     0,     0,     0,     0,     0,     0,     0,
/* 576 */     0,     0,     0,     0,     0,     0,     0,     0,
/* 584 */     0,     0,     0,     0,     0,     0,     0,     0,
/* 592 */     0,     0,     0,     0,     0,     0,     0,     0,
/* 600 */     0,     0,     0,     0,     0,     0,     0,     0,
/* 608 */     0,     0,     0,     0,     0,     0,     0,   890,
/* 616 */   902,   914,   932,   950,   962,   968,   893,   896,
/* 624 */     0,   899,   905,   908,   911,   917,   920,   923,
/* 632 */   926,   929,   935,   938,   941,   944,   947,   953,
/* 640 */   956,   959,   965,     0,     0,     0,     0,     0,
/* 648 */     0,     0,     0,     0,     0,   872,     0,     0,
/* 656 */     0,   878,     0,     0,   863,   866,   884,   869,
/* 664 */     0,   875,   881,   887,     0,     0,     0,     0,
/* 672 */     0,     0,     0,     0,     0,     0,     0,     0,
/* 680 */     0,     0,     0,     0,     0,     0,     0,     0,
/* 688 */     0,     0,   759,   775,   791,   815,   839,   855,
/* 696 */     0,   763,   767,   771,   779,   783,   787,   795,
/* 704 */   799,   803,   807,   811,     0,   819,   823,   827,
/* 712 */   831,   835,   843,   847,   851,   859,     0,     0,
/* 720 */     0,   971,     0,   974,     0,   977,   980,     0,
/* 728 */     0,   983,     0,     0,     0,     0,     0,   995,
/* 736 */     0,     0,     0,   992,   989,   986,     0,     0,
/* 744 */     0,     0,     0,     0,     0,     0,     0,     0,
/* 752 */     0,     0,     0,     0,     0,     0,     0,     0,
/* 760 */     0,     0,     0,     0,     0,     0,     0,     0,
/* 768 */     0,     0,     0,     0,     0,     0,     0,     0,
/* 776 */     0,     0,     0,     0,     0,     0,     0,     0,
/* 784 */     0,     0,     0,     0,     0,     0,     0,     0,
/* 792 */     0,     0,     0,     0,     0,     0,     0,     0,
/* 800 */     0,     0,     0,     0,     0,     0,     0,     0,
/* 808 */     0,     0,   998,     0,     0,     0,     0,     0,
/* 816 */     0,     0,     0,     0,     0,     0,     0,     0,
/* 824 */     0,     0,     0,     0,     0,     0,     0,     0,
/* 832 */     0,     0,     0,     0,     0,     0,     0,     0,
/* 840 */     0,     0,     0,     0,     0,     0,     0,     0,
/* 848 */     0,     0,     0,     0,     0,     0,     0,     0,
/* 856 */     0,     0,     0,     0,     0,     0,     0
} ; 

const U8 ChPD [] = {
/*   0 */   0,   1,  91,   5, 139, 117, 132, 126,
/*   8 */ 138,   4, 123, 116, 132, 138,   2, 119,
/*  16 */ 132,   4,  29,  21,   8,  35,   4, 124,
/*  24 */ 117, 141,  91,   6, 124, 117, 141,  91,
/*  32 */  92,  91,   4,  35,  21,   8,  35,   6,
/*  40 */ 139, 117, 132, 126, 138,  91,   8, 139,
/*  48 */ 117, 132, 126, 138,  91,  92,  91,   2,
/*  56 */  91,  29,   5,  91, 118, 136, 116, 137,
/*  64 */   3, 116, 138,  91,   5,  91, 137, 115,
/*  72 */ 132, 137,   6,  91, 138, 116, 131, 134,
/*  80 */ 137,   3, 116, 132,  91,   2,  91,  35,
/*  88 */   5,  91, 138, 118, 119, 138,   2, 100,
/*  96 */  91,   3, 118, 119,  91,   3, 118, 112,
/* 104 */  91,   3, 118, 119, 117,   3, 118, 132,
/* 112 */ 142,   3,  38,  10,  28,   1,  29,   1,
/* 120 */  27,   1,  35,   1,  38,   1,  92,   1,
/* 128 */ 127,   2,  91,  38,   4,  91, 132, 118,
/* 136 */ 136,   1,  31,   3,  91, 137, 119,   2,
/* 144 */   3,  35,   1, 100,   3, 117, 130,  91,
/* 152 */   5, 116, 130, 130, 116,  91,   3, 118,
/* 160 */ 132,  91,   3,   3,  27,  35,   1, 120,
/* 168 */   1, 138,   2, 132, 138,   1, 124,   2,
/* 176 */ 132, 124,   3, 116, 137, 138,   5, 118,
/* 184 */ 119, 116, 137, 138,   3, 118, 136, 138,
/* 192 */   3, 116, 136, 138,   3,  91, 116, 132,
/* 200 */   2,  30,   6,   2,  27,   6,   2,  31,
/* 208 */   6,   2,   3,  24,   2,  25,   6,   2,
/* 216 */   1,  23,   2,  25,   8,   2,  33,   1,
/* 224 */   2,   3,  18,   2,   3,  37,   2,   3,
/* 232 */  38,   2,  34,   6,   2,  33,  12,   2,
/* 240 */   3,  19,   2,   3,  27,   2,  35,   6,
/* 248 */   2,  28,   6,   7,  31,  11,  30,  18,
/* 256 */   5,  28,   6,   3,   8,  33,  27,   1,
/* 264 */   8,   3,  29,   3,  31,   1,  13,   2,
/* 272 */  91, 123,   2,   1,  22,   1,  14,   1,
/* 280 */ 143,   1, 125,   1, 137,   1,   3,   2,
/* 288 */   4,  18,   1, 122,   1, 123,   5, 127,
/* 296 */ 115, 132, 124, 122,   5, 125, 118, 118,
/* 304 */ 138, 122,   2,   1,  37,   1, 131,   2,
/* 312 */ 134, 137,   1,   1,   1, 132,   2,   1,
/* 320 */  38,   1, 134,   2, 132, 116,   1,  11,
/* 328 */   2,  91, 137,   5,  91, 124, 116, 137,
/* 336 */ 137,   1, 130,   1,   9,   1, 136,   1,
/* 344 */   4,   2,   1,  28,   3, 137, 129, 117,
/* 352 */   2,   6,   8,   3, 115, 122, 122,   1,
/* 360 */ 116,   2, 116, 132,   2, 116,  91,   2,
/* 368 */   3,  22,   1,   2,   1,   6,   1,  15,
/* 376 */   1,  34,   2,  91, 115,   2,  91, 118,
/* 384 */   1,  30,   1,  33,   2, 115, 117,   3,
/* 392 */ 115, 138, 117,   3, 104, 116, 132,   3,
/* 400 */ 104, 131, 104,   2, 105, 132,   2, 104,
/* 408 */ 136,   4, 117, 130, 130, 104,   2, 118,
/* 416 */ 130,   2, 118, 132,   2, 118, 136,   3,
/* 424 */  91, 115, 136,   2, 115, 109,   2, 115,
/* 432 */ 132,   1, 118,   2, 104, 126,   2, 104,
/* 440 */ 118,   2, 104, 138,   5,  91, 122, 136,
/* 448 */ 118, 132,   5,  91, 123, 115, 138, 104,
/* 456 */   1, 119,   4, 118, 132, 124, 136,   2,
/* 464 */  91, 104,   3, 104, 132, 104,   5, 116,
/* 472 */ 132, 116, 117, 137,   2, 117, 124,   3,
/* 480 */ 117, 132, 117,   3, 117, 132, 118,   4,
/* 488 */ 117, 119, 136, 117,   2, 118, 109,   3,
/* 496 */ 118, 134, 136,   4, 118, 137, 118, 132,
/* 504 */   2, 118, 138,   2, 118, 131,   2, 118,
/* 512 */ 126,   3,  91, 131, 115,   2, 117, 115,
/* 520 */   3, 115, 118, 132,   3, 134, 137, 120,
/* 528 */   1, 115,   1, 104,   2, 134, 115,   2,
/* 536 */ 117, 142,   3, 118, 118, 130,   3,  91,
/* 544 */ 138, 115,   2, 117, 132,   4, 117, 137,
/* 552 */ 138, 118,   3, 117, 137, 123,   4,  35,
/* 560 */  19,   1,  33,   4, 116, 132, 124, 118,
/* 568 */   4, 134, 104, 136, 117,   2, 104, 115,
/* 576 */   2, 104, 117,   2, 104, 130,   1,  23,
/* 584 */   4,  91, 138, 136, 117,   3, 117, 116,
/* 592 */ 142,   4, 117, 118, 132, 137,   3, 118,
/* 600 */ 132, 137,   1, 117,   4,  91, 138, 136,
/* 608 */ 118,   2, 117, 130,   2, 117, 138,   2,
/* 616 */ 117, 125,   3, 118, 134, 127,   3, 118,
/* 624 */ 137, 134,   3, 118, 138, 136,   4, 115,
/* 632 */ 132, 138, 117,   5, 127, 120, 134, 116,
/* 640 */ 136,   2, 117,  91,   4, 115, 123, 136,
/* 648 */ 118,   3, 129, 136, 115,   4, 131, 115,
/* 656 */ 132, 115,   6, 123, 136, 118, 131, 130,
/* 664 */ 116,   3,  91, 138, 116,   4, 139, 115,
/* 672 */ 136, 116,   4, 130, 115, 137, 137,   3,
/* 680 */ 130, 116, 119,   3, 130, 117, 132,   2,
/* 688 */ 132, 118,   2, 139, 115,   2,  33,   4,
/* 696 */   2, 116, 125,   2, 116, 136,   2, 116,
/* 704 */ 141,   1,  32,   2, 137, 116,   2,  91,
/* 712 */ 116,   2, 142, 104,   2, 134, 116,   1,
/* 720 */ 111,   3, 115, 118, 119,   2, 115, 130,
/* 728 */   2, 118, 119,   2, 124, 136,   2, 137,
/* 736 */ 138,   2, 122, 136,   1, 129,   2,   6,
/* 744 */   1,   2, 123, 136,   2, 123, 127,   3,
/* 752 */ 123,  87, 127,   2, 134, 117,   2, 137,
/* 760 */ 117,   3,  91, 123, 130,   3,   1,  37,
/* 768 */  13,   2,  91, 136,   3, 134, 116, 136,
/* 776 */   4,  91, 115, 134, 134,   2, 124, 117,
/* 784 */   2,  91, 122,   7,  91, 132, 117, 138,
/* 792 */ 136, 118, 122,   4,  91, 124, 104, 122,
/* 800 */   7, 115, 136, 137, 104, 132, 118, 122,
/* 808 */   7, 123, 127, 130, 118, 136, 118, 122,
/* 816 */   1, 142,   4, 126, 115, 130, 116,   4,
/* 824 */ 126, 115, 130, 117,   5, 128, 115, 131,
/* 832 */ 117, 132,   4, 128, 118, 117, 132,   3,
/* 840 */ 138, 127, 117,   3, 138, 127, 118,   4,
/* 848 */ 138, 118, 132, 117,   2,  91, 127,   2,
/* 856 */ 124, 104,   2,  91, 131,   2,  91, 134,
/* 864 */   3, 137, 119, 131,   2, 138, 115,   4,
/* 872 */ 138, 127, 117, 118,   2, 138, 118,   5,
/* 880 */ 138, 136, 117, 123,  91,   4, 137, 116,
/* 888 */ 123,  91,   5, 138, 127, 105, 137, 116,
/* 896 */   4, 132, 116, 131, 117,   3, 132, 104,
/* 904 */ 115,   4,  91, 137, 118, 130,   3, 132,
/* 912 */ 116, 130,   2, 132, 117,   2,  13,  38,
/* 920 */   4, 127, 115, 136, 131,   2, 127, 116,
/* 928 */   2, 127, 120,   1,  16,   3,  91, 115,
/* 936 */ 126,   4,  91, 115, 124, 124,   3,  91,
/* 944 */ 122, 130,   6,  91, 136, 104, 125, 104,
/* 952 */ 136,   3,  91, 137, 138,   5,  91, 134,
/* 960 */ 130, 115, 123,   4,  91, 131, 104, 131,
/* 968 */   4,  91, 131, 115, 126,   2,  91, 129,
/* 976 */   2,  91, 126,   8,  91, 123, 118, 132,
/* 984 */ 138, 136, 116, 137,   4,  91, 116, 132,
/* 992 */ 123,   3,  91, 115, 134,   4,  91, 124,
/* 1000 */ 104, 134,   2, 137,  91,   5,  91, 123,
/* 1008 */ 118, 132, 137,   6,  91, 134, 136, 116,
/* 1016 */ 137, 137,   5,  91, 136, 116, 137, 137,
/* 1024 */   4,  91, 124, 104, 131,   4,  91, 136,
/* 1032 */ 116, 134,   4,  91, 123, 118, 119,   4,
/* 1040 */ 116, 141, 115, 131,   3, 138, 118,  91,
/* 1048 */   3, 124, 118,  91,   3, 123, 118,  91,
/* 1056 */   4,  91, 137, 119, 134,   4,  91, 127,
/* 1064 */ 120, 134,   3, 116, 137,  91,   4, 117,
/* 1072 */ 137, 123, 127,   3, 117, 137, 127,   4,
/* 1080 */ 140, 117, 130, 130,   3, 131, 115, 120,
/* 1088 */   2,  10,  19,   5,  37,   3,  27,  22,
/* 1096 */   7,   2, 115, 120,   2, 119, 120,   4,
/* 1104 */ 119, 137, 123, 117,   2, 119, 117,   3,
/* 1112 */ 119, 117, 137,   3, 119, 117, 116,   2,
/* 1120 */   5,  27,   4, 138, 136, 119, 123,   1,
/* 1128 */   5,   4, 137, 118, 119, 137,   3, 137,
/* 1136 */ 119, 137,   3, 123, 116, 132,   6,  91,
/* 1144 */ 100,  91, 130,  87,  91,   3,  91,  92,
/* 1152 */  91,   1,  12,   1, 126,   2, 136, 116,
/* 1160 */   1,   7,   2,  91, 132,   2,  91, 139,
/* 1168 */   3,  91, 115, 139,   2, 138, 136,   1,
/* 1176 */  10,   1, 139,   2,   3,  28,   2,  22,
/* 1184 */  11,   2,   3,  29,   6,  91, 131, 116,
/* 1192 */ 136, 126, 119,   2,  91, 125,   3, 126,
/* 1200 */ 118, 131,   5, 137, 115, 132, 123, 127,
/* 1208 */   3, 130, 118, 134,   1,  25,   2, 118,
/* 1216 */ 117,   3, 130, 130, 116,   2, 130, 130,
/* 1224 */   2, 136, 136,   1, 141,   2, 126, 131,
/* 1232 */   2, 116, 138,   3, 136, 117, 116,   4,
/* 1240 */ 132, 105, 137, 116,   3, 137, 137, 116,
/* 1248 */   2, 137, 137,   3, 132, 116, 136,   3,
/* 1256 */ 123, 116, 136,   3, 132, 116, 119,   1,
/* 1264 */  24,   1, 101,   1, 110,   2,  32,  38,
/* 1272 */   3, 118, 137, 116,   3, 118, 137, 117,
/* 1280 */   2, 115, 138,   2, 118, 137,   2, 119,
/* 1288 */ 137,   2,  91, 117,   2, 123, 118,   3,
/* 1296 */ 115, 134, 127,   3, 115, 138, 127,   2,
/* 1304 */ 116, 117,   1, 105,   2, 110, 138,   3,
/* 1312 */ 124, 117, 115,   5,  91, 122, 118, 119,
/* 1320 */ 136,   1,  36,   2,  32,  10,   2,  32,
/* 1328 */  12,   2, 117, 137,   2,  32,  21,   3,
/* 1336 */ 116, 136,  91,   3, 116, 142,  91,   2,
/* 1344 */  32,  20,   3,  91, 128, 115,   1, 109,
/* 1352 */   1, 107,   4, 122, 118, 119, 136,   3,
/* 1360 */ 130, 118, 132,   3, 118, 119, 136,   1,
/* 1368 */ 128,   3, 115, 131, 120,   2,  32,  25,
/* 1376 */   2, 137, 119,   3,   8,  22,  13,   2,
/* 1384 */ 123, 130,   2,  22,  13,   3, 124, 104,
/* 1392 */ 139,   3, 116, 132, 139,   5, 130, 117,
/* 1400 */ 141, 117, 139,   3, 118, 122, 139,   6,
/* 1408 */ 115, 131, 132, 117, 137, 138,   4, 123,
/* 1416 */ 127, 101, 138,   2,  22,  14,   2, 138,
/* 1424 */  91,   2,   8,  22,   2,   8,  18,   3,
/* 1432 */ 134, 115, 134,   2, 135, 119,   2, 126,
/* 1440 */ 119,   1,  22,   2, 134, 127,   4, 126,
/* 1448 */ 116, 132, 138,   4, 131, 115, 132, 126,
/* 1456 */   4, 131, 115, 132, 135,   2,   8,  39,
/* 1464 */   2,   8,  38,   4,  14,  35,   3,  19,
/* 1472 */   4, 115, 117, 130, 130,   4,  91, 115,
/* 1480 */ 132, 138,   3, 115, 123, 117,   3, 115,
/* 1488 */ 123, 119,   3, 115, 119, 136,   3, 119,
/* 1496 */ 132, 117,   3, 118, 141, 120,   3, 118,
/* 1504 */ 139, 119,   2, 136, 115,   3, 136, 118,
/* 1512 */ 132,   3, 136, 116, 142,   5, 136, 117,
/* 1520 */ 118, 132, 137,   2,   8,   3,   3, 136,
/* 1528 */ 116,  91,   4, 136, 116, 137,  91,   2,
/* 1536 */ 116, 137,   3,  91, 126, 119,   3,  91,
/* 1544 */ 135, 119,   3,  91, 125, 117,   2, 115,
/* 1552 */ 119,   3,  91, 115, 119,   4,  91, 137,
/* 1560 */ 115, 119,   1,  18,   1,  37,   2,  20,
/* 1568 */   1,   2, 126, 132,   2,  20,  14,   2,
/* 1576 */   9,  37,   2,   4,  37,   4,   5,  27,
/* 1584 */  22,   7,   2,   9,  38,   3,   9,  38,
/* 1592 */  92,   3, 115, 130, 123,   2,   9,   9,
/* 1600 */   2, 134, 104,   3, 134, 105, 136,   2,
/* 1608 */ 134, 138,   2, 136, 124,   3, 122, 130,
/* 1616 */ 117,   3, 123, 123, 119,   5,  91, 131,
/* 1624 */ 117, 123, 136,   4,  91, 117, 132, 123,
/* 1632 */   1,  20,   2,   1,  11,   2,   9,  28,
/* 1640 */   4, 137, 129, 117,  91,   4, 137, 129,
/* 1648 */ 115,  91,   2,   9,  22,   5,  91, 123,
/* 1656 */ 115, 123, 115,   4,  91, 123, 115, 130,
/* 1664 */   4,  91, 115, 136, 136,   4,  91, 137,
/* 1672 */ 115, 131,   3,  20,   1,  22,   4, 138,
/* 1680 */ 117, 118, 132,   2, 126, 136,   2,  91,
/* 1688 */ 142,   4,  91, 115, 131, 115,   3, 117,
/* 1696 */ 132, 123,   4, 116, 141, 116, 131,   3,
/* 1704 */ 136, 118, 131,   3,  91, 137, 116,   3,
/* 1712 */ 115, 117, 132,   2, 117, 105,   2,  34,
/* 1720 */  27,   4,   6,  33,  20,   1,   3,  91,
/* 1728 */ 115, 124,   3,  91, 117, 132,   5,  91,
/* 1736 */ 117, 132, 115, 124,   4,  91, 134, 104,
/* 1744 */ 136,   3,  91, 123, 118,   4,  91, 137,
/* 1752 */ 119, 122,   5, 124, 136, 117, 130, 130,
/* 1760 */   3,  33,  20,   1,   3, 138, 116, 136,
/* 1768 */   3, 124, 136, 115,   3, 124, 136, 119,
/* 1776 */   3, 136, 138, 116,   3, 136, 138, 142,
/* 1784 */   3, 124, 136, 117,   3,  33,  21,   8,
/* 1792 */   3, 119, 122, 117,   4, 118, 122, 130,
/* 1800 */ 117,   4, 124, 117, 137, 138,   3, 130,
/* 1808 */ 115, 138,   3, 131, 118, 130,   3, 131,
/* 1816 */ 119, 130,   3, 134, 115, 136,   3, 134,
/* 1824 */ 118, 130,   3, 134, 118, 138,   3, 134,
/* 1832 */ 136, 118,   2, 137, 104,   2,  33,  20,
/* 1840 */   4,  91, 124, 116, 137,   2, 117, 123,
/* 1848 */   2,  33,  21,   4, 116, 137, 138, 115,
/* 1856 */   4, 117, 132, 124, 104,   4, 117, 132,
/* 1864 */ 138, 117,   3,  91, 126, 115,   1,  19,
/* 1872 */   2, 116, 130,   3, 117, 115, 124,   3,
/* 1880 */ 117, 115, 132,   3, 117, 115, 136,   3,
/* 1888 */ 117, 115, 138,   2, 117, 116,   3,  91,
/* 1896 */ 122, 117,   2, 116, 115,   3, 134, 136,
/* 1904 */ 104,   2, 115, 126,   2, 119, 131,   2,
/* 1912 */ 119, 136,   4, 134, 115, 136, 115,   2,
/* 1920 */   4,  29,   3, 117, 138, 104,   3, 117,
/* 1928 */ 124, 116,   3, 117, 137,  91,   3,  91,
/* 1936 */ 115, 130,   4,  91, 122, 115, 130,   3,
/* 1944 */  91, 124, 104,   4, 115, 123, 136, 115,
/* 1952 */   4, 115, 138, 116, 130,   3, 104, 126,
/* 1960 */ 136,   4, 116, 132, 137, 117,   3, 117,
/* 1968 */ 130, 117,   3, 118, 130, 117,   3, 118,
/* 1976 */ 136, 134,   3, 119, 122, 128,   2, 119,
/* 1984 */ 116,   2, 119, 104,   2, 119, 105,   2,
/* 1992 */ 119, 130,   2, 120, 132,   3,  91, 124,
/* 2000 */ 120,   3, 116, 132, 138,   3,  91, 130,
/* 2008 */ 116,   3,  91, 124, 116,   3, 124, 117,
/* 2016 */ 138,   4, 135, 119, 116, 130,   4, 127,
/* 2024 */ 115, 120, 116,   5, 130, 118, 126, 116,
/* 2032 */ 137,   7, 131, 118, 119, 130, 117, 132,
/* 2040 */ 137,   3,  91, 131, 116,   6, 134, 137,
/* 2048 */ 120, 123, 127, 118,   3,  91, 136, 104,
/* 2056 */   3, 116, 123, 138,   3, 104, 135, 119,
/* 2064 */   3, 117, 132, 126,   3, 117, 134, 117,
/* 2072 */   2,  27,  33,   3, 117, 142, 118,   2,
/* 2080 */ 125, 115,   4, 138, 136, 115, 132,   3,
/* 2088 */ 122, 118, 132,   3, 137, 119, 122,   4,
/* 2096 */  91, 128, 116, 136,   2, 116, 120,   3,
/* 2104 */ 117, 115, 117,   3, 115, 123, 138,   3,
/* 2112 */ 115, 125, 136,   3, 115, 130, 134,   4,
/* 2120 */ 118, 123, 104, 115,   3, 115, 132, 132,
/* 2128 */   3, 118, 131, 117,   4,  91, 138, 118,
/* 2136 */ 119,   4,  91, 130, 116, 137,   5,  91,
/* 2144 */ 123, 116, 119, 141,   5,  91, 124, 116,
/* 2152 */ 119, 141,   4, 132, 116, 130,  91,   5,
/* 2160 */ 132, 117, 116, 136,  91,   4, 132, 117,
/* 2168 */ 130,  91,   5, 132, 115, 136, 124,  91,
/* 2176 */   3, 132, 116,  91,   4, 132, 116, 137,
/* 2184 */  91,   3, 132, 104,  91,   3, 130, 116,
/* 2192 */  91,   5, 132, 115, 117, 116,  91,   5,
/* 2200 */ 132, 115, 117, 137,  91,   3, 124, 120,
/* 2208 */ 137,   3, 122, 117, 137,   4,  91, 127,
/* 2216 */ 115, 119,   4,  91, 131, 118, 132,   4,
/* 2224 */ 136, 104, 115, 130,   2, 115, 137,   6,
/* 2232 */  91, 122, 115, 130, 122, 119,   9,  91,
/* 2240 */ 124, 117, 125, 125, 104, 136, 116, 132,
/* 2248 */   4,  91, 117, 132, 117,   2, 139, 116,
/* 2256 */   5, 117, 118, 132, 137,  91,   1, 106,
/* 2264 */   1, 113,   4,  91, 122, 136, 119,   3,
/* 2272 */  91, 123, 115,   3,  91, 126, 101,   4,
/* 2280 */ 117, 118, 132,  91,   4, 117, 118, 132,
/* 2288 */ 132,   3, 117, 118, 132,   4,  91, 125,
/* 2296 */ 118, 136,   4,  91, 126, 136, 115,   3,
/* 2304 */  91, 134, 104,   3,  91, 136, 115,   4,
/* 2312 */  91, 137, 134, 115,   2, 117, 118,   5,
/* 2320 */ 117, 118, 132, 115, 130,   5, 117, 118,
/* 2328 */ 132, 115, 119,   6, 117, 118, 131, 105,
/* 2336 */ 138, 136,   7, 117, 118, 132, 117, 137,
/* 2344 */ 131, 116,   7, 117, 118, 132, 115, 136,
/* 2352 */ 117, 137,   3,  27,  22,   1,   3, 135,
/* 2360 */ 119, 118,   5, 131, 116, 132, 138,  91,
/* 2368 */   3,  27,  22,  13,   5,  91, 117, 132,
/* 2376 */ 137, 115,   3,  91, 137, 115,   2, 115,
/* 2384 */ 136,   7, 137, 119, 122, 137, 138, 115,
/* 2392 */ 132,   3, 137, 138, 117,   7, 115, 137,
/* 2400 */ 137, 119, 136, 115, 132,   3, 117, 116,
/* 2408 */ 130,   4, 117, 116, 119, 141,   5, 117,
/* 2416 */ 116, 119, 137, 116,   3, 117, 119, 131,
/* 2424 */   3, 117, 116, 132,   5, 117, 116, 132,
/* 2432 */ 132, 116,   3, 117, 115, 130,   4, 117,
/* 2440 */ 115, 119, 141,   3,  21,   8,  22,   4,
/* 2448 */  91, 115, 123, 123,   3,  91, 115, 123,
/* 2456 */   4,  91, 122, 115, 123,   7,  91, 123,
/* 2464 */ 118, 136, 132, 116, 123,   4,  91, 123,
/* 2472 */ 119, 123,   6,  91, 138, 115, 134, 116,
/* 2480 */ 123,   5,  91, 134, 115, 136, 125,   3,
/* 2488 */ 122, 136, 115,   6, 122, 115, 136, 117,
/* 2496 */ 119, 131,   3, 139, 117, 136,   3, 131,
/* 2504 */ 119, 131,   5,  91, 123, 117, 136, 123,
/* 2512 */   5,  91, 131, 104, 124, 117,   5,  91,
/* 2520 */ 136, 115, 124, 117,   2, 123, 117,   2,
/* 2528 */ 123, 138,   2, 116, 119,   4, 117, 116,
/* 2536 */ 142,  91,   2, 125, 130,   3, 115, 132,
/* 2544 */ 138,   1,  21,   2, 122, 130,   2, 125,
/* 2552 */ 125,   1,  28,   3,  91, 124, 117,   5,
/* 2560 */  91, 137, 116, 134, 138,   5,  91, 132,
/* 2568 */ 116, 119, 125,   4,  91, 137, 118, 117,
/* 2576 */   2, 123, 120,   3,   3,  32,  29,   2,
/* 2584 */ 136, 104,   5, 115, 126, 104, 137, 117,
/* 2592 */   2,  32,  29,   4, 115, 132, 138, 127,
/* 2600 */   3,  91, 137, 117,   4,  91, 124, 116,
/* 2608 */ 119,   2,  33,  27,   2, 130, 117,   2,
/* 2616 */ 136, 117,   2, 138, 127,   3,  91, 124,
/* 2624 */ 136,   3,  91, 125, 130,   3,  91, 136,
/* 2632 */ 117,   2,  31,  29,   2, 131, 116,   2,
/* 2640 */   5,  91,   2,  91,  30,   2,  91,  37,
/* 2648 */   2,  91,  34,   4,  91,  23,  13,  34,
/* 2656 */   3,  91,  13,  34,   3,  91,   1,  34,
/* 2664 */   2,  91,  33,   2,  91,  19,   2,  18,
/* 2672 */  22,   2,  91,  28,   3,  18,  11,  35,
/* 2680 */   2,  18,  12,   1,  85,   1,  86,   1,
/* 2688 */  78,   5,   8,  32,  19,   3,  33,   2,
/* 2696 */  91,  85,   2,  91,  86,   2,  91,  88,
/* 2704 */   2,  91,  78,   2,  91,  90,   2,  91,
/* 2712 */  82,   2,  87,  91,   2,  91, 124,   2,
/* 2720 */  92, 124,   2,  91, 128,   2,  91, 130,
/* 2728 */   2,  91, 138,   1, 135,   1, 140
} ; 

const short EnsOuCh [] = {
/*   0 */     2,     3,     9,     1,    14,     2,    22,    27,
/*   8 */     2,    39,    46,     1,    58,     1,    64,     2,
/*  16 */    68,    74,     1,    81,     1,    88,     2,    81,
/*  24 */    94,     6,    64,    97,    81,   101,   105,   109,
/*  32 */     2,     1,    34,     1,     7,     2,    20,     1,
/*  40 */     4,  -117,  -119,  -121,  -123,     2,   125,    38,
/*  48 */     2,    20,   127,     2,     1,    37,     1,    34,
/*  56 */     2,     1,    35,     2,     1,    36,     1,   132,
/*  64 */     1,   139,     1,     1,     4,   146,   148,   152,
/*  72 */   158,     1,    19,     2,    34,   166,     4,    20,
/*  80 */   168,    20,   170,     6,    20,   173,    20,   175,
/*  88 */   178,   182,     2,   188,   192,     3,   158,   148,
/*  96 */   152,     1,   196,     1,   271,     1,    40,     2,
/* 104 */     8,     1,     1,   281,     2,   283,    20,     3,
/* 112 */   290,   292,   127,     2,   294,   300,     1,    20,
/* 120 */     3,   309,   283,   311,     1,   173,     1,   316,
/* 128 */     1,    17,     5,     1,    66,   309,     1,    67,
/* 136 */     2,     9,     1,     3,   281,   321,   168,     2,
/* 144 */   323,    40,     2,   328,   331,     1,   337,     1,
/* 152 */   341,     1,   348,     1,   321,     1,   283,     1,
/* 160 */   355,     1,   359,     2,     1,    90,     1,   361,
/* 168 */     1,   127,     1,   364,     3,   378,   381,   139,
/* 176 */     2,   283,   168,     1,  -384,     1,   378,    10,
/* 184 */   388,   391,   395,   399,   403,   406,   409,   414,
/* 192 */   417,   420,     1,   423,     8,   427,   430,   433,
/* 200 */   395,   435,   438,   441,   361,     1,   444,     1,
/* 208 */   433,     1,   450,     1,   456,     1,   458,     1,
/* 216 */   463,    10,   466,   470,   476,   479,   483,   487,
/* 224 */   492,   495,   499,   504,     5,   414,   507,   510,
/* 232 */   433,    40,     1,   513,     2,   517,   520,     1,
/* 240 */   524,     5,   528,   433,   517,   530,     0,     1,
/* 248 */   532,     1,   166,     1,   328,     3,   535,   414,
/* 256 */   538,     1,   542,     6,   438,   166,   546,   549,
/* 264 */   528,   554,     3,     1,   563,   568,     7,   573,
/* 272 */   395,   438,   576,   579,   433,   166,     1,   584,
/* 280 */     3,   589,   593,   598,     2,   602,   433,     1,
/* 288 */   604,     9,   528,   609,   612,   615,   476,   492,
/* 296 */   618,   622,   626,     3,     1,   630,   635,     2,
/* 304 */    91,   641,     1,   644,     1,   420,     2,     1,
/* 312 */    82,     7,   649,   653,   513,   658,   665,   669,
/* 320 */   433,     5,   674,   679,   683,   687,   690,     3,
/* 328 */    12,   283,    23,     3,   696,   699,   702,     1,
/* 336 */   707,     1,   417,     1,   710,     1,   713,     2,
/* 344 */   546,   716,     1,    41,     1,  -119,     1,    25,
/* 352 */     3,    25,   719,     0,     1,  -386,     3,   528,
/* 360 */   359,   721,     2,     1,    42,     9,   528,   359,
/* 368 */   602,   725,   414,   433,   728,     0,   456,     1,
/* 376 */  -137,     1,     0,     1,   168,     3,   127,   173,
/* 384 */   731,     2,   734,   737,     1,   740,     1,   745,
/* 392 */     2,   748,   751,     2,     0,    40,     2,   755,
/* 400 */   758,     1,   761,     1,   309,     2,     1,   769,
/* 408 */     2,   755,   772,     3,    16,   283,    23,     2,
/* 416 */     1,    44,     1,    43,     1,   776,     1,   781,
/* 424 */     5,   784,   787,   795,   800,   808,     1,   816,
/* 432 */     1,   784,     7,   818,   823,   828,   834,   839,
/* 440 */   843,   847,     1,   731,     1,   852,     1,   855,
/* 448 */     1,   858,     3,   855,   843,   420,     1,   861,
/* 456 */     5,   864,   868,   843,   871,   876,     2,   879,
/* 464 */   885,     1,   292,     1,   890,     2,   896,   901,
/* 472 */     1,     8,     1,   905,     2,   910,   914,     6,
/* 480 */    20,   316,    20,   920,   925,   928,     5,   933,
/* 488 */   937,   942,   946,   953,     4,   957,   963,   968,
/* 496 */   973,     6,   976,   979,   988,   271,   993,   997,
/* 504 */     1,  1002,     7,   328,  1005,  1011,  1018,   858,
/* 512 */  1024,  1029,     1,  1034,     2,    20,  1039,     3,
/* 520 */  1044,  1048,  1052,     4,    10,   283,    23,     1,
/* 528 */     3,  1056,  1061,   861,     2,   364,  1066,     4,
/* 536 */   378,     0,     1,     0,     2,     1,    45,     4,
/* 544 */  1070,  1075,  1079,  1084,     1,    46,     2,     1,
/* 552 */    47,     1,   769,     8,  1097,  1100,  1103,  1108,
/* 560 */  1111,  1115,   364,  1066,     1,  1122,     2,  1129,
/* 568 */  1134,     1,  1138,     3,     1,     1,     0,     2,
/* 576 */  1142,  1149,     1,    72,     1,  1155,     2,  1157,
/* 584 */    40,     1,  1162,     4,   858,  1165,  1168,   784,
/* 592 */     2,   337,   316,     1,  1172,     7,     5,   316,
/* 600 */  1177,   281,   609,     0,     5,     5,  1188,  1195,
/* 608 */  1198,  1202,  1208,     1,   528,     1,  1214,     9,
/* 616 */  1217,    40,  1217,     0,    20,  1217,     0,     5,
/* 624 */    20,     2,  1221,    20,    11,  1224,  1221,    13,
/* 632 */    13,  1227,     3,     4,     3,  1002,   311,  1229,
/* 640 */    10,     0,    20,     0,   341,    20,     0,   337,
/* 648 */    20,   748,    20,     1,  1232,     2,  1235,    40,
/* 656 */     1,  1239,     8,     3,     0,    20,     0,   341,
/* 664 */    20,   748,    20,     2,  1244,    40,     2,  1248,
/* 672 */    20,     6,    16,     0,    16,     1,   283,    23,
/* 680 */     2,  1251,  1255,     1,  1259,     2,     0,    23,
/* 688 */     1, -1263,     5,   528,   146,  1265,   433,  1267,
/* 696 */     2,  1272,  1276,     3,  1280,  1283,  1286,     1,
/* 704 */  1289,     2,   530,   359,     1,  1292,     1,   612,
/* 712 */    10,  1295,  1299,  1303,   530,  1306,  1232,   507,
/* 720 */  1283,  1308,    97,     2,     1,  1292,     1,  1280,
/* 728 */     1,  1311,     2,     1,    81,     1,  1315,     1,
/* 736 */   609,     1,   388,     1,  1329,     1,   546,     2,
/* 744 */   546,  1329,     3,  1335,  1339,    22,     1,   683,
/* 752 */     3,     1,  1289,  1346,     2,   528,     0,     2,
/* 760 */  1350,  1352,     2,  1354,  1359,     2,     1,    48,
/* 768 */     2,   -26,  1363,     5,  1367,   168,   283,    23,
/* 776 */    40,     1,  1369,     1,  1376,     1,  -705,     1,
/* 784 */  1383,     2,     1,    49,     6,  1389,  1393,  1397,
/* 792 */  1403,  1407,  1414,     2,   168,  1177,     2,  1422,
/* 800 */   731,     1,  1422,     2,    14,    21,     3,   290,
/* 808 */  1177,   748,     1,  1431,     4,   528,   359,   602,
/* 816 */   507,     4,     1,     1,    83,    84,     2,  1177,
/* 824 */   337,     3,     0,  1435,  1438,     2,  1443,   283,
/* 832 */     1,  1446,     2,     1,    50,     2,  1451,  1456,
/* 840 */     1,    14,     3,     1,     1,    68,     2,   528,
/* 848 */   433,     2,   602,  1472,     1,  1477,     7,  1482,
/* 856 */  1486,  1299,  1490,  1494,  1498,  1502,     4,  1506,
/* 864 */  1509,  1513,  1517,     2,  1526,  1530,     2,     0,
/* 872 */    20,     3,    20,    21,     0,     5,    22,   359,
/* 880 */    24,  1535,    23,     3,     0,     2,     1,     2,
/* 888 */     6,     5,     2,     0,     0,     4,     1,     0,
/* 896 */  1538,  1542,     1,  1195,     1,  1546,     1,   728,
/* 904 */     1,  1550,     2,  1553,  1557,     1, -1562,     1,
/* 912 */ -1564,     1,  -123,     1,  1569,     2,     1,    69,
/* 920 */     2,   359,    40,     2,    15,     1,     2,     1,
/* 928 */    65,     1,  1593,     6,  1600,  1603,  1607,  1610,
/* 936 */  1613,  1617,     4,   816,  1621,  1162,  1627,     6,
/* 944 */   609,   589,   593,   364,  1066,    40,     2,     0,
/* 952 */     5,     2,   341,    20,     2,    22,  1335,     2,
/* 960 */   175,    40,     2,  1640,  1645,     6,   271,   976,
/* 968 */  1653,  1659,  1664,  1669,     3,    22,   359,    24,
/* 976 */     6,   707,    40,   168,    40,   125,  1678,     2,
/* 984 */   292,    40,     3,     0,   602,   530,     3,   173,
/* 992 */   281,  1683,     2,  1686,  1689,     2,   316,    20,
/* 1000 */     2,   271,  1694,     5,   341,   281,   602,  1177,
/* 1008 */   337,     2,  1698,  1703,     1,  1707,     3,    40,
/* 1016 */  1711,  1715,     1,    85,     2,     1,    52,     3,
/* 1024 */   528,   433,  1535,     2,     1,    51,     1,  -376,
/* 1032 */     7,     1,  1726,  1730,  1734,  1740,  1745,  1749,
/* 1040 */     1,    11,     1,  1754,     6,  1764,  1768,  1772,
/* 1048 */  1776,  1780,  1784,     2,  1792,  1796,     2,   292,
/* 1056 */   281,     1,   530,    10,   430,  1801,  1806,  1810,
/* 1064 */  1814,  1818,  1822,  1826,  1830,  1834,     3,   328,
/* 1072 */   378,  1840,     3,   528,   615,  1845,     3,  1851,
/* 1080 */  1856,  1861,     1,  1866,     1, -1870,    10,   528,
/* 1088 */  1872,  1066,  1875,  1879,  1883,  1887,  1891,   609,
/* 1096 */   546,     1,  1894,     8,   528,   417,   728,   364,
/* 1104 */  1066,  1898,  1335,    64,     1,  1745,     2,   528,
/* 1112 */   166,     1,  1901,     7,  1905,   361,   699,   476,
/* 1120 */   507,  1908,  1911,     1,  1830,     5,   528,   433,
/* 1128 */   364,  1066,   579,     1,  1914,     7,   359,    40,
/* 1136 */  1922,    40,  1926,    40,  1930,     2,     1,    70,
/* 1144 */     1,    71,     2,  1934,  1938,     1,  1943,    14,
/* 1152 */  1947,  1952,  1957,  1961,   702,  1966,  1970,  1974,
/* 1160 */  1978,  1982,  1985,  1988,  1991,  1994,     1,  1997,
/* 1168 */     1,  2001,     2,  2005,  2009,     5,  2013,  2017,
/* 1176 */  2022,  2027,  2033,     1,  2041,     1,  2005,     1,
/* 1184 */   602,     1,  2045,     1,  2052,     4,  2056,  2060,
/* 1192 */  2064,  2068,     1,  2075,     1,  2079,     3,   855,
/* 1200 */  2082,  2087,     1,  2091,     2,  1329,   476,     1,
/* 1208 */  2095,     3,  2100,   388,  2103,     1,  2082,     8,
/* 1216 */  2107,  2111,  2115,  1280,   602,  2119,   127,  1911,
/* 1224 */     3,   427,  2124,  2128,     1,  2132,     3,  2137,
/* 1232 */  2142,  2148,    10,  2154,  2159,  2165,  2170,  2176,
/* 1240 */  2180,  2185,  2189,  2193,  2199,     3,     1,    56,
/* 1248 */   528,     3,     1,    57,  1306,     3,     1,    58,
/* 1256 */   602,     3,     1,    59,   433,     6,     1,    60,
/* 1264 */   456,     1,    61,   456,     2,     1,    62,     2,
/* 1272 */    53,   359,     2,  2205,  2209,     2,   290,    20,
/* 1280 */     1,  2213,     1,     2,     1,  2218,     2,     2,
/* 1288 */  2223,     2,  2228,  1329,     3,  2231,  2238,  2248,
/* 1296 */     4,   283,  1227,   168,  2253,     1,  2256,     3,
/* 1304 */     1,    73,   528,     4,     1,    74,   602,   388,
/* 1312 */     3,     1,    75,   433,     3,     1,    76,   456,
/* 1320 */     3,     1,    77,   316,     3,     1,    78,   292,
/* 1328 */     3,     1,    79,   321,     7,     1,    80,   359,
/* 1336 */   337,  2262,  1265,  2264,     5,   283,  1227,  2266,
/* 1344 */  2271,  2275,     3,  2279,  2284,    20,     4,  2289,
/* 1352 */    40,  2284,    20,     5,  2293,  2298,  2303,  2307,
/* 1360 */  2311,     1,  2316,     5,  2319,  2325,  2331,  2338,
/* 1368 */  2346,     2,  2316,    40,     2,  2358,   532,     1,
/* 1376 */  2362,     2,  1891,    40,     1,    86,     2,  2372,
/* 1384 */  2378,     2,   602,    22,     5,   361,  2382,  2385,
/* 1392 */  2393,  2397,     1,  2405,     3,  2409,  2414,  2420,
/* 1400 */     1,    87,     4,  2424,    40,  2428,    40,     2,
/* 1408 */     1,    88,     1,   517,     2,   361,  2382,     2,
/* 1416 */  2434,  2438,     1,   125,     2,     1,    89,     3,
/* 1424 */    18,     1,    54,     1,    55,     1,  -121,     7,
/* 1432 */   271,  2447,  2452,  2456,  2461,  2469,  2474,     1,
/* 1440 */  2481,     6,     0,   528,   530,   602,   456,   166,
/* 1448 */     3,  1607,  2487,  2491,     3,  2498,  2502,   734,
/* 1456 */     5,  2506,   973,  2512,   976,  2518,     2,  2524,
/* 1464 */  1155,     1,  2527,     4,    22,   699,    40,  2530,
/* 1472 */     2,  2001,    40,     1,  2533,     1,  2538,     2,
/* 1480 */   737,  1172,     1,  2541,     2,     1,   -31,     3,
/* 1488 */   602,   528,   433,     1,  2547,     1,  2550,     2,
/* 1496 */   290,    40,     1, -2553,     1,  1905,     1,  2017,
/* 1504 */     1,  2555,     2,  2559,  2565,     1,  2571,     1,
/* 1512 */  2576,     4,     1,  1730,  2583,  1745,     1,  2586,
/* 1520 */     2,  2595,   530,     3,  2600,  2555,  2604,     4,
/* 1528 */    63,     1,    64,     0,     5,   388,   781,  1303,
/* 1536 */  2612,  2615,     1,  2618,     2,   321,   290,     4,
/* 1544 */  2621,  2625,   784,   769,     2,   364,     1,     2,
/* 1552 */     0,     2,     3,     1,    21,     0,     2,     2,
/* 1560 */     5,     3,    22,   359,    23,     2,  2307,  2629,
/* 1568 */     2,  2636,   755,     1,  -117,     2,     1,    39,
/* 1576 */     1,   -26,     1,    31,     1,    26,     5,    31,
/* 1584 */    29,    26,  1870,    31,     2,    31,    31,     2,
/* 1592 */    31,    29,     3,     1,    31,     1,     1,  2642,
/* 1600 */     2,    31,    27,     1,  2645,     6,   123,    27,
/* 1608 */  1870,    26,   117,    26,     2,  2648,  2651,     2,
/* 1616 */   123,    27,     3,  2648,  2656,  2660,     2,   117,
/* 1624 */    26,     1,  2664,     4,   123,    26,  1870,    26,
/* 1632 */     1,  2667,     1,  2670,     1,    85,     2,   123,
/* 1640 */    26,     1,  2673,     2,  2676,  2680,     2,     1,
/* 1648 */    31,     2,    31,  1127,     2,    26,    31,     2,
/* 1656 */    30,  1441,     2,    31,    26,     2,   -26,   -31,
/* 1664 */     1,  1441,     1,   121,     1,   119,     3,  2683,
/* 1672 */  2685,  2687,    12,    31,   372,    31,    33,   372,
/* 1680 */    31,    29,   372,    31,    29,    33,   372,    12,
/* 1688 */    31,   263,    31,    33,   263,    31,    29,   263,
/* 1696 */    31,    29,    33,   263,     2,    32,    29,     1,
/* 1704 */    28,     2,     1,    31,     2,     1,  2687,    10,
/* 1712 */  -271, -2716, -2719, -2722, -2725,  -858, -1162,  -328,
/* 1720 */ -2728, -1435
} ;

const U8 FinCont [] = {
/*   0 */ 0x6B, 0x6A, 0xD5, 0xBF, 0x2B, 0x79, 0x65, 0x25,
/*   8 */ 0x57, 0xAC, 0xA5, 0xDB, 0xAA, 0xD2, 0xED, 0x75,
/*  16 */ 0x45, 0x6E, 0x5A, 0xAA, 0xA5, 0x57, 0x6A, 0xFF,
/*  24 */ 0xD7, 0xFA, 0xAA, 0xBF, 0xF7, 0x56, 0xBA, 0xAB,
/*  32 */ 0xAF, 0xDD, 0xFD, 0x76, 0xBF, 0xEE, 0xD4, 0xBF,
/*  40 */ 0xBE, 0xAE, 0xAA, 0xD5, 0x55, 0xCB, 0xFA, 0xAB,
/*  48 */ 0xB5, 0x6D, 0xAB, 0x6A, 0x55, 0x7D, 0x5F, 0xD5,
/*  56 */ 0x5D, 0x7D, 0xAB, 0x56, 0xBD, 0xF7, 0xBF, 0x5F,
/*  64 */ 0xD6, 0xEB, 0x76, 0x52, 0xF4, 0xAF, 0xF5, 0xAA,
/*  72 */ 0xD4, 0xAF, 0x6B, 0xEB, 0xEA, 0x48, 0x96, 0xD7,
/*  80 */ 0x24, 0xA9, 0x54, 0xA4, 0x95, 0x69, 0x5F, 0x6E,
/*  88 */ 0xB5, 0x7F, 0xE5, 0x4A, 0xAA, 0xDD, 0x72, 0xD9,
/*  96 */ 0x6D, 0xAA, 0x97, 0xED, 0xA5, 0xD7, 0xAD, 0xBB,
/* 104 */ 0x4B, 0x55, 0xB5, 0xFD, 0xEC, 0xAA, 0xA6, 0x49,
/* 112 */ 0xD5, 0x5A, 0xA9, 0x2C, 0xAF, 0xDE, 0xFC, 0x96,
/* 120 */ 0x5B, 0xF5, 0x2E, 0x5D, 0xD9, 0x6F, 0xB5, 0xD2,
/* 128 */ 0xE5, 0x7F, 0x57, 0xED, 0xAF, 0xFD, 0xDD, 0xD5,
/* 136 */ 0xFF, 0xAF, 0xF5, 0xAF, 0xEB, 0xE9, 0x59, 0x5A,
/* 144 */ 0xFF, 0xFD, 0x5B, 0xEA, 0xAB, 0xD5, 0xD6, 0xBA,
/* 152 */ 0xFF, 0x75, 0xDF, 0xF8, 0x88, 0x88, 0x92, 0xD9,
/* 160 */ 0x55, 0xB7, 0x7A, 0x23, 0x11, 0x11, 0x13, 0xF7,
/* 168 */ 0xD4, 0xAF, 0xAF, 0x96, 0x95, 0x97, 0xD7, 0x4A,
/* 176 */ 0x56, 0xD2, 0xAA, 0xFE, 0xBF, 0x77, 0x7D, 0xAB,
/* 184 */ 0x2A, 0xD6, 0xEA, 0x55, 0x5A, 0xBD, 0x6E, 0xB7,
/* 192 */ 0xD6, 0xF6, 0x54, 0xAB, 0x69, 0x54, 0x92, 0x4D,
/* 200 */ 0x29, 0x56, 0x5C, 0xA5, 0x54, 0xAC, 0x92, 0x49,
/* 208 */ 0x55, 0xC9, 0x22, 0x49, 0x12, 0xB6, 0xFF, 0xD8,
/* 216 */ 0x00
} ;

const U8 ClOuCh [] = {
/*   0 */ 0x00, 0x00, 0x00, 0x00, 0x2B, 0x01, 0x45, 0x24,
/*   8 */ 0x00, 0x29, 0x4A, 0x00, 0x02, 0x82, 0x01, 0x00,
/*  16 */ 0x49, 0x40, 0x40, 0x00, 0x04, 0x00, 0x00, 0x00,
/*  24 */ 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x02, 0x00,
/*  32 */ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x80,
/*  40 */ 0x00, 0xA0, 0x00, 0x11, 0x50, 0x08, 0x04, 0x20,
/*  48 */ 0x00, 0x0C, 0x00, 0x0A, 0x50, 0x00, 0x00, 0x00,
/*  56 */ 0x00, 0x00, 0x00, 0x40, 0xA0, 0x00, 0x00, 0x00,
/*  64 */ 0x04, 0x0A, 0x00, 0x52, 0x04, 0x80, 0x00, 0x02,
/*  72 */ 0x10, 0x80, 0x02, 0x18, 0x00, 0x5B, 0x91, 0xB8,
/*  80 */ 0x76, 0xA1, 0x1E, 0xA4, 0xB9, 0x03, 0x00, 0x00,
/*  88 */ 0x00, 0x00, 0x00, 0x08, 0x00, 0x04, 0x02, 0x01,
/*  96 */ 0x41, 0x80, 0x10, 0x00, 0x0C, 0x00, 0x0C, 0x20,
/* 104 */ 0x08, 0x44, 0x00, 0x00, 0x01, 0xBA, 0xAC, 0xD9,
/* 112 */ 0x00, 0x00, 0x01, 0x28, 0x80, 0x00, 0x05, 0x94,
/* 120 */ 0x40, 0x05, 0x28, 0x50, 0x01, 0x00, 0x01, 0x12,
/* 128 */ 0x04, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 136 */ 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x51, 0x40,
/* 144 */ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 152 */ 0x00, 0x00, 0x00, 0x01, 0x11, 0x11, 0x22, 0x81,
/* 160 */ 0x11, 0x00, 0x00, 0x44, 0x22, 0x22, 0x22, 0x00,
/* 168 */ 0x04, 0xA0, 0x00, 0x10, 0x14, 0x10, 0x00, 0x4A,
/* 176 */ 0x40, 0x02, 0xA8, 0x00, 0x20, 0x00, 0x00, 0x0A,
/* 184 */ 0x20, 0x02, 0x00, 0x40, 0x00, 0x00, 0x00, 0xB0,
/* 192 */ 0x00, 0x00, 0xCD, 0xA8, 0x01, 0x55, 0xD6, 0xC8,
/* 200 */ 0x61, 0x50, 0x40, 0x85, 0x00, 0x80, 0xA6, 0x9B,
/* 208 */ 0x00, 0x16, 0xDC, 0xB6, 0xE6, 0x90, 0x00, 0x10,
/* 216 */ 0x00
} ; 
