/*
 ***********************************************************************
 *
 *                           Coryright (c)
 *     Digital Equipment Corporation 1996, 1997. All rights reserved.
 *
 *    Restricted Rights: Use, duplication, or disclosure by the U.S.
 *    Government is subject to restrictions as set forth in subparagraph
 *    (c) (1) (ii) of DFARS 252.227-7013, or in FAR 52.227-19, or in FAR
 *    52.227-14 Alt. III, as applicable.
 *
 *    This software is proprietary to and embodies the confidential
 *    technology of Digital Equipment Corporation and other parties.
 *    Possession, use, or copying of this software and media is authorized
 *    only pursuant to a valid written license from Digital or an
 *    authorized sublicensor.
 *
 ***********************************************************************
 *    File Name:    lsw_main.c
 *    Author:       Matthew Schnee
 *    Creation Date:02/29/1996
 *
 *    Functionality:
 *    lts entry point stub, for window only
 *
 ***********************************************************************
 *    Revision History:                    
 *
 *  Rev Who     Date        	Description
 *  --- -----   ----------- 	---------------------------------------
 *  001 KM   	09/23/1984   	Modified to look for default user.dic
 *                              in the HOME directory for OSF/1.
 *  002 MGS     03/10/1996      Renamed file from lsm_acna.c
 *  003 JDB     05/30/1996      Add language dependent conditionals
 *  004 GL      11/26/1996      remove dummy msdos and dtex switch
 *  005 GL	12/11/1996	remove the WIN32 language pipe hack
 *  006 KSB     02/10/1997	Fixed bugs for DTDemo fetch, and added debug code
 *  007 NCS     02/21/1997      Merged Tom's multilanguage code in.
 *  008 NCS     02/26/1997      Changed LibMain to LTSLibMain.
 */

				 
#include "ls_def.h"

#ifdef SEPARATE_PROCESSES
struct share_data       *kernel_share;
#endif

/*
 * extern int namef;
 */
#ifdef WIN32

/* tek 23jan97 need the dictionary globals if we're doing the code_DLL thing */
#ifdef BLD_CORE_DLL
int gnInstanceCounter=0;
  int far                   *gpufdic          = NULL;
  S32                       gufdic_entries     = 0;

#endif /*BLD_CORE_DLL*/

#define  MAX_STRING_LENGTH  512

static void GetDictionaryNames( char *, char * );

// The following line is from TOM's multilang-code   ncs 3/7/97
extern void unload_dictionary( void **, unsigned int * );

extern MMRESULT load_dictionary( LPTTS_HANDLE_T,
				 void **,
				 unsigned int *,
				 char *,
				 BOOL,
				 BOOL );
										
int __stdcall lts_main( LPTTS_HANDLE_T phTTS )
/* Line below is commented out due to the line above */
// DllExport int __stdcall lts_main( LPTTS_HANDLE_T phTTS )

#else

#include "dtmmedefs.h"

extern MMRESULT load_dictionary( void **,
				 				unsigned int *,
				 				char *,
				 				int );
										


/* PROTOTYPES */
extern lsa_util_init_lang();
extern void default_lang ();

extern ls_task_main ();


int lts_main(LPTTS_HANDLE_T phTTS )

#endif
{
  
  /* 
   * Added a variable to get current instance kernel share data and
   * initialize from phTTS structure  :MI : MVP
   */
  PKSD_T pKsd_t = phTTS->pKernelShareData;
  PLTS_T pLts_t = NULL;

#ifdef SEPARATE_PROCESSES
	kernel_share = (struct share_data *)malloc(sizeof(struct share_data));
#endif
  
#ifdef WIN32

  char szMainDict[MAX_STRING_LENGTH];
  char szUserDict[MAX_STRING_LENGTH];
  int nDicLoad ;

  if((pLts_t = (PLTS_T)malloc(sizeof(LTS_T)))== NULL)
	return(MMSYSERR_NOMEM);
  
  /* MVP :Associate LTS thread specific data handle to the current speech object*/
  phTTS->pLTSThreadData = pLts_t ;
  

  GetDictionaryNames( szMainDict, szUserDict );

  /*
   * MVP : Load the main dictionary only once for all instances of DECtalk
   *		  Speech engine.
   */
  if(!gnInstanceCounter)
  {

#ifdef ENGLISH_US
		nDicLoad = load_dictionary( phTTS,
						&(pKsd_t->fdic),
						&(pKsd_t->fdic_entries),
						szMainDict,
						TRUE,
						TRUE );
#endif
#ifdef SPANISH
		nDicLoad = load_dictionary( phTTS,
						&(pKsd_t->sdic),
						&(pKsd_t->sdic_entries),
						szMainDict,
						TRUE,
						TRUE );
#endif
#ifdef GERMAN
		nDicLoad = load_dictionary( phTTS,
						&(pKsd_t->gdic),
						&(pKsd_t->gdic_entries),
						szMainDict,
						TRUE,
						TRUE );
#endif


		/*MVP : On the following errors notify TextToSpeechStartup by 
			returning the error.
		*/
		if(nDicLoad == MMSYSERR_INVALPARAM || nDicLoad == MMSYSERR_NOMEM ||
 			nDicLoad == MMSYSERR_ERROR)
		{
#ifdef DEBUG
			MessageBox(NULL,szMainDict,"Error loading dictionary", MB_ICONSTOP | MB_OK);
#endif
			return (nDicLoad);
		}
		gnInstanceCounter++;
#ifdef ENGLISH_US		
		gpufdic = pKsd_t->fdic;
		gufdic_entries = pKsd_t->fdic_entries;
#endif
#ifdef SPANISH
		gpufdic = pKsd_t->sdic;
		gufdic_entries = pKsd_t->sdic_entries;

#endif
#ifdef GERMAN
		gpufdic = pKsd_t->gdic;
		gufdic_entries = pKsd_t->gdic_entries;

#endif

  }
  else
  {
#ifdef ENGLISH_US
		pKsd_t->fdic = gpufdic;
		pKsd_t->fdic_entries = gufdic_entries;
#endif
#ifdef SPANISH
		pKsd_t->sdic = gpufdic;
		pKsd_t->sdic_entries = gufdic_entries;
#endif
#ifdef GERMAN
		pKsd_t->gdic = gpufdic;
		pKsd_t->gdic_entries = gufdic_entries;

#endif


  }

#ifdef ENGLISH_US  
  nDicLoad = load_dictionary( phTTS,
				  &(pKsd_t->udic),
				  &(pKsd_t->udic_entries),
				  szUserDict,
				  FALSE,
				  TRUE );
#endif
#ifdef SPANISH
nDicLoad = load_dictionary( phTTS,
				  &(pKsd_t->usdic),
				  &(pKsd_t->usdic_entries),
				  szUserDict,
				  FALSE,
				  TRUE );
#endif
#ifdef GERMAN
nDicLoad = load_dictionary( phTTS,
				  &(pKsd_t->ugdic),
				  &(pKsd_t->ugdic_entries),
				  szUserDict,
				  FALSE,
				  TRUE );
#endif



 /*MVP : On the following errors notify TextToSpeechStartup 
		  by returning the error.
  */
  if(nDicLoad == MMSYSERR_INVALPARAM || nDicLoad == MMSYSERR_NOMEM ||
		nDicLoad == MMSYSERR_ERROR)
  {
	  return(nDicLoad);
  }
  
  SetEvent(phTTS->hMallocSuccessEvent);  /*MVP :Set the malloc success,load dictionary success event */
  
 #else /* #ifdef WIN32 */

  char    homedir[258];
  char    filename[275];

#ifdef ENGLISH_US
  if( load_dictionary( &(pKsd_t->fdic),
		   &(pKsd_t->fdic_entries),
		   "/usr/lib/dtk/dectalk.dic",
		   TRUE ) != MMSYSERR_NOERROR )
  {
	  fprintf(stderr,"DECtalk cannot run without the dictionary file %s\n",
				  "/usr/lib/dtk/dectalk.dic");
	  exit( 0 );
  }
#endif
#ifdef SPANISH
  if( load_dictionary( &(pKsd_t->sdic),
		   &(pKsd_t->sdic_entries),
		   "/usr/lib/dtk/dectalk_sp.dic",
		   TRUE ) != MMSYSERR_NOERROR )
  {
	  fprintf(stderr,"DECtalk cannot run without the dictionary file %s\n",
				  "/usr/lib/dtk/dectalk_sp.dic");
	  exit( 0 );
  }
#endif
#ifdef GERMAN
  if( load_dictionary( &(pKsd_t->gdic),
		   &(pKsd_t->gdic_entries),
		   "/usr/lib/dtk/dectalk_gr.dic",
		   TRUE ) != MMSYSERR_NOERROR )
  {
	  fprintf(stderr,"DECtalk kann nicht ohne die Bibliothekdatei %s laufen\n",
				  "/usr/lib/dtk/dectalk_sp.dic");
	  exit( 0 );
  }
#endif
#ifdef FRENCH
  if( load_dictionary( &(pKsd_t->frdic),
		   &(pKsd_t->frdic_entries),
		   "/usr/lib/dtk/dectalk_fr.dic",
		   TRUE ) != MMSYSERR_NOERROR )
  {
	  fprintf(stderr,"DECtalk cannot run without the dictionary file %s\n",
				  "/usr/lib/dtk/dectalk_sp.dic");
	  exit( 0 );
  }
#endif


  /*
   * Look for an ini file in the users login directory
   */
  strcpy(homedir,getenv("HOME"));
  sprintf(filename, "%s/user.dic", homedir);

#ifdef ENGLISH_US
  load_dictionary( &(pKsd_t->udic),
		   &(pKsd_t->udic_entries),
		   filename,
		   FALSE );
#endif
#ifdef SPANISH
  load_dictionary( &(pKsd_t->usdic),
		   &(pKsd_t->usdic_entries),
		   filename,
		   FALSE );
#endif
#ifdef GERMAN
  load_dictionary( &(pKsd_t->ugdic),
		   &(pKsd_t->ugdic_entries),
		   filename,
		   FALSE );
#endif

#endif /* #ifdef WIN32 */


ls_util_lts_init (pLts_t, pKsd_t); 


/* JDB: language dependent... */
#ifdef ENGLISH_US
#ifdef ACNA
  	lsa_util_init_lang();
#endif
	default_lang(pKsd_t,LANG_english,LANG_lts_ready);  
#endif

#ifdef SPANISH
    default_lang(pKsd_t,LANG_spanish,LANG_lts_ready);
#endif

#ifdef GERMAN
   default_lang(pKsd_t,LANG_german,LANG_lts_ready);
#endif

#ifdef FRENCH
   default_lang(pKsd_t,LANG_french,LANG_lts_ready);
#endif
	
	ls_task_main(phTTS);
	/* Free here thread specific data structure MVP */
	if(pLts_t)
		free(pLts_t);
	phTTS->pLTSThreadData = pLts_t = NULL;
}       

/*extern int fc_index; */    /*MVP MI */

#ifdef WIN32

/**********************************************************************/
/*                                                                    */
/*  Function: GetDictionaryNames                                      */
/*  Author: Bill Hallahan                                             */
/*  Date: October 5, 1994                                             */
/*                                                                    */
/*                                                                    */
/*  Abstract:                                                         */
/*                                                                    */
/*         This function gets the main dictionary name and user       */
/*    dictionary name from the registry.                              */
/*                                                                    */
/*                                                                    */
/*  Input:                                                            */
/*                                                                    */
/*    szMainDict     A pointer to a string that will contain the      */
/*                   name provided during installation.               */
/*                   The returned value will be NULL terminated.      */
/*                                                                    */
/*    szUserDict     A pointer to a string that will contain the      */
/*                   company name provided during installation.       */
/*                   The returned value will be NULL terminated.      */
/*                                                                    */
/*                                                                    */
/*  Output:                                                           */
/*                                                                    */
/*    None.                                                           */
/*                                                                    */
/**********************************************************************/
/**********************************************************************/

LPSTR szLocalMachineDECtalk =
  "SOFTWARE\\DigitalEquipmentCorporation\\DECtalk\\4.40";

LPSTR szCurrentUsersDECtalk =
  "Software\\DigitalEquipmentCorporation\\DECtalkv4.40";

/* dictionary name area.  GL 12/12/1996 */
/* use the next block of code for final installation code */
LPSTR szMainDictDef = "DECTALK.DIC";
LPSTR szUserDictDef = "USER.DIC"; 

#if 0
#ifdef ENGLISH_US
LPSTR szMainDictDef = "DECTALK.DIC";
LPSTR szUserDictDef = "USER.DIC"; 
#endif
#ifdef SPANISH
LPSTR szMainDictDef = "DECTALK_SP.DIC";
LPSTR szUserDictDef = "USER.DIC"; 
#endif
#ifdef GERMAN
LPSTR szMainDictDef = "DECTALK_GR.DIC";
LPSTR szUserDictDef = "USER.DIC"; 
#endif
#ifdef FRENCH
LPSTR szMainDictDef = "DECTALK_FR.DIC";
LPSTR szUserDictDef = "USER.DIC"; 
#endif
#endif
/*
 *      Function Name: GetDictionaryNames()      
 *
 *  	Description: This function gets the main dictionary name and user       
 *    				 dictionary name from the registry.                              
 *                                                                    
 *                                                                    
 *  				 Input:                                                            
 *                                                                    
 *    				 szMainDict     
 *                   A pointer to a string that will contain the      
 *                   name provided during installation.              
 *                   The returned value will be NULL terminated.     
 *                                                                   
 *    				 szUserDict     
 *					 A pointer to a string that will contain the     
 *                   company name provided during installation.     
 *                   The returned value will be NULL terminated.     
 *
 *
 *      Arguments: 	char * szMainDict,
 *					char * szUserDict
 *
 *      Return Value: void 
 *
 *      Comments:
 *
 */
static void GetDictionaryNames( char * szMainDict,
				char * szUserDict )
{
  HKEY hKey;
  DWORD dwType;
  DWORD cbData;

#ifdef DEMO
  LPTSTR cmd_line = GetCommandLine();
  char new_cmd_line[512];
  char temp[20];
  int cmd_ptr = 0;

  while (cmd_line[cmd_ptr] != '\0' && cmd_line[cmd_ptr] != ' ')	cmd_ptr++;
  while (cmd_line[cmd_ptr] != '\\' && cmd_ptr != 0)				cmd_ptr--;
  if (cmd_ptr != 0)	cmd_ptr++;
  cmd_line[cmd_ptr] = '\0';
  
  sprintf(szUserDict,"%s%s",cmd_line,"user.dic");
#ifdef ENGLISH_US
	strcpy(temp,"dtalk_en.dic");
#endif
#ifdef SPANISH
	strcpy(temp,"dtalk_sp.dic");
#endif
#ifdef GERMAN
	strcpy(temp,"dtalk_gr.dic");
#endif
	if (cmd_line[0] == '"')	strcpy(new_cmd_line,cmd_line+1);	// Win95 addes a " to the beginning
	else					strcpy(new_cmd_line,cmd_line);
	sprintf(szMainDict, "%s%s", new_cmd_line, temp);
	return;
#endif


  /********************************************************************/
  /*  Get the user dictionary.                                        */
  /********************************************************************/

  if ( RegOpenKeyEx( HKEY_CURRENT_USER,
			 szCurrentUsersDECtalk,
			 0,
			 KEY_QUERY_VALUE,
			 &hKey ) != ERROR_SUCCESS )
  {
	strcpy( szUserDict, szUserDictDef );
  }
  else
  {
	cbData = MAX_STRING_LENGTH;

	if ( RegQueryValueEx( hKey,
			  "UserDict",
			  NULL,
			  &dwType,
			  (LPBYTE)szUserDict,
			  &cbData ) != ERROR_SUCCESS )
	{
	  strcpy( szUserDict, szUserDictDef );
	}

	RegCloseKey( hKey );
  }


  /********************************************************************/
  /*  Get the main dictionary.                                        */
  /********************************************************************/
  if(!gnInstanceCounter)
  {
		if ( RegOpenKeyEx( HKEY_LOCAL_MACHINE,
				 szLocalMachineDECtalk,
				 0,
				KEY_QUERY_VALUE,
				&hKey ) != ERROR_SUCCESS )
		{
			strcpy( szMainDict, szMainDictDef );
		}
		else
		{
			cbData = MAX_STRING_LENGTH;

			if ( RegQueryValueEx( hKey,
					"MainDict",
					NULL,
					&dwType,
					(LPBYTE)szMainDict,
					&cbData ) != ERROR_SUCCESS )
			{
				strcpy( szMainDict, szMainDictDef );
			}

			RegCloseKey( hKey );
		}
  }

}
#endif

BOOL WINAPI _CRT_INIT( HINSTANCE hinstDLL, DWORD fdwReason, 
	LPVOID lpReserved );

/* tek 23jan97 add the entrypoint function and use it to load/unload dictionaries. */
/* changed name from the request of Kevinb. ncs 26feb97 */
/**********************************************************************/
/**********************************************************************/
/*                                                                    */
/*  Function: LTSLibMain                                              */
/*                                                                    */
/*  Abstract:                                                         */
/*                                                                    */
/*         LTSLibMain is called by Windows when the dectalk DLL is    */
/*    initialized, Thread Attached, and other times. Since no DLL     */
/*    initialization is required, LTSLibMain return a value of 1      */
/*    indicating success.                                             */
/*                                                                    */
/**********************************************************************/
/**********************************************************************/

int LTSLibMain( HANDLE hInst,
			  DWORD ul_reason_being_called,
			  LPVOID lpReserved )
{


	// Initialize the C run-time before calling any of your code.
	if( ul_reason_being_called == DLL_PROCESS_ATTACH ||
		ul_reason_being_called == DLL_THREAD_ATTACH )
	{
#if 0 // This section of code breaks durning build. ie. This won't compile.
      // Could the BOOL line above the LibMain function also be a problem?
		if( !_CRT_INIT( hInst, ul_reason_being_called, lpReserved ) )
			return( FALSE );
#endif // Broken code.
	}

	switch(ul_reason_being_called)
	{
		/*
		 * DLL is attaching to a process.It could be
		 * while process getting loaded (The process 
		 * might have used load-time dynamic linking i.e
		 * built using dectalk.lib import library)
		 * OR   
		 * Process made a call to LoadLibrary(dectalk.dll)
		 */
	case DLL_PROCESS_ATTACH :
	  /*
	  /* does licensing happen here? tek 23jan97 */

	break;

	case DLL_THREAD_ATTACH:
		break;
	case DLL_THREAD_DETACH:
		break;
	case DLL_PROCESS_DETACH :
		/* drop the reference count.. */
		gnInstanceCounter--;
		if (gnInstanceCounter == 0)
		{
			/* unload dictionaries.. */
			if ( gufdic_entries != 0 )
			{
				unload_dictionary((void **)&(gpufdic),
				(unsigned int *)&(gufdic_entries));
				gpufdic = NULL;
				gufdic_entries = 0;
			}
		   /* WARNING WARNING we can't unload user dics here, because we */
		   /* can't see the pksd_t.. so the caller nees to deal with that! */
		   /*if ( pKsd_t->udic_entries != 0 )
			  {
				unload_dictionary((void **)&pKsd_t->udic,
						  (unsigned int *)&pKsd_t->udic_entries );
			  }
		   */
		}

//#ifdef LICENSES
//              ReleaseLicenseRef();
//#endif
		break;
	}

	return(TRUE);
//  return( 1 );
//  UNREFERENCED_PARAMETER( hInst );
//  UNREFERENCED_PARAMETER( ul_reason_being_called );
//  UNREFERENCED_PARAMETER( lpReserved );
}
