/*
 ***********************************************************************
 *                                                                      
 *                           Coryright (c)                              
 *     Digital Equipment Corporation 1996, 1997. All rights reserved.        
 *                                                                      
 *    Restricted Rights: Use, duplication, or disclosure by the U.S.    
 *    Government is subject to restrictions as set forth in subparagraph
 *    (c) (1) (ii) of DFARS 252.227-7013, or in FAR 52.227-19, or in FAR
 *    52.227-14 Alt. III, as applicable.                                
 *                                                                      
 *    This software is proprietary to and embodies the confidential     
 *    technology of Digital Equipment Corporation and other parties.    
 *    Possession, use, or copying of this software and media is authorized
 *    only pursuant to a valid written license from Digital or an        
 *    authorized sublicensor.                                            
 *                                                                       
 *********************************************************************** 
 *    File Name:    ls_suff.c
 *    Author:       Matthew Schnee                                         
 *    Creation Date:02/06/96                                                   
 *                                                                             
 *    Functionality:                                                           
 *    ls_suff_suffix_find(pLts_t,) is used to attempt a suffix strip from a word that
 *    hasn't been found in the dictionary ..
 *                                                                             
 ***********************************************************************       
 *                                                                             
 * Rev	Who		Date			Description                    
 * ---	-----	-----------		---------------------------------------
 * 001	MGS		02/27/1996 		Reformatted code and added function headers    
 * 002	MGS		03/18/1996		Added LSSUFFDEBUG tag
 * 003  MGS		03/18/1996		Finished WIN32 code merge, function headers need updating
 * 
 */

#if defined (ENGLISH_US) || defined (GERMAN)

#include "ls_def.h"
	
/* #define LSSUFFDEBUG */

void ls_suff_append_pron(LPTTS_HANDLE_T phTTS,unsigned char __far *pb);
extern unsigned char suffix_table[];
extern U16 suffix_index[];

/*
 *  tokens used in the parse table (must match the suffix dictionary
 *  compiler ...
 */

#define SF_END                  0xff  /* End of rule */
#define SF_STRIP                0xfe  /* Strip type  - */
#define SF_FC                   0xfd  /* Form class tag only  + */
#define SF_REPLACE              0xfc  /* Start of replacement rule / */
#define SF_REPLACE_WITH         0xfb  /* Substitute on replacement rule : */
#define SF_REPLACE_END 			0xfa  /* End of substitute rule */
#define SF_RECURSE              0xf9  /* Retry rules again # */ 
#define SF_PHONES               0xf8  /* Start of phonemene field  % */
#define SF_PHONES_END           0xf7  /* End of phonemene field */    

/*
 *      Function Name:
 *              ls_suff_suffix_find     
 *
 *      Description:           
 *              This function looks for suffixes
 *
 *      Arguments:                          
 *              unsigned char __far *str_end    The string to match
 *              short which_dic                 The dictionary to search through
 *
 *      Return Value:                                                       
 *              HIT             The word was found in the dictionary
 *              MISS    The wourd was not fouind inthe dictionary
 *
 *      Comments:
 *
 */
int ls_suff_suffix_find(LPTTS_HANDLE_T phTTS,unsigned char      __far *str_end,short which_dic)
{
	unsigned char   _far *bp;                       /* base text string seach */
	unsigned char   _far *sp;                       /* suffix string seach */
	unsigned char   _far *np;                       /* replacement string save */
	unsigned char   _far *sbp;                      /* saved base pointer to recurse */
	U16     i,stat=0;
	U16		si;

	struct  suff_rule       *stp;
	unsigned char   save_str[128];
	PLTS_T  pLts_t;
	PKSD_T  pKsd_t;
	pKsd_t = phTTS->pKernelShareData;

	pLts_t = phTTS->pLTSThreadData;
	
	#ifdef LSSUFFDEBUG
		printf("ls_suff_suffix_find; comp_str = %s str_end = %s\n",pLts_t->comp_str,str_end);
	#endif

	if(IS_LOWER_ALPHA(ls_lower[*str_end]) == false)
		si = suffix_index[26];
	else
		si = suffix_index[ls_lower[*str_end] - 'a'];
	#ifdef LSSUFFDEBUG
		printf("suffix_find si = %04X\n",si); 
	#endif

	while(si != 0xffff)
	{
		stp = (struct suff_rule *)&suffix_table[si];
		bp = str_end;
		sp = &stp->rule[0];
		while(*sp != SF_STRIP && *sp != SF_FC)
		{
			if(ls_lower[*bp] != *sp || bp == pLts_t->str_vowel)
				break;
			bp--;
			sp++;
		}

		/*
		 *  for form class hits, just set the fc field ...
		 */
		
		if(which_dic && (*sp == SF_FC))
		{
			pLts_t->fc_struct[pLts_t->fc_index] = stp->fc;
			return(MISS);
		}
		/*
		 *  if the suffix can be stripped, look for a striping rule starting
		 *  with / and see if it can be applied ...
		 */
		if(*sp++ == SF_STRIP)
		{
			for(i=0;save_str[i] = pLts_t->comp_str[i];i++);
			sbp = bp;

			while(*sp != SF_END)
			{
				if(*sp++ == SF_REPLACE)
				{
					while(*sp == ls_lower[*bp])
					{
						sp++;
						bp--;
					}
					if(*sp++ == SF_REPLACE_WITH)
					{
						np = bp+1;
						while(*sp != SF_REPLACE_END)
						{
							*np++ = *sp++;
						}
						*np++ = 0;
						sp++;
						if(*sp == SF_RECURSE)
						{
							sp++;
							#ifdef LSSUFFDEBUG
								printf("suffix_find recursion bp = %s np = %s save_str = %s\n",bp,np,save_str);
							#endif
							stat = ls_suff_suffix_find(phTTS,np-1,which_dic);
							#ifdef LSSUFFDEBUG
								printf("out of recursion\n");
							#endif
						}
						else
						{
							pLts_t->fc_struct[pLts_t->fc_index] = stp->fc;
							if(pKsd_t->udic_entries != 0)
							{
								stat=ls_dict_ufind_word(phTTS);
							}

							if(DICT_ENTRY !=0 && stat != HIT)
							{
								stat = ls_dict_find_word(phTTS);
							}
						}
						if(stat == HIT)
						{
							/* debug switch */
							if (DT_DBG(LTS_DBG,0x004))
							{
                                                                printf("\nHITS(%s)",pLts_t->comp_str);
							}
							ls_suff_append_pron(phTTS,sp);
							return(HIT);
						}
						else 
						{
							pLts_t->fc_struct[pLts_t->fc_index] = 0;
						}
						for(i=0;pLts_t->comp_str[i] = save_str[i];i++);
					} /* if(*sp++ == SF_REPLACE_WITH) */
					bp = sbp;
				} /* if(*sp++ == SF_REPLACE) */
			} /* while(*sp != SF_END) */
		} /* if(*sp++ == SF_STRIP) */
		si = stp->next;
		#ifdef LSSUFFDEBUG
			printf("suffix_find new si = %04X\n",si); 
		#endif
	}/*     while(si != 0xffff)*/
	return(MISS);
}

/*
 *      Function Name:                                       
 *              ls_suff_append_pron
 *
 *      Description:           
 *              
 *
 *      Arguments: LPTTS_HANDLE_T phTTS,unsigned char __far *pb
 *
 *      Return Value: void
 *
 *      Comments:
 *
 */
void ls_suff_append_pron(LPTTS_HANDLE_T phTTS,unsigned char __far *pb)
{
	PLTS_T  pLts_t;

	pLts_t = phTTS->pLTSThreadData;

	while(*pb != SF_END)
	{
		if(*pb++ == SF_PHONES)
	    {   
		if((*pb++ & pfeat[pLts_t->lphone]) == *pb++)
		{
			while(*pb != SF_PHONES_END)
					ls_util_send_phone(phTTS,*pb++);
			break;
		}
		}
	}
}

char *form_class_strings[] = {
	" adj",
	" adv",
	" art",
	" aux",
	" be",
	" bev",
	" conj",
	" ed",
	" have",
	" ing",
	" noun",
	" pos",
	" prep",
	" pron",
	" subj",
	" that",
	" to",
	" verb",
	" who",
	" neg",
	" intr",
	" ref",
	" part",
	" func",
	" conj",
	" char",
	" refr",
	" unused",
	" unused",
	" mark",
	" cont",
	" homo",
};
/*
 *      Function Name:  
 *              ls_suff_printf_fc
 *
 *      Description:
 *
 *      Arguments: LPTTS_HANDLE_T phTTS
 *
 *      Return Value: void
 *
 *      Comments:
 *
 */
#ifdef MSDOS
void ls_suff_print_fc(LPTTS_HANDLE_T phTTS)
{
	int     i,j;
	S32    fc_mask;
	PLTS_T pLts_t;
	pLts_t= phTTS->pLTSThreadData;

	WAIT_PRINT;
	printf("\n[:form");
	for(j=1;j<=pLts_t->fc_index;j++)
	{
		if(pLts_t->fc_struct[j])
		{
			printf("\n  %d :",j);
			fc_mask = 1;
			for(i=0;i<32;i++)
			{
				if(pLts_t->fc_struct[j] & fc_mask)
					printf("%s fc ",form_class_strings[i]);
				fc_mask = fc_mask*2;
			}
		}
		else
		{
			printf("\n  %d : unknown. \n",j);
		}
	}
	printf("]\n");
	SIGNAL_PRINT;
}
            
            
#else

#ifdef WIN32
#include <windows.h>
#include <mmsystem.h>
#endif

#ifdef __osf__
#include "dtmmedefs.h"
#endif

#include "tts.h"

/* ??? from ginger's code merge
   thought I leave it in here -- ncs 3/7/97
#ifndef LDS_BUILD
#include "ttsapi.c"
#endif
*/

/*LPTTS_HANDLE_T TextToSpeechGetHandle(void);*/

#ifndef LDS_BUILD
void TextToSpeechErrorHandler( LPTTS_HANDLE_T, UINT, MMRESULT );
#endif
 
/*
 *      Function Name: ls_suff_print_fc()      
 *
 *  	Description: 
 *
 *      Arguments: LPTTS_HANDLE_T phTTS
 *
 *      Return Value: void
 *
 *      Comments:
 *
 */
void ls_suff_print_fc(LPTTS_HANDLE_T phTTS)
{
  int i,j;
  S32 fc_mask;
  PLTS_T pLts_t = phTTS->pLTSThreadData;

#ifdef WIN32
  EnterCriticalSection( phTTS->pcsLogFile );
#endif
#ifdef __osf__
  ToggleLogfileMutex( MUTEX_RESERVE );
#endif

  if ( fprintf( phTTS->pLogFile, "\n[:form") < 0 )
  {
#ifndef LDS_BUILD
    TextToSpeechErrorHandler( phTTS,
			      ERROR_WRITING_FILE,
			      0L );
#endif
  }

  for( j = 1; j <= pLts_t->fc_index; j++ )
  {
    if( pLts_t->fc_struct[j] )
    {
      fc_mask = 1;

      for( i = 0; i < 32; i++ )
      {
	if( pLts_t->fc_struct[j] & fc_mask )
	{
	  if ( fprintf( phTTS->pLogFile, "%s fc ",form_class_strings[i] ) < 0 )
	  {
#ifndef LDS_BUILD
	    TextToSpeechErrorHandler( phTTS,
				      ERROR_WRITING_FILE,
				      0L );
#endif
	  }
	}
	fc_mask = fc_mask << 1;
      }
    }
    else
    {
      if ( fprintf( phTTS->pLogFile, "\n  %d : unknown. \n",j) < 0 )
      {
#ifndef LDS_BUILD
	TextToSpeechErrorHandler( phTTS,
				  ERROR_WRITING_FILE,
				  0L );
#endif
      }
    }
  }

  if ( fprintf( phTTS->pLogFile, "]\n") < 0 )
  {
#ifndef LDS_BUILD
    TextToSpeechErrorHandler( phTTS,
			      ERROR_WRITING_FILE,
			      0L );
#endif
  }

#ifdef WIN32
  LeaveCriticalSection( phTTS->pcsLogFile );
#endif
#ifdef __osf__
  ToggleLogfileMutex( MUTEX_RELEASE );
#endif

}
#endif          
#endif
